/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.photonmap;

import java.util.ArrayList;
import org.sunflow.core.CausticPhotonMapInterface;
import org.sunflow.core.LightSample;
import org.sunflow.core.Options;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;

public final class CausticPhotonMap
implements CausticPhotonMapInterface {
    private ArrayList<Photon> photonList;
    private Photon[] photons;
    private int storedPhotons;
    private int halfStoredPhotons;
    private int log2n;
    private int gatherNum;
    private float gatherRadius;
    private BoundingBox bounds;
    private float filterValue;
    private float maxPower;
    private float maxRadius;
    private int numEmit;

    public void prepare(Options options, BoundingBox boundingBox) {
        this.numEmit = options.getInt("caustics.emit", 10000);
        this.gatherNum = options.getInt("caustics.gather", 50);
        this.gatherRadius = options.getFloat("caustics.radius", 0.5f);
        this.filterValue = options.getFloat("caustics.filter", 1.1f);
        this.bounds = new BoundingBox();
        this.maxPower = 0.0f;
        this.maxRadius = 0.0f;
        this.photonList = new ArrayList();
        this.photonList.add(null);
        this.photons = null;
        this.halfStoredPhotons = 0;
        this.storedPhotons = 0;
    }

    private void locatePhotons(NearestPhotons nearestPhotons) {
        float[] fArray = new float[this.log2n];
        int[] nArray = new int[this.log2n];
        int n = 1;
        int n2 = 0;
        while (true) {
            int n3;
            if (n < this.halfStoredPhotons) {
                float f = this.photons[n].getDist1(nearestPhotons.px, nearestPhotons.py, nearestPhotons.pz);
                fArray[n2] = f * f;
                n += n;
                if (f > 0.0f) {
                    // empty if block
                }
                nArray[n2++] = ++n;
                continue;
            }
            nearestPhotons.checkAddNearest(this.photons[n]);
            do {
                n3 = n;
                --n2;
                if ((n >>= 1) != 0) continue;
                return;
            } while (fArray[n2] >= nearestPhotons.dist2[0] || n3 != nArray[n2]);
            nearestPhotons.checkAddNearest(this.photons[n]);
            n = nArray[n2++] ^ 1;
        }
    }

    private void balance() {
        if (this.storedPhotons == 0) {
            return;
        }
        this.photons = this.photonList.toArray(new Photon[this.photonList.size()]);
        this.photonList = null;
        Photon[] photonArray = new Photon[this.storedPhotons + 1];
        this.balanceSegment(photonArray, 1, 1, this.storedPhotons);
        this.photons = photonArray;
        this.halfStoredPhotons = this.storedPhotons / 2;
        this.log2n = (int)Math.ceil(Math.log(this.storedPhotons) / Math.log(2.0));
    }

    private void balanceSegment(Photon[] photonArray, int n, int n2, int n3) {
        int n4 = 1;
        while (4 * n4 <= n3 - n2 + 1) {
            n4 += n4;
        }
        if (3 * n4 <= n3 - n2 + 1) {
            n4 += n4;
            n4 += n2 - 1;
        } else {
            n4 = n3 - n4 + 1;
        }
        int n5 = 2;
        Vector3 vector3 = this.bounds.getExtents();
        if (vector3.x > vector3.y && vector3.x > vector3.z) {
            n5 = 0;
        } else if (vector3.y > vector3.z) {
            n5 = 1;
        }
        int n6 = n2;
        int n7 = n3;
        while (n7 > n6) {
            double d = this.photons[n7].getCoord(n5);
            int n8 = n6 - 1;
            int n9 = n7;
            while (true) {
                if ((double)this.photons[++n8].getCoord(n5) < d) {
                    continue;
                }
                while ((double)this.photons[--n9].getCoord(n5) > d && n9 > n6) {
                }
                if (n8 >= n9) break;
                this.swap(n8, n9);
            }
            this.swap(n8, n7);
            if (n8 >= n4) {
                n7 = n8 - 1;
            }
            if (n8 > n4) continue;
            n6 = n8 + 1;
        }
        photonArray[n] = this.photons[n4];
        photonArray[n].setSplitAxis(n5);
        if (n4 > n2) {
            if (n2 < n4 - 1) {
                switch (n5) {
                    case 0: {
                        float f = this.bounds.getMaximum().x;
                        this.bounds.getMaximum().x = photonArray[n].x;
                        this.balanceSegment(photonArray, 2 * n, n2, n4 - 1);
                        this.bounds.getMaximum().x = f;
                        break;
                    }
                    case 1: {
                        float f = this.bounds.getMaximum().y;
                        this.bounds.getMaximum().y = photonArray[n].y;
                        this.balanceSegment(photonArray, 2 * n, n2, n4 - 1);
                        this.bounds.getMaximum().y = f;
                        break;
                    }
                    default: {
                        float f = this.bounds.getMaximum().z;
                        this.bounds.getMaximum().z = photonArray[n].z;
                        this.balanceSegment(photonArray, 2 * n, n2, n4 - 1);
                        this.bounds.getMaximum().z = f;
                        break;
                    }
                }
            } else {
                photonArray[2 * n] = this.photons[n2];
            }
        }
        if (n4 < n3) {
            if (n4 + 1 < n3) {
                switch (n5) {
                    case 0: {
                        float f = this.bounds.getMinimum().x;
                        this.bounds.getMinimum().x = photonArray[n].x;
                        this.balanceSegment(photonArray, 2 * n + 1, n4 + 1, n3);
                        this.bounds.getMinimum().x = f;
                        break;
                    }
                    case 1: {
                        float f = this.bounds.getMinimum().y;
                        this.bounds.getMinimum().y = photonArray[n].y;
                        this.balanceSegment(photonArray, 2 * n + 1, n4 + 1, n3);
                        this.bounds.getMinimum().y = f;
                        break;
                    }
                    default: {
                        float f = this.bounds.getMinimum().z;
                        this.bounds.getMinimum().z = photonArray[n].z;
                        this.balanceSegment(photonArray, 2 * n + 1, n4 + 1, n3);
                        this.bounds.getMinimum().z = f;
                        break;
                    }
                }
            } else {
                photonArray[2 * n + 1] = this.photons[n3];
            }
        }
    }

    private void swap(int n, int n2) {
        Photon photon = this.photons[n];
        this.photons[n] = this.photons[n2];
        this.photons[n2] = photon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ShadingState shadingState, Vector3 vector3, Color color, Color color2) {
        if (shadingState.getDiffuseDepth() == 0 && (shadingState.getReflectionDepth() > 0 || shadingState.getRefractionDepth() > 0)) {
            Photon photon = new Photon(shadingState.getPoint(), vector3, color);
            CausticPhotonMap causticPhotonMap = this;
            synchronized (causticPhotonMap) {
                ++this.storedPhotons;
                this.photonList.add(photon);
                this.bounds.include(new Point3(photon.x, photon.y, photon.z));
                this.maxPower = Math.max(this.maxPower, color.getMax());
            }
        }
    }

    public void init() {
        UI.printInfo(UI.Module.LIGHT, "Balancing caustics photon map ...", new Object[0]);
        Timer timer = new Timer();
        timer.start();
        this.balance();
        timer.end();
        UI.printInfo(UI.Module.LIGHT, "Caustic photon map:", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "  * Photons stored:   %d", this.storedPhotons);
        UI.printInfo(UI.Module.LIGHT, "  * Photons/estimate: %d", this.gatherNum);
        this.maxRadius = 1.4f * (float)Math.sqrt(this.maxPower * (float)this.gatherNum);
        UI.printInfo(UI.Module.LIGHT, "  * Estimate radius:  %.3f", Float.valueOf(this.gatherRadius));
        UI.printInfo(UI.Module.LIGHT, "  * Maximum radius:   %.3f", Float.valueOf(this.maxRadius));
        UI.printInfo(UI.Module.LIGHT, "  * Balancing time:   %s", timer.toString());
        if (this.gatherRadius > this.maxRadius) {
            this.gatherRadius = this.maxRadius;
        }
    }

    public void getSamples(ShadingState shadingState) {
        if (this.storedPhotons == 0) {
            return;
        }
        NearestPhotons nearestPhotons = new NearestPhotons(shadingState.getPoint(), this.gatherNum, this.gatherRadius * this.gatherRadius);
        this.locatePhotons(nearestPhotons);
        if (nearestPhotons.found < 8) {
            return;
        }
        Point3 point3 = new Point3();
        Vector3 vector3 = new Vector3();
        Vector3 vector32 = new Vector3();
        float f = 1.0f / ((float)Math.PI * nearestPhotons.dist2[0]);
        float f2 = nearestPhotons.dist2[0] * 0.05f;
        float f3 = 1.0f / (this.filterValue * this.filterValue * nearestPhotons.dist2[0]);
        float f4 = 1.0f / (1.0f - 2.0f / (3.0f * this.filterValue));
        for (int i = 1; i <= nearestPhotons.found; ++i) {
            Photon photon = nearestPhotons.index[i];
            Vector3.decode(photon.dir, vector3);
            float f5 = -Vector3.dot(vector3, shadingState.getNormal());
            if (!((double)f5 > 0.001)) continue;
            point3.set(photon.x, photon.y, photon.z);
            Point3.sub(point3, shadingState.getPoint(), vector32);
            float f6 = Vector3.dot(vector32, shadingState.getNormal());
            if (!(f6 < f2) || !(f6 > -f2)) continue;
            LightSample lightSample = new LightSample();
            lightSample.setShadowRay(new Ray(shadingState.getPoint(), vector3.negate()));
            lightSample.setRadiance(new Color().setRGBE(nearestPhotons.index[i].power).mul(f / f5), Color.BLACK);
            lightSample.getDiffuseRadiance().mul((1.0f - (float)Math.sqrt(nearestPhotons.dist2[i] * f3)) * f4);
            shadingState.addSample(lightSample);
        }
    }

    public boolean allowDiffuseBounced() {
        return false;
    }

    public boolean allowReflectionBounced() {
        return true;
    }

    public boolean allowRefractionBounced() {
        return true;
    }

    public int numEmit() {
        return this.numEmit;
    }

    private static class Photon {
        float x;
        float y;
        float z;
        short dir;
        int power;
        int flags;
        static final int SPLIT_X = 0;
        static final int SPLIT_Y = 1;
        static final int SPLIT_Z = 2;
        static final int SPLIT_MASK = 3;

        Photon(Point3 point3, Vector3 vector3, Color color) {
            this.x = point3.x;
            this.y = point3.y;
            this.z = point3.z;
            this.dir = vector3.encode();
            this.power = color.toRGBE();
            this.flags = 0;
        }

        void setSplitAxis(int n) {
            this.flags &= 0xFFFFFFFC;
            this.flags |= n;
        }

        float getCoord(int n) {
            switch (n) {
                case 0: {
                    return this.x;
                }
                case 1: {
                    return this.y;
                }
            }
            return this.z;
        }

        float getDist1(float f, float f2, float f3) {
            switch (this.flags & 3) {
                case 0: {
                    return f - this.x;
                }
                case 1: {
                    return f2 - this.y;
                }
            }
            return f3 - this.z;
        }

        float getDist2(float f, float f2, float f3) {
            float f4 = this.x - f;
            float f5 = this.y - f2;
            float f6 = this.z - f3;
            return f4 * f4 + f5 * f5 + f6 * f6;
        }
    }

    private static class NearestPhotons {
        int found;
        float px;
        float py;
        float pz;
        private int max;
        private boolean gotHeap;
        protected float[] dist2;
        protected Photon[] index;

        NearestPhotons(Point3 point3, int n, float f) {
            this.max = n;
            this.found = 0;
            this.gotHeap = false;
            this.px = point3.x;
            this.py = point3.y;
            this.pz = point3.z;
            this.dist2 = new float[n + 1];
            this.index = new Photon[n + 1];
            this.dist2[0] = f;
        }

        void reset(Point3 point3, float f) {
            this.found = 0;
            this.gotHeap = false;
            this.px = point3.x;
            this.py = point3.y;
            this.pz = point3.z;
            this.dist2[0] = f;
        }

        void checkAddNearest(Photon photon) {
            float f = photon.getDist2(this.px, this.py, this.pz);
            if (f < this.dist2[0]) {
                if (this.found < this.max) {
                    ++this.found;
                    this.dist2[this.found] = f;
                    this.index[this.found] = photon;
                } else {
                    int n;
                    int n2;
                    if (!this.gotHeap) {
                        int n3;
                        for (int i = n3 = this.found >> 1; i >= 1; --i) {
                            n2 = i;
                            Photon photon2 = this.index[i];
                            float f2 = this.dist2[i];
                            while (n2 <= n3) {
                                n = n2 + n2;
                                if (n < this.found && this.dist2[n] < this.dist2[n + 1]) {
                                    ++n;
                                }
                                if (f2 >= this.dist2[n]) break;
                                this.dist2[n2] = this.dist2[n];
                                this.index[n2] = this.index[n];
                                n2 = n;
                            }
                            this.dist2[n2] = f2;
                            this.index[n2] = photon2;
                        }
                        this.gotHeap = true;
                    }
                    n2 = 1;
                    for (n = 2; n <= this.found; n += n) {
                        if (n < this.found && this.dist2[n] < this.dist2[n + 1]) {
                            ++n;
                        }
                        if (f > this.dist2[n]) break;
                        this.dist2[n2] = this.dist2[n];
                        this.index[n2] = this.index[n];
                        n2 = n;
                    }
                    this.dist2[n2] = f;
                    this.index[n2] = photon;
                    this.dist2[0] = this.dist2[1];
                }
            }
        }
    }
}

