/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image.writers;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sunflow.image.BitmapWriter;
import org.sunflow.image.Color;
import org.sunflow.image.XYZColor;

public class IGIBitmapWriter
implements BitmapWriter {
    private String filename;
    private int width;
    private int height;
    private float[] xyz;

    public void configure(String string, String string2) {
    }

    public void openFile(String string) throws IOException {
        this.filename = string;
    }

    public void writeHeader(int n, int n2, int n3) throws IOException, UnsupportedOperationException {
        this.width = n;
        this.height = n2;
        this.xyz = new float[n * n2 * 3];
    }

    public void writeTile(int n, int n2, int n3, int n4, Color[] colorArray, float[] fArray) throws IOException {
        int n5 = 0;
        int n6 = 0;
        int n7 = 3 * (n + n2 * this.width);
        while (n5 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                XYZColor xYZColor = Color.NATIVE_SPACE.convertRGBtoXYZ(colorArray[n6]);
                this.xyz[n7 + 0] = xYZColor.getX();
                this.xyz[n7 + 1] = xYZColor.getY();
                this.xyz[n7 + 2] = xYZColor.getZ();
                ++n8;
                ++n6;
                n7 += 3;
            }
            ++n5;
            n7 += 3 * (this.width - n3);
        }
    }

    public void closeFile() throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.filename));
        IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, 66613373);
        IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, 1);
        IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, 0);
        IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, 0);
        IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, this.width);
        IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, this.height);
        IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, 1);
        IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, 0);
        IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, this.width * this.height * 12);
        IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, 0);
        ((OutputStream)bufferedOutputStream).write(new byte[5000]);
        for (float f : this.xyz) {
            IGIBitmapWriter.write32((OutputStream)bufferedOutputStream, f);
        }
        ((OutputStream)bufferedOutputStream).close();
    }

    private static final void write32(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >> 24 & 0xFF);
    }

    private static final void write32(OutputStream outputStream, float f) throws IOException {
        IGIBitmapWriter.write32(outputStream, Float.floatToIntBits(f));
    }
}

