/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.math;

public final class MathUtils {
    private MathUtils() {
    }

    public static final int clamp(int n, int n2, int n3) {
        if (n > n3) {
            return n3;
        }
        if (n > n2) {
            return n;
        }
        return n2;
    }

    public static final float clamp(float f, float f2, float f3) {
        if (f > f3) {
            return f3;
        }
        if (f > f2) {
            return f;
        }
        return f2;
    }

    public static final double clamp(double d, double d2, double d3) {
        if (d > d3) {
            return d3;
        }
        if (d > d2) {
            return d;
        }
        return d2;
    }

    public static final int min(int n, int n2, int n3) {
        if (n > n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }

    public static final float min(float f, float f2, float f3) {
        if (f > f2) {
            f = f2;
        }
        if (f > f3) {
            f = f3;
        }
        return f;
    }

    public static final double min(double d, double d2, double d3) {
        if (d > d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        return d;
    }

    public static final float min(float f, float f2, float f3, float f4) {
        if (f > f2) {
            f = f2;
        }
        if (f > f3) {
            f = f3;
        }
        if (f > f4) {
            f = f4;
        }
        return f;
    }

    public static final int max(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        }
        if (n < n3) {
            n = n3;
        }
        return n;
    }

    public static final float max(float f, float f2, float f3) {
        if (f < f2) {
            f = f2;
        }
        if (f < f3) {
            f = f3;
        }
        return f;
    }

    public static final double max(double d, double d2, double d3) {
        if (d < d2) {
            d = d2;
        }
        if (d < d3) {
            d = d3;
        }
        return d;
    }

    public static final float max(float f, float f2, float f3, float f4) {
        if (f < f2) {
            f = f2;
        }
        if (f < f3) {
            f = f3;
        }
        if (f < f4) {
            f = f4;
        }
        return f;
    }

    public static final float smoothStep(float f, float f2, float f3) {
        if (f3 <= f) {
            return 0.0f;
        }
        if (f3 >= f2) {
            return 1.0f;
        }
        float f4 = MathUtils.clamp((f3 - f) / (f2 - f), 0.0f, 1.0f);
        return f4 * f4 * (3.0f - 2.0f * f4);
    }

    public static final float frac(float f) {
        return f < 0.0f ? f - (float)((int)f) + 1.0f : f - (float)((int)f);
    }

    public static final float fastPow(float f, float f2) {
        float f3 = Float.floatToRawIntBits(f);
        f3 *= 1.1920929E-7f;
        float f4 = (f3 -= 127.0f) - (float)((int)Math.floor(f3));
        f2 *= f3 + (f4 - f4 * f4) * 0.346607f;
        f4 = f2 - (float)((int)Math.floor(f2));
        f4 = (f4 - f4 * f4) * 0.33971f;
        return Float.intBitsToFloat((int)((f2 + 127.0f - f4) * 8388608.0f));
    }
}

