/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastHashMap<K, V>
implements Iterable<Entry<K, V>> {
    private static final int MIN_SIZE = 4;
    private Entry<K, V>[] entries;
    private int size;

    public FastHashMap() {
        this.clear();
    }

    public void clear() {
        this.size = 0;
        this.entries = this.alloc(4);
    }

    public V put(K k, V v) {
        int n = k.hashCode();
        int n2 = 0;
        int n3 = this.entries.length;
        while (this.entries[n &= this.entries.length - 1] != null) {
            if (((Entry)this.entries[n]).isRemoved() && n3 == this.entries.length) {
                n3 = n;
            } else if (((Entry)this.entries[n]).k.equals(k)) {
                Object object = ((Entry)this.entries[n]).v;
                ((Entry)this.entries[n]).v = v;
                return (V)object;
            }
            n += ++n2;
        }
        if (n3 < this.entries.length) {
            n = n3;
        }
        this.entries[n] = new Entry(k, v);
        ++this.size;
        if (this.size * 2 > this.entries.length) {
            this.resize(this.entries.length * 2);
        }
        return null;
    }

    public V get(K k) {
        int n = k.hashCode();
        int n2 = 0;
        while (this.entries[n &= this.entries.length - 1] != null) {
            if (!((Entry)this.entries[n]).isRemoved() && ((Entry)this.entries[n]).k.equals(k)) {
                return (V)((Entry)this.entries[n]).v;
            }
            n += ++n2;
        }
        return null;
    }

    public boolean containsKey(K k) {
        int n = k.hashCode();
        int n2 = 0;
        while (this.entries[n &= this.entries.length - 1] != null) {
            if (!((Entry)this.entries[n]).isRemoved() && ((Entry)this.entries[n]).k.equals(k)) {
                return true;
            }
            n += ++n2;
        }
        return false;
    }

    public void remove(K k) {
        int n = k.hashCode();
        int n2 = 0;
        while (true) {
            if (this.entries[n &= this.entries.length - 1] == null) {
                return;
            }
            if (!((Entry)this.entries[n]).isRemoved() && ((Entry)this.entries[n]).k.equals(k)) {
                ((Entry)this.entries[n]).remove();
                --this.size;
                break;
            }
            n += ++n2;
        }
        if (this.entries.length > 4 && this.size * 10 < 2 * this.entries.length) {
            this.resize(this.entries.length / 2);
        }
    }

    private void resize(int n) {
        assert ((n & n - 1) == 0);
        assert (n >= 4);
        Entry<K, V>[] entryArray = this.alloc(n);
        for (Entry<K, V> entry : this.entries) {
            if (entry == null || ((Entry)entry).isRemoved()) continue;
            int n2 = ((Entry)entry).k.hashCode();
            int n3 = 0;
            while (entryArray[n2 &= entryArray.length - 1] != null) {
                assert (!((Entry)entryArray[n2]).k.equals(((Entry)entry).k));
                n2 += ++n3;
            }
            entryArray[n2] = new Entry(((Entry)entry).k, ((Entry)entry).v);
        }
        this.entries = entryArray;
    }

    private Entry<K, V>[] alloc(int n) {
        return new Entry[n];
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        return new EntryIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Entry<K, V>> {
        private int index = 0;

        private EntryIterator() {
            if (!this.readable()) {
                this.inc();
            }
        }

        private boolean readable() {
            return FastHashMap.this.entries[this.index] != null && !FastHashMap.this.entries[this.index].isRemoved();
        }

        private void inc() {
            do {
                ++this.index;
            } while (this.hasNext() && !this.readable());
        }

        @Override
        public boolean hasNext() {
            return this.index < FastHashMap.this.entries.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Entry<K, V> next() {
            try {
                Entry entry = FastHashMap.this.entries[this.index];
                return entry;
            }
            finally {
                this.inc();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K, V> {
        private final K k;
        private V v;

        private Entry(K k, V v) {
            this.k = k;
            this.v = v;
        }

        private boolean isRemoved() {
            return this.v == null;
        }

        private void remove() {
            this.v = null;
        }

        public K getKey() {
            return this.k;
        }

        public V getValue() {
            return this.v;
        }
    }
}

