/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.LwsFrame;
import com.sun.j3d.loaders.lw3d.LwsMotion;
import com.sun.j3d.loaders.lw3d.LwsPrimitive;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;

class LwsCamera
extends TextfileParser
implements LwsPrimitive {
    String fileName;
    String objName;
    LwsMotion motion;
    int parent;
    TransformGroup objectTransform;
    Vector objectBehavior;

    LwsCamera(StreamTokenizer streamTokenizer, int n, int n2, float f, int n3) throws ParsingErrorException {
        this.debugPrinter.setValidOutput(n3);
        this.parent = -1;
        this.getNumber(streamTokenizer);
        this.getNumber(streamTokenizer);
        this.getAndCheckString(streamTokenizer, "CameraMotion");
        this.motion = new LwsMotion(streamTokenizer, n, n2, f, this.debugPrinter.getValidOutput());
        while (!this.isCurrentToken(streamTokenizer, "DepthOfField")) {
            this.debugOutputLn(8, "currentToken = " + streamTokenizer.sval);
            if (this.isCurrentToken(streamTokenizer, "ParentObject")) {
                this.parent = (int)this.getNumber(streamTokenizer);
            }
            try {
                streamTokenizer.nextToken();
            }
            catch (IOException iOException) {
                throw new ParsingErrorException(iOException.getMessage());
            }
        }
        this.getNumber(streamTokenizer);
    }

    int getParent() {
        return this.parent;
    }

    void createJava3dObject(int n) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        LwsFrame lwsFrame = this.motion.getFirstFrame();
        lwsFrame.setMatrix(matrix4d);
        this.debugOutputLn(2, "  Camera Matrix = \n" + matrix4d);
        Transform3D transform3D = new Transform3D();
        Matrix4d matrix4d2 = new Matrix4d();
        double d = 0.1;
        matrix4d2.setColumn(0, d, 0.0, 0.0, 0.0);
        matrix4d2.setColumn(1, 0.0, d, 0.0, 0.0);
        matrix4d2.setColumn(2, 0.0, 0.0, d, 0.0);
        matrix4d2.setColumn(3, 0.0, 0.0, 0.0, 1.0);
        Transform3D transform3D2 = new Transform3D(matrix4d2);
        TransformGroup transformGroup = new TransformGroup(transform3D2);
        transformGroup.setCapability(18);
        transformGroup.setCapability(17);
        transform3D.set(matrix4d);
        this.objectTransform = new TransformGroup(transform3D);
        this.objectTransform.setCapability(18);
        this.objectBehavior = new Vector();
        if (n != 0) {
            this.motion.createJava3dBehaviors(this.objectTransform);
            Behavior behavior = this.motion.getBehaviors();
            if (behavior != null) {
                this.objectBehavior.addElement(behavior);
            }
        }
    }

    public TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    public Vector getObjectBehaviors() {
        this.debugOutputLn(1, "getObjectBehaviors()");
        return this.objectBehavior;
    }

    void printVals() {
        System.out.println("   objName = " + this.objName);
        this.motion.printVals();
    }
}

