/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.curve.tess;

import com.jogamp.graph.curve.tess.Triangulator;
import com.jogamp.graph.geom.Outline;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.VectorUtil;
import java.util.ArrayList;
import java.util.List;
import jogamp.graph.curve.tess.CDTriangulator2DExpAddOn;
import jogamp.graph.curve.tess.GraphOutline;
import jogamp.graph.curve.tess.GraphVertex;
import jogamp.graph.curve.tess.Loop;
import jogamp.opengl.Debug;

public class CDTriangulator2D
implements Triangulator {
    protected static final boolean DEBUG = Debug.debug("graph.curve.Triangulation");
    private static final boolean TEST_LINE_AA = Debug.debug("graph.curve.triangulation.LINE_AA");
    private static final boolean TEST_MARK_LINE = Debug.debug("graph.curve.triangulation.MARK_AA");
    private static final boolean TEST_ENABLED = TEST_LINE_AA || TEST_MARK_LINE;
    private final ArrayList<Loop> loops = new ArrayList();
    private int addedVerticeCount;
    private int maxTriID;

    public CDTriangulator2D() {
        this.reset();
    }

    @Override
    public final void reset() {
        this.maxTriID = 0;
        this.addedVerticeCount = 0;
        this.loops.clear();
    }

    @Override
    public final int getAddedVerticeCount() {
        return this.addedVerticeCount;
    }

    @Override
    public final void addCurve(List<Triangle> list, Outline outline, float f) {
        Loop loop = null;
        if (!this.loops.isEmpty()) {
            loop = this.getContainerLoop(outline);
        }
        if (loop == null) {
            GraphOutline graphOutline = new GraphOutline(outline);
            GraphOutline graphOutline2 = this.extractBoundaryTriangles(list, graphOutline, false, f);
            loop = new Loop(graphOutline2, VectorUtil.Winding.CCW);
            this.loops.add(loop);
        } else {
            GraphOutline graphOutline = new GraphOutline(outline);
            GraphOutline graphOutline3 = this.extractBoundaryTriangles(list, graphOutline, true, f);
            loop.addConstraintCurve(graphOutline3);
        }
    }

    @Override
    public final void generate(List<Triangle> list) {
        block6: {
            float[] fArray;
            Triangle triangle;
            int n;
            int n2;
            Object object;
            block7: {
                int n3 = this.loops.size();
                for (int i = 0; i < n3; ++i) {
                    object = this.loops.get(i);
                    n2 = 0;
                    n = ((Loop)object).computeLoopSize();
                    while (!((Loop)object).isSimplex()) {
                        triangle = n2 > n ? ((Loop)object).cut(false) : ((Loop)object).cut(true);
                        ++n2;
                        if (triangle != null) {
                            n2 = 0;
                            --n;
                            triangle.setId(this.maxTriID++);
                            list.add(triangle);
                            if (DEBUG) {
                                System.err.println("CDTri.gen[" + i + "].0: " + triangle);
                            }
                        }
                        if (n2 <= n * 2) continue;
                        if (!DEBUG) break;
                        System.err.println("CDTri.gen[" + i + "].X: Triangulation not complete!");
                        break;
                    }
                    if ((triangle = ((Loop)object).cut(true)) == null) continue;
                    list.add(triangle);
                    if (!DEBUG) continue;
                    System.err.println("CDTri.gen[" + i + "].1: " + triangle);
                }
                if (!TEST_ENABLED) break block6;
                fArray = new float[2];
                object = new CDTriangulator2DExpAddOn();
                n2 = list.size();
                if (!TEST_MARK_LINE) break block7;
                for (n = 0; n < n2; ++n) {
                    triangle = list.get(n);
                    ((CDTriangulator2DExpAddOn)object).markLineInTriangle(triangle, fArray);
                }
                break block6;
            }
            if (!TEST_LINE_AA) break block6;
            for (n = 0; n < n2 - 1; n += 2) {
                triangle = list.get(n);
                Triangle triangle2 = list.get(n + 1);
                ((CDTriangulator2DExpAddOn)object).processLineAA(n, triangle, triangle2, fArray);
            }
        }
    }

    private GraphOutline extractBoundaryTriangles(List<Triangle> list, GraphOutline graphOutline, boolean bl, float f) {
        GraphOutline graphOutline2 = new GraphOutline();
        ArrayList<GraphVertex> arrayList = graphOutline.getGraphPoint();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            GraphVertex graphVertex = arrayList.get(i);
            GraphVertex graphVertex2 = arrayList.get((i + n - 1) % n);
            GraphVertex graphVertex3 = arrayList.get((i + 1) % n);
            if (!graphVertex.getPoint().isOnCurve()) {
                Triangle triangle;
                boolean bl2;
                Vertex vertex = graphVertex2.getPoint().clone();
                Vertex vertex2 = graphVertex3.getPoint().clone();
                Vertex vertex3 = graphVertex.getPoint().clone();
                this.addedVerticeCount += 3;
                boolean[] blArray = new boolean[]{true, true, true};
                graphVertex2.setBoundaryContained(true);
                graphVertex.setBoundaryContained(true);
                graphVertex3.setBoundaryContained(true);
                if (VectorUtil.ccw(vertex, vertex3, vertex2)) {
                    bl2 = false;
                    triangle = new Triangle(vertex, vertex3, vertex2, blArray);
                } else {
                    bl2 = true;
                    triangle = new Triangle(vertex2, vertex3, vertex, blArray);
                }
                triangle.setId(this.maxTriID++);
                list.add(triangle);
                if (DEBUG) {
                    System.err.println(triangle);
                }
                if (bl || bl2) {
                    vertex.setTexCoord(0.0f, -0.1f, 0.0f);
                    vertex2.setTexCoord(1.0f, -0.1f, 0.0f);
                    vertex3.setTexCoord(0.5f, -f - 0.1f, 0.0f);
                    graphOutline2.addVertex(graphVertex);
                } else {
                    vertex.setTexCoord(0.0f, 0.1f, 0.0f);
                    vertex2.setTexCoord(1.0f, 0.1f, 0.0f);
                    vertex3.setTexCoord(0.5f, f + 0.1f, 0.0f);
                }
                if (!DEBUG) continue;
                System.err.println("CDTri.ebt[" + i + "].0: hole " + (bl || bl2) + " " + graphVertex + ", " + triangle);
                continue;
            }
            if (!graphVertex3.getPoint().isOnCurve() || !graphVertex2.getPoint().isOnCurve()) {
                graphVertex.setBoundaryContained(true);
            }
            graphOutline2.addVertex(graphVertex);
            if (!DEBUG) continue;
            System.err.println("CDTri.ebt[" + i + "].1: " + graphVertex);
        }
        return graphOutline2;
    }

    private Loop getContainerLoop(Outline outline) {
        ArrayList<Vertex> arrayList = outline.getVertices();
        for (int i = 0; i < this.loops.size(); ++i) {
            Loop loop = this.loops.get(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!loop.checkInside(arrayList.get(j))) continue;
                return loop;
            }
        }
        return null;
    }
}

