/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.geom.Vertex;
import jogamp.graph.font.typecast.ot.OTGlyph;
import jogamp.graph.font.typecast.ot.Point;
import jogamp.opengl.Debug;

public class TypecastRenderer {
    private static final boolean DEBUG = Debug.debug("graph.font.Renderer");

    private static void addShapeMoveTo(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, Point point) {
        if (DEBUG) {
            System.err.println("Shape.MoveTo: " + point);
        }
        outlineShape.closeLastOutline(false);
        outlineShape.addEmptyOutline();
        outlineShape.addVertex(0, factory.create(point.x, (float)point.y, 0.0f, point.onCurve));
    }

    private static void addShapeLineTo(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, Point point) {
        if (DEBUG) {
            System.err.println("Shape.LineTo: " + point);
        }
        outlineShape.addVertex(0, factory.create(point.x, (float)point.y, 0.0f, point.onCurve));
    }

    private static void addShapeQuadTo(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, Point point, Point point2) {
        if (DEBUG) {
            System.err.println("Shape.QuadTo: " + point + ", " + point2);
        }
        outlineShape.addVertex(0, factory.create(point.x, (float)point.y, 0.0f, point.onCurve));
        outlineShape.addVertex(0, factory.create(point2.x, (float)point2.y, 0.0f, point2.onCurve));
    }

    private static void addShapeQuadTo(OutlineShape outlineShape, Vertex.Factory<? extends Vertex> factory, Point point, float f, float f2, boolean bl) {
        if (DEBUG) {
            System.err.println("Shape.QuadTo: " + point + ", p2 " + f + ", " + f2 + ", onCurve " + bl);
        }
        outlineShape.addVertex(0, factory.create(point.x, (float)point.y, 0.0f, point.onCurve));
        outlineShape.addVertex(0, factory.create(f, f2, 0.0f, bl));
    }

    public static OutlineShape buildShape(char c, OTGlyph oTGlyph, Vertex.Factory<? extends Vertex> factory) {
        if (oTGlyph == null) {
            return null;
        }
        OutlineShape outlineShape = new OutlineShape(factory);
        TypecastRenderer.buildShapeImpl(outlineShape, c, oTGlyph, factory);
        outlineShape.setIsQuadraticNurbs();
        return outlineShape;
    }

    private static void buildShapeImpl(OutlineShape outlineShape, char c, OTGlyph oTGlyph, Vertex.Factory<? extends Vertex> factory) {
        int n = 0;
        int n2 = 0;
        int n3 = oTGlyph.getPointCount();
        for (int i = 0; i < n3; ++i) {
            ++n2;
            if (!oTGlyph.getPoint((int)i).endOfContour) continue;
            int n4 = 0;
            while (n4 < n2 - 1) {
                Point point;
                Point point2 = oTGlyph.getPoint(n + n4 % n2);
                Point point3 = oTGlyph.getPoint(n + (n4 + 1) % n2);
                Point point4 = oTGlyph.getPoint(n + (n4 + 2) % n2);
                Point point5 = point = n4 + 3 < n2 ? oTGlyph.getPoint(n + n4 + 3) : null;
                if (DEBUG) {
                    System.err.println("GlyphShape<" + c + ">: offset " + n4 + " of " + n2 + "/" + n3 + " points");
                    int n5 = n4 == 0 ? n + n2 - 1 : n + (n4 - 1) % n2;
                    Point point6 = oTGlyph.getPoint(n5);
                    int n6 = n + n4 % n2;
                    int n7 = n + (n4 + 1) % n2;
                    int n8 = n + (n4 + 2) % n2;
                    int n9 = n + (n4 + 3) % n2;
                    System.err.println("\t pM[" + n5 + "] " + point6);
                    System.err.println("\t p0[" + n6 + "] " + point2);
                    System.err.println("\t p1[" + n7 + "] " + point3);
                    System.err.println("\t p2[" + n8 + "] " + point4);
                    System.err.println("\t p3[" + n9 + "] " + point);
                }
                if (n4 == 0) {
                    TypecastRenderer.addShapeMoveTo(outlineShape, factory, point2);
                }
                if (point2.endOfContour) {
                    if (DEBUG) {
                        System.err.println("B0 .. end-of-contour **** EOC");
                    }
                    outlineShape.closeLastOutline(false);
                    break;
                }
                if (point2.onCurve) {
                    if (point3.onCurve) {
                        if (DEBUG) {
                            System.err.println("B1 .. line-to p0-p1");
                        }
                        TypecastRenderer.addShapeLineTo(outlineShape, factory, point3);
                        ++n4;
                        continue;
                    }
                    if (point4.onCurve) {
                        if (DEBUG) {
                            System.err.println("B2 .. quad-to p0-p1-p2");
                        }
                        TypecastRenderer.addShapeQuadTo(outlineShape, factory, point3, point4);
                        n4 += 2;
                        continue;
                    }
                    if (null != point && point.onCurve) {
                        if (DEBUG) {
                            System.err.println("B3 .. 2-quad p0-p1-p1_2, p1_2-p2-p3 **** 2QUAD");
                        }
                        TypecastRenderer.addShapeQuadTo(outlineShape, factory, point3, TypecastRenderer.midValue(point3.x, point4.x), TypecastRenderer.midValue(point3.y, point4.y), true);
                        TypecastRenderer.addShapeQuadTo(outlineShape, factory, point4, point);
                        n4 += 3;
                        continue;
                    }
                    if (DEBUG) {
                        System.err.println("B4 .. quad-to p0-p1-p2h **** MID");
                    }
                    TypecastRenderer.addShapeQuadTo(outlineShape, factory, point3, TypecastRenderer.midValue(point3.x, point4.x), TypecastRenderer.midValue(point3.y, point4.y), true);
                    n4 += 2;
                    continue;
                }
                if (!point3.onCurve) {
                    if (DEBUG) {
                        System.err.println("B5 .. quad-to pMh-p0-p1h ***** MID");
                    }
                    TypecastRenderer.addShapeQuadTo(outlineShape, factory, point2, TypecastRenderer.midValue(point2.x, point3.x), TypecastRenderer.midValue(point2.y, point3.y), true);
                    ++n4;
                    continue;
                }
                if (DEBUG) {
                    System.err.println("B6 .. quad-to pMh-p0-p1");
                }
                TypecastRenderer.addShapeQuadTo(outlineShape, factory, point2, point3);
                ++n4;
            }
            outlineShape.closeLastOutline(false);
            n = i + 1;
            n2 = 0;
        }
    }

    private static float midValue(float f, float f2) {
        return f + (f2 - f) / 2.0f;
    }
}

