/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.GlyfCompositeDescript;
import jogamp.graph.font.typecast.ot.table.GlyfDescript;
import jogamp.graph.font.typecast.ot.table.GlyfSimpleDescript;
import jogamp.graph.font.typecast.ot.table.LocaTable;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.Table;

public class GlyfTable
implements Table {
    private final DirectoryEntry _de;
    private final GlyfDescript[] _descript;

    protected GlyfTable(DirectoryEntry directoryEntry, DataInput dataInput, MaxpTable maxpTable, LocaTable locaTable) throws IOException {
        short s;
        DataInputStream dataInputStream;
        int n;
        int n2;
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._descript = new GlyfDescript[maxpTable.getNumGlyphs()];
        byte[] byArray = new byte[directoryEntry.getLength()];
        dataInput.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        for (n2 = 0; n2 < maxpTable.getNumGlyphs(); ++n2) {
            n = locaTable.getOffset(n2 + 1) - locaTable.getOffset(n2);
            if (n > 0) {
                byteArrayInputStream.reset();
                byteArrayInputStream.skip(locaTable.getOffset(n2));
                dataInputStream = new DataInputStream(byteArrayInputStream);
                s = dataInputStream.readShort();
                if (s < 0) continue;
                this._descript[n2] = new GlyfSimpleDescript(this, n2, s, dataInputStream);
                continue;
            }
            this._descript[n2] = null;
        }
        for (n2 = 0; n2 < maxpTable.getNumGlyphs(); ++n2) {
            n = locaTable.getOffset(n2 + 1) - locaTable.getOffset(n2);
            if (n <= 0) continue;
            byteArrayInputStream.reset();
            byteArrayInputStream.skip(locaTable.getOffset(n2));
            dataInputStream = new DataInputStream(byteArrayInputStream);
            s = dataInputStream.readShort();
            if (s >= 0) continue;
            this._descript[n2] = new GlyfCompositeDescript(this, n2, dataInputStream);
        }
    }

    public GlyfDescript getDescription(int n) {
        if (n < this._descript.length) {
            return this._descript[n];
        }
        return null;
    }

    @Override
    public int getType() {
        return 1735162214;
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

