/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.LookupSubtable;
import jogamp.graph.font.typecast.ot.table.LookupSubtableFactory;

public class Lookup {
    public static final int IGNORE_BASE_GLYPHS = 2;
    public static final int IGNORE_BASE_LIGATURES = 4;
    public static final int IGNORE_BASE_MARKS = 8;
    public static final int MARK_ATTACHMENT_TYPE = 65280;
    private final int _type;
    private final int _flag;
    private final int _subTableCount;
    private final int[] _subTableOffsets;
    private final LookupSubtable[] _subTables;

    public Lookup(LookupSubtableFactory lookupSubtableFactory, DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        dataInputStream.reset();
        dataInputStream.skipBytes(n);
        this._type = dataInputStream.readUnsignedShort();
        this._flag = dataInputStream.readUnsignedShort();
        this._subTableCount = dataInputStream.readUnsignedShort();
        this._subTableOffsets = new int[this._subTableCount];
        this._subTables = new LookupSubtable[this._subTableCount];
        for (n2 = 0; n2 < this._subTableCount; ++n2) {
            this._subTableOffsets[n2] = dataInputStream.readUnsignedShort();
        }
        for (n2 = 0; n2 < this._subTableCount; ++n2) {
            this._subTables[n2] = lookupSubtableFactory.read(this._type, dataInputStream, n + this._subTableOffsets[n2]);
        }
    }

    public int getType() {
        return this._type;
    }

    public int getSubtableCount() {
        return this._subTableCount;
    }

    public LookupSubtable getSubtable(int n) {
        return this._subTables[n];
    }
}

