/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Morph;
import javax.media.j3d.SceneGraphObject;

public class MorphState
extends LeafState {
    private int[] geometry;
    private double[] weights;
    private int appearance;

    public MorphState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.appearance = controller.getSymbolTable().addReference((SceneGraphObject)((Morph)this.node).getAppearance());
            this.weights = ((Morph)this.node).getWeights();
            this.geometry = new int[this.weights.length];
            for (int i = 0; i < this.weights.length; ++i) {
                this.geometry[i] = controller.getSymbolTable().addReference((SceneGraphObject)((Morph)this.node).getGeometryArray(i));
            }
        }
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.control.writeBounds(dataOutput, ((Morph)this.node).getCollisionBounds());
        dataOutput.writeInt(this.appearance);
        dataOutput.writeBoolean(((Morph)this.node).getAppearanceOverrideEnable());
        dataOutput.writeInt(this.geometry.length);
        for (int i = 0; i < this.geometry.length; ++i) {
            dataOutput.writeInt(this.geometry[i]);
            dataOutput.writeDouble(this.weights[i]);
        }
    }

    @Override
    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Morph)this.node).setCollisionBounds(this.control.readBounds(dataInput));
        this.appearance = dataInput.readInt();
        ((Morph)this.node).setAppearanceOverrideEnable(dataInput.readBoolean());
        int n = dataInput.readInt();
        this.geometry = new int[n];
        this.weights = new double[n];
        for (int i = 0; i < this.geometry.length; ++i) {
            this.geometry[i] = dataInput.readInt();
            this.weights[i] = dataInput.readDouble();
        }
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.appearance);
        for (int i = 0; i < this.geometry.length; ++i) {
            this.control.getSymbolTable().incNodeComponentRefCount(this.geometry[i]);
        }
    }

    @Override
    public void buildGraph() {
        ((Morph)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.appearance));
        GeometryArray[] geometryArrayArray = new GeometryArray[this.geometry.length];
        for (int i = 0; i < this.geometry.length; ++i) {
            geometryArrayArray[i] = (GeometryArray)this.control.getSymbolTable().getJ3dNode(this.geometry[i]);
        }
        ((Morph)this.node).setGeometryArrays(geometryArrayArray);
        ((Morph)this.node).setWeights(this.weights);
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Morph(null);
    }
}

