/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class JPEGFormat
extends VideoFormat {
    public static final int DEC_422 = 0;
    public static final int DEC_420 = 1;
    public static final int DEC_444 = 2;
    public static final int DEC_402 = 3;
    public static final int DEC_411 = 4;
    int qFactor = -1;
    int decimation = -1;

    public JPEGFormat() {
        super("jpeg");
    }

    public JPEGFormat(Dimension size, int maxDataLength, Class dataType, float frameRate, int q, int dec) {
        super("jpeg", size, maxDataLength, dataType, frameRate);
        this.qFactor = q;
        this.decimation = dec;
    }

    public int getQFactor() {
        return this.qFactor;
    }

    public int getDecimation() {
        return this.decimation;
    }

    public Object clone() {
        JPEGFormat f = new JPEGFormat(this.getSize(), this.getMaxDataLength(), this.getDataType(), this.getFrameRate(), this.qFactor, this.decimation);
        f.copy(this);
        return f;
    }

    protected void copy(Format f) {
        super.copy(f);
        JPEGFormat jf = (JPEGFormat)f;
        this.qFactor = jf.qFactor;
        this.decimation = jf.decimation;
    }

    public String toString() {
        String s = this.getEncoding() + " video format:";
        if (this.size != null) {
            s = s + " size = " + this.size.width + "x" + this.size.height;
        }
        if (this.frameRate != -1.0f) {
            s = s + " FrameRate = " + this.frameRate;
        }
        if (this.maxDataLength != -1) {
            s = s + " maxDataLength = " + this.maxDataLength;
        }
        if (this.dataType != null) {
            s = s + " dataType = " + this.dataType;
        }
        if (this.qFactor != -1) {
            s = s + " q factor = " + this.qFactor;
        }
        if (this.decimation != -1) {
            s = s + " decimation = " + this.decimation;
        }
        return s;
    }

    public boolean equals(Object format) {
        if (format instanceof JPEGFormat) {
            JPEGFormat vf = (JPEGFormat)format;
            return super.equals(format) && this.qFactor == vf.qFactor && this.decimation == vf.decimation;
        }
        return false;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof JPEGFormat)) {
            return true;
        }
        JPEGFormat vf = (JPEGFormat)format;
        return !(this.qFactor != -1 && vf.qFactor != -1 && this.qFactor != vf.qFactor || this.decimation != -1 && vf.decimation != -1 && this.decimation != vf.decimation);
    }

    public Format intersects(Format format) {
        Format fmt = super.intersects(format);
        if (fmt == null) {
            return null;
        }
        if (!(format instanceof JPEGFormat)) {
            return fmt;
        }
        JPEGFormat other = (JPEGFormat)format;
        JPEGFormat res = (JPEGFormat)fmt;
        res.qFactor = this.qFactor != -1 ? this.qFactor : other.qFactor;
        res.decimation = this.decimation != -1 ? this.decimation : other.decimation;
        return res;
    }
}

