/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.Home3DAttributesController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Home3DAttributesPanel
extends JPanel
implements DialogView {
    private final Home3DAttributesController controller;
    private JRadioButton groundColorRadioButton;
    private ColorButton groundColorButton;
    private JRadioButton groundTextureRadioButton;
    private JComponent groundTextureComponent;
    private JCheckBox backgroundImageVisibleOnGround3DCheckBox;
    private JRadioButton skyColorRadioButton;
    private ColorButton skyColorButton;
    private JRadioButton skyTextureRadioButton;
    private JComponent skyTextureComponent;
    private JLabel brightnessLabel;
    private JSlider brightnessSlider;
    private JLabel darkBrightnessLabel;
    private JLabel brightBrightnessLabel;
    private JLabel wallsTransparencyLabel;
    private JLabel opaqueWallsTransparencyLabel;
    private JLabel invisibleWallsTransparencyLabel;
    private JSlider wallsTransparencySlider;
    private String dialogTitle;

    public Home3DAttributesPanel(UserPreferences userPreferences, Home3DAttributesController home3DAttributesController) {
        super(new GridBagLayout());
        this.controller = home3DAttributesController;
        this.createComponents(userPreferences, home3DAttributesController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences);
    }

    private void createComponents(UserPreferences userPreferences, final Home3DAttributesController home3DAttributesController) {
        this.groundColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "groundColorRadioButton.text", new Object[0]));
        this.groundColorRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (Home3DAttributesPanel.this.groundColorRadioButton.isSelected()) {
                    home3DAttributesController.setGroundPaint(Home3DAttributesController.EnvironmentPaint.COLORED);
                }
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.GROUND_PAINT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.updateGroundRadioButtons(home3DAttributesController);
            }
        });
        this.groundColorButton = new ColorButton(userPreferences);
        this.groundColorButton.setColor(home3DAttributesController.getGroundColor());
        this.groundColorButton.setColorDialogTitle(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "groundColorDialog.title", new Object[0]));
        this.groundColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                home3DAttributesController.setGroundColor(Home3DAttributesPanel.this.groundColorButton.getColor());
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.GROUND_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.groundColorButton.setColor(home3DAttributesController.getGroundColor());
            }
        });
        this.groundTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "groundTextureRadioButton.text", new Object[0]));
        this.groundTextureRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (Home3DAttributesPanel.this.groundTextureRadioButton.isSelected()) {
                    home3DAttributesController.setGroundPaint(Home3DAttributesController.EnvironmentPaint.TEXTURED);
                }
            }
        });
        this.groundTextureComponent = (JComponent)((Object)home3DAttributesController.getGroundTextureController().getView());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.groundColorRadioButton);
        buttonGroup.add(this.groundTextureRadioButton);
        this.updateGroundRadioButtons(home3DAttributesController);
        this.backgroundImageVisibleOnGround3DCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "backgroundImageVisibleOnGround3DCheckBox.text", new Object[0]));
        this.backgroundImageVisibleOnGround3DCheckBox.setSelected(home3DAttributesController.isBackgroundImageVisibleOnGround3D());
        this.backgroundImageVisibleOnGround3DCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                home3DAttributesController.setBackgroundImageVisibleOnGround3D(Home3DAttributesPanel.this.backgroundImageVisibleOnGround3DCheckBox.isSelected());
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.BACKGROUND_IMAGE_VISIBLE_ON_GROUND_3D, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.backgroundImageVisibleOnGround3DCheckBox.setSelected(home3DAttributesController.isBackgroundImageVisibleOnGround3D());
            }
        });
        this.skyColorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "skyColorRadioButton.text", new Object[0]));
        this.skyColorRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (Home3DAttributesPanel.this.skyColorRadioButton.isSelected()) {
                    home3DAttributesController.setSkyPaint(Home3DAttributesController.EnvironmentPaint.COLORED);
                }
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.SKY_PAINT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.updateSkyRadioButtons(home3DAttributesController);
            }
        });
        this.skyColorButton = new ColorButton(userPreferences);
        this.skyColorButton.setColor(home3DAttributesController.getSkyColor());
        this.skyColorButton.setColorDialogTitle(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "skyColorDialog.title", new Object[0]));
        this.skyColorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                home3DAttributesController.setSkyColor(Home3DAttributesPanel.this.skyColorButton.getColor());
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.SKY_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.skyColorButton.setColor(home3DAttributesController.getSkyColor());
            }
        });
        this.skyTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "skyTextureRadioButton.text", new Object[0]));
        this.skyTextureRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (Home3DAttributesPanel.this.skyTextureRadioButton.isSelected()) {
                    home3DAttributesController.setSkyPaint(Home3DAttributesController.EnvironmentPaint.TEXTURED);
                }
            }
        });
        this.skyTextureComponent = (JComponent)((Object)home3DAttributesController.getSkyTextureController().getView());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.skyColorRadioButton);
        buttonGroup2.add(this.skyTextureRadioButton);
        this.updateSkyRadioButtons(home3DAttributesController);
        this.brightnessLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "brightnessLabel.text", new Object[0]));
        this.brightnessSlider = new JSlider(0, 255);
        this.darkBrightnessLabel = new JLabel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "darkLabel.text", new Object[0]));
        this.brightBrightnessLabel = new JLabel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "brightLabel.text", new Object[0]));
        this.brightnessSlider.setPaintTicks(true);
        this.brightnessSlider.setMajorTickSpacing(17);
        this.brightnessSlider.setValue(home3DAttributesController.getLightColor() & 0xFF);
        this.brightnessSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = Home3DAttributesPanel.this.brightnessSlider.getValue();
                home3DAttributesController.setLightColor((n << 16) + (n << 8) + n);
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.LIGHT_COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.brightnessSlider.setValue(home3DAttributesController.getLightColor() & 0xFF);
            }
        });
        this.wallsTransparencyLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, Home3DAttributesPanel.class, "wallsTransparencyLabel.text", new Object[0]));
        this.wallsTransparencySlider = new JSlider(0, 255);
        this.opaqueWallsTransparencyLabel = new JLabel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "opaqueLabel.text", new Object[0]));
        this.invisibleWallsTransparencyLabel = new JLabel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "invisibleLabel.text", new Object[0]));
        this.wallsTransparencySlider.setPaintTicks(true);
        this.wallsTransparencySlider.setMajorTickSpacing(17);
        this.wallsTransparencySlider.setValue((int)(home3DAttributesController.getWallsAlpha() * 255.0f));
        this.wallsTransparencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                home3DAttributesController.setWallsAlpha((float)Home3DAttributesPanel.this.wallsTransparencySlider.getValue() / 255.0f);
            }
        });
        home3DAttributesController.addPropertyChangeListener(Home3DAttributesController.Property.WALLS_ALPHA, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Home3DAttributesPanel.this.wallsTransparencySlider.setValue((int)(home3DAttributesController.getWallsAlpha() * 255.0f));
            }
        });
        this.dialogTitle = userPreferences.getLocalizedString(Home3DAttributesPanel.class, "home3DAttributes.title", new Object[0]);
    }

    private void updateGroundRadioButtons(Home3DAttributesController home3DAttributesController) {
        if (home3DAttributesController.getGroundPaint() == Home3DAttributesController.EnvironmentPaint.COLORED) {
            this.groundColorRadioButton.setSelected(true);
        } else {
            this.groundTextureRadioButton.setSelected(true);
        }
    }

    private void updateSkyRadioButtons(Home3DAttributesController home3DAttributesController) {
        if (home3DAttributesController.getSkyPaint() == Home3DAttributesController.EnvironmentPaint.COLORED) {
            this.skyColorRadioButton.setSelected(true);
        } else {
            this.skyTextureRadioButton.setSelected(true);
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.groundColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "groundColorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.groundTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "groundTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.backgroundImageVisibleOnGround3DCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "backgroundImageVisibleOnGround3DCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.skyColorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "skyColorRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.skyTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "skyTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.brightnessLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "brightnessLabel.mnemonic", new Object[0])).getKeyCode());
            this.brightnessLabel.setLabelFor(this.brightnessSlider);
            this.wallsTransparencyLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "wallsTransparencyLabel.mnemonic", new Object[0])).getKeyCode());
            this.wallsTransparencyLabel.setLabelFor(this.wallsTransparencySlider);
        }
    }

    private void layoutComponents(UserPreferences userPreferences) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        JPanel jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "groundPanel.title", new Object[0]));
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        Insets insets = new Insets(0, 0, Math.round(2.0f * SwingTools.getResolutionScale()), n2);
        jPanel.add((Component)this.groundColorRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this.groundColorButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, Math.round(2.0f * SwingTools.getResolutionScale()), 0), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 2, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.groundTextureRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, n2), 0, 0));
        jPanel.add((Component)this.groundTextureComponent, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 0), 0, 0));
        Insets insets2 = OperatingSystem.isMacOSXLeopardOrSuperior() ? new Insets(0, 0, 0, 0) : new Insets(0, 0, n2, 0);
        this.backgroundImageVisibleOnGround3DCheckBox.setVerticalTextPosition(1);
        jPanel.add((Component)this.backgroundImageVisibleOnGround3DCheckBox, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 21, 1, insets2, 0, 0));
        JPanel jPanel2 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "skyPanel.title", new Object[0]));
        jPanel2.add((Component)this.skyColorRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel2.add((Component)this.skyColorButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 2, 0), 0, 0));
        jPanel2.add((Component)this.skyTextureRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, n2), 0, 0));
        jPanel2.add((Component)this.skyTextureComponent, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n2, 0), 0, 0));
        jPanel2.add((Component)new JLabel(), new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 21, 1, insets2, 0, 0));
        JPanel jPanel3 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(Home3DAttributesPanel.class, "renderingPanel.title", new Object[0]));
        jPanel3.add((Component)this.brightnessLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel3.add((Component)this.brightnessSlider, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new BorderLayout(20, 0));
        jPanel4.setOpaque(false);
        jPanel4.add((Component)this.darkBrightnessLabel, "West");
        jPanel4.add((Component)this.brightBrightnessLabel, "East");
        jPanel3.add((Component)jPanel4, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(OperatingSystem.isWindows() ? 0 : -3, 0, 3, 0), 0, 0));
        jPanel3.add((Component)this.wallsTransparencyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel3.add((Component)this.wallsTransparencySlider, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel5 = new JPanel(new BorderLayout(20, 0));
        jPanel5.setOpaque(false);
        jPanel5.add((Component)this.opaqueWallsTransparencyLabel, "West");
        jPanel5.add((Component)this.invisibleWallsTransparencyLabel, "East");
        jPanel3.add((Component)jPanel5, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(OperatingSystem.isWindows() ? 0 : -3, 0, 10, 0), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.wallsTransparencySlider) == 0 && this.controller != null) {
            this.controller.modify3DAttributes();
        }
    }
}

