/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.AbstractPhotoController;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;

public class PhotoController
extends AbstractPhotoController {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final PropertyChangeSupport propertyChangeSupport;
    private final CameraChangeListener cameraChangeListener;
    private DialogView photoView;
    private long time;
    private Camera.Lens lens;
    private String renderer;

    public PhotoController(Home home, UserPreferences userPreferences, View view, ViewFactory viewFactory, ContentManager contentManager) {
        super(home, userPreferences, view, contentManager);
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.cameraChangeListener = new CameraChangeListener(this);
        home.getCamera().addPropertyChangeListener(this.cameraChangeListener);
        home.addPropertyChangeListener(Home.Property.CAMERA, (PropertyChangeListener)new HomeCameraChangeListener(this));
        this.updateProperties();
    }

    @Override
    public DialogView getView() {
        if (this.photoView == null) {
            this.photoView = this.viewFactory.createPhotoView(this.home, this.preferences, this);
        }
        return this.photoView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    @Override
    protected void updateProperties() {
        if (this.home != null) {
            super.updateProperties();
            this.setTime(this.home.getCamera().getTime());
            this.setLens(this.home.getCamera().getLens());
            String string = this.home.getCamera().getRenderer();
            if (string == null) {
                string = this.preferences.getPhotoRenderer();
            }
            this.setRenderer(string, false);
        }
    }

    public void setTime(long l) {
        if (this.time != l) {
            long l2 = this.time;
            this.time = l;
            this.propertyChangeSupport.firePropertyChange(Property.TIME.name(), l2, l);
            Camera camera = this.home.getCamera();
            camera.removePropertyChangeListener(this.cameraChangeListener);
            camera.setTime(l);
            camera.addPropertyChangeListener(this.cameraChangeListener);
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setLens(Camera.Lens lens) {
        if (this.lens != lens) {
            Camera.Lens lens2 = this.lens;
            this.lens = lens;
            this.propertyChangeSupport.firePropertyChange(Property.LENS.name(), (Object)lens2, (Object)lens);
            if (lens == Camera.Lens.SPHERICAL) {
                this.setAspectRatio(AspectRatio.RATIO_2_1);
            } else if (lens == Camera.Lens.FISHEYE) {
                this.setAspectRatio(AspectRatio.SQUARE_RATIO);
            }
            this.home.getCamera().setLens(this.lens);
        }
    }

    public Camera.Lens getLens() {
        return this.lens;
    }

    public void setRenderer(String string) {
        this.setRenderer(string, true);
    }

    private void setRenderer(String string, boolean bl) {
        if (this.renderer != string) {
            String string2 = this.renderer;
            this.renderer = string;
            this.propertyChangeSupport.firePropertyChange(Property.RENDERER.name(), string2, string);
            this.home.getTopCamera().setRenderer(this.renderer);
            this.home.getObserverCamera().setRenderer(this.renderer);
            if (bl) {
                this.preferences.setPhotoRenderer(string);
            }
        }
    }

    public String getRenderer() {
        return this.renderer;
    }

    private static class CameraChangeListener
    implements PropertyChangeListener {
        private WeakReference<AbstractPhotoController> photoController;

        public CameraChangeListener(AbstractPhotoController abstractPhotoController) {
            this.photoController = new WeakReference<AbstractPhotoController>(abstractPhotoController);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractPhotoController abstractPhotoController = (AbstractPhotoController)this.photoController.get();
            if (abstractPhotoController == null) {
                ((Camera)propertyChangeEvent.getSource()).removePropertyChangeListener(this);
            } else {
                abstractPhotoController.updateProperties();
            }
        }
    }

    private static class HomeCameraChangeListener
    implements PropertyChangeListener {
        private WeakReference<PhotoController> photoController;

        public HomeCameraChangeListener(PhotoController photoController) {
            this.photoController = new WeakReference<PhotoController>(photoController);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PhotoController photoController = (PhotoController)this.photoController.get();
            if (photoController == null) {
                ((Home)propertyChangeEvent.getSource()).removePropertyChangeListener(Home.Property.CAMERA, (PropertyChangeListener)this);
            } else {
                ((Camera)propertyChangeEvent.getOldValue()).removePropertyChangeListener(photoController.cameraChangeListener);
                photoController.updateProperties();
                ((Camera)propertyChangeEvent.getNewValue()).addPropertyChangeListener(photoController.cameraChangeListener);
            }
        }
    }

    public static enum Property {
        TIME,
        LENS,
        RENDERER;

    }
}

