/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import java.io.IOException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.ad.constant.CommonName;
import org.opensearch.ad.model.ADTaskProfile;
import org.opensearch.ad.model.DetectorState;
import org.opensearch.ad.model.InitProgressProfile;
import org.opensearch.ad.model.Mergeable;
import org.opensearch.ad.model.ModelProfileOnNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class DetectorProfile
implements Writeable,
ToXContentObject,
Mergeable {
    private DetectorState state;
    private String error;
    private ModelProfileOnNode[] modelProfile;
    private int shingleSize;
    private String coordinatingNode;
    private long totalSizeInBytes;
    private InitProgressProfile initProgress;
    private Long totalEntities;
    private Long activeEntities;
    private ADTaskProfile adTaskProfile;
    private long modelCount;

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public DetectorProfile(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.state = (DetectorState)in.readEnum(DetectorState.class);
        }
        this.error = in.readOptionalString();
        this.modelProfile = (ModelProfileOnNode[])in.readOptionalArray(ModelProfileOnNode::new, ModelProfileOnNode[]::new);
        this.shingleSize = in.readOptionalInt();
        this.coordinatingNode = in.readOptionalString();
        this.totalSizeInBytes = in.readOptionalLong();
        this.totalEntities = in.readOptionalLong();
        this.activeEntities = in.readOptionalLong();
        if (in.readBoolean()) {
            this.initProgress = new InitProgressProfile(in);
        }
        if (in.readBoolean()) {
            this.adTaskProfile = new ADTaskProfile(in);
        }
        this.modelCount = in.readVLong();
    }

    private DetectorProfile() {
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.state == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.state);
        }
        out.writeOptionalString(this.error);
        out.writeOptionalArray((Writeable[])this.modelProfile);
        out.writeOptionalInt(Integer.valueOf(this.shingleSize));
        out.writeOptionalString(this.coordinatingNode);
        out.writeOptionalLong(Long.valueOf(this.totalSizeInBytes));
        out.writeOptionalLong(this.totalEntities);
        out.writeOptionalLong(this.activeEntities);
        if (this.initProgress == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.initProgress.writeTo(out);
        }
        if (this.adTaskProfile == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.adTaskProfile.writeTo(out);
        }
        out.writeVLong(this.modelCount);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.state != null) {
            xContentBuilder.field("state", (Object)this.state);
        }
        if (this.error != null) {
            xContentBuilder.field("error", this.error);
        }
        if (this.modelProfile != null && this.modelProfile.length > 0) {
            xContentBuilder.startArray("models");
            for (ModelProfileOnNode profile : this.modelProfile) {
                profile.toXContent(xContentBuilder, params);
            }
            xContentBuilder.endArray();
        }
        if (this.shingleSize != -1) {
            xContentBuilder.field("shingle_size", this.shingleSize);
        }
        if (this.coordinatingNode != null && !this.coordinatingNode.isEmpty()) {
            xContentBuilder.field("coordinating_node", this.coordinatingNode);
        }
        if (this.totalSizeInBytes != -1L) {
            xContentBuilder.field("total_size_in_bytes", this.totalSizeInBytes);
        }
        if (this.initProgress != null) {
            xContentBuilder.field("init_progress", (ToXContent)this.initProgress);
        }
        if (this.totalEntities != null) {
            xContentBuilder.field("total_entities", this.totalEntities);
        }
        if (this.activeEntities != null) {
            xContentBuilder.field("active_entities", this.activeEntities);
        }
        if (this.adTaskProfile != null) {
            xContentBuilder.field("ad_task", (ToXContent)this.adTaskProfile);
        }
        if (this.modelCount > 0L) {
            xContentBuilder.field(CommonName.MODEL_COUNT, this.modelCount);
        }
        return xContentBuilder.endObject();
    }

    public DetectorState getState() {
        return this.state;
    }

    public void setState(DetectorState state) {
        this.state = state;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public ModelProfileOnNode[] getModelProfile() {
        return this.modelProfile;
    }

    public void setModelProfile(ModelProfileOnNode[] modelProfile) {
        this.modelProfile = modelProfile;
    }

    public int getShingleSize() {
        return this.shingleSize;
    }

    public void setShingleSize(int shingleSize) {
        this.shingleSize = shingleSize;
    }

    public String getCoordinatingNode() {
        return this.coordinatingNode;
    }

    public void setCoordinatingNode(String coordinatingNode) {
        this.coordinatingNode = coordinatingNode;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public void setTotalSizeInBytes(long totalSizeInBytes) {
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public InitProgressProfile getInitProgress() {
        return this.initProgress;
    }

    public void setInitProgress(InitProgressProfile initProgress) {
        this.initProgress = initProgress;
    }

    public Long getTotalEntities() {
        return this.totalEntities;
    }

    public void setTotalEntities(Long totalEntities) {
        this.totalEntities = totalEntities;
    }

    public Long getActiveEntities() {
        return this.activeEntities;
    }

    public void setActiveEntities(Long activeEntities) {
        this.activeEntities = activeEntities;
    }

    public ADTaskProfile getAdTaskProfile() {
        return this.adTaskProfile;
    }

    public void setAdTaskProfile(ADTaskProfile adTaskProfile) {
        this.adTaskProfile = adTaskProfile;
    }

    public long getModelCount() {
        return this.modelCount;
    }

    public void setModelCount(long modelCount) {
        this.modelCount = modelCount;
    }

    @Override
    public void merge(Mergeable other) {
        if (this == other || other == null || this.getClass() != other.getClass()) {
            return;
        }
        DetectorProfile otherProfile = (DetectorProfile)other;
        if (otherProfile.getState() != null) {
            this.state = otherProfile.getState();
        }
        if (otherProfile.getError() != null) {
            this.error = otherProfile.getError();
        }
        if (otherProfile.getCoordinatingNode() != null) {
            this.coordinatingNode = otherProfile.getCoordinatingNode();
        }
        if (otherProfile.getShingleSize() != -1) {
            this.shingleSize = otherProfile.getShingleSize();
        }
        if (otherProfile.getModelProfile() != null) {
            this.modelProfile = otherProfile.getModelProfile();
        }
        if (otherProfile.getTotalSizeInBytes() != -1L) {
            this.totalSizeInBytes = otherProfile.getTotalSizeInBytes();
        }
        if (otherProfile.getInitProgress() != null) {
            this.initProgress = otherProfile.getInitProgress();
        }
        if (otherProfile.getTotalEntities() != null) {
            this.totalEntities = otherProfile.getTotalEntities();
        }
        if (otherProfile.getActiveEntities() != null) {
            this.activeEntities = otherProfile.getActiveEntities();
        }
        if (otherProfile.getAdTaskProfile() != null) {
            this.adTaskProfile = otherProfile.getAdTaskProfile();
        }
        if (otherProfile.getModelCount() > 0L) {
            this.modelCount = otherProfile.getModelCount();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof DetectorProfile) {
            DetectorProfile other = (DetectorProfile)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            if (this.state != null) {
                equalsBuilder.append((Object)this.state, (Object)other.state);
            }
            if (this.error != null) {
                equalsBuilder.append((Object)this.error, (Object)other.error);
            }
            if (this.modelProfile != null && this.modelProfile.length > 0) {
                equalsBuilder.append((Object[])this.modelProfile, (Object[])other.modelProfile);
            }
            if (this.shingleSize != -1) {
                equalsBuilder.append(this.shingleSize, other.shingleSize);
            }
            if (this.coordinatingNode != null) {
                equalsBuilder.append((Object)this.coordinatingNode, (Object)other.coordinatingNode);
            }
            if (this.totalSizeInBytes != -1L) {
                equalsBuilder.append(this.totalSizeInBytes, other.totalSizeInBytes);
            }
            if (this.initProgress != null) {
                equalsBuilder.append((Object)this.initProgress, (Object)other.initProgress);
            }
            if (this.totalEntities != null) {
                equalsBuilder.append((Object)this.totalEntities, (Object)other.totalEntities);
            }
            if (this.activeEntities != null) {
                equalsBuilder.append((Object)this.activeEntities, (Object)other.activeEntities);
            }
            if (this.adTaskProfile != null) {
                equalsBuilder.append((Object)this.adTaskProfile, (Object)other.adTaskProfile);
            }
            if (this.modelCount > 0L) {
                equalsBuilder.append(this.modelCount, other.modelCount);
            }
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.state).append((Object)this.error).append((Object[])this.modelProfile).append(this.shingleSize).append((Object)this.coordinatingNode).append(this.totalSizeInBytes).append((Object)this.initProgress).append((Object)this.totalEntities).append((Object)this.activeEntities).append((Object)this.adTaskProfile).append(this.modelCount).toHashCode();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        if (this.state != null) {
            toStringBuilder.append("state", (Object)this.state);
        }
        if (this.error != null) {
            toStringBuilder.append("error", (Object)this.error);
        }
        if (this.modelProfile != null && this.modelProfile.length > 0) {
            toStringBuilder.append((Object[])this.modelProfile);
        }
        if (this.shingleSize != -1) {
            toStringBuilder.append("shingle_size", this.shingleSize);
        }
        if (this.coordinatingNode != null) {
            toStringBuilder.append("coordinating_node", (Object)this.coordinatingNode);
        }
        if (this.totalSizeInBytes != -1L) {
            toStringBuilder.append("total_size_in_bytes", this.totalSizeInBytes);
        }
        if (this.initProgress != null) {
            toStringBuilder.append("init_progress", (Object)this.initProgress);
        }
        if (this.totalEntities != null) {
            toStringBuilder.append("total_entities", (Object)this.totalEntities);
        }
        if (this.activeEntities != null) {
            toStringBuilder.append("active_entities", (Object)this.activeEntities);
        }
        if (this.adTaskProfile != null) {
            toStringBuilder.append("ad_task", (Object)this.adTaskProfile);
        }
        if (this.modelCount > 0L) {
            toStringBuilder.append(CommonName.MODEL_COUNT, this.modelCount);
        }
        return toStringBuilder.toString();
    }

    public static class Builder {
        private DetectorState state = null;
        private String error = null;
        private ModelProfileOnNode[] modelProfile = null;
        private int shingleSize = -1;
        private String coordinatingNode = null;
        private long totalSizeInBytes = -1L;
        private InitProgressProfile initProgress = null;
        private Long totalEntities;
        private Long activeEntities;
        private ADTaskProfile adTaskProfile;
        private long modelCount = 0L;

        public Builder state(DetectorState state) {
            this.state = state;
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            return this;
        }

        public Builder modelProfile(ModelProfileOnNode[] modelProfile) {
            this.modelProfile = modelProfile;
            return this;
        }

        public Builder modelCount(long modelCount) {
            this.modelCount = modelCount;
            return this;
        }

        public Builder shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return this;
        }

        public Builder coordinatingNode(String coordinatingNode) {
            this.coordinatingNode = coordinatingNode;
            return this;
        }

        public Builder totalSizeInBytes(long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        public Builder initProgress(InitProgressProfile initProgress) {
            this.initProgress = initProgress;
            return this;
        }

        public Builder totalEntities(Long totalEntities) {
            this.totalEntities = totalEntities;
            return this;
        }

        public Builder activeEntities(Long activeEntities) {
            this.activeEntities = activeEntities;
            return this;
        }

        public Builder adTaskProfile(ADTaskProfile adTaskProfile) {
            this.adTaskProfile = adTaskProfile;
            return this;
        }

        public DetectorProfile build() {
            DetectorProfile profile = new DetectorProfile();
            profile.state = this.state;
            profile.error = this.error;
            profile.modelProfile = this.modelProfile;
            profile.modelCount = this.modelCount;
            profile.shingleSize = this.shingleSize;
            profile.coordinatingNode = this.coordinatingNode;
            profile.totalSizeInBytes = this.totalSizeInBytes;
            profile.initProgress = this.initProgress;
            profile.totalEntities = this.totalEntities;
            profile.activeEntities = this.activeEntities;
            profile.adTaskProfile = this.adTaskProfile;
            return profile;
        }
    }
}

