/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport.handler;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.transport.handler.AnomalyIndexHandler;
import org.opensearch.ad.util.ClientUtil;
import org.opensearch.ad.util.IndexUtils;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.threadpool.ThreadPool;

public class AnomalyResultBulkIndexHandler
extends AnomalyIndexHandler<AnomalyResult> {
    private static final Logger LOG = LogManager.getLogger(AnomalyResultBulkIndexHandler.class);
    private AnomalyDetectionIndices anomalyDetectionIndices;

    public AnomalyResultBulkIndexHandler(Client client, Settings settings, ThreadPool threadPool, ClientUtil clientUtil, IndexUtils indexUtils, ClusterService clusterService, AnomalyDetectionIndices anomalyDetectionIndices) {
        super(client, settings, threadPool, ".opendistro-anomaly-results", anomalyDetectionIndices, clientUtil, indexUtils, clusterService);
        this.anomalyDetectionIndices = anomalyDetectionIndices;
    }

    public void bulkIndexAnomalyResult(String resultIndex, List<AnomalyResult> anomalyResults, ActionListener<BulkResponse> listener) {
        if (anomalyResults == null || anomalyResults.size() == 0) {
            listener.onResponse(null);
            return;
        }
        String detectorId = anomalyResults.get(0).getDetectorId();
        try {
            if (resultIndex != null) {
                if (!this.anomalyDetectionIndices.doesIndexExist(resultIndex)) {
                    throw new EndRunException(detectorId, CommonErrorMessages.CAN_NOT_FIND_RESULT_INDEX + resultIndex, true);
                }
                if (!this.anomalyDetectionIndices.isValidResultIndexMapping(resultIndex)) {
                    throw new EndRunException(detectorId, "wrong index mapping of custom AD result index", true);
                }
                this.bulkSaveDetectorResult(resultIndex, anomalyResults, listener);
                return;
            }
            if (!this.anomalyDetectionIndices.doesDefaultAnomalyResultIndexExist()) {
                this.anomalyDetectionIndices.initDefaultAnomalyResultIndexDirectly((ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                    if (response.isAcknowledged()) {
                        this.bulkSaveDetectorResult(anomalyResults, listener);
                    } else {
                        String error = "Creating anomaly result index with mappings call not acknowledged";
                        LOG.error(error);
                        listener.onFailure((Exception)new AnomalyDetectionException(error));
                    }
                }, exception -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                        this.bulkSaveDetectorResult(anomalyResults, listener);
                    } else {
                        listener.onFailure(exception);
                    }
                }));
            } else {
                this.bulkSaveDetectorResult(anomalyResults, listener);
            }
        }
        catch (AnomalyDetectionException e) {
            listener.onFailure((Exception)e);
        }
        catch (Exception e) {
            String error = "Failed to bulk index anomaly result";
            LOG.error(error, (Throwable)e);
            listener.onFailure((Exception)new AnomalyDetectionException(error, e));
        }
    }

    private void bulkSaveDetectorResult(List<AnomalyResult> anomalyResults, ActionListener<BulkResponse> listener) {
        this.bulkSaveDetectorResult(".opendistro-anomaly-results", anomalyResults, listener);
    }

    private void bulkSaveDetectorResult(String resultIndex, List<AnomalyResult> anomalyResults, ActionListener<BulkResponse> listener) {
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        anomalyResults.forEach(anomalyResult -> {
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                IndexRequest indexRequest = new IndexRequest(resultIndex).source(anomalyResult.toXContent(builder, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE));
                bulkRequestBuilder.add(indexRequest);
            }
            catch (Exception e) {
                String error = "Failed to prepare request to bulk index anomaly results";
                LOG.error(error, (Throwable)e);
                throw new AnomalyDetectionException(error);
            }
        });
        this.client.bulk((BulkRequest)bulkRequestBuilder.request(), ActionListener.wrap(r -> {
            if (r.hasFailures()) {
                String failureMessage = r.buildFailureMessage();
                LOG.warn("Failed to bulk index AD result " + failureMessage);
                listener.onFailure((Exception)new AnomalyDetectionException(failureMessage));
            } else {
                listener.onResponse(r);
            }
        }, e -> {
            LOG.error("bulk index ad result failed", (Throwable)e);
            listener.onFailure(e);
        }));
    }
}

