/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasource.model;

public enum DataSourceType {
    PROMETHEUS("prometheus"),
    OPENSEARCH("opensearch"),
    SPARK("spark");

    private String text;

    private DataSourceType(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public static DataSourceType fromString(String text) {
        for (DataSourceType dataSourceType : DataSourceType.values()) {
            if (!dataSourceType.text.equalsIgnoreCase(text)) continue;
            return dataSourceType;
        }
        throw new IllegalArgumentException("No DataSourceType with text " + text + " found");
    }
}

