/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import java.awt.image.BufferedImage;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImageEncoder;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.TIFFTranscoder;

public class TIFFTranscoderInternalCodecWriteAdapter
implements TIFFTranscoder.WriteAdapter {
    public void writeImage(TIFFTranscoder tIFFTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        TranscodingHints transcodingHints = tIFFTranscoder.getTranscodingHints();
        TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
        float f = tIFFTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n = (int)((double)(100000.0f / f) + 0.5);
        int n2 = 10000;
        long[] lArray = new long[]{n, n2};
        TIFFField[] tIFFFieldArray = new TIFFField[]{new TIFFField(296, 3, 1, new char[]{'\u0003'}), new TIFFField(282, 5, 1, new long[][]{lArray}), new TIFFField(283, 5, 1, new long[][]{lArray})};
        tIFFEncodeParam.setExtraFields(tIFFFieldArray);
        if (transcodingHints.containsKey((Object)TIFFTranscoder.KEY_COMPRESSION_METHOD)) {
            String string = (String)transcodingHints.get((Object)TIFFTranscoder.KEY_COMPRESSION_METHOD);
            if ("packbits".equals(string)) {
                tIFFEncodeParam.setCompression(32773);
            } else if ("deflate".equals(string)) {
                tIFFEncodeParam.setCompression(32946);
            }
        }
        try {
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            OutputStream outputStream = transcoderOutput.getOutputStream();
            TIFFImageEncoder tIFFImageEncoder = new TIFFImageEncoder(outputStream, tIFFEncodeParam);
            int n5 = singlePixelPackedSampleModel.getNumBands();
            int[] nArray = new int[n5];
            for (int i = 0; i < n5; ++i) {
                nArray[i] = i;
            }
            PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n3, n4, n5, n3 * n5, nArray);
            FormatRed formatRed = new FormatRed(GraphicsUtil.wrap((RenderedImage)bufferedImage), (SampleModel)pixelInterleavedSampleModel);
            tIFFImageEncoder.encode((RenderedImage)formatRed);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException((Exception)iOException);
        }
    }
}

