/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.autoplay;

public class PointList {
    private long[] _millis = null;
    private int[] _indexes = null;
    private final int _maxItem;
    private int _currentItem = 0;

    public PointList(int n) {
        this._millis = new long[n];
        this._indexes = new int[n];
        this._currentItem = 0;
        this._maxItem = n - 1;
    }

    public void setPoint(long l, int n) {
        this._millis[this._currentItem] = l;
        this._indexes[this._currentItem] = n;
        ++this._currentItem;
    }

    public void set(long l) {
        if (this.isFinished() || l < this._millis[this._currentItem]) {
            this._currentItem = 0;
        }
        while (this._currentItem < this._maxItem && this._millis[this._currentItem + 1] < l) {
            ++this._currentItem;
        }
    }

    public void normalize(int n) {
        if (this._maxItem <= 0) {
            return;
        }
        long l = this._millis[this._maxItem] - this._millis[0];
        if (l > 0L) {
            double d = (double)n * 1000.0 / (double)l;
            int n2 = 0;
            while (n2 <= this._maxItem) {
                this._millis[n2] = (long)((double)this._millis[n2] * d);
                ++n2;
            }
        }
    }

    public long getCurrentMilliseconds() {
        if (this.isAtStart() || this.isFinished()) {
            return 0L;
        }
        return this._millis[this._currentItem];
    }

    public int getCurrentPointIndex() {
        return this._indexes[this._currentItem];
    }

    public boolean isAtStart() {
        return this._currentItem == 0;
    }

    public boolean isFinished() {
        return this._currentItem >= this._maxItem;
    }

    public long getMillisUntilNextPoint(long l) {
        if (this.isFinished() || this._millis[this._currentItem + 1] < this._millis[this._currentItem]) {
            return 0L;
        }
        return this._millis[this._currentItem + 1] - l;
    }
}

