/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.sf.jnati.ArtefactDescriptor;
import net.sf.jnati.FileUtils;
import net.sf.jnati.NativeCodeException;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.artefact.ConfigManager;
import net.sf.jnati.deploy.repository.ClasspathRepository;
import net.sf.jnati.deploy.repository.LocalRepository;
import net.sf.jnati.deploy.repository.RemoteRepository;
import net.sf.jnati.deploy.resolver.ArtefactNotFoundException;
import net.sf.jnati.deploy.resolver.ArtefactResolver;
import net.sf.jnati.deploy.source.ArtefactSource;
import org.apache.log4j.Logger;

public class NativeArtefactLocator {
    private static final Logger LOG = Logger.getLogger(NativeArtefactLocator.class);

    public Artefact getArtefact(String id, String version) throws NativeCodeException {
        Artefact artefact = new Artefact(id, version);
        ConfigManager.loadConfiguration(artefact);
        ClasspathRepository cpRepo = new ClasspathRepository();
        List<ArtefactSource> cpSources = null;
        try {
            cpSources = cpRepo.getArtefactSource(artefact);
        }
        catch (IOException e) {
            LOG.warn("Error searching classpath", e);
            cpSources = Collections.emptyList();
        }
        if (artefact.getAllowLocal()) {
            for (ArtefactSource source : cpSources) {
                if (!source.isLocal()) continue;
                try {
                    source.loadManifest(artefact);
                    artefact.setPath(source.getPath());
                    LOG.info("Artefact (" + artefact + ") location: " + artefact.getPath());
                    return artefact;
                }
                catch (IOException e) {
                    LOG.warn("Error loading manifest", e);
                }
            }
        }
        LocalRepository localRepo = new LocalRepository(artefact.getLocalRepository());
        List<? extends ArtefactSource> localSources = localRepo.getArtefactSource(artefact);
        for (ArtefactSource artefactSource : localSources) {
            if (!artefactSource.isLocal()) continue;
            try {
                artefactSource.loadManifest(artefact);
                artefact.setPath(artefactSource.getPath());
                LOG.info("Artefact (" + artefact + ") location: " + artefact.getPath());
                return artefact;
            }
            catch (IOException e) {
                LOG.warn("Error loading manifest", e);
            }
        }
        if (!cpSources.isEmpty()) {
            File target = localRepo.createArtefact(artefact);
            for (ArtefactSource source : cpSources) {
                try {
                    new ArtefactResolver().resolve(artefact, source, target);
                    LOG.info("Artefact (" + artefact + ") location: " + artefact.getPath());
                    return artefact;
                }
                catch (IOException e) {
                    LOG.warn("Error resolving artefact to local repository", e);
                }
            }
            FileUtils.delTree(target);
        }
        if (artefact.getAllowDownload()) {
            List<String> urls = artefact.getRepositoryUrls();
            Collections.shuffle(urls);
            for (String u : urls) {
                List<? extends ArtefactSource> remoteSources;
                URL url;
                try {
                    url = new URL(u);
                }
                catch (MalformedURLException e) {
                    LOG.warn("Malformed URL", e);
                    continue;
                }
                RemoteRepository remoteRepo = new RemoteRepository(url);
                try {
                    remoteSources = remoteRepo.getArtefactSource(artefact);
                }
                catch (IOException e) {
                    LOG.warn("Error accessing remote repository", e);
                    continue;
                }
                if (remoteSources.isEmpty()) continue;
                File target = localRepo.createArtefact(artefact);
                for (ArtefactSource artefactSource : remoteSources) {
                    try {
                        new ArtefactResolver().resolve(artefact, artefactSource, target);
                        LOG.info("Artefact (" + artefact + ") location: " + artefact.getPath());
                        return artefact;
                    }
                    catch (IOException e) {
                        LOG.warn("Error resolving artefact to local repository", e);
                    }
                }
                FileUtils.delTree(target);
            }
        }
        throw new ArtefactNotFoundException("Artefact not found: " + artefact);
    }

    public static ArtefactDescriptor findArtefact(String id, String version) throws NativeCodeException {
        NativeArtefactLocator loc = new NativeArtefactLocator();
        Artefact artefact = loc.getArtefact(id, version);
        return artefact.getArtefactLocation();
    }
}

