/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;

public class XmlChemDrawReader
extends XmlReader {
    boolean optimize2D;
    private float minX = Float.MAX_VALUE;
    private float minY = Float.MAX_VALUE;
    private float minZ = Float.MAX_VALUE;
    private float maxZ = -3.4028235E38f;
    private float maxY = -3.4028235E38f;
    private float maxX = -3.4028235E38f;
    private boolean is3D;
    private Lst<Object[]> bonds = new Lst();
    private Atom warningAtom;

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        this.optimize2D = this.checkFilterKey("2D");
        this.processXml2(parent, saxReader);
        this.filter = parent.filter;
    }

    @Override
    public void processStartElement(String localName, String nodeName) {
        if ("fragment".equals(localName)) {
            return;
        }
        if ("n".equals(localName)) {
            String nodeType;
            if (this.asc.bsAtoms == null) {
                this.asc.bsAtoms = new BS();
            }
            if ("Fragment".equals(nodeType = (String)this.atts.get("nodetype"))) {
                return;
            }
            boolean isNickname = "Nickname".equals(nodeType);
            boolean isConnectionPt = "ExternalConnectionPoint".equals(nodeType);
            String warning = (String)this.atts.get("warning");
            this.atom = new Atom();
            this.atom.atomName = (String)this.atts.get("id");
            String element = (String)this.atts.get("element");
            this.atom.elementNumber = (short)(warning != null ? 0 : (element == null ? 6 : Integer.parseInt(element)));
            element = JmolAdapter.getElementSymbol(this.atom.elementNumber);
            String isotope = (String)this.atts.get("isotope");
            if (isotope != null) {
                element = isotope + element;
            }
            this.setElementAndIsotope(this.atom, element);
            String s = (String)this.atts.get("charge");
            if (s != null) {
                this.atom.formalCharge = Integer.parseInt(s);
            }
            if (this.atts.containsKey("xyz")) {
                this.is3D = true;
                this.setAtom("xyz");
            } else if (this.atts.containsKey("p")) {
                this.setAtom("p");
            }
            this.asc.addAtomWithMappedName(this.atom);
            if (warning != null) {
                this.atom.atomName = PT.rep(warning, "&apos;", "'");
                this.warningAtom = this.atom;
            } else {
                this.warningAtom = null;
            }
            if (!isConnectionPt && !isNickname) {
                this.asc.bsAtoms.set(this.atom.index);
            }
            return;
        }
        if ("s".equals(localName) && this.warningAtom != null) {
            this.setKeepChars(true);
        }
        if ("b".equals(localName)) {
            String atom1 = (String)this.atts.get("b");
            String atom2 = (String)this.atts.get("e");
            boolean invertEnds = false;
            int order = this.atts.containsKey("order") ? this.parseIntStr((String)this.atts.get("order")) : 1;
            String buf = (String)this.atts.get("display");
            if (buf != null) {
                if (buf.equals("WedgeEnd")) {
                    invertEnds = true;
                    order = 1025;
                } else if (buf.equals("WedgeBegin")) {
                    order = 1025;
                } else if (buf.equals("Hash") || buf.equals("WedgedHashBegin")) {
                    order = 1041;
                } else if (buf.equals("WedgedHashEnd")) {
                    invertEnds = true;
                    order = 1041;
                }
            }
            this.bonds.addLast(new Object[]{invertEnds ? atom2 : atom1, invertEnds ? atom1 : atom2, order});
            return;
        }
    }

    private void setAtom(String key) {
        float z;
        String xyz = (String)this.atts.get(key);
        String[] tokens = PT.getTokens(xyz);
        float x = this.parseFloatStr(tokens[0]);
        float y = -this.parseFloatStr(tokens[1]);
        float f = z = key == "xyz" ? this.parseFloatStr(tokens[2]) : 0.0f;
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        this.atom.set(x, y, z);
    }

    @Override
    void processEndElement(String localName) {
        if ("s".equals(localName) && this.warningAtom != null) {
            String group = this.chars.toString();
            this.warningAtom.atomName = this.warningAtom.atomName + ": " + group;
            this.parent.appendLoadNote("Warning: " + this.warningAtom.atomName);
            this.warningAtom = null;
        }
        this.setKeepChars(false);
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.fixConnections();
        this.center();
        System.out.println("bsAtoms = " + this.asc.bsAtoms);
        this.asc.setInfo("minimize3D", this.is3D);
        this.set2D();
        this.asc.setInfo("is2D", !this.is3D);
        if (!this.is3D) {
            this.asc.setModelInfoForSet("dimension", "2D", this.asc.iSet);
        }
        this.parent.appendLoadNote("ChemDraw CDXML: " + (this.is3D ? "3D" : "2D"));
    }

    private void fixConnections() {
        int n = this.bonds.size();
        for (int i = 0; i < n; ++i) {
            Atom pt;
            Object[] o = (Object[])this.bonds.get(i);
            Bond b = this.asc.addNewBondFromNames((String)o[0], (String)o[1], (Integer)o[2]);
            if (b == null) continue;
            Atom a1 = this.asc.atoms[b.atomIndex1];
            Atom a2 = this.asc.atoms[b.atomIndex2];
            Atom atom = !this.asc.bsAtoms.get(b.atomIndex1) ? a1 : (pt = !this.asc.bsAtoms.get(b.atomIndex2) ? a2 : null);
            if (pt == null) continue;
            int j = this.asc.bsAtoms.nextSetBit(0);
            while (j >= 0) {
                Atom a = this.asc.atoms[j];
                if (Math.abs(a.x - pt.x) < 0.1f && Math.abs(a.y - pt.y) < 0.1f) {
                    if (pt == a1) {
                        a1 = a;
                        b.atomIndex1 = a1.index;
                        break;
                    }
                    a2 = a;
                    b.atomIndex2 = a2.index;
                    break;
                }
                j = this.asc.bsAtoms.nextSetBit(j + 1);
            }
            b.distance = a1.distance(a2);
        }
    }

    private void center() {
        if (this.minX > this.maxX) {
            return;
        }
        float sum = 0.0f;
        int n = 0;
        if (this.is3D) {
            int i = this.asc.bondCount;
            while (--i >= 0) {
                if (this.asc.atoms[this.asc.bonds[i].atomIndex1].elementNumber <= 1 || this.asc.atoms[this.asc.bonds[i].atomIndex2].elementNumber <= 1) continue;
                sum += this.asc.bonds[i].distance;
                ++n;
            }
        }
        float f = 1.0f;
        if (sum > 0.0f) {
            f = 1.45f * (float)n / sum;
        }
        float cx = (this.maxX + this.minX) / 2.0f;
        float cy = (this.maxY + this.minY) / 2.0f;
        float cz = (this.maxZ + this.minZ) / 2.0f;
        int i = this.asc.ac;
        while (--i >= 0) {
            Atom a = this.asc.atoms[i];
            a.x = (a.x - cx) * f;
            a.y = (a.y - cy) * f;
            a.z = (a.z - cz) * f;
        }
    }
}

