/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.IOException;
import javajs.util.SB;
import jspecview.common.Coordinate;
import jspecview.source.JDXSourceStreamTokenizer;
import org.jmol.util.Logger;

public class JDXDecompressor {
    private double xFactor;
    private double yFactor;
    private double deltaX;
    private int nPoints;
    private static final String allDelim = "+-%@ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrs? ,\t\n";
    private int ich;
    private int lineNumber = 0;
    private JDXSourceStreamTokenizer t;
    private double firstX;
    private double dx;
    private double maxY = Double.MIN_VALUE;
    private double minY = Double.MAX_VALUE;
    private boolean debugging;
    private Coordinate[] xyCoords;
    private int ipt;
    private String line;
    private String lastLine;
    private int lineLen;
    private SB errorLog;
    private int difVal = Integer.MIN_VALUE;
    private int lastDif = Integer.MIN_VALUE;
    private int dupCount;
    private double xval;
    private double yval;
    private double[] firstLastX;
    private static final String WHITE_SPACE = " ,\t\n";

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public JDXDecompressor(JDXSourceStreamTokenizer t, double firstX, double xFactor, double yFactor, double deltaX, int nPoints) {
        this.t = t;
        this.firstX = firstX;
        this.xFactor = xFactor;
        this.yFactor = yFactor;
        this.deltaX = deltaX;
        this.nPoints = nPoints;
        this.lineNumber = t.labelLineNo;
        this.debugging = Logger.isActiveLevel(6);
    }

    private void addPoint(Coordinate pt) {
        double d;
        if (this.ipt == this.xyCoords.length) {
            Coordinate[] t = new Coordinate[this.ipt * 2];
            System.arraycopy(this.xyCoords, 0, t, 0, this.ipt);
            this.xyCoords = t;
        }
        if ((d = pt.getYVal()) > this.maxY) {
            this.maxY = d;
        } else if (d < this.minY) {
            this.minY = d;
        }
        if (this.debugging) {
            this.logError("Coord: " + this.ipt + pt);
        }
        this.xyCoords[this.ipt++] = pt;
        this.firstLastX[1] = pt.getXVal();
    }

    public Coordinate[] decompressData(SB errorLog, double[] firstLastX) {
        this.errorLog = errorLog;
        this.firstLastX = firstLastX;
        if (this.debugging) {
            this.logError("firstX=" + this.firstX + " xFactor=" + this.xFactor + " yFactor=" + this.yFactor + " deltaX=" + this.deltaX + " nPoints=" + this.nPoints);
        }
        this.testAlgorithm();
        this.xyCoords = new Coordinate[this.nPoints];
        double difMax = Math.abs(0.35 * this.deltaX);
        double dif14 = Math.abs(1.4 * this.deltaX);
        double dif06 = Math.abs(0.6 * this.deltaX);
        try {
            while ((this.line = this.t.readLineTrimmed()) != null && this.line.indexOf("##") < 0) {
                ++this.lineNumber;
                if (this.debugging) {
                    this.logError(this.lineNumber + "\t" + this.line);
                }
                if ((this.lineLen = this.line.length()) == 0) continue;
                this.ich = 0;
                boolean isCheckPoint = this.lastDif != Integer.MIN_VALUE;
                this.xval = this.getValueDelim() * this.xFactor;
                if (this.ipt == 0) {
                    firstLastX[0] = this.xval;
                    this.dx = this.firstX - this.xval;
                }
                this.xval += this.dx;
                this.yval = this.getYValue();
                Coordinate point = new Coordinate().set(this.xval, this.yval * this.yFactor);
                if (this.ipt == 0) {
                    this.addPoint(point);
                } else {
                    Coordinate lastPoint = this.xyCoords[this.ipt - 1];
                    double xdif = Math.abs(lastPoint.getXVal() - point.getXVal());
                    if (isCheckPoint && xdif < difMax) {
                        this.xyCoords[this.ipt - 1] = point;
                        double y = lastPoint.getYVal();
                        double y1 = point.getYVal();
                        if (y1 != y) {
                            this.logError(this.lastLine + "\n" + this.line + "\nY-value Checkpoint Error! Line " + this.lineNumber + " for y1=" + y1 + " y0=" + y);
                        }
                    } else {
                        this.addPoint(point);
                        if (xdif < dif06 || xdif > dif14) {
                            this.logError(this.lastLine + "\n" + this.line + "\nX-sequence Checkpoint Error! Line " + this.lineNumber + " |x1-x0|=" + xdif + " instead of " + Math.abs(this.deltaX) + " for x1=" + point.getXVal() + " x0=" + lastPoint.getXVal());
                        }
                    }
                }
                while (this.ich < this.lineLen || this.difVal != Integer.MIN_VALUE || this.dupCount > 0) {
                    this.xval += this.deltaX;
                    this.yval = this.getYValue();
                    if (Double.isNaN(this.yval)) continue;
                    this.addPoint(new Coordinate().set(this.xval, this.yval * this.yFactor));
                }
                this.lastLine = this.line;
            }
        }
        catch (IOException isCheckPoint) {
            // empty catch block
        }
        if (this.nPoints != this.ipt) {
            this.logError("Decompressor did not find " + this.nPoints + " points -- instead " + this.ipt);
            Coordinate[] temp = new Coordinate[this.ipt];
            System.arraycopy(this.xyCoords, 0, temp, 0, this.ipt);
            this.xyCoords = temp;
        }
        return this.deltaX > 0.0 ? this.xyCoords : Coordinate.reverse(this.xyCoords);
    }

    private void logError(String s) {
        if (this.debugging) {
            Logger.debug(s);
        }
        this.errorLog.append(s).appendC('\n');
    }

    private double getYValue() {
        if (this.dupCount > 0) {
            --this.dupCount;
            this.yval = this.lastDif == Integer.MIN_VALUE ? this.yval : this.yval + (double)this.lastDif;
            return this.yval;
        }
        if (this.difVal != Integer.MIN_VALUE) {
            this.yval += (double)this.difVal;
            this.lastDif = this.difVal;
            this.difVal = Integer.MIN_VALUE;
            return this.yval;
        }
        if (this.ich == this.lineLen) {
            return Double.NaN;
        }
        char ch = this.line.charAt(this.ich);
        if (this.debugging) {
            Logger.info("" + ch);
        }
        switch (ch) {
            case '%': {
                this.difVal = 0;
                break;
            }
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': {
                this.difVal = ch - 73;
                break;
            }
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': {
                this.difVal = 105 - ch;
                break;
            }
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': {
                this.dupCount = ch - 82;
                break;
            }
            case 's': {
                this.dupCount = 9;
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '@': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': {
                this.lastDif = Integer.MIN_VALUE;
                return this.getValue();
            }
            case '?': {
                this.lastDif = Integer.MIN_VALUE;
                return Double.NaN;
            }
            default: {
                ++this.ich;
                this.lastDif = Integer.MIN_VALUE;
                return this.getYValue();
            }
        }
        ++this.ich;
        if (this.difVal != Integer.MIN_VALUE) {
            this.difVal = this.getDifDup(this.difVal);
        } else {
            this.dupCount = this.getDifDup(this.dupCount) - 1;
        }
        return this.getYValue();
    }

    private int getDifDup(int i) {
        int ich0 = this.ich;
        this.next();
        String s = i + this.line.substring(ich0, this.ich);
        return ich0 == this.ich ? i : Integer.valueOf(s);
    }

    private double getValue() {
        int ich0 = this.ich;
        if (this.ich == this.lineLen) {
            return Double.NaN;
        }
        char ch = this.line.charAt(this.ich);
        int leader = 0;
        switch (ch) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.getValueDelim();
            }
            case '@': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': {
                leader = ch - 64;
                ich0 = ++this.ich;
                break;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': {
                leader = 96 - ch;
                ich0 = ++this.ich;
                break;
            }
            default: {
                ++this.ich;
                return this.getValue();
            }
        }
        this.next();
        return Double.valueOf(leader + this.line.substring(ich0, this.ich));
    }

    private double getValueDelim() {
        int ich0 = this.ich;
        int ch = 0;
        while (this.ich < this.lineLen) {
            char c = this.line.charAt(this.ich);
            ch = c;
            if (WHITE_SPACE.indexOf(c) < 0) break;
            ++this.ich;
        }
        double factor = 1.0;
        switch (ch) {
            case 45: {
                factor = -1.0;
            }
            case 43: {
                ich0 = ++this.ich;
            }
        }
        ch = this.next();
        if (ch == 69 && this.ich + 3 < this.lineLen) {
            switch (this.line.charAt(this.ich + 1)) {
                case '+': 
                case '-': {
                    this.ich += 4;
                    if (this.ich >= this.lineLen) break;
                    char c = this.line.charAt(this.ich);
                    ch = c;
                    if (c < '0' || ch > 57) break;
                    ++this.ich;
                }
            }
        }
        return factor * Double.valueOf(this.line.substring(ich0, this.ich));
    }

    private char next() {
        while (this.ich < this.lineLen && allDelim.indexOf(this.line.charAt(this.ich)) < 0) {
            ++this.ich;
        }
        return this.ich == this.lineLen ? (char)'\u0000' : this.line.charAt(this.ich);
    }

    private void testAlgorithm() {
    }
}

