/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.ByteArrayInputStream;
import java.util.Map;
import javajs.J2SIgnoreImport;
import javajs.util.AU;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.jmol.api.JmolAudioPlayer;
import org.jmol.api.js.JSmolAppletObject;
import org.jmol.api.js.JmolToJSmolInterface;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

@J2SIgnoreImport(value={AudioInputStream.class, AudioSystem.class, Clip.class, Line.class, LineEvent.class, LineListener.class})
public class JmolAudio
implements LineListener,
JmolAudioPlayer {
    private static final int MAX_LOOP = 10;
    private Map<String, Object> params;
    private Clip myClip;
    private String fileName;
    private Viewer vwr;
    private String id;
    private static int idCount;
    private boolean autoClose;

    public void playAudio(Viewer vwr, Map<String, Object> htParams) {
        try {
            this.id = (String)htParams.get("id");
            if (this.id == null || this.id.length() == 0) {
                this.autoClose = true;
                this.id = "audio" + ++idCount;
                htParams.put("id", this.id);
            }
            this.vwr = vwr;
            this.params = htParams;
            this.params.put("audioPlayer", this);
            this.fileName = (String)htParams.get("audioFile");
            vwr.sm.registerAudio(this.id, htParams);
            JSmolAppletObject applet = vwr.html5Applet;
            JmolToJSmolInterface jmol = Viewer.jmolObject;
            if (jmol == null) {
                this.getClip();
            } else {
                jmol.playAudio(applet, htParams);
            }
            if (this.myClip == null) {
                return;
            }
            if (htParams.containsKey("action")) {
                this.action((String)htParams.get("action"));
            } else if (htParams.containsKey("loop")) {
                this.action("loop");
            } else {
                this.autoClose = true;
                this.action("start");
            }
        }
        catch (Exception e) {
            Logger.info("File " + this.fileName + " could not be opened as an audio file");
        }
    }

    private void getClip() throws Exception {
        Object data = this.vwr.fm.getFileAsBytes(this.fileName, null);
        if (!AU.isAB(data)) {
            Logger.info("File " + this.fileName + " " + data);
            return;
        }
        this.myClip = (Clip)AudioSystem.getLine(new Line.Info(Clip.class));
        this.myClip.addLineListener(this);
        this.myClip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream((byte[])data)));
    }

    @Override
    public void update(LineEvent le) {
        this.processUpdate(le.getType().toString());
    }

    public void processUpdate(String type) {
        Logger.info("audio id " + this.id + " " + this.fileName + " " + type);
        if (type == "open" || type == "Open") {
            this.params.put("status", "open");
        } else if (type == "play" || type == "Start") {
            this.params.put("status", "play");
        } else if (type == "pause" || type == "Stop") {
            this.params.put("status", "pause");
            if (this.autoClose) {
                this.myClip.close();
            }
        } else if (type == "ended" || type == "Close") {
            this.params.put("status", "ended");
        } else {
            this.params.put("status", type);
        }
        this.vwr.sm.notifyAudioStatus(this.params);
    }

    @Override
    public void action(String action) {
        if (this.myClip == null) {
            if (action == "kill") {
                return;
            }
            this.params.put("status", "ended");
            this.vwr.sm.notifyAudioStatus(this.params);
            return;
        }
        try {
            if ("start".equals(action)) {
                this.myClip.setMicrosecondPosition(0L);
                this.myClip.loop(0);
                this.myClip.start();
            } else if ("loop".equals(action)) {
                this.myClip.setMicrosecondPosition(0L);
                this.myClip.loop(10);
                this.myClip.start();
            } else if ("pause".equals(action)) {
                if (this.myClip != null) {
                    this.myClip.stop();
                }
            } else if ("play".equals(action)) {
                this.myClip.stop();
                this.myClip.start();
            } else if ("close".equals(action)) {
                this.myClip.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

