/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import org.jruby.RubySymbol;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.interpreter.InterpreterEngine;
import org.jruby.ir.interpreter.StartupInterpreterEngine;
import org.jruby.ir.representations.CFG;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;

public class InterpreterContext {
    private static final Instr[] NO_INSTRUCTIONS = new Instr[0];
    private static final InterpreterEngine DEFAULT_INTERPRETER = new InterpreterEngine();
    private static final InterpreterEngine STARTUP_INTERPRETER = new StartupInterpreterEngine();
    protected int temporaryVariableCount;
    protected Instr[] instructions;
    protected int[] rescueIPCs = null;
    protected boolean hasExplicitCallProtocol;
    protected boolean dynamicScopeEliminated;
    private boolean reuseParentDynScope;
    private boolean metaClassBodyScope;
    private InterpreterEngine engine;
    public final Supplier<List<Instr>> instructionsCallback;
    private EnumSet<IRFlags> flags;
    private final IRScope scope;

    public InterpreterContext(IRScope scope, List<Instr> instructions, int temporaryVariableCount, EnumSet<IRFlags> flags2) {
        this.scope = scope;
        this.engine = instructions == null ? DEFAULT_INTERPRETER : STARTUP_INTERPRETER;
        this.metaClassBodyScope = scope instanceof IRMetaClassBody;
        this.setInstructions(instructions);
        this.instructionsCallback = null;
        this.temporaryVariableCount = temporaryVariableCount;
        this.flags = flags2;
    }

    public InterpreterContext(IRScope scope, Supplier<List<Instr>> instructions, int temporaryVariableCount, EnumSet<IRFlags> flags2) {
        this.scope = scope;
        this.metaClassBodyScope = scope instanceof IRMetaClassBody;
        this.instructionsCallback = instructions;
        this.temporaryVariableCount = temporaryVariableCount;
        this.flags = flags2;
    }

    protected void initialize() {
        if (this.instructions == null) {
            this.getEngine();
        }
    }

    public InterpreterEngine getEngine() {
        if (this.engine == null) {
            this.setInstructions(this.instructionsCallback.get());
            this.engine = this.instructions == null ? DEFAULT_INTERPRETER : STARTUP_INTERPRETER;
        }
        return this.engine;
    }

    public Instr[] getInstructions() {
        this.initialize();
        return this.instructions == null ? NO_INSTRUCTIONS : this.instructions;
    }

    private void setInstructions(List<Instr> instructions) {
        this.instructions = instructions != null ? this.prepareBuildInstructions(instructions) : null;
    }

    private Instr[] prepareBuildInstructions(List<Instr> instructions) {
        int length2 = instructions.size();
        Instr[] linearizedInstrArray = instructions.toArray(new Instr[length2]);
        for (int ipc = 0; ipc < length2; ++ipc) {
            Instr i2 = linearizedInstrArray[ipc];
            if (!(i2 instanceof LabelInstr)) continue;
            ((LabelInstr)i2).getLabel().setTargetPC(ipc + 1);
        }
        ArrayDeque<Integer> markers = new ArrayDeque<Integer>(8);
        this.rescueIPCs = new int[length2];
        int rpc = -1;
        for (int ipc = 0; ipc < length2; ++ipc) {
            Instr i3 = linearizedInstrArray[ipc];
            if (i3 instanceof ExceptionRegionStartMarkerInstr) {
                rpc = ((ExceptionRegionStartMarkerInstr)i3).getFirstRescueBlockLabel().getTargetPC();
                markers.push(rpc);
            } else if (i3 instanceof ExceptionRegionEndMarkerInstr) {
                markers.pop();
                rpc = markers.isEmpty() ? -1 : (Integer)markers.peek();
            }
            this.rescueIPCs[ipc] = rpc;
        }
        return linearizedInstrArray;
    }

    public int[] getRescueIPCs() {
        return this.rescueIPCs;
    }

    public int getRequiredArgsCount() {
        return this.getStaticScope().getSignature().required();
    }

    public IRScope getScope() {
        return this.scope;
    }

    public CFG getCFG() {
        return null;
    }

    public int getTemporaryVariableCount() {
        return this.temporaryVariableCount;
    }

    public Object[] allocateTemporaryVariables() {
        return this.temporaryVariableCount > 0 ? new Object[this.temporaryVariableCount] : null;
    }

    public boolean[] allocateTemporaryBooleanVariables() {
        return null;
    }

    public long[] allocateTemporaryFixnumVariables() {
        return null;
    }

    public double[] allocateTemporaryFloatVariables() {
        return null;
    }

    public StaticScope getStaticScope() {
        return this.scope.getStaticScope();
    }

    public String getFileName() {
        return this.scope.getFile();
    }

    public int getLine() {
        return this.scope.getLine();
    }

    public RubySymbol getName() {
        return this.scope.getManager().getRuntime().newSymbol(this.scope.getId());
    }

    public void computeScopeFlagsFromInstructions() {
        for (Instr instr : this.getInstructions()) {
            instr.computeScopeFlags(this.scope, this.getFlags());
        }
    }

    public DynamicScope newDynamicScope(ThreadContext context) {
        if (this.metaClassBodyScope) {
            return DynamicScope.newDynamicScope(this.getStaticScope(), context.getCurrentScope());
        }
        return DynamicScope.newDynamicScope(this.getStaticScope());
    }

    public boolean hasExplicitCallProtocol() {
        this.initialize();
        return this.hasExplicitCallProtocol;
    }

    public void setExplicitCallProtocol(boolean callProtocol) {
        this.hasExplicitCallProtocol = callProtocol;
    }

    public boolean isDynamicScopeEliminated() {
        return this.dynamicScopeEliminated;
    }

    public void setDynamicScopeEliminated(boolean dynamicScopeEliminated) {
        this.dynamicScopeEliminated = dynamicScopeEliminated;
    }

    public boolean pushNewDynScope() {
        this.initialize();
        return !this.dynamicScopeEliminated && !this.reuseParentDynScope;
    }

    public boolean reuseParentDynScope() {
        this.initialize();
        return this.reuseParentDynScope;
    }

    public void setReuseParentDynScope(boolean reuseParentDynScope) {
        this.reuseParentDynScope = reuseParentDynScope;
    }

    public boolean popDynScope() {
        this.initialize();
        return this.pushNewDynScope() || this.reuseParentDynScope();
    }

    public boolean receivesKeywordArguments() {
        return this.scope.receivesKeywordArgs();
    }

    public boolean isRuby2Keywords() {
        return this.scope.isRuby2Keywords();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getFileName()).append(':').append(this.scope.getLine());
        if (this.getName() != null) {
            buf.append(' ').append(this.getName()).append("\n");
        }
        if (this.getInstructions() == null) {
            buf.append("  No Instructions.  Full Build before linearizeInstr?");
        } else {
            buf.append(this.toStringInstrs()).append("\n");
        }
        return buf.toString();
    }

    public String toStringInstrs() {
        StringBuilder b2 = new StringBuilder();
        int length2 = this.instructions.length;
        for (int i2 = 0; i2 < length2; ++i2) {
            if (i2 > 0) {
                b2.append("\n");
            }
            b2.append(String.format("%6d", i2)).append('\t').append(this.instructions[i2]);
        }
        return b2.toString();
    }

    public EnumSet<IRFlags> getFlags() {
        return this.flags;
    }
}

