/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lang.DisposedException;
import com.sun.star.lib.uno.environments.remote.JavaThreadPoolFactory;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.uno.RuntimeException;
import java.util.ArrayList;

public class JobQueue {
    private static final boolean DEBUG = false;
    final ArrayList<Job> jobList = new ArrayList();
    private ThreadId _threadId;
    protected int _ref_count = 0;
    private boolean _createThread;
    private boolean _createThread_now;
    private Thread _worker_thread;
    private Object _disposeId;
    private Object _doDispose = null;
    private Throwable _throwable;
    JobQueue _async_jobQueue;
    protected JobQueue _sync_jobQueue;
    private boolean _active = false;
    private JavaThreadPoolFactory _javaThreadPoolFactory;

    JobQueue(JavaThreadPoolFactory javaThreadPoolFactory, ThreadId threadId) {
        this._javaThreadPoolFactory = javaThreadPoolFactory;
        this._threadId = ThreadId.createFresh();
        this._sync_jobQueue = javaThreadPoolFactory.getJobQueue(threadId);
        if (this._sync_jobQueue == null) {
            this._sync_jobQueue = new JobQueue(javaThreadPoolFactory, threadId, true);
            this._sync_jobQueue.acquire();
        }
        this._sync_jobQueue._async_jobQueue = this;
        this._createThread = true;
        this._createThread_now = true;
        this.acquire();
    }

    JobQueue(JavaThreadPoolFactory javaThreadPoolFactory, ThreadId threadId, boolean createThread) {
        this._javaThreadPoolFactory = javaThreadPoolFactory;
        this._threadId = threadId;
        this._createThread = createThread;
        this._createThread_now = createThread;
    }

    ThreadId getThreadId() {
        return this._threadId;
    }

    synchronized void acquire() {
        if (this._ref_count <= 0 && this._sync_jobQueue == null) {
            this._javaThreadPoolFactory.addJobQueue(this);
        }
        ++this._ref_count;
    }

    synchronized void release() {
        --this._ref_count;
        if (this._ref_count <= 0) {
            if (this._sync_jobQueue == null) {
                this._javaThreadPoolFactory.removeJobQueue(this);
            }
            if (this._sync_jobQueue != null) {
                this._sync_jobQueue._async_jobQueue = null;
                this._sync_jobQueue.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job removeJob(int waitTime) {
        Job job = null;
        JobQueue jobQueue = this;
        synchronized (jobQueue) {
            boolean waited = false;
            while (this.jobList.isEmpty() && (waitTime == 0 || !waited)) {
                if (this._doDispose == this._disposeId) {
                    this._doDispose = null;
                    throw (DisposedException)new DisposedException().initCause(this._throwable);
                }
                this.notifyAll();
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(this.getClass().getName() + ".removeJob - unexpected:" + interruptedException);
                }
                waited = true;
            }
            if (!this.jobList.isEmpty()) {
                job = this.jobList.remove(0);
                this._active = true;
            }
        }
        if (job != null && this._async_jobQueue != null) {
            jobQueue = this._async_jobQueue;
            synchronized (jobQueue) {
                while (this._async_jobQueue._active || !this._async_jobQueue.jobList.isEmpty()) {
                    if (this._doDispose == this._disposeId) {
                        this._doDispose = null;
                        throw (DisposedException)new DisposedException().initCause(this._throwable);
                    }
                    try {
                        this._async_jobQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(this.getClass().getName() + ".removeJob - unexpected:" + interruptedException);
                    }
                }
            }
        }
        return job;
    }

    synchronized void putJob(Job job, Object disposeId) {
        this.jobList.add(job);
        if (this._worker_thread == null && this._createThread && this._createThread_now) {
            this.acquire();
            this._createThread_now = false;
            new JobDispatcher(disposeId).start();
        }
        this.notifyAll();
    }

    Object enter(Object disposeId) throws Throwable {
        return this.enter(0, disposeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object enter(int waitTime, Object disposeId) throws Throwable {
        boolean quit = false;
        Object hold_disposeId = this._disposeId;
        this._disposeId = disposeId;
        Object result = null;
        Thread hold_worker_thread = this._worker_thread;
        this._worker_thread = Thread.currentThread();
        while (!quit) {
            Job job = null;
            try {
                job = this.removeJob(waitTime);
                if (job != null) {
                    try {
                        result = job.execute();
                    }
                    finally {
                        this._active = false;
                    }
                    if (!job.isRequest()) {
                        job.dispose();
                        quit = true;
                    }
                    job = null;
                    continue;
                }
                quit = true;
            }
            finally {
                JobQueue jobQueue = this;
                synchronized (jobQueue) {
                    if (job != null || quit && this.jobList.isEmpty()) {
                        this._worker_thread = hold_worker_thread;
                        this._createThread_now = true;
                        this._disposeId = hold_disposeId;
                        if (this._sync_jobQueue != null) {
                            this.notifyAll();
                        }
                    } else {
                        quit = false;
                    }
                }
            }
        }
        return result;
    }

    synchronized void dispose(Object disposeId, Throwable throwable) {
        if (this._sync_jobQueue == null) {
            this._doDispose = disposeId;
            this._throwable = throwable;
            this.notifyAll();
        }
    }

    class JobDispatcher
    extends Thread {
        Object _disposeId;

        JobDispatcher(Object disposeId) {
            super("JobDispatcher");
            this._disposeId = disposeId;
        }

        ThreadId getThreadId() {
            return JobQueue.this._threadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                JobQueue.this.enter(2000, this._disposeId);
            }
            catch (Throwable throwable) {
                JobQueue jobQueue = JobQueue.this;
                synchronized (jobQueue) {
                    if (!JobQueue.this.jobList.isEmpty() || JobQueue.this._active) {
                        System.err.println(this.getClass().getName() + " - exception occurred:" + throwable);
                        throwable.printStackTrace(System.err);
                    }
                }
            }
            finally {
                JobQueue.this.release();
            }
        }
    }
}

