/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.jsonrpc.io;

import org.directwebremoting.jsonrpc.io.JsonRpcCalls;

public class JsonRpcCallException
extends RuntimeException {
    private final String id;
    private final String version;
    private final int jsonRpcErrorCode;
    private final int httpStatusCode;
    private final Object data;

    public JsonRpcCallException(String id, String version, String reason, int jsonRpcErrorCode, int httpStatusCode, String data) {
        super(reason);
        this.jsonRpcErrorCode = jsonRpcErrorCode;
        this.httpStatusCode = httpStatusCode;
        this.id = id;
        this.version = version;
        this.data = data;
    }

    public JsonRpcCallException(String id, String version, String reason, int jsonRpcErrorCode, int httpStatusCode) {
        super(reason);
        this.jsonRpcErrorCode = jsonRpcErrorCode;
        this.httpStatusCode = httpStatusCode;
        this.id = id;
        this.version = version;
        this.data = null;
    }

    public JsonRpcCallException(JsonRpcCalls calls, String reason, int jsonRpcErrorCode, int httpStatusCode) {
        super(reason);
        this.jsonRpcErrorCode = jsonRpcErrorCode;
        this.httpStatusCode = httpStatusCode;
        this.id = calls.getBatchId();
        this.version = calls.getVersion();
        this.data = null;
    }

    public int getJsonRpcErrorCode() {
        return this.jsonRpcErrorCode;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getId() {
        return this.id;
    }

    public Object getData() {
        return this.data;
    }

    public String getVersion() {
        return this.version;
    }
}

