/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.klimt.creole.Display;

public final class Page {
    private final double headerHeight;
    private final double newpage1;
    private final double newpage2;
    private final double tailHeight;
    private final double signatureHeight;
    private final Display title;

    public String toString() {
        return "headerHeight=" + this.headerHeight + " newpage1=" + this.newpage1 + " newpage2=" + this.newpage2;
    }

    public Page(double headerHeight, double newpage1, double newpage2, double tailHeight, double signatureHeight, Display title) {
        if (headerHeight < 0.0) {
            throw new IllegalArgumentException();
        }
        if (tailHeight < 0.0) {
            throw new IllegalArgumentException();
        }
        if (signatureHeight < 0.0) {
            throw new IllegalArgumentException();
        }
        if (newpage1 > newpage2) {
            throw new IllegalArgumentException();
        }
        this.headerHeight = headerHeight;
        this.newpage1 = newpage1;
        this.newpage2 = newpage2;
        this.tailHeight = tailHeight;
        this.signatureHeight = signatureHeight;
        this.title = title;
    }

    public double getHeight() {
        return this.headerHeight + this.getBodyHeight() + this.tailHeight + this.signatureHeight;
    }

    public double getHeaderRelativePosition() {
        return 0.0;
    }

    public double getBodyRelativePosition() {
        return this.getHeaderRelativePosition() + this.headerHeight;
    }

    public double getBodyHeight() {
        return this.newpage2 - this.newpage1;
    }

    public double getTailRelativePosition() {
        return this.getBodyRelativePosition() + this.getBodyHeight();
    }

    public double getSignatureRelativePosition() {
        if (!this.displaySignature()) {
            return -1.0;
        }
        return this.getTailRelativePosition() + this.tailHeight;
    }

    public boolean displaySignature() {
        return this.signatureHeight > 0.0;
    }

    public double getNewpage1() {
        return this.newpage1;
    }

    public double getNewpage2() {
        return this.newpage2;
    }

    public double getHeaderHeight() {
        return this.headerHeight;
    }

    public final Display getTitle() {
        return this.title;
    }
}

