/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import java.io.IOException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.SessionConfig;
import org.apache.catalina.valves.ValveBase;

public class LoadBalancerDrainingValve
extends ValveBase {
    public static final String ATTRIBUTE_KEY_JK_LB_ACTIVATION = "JK_LB_ACTIVATION";
    private int _redirectStatusCode = 307;
    private String _ignoreCookieName;
    private String _ignoreCookieValue;

    public LoadBalancerDrainingValve() {
        super(true);
    }

    public void setRedirectStatusCode(int n) {
        this._redirectStatusCode = n;
    }

    public String getIgnoreCookieName() {
        return this._ignoreCookieName;
    }

    public void setIgnoreCookieName(String string) {
        this._ignoreCookieName = string;
    }

    public String getIgnoreCookieValue() {
        return this._ignoreCookieValue;
    }

    public void setIgnoreCookieValue(String string) {
        this._ignoreCookieValue = string;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if ("DIS".equals(request.getAttribute(ATTRIBUTE_KEY_JK_LB_ACTIVATION)) && !request.isRequestedSessionIdValid()) {
            String string;
            String string2;
            Object object;
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)"Load-balancer is in DISABLED state; draining this node");
            }
            boolean bl = false;
            Cookie cookie = null;
            Cookie[] cookieArray = request.getCookies();
            String string3 = SessionConfig.getSessionCookieName(request.getContext());
            if (null != cookieArray) {
                object = cookieArray;
                int n = ((Cookie[])object).length;
                for (int i = 0; i < n; ++i) {
                    Cookie cookie2 = object[i];
                    String string4 = cookie2.getName();
                    if (this.containerLog.isTraceEnabled()) {
                        this.containerLog.trace((Object)("Checking cookie " + string4 + "=" + cookie2.getValue()));
                    }
                    if (string3.equals(string4) && request.getRequestedSessionId().equals(cookie2.getValue())) {
                        cookie = cookie2;
                        continue;
                    }
                    if (null == this._ignoreCookieName || !this._ignoreCookieName.equals(string4) || null == this._ignoreCookieValue || !this._ignoreCookieValue.equals(cookie2.getValue())) continue;
                    bl = true;
                }
            }
            if (bl) {
                if (this.containerLog.isDebugEnabled()) {
                    this.containerLog.debug((Object)("Client is presenting a valid " + this._ignoreCookieName + " cookie, re-balancing is being skipped"));
                }
                this.getNext().invoke(request, response);
                return;
            }
            if (null != cookie) {
                cookie.setPath(SessionConfig.getSessionCookiePath(request.getContext()));
                cookie.setMaxAge(0);
                cookie.setValue("");
                object = request.getContext().getServletContext().getSessionCookieConfig();
                cookie.setSecure(request.isSecure() || object.isSecure());
                response.addCookie(cookie);
            }
            if (((String)(object = request.getRequestURI())).contains(";" + (string2 = SessionConfig.getSessionUriParamName(request.getContext())) + "=")) {
                object = ((String)object).replaceFirst(";" + string2 + "=[^&?]*", "");
            }
            if (null != (string = request.getQueryString())) {
                object = (String)object + "?" + string;
            }
            response.setHeader("Location", (String)object);
            response.setStatus(this._redirectStatusCode);
        } else {
            this.getNext().invoke(request, response);
        }
    }
}

