/// <reference types="node" />
import { Fz, Definition, KeyValue, KeyValueAny } from './types';
declare type Day = 'mon' | 'tue' | 'wed' | 'thu' | 'fri' | 'sat' | 'sun';
export interface TrvScheduleConfigEvent {
    time: number;
    temperature: number;
}
export interface TrvScheduleConfig {
    days: Day[];
    events: TrvScheduleConfigEvent[];
}
export declare const VOCKQJK11LMDisplayUnit: {
    mgm3_celsius: number;
    ppb_celsius: number;
    mgm3_fahrenheit: number;
    ppb_fahrenheit: number;
};
export declare const fp1: {
    constants: {
        region_event_key: number;
        region_event_types: {
            Enter: number;
            Leave: number;
            Occupied: number;
            Unoccupied: number;
        };
        region_config_write_attribute: number;
        region_config_write_attribute_type: number;
        region_config_cmds: {
            /**
             * Creates new region (or force replaces existing one)
             * with new zones definition.
             */
            create: number;
            /**
             * Modifies existing region.
             * Note: unused, as it seems to break existing regions
             * (region stops reporting new detection events).
             * Use "create" instead, as it replaces existing region with new one.
             */
            modify: number;
            /**
             * Deletes existing region.
             */
            delete: number;
        };
        region_config_regionId_min: number;
        region_config_regionId_max: number;
        region_config_zoneY_min: number;
        region_config_zoneY_max: number;
        region_config_zoneX_min: number;
        region_config_zoneX_max: number;
        region_config_cmd_suffix_upsert: number;
        region_config_cmd_suffix_delete: number;
    };
    mappers: {
        aqara_fp1: {
            region_event_type_names: {
                [x: number]: string;
            };
        };
    };
    /**
     * @param {undefined | Set<number>} xCells
     * @return {number}
     */
    encodeXCellsDefinition: (xCells: number[]) => number;
    /**
     * @param {number} cellXIdx
     * @return {number}
     */
    encodeXCellIdx: (cellXIdx: number) => number;
    /**
     * @param {unknown} input
     */
    parseAqaraFp1RegionDeleteInput: (input: KeyValueAny) => {
        isSuccess: boolean;
        error: {
            reason: string;
        };
    } | {
        /** @type true */
        isSuccess: boolean;
        payload: {
            command: {
                region_id: any;
            };
        };
    };
    /**
     * @param {unknown} input
     */
    parseAqaraFp1RegionUpsertInput: (input: KeyValueAny) => {
        isSuccess: boolean;
        error: {
            reason: string;
        };
    } | {
        /** @type true */
        isSuccess: boolean;
        payload: {
            command: {
                region_id: any;
                zones: any[];
            };
        };
    };
    /**
     * @param {unknown} value
     * @returns {value is number}
     */
    isAqaraFp1RegionId: (value: number) => boolean;
    /**
     * @param {unknown} value
     * @returns {value is AqaraFP1RegionZone}
     */
    isAqaraFp1RegionZoneDefinition: (value: KeyValueAny) => boolean;
    /**
     * @template {Record<string, unknown>} ErrorType
     * @param {ErrorType} error
     * @return { { isSuccess: false, error: ErrorType } }
     */
    failure: (error: {
        reason: string;
    }) => {
        isSuccess: boolean;
        error: {
            reason: string;
        };
    };
};
export declare const trv: {
    decodeFirmwareVersionString(value: number): string;
    decodePreset(value: number): {
        setup: boolean;
        preset: string;
    };
    decodeHeartbeat(meta: Fz.Meta, model: Definition, messageBuffer: Buffer): KeyValue;
    /**
     * Decode a Zigbee schedule configuration message into a schedule configuration object.
     * @param {Buffer} buffer
     * @return {TrvScheduleConfig}
     */
    decodeSchedule(buffer: Buffer): TrvScheduleConfig;
    /**
     * @param {TrvScheduleConfig} schedule
     * @return {void}
     */
    validateSchedule(schedule: TrvScheduleConfig): void;
    /**
     * Encodes a schedule object into Zigbee message format.
     * @param {TrvScheduleConfig} schedule
     * @return {Buffer}
     */
    encodeSchedule(schedule: KeyValueAny): Buffer;
    stringifySchedule(schedule: TrvScheduleConfig): string;
    parseSchedule(stringifiedSchedule: string): TrvScheduleConfig;
};
export declare const manufacturerCode = 4447;
export {};
//# sourceMappingURL=xiaomi.d.ts.map