/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.tasks;

import java.util.Objects;
import org.opensearch.client.tasks.OpenSearchException;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.XContentParser;

public class TaskOperationFailure {
    private final String nodeId;
    private final long taskId;
    private final OpenSearchException reason;
    private final String status;
    private static final ConstructingObjectParser<TaskOperationFailure, Void> PARSER = new ConstructingObjectParser("task_info", true, constructorObjects -> {
        int i = 0;
        String nodeId = (String)constructorObjects[i++];
        long taskId = (Long)constructorObjects[i++];
        String status = (String)constructorObjects[i++];
        OpenSearchException reason = (OpenSearchException)constructorObjects[i];
        return new TaskOperationFailure(nodeId, taskId, status, reason);
    });

    public TaskOperationFailure(String nodeId, long taskId, String status, OpenSearchException reason) {
        this.nodeId = nodeId;
        this.taskId = taskId;
        this.status = status;
        this.reason = reason;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public OpenSearchException getReason() {
        return this.reason;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskOperationFailure)) {
            return false;
        }
        TaskOperationFailure that = (TaskOperationFailure)o;
        return this.getTaskId() == that.getTaskId() && Objects.equals(this.getNodeId(), that.getNodeId()) && Objects.equals(this.getReason(), that.getReason()) && Objects.equals(this.getStatus(), that.getStatus());
    }

    public int hashCode() {
        return Objects.hash(this.getNodeId(), this.getTaskId(), this.getReason(), this.getStatus());
    }

    public String toString() {
        return "TaskOperationFailure{nodeId='" + this.nodeId + "', taskId=" + this.taskId + ", reason=" + this.reason + ", status='" + this.status + "'}";
    }

    public static TaskOperationFailure fromXContent(XContentParser parser) {
        return (TaskOperationFailure)PARSER.apply(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("node_id", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("task_id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("status", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, c) -> OpenSearchException.fromXContent(parser), new ParseField("reason", new String[0]));
    }
}

