/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Arrays;
import java.util.Comparator;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.MeshSurface;

public class MeshData
extends MeshSurface {
    public static final int MODE_GET_VERTICES = 1;
    public static final int MODE_GET_COLOR_INDEXES = 2;
    public static final int MODE_PUT_SETS = 3;
    public static final int MODE_PUT_VERTICES = 4;
    private boolean setsSuccessful;
    public int vertexIncrement = 1;
    public String polygonColorData;

    public int addVertexCopy(T3 vertex, float value, int assocVertex, boolean asCopy) {
        if (assocVertex < 0) {
            this.vertexIncrement = -assocVertex;
        }
        return this.addVCVal(vertex, value, asCopy);
    }

    public BS[] getSurfaceSet() {
        return this.surfaceSet == null ? this.getSurfaceSetForLevel(0) : this.surfaceSet;
    }

    private BS[] getSurfaceSetForLevel(int level) {
        if (level == 0) {
            this.surfaceSet = new BS[100];
            this.nSets = 0;
        }
        this.setsSuccessful = true;
        for (int i = 0; i < this.pc; ++i) {
            if (this.pis[i] == null || this.bsSlabDisplay != null && !this.bsSlabDisplay.get(i)) continue;
            int[] p = this.pis[i];
            int pt0 = this.findSet(p[0]);
            int pt1 = this.findSet(p[1]);
            int pt2 = this.findSet(p[2]);
            if (pt0 < 0 && pt1 < 0 && pt2 < 0) {
                this.createSet(p[0], p[1], p[2]);
                continue;
            }
            if (pt0 == pt1 && pt1 == pt2) continue;
            if (pt0 >= 0) {
                this.surfaceSet[pt0].set(p[1]);
                this.surfaceSet[pt0].set(p[2]);
                if (pt1 >= 0 && pt1 != pt0) {
                    this.mergeSets(pt0, pt1);
                }
                if (pt2 < 0 || pt2 == pt0 || pt2 == pt1) continue;
                this.mergeSets(pt0, pt2);
                continue;
            }
            if (pt1 >= 0) {
                this.surfaceSet[pt1].set(p[0]);
                this.surfaceSet[pt1].set(p[2]);
                if (pt2 < 0 || pt2 == pt1) continue;
                this.mergeSets(pt1, pt2);
                continue;
            }
            this.surfaceSet[pt2].set(p[0]);
            this.surfaceSet[pt2].set(p[1]);
        }
        int n = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null) continue;
            ++n;
        }
        BS[] temp = new BS[this.surfaceSet.length];
        n = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null) continue;
            temp[n++] = this.surfaceSet[i];
        }
        this.nSets = n;
        this.surfaceSet = temp;
        if (!this.setsSuccessful && level < 2) {
            this.getSurfaceSetForLevel(level + 1);
        }
        if (level == 0) {
            int i;
            SSet[] sets = new SSet[this.nSets];
            for (i = 0; i < this.nSets; ++i) {
                sets[i] = new SSet(this.surfaceSet[i]);
            }
            Arrays.sort(sets, new SortSet());
            for (i = 0; i < this.nSets; ++i) {
                this.surfaceSet[i] = sets[i].bs;
            }
            this.setVertexSets(false);
        }
        return this.surfaceSet;
    }

    public void setVertexSets(boolean onlyIfNull) {
        if (this.surfaceSet == null) {
            return;
        }
        int nNull = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] != null && this.surfaceSet[i].nextSetBit(0) < 0) {
                this.surfaceSet[i] = null;
            }
            if (this.surfaceSet[i] != null) continue;
            ++nNull;
        }
        if (nNull > 0) {
            BS[] bsNew = new BS[this.nSets - nNull];
            int n = 0;
            for (int i = 0; i < this.nSets; ++i) {
                if (this.surfaceSet[i] == null) continue;
                bsNew[n++] = this.surfaceSet[i];
            }
            this.surfaceSet = bsNew;
            this.nSets -= nNull;
        } else if (onlyIfNull) {
            return;
        }
        this.vertexSets = new int[this.vc];
        for (int i = 0; i < this.nSets; ++i) {
            int j = this.surfaceSet[i].nextSetBit(0);
            while (j >= 0) {
                this.vertexSets[j] = i;
                j = this.surfaceSet[i].nextSetBit(j + 1);
            }
        }
    }

    private int findSet(int vertex) {
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null || !this.surfaceSet[i].get(vertex)) continue;
            return i;
        }
        return -1;
    }

    private void createSet(int v1, int v2, int v3) {
        int i;
        for (i = 0; i < this.nSets && this.surfaceSet[i] != null; ++i) {
        }
        if (i == this.surfaceSet.length) {
            this.surfaceSet = (BS[])AU.ensureLength(this.surfaceSet, this.surfaceSet.length + 100);
        }
        this.surfaceSet[i] = new BS();
        this.surfaceSet[i].set(v1);
        this.surfaceSet[i].set(v2);
        this.surfaceSet[i].set(v3);
        if (i == this.nSets) {
            ++this.nSets;
        }
    }

    private void mergeSets(int a, int b) {
        this.surfaceSet[a].or(this.surfaceSet[b]);
        this.surfaceSet[b] = null;
    }

    public void invalidateSurfaceSet(int i) {
        int j = this.surfaceSet[i].nextSetBit(0);
        while (j >= 0) {
            this.vvs[j] = Float.NaN;
            j = this.surfaceSet[i].nextSetBit(j + 1);
        }
        this.surfaceSet[i] = null;
    }

    public static boolean checkCutoff(int iA, int iB, int iC, float[] vertexValues) {
        if (iA < 0 || iB < 0 || iC < 0) {
            return false;
        }
        float val1 = vertexValues[iA];
        float val2 = vertexValues[iB];
        float val3 = vertexValues[iC];
        return val1 >= 0.0f && val2 >= 0.0f && val3 >= 0.0f || val1 <= 0.0f && val2 <= 0.0f && val3 <= 0.0f;
    }

    public static Object calculateVolumeOrArea(MeshData m, int thisSet, boolean isArea, boolean getSets) {
        if (getSets || m.nSets <= 0) {
            m.getSurfaceSet();
        }
        boolean justOne = thisSet >= -1;
        int n = justOne || m.nSets <= 0 ? 1 : m.nSets;
        double[] v = new double[n];
        V3 vAB = new V3();
        V3 vAC = new V3();
        V3 vTemp = new V3();
        int i = m.pc;
        while (--i >= 0) {
            int iSet;
            if (m.setABC(i) == null) continue;
            int n2 = iSet = m.nSets <= 0 ? 0 : m.vertexSets[m.iA];
            if (thisSet >= 0 && iSet != thisSet) continue;
            if (isArea) {
                vAB.sub2(m.vs[m.iB], m.vs[m.iA]);
                vAC.sub2(m.vs[m.iC], m.vs[m.iA]);
                vTemp.cross(vAB, vAC);
                int n3 = justOne ? 0 : iSet;
                v[n3] = v[n3] + (double)vTemp.length();
                continue;
            }
            vAB.setT(m.vs[m.iB]);
            vAC.setT(m.vs[m.iC]);
            vTemp.cross(vAB, vAC);
            vAC.setT(m.vs[m.iA]);
            int n4 = justOne ? 0 : iSet;
            v[n4] = v[n4] + (double)vAC.dot(vTemp);
        }
        double factor = isArea ? 2 : 6;
        int i2 = 0;
        while (i2 < n) {
            int n5 = i2++;
            v[n5] = v[n5] / factor;
        }
        if (justOne) {
            return Float.valueOf((float)v[0]);
        }
        return v;
    }

    public void updateInvalidatedVertices(BS bs) {
        bs.clearAll();
        for (int i = 0; i < this.vc; i += this.vertexIncrement) {
            if (!Float.isNaN(this.vvs[i])) continue;
            bs.set(i);
        }
    }

    public void invalidateVertices(BS bsInvalid) {
        int i = bsInvalid.nextSetBit(0);
        while (i >= 0) {
            this.vvs[i] = Float.NaN;
            i = bsInvalid.nextSetBit(i + 1);
        }
    }

    protected class SortSet
    implements Comparator<SSet> {
        protected SortSet() {
        }

        @Override
        public int compare(SSet o1, SSet o2) {
            return o1.n > o2.n ? -1 : (o1.n < o2.n ? 1 : 0);
        }
    }

    private class SSet {
        BS bs;
        int n;

        protected SSet(BS bs) {
            this.bs = bs;
            this.n = bs.cardinality();
        }
    }
}

