/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BSUtil;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class SpaceGroupFinder {
    private static final int MAX_COUNT = 100;
    private static final float SLOP0014 = (float)Math.sqrt(1.96E-6f);
    private static final float SLOP001 = 0.001f;
    private static final float SLOP0001 = 1.0E-4f;
    private static int GROUP_COUNT;
    private static int OP_COUNT;
    private static BS[] bsOpGroups;
    private static BS[] bsGroupOps;
    private static String[] groupNames;
    private static String[] opXYZ;
    private static SymmetryOperation[] ops;
    private static BufferedReader rdr;
    private SGAtom[] atoms;
    private int nAtoms;
    private P3 pt = new P3();

    public Object findSpaceGroup(Viewer vwr, BS atoms0, String xyzList, float[] unitCellParams, SymmetryInterface uc, boolean asString, boolean isAssign) {
        P3[] oabc = null;
        Atom[] cartesians = vwr.ms.at;
        int isg = 0;
        BS bsGroups = new BS();
        BS bsOps = new BS();
        BS bsAtoms = null;
        BS bsPoints0 = new BS();
        if (xyzList == null || isAssign) {
            bsAtoms = BSUtil.copy(atoms0);
            this.nAtoms = bsAtoms.cardinality();
        }
        BS targets = BS.newN(this.nAtoms);
        int n = 0;
        int nChecked = 0;
        P3 scaling = P3.new3(1.0f, 1.0f, 1.0f);
        SpaceGroup sg = null;
        try {
            if (bsOpGroups == null) {
                SpaceGroupFinder.loadData(vwr, this);
            }
            if (xyzList != null) {
                Object ret = this.getGroupsWithOps(xyzList, unitCellParams, isAssign);
                if (!isAssign) {
                    return ret;
                }
                sg = (SpaceGroup)ret;
                uc.setUnitCell(unitCellParams, false);
            }
            oabc = uc.getUnitCellVectors();
            uc = uc.getUnitCellMultiplied();
            this.filterGroups(bsGroups, uc.getUnitCellParams());
            this.atoms = new SGAtom[bsAtoms.cardinality()];
            System.out.println("bsAtoms = " + bsAtoms);
            int p = 0;
            int i = bsAtoms.nextSetBit(0);
            while (i >= 0) {
                Atom a = cartesians[i];
                int type = a.getAtomicAndIsotopeNumber();
                this.atoms[p] = new SGAtom(type, i, a.getAtomName(), a.getOccupancy100());
                this.atoms[p].setT(this.toFractional(a, uc));
                i = bsAtoms.nextSetBit(i + 1);
                ++p;
            }
            BS bsPoints = BSUtil.newBitSet2(0, this.nAtoms);
            SymmetryInterface uc0 = uc;
            this.nAtoms = bsPoints.cardinality();
            uc0 = uc;
            boolean isSupercell = false;
            if (this.nAtoms > 0) {
                int i2 = bsPoints.nextSetBit(0);
                while (i2 >= 0) {
                    SimpleUnitCell.unitizeDim(3, this.atoms[i2]);
                    i2 = bsPoints.nextSetBit(i2 + 1);
                }
                this.removeDuplicates(bsPoints);
                uc = this.checkSupercell(vwr, uc, bsPoints, 1, scaling);
                uc = this.checkSupercell(vwr, uc, bsPoints, 2, scaling);
                uc = this.checkSupercell(vwr, uc, bsPoints, 3, scaling);
                boolean bl = isSupercell = uc != uc0;
                if (isSupercell) {
                    if (scaling.x != 1.0f) {
                        System.out.println("supercell found; a scaled by 1/" + scaling.x);
                    }
                    if (scaling.y != 1.0f) {
                        System.out.println("supercell found; b scaled by 1/" + scaling.y);
                    }
                    if (scaling.z != 1.0f) {
                        System.out.println("supercell found; c scaled by 1/" + scaling.z);
                    }
                }
            }
            n = bsPoints.cardinality();
            bsAtoms = new BS();
            SGAtom[] newAtoms = new SGAtom[n];
            int p2 = 0;
            int i3 = bsPoints.nextSetBit(0);
            while (i3 >= 0) {
                SGAtom a = this.atoms[i3];
                newAtoms[p2++] = a;
                if (isSupercell) {
                    a.setT(this.toFractional(cartesians[a.index], uc));
                    SimpleUnitCell.unitizeDim(3, a);
                }
                bsAtoms.set(this.atoms[i3].index);
                i3 = bsPoints.nextSetBit(i3 + 1);
            }
            this.atoms = newAtoms;
            this.nAtoms = n;
            System.out.println("bsAtoms(within cell) = " + bsAtoms);
            bsPoints.clearAll();
            bsPoints.setBits(0, this.nAtoms);
            bsPoints0 = BS.copy(bsPoints);
            BS temp1 = BS.newN(OP_COUNT);
            BS targeted = BS.newN(this.nAtoms);
            bsOps.setBits(1, sg == null ? OP_COUNT : sg.getOperationCount());
            if (this.nAtoms == 0) {
                bsGroups.clearBits(1, GROUP_COUNT);
                bsOps.clearAll();
            }
            BS uncheckedOps = BS.newN(OP_COUNT);
            BS opsChecked = BS.newN(OP_COUNT);
            opsChecked.set(0);
            boolean hasC1 = false;
            int iop = bsOps.nextSetBit(1);
            while (iop > 0 && !bsGroups.isEmpty()) {
                SymmetryOperation op;
                SymmetryOperation symmetryOperation = op = sg == null ? SpaceGroupFinder.getOp(iop) : (SymmetryOperation)sg.getOperation(iop);
                if (sg == null) {
                    System.out.println("\nChecking operation " + iop + " " + opXYZ[iop]);
                    System.out.println("bsGroups = " + bsGroups);
                    System.out.println("bsOps = " + bsOps);
                    ++nChecked;
                }
                boolean isOK = true;
                bsPoints.clearAll();
                bsPoints.or(bsPoints0);
                targeted.clearAll();
                int i4 = bsPoints.nextSetBit(0);
                while (i4 >= 0) {
                    bsPoints.clear(i4);
                    int j = this.findEquiv(iop, op, i4, bsPoints, this.pt, true);
                    if (j < 0 && sg == null) {
                        System.out.println("failed op " + iop + " for atom " + i4 + " " + this.atoms[i4].name + " " + this.atoms[i4] + " looking for " + this.pt + "\n" + op);
                        isOK = false;
                        break;
                    }
                    if (j >= 0 && i4 != j) {
                        targeted.set(j);
                    }
                    i4 = bsPoints.nextSetBit(i4 + 1);
                }
                if (sg == null) {
                    int i5;
                    BS myGroups = bsOpGroups[iop];
                    bsOps.clear(iop);
                    opsChecked.set(iop);
                    if (isOK) {
                        System.out.println("OK!");
                        if (iop == 1) {
                            hasC1 = true;
                        }
                        targets.or(targeted);
                        bsGroups.and(myGroups);
                        temp1.setBits(1, OP_COUNT);
                        i5 = bsGroups.nextSetBit(0);
                        while (i5 >= 0) {
                            temp1.and(bsGroupOps[i5]);
                            i5 = bsGroups.nextSetBit(i5 + 1);
                        }
                        uncheckedOps.or(temp1);
                        bsOps.andNot(temp1);
                    } else {
                        bsGroups.andNot(myGroups);
                        temp1.clearAll();
                        i5 = bsGroups.nextSetBit(0);
                        while (i5 >= 0) {
                            temp1.or(bsGroupOps[i5]);
                            i5 = bsGroups.nextSetBit(i5 + 1);
                        }
                        bsOps.and(temp1);
                    }
                } else {
                    targets.or(targeted);
                }
                iop = bsOps.nextSetBit(iop + 1);
            }
            if (sg == null) {
                n = bsGroups.cardinality();
                if (n == 0) {
                    bsGroups.set(hasC1 ? 1 : 0);
                    n = 1;
                    if (hasC1 && !asString) {
                        uncheckedOps.clearAll();
                        uncheckedOps.set(1);
                        opsChecked.clearAll();
                        targets.clearAll();
                        bsPoints.or(bsPoints0);
                    }
                }
                isg = bsGroups.nextSetBit(0);
                if (n == 1) {
                    if (isg > 0) {
                        opsChecked.and(bsGroupOps[isg]);
                        uncheckedOps.and(bsGroupOps[isg]);
                        uncheckedOps.andNot(opsChecked);
                        uncheckedOps.or(bsGroupOps[isg]);
                        uncheckedOps.clear(0);
                        bsPoints.or(bsPoints0);
                        bsPoints.andNot(targets);
                        if (!this.checkBasis(uncheckedOps, bsPoints, targets)) {
                            isg = 0;
                        }
                    }
                    if (isg == 0) {
                        targets.clearAll();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            bsGroups.clearAll();
        }
        if (sg == null) {
            System.out.println("checked " + nChecked + " operations; now " + n + " " + bsGroups + " " + bsOps);
            int i = bsGroups.nextSetBit(0);
            while (i >= 0) {
                System.out.println(SpaceGroup.nameToGroup.get(groupNames[i]));
                i = bsGroups.nextSetBit(i + 1);
            }
            if (n != 1) {
                return null;
            }
            sg = SpaceGroup.nameToGroup.get(groupNames[isg]);
        }
        String name = sg.asString();
        BS basis = BSUtil.copy(bsAtoms);
        int i = targets.nextSetBit(0);
        while (i >= 0) {
            basis.clear(this.atoms[i].index);
            i = targets.nextSetBit(i + 1);
        }
        int nb = basis.cardinality();
        String msg = name + "\nbasis is " + nb + " atom" + (nb == 1 ? "" : "s") + ": " + basis;
        System.out.println(msg);
        if (asString) {
            return msg;
        }
        Map map = (Map)sg.dumpInfoObj();
        System.out.println("unitcell is " + uc.getUnitCellInfo(true));
        BS bs1 = BS.copy(bsPoints0);
        bs1.andNot(targets);
        if (!isAssign) {
            this.dumpBasis(bsGroupOps[isg], bs1, bsPoints0);
        }
        map.put("name", name);
        map.put("basis", basis);
        map.put("supercell", scaling);
        oabc[1].scale(scaling.x);
        oabc[2].scale(scaling.y);
        oabc[3].scale(scaling.z);
        map.put("unitcell", oabc);
        if (isAssign) {
            map.put("sg", sg);
        }
        return map;
    }

    private void removeDuplicates(BS bs) {
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            SGAtom a = this.atoms[i];
            int j = bs.nextSetBit(0);
            while (j < i) {
                SGAtom b = this.atoms[j];
                if (a.typeAndOcc == b.typeAndOcc && a.distanceSquared(b) < 1.96E-6f) {
                    bs.clear(i);
                    break;
                }
                j = bs.nextSetBit(j + 1);
            }
            i = bs.nextSetBit(i + 1);
        }
    }

    private void dumpBasis(BS ops, BS bs1, BS bsPoints) {
    }

    private boolean checkBasis(BS uncheckedOps, BS bsPoints, BS targets) {
        int n = uncheckedOps.cardinality();
        if (n == 0) {
            return true;
        }
        BS bs = new BS();
        bs.or(bsPoints);
        System.out.println("finishing check for basis for " + n + " operations");
        int iop = uncheckedOps.nextSetBit(0);
        while (iop >= 0) {
            bs.or(bsPoints);
            SymmetryOperation op = SpaceGroupFinder.getOp(iop);
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                int j = this.findEquiv(-1, op, i, bs, this.pt, false);
                if (j < 0) {
                    return false;
                }
                if (i != j) {
                    j = Math.max(i, j);
                    targets.set(j);
                    bs.clear(j);
                }
                i = bs.nextSetBit(i + 1);
            }
            iop = uncheckedOps.nextSetBit(iop + 1);
        }
        return true;
    }

    private void filterGroups(BS bsGroups, float[] params) {
        int i;
        int i0;
        block13: {
            boolean isOrtho = false;
            boolean isTet = false;
            boolean isTri = false;
            boolean isRhombo = false;
            boolean isCubic = false;
            boolean absame = this.approx0(params[0] - params[1]);
            boolean bcsame = this.approx0(params[1] - params[2]);
            if (params[3] == 90.0f) {
                if (params[4] == 90.0f) {
                    if (absame && params[0] != params[1]) {
                        System.out.println("OHOH");
                    }
                    boolean bl = isTri = absame && this.approx000(params[5] - 120.0f);
                    if (params[5] == 90.0f) {
                        isCubic = absame && params[1] == params[2];
                        isTet = !isCubic && absame;
                        isOrtho = !isCubic && !isTet;
                    }
                }
            } else if (absame && bcsame && params[3] == params[4] && params[4] == params[5]) {
                isRhombo = true;
            }
            bsGroups.setBits(0, 2);
            i0 = 2;
            i = 2;
            i = SpaceGroupFinder.scanTo(i, "16");
            if (!isOrtho && !isTet && !isTri && !isRhombo && !isCubic) break block13;
            i = SpaceGroupFinder.scanTo(i, "75");
            if (!isTet && !isTri && !isRhombo && !isCubic) break block13;
            i = SpaceGroupFinder.scanTo(i, "143");
            if (!isTri && !isRhombo && !isCubic) break block13;
            i0 = i;
            while (true) {
                block15: {
                    String g;
                    block14: {
                        if ((g = groupNames[i]).indexOf(":r") < 0) break block14;
                        if (!isRhombo) break block15;
                        bsGroups.set(i);
                    }
                    if (g.startsWith("195")) {
                        if (!isRhombo) break;
                        return;
                    }
                }
                ++i;
            }
            if (isCubic) {
                bsGroups.setBits(2, i0);
                i0 = i;
                i = GROUP_COUNT;
            }
        }
        bsGroups.setBits(i0, i);
    }

    private static int scanTo(int i, String num) {
        while (!groupNames[i].startsWith(num)) {
            ++i;
        }
        return i;
    }

    private Object getGroupsWithOps(String xyzList, float[] unitCellParams, boolean isAssign) {
        int i;
        BS groups = new BS();
        if (unitCellParams == null) {
            groups.setBits(0, GROUP_COUNT);
        } else {
            this.filterGroups(groups, unitCellParams);
        }
        SpaceGroup sg = null;
        if (xyzList.indexOf("x") < 0) {
            sg = SpaceGroup.determineSpaceGroupNA(xyzList, unitCellParams);
            if (sg == null) {
                return null;
            }
            sg.checkHallOperators();
            for (int i2 = 0; i2 < GROUP_COUNT; ++i2) {
                if (!groupNames[i2].equals(sg.intlTableNumberFull)) continue;
                return groups.get(i2) ? sg : null;
            }
            return null;
        }
        boolean isEqual = xyzList.indexOf("&") < 0 || isAssign;
        String[] ops = PT.split(PT.trim(xyzList.trim().replace('&', ';'), ";="), ";");
        int j = ops.length;
        block1: while (--j >= 0) {
            String xyz = ops[j];
            if (xyz == null || xyz.indexOf("z") < xyz.lastIndexOf(",")) {
                return "?" + ops[j] + "?";
            }
            xyz = SymmetryOperation.getJmolCanonicalXYZ(xyz);
            i = opXYZ.length;
            while (--i >= 0) {
                if (opXYZ[i].equals(xyz)) {
                    groups.and(bsOpGroups[i]);
                    continue block1;
                }
                if (i != 0) continue;
                groups.clearAll();
            }
        }
        if (groups.isEmpty()) {
            return isAssign ? SpaceGroup.createSpaceGroupN(xyzList) : null;
        }
        if (isEqual) {
            int n = ops.length;
            int i3 = groups.nextSetBit(0);
            while (i3 >= 0) {
                if (bsGroupOps[i3].cardinality() == n) {
                    if (isAssign) {
                        return SpaceGroup.createSpaceGroupN(groupNames[i3]);
                    }
                    return SpaceGroup.getInfo(null, groupNames[i3], unitCellParams, true, false);
                }
                i3 = groups.nextSetBit(i3 + 1);
            }
            return null;
        }
        String[] ret = new String[groups.cardinality()];
        int p = 0;
        i = groups.nextSetBit(0);
        while (i >= 0) {
            ret[p++] = groupNames[i];
            i = groups.nextSetBit(i + 1);
        }
        return ret;
    }

    P3 toFractional(Atom a, SymmetryInterface uc) {
        this.pt.setT(a);
        uc.toFractional(this.pt, false);
        return this.pt;
    }

    private static SymmetryOperation getOp(int iop) {
        SymmetryOperation op = ops[iop];
        if (op == null) {
            SpaceGroupFinder.ops[iop] = op = new SymmetryOperation(null, iop, false);
            op.setMatrixFromXYZ(opXYZ[iop], 0, false);
            op.doFinalize();
        }
        return op;
    }

    public SymmetryInterface checkSupercell(Viewer vwr, SymmetryInterface uc, BS bsPoints, int abc, P3 scaling) {
        int n;
        if (bsPoints.isEmpty()) {
            return uc;
        }
        int minF = Integer.MAX_VALUE;
        int maxF = Integer.MIN_VALUE;
        int[] counts = new int[101];
        int i = bsPoints.nextSetBit(0);
        while (i >= 0) {
            SGAtom a = this.atoms[i];
            int type = a.typeAndOcc;
            int j = bsPoints.nextSetBit(0);
            while (j >= 0) {
                block24: {
                    int n2;
                    float f;
                    if (j == i) break block24;
                    SGAtom b = this.atoms[j];
                    if (b.typeAndOcc != type) break block24;
                    this.pt.sub2(b, a);
                    switch (abc) {
                        case 1: {
                            f = this.pt.x;
                            if (!this.approx0(f) && this.approx0(this.pt.y) && this.approx0(this.pt.z)) break;
                            break block24;
                        }
                        case 2: {
                            f = this.pt.y;
                            if (!this.approx0(f) && this.approx0(this.pt.x) && this.approx0(this.pt.z)) break;
                            break block24;
                        }
                        default: {
                            f = this.pt.z;
                            if (this.approx0(f) || !this.approx0(this.pt.x) || !this.approx0(this.pt.y)) break block24;
                        }
                    }
                    if ((n2 = this.approxInt(1.0f / f)) != 0 && (float)(this.nAtoms / n2) == 1.0f * (float)this.nAtoms / (float)n2 && n2 <= 100) {
                        if (n2 > maxF) {
                            maxF = n2;
                        }
                        if (n2 < minF) {
                            minF = n2;
                        }
                        int n3 = n2;
                        counts[n3] = counts[n3] + 1;
                    }
                }
                j = bsPoints.nextSetBit(j + 1);
            }
            i = bsPoints.nextSetBit(i + 1);
        }
        for (n = maxF; n >= minF && (counts[n] <= 0 || counts[n] != (n - 1) * this.nAtoms / n); --n) {
        }
        if (n < minF) {
            return uc;
        }
        T3[] oabc = uc.getUnitCellVectors();
        oabc[abc].scale(1.0f / (float)n);
        switch (abc) {
            case 1: {
                scaling.x = n;
                break;
            }
            case 2: {
                scaling.y = n;
                break;
            }
            case 3: {
                scaling.z = n;
            }
        }
        uc = vwr.getSymTemp().getUnitCell(oabc, false, "scaled");
        int f = 0;
        int i2 = bsPoints.nextSetBit(0);
        while (i2 >= 0) {
            switch (abc) {
                case 1: {
                    f = this.approxInt((float)n * this.atoms[i2].x);
                    break;
                }
                case 2: {
                    f = this.approxInt((float)n * this.atoms[i2].y);
                    break;
                }
                case 3: {
                    f = this.approxInt((float)n * this.atoms[i2].z);
                }
            }
            if (f != 0) {
                this.atoms[i2] = null;
                bsPoints.clear(i2);
            }
            i2 = bsPoints.nextSetBit(i2 + 1);
        }
        this.nAtoms = bsPoints.cardinality();
        return uc;
    }

    private boolean approx0(float f) {
        return Math.abs(f) < 0.001f;
    }

    private boolean approx000(float f) {
        return Math.abs(f) < 1.0E-4f;
    }

    private boolean approx0014(float f) {
        return Math.abs(f) < SLOP0014;
    }

    private int approxInt(float finv) {
        int i = (int)(finv + 0.001f);
        return Math.abs(finv - (float)i) < 0.001f ? i : 0;
    }

    private int findEquiv(int iop, SymmetryOperation op, int i, BS bsPoints, P3 pt, boolean andClear) {
        SGAtom a = this.atoms[i];
        pt.setT(a);
        op.rotTrans(pt);
        SimpleUnitCell.unitizeDim(3, pt);
        if (pt.distanceSquared(a) == 0.0f) {
            return i;
        }
        int testiop = -99;
        int type = a.typeAndOcc;
        String name = a.name;
        int j = this.nAtoms;
        while (--j >= 0) {
            float d;
            SGAtom b = this.atoms[j];
            if (b.typeAndOcc != type || !((d = b.distance(pt)) * d < 1.96E-6f) && (!((1.0f - d) * (1.0f - d) < 1.96E-6f) || !this.latticeShift(pt, b))) continue;
            if (andClear && i != (j = Math.max(i, j))) {
                bsPoints.clear(j);
            }
            return j;
        }
        return -1;
    }

    private boolean latticeShift(P3 a, P3 b) {
        boolean is1;
        boolean bl = is1 = this.approx0014(Math.abs(a.x - b.x) - 1.0f) || this.approx0014(Math.abs(a.y - b.y) - 1.0f) || this.approx0014(Math.abs(a.z - b.z) - 1.0f);
        if (is1) {
            // empty if block
        }
        return is1;
    }

    public static void main(String[] args) {
        if (SpaceGroupFinder.loadData(null, new SpaceGroupFinder())) {
            System.out.println("OK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadData(Viewer vwr, Object me) {
        try {
            groupNames = SpaceGroupFinder.getList(vwr, me, null, "sggroups_ordered.txt");
            GROUP_COUNT = groupNames.length;
            opXYZ = SpaceGroupFinder.getList(vwr, me, null, "sgops_ordered.txt");
            OP_COUNT = opXYZ.length;
            String[] map = SpaceGroupFinder.getList(vwr, me, new String[OP_COUNT], "sgmap.txt");
            bsGroupOps = new BS[GROUP_COUNT];
            bsOpGroups = new BS[OP_COUNT];
            for (int j = 0; j < GROUP_COUNT; ++j) {
                SpaceGroupFinder.bsGroupOps[j] = BS.newN(OP_COUNT);
            }
            for (int i = 0; i < OP_COUNT; ++i) {
                String m = map[i];
                SpaceGroupFinder.bsOpGroups[i] = BS.newN(GROUP_COUNT);
                for (int j = 0; j < GROUP_COUNT; ++j) {
                    if (m.charAt(j) != '1') continue;
                    bsGroupOps[j].set(i);
                    bsOpGroups[i].set(j);
                }
            }
            ops = new SymmetryOperation[OP_COUNT];
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String[] getList(Viewer vwr, Object me, String[] list, String fileName) throws IOException {
        rdr = FileManager.getBufferedReaderForResource(vwr, me, "org/jmol/symmetry/", "sg/" + fileName);
        if (list == null) {
            String line;
            Lst<String> l = new Lst<String>();
            while ((line = rdr.readLine()) != null) {
                if (line.length() <= 0) continue;
                l.addLast(line);
            }
            list = new String[l.size()];
            l.toArray(list);
        } else {
            for (int i = 0; i < list.length; ++i) {
                list[i] = rdr.readLine();
            }
        }
        rdr.close();
        return list;
    }

    static {
        rdr = null;
    }

    private class SGAtom
    extends P3 {
        int typeAndOcc;
        int index;
        String name;

        SGAtom(int type, int index, String name, int occupancy) {
            this.typeAndOcc = type + 1000 * occupancy;
            this.index = index;
            this.name = name;
        }
    }
}

