/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.AccSupp;
import com.dickimawbooks.texparserlib.CaseChange;
import com.dickimawbooks.texparserlib.DataObjectList;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import java.io.IOException;

public class GlsEntryField
extends AbstractGlsCommand {
    protected String field;
    protected CaseChange caseChange;
    protected boolean protect = false;

    public GlsEntryField(String string, GlossariesSty glossariesSty) {
        this(string, null, CaseChange.NO_CHANGE, glossariesSty);
    }

    public GlsEntryField(String string, String string2, GlossariesSty glossariesSty) {
        this(string, string2, CaseChange.NO_CHANGE, glossariesSty);
    }

    public GlsEntryField(String string, boolean bl, GlossariesSty glossariesSty) {
        this(string, null, CaseChange.NO_CHANGE, bl, glossariesSty);
    }

    public GlsEntryField(String string, String string2, CaseChange caseChange, GlossariesSty glossariesSty) {
        this(string, string2, caseChange, false, glossariesSty);
    }

    public GlsEntryField(String string, String string2, CaseChange caseChange, boolean bl, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.field = string2;
        this.caseChange = caseChange;
        this.protect = bl;
    }

    @Override
    public Object clone() {
        return new GlsEntryField(this.getName(), this.getField(), this.getCaseChange(), this.protect, this.getSty());
    }

    public AccSupp getAccSupp(GlsLabel glsLabel, String string) {
        String string2;
        if (glsLabel == null) {
            return null;
        }
        GlossaryEntry glossaryEntry = glsLabel.getEntry();
        if (glossaryEntry == null) {
            return null;
        }
        TeXObject teXObject = glossaryEntry.get(string + "access");
        if (teXObject == null && string.endsWith("plural")) {
            int n = string.length() - 6;
            string2 = n > 0 ? string.substring(0, n) : "text";
            teXObject = glossaryEntry.get(string2 + "access");
        }
        if (teXObject == null) {
            return null;
        }
        string2 = teXObject instanceof TextualContentCommand ? ((TextualContentCommand)teXObject).getText() : (teXObject instanceof GenericCommand ? ((GenericCommand)teXObject).getDefinition().toString(this.sty.getParser()) : teXObject.toString(this.sty.getParser()));
        return this.getAccSupp(glsLabel, string, string2);
    }

    protected AccSupp getAccSupp(GlsLabel glsLabel, String string, String string2) {
        if (string.startsWith("short")) {
            return AccSupp.createAbbr(this.sty.getTarget(glsLabel), string2);
        }
        return AccSupp.createSymbol(string2, this.sty.isFieldIcon(string));
    }

    protected TeXObjectList expand(GlsLabel glsLabel, String string, CaseChange caseChange, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.getFieldValue(glsLabel, string);
        TeXObjectList teXObjectList2 = new TeXObjectList();
        if (teXObject != null) {
            switch (caseChange) {
                case SENTENCE: {
                    teXObjectList2.add(new TeXCsRef("makefirstuc"));
                    Group group = teXParser.getListener().createGroup();
                    group.add(teXObject);
                    teXObjectList2.add(group);
                    break;
                }
                case TITLE: {
                    teXObjectList2.add(new TeXCsRef("glsxtrfieldtitlecasecs"));
                    Group group = teXParser.getListener().createGroup();
                    group.add(teXObject);
                    teXObjectList2.add(group);
                    break;
                }
                case TO_UPPER: {
                    teXObjectList2.add(new TeXCsRef("mfirstucMakeUppercase"));
                    Group group = teXParser.getListener().createGroup();
                    group.add(teXObject);
                    teXObjectList2.add(group);
                    break;
                }
                default: {
                    teXObjectList2.add(teXObject);
                }
            }
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        String string = this.field;
        if (this.field == null) {
            string = this.sty.getFieldName(this.popLabelString(teXParser, teXObjectList));
        }
        TeXObjectList teXObjectList2 = this.expand(glsLabel, string, this.caseChange, teXParser, teXObjectList);
        if (this.protect) {
            DataObjectList dataObjectList = teXParser.getListener().createDataList(true);
            dataObjectList.addAll(teXObjectList2);
            teXObjectList2 = teXParser.getListener().createStack();
            teXObjectList2.add(dataObjectList);
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        if (this.protect) {
            return this.expandonce(teXParser, teXObjectList);
        }
        if (this.caseChange != CaseChange.NO_CHANGE) {
            if (teXParser == teXObjectList || teXObjectList == null) {
                return this.expandonce(teXParser).expandfully(teXParser);
            }
            return this.expandonce(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
        }
        GlsLabel glsLabel = this.popEntryLabel(teXParser, teXObjectList);
        String string = this.field;
        if (this.field == null) {
            string = this.popLabelString(teXParser, teXObjectList);
        }
        if ((teXObject = this.getFieldValue(glsLabel, string)) == null || !teXObject.canExpand()) {
            TeXObjectList teXObjectList2 = new TeXObjectList();
            if (teXObject != null) {
                teXObjectList2.add(teXObject);
            }
            return teXObjectList2;
        }
        TeXObjectList teXObjectList3 = teXParser == teXObjectList || teXObjectList == null ? ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList) : ((Expandable)((Object)teXObject)).expandfully(teXParser);
        if (teXObjectList3 == null) {
            TeXObjectList teXObjectList4 = new TeXObjectList();
            teXObjectList4.add(teXObject);
            return teXObjectList4;
        }
        return teXObjectList3;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.expandonce(teXParser, teXObjectList).process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.expandonce(teXParser).process(teXParser);
    }

    public String getField() {
        return this.field;
    }

    public CaseChange getCaseChange() {
        return this.caseChange;
    }
}

