/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.action;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.indexstatemanagement.action.AliasAction;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.ActionParser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/action/AliasActionParser;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/ActionParser;", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "fromStreamInput", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action;", "sin", "Lorg/opensearch/common/io/stream/StreamInput;", "fromXContent", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "index", "", "getActionType", "", "opensearch-index-management"})
public final class AliasActionParser
extends ActionParser {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public AliasActionParser() {
        super(false, 1, null);
    }

    @NotNull
    public Action fromStreamInput(@NotNull StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        List actions = sin.readList(IndicesAliasesRequest.AliasActions::new);
        int index2 = sin.readInt();
        Intrinsics.checkNotNullExpressionValue((Object)actions, (String)"actions");
        return new AliasAction(actions, index2);
    }

    @NotNull
    public Action fromXContent(@NotNull XContentParser xcp, int index2) {
        Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
        List actions = new ArrayList();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (Intrinsics.areEqual((Object)fieldName, (Object)"actions")) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                    IndicesAliasesRequest.AliasActions aliasActions = IndicesAliasesRequest.AliasActions.fromXContent((XContentParser)xcp);
                    Intrinsics.checkNotNullExpressionValue((Object)aliasActions, (String)"fromXContent(xcp)");
                    actions.add(aliasActions);
                }
                continue;
            }
            this.logger.error("Invalid field: [" + fieldName + "] found in AliasAction.");
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in AliasAction.");
        }
        return new AliasAction(actions, index2);
    }

    @NotNull
    public String getActionType() {
        return "alias";
    }
}

