/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.classfmt.BinaryTypeFormatter;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.ElementValuePairInfo;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.util.Util;

public class AnnotationInfo
extends ClassFileStruct
implements IBinaryAnnotation {
    private char[] typename;
    private volatile ElementValuePairInfo[] pairs;
    long standardAnnotationTagBits = 0L;
    int readOffset = 0;
    static Object[] EmptyValueArray = new Object[0];
    public RuntimeException exceptionDuringDecode;

    AnnotationInfo(byte[] byArray, int[] nArray, int n) {
        super(byArray, nArray, n);
    }

    AnnotationInfo(byte[] byArray, int[] nArray, int n, boolean bl, boolean bl2) {
        this(byArray, nArray, n);
        if (bl2) {
            this.decodeAnnotation();
        } else {
            this.readOffset = this.scanAnnotation(0, bl, true);
        }
    }

    private void decodeAnnotation() {
        this.readOffset = 0;
        int n = this.constantPoolOffsets[this.u2At(0)] - this.structOffset;
        this.typename = this.utf8At(n + 3, this.u2At(n + 1));
        int n2 = this.u2At(2);
        this.readOffset += 4;
        ElementValuePairInfo[] elementValuePairInfoArray = n2 == 0 ? ElementValuePairInfo.NoMembers : new ElementValuePairInfo[n2];
        int n3 = 0;
        try {
            while (n3 < n2) {
                n = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                char[] cArray = this.utf8At(n + 3, this.u2At(n + 1));
                this.readOffset += 2;
                Object object = this.decodeDefaultValue();
                elementValuePairInfoArray[n3++] = new ElementValuePairInfo(cArray, object);
            }
            this.pairs = elementValuePairInfoArray;
        }
        catch (RuntimeException runtimeException) {
            this.sanitizePairs(elementValuePairInfoArray);
            StringBuilder stringBuilder = new StringBuilder(runtimeException.getMessage());
            stringBuilder.append(" while decoding pair #").append(n3).append(" of annotation @").append(this.typename);
            stringBuilder.append(", bytes at structOffset ").append(this.structOffset).append(":");
            int n4 = this.structOffset;
            while (n4 <= this.structOffset + this.readOffset && n4 < this.reference.length) {
                stringBuilder.append(' ').append(Integer.toHexString(this.reference[n4++] & 0xFF));
            }
            throw new IllegalStateException(stringBuilder.toString(), runtimeException);
        }
    }

    private void sanitizePairs(ElementValuePairInfo[] elementValuePairInfoArray) {
        if (elementValuePairInfoArray != null) {
            ElementValuePairInfo[] elementValuePairInfoArray2 = new ElementValuePairInfo[elementValuePairInfoArray.length];
            int n = 0;
            for (int i = 0; i < elementValuePairInfoArray.length; ++i) {
                ElementValuePairInfo elementValuePairInfo = elementValuePairInfoArray[i];
                if (elementValuePairInfo == null) continue;
                elementValuePairInfoArray2[n++] = elementValuePairInfo;
            }
            this.pairs = n < elementValuePairInfoArray.length ? Arrays.copyOf(elementValuePairInfoArray2, n) : elementValuePairInfoArray2;
        } else {
            this.pairs = ElementValuePairInfo.NoMembers;
        }
    }

    Object decodeDefaultValue() {
        Object object = null;
        int n = this.u1At(this.readOffset);
        ++this.readOffset;
        int n2 = -1;
        switch (n) {
            case 90: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                object = BooleanConstant.fromValue(this.i4At(n2 + 1) == 1);
                this.readOffset += 2;
                break;
            }
            case 73: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                object = IntConstant.fromValue(this.i4At(n2 + 1));
                this.readOffset += 2;
                break;
            }
            case 67: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                object = CharConstant.fromValue((char)this.i4At(n2 + 1));
                this.readOffset += 2;
                break;
            }
            case 66: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                object = ByteConstant.fromValue((byte)this.i4At(n2 + 1));
                this.readOffset += 2;
                break;
            }
            case 83: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                object = ShortConstant.fromValue((short)this.i4At(n2 + 1));
                this.readOffset += 2;
                break;
            }
            case 68: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                object = DoubleConstant.fromValue(this.doubleAt(n2 + 1));
                this.readOffset += 2;
                break;
            }
            case 70: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                object = FloatConstant.fromValue(this.floatAt(n2 + 1));
                this.readOffset += 2;
                break;
            }
            case 74: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                object = LongConstant.fromValue(this.i8At(n2 + 1));
                this.readOffset += 2;
                break;
            }
            case 115: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                object = StringConstant.fromValue(String.valueOf(this.utf8At(n2 + 3, this.u2At(n2 + 1))));
                this.readOffset += 2;
                break;
            }
            case 101: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                char[] cArray = this.utf8At(n2 + 3, this.u2At(n2 + 1));
                this.readOffset += 2;
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                char[] cArray2 = this.utf8At(n2 + 3, this.u2At(n2 + 1));
                this.readOffset += 2;
                object = new EnumConstantSignature(cArray, cArray2);
                break;
            }
            case 99: {
                n2 = this.constantPoolOffsets[this.u2At(this.readOffset)] - this.structOffset;
                char[] cArray = this.utf8At(n2 + 3, this.u2At(n2 + 1));
                object = new ClassSignature(cArray);
                this.readOffset += 2;
                break;
            }
            case 64: {
                object = new AnnotationInfo(this.reference, this.constantPoolOffsets, this.readOffset + this.structOffset, false, true);
                this.readOffset += ((AnnotationInfo)object).readOffset;
                break;
            }
            case 91: {
                int n3 = this.u2At(this.readOffset);
                this.readOffset += 2;
                if (n3 == 0) {
                    object = EmptyValueArray;
                    break;
                }
                Object[] objectArray = new Object[n3];
                object = objectArray;
                for (int i = 0; i < n3; ++i) {
                    objectArray[i] = this.decodeDefaultValue();
                }
                break;
            }
            default: {
                String string = n == 0 ? "0x00" : (char)n + " (" + Integer.toHexString(n & 0xFF) + ")";
                throw new IllegalStateException("Unrecognized tag " + string);
            }
        }
        return object;
    }

    @Override
    public IBinaryElementValuePair[] getElementValuePairs() {
        if (this.pairs == null) {
            this.lazyInitialize();
        }
        return this.pairs;
    }

    @Override
    public char[] getTypeName() {
        return this.typename;
    }

    @Override
    public boolean isDeprecatedAnnotation() {
        return (this.standardAnnotationTagBits & 0x4000400000000000L) != 0L;
    }

    void initialize() {
        if (this.pairs == null) {
            this.decodeAnnotation();
        }
    }

    synchronized void lazyInitialize() {
        if (this.pairs == null) {
            this.decodeAnnotation();
        }
    }

    private int readRetentionPolicy(int n) {
        int n2 = n;
        int n3 = this.u1At(n2);
        ++n2;
        switch (n3) {
            case 101: {
                int n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
                char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
                n2 += 2;
                if (cArray.length == 38 && CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_RETENTIONPOLICY)) {
                    n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
                    char[] cArray2 = this.utf8At(n4 + 3, this.u2At(n4 + 1));
                    this.standardAnnotationTagBits |= Annotation.getRetentionPolicy(cArray2);
                }
                n2 += 2;
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 99: 
            case 115: {
                n2 += 2;
                break;
            }
            case 64: {
                n2 = this.scanAnnotation(n2, false, false);
                break;
            }
            case 91: {
                int n5 = this.u2At(n2);
                n2 += 2;
                for (int i = 0; i < n5; ++i) {
                    n2 = this.scanElementValue(n2);
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return n2;
    }

    private int readTargetValue(int n) {
        int n2 = n;
        int n3 = this.u1At(n2);
        ++n2;
        switch (n3) {
            case 101: {
                int n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
                char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
                n2 += 2;
                if (cArray.length == 34 && CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_ELEMENTTYPE)) {
                    n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
                    char[] cArray2 = this.utf8At(n4 + 3, this.u2At(n4 + 1));
                    this.standardAnnotationTagBits |= Annotation.getTargetElementType(cArray2);
                }
                n2 += 2;
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 99: 
            case 115: {
                n2 += 2;
                break;
            }
            case 64: {
                n2 = this.scanAnnotation(n2, false, false);
                break;
            }
            case 91: {
                int n5 = this.u2At(n2);
                n2 += 2;
                if (n5 == 0) {
                    this.standardAnnotationTagBits |= 0x800000000L;
                    break;
                }
                for (int i = 0; i < n5; ++i) {
                    n2 = this.readTargetValue(n2);
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return n2;
    }

    private int scanAnnotation(int n, boolean bl, boolean bl2) {
        int n2 = n;
        int n3 = this.constantPoolOffsets[this.u2At(n)] - this.structOffset;
        char[] cArray = this.utf8At(n3 + 3, this.u2At(n3 + 1));
        if (bl2) {
            this.typename = cArray;
        }
        int n4 = this.u2At(n + 2);
        n2 += 4;
        if (bl && bl2) {
            switch (cArray.length) {
                case 22: {
                    if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_DEPRECATED)) break;
                    this.standardAnnotationTagBits |= 0x400000000000L;
                    break;
                }
                case 23: {
                    if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_SAFEVARARGS)) break;
                    this.standardAnnotationTagBits |= 0x8000000000000L;
                    return n2;
                }
                case 29: {
                    if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_TARGET)) break;
                    return this.readTargetValue(n2 += 2);
                }
                case 32: {
                    if (CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_RETENTION)) {
                        return this.readRetentionPolicy(n2 += 2);
                    }
                    if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_INHERITED)) break;
                    this.standardAnnotationTagBits |= 0x1000000000000L;
                    return n2;
                }
                case 33: {
                    if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_DOCUMENTED)) break;
                    this.standardAnnotationTagBits |= 0x800000000000L;
                    return n2;
                }
                case 52: {
                    if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_INVOKE_METHODHANDLE_POLYMORPHICSIGNATURE)) break;
                    this.standardAnnotationTagBits |= 0x10000000000000L;
                    return n2;
                }
            }
        }
        for (int i = 0; i < n4; ++i) {
            n2 += 2;
            n2 = this.scanElementValue(n2);
        }
        return n2;
    }

    private int scanElementValue(int n) {
        int n2 = n;
        int n3 = this.u1At(n2);
        ++n2;
        switch (n3) {
            case 90: {
                int n4;
                if ((this.standardAnnotationTagBits & 0x400000000000L) != 0L && this.i4At(n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset + 1) == 1) {
                    this.standardAnnotationTagBits |= 0x4000000000000000L;
                }
                n2 += 2;
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 99: 
            case 115: {
                n2 += 2;
                break;
            }
            case 101: {
                n2 += 4;
                break;
            }
            case 64: {
                n2 = this.scanAnnotation(n2, false, false);
                break;
            }
            case 91: {
                int n5 = this.u2At(n2);
                n2 += 2;
                for (int i = 0; i < n5; ++i) {
                    n2 = this.scanElementValue(n2);
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return n2;
    }

    public String toString() {
        return BinaryTypeFormatter.annotationToString(this);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Util.hashCode(this.pairs);
        n = 31 * n + CharOperation.hashCode(this.typename);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AnnotationInfo annotationInfo = (AnnotationInfo)object;
        if (!Arrays.equals(this.pairs, annotationInfo.pairs)) {
            return false;
        }
        return Arrays.equals(this.typename, annotationInfo.typename);
    }
}

