/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang.test;

import com.drew.lang.Rational;
import junit.framework.TestCase;

public class RationalTest
extends TestCase {
    public RationalTest(String s) {
        super(s);
    }

    public void testCreateRational() throws Exception {
        Rational rational = new Rational(1, 3);
        RationalTest.assertEquals((int)1, (int)rational.getNumerator());
        RationalTest.assertEquals((int)3, (int)rational.getDenominator());
        RationalTest.assertEquals((Object)new Double(0.3333333333333333), (Object)new Double(rational.doubleValue()));
    }

    public void testToString() throws Exception {
        Rational rational = new Rational(1, 3);
        RationalTest.assertEquals((String)"1/3", (String)rational.toString());
    }

    public void testToSimpleString() throws Exception {
        Rational third1 = new Rational(1, 3);
        Rational third2 = new Rational(2, 6);
        RationalTest.assertEquals((String)"1/3", (String)third1.toSimpleString(true));
        RationalTest.assertEquals((String)"1/3", (String)third2.toSimpleString(true));
        RationalTest.assertEquals((Object)third1, (Object)third2);
        Rational twoThirds = new Rational(10, 15);
        RationalTest.assertEquals((String)"2/3", (String)twoThirds.toSimpleString(true));
        Rational two = new Rational(10, 5);
        RationalTest.assertTrue((boolean)two.isInteger());
        RationalTest.assertEquals((String)"2", (String)two.toSimpleString(true));
        RationalTest.assertEquals((String)"2", (String)two.toSimpleString(false));
        Rational twoFifths = new Rational(4, 10);
        RationalTest.assertEquals((String)"0.4", (String)twoFifths.toSimpleString(true));
        RationalTest.assertEquals((String)"2/5", (String)twoFifths.toSimpleString(false));
        Rational threeEigths = new Rational(3, 8);
        RationalTest.assertEquals((String)"3/8", (String)threeEigths.toSimpleString(true));
        Rational zero = new Rational(0, 8);
        RationalTest.assertTrue((boolean)zero.isInteger());
        RationalTest.assertEquals((String)"0", (String)zero.toSimpleString(true));
        RationalTest.assertEquals((String)"0", (String)zero.toSimpleString(false));
        zero = new Rational(0, 0);
        RationalTest.assertTrue((boolean)zero.isInteger());
        RationalTest.assertEquals((String)"0", (String)zero.toSimpleString(true));
        RationalTest.assertEquals((String)"0", (String)zero.toSimpleString(false));
    }

    public void testGetReciprocal() throws Exception {
        Rational rational = new Rational(1, 3);
        Rational reciprocal = rational.getReciprocal();
        RationalTest.assertEquals((String)"new rational should be reciprocal", (Object)new Rational(3, 1), (Object)reciprocal);
        RationalTest.assertEquals((String)"origianl reciprocal should remain unchanged", (Object)new Rational(1, 3), (Object)rational);
    }
}

