
-- Copyright (c) 2003, 2008-2012, Oracle and/or its affiliates. All rights reserved.
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; version 2 of the License.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-- DO NOT EDIT THIS FILE. It is generated automatically.

-- To use this file, load its contents into the mysql database. For example,
-- with the mysql client program, process the file like this, where
-- file_name is the name of this file:

--     mysql -u root -p mysql < file_name

set names 'utf8';

set sql_log_bin = 0;

use mysql;
delete from help_topic;
delete from help_category;
delete from help_keyword;
delete from help_relation;

lock tables help_topic write, help_category write, help_keyword write, help_relation write;
insert into help_category (help_category_id,name,parent_category_id,url) values (1,'Contents',0,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (2,'Polygon Properties',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (3,'WKT',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (4,'Numeric Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (5,'Plugins',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (6,'MBR',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (7,'Control Flow Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (8,'Transactions',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (9,'Help Metadata',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (10,'Account Management',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (11,'Point Properties',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (12,'Encryption Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (13,'LineString Properties',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (14,'Miscellaneous Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (15,'Logical Operators',47,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (16,'Functions and Modifiers for Use with GROUP BY',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (17,'Information Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (18,'Assignment Operators',47,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (19,'Comparison Operators',47,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (20,'Bit Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (21,'Table Maintenance',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (22,'User-Defined Functions',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (23,'Data Types',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (24,'Compound Statements',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (25,'Geometry Constructors',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (26,'Administration',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (27,'Data Manipulation',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (28,'Utility',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (29,'Language Structure',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (30,'Geometry Relations',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (31,'Date and Time Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (32,'WKB',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (33,'Procedures',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (34,'Geographic Features',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (35,'Geometry Properties',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (36,'String Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (37,'Functions',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (38,'Data Definition',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (39,'Sequences',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (40,'JSON Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (41,'Window Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (42,'Spider Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (43,'Dynamic Column Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (44,'Galera Functions',37,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (45,'Temporal Tables',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (46,'GeoJSON',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (47,'Operators',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (48,'Arithmetic Operators',47,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (49,'Replication',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (50,'Prepared Statements',1,'');

insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (1,9,'HELP_DATE','Help Contents generated from the MariaDB Knowledge Base on 25 July 2023.','','');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (2,9,'HELP_VERSION','Help Contents generated for MariaDB 11.0 from the MariaDB Knowledge Base on 25 July 2023.','','');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (3,2,'AREA','A synonym for ST_AREA.\n\nURL: https://mariadb.com/kb/en/polygon-properties-area/','','https://mariadb.com/kb/en/polygon-properties-area/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (4,2,'CENTROID','A synonym for ST_CENTROID.\n\nURL: https://mariadb.com/kb/en/centroid/','','https://mariadb.com/kb/en/centroid/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (5,2,'ExteriorRing','A synonym for ST_ExteriorRing.\n\nURL: https://mariadb.com/kb/en/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/polygon-properties-exteriorring/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (6,2,'InteriorRingN','A synonym for ST_InteriorRingN.\n\nURL: https://mariadb.com/kb/en/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/polygon-properties-interiorringn/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (7,2,'NumInteriorRings','A synonym for ST_NumInteriorRings.\n\nURL: https://mariadb.com/kb/en/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/polygon-properties-numinteriorrings/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (8,2,'ST_AREA','Syntax\n------\n\nST_Area(poly)\nArea(poly)\n\nDescription\n-----------\n\nReturns as a double-precision number the area of the Polygon value poly, as\nmeasured in its spatial reference system.\n\nST_Area() and Area() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\n\nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n\nURL: https://mariadb.com/kb/en/st_area/','','https://mariadb.com/kb/en/st_area/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (9,2,'ST_CENTROID','Syntax\n------\n\nST_Centroid(mpoly)\nCentroid(mpoly)\n\nDescription\n-----------\n\nReturns a point reflecting the mathematical centroid (geometric center) for\nthe MultiPolygon mpoly. The resulting point will not necessarily be on the\nMultiPolygon.\n\nST_Centroid() and Centroid() are synonyms.\n\nExamples\n--------\n\nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0 0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n+--------------+\n| center       |\n+--------------+\n| POINT(10 10) |\n+--------------+\n\nURL: https://mariadb.com/kb/en/st_centroid/','','https://mariadb.com/kb/en/st_centroid/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (10,2,'ST_ExteriorRing','Syntax\n------\n\nST_ExteriorRing(poly)\nExteriorRing(poly)\n\nDescription\n-----------\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nST_ExteriorRing() and ExteriorRing() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_exteriorring/','','https://mariadb.com/kb/en/st_exteriorring/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (11,2,'ST_InteriorRingN','Syntax\n------\n\nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n\nDescription\n-----------\n\nReturns the N-th interior ring for the Polygon value poly as a LineString.\nRings are numbered beginning with 1.\n\nST_InteriorRingN() and InteriorRingN() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_interiorringn/','','https://mariadb.com/kb/en/st_interiorringn/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (12,2,'ST_NumInteriorRings','Syntax\n------\n\nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n\nDescription\n-----------\n\nReturns an integer containing the number of interior rings in the Polygon\nvalue poly.\n\nNote that according the the OpenGIS standard, a POLYGON should have exactly\none ExteriorRing and all other rings should lie within that ExteriorRing and\nthus be the InteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several \'ExteriorRings\'. In the case of\nthere being multiple, non-overlapping exterior rings ST_NumInteriorRings()\nwill return 1.\n\nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n\nExamples\n--------\n\nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\n\nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/st_numinteriorrings/','','https://mariadb.com/kb/en/st_numinteriorrings/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (13,3,'WKT Definition','Description\n-----------\n\nThe Well-Known Text (WKT) representation of Geometry is designed to exchange\ngeometry data in ASCII form. Examples of the basic geometry types include:\n\n+-----------------------------------------------------------------------------+\n| Geometry Types                                                              |\n+-----------------------------------------------------------------------------+\n| POINT                                                                       |\n+-----------------------------------------------------------------------------+\n| LINESTRING                                                                  |\n+-----------------------------------------------------------------------------+\n| POLYGON                                                                     |\n+-----------------------------------------------------------------------------+\n| MULTIPOINT                                                                  |\n+-----------------------------------------------------------------------------+\n| MULTILINESTRING                                                             |\n+-----------------------------------------------------------------------------+\n| MULTIPOLYGON                                                                |\n+-----------------------------------------------------------------------------+\n| GEOMETRYCOLLECTION                                                          |\n+-----------------------------------------------------------------------------+\n| GEOMETRY                                                                    |\n+-----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/wkt-definition/','','https://mariadb.com/kb/en/wkt-definition/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (14,3,'AsText','A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-astext/','','https://mariadb.com/kb/en/wkt-astext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (15,3,'AsWKT','A synonym for ST_AsText().\n\nURL: https://mariadb.com/kb/en/wkt-aswkt/','','https://mariadb.com/kb/en/wkt-aswkt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (16,3,'GeomCollFromText','A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/wkt-geomcollfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (17,3,'GeometryCollectionFromText','A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/geometrycollectionfromtext/','','https://mariadb.com/kb/en/geometrycollectionfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (18,3,'GeometryFromText','A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/geometryfromtext/','','https://mariadb.com/kb/en/geometryfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (19,3,'GeomFromText','A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/wkt-geomfromtext/','','https://mariadb.com/kb/en/wkt-geomfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (20,3,'LineFromText','A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/wkt-linefromtext/','','https://mariadb.com/kb/en/wkt-linefromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (21,3,'LineStringFromText','A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/linestringfromtext/','','https://mariadb.com/kb/en/linestringfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (22,3,'MLineFromText','Syntax\n------\n\nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTILINESTRING value using its WKT representation and SRID.\n\nMLineFromText() and MultiLineStringFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\nINSERT INTO gis_multi_line VALUES\n  (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16\n23,16 48))\')),\n  (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n  (MLineFromWKB(AsWKB(MultiLineString(\n   LineString(Point(1, 2), Point(3, 5)),\n   LineString(Point(2, 5), Point(5, 8), Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/mlinefromtext/','','https://mariadb.com/kb/en/mlinefromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (23,3,'MPointFromText','Syntax\n------\n\nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nMPointFromText() and MultiPointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/mpointfromtext/','','https://mariadb.com/kb/en/mpointfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (24,3,'MPolyFromText','Syntax\n------\n\nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nMPolyFromText() and MultiPolygonFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(\n   ((28 26,28 0,84 0,84 42,28 26),(52 18,66 23,73 9,48 6,52 18)),\n   ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(\n   LineString(Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/mpolyfromtext/','','https://mariadb.com/kb/en/mpolyfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (25,3,'MultiLineStringFromText','A synonym for MLineFromText.\n\nURL: https://mariadb.com/kb/en/multilinestringfromtext/','','https://mariadb.com/kb/en/multilinestringfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (26,3,'MultiPointFromText','A synonym for MPointFromText.\n\nURL: https://mariadb.com/kb/en/multipointfromtext/','','https://mariadb.com/kb/en/multipointfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (27,3,'MultiPolygonFromText','A synonym for MPolyFromText.\n\nURL: https://mariadb.com/kb/en/multipolygonfromtext/','','https://mariadb.com/kb/en/multipolygonfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (28,3,'PointFromText','A synonym for ST_PointFromText.\n\nURL: https://mariadb.com/kb/en/wkt-pointfromtext/','','https://mariadb.com/kb/en/wkt-pointfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (29,3,'PolyFromText','A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/wkt-polyfromtext/','','https://mariadb.com/kb/en/wkt-polyfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (30,3,'PolygonFromText','A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/polygonfromtext/','','https://mariadb.com/kb/en/polygonfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (31,3,'ST_AsText','Syntax\n------\n\nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n\nDescription\n-----------\n\nConverts a value in internal geometry format to its WKT representation and\nreturns the string result.\n\nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all synonyms.\n\nExamples\n--------\n\nSET @g = \'LineString(1 1,4 4,6 6)\';\n\nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6)        |\n+--------------------------------+\n\nURL: https://mariadb.com/kb/en/st_astext/','','https://mariadb.com/kb/en/st_astext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (32,3,'ST_ASWKT','A synonym for ST_ASTEXT().\n\nURL: https://mariadb.com/kb/en/st_aswkt/','','https://mariadb.com/kb/en/st_aswkt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (33,3,'ST_GeomCollFromText','Syntax\n------\n\nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and SRID.\n\nST_GeomCollFromText(), ST_GeometryCollectionFromText(), GeomCollFromText() and\nGeometryCollectionFromText() are all synonyms.\n\nExample\n-------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/st_geomcollfromtext/','','https://mariadb.com/kb/en/st_geomcollfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (34,3,'ST_GeometryCollectionFromText','A synonym for ST_GeomCollFromText.\n\nURL: https://mariadb.com/kb/en/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/st_geometrycollectionfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (35,3,'ST_GeometryFromText','A synonym for ST_GeomFromText.\n\nURL: https://mariadb.com/kb/en/st_geometryfromtext/','','https://mariadb.com/kb/en/st_geometryfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (36,3,'ST_GeomFromText','Syntax\n------\n\nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a geometry value of any type using its WKT representation and SRID.\n\nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n\nExample\n-------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nURL: https://mariadb.com/kb/en/st_geomfromtext/','','https://mariadb.com/kb/en/st_geomfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (37,3,'ST_LineFromText','Syntax\n------\n\nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nST_LineFromText(), ST_LineStringFromText(), ST_LineFromText() and\nST_LineStringFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_line  (g LINESTRING);\nSHOW FIELDS FROM gis_line;\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/st_linefromtext/','','https://mariadb.com/kb/en/st_linefromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (38,3,'ST_LineStringFromText','A synonym for ST_LineFromText.\n\nURL: https://mariadb.com/kb/en/st_linestringfromtext/','','https://mariadb.com/kb/en/st_linestringfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (39,3,'ST_PointFromText','Syntax\n------\n\nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POINT value using its WKT representation and SRID.\n\nST_PointFromText() and PointFromText() are synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_point  (g POINT);\nSHOW FIELDS FROM gis_point;\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/st_pointfromtext/','','https://mariadb.com/kb/en/st_pointfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (40,3,'ST_PolyFromText','Syntax\n------\n\nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n\nDescription\n-----------\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n\nExamples\n--------\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\'));\n\nURL: https://mariadb.com/kb/en/st_polyfromtext/','','https://mariadb.com/kb/en/st_polyfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (41,3,'ST_PolygonFromText','A synonym for ST_PolyFromText.\n\nURL: https://mariadb.com/kb/en/st_polygonfromtext/','','https://mariadb.com/kb/en/st_polygonfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (42,4,'DIV','Syntax\n------\n\nDIV\n\nDescription\n-----------\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for non-integer operands that exceed BIGINT range.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a division by zero produces\nan error. Otherwise, it returns NULL.\n\nThe remainder of a division can be obtained using the MOD operator.\n\nExamples\n--------\n\nSELECT 300 DIV 7;\n+-----------+\n| 300 DIV 7 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT 300 DIV 0;\n+-----------+\n| 300 DIV 0 |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/div/','','https://mariadb.com/kb/en/div/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (43,4,'ABS','Syntax\n------\n\nABS(X)\n\nDescription\n-----------\n\nReturns the absolute (non-negative) value of X. If X is not a number, it is\nconverted to a numeric type.\n\nExamples\n--------\n\nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n|      42 |\n+---------+\n\nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n|       42 |\n+----------+\n\nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n|               19940101 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/abs/','','https://mariadb.com/kb/en/abs/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (44,4,'ACOS','Syntax\n------\n\nACOS(X)\n\nDescription\n-----------\n\nReturns the arc cosine of X, that is, the value whose cosine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n|         NULL |\n+--------------+\n\nSELECT ACOS(0);\n+-----------------+\n| ACOS(0)         |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234)      |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/acos/','','https://mariadb.com/kb/en/acos/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (45,4,'ASIN','Syntax\n------\n\nASIN(X)\n\nDescription\n-----------\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns NULL if\nX is not in the range -1 to 1.\n\nExamples\n--------\n\nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2)          |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n\nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n\nSHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n\nURL: https://mariadb.com/kb/en/asin/','','https://mariadb.com/kb/en/asin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (46,4,'ATAN','Syntax\n------\n\nATAN(X)\n\nDescription\n-----------\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nExamples\n--------\n\nSELECT ATAN(2);\n+--------------------+\n| ATAN(2)            |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n\nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2)            |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/atan/','','https://mariadb.com/kb/en/atan/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (47,4,'ATAN2','Syntax\n------\n\nATAN(Y,X), ATAN2(Y,X)\n\nDescription\n-----------\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both arguments\nare used to determine the quadrant of the result.\n\nExamples\n--------\n\nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2)          |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n\nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0)      |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/atan2/','','https://mariadb.com/kb/en/atan2/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (48,4,'CEIL','Syntax\n------\n\nCEIL(X)\n\nDescription\n-----------\n\nCEIL() is a synonym for CEILING().\n\nURL: https://mariadb.com/kb/en/ceil/','','https://mariadb.com/kb/en/ceil/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (49,4,'CEILING','Syntax\n------\n\nCEILING(X)\n\nDescription\n-----------\n\nReturns the smallest integer value not less than X.\n\nExamples\n--------\n\nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n|             -1 |\n+----------------+\n\nURL: https://mariadb.com/kb/en/ceiling/','','https://mariadb.com/kb/en/ceiling/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (50,4,'CONV','Syntax\n------\n\nCONV(N,from_base,to_base)\n\nDescription\n-----------\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base to_base.\n\nReturns NULL if any argument is NULL, or if the second or third argument are\nnot in the allowed range.\n\nThe argument N is interpreted as an integer, but may be specified as an\ninteger or a string. The minimum base is 2 and the maximum base is 36. If\nto_base is a negative number, N is regarded as a signed number. Otherwise, N\nis treated as unsigned. CONV() works with 64-bit precision.\n\nSome shortcuts for this function are also available: BIN(), OCT(), HEX(),\nUNHEX(). Also, MariaDB allows binary literal values and hexadecimal literal\nvalues.\n\nExamples\n--------\n\nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010           |\n+----------------+\n\nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172             |\n+-----------------+\n\nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H               |\n+------------------+\n\nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42                           |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/conv/','','https://mariadb.com/kb/en/conv/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (51,4,'COS','Syntax\n------\n\nCOS(X)\n\nDescription\n-----------\n\nReturns the cosine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n|        -1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/cos/','','https://mariadb.com/kb/en/cos/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (52,4,'COT','Syntax\n------\n\nCOT(X)\n\nDescription\n-----------\n\nReturns the cotangent of X.\n\nExamples\n--------\n\nSELECT COT(42);\n+--------------------+\n| COT(42)            |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n\nSELECT COT(12);\n+---------------------+\n| COT(12)             |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n\nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in \'cot(0)\'\n\nURL: https://mariadb.com/kb/en/cot/','','https://mariadb.com/kb/en/cot/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (53,4,'CRC32','Syntax\n------\n\n<= MariaDB 10.7\n\nCRC32(expr)\n\nFrom MariaDB 10.8\n\nCRC32([par,]expr)\n\nDescription\n-----------\n\nComputes a cyclic redundancy check (CRC) value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is expected to\nbe a string and (if possible) is treated as one if it is not.\n\nUses the ISO 3309 polynomial that used by zlib and many others. MariaDB 10.8\nintroduced the CRC32C() function, which uses the alternate Castagnoli\npolynomia.\n\nMariaDB starting with 10.8\n--------------------------\nOften, CRC is computed in pieces. To facilitate this, MariaDB 10.8.0\nintroduced an optional parameter: CRC32(\'MariaDB\')=CRC32(CRC32(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n|       4227209140 |\n+------------------+\n\nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n|       2594253378 |\n+------------------+\n\nFrom MariaDB 10.8.0\n\nSELECT CRC32(CRC32(\'Maria\'),\'DB\');\n+----------------------------+\n| CRC32(CRC32(\'Maria\'),\'DB\') |\n+----------------------------+\n|                 4227209140 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/crc32/','','https://mariadb.com/kb/en/crc32/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (54,4,'CRC32C','MariaDB starting with 10.8\n--------------------------\nIntroduced in MariaDB 10.8.0 to compute a cyclic redundancy check (CRC) value\nusing the Castagnoli polynomial.\n\nSyntax\n------\n\nCRC32C([par,]expr)\n\nDescription\n-----------\n\nMariaDB has always included a native unary function CRC32() that computes the\nCRC-32 of a string using the ISO 3309 polynomial that used by zlib and many\nothers.\n\nInnoDB and MyRocks use a different polynomial, which was implemented in SSE4.2\ninstructions that were introduced in the Intel Nehalem microarchitecture. This\nis commonly called CRC-32C (Castagnoli).\n\nThe CRC32C function uses the Castagnoli polynomial.\n\nThis allows SELECT…INTO DUMPFILE to be used for the creation of files with\nvalid checksums, such as a logically empty InnoDB redo log file ib_logfile0\ncorresponding to a particular log sequence number.\n\nThe optional parameter allows the checksum to be computed in pieces:\nCRC32C(\'MariaDB\')=CRC32C(CRC32C(\'Maria\'),\'DB\').\n\nExamples\n--------\n\nSELECT CRC32C(\'MariaDB\');\n+-------------------+\n| CRC32C(\'MariaDB\') |\n+-------------------+\n|         809606978 |\n+-------------------+\n\nSELECT CRC32C(CRC32C(\'Maria\'),\'DB\');\n+------------------------------+\n| CRC32C(CRC32C(\'Maria\'),\'DB\') |\n+------------------------------+\n|                    809606978 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/crc32c/','','https://mariadb.com/kb/en/crc32c/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (55,4,'DEGREES','Syntax\n------\n\nDEGREES(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from radians to degrees.\n\nThis is the converse of the RADIANS() function.\n\nExamples\n--------\n\nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n|           180 |\n+---------------+\n\nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n|                90 |\n+-------------------+\n\nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45)     |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/degrees/','','https://mariadb.com/kb/en/degrees/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (56,4,'EXP','Syntax\n------\n\nEXP(X)\n\nDescription\n-----------\n\nReturns the value of e (the base of natural logarithms) raised to the power of\nX. The inverse of this function is LOG() (using a single argument only) or\nLN().\n\nIf X is NULL, this function returns NULL.\n\nExamples\n--------\n\nSELECT EXP(2);\n+------------------+\n| EXP(2)           |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n\nSELECT EXP(-2);\n+--------------------+\n| EXP(-2)            |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n\nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n|      1 |\n+--------+\n\nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n|      NULL |\n+-----------+\n\nURL: https://mariadb.com/kb/en/exp/','','https://mariadb.com/kb/en/exp/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (57,4,'FLOOR','Syntax\n------\n\nFLOOR(X)\n\nDescription\n-----------\n\nReturns the largest integer value not greater than X.\n\nExamples\n--------\n\nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n|           -2 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/floor/','','https://mariadb.com/kb/en/floor/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (58,4,'LN','Syntax\n------\n\nLN(X)\n\nDescription\n-----------\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X. If X\nis less than or equal to 0, or NULL, then NULL is returned.\n\nThe inverse of this function is EXP().\n\nExamples\n--------\n\nSELECT LN(2);\n+-------------------+\n| LN(2)             |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n|   NULL |\n+--------+\n\nURL: https://mariadb.com/kb/en/ln/','','https://mariadb.com/kb/en/ln/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (59,4,'LOG','Syntax\n------\n\nLOG(X), LOG(B,X)\n\nDescription\n-----------\n\nIf called with one parameter, this function returns the natural logarithm of\nX. If X is less than or equal to 0, then NULL is returned.\n\nIf called with two parameters, it returns the logarithm of X to the base B. If\nB is <= 1 or X <= 0, the function returns NULL.\n\nIf any argument is NULL, the function returns NULL.\n\nThe inverse of this function (when called with a single argument) is the EXP()\nfunction.\n\nExamples\n--------\n\nLOG(X):\n\nSELECT LOG(2);\n+-------------------+\n| LOG(2)            |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n\nSELECT LOG(-2);\n+---------+\n| LOG(-2) |\n+---------+\n|    NULL |\n+---------+\n\nLOG(B,X)\n\nSELECT LOG(2,16);\n+-----------+\n| LOG(2,16) |\n+-----------+\n|         4 |\n+-----------+\n\nSELECT LOG(3,27);\n+-----------+\n| LOG(3,27) |\n+-----------+\n|         3 |\n+-----------+\n\nSELECT LOG(3,1);\n+----------+\n| LOG(3,1) |\n+----------+\n|        0 |\n+----------+\n\nSELECT LOG(3,0);\n+----------+\n| LOG(3,0) |\n+----------+\n|     NULL |\n+----------+\n\nURL: https://mariadb.com/kb/en/log/','','https://mariadb.com/kb/en/log/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (60,4,'LOG10','Syntax\n------\n\nLOG10(X)\n\nDescription\n-----------\n\nReturns the base-10 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG10(2);\n+-------------------+\n| LOG10(2)          |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n\nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n|          2 |\n+------------+\n\nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/log10/','','https://mariadb.com/kb/en/log10/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (61,4,'LOG2','Syntax\n------\n\nLOG2(X)\n\nDescription\n-----------\n\nReturns the base-2 logarithm of X.\n\nExamples\n--------\n\nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n|                  42 |\n+---------------------+\n\nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n|          16 |\n+-------------+\n\nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n|       NULL |\n+------------+\n\nURL: https://mariadb.com/kb/en/log2/','','https://mariadb.com/kb/en/log2/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (62,4,'MOD','Syntax\n------\n\nMOD(N,M), N % M, N MOD M\n\nDescription\n-----------\n\nModulo operation. Returns the remainder of N divided by M. See also Modulo\nOperator.\n\nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any number modulus zero\nproduces an error. Otherwise, it returns NULL.\n\nThe integer part of a division can be obtained using DIV.\n\nExamples\n--------\n\nSELECT 1042 % 50;\n+-----------+\n| 1042 % 50 |\n+-----------+\n|        42 |\n+-----------+\n\nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n|            4 |\n+--------------+\n\nSELECT 253 % 7;\n+---------+\n| 253 % 7 |\n+---------+\n|       1 |\n+---------+\n\nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n|         2 |\n+-----------+\n\nSELECT 29 MOD 9;\n+----------+\n| 29 MOD 9 |\n+----------+\n|        2 |\n+----------+\n\nURL: https://mariadb.com/kb/en/mod/','','https://mariadb.com/kb/en/mod/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (63,4,'OCT','Syntax\n------\n\nOCT(N)\n\nDescription\n-----------\n\nReturns a string representation of the octal value of N, where N is a longlong\n(BIGINT) number. This is equivalent to CONV(N,10,8). Returns NULL if N is NULL.\n\nExamples\n--------\n\nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42      |\n+---------+\n\nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14      |\n+---------+\n\nURL: https://mariadb.com/kb/en/oct/','','https://mariadb.com/kb/en/oct/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (64,4,'PI','Syntax\n------\n\nPI()\n\nDescription\n-----------\n\nReturns the value of π (pi). The default number of decimal places displayed is\nsix, but MariaDB uses the full double-precision value internally.\n\nExamples\n--------\n\nSELECT PI();\n+----------+\n| PI()     |\n+----------+\n| 3.141593 |\n+----------+\n\nSELECT PI()+0.0000000000000000000000;\n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n|      3.1415926535897931159980 |\n+-------------------------------+\n\nURL: https://mariadb.com/kb/en/pi/','','https://mariadb.com/kb/en/pi/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (65,4,'POW','Syntax\n------\n\nPOW(X,Y)\n\nDescription\n-----------\n\nReturns the value of X raised to the power of Y.\n\nPOWER() is a synonym.\n\nExamples\n--------\n\nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n|        8 |\n+----------+\n\nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n|      0.25 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/pow/','','https://mariadb.com/kb/en/pow/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (66,4,'POWER','Syntax\n------\n\nPOWER(X,Y)\n\nDescription\n-----------\n\nThis is a synonym for POW(), which returns the value of X raised to the power\nof Y.\n\nURL: https://mariadb.com/kb/en/power/','','https://mariadb.com/kb/en/power/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (67,4,'RADIANS','Syntax\n------\n\nRADIANS(X)\n\nDescription\n-----------\n\nReturns the argument X, converted from degrees to radians. Note that π radians\nequals 180 degrees.\n\nThis is the converse of the DEGREES() function.\n\nExamples\n--------\n\nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45)       |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n\nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90)     |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n\nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI())      |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n\nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180)     |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/radians/','','https://mariadb.com/kb/en/radians/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (68,4,'RAND','Syntax\n------\n\nRAND(), RAND(N)\n\nDescription\n-----------\n\nReturns a random DOUBLE precision floating point value v in the range 0 <= v <\n1.0. If a constant integer argument N is specified, it is used as the seed\nvalue, which produces a repeatable sequence of column values. In the example\nbelow, note that the sequences of values produced by RAND(3) is the same both\nplaces where it occurs.\n\nIn a WHERE clause, RAND() is evaluated each time the WHERE is executed.\n\nStatements using the RAND() function are not safe for statement-based\nreplication.\n\nPractical uses\n--------------\n\nThe expression to get a random integer from a given range is the following:\n\nFLOOR(min_value + RAND() * (max_value - min_value +1))\n\nRAND() is often used to read random rows from a table, as follows:\n\nSELECT * FROM my_table ORDER BY RAND() LIMIT 10;\n\nNote, however, that this technique should never be used on a large table as it\nwill be extremely slow. MariaDB will read all rows in the table, generate a\nrandom value for each of them, order them, and finally will apply the LIMIT\nclause.\n\nExamples\n--------\n\nCREATE TABLE t (i INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.255651095188829 |\n|    2 | 0.833920199269355 |\n|    3 |  0.40264774151393 |\n+------+-------------------+\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nSELECT i, RAND() FROM t;\n+------+-------------------+\n| i    | RAND()            |\n+------+-------------------+\n|    1 | 0.511478140495232 |\n|    2 | 0.349447508668012 |\n|    3 | 0.212803152588013 |\n+------+-------------------+\n\nUsing the same seed, the same sequence will be returned:\n\nSELECT i, RAND(3) FROM t;\n+------+-------------------+\n| i    | RAND(3)           |\n+------+-------------------+\n|    1 |  0.90576975597606 |\n|    2 | 0.373079058130345 |\n|    3 | 0.148086053457191 |\n+------+-------------------+\n\nGenerating a random number from 5 to 15:\n\nSELECT FLOOR(5 + (RAND() * 11));\n\nURL: https://mariadb.com/kb/en/rand/','','https://mariadb.com/kb/en/rand/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (69,4,'ROUND','Syntax\n------\n\nROUND(X), ROUND(X,D)\n\nDescription\n-----------\n\nRounds the argument X to D decimal places. D defaults to 0 if not specified. D\ncan be negative to cause D digits left of the decimal point of the value X to\nbecome zero.\n\nThe rounding algorithm depends on the data type of X:\n\n* for floating point types (FLOAT, DOUBLE) the C libraries rounding function\nis used, so the behavior *may* differ between operating systems\n* for fixed point types (DECIMAL, DEC/NUMBER/FIXED) the \"round half up\" rule\nis used, meaning that e.g. a value ending in exactly .5 is always rounded up.\n\nExamples\n--------\n\nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n|           -1 |\n+--------------+\n\nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n|           -2 |\n+--------------+\n\nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n|           2 |\n+-------------+\n\nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n|             1.3 |\n+-----------------+\n\nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n|                20 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/round/','','https://mariadb.com/kb/en/round/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (70,4,'SIGN','Syntax\n------\n\nSIGN(X)\n\nDescription\n-----------\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X is\nnegative, zero, or positive.\n\nExamples\n--------\n\nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n|        -1 |\n+-----------+\n\nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n|       0 |\n+---------+\n\nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/sign/','','https://mariadb.com/kb/en/sign/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (71,4,'SIN','Syntax\n------\n\nSIN(X)\n\nDescription\n-----------\n\nReturns the sine of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT SIN(PI());\n+----------------------+\n| SIN(PI())            |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n\nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n|                0 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/sin/','','https://mariadb.com/kb/en/sin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (72,4,'SQRT','Syntax\n------\n\nSQRT(X)\n\nDescription\n-----------\n\nReturns the square root of X. If X is negative, NULL is returned.\n\nExamples\n--------\n\nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n|       2 |\n+---------+\n\nSELECT SQRT(20);\n+------------------+\n| SQRT(20)         |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n\nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n|         42 |\n+------------+\n\nURL: https://mariadb.com/kb/en/sqrt/','','https://mariadb.com/kb/en/sqrt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (73,4,'TAN','Syntax\n------\n\nTAN(X)\n\nDescription\n-----------\n\nReturns the tangent of X, where X is given in radians.\n\nExamples\n--------\n\nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n|      0.9999999999999999 |\n+-------------------------+\n\nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI())             |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n\nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1)     |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n\nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/tan/','','https://mariadb.com/kb/en/tan/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (74,4,'TRUNCATE','This page documents the TRUNCATE function. See TRUNCATE TABLE for the DDL\nstatement.\n\nSyntax\n------\n\nTRUNCATE(X,D)\n\nDescription\n-----------\n\nReturns the number X, truncated to D decimal places. If D is 0, the result has\nno decimal point or fractional part. D can be negative to cause D digits left\nof the decimal point of the value X to become zero.\n\nExamples\n--------\n\nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n|               1.2 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n|               1.9 |\n+-------------------+\n\nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n|               -1.9 |\n+--------------------+\n\nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n|              100 |\n+------------------+\n\nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n|                  1028 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/truncate/','','https://mariadb.com/kb/en/truncate/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (75,5,'INSTALL PLUGIN','Syntax\n------\n\nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement installs an individual plugin from the specified library. To\ninstall the whole library (which could be required), use INSTALL SONAME. See\nalso Installing a Plugin.\n\nplugin_name is the name of the plugin as defined in the plugin declaration\nstructure contained in the library file. Plugin names are not case sensitive.\nFor maximal compatibility, plugin names should be limited to ASCII letters,\ndigits, and underscore, because they are used in C source files, shell command\nlines, M4 and Bourne shell scripts, and SQL environments.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension can be omitted (which makes the statement look\nthe same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nINSTALL PLUGIN causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nPLUGIN only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a note instead of\nan error if the specified plugin already exists. See SHOW WARNINGS.\n\nExamples\n--------\n\nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n\nThe extension can also be omitted:\n\nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected (0.104 sec)\n\nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------+\n| Level | Code | Message                            |\n+-------+------+------------------------------------+\n| Note  | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n\nURL: https://mariadb.com/kb/en/install-plugin/','','https://mariadb.com/kb/en/install-plugin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (76,5,'UNINSTALL PLUGIN','Syntax\n------\n\nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n\nDescription\n-----------\n\nThis statement removes a single installed plugin. To uninstall the whole\nlibrary which contains the plugin, use UNINSTALL SONAME. You cannot uninstall\na plugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the mysql.plugin\ntable. The server executes the plugin\'s deinitialization function and removes\nthe row for the plugin from the mysql.plugin table, so that subsequent server\nrestarts will not load and initialize the plugin. UNINSTALL PLUGIN does not\nremove the plugin\'s shared library file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nUNINSTALL PLUGIN example;\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL PLUGIN IF EXISTS example;\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------+\n| Level | Code | Message                       |\n+-------+------+-------------------------------+\n| Note  | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-plugin/','','https://mariadb.com/kb/en/uninstall-plugin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (77,5,'INSTALL SONAME','Syntax\n------\n\nINSTALL SONAME \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of INSTALL PLUGIN. It installs all plugins from a\ngiven plugin_library. See INSTALL PLUGIN for details.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nThe shared library must be located in the plugin directory (that is, the\ndirectory named by the plugin_dir system variable). The library must be in the\nplugin directory itself, not in a subdirectory. By default, plugin_dir is\nplugin directory under the directory named by the pkglibdir configuration\nvariable, but it can be changed by setting the value of plugin_dir at server\nstartup. For example, set its value in a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is taken to be relative\nto the MySQL base directory (the value of the basedir system variable).\n\nINSTALL SONAME adds one or more lines to the mysql.plugin table that describes\nthe plugin. This table contains the plugin name and library file name.\n\nINSTALL SONAME causes the server to read option (my.cnf) files just as during\nserver startup. This enables the plugin to pick up any relevant options from\nthose files. It is possible to add plugin options to an option file even\nbefore loading a plugin (if the loose prefix is used). It is also possible to\nuninstall a plugin, edit my.cnf, and install the plugin again. Restarting the\nplugin this way enables it to the new option values without a server restart.\n\nINSTALL SONAME also loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its initialization\nfunction, which handles any setup that the plugin must perform before it can\nbe used.\n\nTo use INSTALL SONAME, you must have the INSERT privilege for the mysql.plugin\ntable.\n\nAt server startup, the server loads and initializes any plugin that is listed\nin the mysql.plugin table. This means that a plugin is installed with INSTALL\nSONAME only once, not every time the server starts. Plugin loading at startup\ndoes not occur if the server is started with the --skip-grant-tables option.\n\nWhen the server shuts down, it executes the de-initialization function for\neach plugin that is loaded so that the plugin has a chance to perform any\nfinal cleanup.\n\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read system\ntables), use the --plugin-load mysqld option.\n\nIf you need to install only one plugin from a library, use the INSTALL PLUGIN\nstatement.\n\nExamples\n--------\n\nTo load the XtraDB storage engine and all of its information_schema tables\nwith one statement, use\n\nINSTALL SONAME \'ha_xtradb\';\n\nThis statement can be used instead of INSTALL PLUGIN even when the library\ncontains only one plugin:\n\nINSTALL SONAME \'ha_sequence\';\n\nURL: https://mariadb.com/kb/en/install-soname/','','https://mariadb.com/kb/en/install-soname/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (78,5,'UNINSTALL SONAME','Syntax\n------\n\nUNINSTALL SONAME  [IF EXISTS] \'plugin_library\'\n\nDescription\n-----------\n\nThis statement is a variant of UNINSTALL PLUGIN statement, that removes all\nplugins belonging to a specified plugin_library. See UNINSTALL PLUGIN for\ndetails.\n\nplugin_library is the name of the shared library that contains the plugin\ncode. The file name extension (for example, libmyplugin.so or libmyplugin.dll)\ncan be omitted (which makes the statement look the same on all architectures).\n\nTo use UNINSTALL SONAME, you must have the DELETE privilege for the\nmysql.plugin table.\n\nMariaDB starting with 10.4.0\n----------------------------\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the plugin library does not exist. See SHOW WARNINGS.\n\nExamples\n--------\n\nTo uninstall the XtraDB plugin and all of its information_schema tables with\none statement, use\n\nUNINSTALL SONAME \'ha_xtradb\';\n\nFrom MariaDB 10.4.0:\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected (0.099 sec)\n\nUNINSTALL SONAME IF EXISTS \'ha_example\';\nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n\nSHOW WARNINGS;\n+-------+------+-------------------------------------+\n| Level | Code | Message                             |\n+-------+------+-------------------------------------+\n| Note  | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/uninstall-soname/','','https://mariadb.com/kb/en/uninstall-soname/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (79,5,'Plugin Overview','Plugins are server components that enhance MariaDB in some way. These can be\nanything from new storage engines, plugins for enhancing full-text parsing, or\neven small enhancements, such as a plugin to get a timestamp as an integer.\n\nQuerying Plugin Information\n---------------------------\n\nThere are a number of ways to see which plugins are currently active.\n\nA server almost always has a large number of active plugins, because the\nserver contains a large number of built-in plugins, which are active by\ndefault and cannot be uninstalled.\n\nQuerying Plugin Information with SHOW PLUGINS\n---------------------------------------------\n\nThe SHOW PLUGINS statement can be used to query information about all active\nplugins.\n\nFor example:\n\nSHOW PLUGINS\\G;\n********************** 1. row **********************\n Name: binlog\n Status: ACTIVE\n Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n********************** 2. row **********************\n Name: mysql_native_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n********************** 3. row **********************\n Name: mysql_old_password\n Status: ACTIVE\n Type: AUTHENTICATION\nLibrary: NULL\nLicense: GPL\n...\n\nIf a plugin\'s Library column has a NULL value, then the plugin is built-in,\nand it cannot be uninstalled.\n\nQuerying Plugin Information with information_schema.PLUGINS\n-----------------------------------------------------------\n\nThe information_schema.PLUGINS table can be queried to get more detailed\ninformation about plugins.\n\nFor example:\n\nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row ***************************\n     PLUGIN_NAME: CSV\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: Brian Aker, MySQL AB\n  PLUGIN_DESCRIPTION: CSV storage engine\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row ***************************\n     PLUGIN_NAME: MEMORY\n    PLUGIN_VERSION: 1.0\n    PLUGIN_STATUS: ACTIVE\n     PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n    PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n    PLUGIN_AUTHOR: MySQL AB\n  PLUGIN_DESCRIPTION: Hash based, stored in memory, useful for temporary\ntables\n    PLUGIN_LICENSE: GPL\n     LOAD_OPTION: FORCE\n   PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n\nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value, then the plugin is\nbuilt-in, and it cannot be uninstalled.\n\nQuerying Plugin Information with mysql.plugin\n---------------------------------------------\n\nThe mysql.plugin table can be queried to get information about installed\nplugins.\n\nThis table only contains information about plugins that have been installed\nvia the following methods:\n\n* The INSTALL SONAME statement.\n* The INSTALL PLUGIN statement.\n* The mariadb-plugin utility.\n\nThis table does not contain information about:\n\n* Built-in plugins.\n* Plugins loaded with the --plugin-load-add option.\n* Plugins loaded with the --plugin-load option.\n\nThis table only contains enough information to reload the plugin when the\nserver is restarted, which means it only contains the plugin name and the\nplugin library.\n\nFor example:\n\nSELECT * FROM mysql.plugin;\n\n+------+------------+\n| name | dl         |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n\nInstalling a Plugin\n-------------------\n\nThere are three primary ways to install a plugin:\n\n* A plugin can be installed dynamically with an SQL statement.\n* A plugin can be installed with a mariadbd option, but it requires a server\nrestart.\n* A plugin can be installed with the mariadb-plugin utility, while the server\nis completely offline.\n\nWhen you are installing a plugin, you also have to ensure that:\n\n* The server\'s plugin directory is properly configured, and the plugin\'s\nlibrary is in the plugin directory.\n* The server\'s minimum plugin maturity is properly configured, and the plugin\nis mature enough to be installed.\n\nInstalling a Plugin Dynamically\n-------------------------------\n\nA plugin can be installed dynamically by executing either the INSTALL SONAME\nor the INSTALL PLUGIN statement.\n\nIf a plugin is installed with one of these statements, then a record will be\nadded to the mysql.plugins table for the plugin. This means that the plugin\nwill automatically be loaded every time the server restarts, unless\nspecifically uninstalled or deactivated.\n\nInstalling a Plugin with INSTALL SONAME\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL SONAME\nstatement. INSTALL SONAME installs all plugins from the given plugin library.\nThis could be required for some plugin libraries.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin), you could execute the\nfollowing:\n\nINSTALL SONAME \'server_audit\';\n\nInstalling a Plugin with INSTALL PLUGIN\n---------------------------------------\n\nYou can install a plugin dynamically by executing the INSTALL PLUGIN\nstatement. INSTALL PLUGIN installs a single plugin from the given plugin\nlibrary.\n\nFor example, to install the server_audit audit plugin from the server_audit\nplugin library, you could execute the following:\n\nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n\nInstalling a Plugin with Plugin Load Options\n--------------------------------------------\n\nA plugin can be installed with a mariadbd option by providing either the\n--plugin-load-add or the --plugin-load option.\n\nIf a plugin is installed with one of these options, then a record will not be\nadded to the mysql.plugins table for the plugin. This means that if the server\nis restarted without the same option set, then the plugin will not\nautomatically be loaded.\n\nInstalling a Plugin with --plugin-load-add\n------------------------------------------\n\nYou can install a plugin with the --plugin-load-add option by specifying the\noption as a command-line argument to mariadbd or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load-add option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mariadbd --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nSpecial care must be taken when specifying both the --plugin-load option and\nthe --plugin-load-add option together. The --plugin-load option resets the\nplugin load list, and this can cause unexpected problems if you are not aware.\nThe --plugin-load-add option does not reset the plugin load list, so it is\nmuch safer to use. See Specifying Multiple Plugin Load Options for more\ninformation.\n\nInstalling a Plugin with --plugin-load\n--------------------------------------\n\nYou can install a plugin with the --plugin-load option by specifying the\noption as a command-line argument to mariadbd or by specifying the option in a\nrelevant server option group in an option file.\n\nThe --plugin-load option uses the following format:\n\n* Plugins can be specified in the format name=library, where name is the\nplugin name and library is the plugin library. This format installs a single\nplugin from the given plugin library.\n* Plugins can also be specified in the format library, where library is the\nplugin library. This format installs all plugins from the given plugin library.\n* Multiple plugins can be specified by separating them with semicolons.\n\nFor example, to install all plugins in the server_audit plugin library (which\nis currently only the server_audit audit plugin) and also the ed25519\nauthentication plugin from the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n\n$ mariadbd --user=mysql --plugin-load=\'server_audit;ed25519=auth_ed25519\'\n\nYou could also set the option to the same values in an option file:\n\n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option together. The --plugin-load option resets the plugin\nload list, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use. See Specifying Multiple Plugin Load Options for more information.\n\nSpecifying Multiple Plugin Load Options\n---------------------------------------\n\nSpecial care must be taken when specifying the --plugin-load option multiple\ntimes, or when specifying both the --plugin-load option and the\n--plugin-load-add option. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load list, so it is much\nsafer to use.\n\nThis can have the following consequences:\n\n* If the --plugin-load option is specified multiple times, then only the last\ninstance will have any effect. For example, in the following case, the first\ninstance of the option is reset:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* If the --plugin-load option is specified after the --plugin-load-add option,\nthen it will also reset the changes made by that option. For example, in the\nfollowing case, the --plugin-load-add option does not do anything, because the\nsubsequent --plugin-load option resets the plugin load list:\n\n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\n\n* In contrast, if the --plugin-load option is specified before the\n--plugin-load-add option, then it will work fine, because the\n--plugin-load-add option does not reset the plugin load list. For example, in\nthe following case, both plugins are properly loaded:\n\n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n\nInstalling a Plugin with mariadb-plugin\n---------------------------------------\n\nA plugin can be installed with the mariadb-plugin utility if the server is\ncompletely offline.\n\nThe syntax is:\n\nmariadb-plugin [options] <plugin> ENABLE|DISABLE\n\nFor example, to install the server_audit audit plugin, you could execute the\nfollowing:\n\nmariadb-plugin server_audit ENABLE\n\nIf a plugin is installed with this utility, then a record will be added to the\nmysql.plugins table for the plugin. This means that the plugin will\nautomatically be loaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n\nConfiguring the Plugin Directory\n--------------------------------\n\nWhen a plugin is being installed, the server looks for the plugin\'s library in\nthe server\'s plugin directory. This directory is configured by the plugin_dir\nsystem variable. This can be specified as a command-line argument to mariadbd\nor it can be specified in a relevant server option group in an option file.\nFor example:\n\n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n\nConfiguring the Minimum Plugin Maturity\n---------------------------------------\n\nWhen a plugin is being installed, the server compares the plugin\'s maturity\nlevel against the server\'s minimum allowed plugin maturity. This can help\nprevent users from using unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system variable. This can\nbe specified as a command-line argument to mariadbd or it can be specified in\na relevant server option group in an option file. For example:\n\n[mariadb]\n...\nplugin_maturity = stable\n\nConfiguring Plugin Activation at Server Startup\n-----------------------------------------------\n\nA plugin will be loaded by default when the server starts if:\n\n* The plugin was installed with the INSTALL SONAME statement.\n* The plugin was installed with the INSTALL PLUGIN statement.\n* The plugin was installed with the mariadb-plugin utility.\n* The server is configured to load the plugin with the --plugin-load-add\noption.\n* The server is configured to load the plugin with the --plugin-load option.\n\nThis behavior can be changed with special options that take the form\n--plugin-name. For example, for the server_audit audit plugin, the special\noption is called --server-audit.\n\nThe possible values for these special options are:\n\n+---------------------------------------+------------------------------------+\n| Option Value                          | Description                        |\n+---------------------------------------+------------------------------------+\n| OFF                                   | Disables the plugin without        |\n|                                       | removing it from the               |\n|                                       | mysql.plugins table.               |\n+---------------------------------------+------------------------------------+\n| ON                                    | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will still continue         |\n|                                       | starting up, but the plugin will   |\n|                                       | be disabled.                       |\n+---------------------------------------+------------------------------------+','','https://mariadb.com/kb/en/plugin-overview/');
update help_topic set description = CONCAT(description, '\n| FORCE                                 | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error.                             |\n+---------------------------------------+------------------------------------+\n| FORCE_PLUS_PERMANENT                  | Enables the plugin. If the plugin  |\n|                                       | cannot be initialized, then the    |\n|                                       | server will fail to start with an  |\n|                                       | error. In addition, the plugin     |\n|                                       | cannot be uninstalled with         |\n|                                       | UNINSTALL SONAME or UNINSTALL      |\n|                                       | PLUGIN while the server is         |\n|                                       | running.                           |\n+---------------------------------------+------------------------------------+\n\nA plugin\'s status can be found by looking at the PLUGIN_STATUS column of the\ninformation_schema.PLUGINS table.\n\nUninstalling Plugins\n--------------------\n\nPlugins that are found in the mysql.plugin table, that is those that were\ninstalled with INSTALL SONAME, INSTALL PLUGIN or mariadb-plugin can be\nuninstalled in one of two ways:\n\n* The UNINSTALL SONAME or the UNINSTALL PLUGIN statement while the server is\nrunning\n* With mariadb-plugin while the server is offline.\n\nPlugins that were enabled as a --plugin-load option do not need to be\nuninstalled. If --plugin-load is omitted the next time the server starts, or\nthe plugin is not listed as one of the --plugin-load entries, the plugin will\nnot be loaded.\n\nUNINSTALL PLUGIN uninstalls a single installed plugin, while UNINSTALL SONAME\nuninstalls all plugins belonging to a given library.\n\nURL: https://mariadb.com/kb/en/plugin-overview/') WHERE help_topic_id = 79;
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (80,6,'MBR Definition','Description\n-----------\n\nThe MBR (Minimum Bounding Rectangle), or Envelope is the bounding geometry,\nformed by the minimum and maximum (X,Y) coordinates:\n\nExamples\n--------\n\n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: https://mariadb.com/kb/en/mbr-definition/','','https://mariadb.com/kb/en/mbr-definition/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (81,6,'MBRContains','Syntax\n------\n\nMBRContains(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GeomFromText(\'Point(1 1)\');\n\nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrcontains/','','https://mariadb.com/kb/en/mbrcontains/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (82,6,'MBRDisjoint','Syntax\n------\n\nMBRDisjoint(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are disjoint. Two geometries are disjoint if they do not\nintersect, that is touch or overlap.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbrdisjoint/','','https://mariadb.com/kb/en/mbrdisjoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (83,6,'MBREqual','Syntax\n------\n\nMBREqual(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 are the same.\n\nExamples\n--------\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0 0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n|                 0 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/mbrequal/','','https://mariadb.com/kb/en/mbrequal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (84,6,'MBRIntersects','Syntax\n------\n\nMBRIntersects(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 intersect.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      1 |\n+------------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/mbrintersects/','','https://mariadb.com/kb/en/mbrintersects/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (85,6,'MBROverlaps','Syntax\n------\n\nMBROverlaps(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 overlap. The term spatially overlaps is used if two\ngeometries intersect and their intersection results in a geometry of the same\ndimension but not equal to either of the given geometries.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/mbroverlaps/','','https://mariadb.com/kb/en/mbroverlaps/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (86,6,'MBRTouches','Syntax\n------\n\nMBRTouches(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of the two\ngeometries g1 and g2 touch. Two geometries spatially touch if the interiors of\nthe geometries do not intersect, but the boundary of one of the geometries\nintersects either the boundary or the interior of the other.\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/mbrtouches/','','https://mariadb.com/kb/en/mbrtouches/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (87,6,'MBRWithin','Syntax\n------\n\nMBRWithin(g1,g2)\n\nDescription\n-----------\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1 is\nwithin the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nExamples\n--------\n\nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n\nURL: https://mariadb.com/kb/en/mbrwithin/','','https://mariadb.com/kb/en/mbrwithin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (88,7,'CASE OPERATOR','Syntax\n------\n\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nDescription\n-----------\n\nThe first version returns the result where value=compare_value. The second\nversion returns the result for the first condition that is true. If there was\nno matching result value, the result after ELSE is returned, or NULL if there\nis no ELSE part.\n\nThere is also a CASE statement, which differs from the CASE operator described\nhere.\n\nExamples\n--------\n\nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END;\n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE \'more\' END |\n+------------------------------------------------------------+\n| one                                                        |\n+------------------------------------------------------------+\n\nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n\nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END |\n+-----------------------------------------------------+\n|                                                NULL |\n+-----------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/case-operator/','','https://mariadb.com/kb/en/case-operator/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (89,7,'IF Function','Syntax\n------\n\nIF(expr1,expr2,expr3)\n\nDescription\n-----------\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns expr2;\notherwise it returns expr3. IF() returns a numeric or string value, depending\non the context in which it is used.\n\nNote: There is also an IF statement which differs from the IF() function\ndescribed here.\n\nExamples\n--------\n\nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n|           3 |\n+-------------+\n\nSELECT IF(1<2,\'yes\',\'no\');\n+--------------------+\n| IF(1<2,\'yes\',\'no\') |\n+--------------------+\n| yes                |\n+--------------------+\n\nSELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n+---------------------------------------+\n| IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\') |\n+---------------------------------------+\n| no                                    |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/if-function/','','https://mariadb.com/kb/en/if-function/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (90,7,'IFNULL','Syntax\n------\n\nIFNULL(expr1,expr2)\nNVL(expr1,expr2)\n\nDescription\n-----------\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns expr2.\nIFNULL() returns a numeric or string value, depending on the context in which\nit is used.\n\nFrom MariaDB 10.3, NVL() is an alias for IFNULL().\n\nExamples\n--------\n\nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n|           1 |\n+-------------+\n\nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n|              10 |\n+-----------------+\n\nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n|        10.0000 |\n+----------------+\n\nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes               |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/ifnull/','','https://mariadb.com/kb/en/ifnull/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (91,7,'NULLIF','Syntax\n------\n\nNULLIF(expr1,expr2)\n\nDescription\n-----------\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is the\nsame as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nExamples\n--------\n\nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n|        NULL |\n+-------------+\n\nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/nullif/','','https://mariadb.com/kb/en/nullif/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (92,7,'NVL','MariaDB starting with 10.3\n--------------------------\nFrom MariaDB 10.3, NVL is a synonym for IFNULL.\n\nURL: https://mariadb.com/kb/en/nvl/','','https://mariadb.com/kb/en/nvl/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (93,7,'NVL2','MariaDB starting with 10.3\n--------------------------\nThe NLV2 function was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nNVL2(expr1,expr2,expr3)\n\nDescription\n-----------\n\nThe NVL2 function returns a value based on whether a specified expression is\nNULL or not. If expr1 is not NULL, then NVL2 returns expr2. If expr1 is NULL,\nthen NVL2 returns expr3.\n\nExamples\n--------\n\nSELECT NVL2(NULL,1,2);\n+----------------+\n| NVL2(NULL,1,2) |\n+----------------+\n|              2 |\n+----------------+\n\nSELECT NVL2(\'x\',1,2);\n+---------------+\n| NVL2(\'x\',1,2) |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/nvl2/','','https://mariadb.com/kb/en/nvl2/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (94,8,'START TRANSACTION','Syntax\n------\n\nSTART TRANSACTION [transaction_property [, transaction_property] ...] | BEGIN\n[WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\ntransaction_property:\n  WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n\nDescription\n-----------\n\nThe START TRANSACTION or BEGIN statement begins a new transaction. COMMIT\ncommits the current transaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET autocommit\nstatement disables or enables the default autocommit mode for the current\nsession.\n\nSTART TRANSACTION and SET autocommit = 1 implicitly commit the current\ntransaction, if any.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses. CHAIN and RELEASE can be used for additional\ncontrol over transaction completion. The value of the completion_type system\nvariable determines the default completion behavior.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the current\none ends, and the new transaction has the same isolation level as the\njust-terminated transaction. The RELEASE clause causes the server to\ndisconnect the current client session after terminating the current\ntransaction. Including the NO keyword suppresses CHAIN or RELEASE completion,\nwhich can be useful if the completion_type system variable is set to cause\nchaining or release completion by default.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. Note that\nunlike the global read_only mode, READ_ONLY ADMIN (and SUPER before MariaDB\n10.11.0) privilege doesn\'t allow writes and DDL statements on temporary tables\nare not allowed either.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the SET TRANSACTION\nstatement, in which case the specified mode is valid for all sessions, or for\nall subsequent transaction used by the current session.\n\nautocommit\n----------\n\nBy default, MariaDB runs with autocommit mode enabled. This means that as soon\nas you execute a statement that updates (modifies) a table, MariaDB stores the\nupdate on disk to make it permanent. To disable autocommit mode, use the\nfollowing statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to zero,\nchanges to transaction-safe tables (such as those for InnoDB or NDBCLUSTER)\nare not made permanent immediately. You must use COMMIT to store your changes\nto disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the START\nTRANSACTION statement.\n\nDDL Statements\n--------------\n\nDDL statements (CREATE, ALTER, DROP) and administrative statements (FLUSH,\nRESET, OPTIMIZE, ANALYZE, CHECK, REPAIR, CACHE INDEX), transaction management\nstatements (BEGIN, START TRANSACTION) and LOAD DATA INFILE, cause an implicit\nCOMMIT and start a new transaction. An exception to this rule are the DDL that\noperate on temporary tables: you can CREATE, ALTER and DROP them without\ncausing any COMMIT, but those actions cannot be rolled back. This means that\nif you call ROLLBACK, the temporary tables you created in the transaction will\nremain, while the rest of the transaction will be rolled back.\n\nTransactions cannot be used in Stored Functions or Triggers. In Stored\nProcedures and Events BEGIN is not allowed, so you should use START\nTRANSACTION instead.\n\nA transaction acquires a metadata lock on every table it accesses to prevent\nother connections from altering their structure. The lock is released at the\nend of the transaction. This happens even with non-transactional storage\nengines (like MEMORY or CONNECT), so it makes sense to use transactions with\nnon-transactional tables.\n\nin_transaction\n--------------\n\nThe in_transaction system variable is a session-only, read-only variable that\nreturns 1 inside a transaction, and 0 if not in a transaction.\n\nWITH CONSISTENT SNAPSHOT\n------------------------\n\nThe WITH CONSISTENT SNAPSHOT option starts a consistent read for storage\nengines such as InnoDB that can do so, the same as if a START TRANSACTION\nfollowed by a SELECT from any InnoDB table was issued.\n\nSee Enhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n\nExamples\n--------\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nURL: https://mariadb.com/kb/en/start-transaction/','','https://mariadb.com/kb/en/start-transaction/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (95,8,'COMMIT','The COMMIT statement ends a transaction, saving any changes to the data so\nthat they become visible to subsequent transactions. Also, unlocks metadata\nchanged by current transaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all transactions which don\'t end\nwith an explicit COMMIT are implicitly rollbacked and the changes are lost.\nThe ROLLBACK statement can be used to do this explicitly.\n\nThe required syntax for the COMMIT statement is as follows:\n\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n\nCOMMIT is the more important transaction terminator, as well as the more\ninteresting one. The basic form of the COMMIT statement is simply the keyword\nCOMMIT (the keyword WORK is simply noise and can be omitted without changing\nthe effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated.\n\nRELEASE tells the server to disconnect the client immediately after the\ncurrent transaction.\n\nThere are NO RELEASE and AND NO CHAIN options. By default, commits do not\nRELEASE or CHAIN, but it\'s possible to change this default behavior with the\ncompletion_type server system variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n\nURL: https://mariadb.com/kb/en/commit/','','https://mariadb.com/kb/en/commit/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (96,8,'ROLLBACK','The ROLLBACK statement rolls back (ends) a transaction, destroying any changes\nto SQL-data so that they never become visible to subsequent transactions. The\nrequired syntax for the ROLLBACK statement is as follows.\n\nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] {<savepoint name> | <simple target specification>} ]\n\nThe ROLLBACK statement will either end a transaction, destroying all data\nchanges that happened during any of the transaction, or it will just destroy\nany data changes that happened since you established a savepoint. The basic\nform of the ROLLBACK statement is just the keyword ROLLBACK (the keyword WORK\nis simply noise and can be omitted without changing the effect).\n\nThe optional AND CHAIN clause is a convenience for initiating a new\ntransaction as soon as the old transaction terminates. If AND CHAIN is\nspecified, then there is effectively nothing between the old and new\ntransactions, although they remain separate. The characteristics of the new\ntransaction will be the same as the characteristics of the old one — that is,\nthe new transaction will have the same access mode, isolation level and\ndiagnostics area size (we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your DBMS to end the\ntransaction — that is, these four SQL statements are equivalent:\n\nROLLBACK; \nROLLBACK WORK; \nROLLBACK AND NO CHAIN; \nROLLBACK WORK AND NO CHAIN;\n\nAll of them end a transaction without saving any transaction characteristics.\nThe only other options, the equivalent statements:\n\nROLLBACK AND CHAIN;\nROLLBACK WORK AND CHAIN;\n\nboth tell your DBMS to end a transaction, but to save that transaction\'s\ncharacteristics for the next transaction.\n\nROLLBACK is much simpler than COMMIT: it may involve no more than a few\ndeletions (of Cursors, locks, prepared SQL statements and log-file entries).\nIt\'s usually assumed that ROLLBACK can\'t fail, although such a thing is\nconceivable (for example, an encompassing transaction might reject an attempt\nto ROLLBACK because it\'s lining up for a COMMIT).\n\nROLLBACK cancels all effects of a transaction. It does not cancel effects on\nobjects outside the DBMS\'s control (for example the values in host program\nvariables or the settings made by some SQL/CLI function calls). But in\ngeneral, it is a convenient statement for those situations when you say \"oops,\nthis isn\'t working\" or when you simply don\'t care whether your temporary work\nbecomes permanent or not.\n\nHere is a moot question. If all you\'ve been doing is SELECTs, so that there\nhave been no data changes, should you end the transaction with ROLLBACK or\nCOMMIT? It shouldn\'t really matter because both ROLLBACK and COMMIT do the\nsame transaction-terminating job. However, the popular conception is that\nROLLBACK implies failure, so after a successful series of SELECT statements\nthe convention is to end the transaction with COMMIT rather than ROLLBACK.\n\nMariaDB (and most other DBMSs) supports rollback of SQL-data change\nstatements, but not of SQL-Schema statements. This means that if you use any\nof CREATE, ALTER, DROP, GRANT, REVOKE, you are implicitly committing at\nexecution time.\n\nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE; \nROLLBACK;\n\nThe result will be that both the INSERT and the DROP will go through as\nseparate transactions so the ROLLBACK will have no effect.\n\nURL: https://mariadb.com/kb/en/rollback/','','https://mariadb.com/kb/en/rollback/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (97,8,'SET TRANSACTION','Syntax\n------\n\nSET [GLOBAL | SESSION] TRANSACTION\n  transaction_property [, transaction_property] ...\n\ntransaction_property:\n  ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n\nlevel:\n  REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n\nDescription\n-----------\n\nThis statement sets the transaction isolation level or the transaction access\nmode globally, for the current session, or for the next transaction:\n\n* With the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions. Existing sessions are\n unaffected.\n* With the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed within the\n current session.\n* Without any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not started) transaction\n performed within the current session.\n\nA change to the global default isolation level requires the SUPER privilege.\nAny session is free to change its session isolation level (even in the middle\nof a transaction), or the isolation level for its next transaction.\n\nIsolation Level\n---------------\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option on the command line or in an option file.\nValues of level for this option use dashes rather than spaces, so the\nallowable values are READ_UNCOMMITTED, READ-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation level to REPEATABLE\nREAD, use these lines in the [mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation levels at runtime,\ncheck the value of the tx_isolation system variable (note that the variable\nhas been renamed transaction_isolation from MariaDB 11.1.1, to match the\noption, and the old name deprecated).\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nFrom MariaDB 11.1.1:\n\nSELECT @@GLOBAL.transaction_isolation, @@transaction_isolation;\n\nInnoDB supports each of the translation isolation levels described here using\ndifferent locking strategies. The default level is REPEATABLE READ. For\nadditional information about InnoDB record-level locks and how it uses them to\nexecute various types of statements, see InnoDB Lock Modes, and\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n\nIsolation Levels\n----------------\n\nThe following sections describe how MariaDB supports the different transaction\nlevels.\n\nREAD UNCOMMITTED\n----------------\n\nSELECT statements are performed in a non-locking fashion, but a possible\nearlier version of a row might be used. Thus, using this isolation level, such\nreads are not consistent. This is also called a \"dirty read.\" Otherwise, this\nisolation level works like READ COMMITTED.\n\nREAD COMMITTED\n--------------\n\nA somewhat Oracle-like isolation level with respect to consistent\n(non-locking) reads: Each consistent read, even within the same transaction,\nsets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), InnoDB locks\nonly index records, not the gaps before them, and thus allows the free\ninsertion of new records next to locked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a unique index with\na unique search condition (such as WHERE id = 100), or a range-type search\ncondition (such as WHERE id > 100). For a unique index with a unique search\ncondition, InnoDB locks only the index record found, not the gap before it.\nFor range-type searches, InnoDB locks the index range scanned, using gap locks\nor next-key (gap plus index-record) locks to block insertions by other\nsessions into the gaps covered by the range. This is necessary because\n\"phantom rows\" must be blocked for MySQL replication and recovery to work.\n\nNote: If the READ COMMITTED isolation level is used or the\ninnodb_locks_unsafe_for_binlog system variable is enabled, there is no InnoDB\ngap locking except for foreign-key constraint checking and duplicate-key\nchecking. Also, record locks for non-matching rows are released after MariaDB\nhas evaluated the WHERE condition.If you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based binary logging.\n\nREPEATABLE READ\n---------------\n\nThis is the default isolation level for InnoDB. For consistent reads, there is\nan important difference from the READ COMMITTED isolation level: All\nconsistent reads within the same transaction read the snapshot established by\nthe first read. This convention means that if you issue several plain\n(non-locking) SELECT statements within the same transaction, these SELECT\nstatements are consistent also with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n\nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE), UPDATE, and\nDELETE statements, locking depends on whether the statement uses a unique\nindex with a unique search condition, or a range-type search condition. For a\nunique index with a unique search condition, InnoDB locks only the index\nrecord found, not the gap before it. For other search conditions, InnoDB locks\nthe index range scanned, using gap locks or next-key (gap plus index-record)\nlocks to block insertions by other sessions into the gaps covered by the range.\n\nThis is the minimum isolation level for non-distributed XA transactions.\n\nSERIALIZABLE\n------------\n\nThis level is like REPEATABLE READ, but InnoDB implicitly converts all plain\nSELECT statements to SELECT ... LOCK IN SHARE MODE if autocommit is disabled.\nIf autocommit is enabled, the SELECT is its own transaction. It therefore is\nknown to be read only and can be serialized if performed as a consistent\n(non-locking) read and need not block for other transactions. (This means that\nto force a plain SELECT to block if other transactions have modified the\nselected rows, you should disable autocommit.)\n\nDistributed XA transactions should always use this isolation level.\n\nAccess Mode\n-----------\n\nThe access mode specifies whether the transaction is allowed to write data or\nnot. By default, transactions are in READ WRITE mode (see the tx_read_only\nsystem variable). READ ONLY mode allows the storage engine to apply\noptimizations that cannot be used for transactions which write data. Note that\nunlike the global read_only mode, READ_ONLY ADMIN (and SUPER before MariaDB\n10.11.0) privilege doesn\'t allow writes and DDL statements on temporary tables\nare not allowed either.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the same\nstatement.\n\nREAD WRITE and READ ONLY can also be specified in the START TRANSACTION\nstatement, in which case the specified mode is only valid for one transaction.\n\nExamples\n--------\n\nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n\nAttempting to set the isolation level within an existing transaction without\nspecifying GLOBAL or SESSION.\n\nSTART TRANSACTION;\n\nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed while a\ntransaction is in progress\n\nURL: https://mariadb.com/kb/en/set-transaction/','','https://mariadb.com/kb/en/set-transaction/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (98,8,'LOCK TABLES','Syntax\n------\n\nLOCK TABLE[S]\n  tbl_name [[AS] alias] lock_type\n  [, tbl_name [[AS] alias] lock_type] ...\n  [WAIT n|NOWAIT]\n\nlock_type:\n  READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nThe lock_type can be one of:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| READ                      | Read lock, no writes allowed                   |\n+---------------------------+------------------------------------------------+\n| READ LOCAL                | Read lock, but allow concurrent inserts        |\n+---------------------------+------------------------------------------------+\n| WRITE                     | Exclusive write lock. No other connections     |\n|                           | can read or write to this table                |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY WRITE        | Exclusive write lock, but allow new read       |\n|                           | locks on the table until we get the write      |\n|                           | lock.                                          |\n+---------------------------+------------------------------------------------+\n| WRITE CONCURRENT          | Exclusive write lock, but allow READ LOCAL     |\n|                           | locks to the table.                            |\n+---------------------------+------------------------------------------------+\n\nMariaDB enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to prevent\nother sessions from modifying tables during periods when a session requires\nexclusive access to them. A session can acquire or release locks only for\nitself. One session cannot acquire locks for another session or release locks\nheld by another session.\n\nLocks may be used to emulate transactions or to get more speed when updating\ntables.\n\nLOCK TABLES explicitly acquires table locks for the current client session.\nTable locks can be acquired for base tables or views. To use LOCK TABLES, you\nmust have the LOCK TABLES privilege, and the SELECT privilege for each object\nto be locked. See GRANT\n\nFor view locking, LOCK TABLES adds all base tables used in the view to the set\nof tables to be locked and locks them automatically. If you lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are also locked\nimplicitly, as described in Triggers and Implicit Locks.\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\n\nMariaDB starting with 10.3.0\n----------------------------\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nLimitations\n-----------\n\n* LOCK TABLES doesn\'t work when using Galera cluster.   You may experience\ncrashes or locks when used with Galera.\n* LOCK TABLES works on XtraDB/InnoDB tables only if the innodb_table_locks\nsystem variable is set to 1 (the default) and autocommit is set to 0 (1 is\ndefault). Please note that no error message will be returned on LOCK TABLES\nwith innodb_table_locks = 0.\n* LOCK TABLES implicitly commits the active transaction, if any. Also,\nstarting a transaction always releases all table locks acquired with LOCK\nTABLES. This means that there is no way to have table locks and an active\ntransaction at the same time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between transactional and\nnon-transactional tables, the GET_LOCK() function can be used.\n* When using LOCK TABLES on a TEMPORARY table, it will always be locked with a\nWRITE lock.\n* While a connection holds an explicit read lock on a table, it cannot modify\nit. If you try, the following error will be produced:\n\nERROR 1099 (HY000): Table \'tab_name\' was locked with a READ lock and can\'t be\nupdated\n\n* While a connection holds an explicit lock on a table, it cannot access a\nnon-locked table. If you try, the following error will be produced:\n\nERROR 1100 (HY000): Table \'tab_name\' was not locked with LOCK TABLES\n\n* While a connection holds an explicit lock on a table, it cannot issue the\nfollowing: INSERT DELAYED, CREATE TABLE, CREATE TABLE ... LIKE, and DDL\nstatements involving stored programs and views (except for triggers). If you\ntry, the following error will be produced:\n\nERROR 1192 (HY000): Can\'t execute the given command because you have active\nlocked tables or an active transaction\n\n* LOCK TABLES can not be used in stored routines - if you try, the following\nerror will be produced on creation:\n\nERROR 1314 (0A000): LOCK is not allowed in stored procedures\n\nURL: https://mariadb.com/kb/en/lock-tables/','','https://mariadb.com/kb/en/lock-tables/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (99,8,'SAVEPOINT','Syntax\n------\n\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nDescription\n-----------\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT, RELEASE\nSAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nEach savepoint must have a legal MariaDB identifier. A savepoint is a named\nsub-transaction.\n\nNormally ROLLBACK undoes the changes performed by the whole transaction. When\nused with the TO clause, it undoes the changes performed after the specified\nsavepoint, and erases all subsequent savepoints. However, all locks that have\nbeen acquired after the save point will survive. RELEASE SAVEPOINT does not\nrollback or commit any changes, but removes the specified savepoint.\n\nWhen the execution of a trigger or a stored function begins, it is not\npossible to use statements which reference a savepoint which was defined from\nout of that stored program.\n\nWhen a COMMIT (including implicit commits) or a ROLLBACK statement (with no TO\nclause) is performed, they act on the whole transaction, and all savepoints\nare removed.\n\nErrors\n------\n\nIf COMMIT or ROLLBACK is issued and no transaction was started, no error is\nreported.\n\nIf SAVEPOINT is issued and no transaction was started, no error is reported\nbut no savepoint is created. When ROLLBACK TO SAVEPOINT or RELEASE SAVEPOINT\nis called for a savepoint that does not exist, an error like this is issued:\n\nERROR 1305 (42000): SAVEPOINT svp_name does not exist\n\nURL: https://mariadb.com/kb/en/savepoint/','','https://mariadb.com/kb/en/savepoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (100,8,'Metadata Locking','MariaDB supports metadata locking. This means that when a transaction\n(including XA transactions) uses a table, it locks its metadata until the end\nof transaction. Non-transactional tables are also locked, as well as views and\nobjects which are related to locked tables/views (stored functions, triggers,\netc). When a connection tries to use a DDL statement (like an ALTER TABLE)\nwhich modifies a table that is locked, that connection is queued, and has to\nwait until it\'s unlocked. Using savepoints and performing a partial rollback\ndoes not release metadata locks.\n\nLOCK TABLES ... WRITE are also queued. Some wrong statements which produce an\nerror may not need to wait for the lock to be freed.\n\nThe metadata lock\'s timeout is determined by the value of the\nlock_wait_timeout server system variable (in seconds). However, note that its\ndefault value is 31536000 (1 year, MariaDB <= 10.2.3), or 86400 (1 day,\nMariaDB >= 10.2.4). If this timeout is exceeded, the following error is\nreturned:\n\nERROR 1205 (HY000): Lock wait timeout exceeded; try restarting transaction\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table stores information about existing metadata locks.\n\nMariaDB starting with 10.5.2\n----------------------------\nFrom MariaDB 10.5, the Performance Schema metadata_locks table contains\nmetadata lock information.\n\nExample\n-------\n\nLet\'s use the following MEMORY (non-transactional) table:\n\nCREATE TABLE t (a INT) ENGINE = MEMORY;\n\nConnection 1 starts a transaction, and INSERTs a row into t:\n\nSTART TRANSACTION;\n\nINSERT INTO t SET a=1;\n\nt\'s metadata is now locked by connection 1. Connection 2 tries to alter t, but\nhas to wait:\n\nALTER TABLE t ADD COLUMN b INT;\n\nConnection 2\'s prompt is blocked now.\n\nNow connection 1 ends the transaction:\n\nCOMMIT;\n\n...and connection 2 finally gets the output of its command:\n\nQuery OK, 1 row affected (35.23 sec)\nRecords: 1  Duplicates: 0  Warnings: 0\n\nURL: https://mariadb.com/kb/en/metadata-locking/','','https://mariadb.com/kb/en/metadata-locking/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (101,8,'Transaction Timeouts','MariaDB has always had the wait_timeout and interactive_timeout settings,\nwhich close connections after a certain period of inactivity.\n\nHowever, these are by default set to a long wait period. In situations where\ntransactions may be started, but not committed or rolled back, more granular\ncontrol and a shorter timeout may be desirable so as to avoid locks being held\nfor too long.\n\nMariaDB 10.3 introduced three new variables to handle this situation.\n\n* idle_transaction_timeout (all transactions)\n* idle_write_transaction_timeout (write transactions - called\nidle_readwrite_transaction_timeout until MariaDB 10.3.2)\n* idle_readonly_transaction_timeout (read transactions)\n\nThese accept a time in seconds to time out, by closing the connection,\ntransactions that are idle for longer than this period. By default all are set\nto zero, or no timeout.\n\nidle_transaction_timeout affects all transactions,\nidle_write_transaction_timeout affects write transactions only and\nidle_readonly_transaction_timeout affects read transactions only. The latter\ntwo variables work independently. However, if either is set along with\nidle_transaction_timeout, the settings for idle_write_transaction_timeout or\nidle_readonly_transaction_timeout will take precedence.\n\nExamples\n--------\n\nSET SESSION idle_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_write_transaction_timeout=2;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\nINSERT INTO t VALUES(1);\n## wait 3 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nSET SESSION idle_transaction_timeout=2, SESSION\nidle_readonly_transaction_timeout=10;\nBEGIN;\nSELECT * FROM t;\nEmpty set (0.000 sec)\n ## wait 3 seconds\nSELECT * FROM t;\nEmpty set (0.000 sec)\n## wait 11 seconds\nSELECT * FROM t;\nERROR 2006 (HY000): MySQL server has gone away\n\nURL: https://mariadb.com/kb/en/transaction-timeouts/','','https://mariadb.com/kb/en/transaction-timeouts/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (102,8,'UNLOCK TABLES','Syntax\n------\n\nUNLOCK TABLES\n\nDescription\n-----------\n\nUNLOCK TABLES explicitly releases any table locks held by the current session.\nSee LOCK TABLES for more information.\n\nIn addition to releasing table locks acquired by the LOCK TABLES statement,\nthe UNLOCK TABLES statement also releases the global read lock acquired by the\nFLUSH TABLES WITH READ LOCK statement. The FLUSH TABLES WITH READ LOCK\nstatement is very useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n\nURL: https://mariadb.com/kb/en/transactions-unlock-tables/','','https://mariadb.com/kb/en/transactions-unlock-tables/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (103,8,'WAIT and NOWAIT','Extended syntax so that it is possible to set innodb_lock_wait_timeout and\nlock_wait_timeout for the following statements:\n\nSyntax\n------\n\nALTER TABLE tbl_name [WAIT n|NOWAIT] ...\nCREATE ... INDEX ON tbl_name (index_col_name, ...) [WAIT n|NOWAIT] ...\nDROP INDEX ... [WAIT n|NOWAIT]\nDROP TABLE tbl_name [WAIT n|NOWAIT] ...\nLOCK TABLE ... [WAIT n|NOWAIT]\nOPTIMIZE TABLE tbl_name [WAIT n|NOWAIT]\nRENAME TABLE tbl_name [WAIT n|NOWAIT] ...\nSELECT ... FOR UPDATE [WAIT n|NOWAIT]\nSELECT ... LOCK IN SHARE MODE [WAIT n|NOWAIT]\nTRUNCATE TABLE tbl_name [WAIT n|NOWAIT]\n\nDescription\n-----------\n\nThe lock wait timeout can be explicitly set in the statement by using either\nWAIT n (to set the wait in seconds) or NOWAIT, in which case the statement\nwill immediately fail if the lock cannot be obtained. WAIT 0 is equivalent to\nNOWAIT.\n\nURL: https://mariadb.com/kb/en/wait-and-nowait/','','https://mariadb.com/kb/en/wait-and-nowait/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (104,8,'XA Transactions','Overview\n--------\n\nThe MariaDB XA implementation is based on the X/Open CAE document Distributed\nTransaction Processing: The XA Specification. This document is published by\nThe Open Group and available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n\nXA transactions are designed to allow distributed transactions, where a\ntransaction manager (the application) controls a transaction which involves\nmultiple resources. Such resources are usually DBMSs, but could be resources\nof any type. The whole set of required transactional operations is called a\nglobal transaction. Each subset of operations which involve a single resource\nis called a local transaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to prepare an effective\ncommit, and waits for a confirm message. The changes are not still made\neffective at this point. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If all resources\ncommunicate that the first commit is successful, the transaction manager can\nrequire a second commit, which makes the changes effective.\n\nIn MariaDB, XA transactions can only be used with storage engines that support\nthem. At least InnoDB, TokuDB, SPIDER and MyRocks support them. For InnoDB,\nuntil MariaDB 10.2, XA transactions can be disabled by setting the\ninnodb_support_xa server system variable to 0. From MariaDB 10.3, XA\ntransactions are always supported.\n\nLike regular transactions, XA transactions create metadata locks on accessed\ntables.\n\nXA transactions require REPEATABLE READ as a minimum isolation level. However,\ndistributed transactions should always use SERIALIZABLE.\n\nTrying to start more than one XA transaction at the same time produces a 1400\nerror (SQLSTATE \'XAE09\'). The same error is produced when attempting to start\nan XA transaction while a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect produces a 1399 error\n(SQLSTATE \'XAE07\').\n\nThe statements that cause an implicit COMMIT for regular transactions produce\na 1400 error (SQLSTATE \'XAE09\') if a XA transaction is in effect.\n\nInternal XA vs External XA\n--------------------------\n\nXA transactions are an overloaded term in MariaDB. If a storage engine is\nXA-capable, it can mean one or both of these:\n\n* It supports MariaDB\'s internal two-phase commit API. This is transparent to\nthe user. Sometimes this is called \"internal XA\", since MariaDB\'s internal\ntransaction coordinator log can handle coordinating these transactions.\n\n* It supports XA transactions, with the XA START, XA PREPARE, XA COMMIT, etc.\nstatements. Sometimes this is called \"external XA\", since it requires the use\nof an external transaction coordinator to use this feature properly.\n\nTransaction Coordinator Log\n---------------------------\n\nIf you have two or more XA-capable storage engines enabled, then a transaction\ncoordinator log must be available.\n\nThere are currently two implementations of the transaction coordinator log:\n\n* Binary log-based transaction coordinator log\n* Memory-mapped file-based transaction coordinator log\n\nIf the binary log is enabled on a server, then the server will use the binary\nlog-based transaction coordinator log. Otherwise, it will use the\nmemory-mapped file-based transaction coordinator log.\n\nSee Transaction Coordinator Log for more information.\n\nSyntax\n------\n\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n\nxid: gtrid [, bqual [, formatID ]]\n\nThe interface to XA transactions is a set of SQL statements starting with XA.\nEach statement changes a transaction\'s state, determining which actions it can\nperform. A transaction which does not exist is in the NON-EXISTING state.\n\nXA START (or BEGIN) starts a transaction and defines its xid (a transaction\nidentifier). The JOIN or RESUME keywords have no effect. The new transaction\nwill be in ACTIVE state.\n\nThe xid can have 3 components, though only the first one is mandatory. gtrid\nis a quoted string representing a global transaction identifier. bqual is a\nquoted string representing a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first two components; if\nnot specified, defaults to 1. MariaDB does not interpret in any way these\ncomponents, and only uses them to identify a transaction. xids of transactions\nin effect must be unique.\n\nXA END declares that the specified ACTIVE transaction is finished and it\nchanges its state to IDLE. SUSPEND [FOR MIGRATE] has no effect.\n\nXA PREPARE prepares an IDLE transaction for commit, changing its state to\nPREPARED. This is the first commit.\n\nXA COMMIT definitely commits and terminates a transaction which has already\nbeen PREPARED. If the ONE PHASE clause is specified, this statements performs\na 1-phase commit on an IDLE transaction.\n\nXA ROLLBACK rolls back and terminates an IDLE or PREPARED transaction.\n\nXA RECOVER shows information about all PREPARED transactions.\n\nWhen trying to execute an operation which is not allowed for the transaction\'s\ncurrent state, an error is produced:\n\nXA COMMIT \'test\' ONE PHASE;\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  ACTIVE state\n\nXA COMMIT \'test2\';\nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be executed when global\ntransaction is in the  NON-EXISTING state\n\nXA RECOVER\n----------\n\nThe XA RECOVER statement shows information about all transactions which are in\nthe PREPARED state. It does not matter which connection created the\ntransaction: if it has been PREPARED, it appears. But this does not mean that\na connection can commit or rollback a transaction which was started by another\nconnection. Note that transactions using a 1-phase commit are never in the\nPREPARED state, so they cannot be shown by XA RECOVER.\n\nXA RECOVER produces four columns:\n\nXA RECOVER;\n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n|        1 |            4 |            0 | test |\n+----------+--------------+--------------+------+\n\nMariaDB starting with 10.3.3\n----------------------------\nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a human readable form\nthat can be directly copy-pasted into XA COMMIT or XA ROLLBACK. This is\nparticularly useful for binary xid generated by some transaction coordinators.\n\nformatID is the formatID part of xid.\n\ndata are the gtrid and bqual parts of xid, concatenated.\n\ngtrid_length and bqual_length are the lengths of gtrid and bqual, respectevely.\n\nExamples\n--------\n\n2-phases commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA PREPARE \'test\';\n\nXA COMMIT \'test\';\n\n1-phase commit:\n\nXA START \'test\';\n\nINSERT INTO t VALUES (1,2);\n\nXA END \'test\';\n\nXA COMMIT \'test\' ONE PHASE;\n\nHuman-readable:\n\nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\ninsert t1 values (40);\n\nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n\nxa recover format=\'RAW\';\n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data               |\n+----------+--------------+--------------+--------------------+\n34      67v78abc       11 |            7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n\nxa recover format=\'SQL\';\n+----------+--------------+--------------+-------------------------------------\n---------+\n| formatID | gtrid_length | bqual_length | data                               \n     |\n+----------+--------------+--------------+-------------------------------------\n---------+\n|        3 |           11 |            7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-------------------------------------\n---------+\n\nxa rollback X\'31320d3334093637763738\',X\'6162630a646566\',3;\n\nKnown Issues\n------------\n\nMariaDB Galera Cluster\n----------------------\n\nMariaDB Galera Cluster does not support XA transactions.\n\nHowever, MariaDB Galera Cluster builds include a built-in plugin called wsrep.\nPrior to MariaDB 10.4.3, this plugin was internally considered an XA-capable\nstorage engine. Consequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the only \"real\"\nstorage engine that supports external XA transactions enabled on these builds\nby default is InnoDB. Therefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default, which could have\nperformance implications.\n\nSee Transaction Coordinator Log Overview: MariaDB Galera Cluster for more\ninformation.\n\nURL: https://mariadb.com/kb/en/xa-transactions/','','https://mariadb.com/kb/en/xa-transactions/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (105,10,'CREATE USER','Syntax\n------\n\nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe CREATE USER statement creates new MariaDB accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE USER creates a new row in mysql.user (until\nMariaDB 10.3 this is a table, from MariaDB 10.4 it\'s a view) or\nmysql.global_priv_table (from MariaDB 10.4) that has no privileges.\n\nIf any of the specified accounts, or any permissions for the specified\naccounts, already exist, then the server returns ERROR 1396 (HY000). If an\nerror occurs, CREATE USER will still create the accounts that do not result in\nan error. Only one error is produced for all users which have not been created:\n\nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all produce the same error\ncode when they fail.\n\nSee Account Names below for details on how account names are specified.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it is basically a shortcut for:\n\nDROP USER IF EXISTS name;\nCREATE USER name ...;\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected (0.00 sec)\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified user already exists.\n\nFor example:\n\nCREATE USER foo2@test IDENTIFIED BY \'password\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'foo2\'@\'test\'\n\nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY \'password\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+----------------------------------------------------+\n| Level | Code | Message                                            |\n+-------+------+----------------------------------------------------+\n| Note  | 1973 | Can\'t create user \'foo2\'@\'test\'; it already exists |\n+-------+------+----------------------------------------------------+\n\nAuthentication Options\n----------------------\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored in the\nmysql.user/mysql.global_priv_table table.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored in the\nmysql.user/mysql.global_priv_table table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nCREATE USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\') OR\nunix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |','','https://mariadb.com/kb/en/create-user/');
update help_topic set description = CONCAT(description, '\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to create a user with resource limits:\n\nCREATE USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mariadb-admin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nAccount Names\n-------------\n\nAccount names have both a user name component and a host name component, and\nare specified as \'user_name\'@\'host_name\'.\n\nThe user name and host name may be unquoted, quoted as strings using double\nquotes (\") or single quotes (\'), or quoted as identifiers using backticks (`).\nYou must use quotes when using special characters (such as a hyphen) or\nwildcard characters. If you quote, you must quote the user name and host name\nseparately (for example \'user_name\'@\'host_name\').\n\nHost Name Component\n-------------------\n\nIf the host name is not provided, it is assumed to be \'%\'.\n\nHost names may contain the wildcard characters % and _. They are matched as if\nby the LIKE clause. If you need to use a wildcard character literally (for\nexample, to match a domain name with an underscore), prefix the character with\na backslash. See LIKE for more information on escaping wildcard characters.\n\nHost name matches are case-insensitive. Host names can match either domain\nnames or IP addresses. Use \'localhost\' as the host name to allow only local\nclient connections. On Linux, the loopback interface (127.0.0.1) will not\nmatch \'localhost\' as it is not considered a local connection: this means that\nonly connections via UNIX-domain sockets will match \'localhost\'.\n\nYou can use a netmask to match a range of IP addresses using \'base_ip/netmask\'\nas the host name. A user with an IP address ip_addr will be allowed to connect\nif the following condition is true:\n\nip_addr & netmask = base_ip\n\nFor example, given a user:\n\nCREATE USER \'maria\'@\'247.150.130.0/255.255.255.0\';\n\nthe IP addresses satisfying this condition range from 247.150.130.0 to\n247.150.130.255.\n\nUsing 255.255.255.255 is equivalent to not using a netmask at all. Netmasks\ncannot be used for IPv6 addresses.\n\nNote that the credentials added when creating a user with the \'%\' wildcard\nhost will not grant access in all cases. For example, some systems come with\nan anonymous localhost user, and when connecting from localhost this will take\nprecedence.\n\nBefore MariaDB 10.6, the host name component could be up to 60 characters in\nlength. Starting from MariaDB 10.6, it can be up to 255 characters.\n\nUser Name Component\n-------------------\n\nUser names must match exactly, including case. A user name that is empty is\nknown as an anonymous account and is allowed to match a login attempt with any\nuser name component. These are described more in the next section.\n\nFor valid identifiers to use as user names, see Identifier Names.\n\nIt is possible for more than one account to match when a user connects.\nMariaDB selects the first matching account after sorting according to the\nfollowing criteria:\n\n* Accounts with an exact host name are sorted before accounts using a wildcard\nin the\nhost name. Host names using a netmask are considered to be exact for sorting.\n* Accounts with a wildcard in the host name are sorted according to the\nposition of\nthe first wildcard character. Those with a wildcard character later in the\nhost name\nsort before those with a wildcard character earlier in the host name.\n* Accounts with a non-empty user name sort before accounts with an empty user\nname.\n* Accounts with an empty user name are sorted last. As mentioned previously,\nthese are known as anonymous accounts. These are described more in the next\nsection.\n\nThe following table shows a list of example account as sorted by these\ncriteria:\n\n+---------+-------------+\n| User    | Host        |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n|         | 192.168.0.% |\n| joffrey | 192.168.%   |\n|         | 192.168.%   |\n+---------+-------------+\n\nOnce connected, you only have the privileges granted to the account that\nmatched, not all accounts that could have matched. For example, consider the\nfollowing commands:\n\nCREATE USER \'joffrey\'@\'192.168.0.3\';\nCREATE USER \'joffrey\'@\'%\';\nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n\nIf you connect as joffrey from 192.168.0.3, you will have the SELECT privilege\non the table test.t1, but not on the table test.t2. If you connect as joffrey\nfrom any other IP address, you will have the SELECT privilege on the table\ntest.t2, but not on the table test.t1.\n\nUsernames can be up to 80 characters long before 10.6 and starting from 10.6\nit can be 128 characters long.\n\nAnonymous Accounts\n------------------\n\nAnonymous accounts are accounts where the user name portion of the account\nname is empty. These accounts act as special catch-all accounts. If a user\nattempts to log into the system from a host, and an anonymous account exists\nwith a host name portion that matches the user\'s host, then the user will log\nin as the anonymous account if there is no more specific account match for the\nuser name that the user entered.\n\nFor example, here are some anonymous accounts:\n\nCREATE USER \'\'@\'localhost\';\nCREATE USER \'\'@\'192.168.0.3\';\n\nFixing a Legacy Default Anonymous Account\n-----------------------------------------\n\nOn some systems, the mysql.db table has some entries for the \'\'@\'%\' anonymous\naccount by default. Unfortunately, there is no matching entry in the\nmysql.user/mysql.global_priv_table table, which means that this anonymous\naccount doesn\'t exactly exist, but it does have privileges--usually on the\ndefault test database created by mariadb-install-db. These account-less\nprivileges are a legacy that is leftover from a time when MySQL\'s privilege\nsystem was less advanced.\n\nThis situation means that you will run into errors if you try to create a\n\'\'@\'%\' account. For example:\n\nCREATE USER \'\'@\'%\';\nERROR 1396 (HY000): Operation CREATE USER failed for \'\'@\'%\'\n\nThe fix is to DELETE the row in the mysql.db table and then execute FLUSH\nPRIVILEGES:\n\nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\nFLUSH PRIVILEGES;\n\nAnd then the account can be created:\n\nCREATE USER \'\'@\'%\';\nQuery OK, 0 rows affected (0.01 sec)\n\nSee MDEV-13486 for more information.\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/create-user/') WHERE help_topic_id = 105;
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (106,10,'ALTER USER','Syntax\n------\n\nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [lock_option] [password_option]\n\nuser_specification:\n username [authentication_option]\n\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule] ...\n\nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\ntls_option\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n\nlock_option:\n  ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n\nDescription\n-----------\n\nThe ALTER USER statement modifies existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. The global SUPER privilege is also required if the read_only\nsystem variable is enabled.\n\nIf any of the specified user accounts do not yet exist, an error results. If\nan error occurs, ALTER USER will still modify the accounts that do not result\nin an error. Only one error is produced for all users which have not been\nmodified.\n\nIF EXISTS\n---------\n\nWhen the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror for each specified user that does not exist.\n\nAccount Names\n-------------\n\nFor ALTER USER statements, account names are specified as the username\nargument in the same way as they are for CREATE USER statements. See account\nnames from the CREATE USER page for details on how account names are specified.\n\nCURRENT_USER or CURRENT_USER() can also be used to alter the account logged\ninto the current session. For example, to change the current user\'s password\nto mariadb:\n\nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n\nAuthentication Options\n----------------------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to slowly migrate users\nto the more secure ed25519 authentication plugin over time, while allowing the\nold mysql_native_password authentication plugin as an alternative for the\ntransitional period. See Authentication from MariaDB 10.4 for more.\n\nWhen running ALTER USER, not specifying an authentication option in the\nIDENTIFIED VIA clause will remove that authentication method. (However this\nwas not the case before MariaDB 10.4.13, see MDEV-21928)\n\nFor example, a user is created with the ability to authenticate via both a\npassword and unix_socket:\n\nCREATE USER \'bob\'@\'localhost\' \n IDENTIFIED VIA mysql_native_password USING PASSWORD(\'pwd\')\n OR unix_socket;\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED VIA mysql_native_password\n USING \'*975B2CD4FF9AE554FE8AD33168FBFC326D2021DD\'\n OR unix_socket\n\nIf the user\'s password is updated, but unix_socket authentication is not\nspecified in the IDENTIFIED VIA clause, unix_socket authentication will no\nlonger be permitted.\n\nALTER USER \'bob\'@\'localhost\' IDENTIFIED VIA mysql_native_password \n USING PASSWORD(\'pwd2\');\n\nSHOW CREATE USER \'bob\'@\'localhost\'\\G\n*************************** 1. row ***************************\nCREATE USER for bob@localhost: CREATE USER `bob`@`localhost` \n IDENTIFIED BY PASSWORD \'*38366FDA01695B6A5A9DD4E428D9FB8F7EB75512\'\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored to the mysql.user table.\n\nFor example, if our password is mariadb, then we can set the account\'s\npassword with:\n\nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD#function. It will be stored to the\nmysql.user table as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n\nAnd then we can set an account\'s password with the hash:\n\nALTER USER foo2@test \n IDENTIFIED BY PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nALTER USER foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nIn MariaDB 10.4 and later, the USING or AS keyword can also be used to provide\na plain-text password to a plugin if it\'s provided as an argument to the\nPASSWORD() function. This is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example, the ed25519\nauthentication plugin supports this:\n\nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can alter a user account to require these TLS options with\nthe following:\n\nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\' AND\n ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+------------------------------------+---------------------------------------+\n| Limit Type                         | Description                           |\n+------------------------------------+---------------------------------------+\n| MAX_QUERIES_PER_HOUR               | Number of statements that the         |\n|                                    | account can issue per hour            |\n|                                    | (including updates)                   |\n+------------------------------------+---------------------------------------+\n| MAX_UPDATES_PER_HOUR               | Number of updates (not queries) that  |\n|                                    | the account can issue per hour        |\n+------------------------------------+---------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR           | Number of connections that the        |\n|                                    | account can start per hour            |\n+------------------------------------+---------------------------------------+\n| MAX_USER_CONNECTIONS               | Number of simultaneous connections    |\n|                                    | that can be accepted from the same    |\n|                                    | account; if it is 0, max_connections  |\n|                                    | will be used instead; if              |\n|                                    | max_connections is 0, there is no     |\n|                                    | limit for this account\'s              |\n|                                    | simultaneous connections.             |','','https://mariadb.com/kb/en/alter-user/');
update help_topic set description = CONCAT(description, '\n+------------------------------------+---------------------------------------+\n| MAX_STATEMENT_TIME                 | Timeout, in seconds, for statements   |\n|                                    | executed by the user. See also        |\n|                                    | Aborting Statements that Exceed a     |\n|                                    | Certain Time to Execute.              |\n+------------------------------------+---------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nHere is an example showing how to set an account\'s resource limits:\n\nALTER USER \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 10\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mysqladmin reload.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nPassword Expiry\n---------------\n\nMariaDB starting with 10.4.3\n----------------------------\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal setting, for example:\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSee User Password Expiry for more details.\n\nAccount Locking\n---------------\n\nMariaDB starting with 10.4.2\n----------------------------\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected). For example:\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nSee Account Locking for more details.\n\nFrom MariaDB 10.4.7 and MariaDB 10.5.8, the lock_option and password_option\nclauses can occur in either order.\n\nURL: https://mariadb.com/kb/en/alter-user/') WHERE help_topic_id = 106;
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (107,10,'DROP USER','Syntax\n------\n\nDROP USER [IF EXISTS] user_name [, user_name] ...\n\nDescription\n-----------\n\nThe DROP USER statement removes one or more MariaDB accounts. It removes\nprivilege rows for the account from all grant tables. To use this statement,\nyou must have the global CREATE USER privilege or the DELETE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used. For\nadditional information about specifying account names, see CREATE USER.\n\nNote that, if you specify an account that is currently connected, it will not\nbe deleted until the connection is closed. The connection will not be\nautomatically closed.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP USER will still drop the accounts that do\nnot result in an error. Only one error is produced for all users which have\nnot been dropped:\n\nERROR 1396 (HY000): Operation DROP USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a note instead of an\nerror if the user does not exist.\n\nExamples\n--------\n\nDROP USER bob;\n\nDROP USER foo2@localhost,foo2@\'127.%\';\n\nIF EXISTS:\n\nDROP USER bob;\nERROR 1396 (HY000): Operation DROP USER failed for \'bob\'@\'%\'\n\nDROP USER IF EXISTS bob;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------+\n| Level | Code | Message                                     |\n+-------+------+---------------------------------------------+\n| Note  | 1974 | Can\'t drop user \'bob\'@\'%\'; it doesn\'t exist |\n+-------+------+---------------------------------------------+\n\nURL: https://mariadb.com/kb/en/drop-user/','','https://mariadb.com/kb/en/drop-user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (108,10,'GRANT','Syntax\n------\n\nGRANT\n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  TO user_specification [ user_options ...]\n\nuser_specification:\n username [authentication_option]\n | PUBLIC\nauthentication_option:\n IDENTIFIED BY \'password\'\n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR authentication_rule  ...]\n\nauthentication_rule:\n  authentication_plugin\n | authentication_plugin {USING|AS} \'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n\nGRANT PROXY ON username\n  TO user_specification [, user_specification ...]\n  [WITH GRANT OPTION]\n\nGRANT rolename TO grantee [, grantee ...]\n  [WITH ADMIN OPTION]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nuser_options:\n  [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n  [WITH with_option [with_option] ...]\n\nobject_type:\n  TABLE\n | FUNCTION\n | PROCEDURE\n | PACKAGE\n\npriv_level:\n  *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n\nwith_option:\n  GRANT OPTION\n | resource_option\n\nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n\ntls_option:\n SSL\n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n\nDescription\n-----------\n\nThe GRANT statement allows you to grant privileges or roles to accounts. To\nuse GRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nUse the REVOKE statement to revoke privileges granted with the GRANT statement.\n\nUse the SHOW GRANTS statement to determine what privileges an account has.\n\nAccount Names\n-------------\n\nFor GRANT statements, account names are specified as the username argument in\nthe same way as they are for CREATE USER statements. See account names from\nthe CREATE USER page for details on how account names are specified.\n\nImplicit Account Creation\n-------------------------\n\nThe GRANT statement also allows you to implicitly create accounts in some\ncases.\n\nIf the account does not yet exist, then GRANT can implicitly create it. To\nimplicitly create an account with GRANT, a user is required to have the same\nprivileges that would be required to explicitly create the account with the\nCREATE USER statement.\n\nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts can only be created\nif authentication information is specified, or with a CREATE USER statement.\nIf no authentication information is provided, GRANT will produce an error when\nthe specified account does not exist, for example:\n\nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value                                      |\n+---------------+--------------------------------------------+\n| sql_mode      | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user table\n\nGRANT USAGE ON *.* TO \'user123\'@\'%\' \n IDENTIFIED VIA PAM using \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n\nselect host, user from mysql.user where user=\'user123\' ;\n\n+------+----------+\n| host | user     |\n+------+----------+\n| %    | user123 |\n+------+----------+\n\nPrivilege Levels\n----------------\n\nPrivileges can be set globally, for an entire database, for a table or\nroutine, or for individual columns in a table. Certain privileges can only be\nset at certain levels.\n\nGlobal privileges do not take effect immediately and are only applied to\nconnections created after the GRANT statement was executed.\n\n* Global privileges priv_type are granted using *.* for\npriv_level. Global privileges include privileges to administer the database\nand manage user accounts, as well as privileges for all tables, functions, and\nprocedures. Global privileges are stored in the mysql.user table prior to\nMariaDB 10.4, and in  mysql.global_priv table afterwards.\n* Database privileges priv_type are granted using db_name.*\nfor priv_level, or using just * to use default database. Database\nprivileges include privileges to create tables and functions, as well as\nprivileges for all tables, functions, and procedures in the database. Database\nprivileges are stored in the mysql.db table.\n* Table privileges priv_type are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in the default\ndatabase. The TABLE keyword is optional. Table privileges include the\nability to select and change data in the table. Certain table privileges can\nbe granted for individual columns.\n* Column privileges priv_type are granted by specifying a table for\npriv_level and providing a column list after the privilege type. They allow\nyou to control exactly which columns in a table users can select and change.\n* Function privileges priv_type are granted using FUNCTION db_name.routine_name\nfor priv_level, or using just  FUNCTION routine_name to specify a function\nin the default database.\n* Procedure privileges priv_type are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to specify a procedure\nin the default database.\n\nThe USAGE Privilege\n-------------------\n\nThe USAGE privilege grants no real privileges. The SHOW GRANTS statement will\nshow a global USAGE privilege for a newly-created user. You can use USAGE with\nthe GRANT statement to change options like GRANT OPTION and\nMAX_USER_CONNECTIONS without changing any account privileges.\n\nThe ALL PRIVILEGES Privilege\n----------------------------\n\nThe ALL PRIVILEGES privilege grants all available privileges. Granting all\nprivileges only affects the given privilege level. For example, granting all\nprivileges on a table does not grant any privileges on the database or\nglobally.\n\nUsing ALL PRIVILEGES does not grant the special GRANT OPTION privilege.\n\nYou can use ALL instead of ALL PRIVILEGES.\n\nThe GRANT OPTION Privilege\n--------------------------\n\nUse the WITH GRANT OPTION clause to give users the ability to grant privileges\nto other users at the given privilege level. Users with the GRANT OPTION\nprivilege can only grant privileges they have. They cannot grant privileges at\na higher privilege level than they have the GRANT OPTION privilege.\n\nThe GRANT OPTION privilege cannot be set for individual columns. If you use\nWITH GRANT OPTION when specifying column privileges, the GRANT OPTION\nprivilege will be granted for the entire table.\n\nUsing the WITH GRANT OPTION clause is equivalent to listing GRANT OPTION as a\nprivilege.\n\nGlobal Privileges\n-----------------\n\nThe following table lists the privileges that can be granted globally. You can\nalso grant all database, table, and function privileges globally. When granted\nglobally, these privileges apply to all databases, tables, or functions,\nincluding those created later.\n\nTo set a global privilege, use *.* for priv_level.\n\nBINLOG ADMIN\n------------\n\nEnables administration of the binary log, including the PURGE BINARY LOGS\nstatement and setting the system variables:\n\n* binlog_annotate_row_events\n* binlog_cache_size\n* binlog_commit_wait_count\n* binlog_commit_wait_usec\n* binlog_direct_non_transactional_updates\n* binlog_expire_logs_seconds\n* binlog_file_cache_size\n* binlog_format\n* binlog_row_image\n* binlog_row_metadata\n* binlog_stmt_cache_size\n* expire_logs_days\n* log_bin_compress\n* log_bin_compress_min_len\n* log_bin_trust_function_creators\n* max_binlog_cache_size\n* max_binlog_size\n* max_binlog_stmt_cache_size\n* sql_log_bin and\n* sync_binlog.\n\nAdded in MariaDB 10.5.2.\n\nBINLOG MONITOR\n--------------\n\nNew name for REPLICATION CLIENT from MariaDB 10.5.2, (REPLICATION CLIENT still\nsupported as an alias for compatibility purposes). Permits running SHOW\ncommands related to the binary log, in particular the SHOW BINLOG STATUS and\nSHOW BINARY LOGS statements. Unlike REPLICATION CLIENT prior to MariaDB 10.5,\nSHOW REPLICA STATUS isn\'t included in this privilege, and REPLICA MONITOR is\nrequired.\n\nBINLOG REPLAY\n-------------\n\nEnables replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), executing SET timestamp when secure_timestamp is set to\nreplication, and setting the session values of system variables usually\nincluded in BINLOG output, in particular:\n\n* gtid_domain_id\n* gtid_seq_no\n* pseudo_thread_id\n* server_id.\n\nAdded in MariaDB 10.5.2\n\nCONNECTION ADMIN\n----------------\n\nEnables administering connection resource limit options. This includes\nignoring the limits specified by:\n\n* max_connections\n* max_user_connections and\n* max_password_errors.\n\nThe statements specified in init_connect are not executed, killing connections\nand queries owned by other users is permitted. The following\nconnection-related system variables can be changed:\n\n* connect_timeout\n* disconnect_on_expired_password\n* extra_max_connections\n* init_connect\n* max_connections\n* max_connect_errors\n* max_password_errors\n* proxy_protocol_networks\n* secure_auth\n* slow_launch_time\n* thread_pool_exact_stats\n* thread_pool_dedicated_listener\n* thread_pool_idle_timeout\n* thread_pool_max_threads\n* thread_pool_min_threads\n* thread_pool_oversubscribe\n* thread_pool_prio_kickup_timer\n* thread_pool_priority\n* thread_pool_size, and\n* thread_pool_stall_limit.\n\nAdded in MariaDB 10.5.2.\n\nCREATE USER\n-----------\n\nCreate a user using the CREATE USER statement, or implicitly create a user\nwith the GRANT statement.\n\nFEDERATED ADMIN\n---------------\n\nExecute CREATE SERVER, ALTER SERVER, and DROP SERVER statements. Added in\nMariaDB 10.5.2.\n\nFILE\n----\n\nRead and write files on the server, using statements like LOAD DATA INFILE or\nfunctions like LOAD_FILE(). Also needed to create CONNECT outward tables.\nMariaDB server must have the permissions to access those files.\n\nGRANT OPTION\n------------\n\nGrant global privileges. You can only grant privileges that you have.\n\nPROCESS\n-------\n\nShow information about the active processes, for example via SHOW PROCESSLIST\nor mariadb-admin processlist. If you have the PROCESS privilege, you can see\nall threads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using).\n\nREAD_ONLY ADMIN\n---------------\n\nUser can set the read_only system variable and allows the user to perform\nwrite operations, even when the read_only option is active. Added in MariaDB\n10.5.2.\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary.\n\nRELOAD\n------\n\nExecute FLUSH statements or equivalent mariadb-admin commands.\n\nREPLICATION CLIENT\n------------------\n\nExecute SHOW MASTER STATUS and SHOW BINARY LOGS informative statements.\nRenamed to BINLOG MONITOR in MariaDB 10.5.2 (but still supported as an alias\nfor compatibility reasons). SHOW SLAVE STATUS was part of REPLICATION CLIENT\nprior to MariaDB 10.5.\n\nREPLICATION MASTER ADMIN\n------------------------\n\nPermits administration of primary servers, including the SHOW REPLICA HOSTS\nstatement, and setting the gtid_binlog_state, gtid_domain_id,\nmaster_verify_checksum and server_id system variables. Added in MariaDB 10.5.2.\n\nREPLICA MONITOR\n---------------\n\nPermit SHOW REPLICA STATUS and SHOW RELAYLOG EVENTS. From MariaDB 10.5.9.\n\nWhen a user would upgrade from an older major release to a MariaDB 10.5 minor\nrelease prior to MariaDB 10.5.9, certain user accounts would lose\ncapabilities. For example, a user account that had the REPLICATION CLIENT\nprivilege in older major releases could run SHOW REPLICA STATUS, but after\nupgrading to a MariaDB 10.5 minor release prior to MariaDB 10.5.9, they could\nno longer run SHOW REPLICA STATUS, because that statement was changed to\nrequire the REPLICATION REPLICA ADMIN privilege.\n\nThis issue is fixed in MariaDB 10.5.9 with this new privilege, which now\ngrants the user the ability to execute SHOW [ALL] (SLAVE | REPLICA) STATUS.\n\nWhen a database is upgraded from an older major release to MariaDB Server\n10.5.9 or later, any user accounts with the REPLICATION CLIENT or REPLICATION\nSLAVE privileges will automatically be granted the new REPLICA MONITOR\nprivilege. The privilege fix occurs when the server is started up, not when\nmariadb-upgrade is performed.\n\nHowever, when a database is upgraded from an early 10.5 minor release to\n10.5.9 and later, the user will have to fix any user account privileges\nmanually.\n\nREPLICATION REPLICA\n-------------------\n\nSynonym for REPLICATION SLAVE. From MariaDB 10.5.1.\n\nREPLICATION SLAVE\n-----------------\n\nAccounts used by replica servers on the primary need this privilege. This is\nneeded to get the updates made on the master. From MariaDB 10.5.1, REPLICATION\nREPLICA is an alias for REPLICATION SLAVE.\n\nREPLICATION SLAVE ADMIN\n-----------------------\n\nPermits administering replica servers, including START REPLICA/SLAVE, STOP\nREPLICA/SLAVE, CHANGE MASTER, SHOW REPLICA/SLAVE STATUS, SHOW RELAYLOG EVENTS\nstatements, replaying the binary log with the BINLOG statement (generated by\nmariadb-binlog), and setting the system variables:\n\n* gtid_cleanup_batch_size\n* gtid_ignore_duplicates\n* gtid_pos_auto_engines\n* gtid_slave_pos\n* gtid_strict_mode\n* init_slave\n* read_binlog_speed_limit\n* relay_log_purge\n* relay_log_recovery\n* replicate_do_db\n* replicate_do_table\n* replicate_events_marked_for_skip\n* replicate_ignore_db\n* replicate_ignore_table\n* replicate_wild_do_table\n* replicate_wild_ignore_table\n* slave_compressed_protocol\n* slave_ddl_exec_mode\n* slave_domain_parallel_threads\n* slave_exec_mode\n* slave_max_allowed_packet\n* slave_net_timeout\n* slave_parallel_max_queued\n* slave_parallel_mode\n* slave_parallel_threads\n* slave_parallel_workers\n* slave_run_triggers_for_rbr\n* slave_sql_verify_checksum\n* slave_transaction_retry_interval\n* slave_type_conversions\n* sync_master_info\n* sync_relay_log, and','','https://mariadb.com/kb/en/grant/');
update help_topic set description = CONCAT(description, '\n* sync_relay_log_info.\n\nAdded in MariaDB 10.5.2.\n\nSET USER\n--------\n\nEnables setting the DEFINER when creating triggers, views, stored functions\nand stored procedures. Added in MariaDB 10.5.2.\n\nSHOW DATABASES\n--------------\n\nList all databases using the SHOW DATABASES statement. Without the SHOW\nDATABASES privilege, you can still issue the SHOW DATABASES statement, but it\nwill only list databases containing tables on which you have privileges.\n\nSHUTDOWN\n--------\n\nShut down the server using SHUTDOWN or the mariadb-admin shutdown command.\n\nSUPER\n-----\n\nExecute superuser statements: CHANGE MASTER TO, KILL (users who do not have\nthis privilege can only KILL their own threads), PURGE LOGS, SET global system\nvariables, or the mariadb-admin debug command. Also, this permission allows\nthe user to write data even if the read_only startup option is set, enable or\ndisable logging, enable or disable replication on replica, specify a DEFINER\nfor statements that support that clause, connect once reaching the\nMAX_CONNECTIONS. If a statement has been specified for the init-connect mysqld\noption, that command will not be executed when a user with SUPER privileges\nconnects to the server.\n\nThe SUPER privilege has been split into multiple smaller privileges from\nMariaDB 10.5.2 to allow for more fine-grained privileges (MDEV-21743). The\nprivileges are:\n\n* SET USER\n* FEDERATED ADMIN\n* CONNECTION ADMIN\n* REPLICATION SLAVE ADMIN\n* BINLOG ADMIN\n* BINLOG REPLAY\n* REPLICA MONITOR\n* BINLOG MONITOR\n* REPLICATION MASTER ADMIN\n* READ_ONLY ADMIN\n\nHowever, the smaller privileges are still a part of the SUPER grant in MariaDB\n10.5.2. From MariaDB 11.0.1 onwards, these grants are no longer a part of\nSUPER and need to be granted separately (MDEV-29668).\n\nFrom MariaDB 10.11.0, the READ_ONLY ADMIN privilege has been removed from\nSUPER. The benefit of this is that one can remove the READ_ONLY ADMIN\nprivilege from all users and ensure that no one can make any changes on any\nnon-temporary tables. This is useful on replicas when one wants to ensure that\nthe replica is kept identical to the primary (MDEV-29596).\n\nDatabase Privileges\n-------------------\n\nThe following table lists the privileges that can be granted at the database\nlevel. You can also grant all table and function privileges at the database\nlevel. Table and function privileges on a database apply to all tables or\nfunctions in that database, including those created later.\n\nTo set a privilege for a database, specify the database using db_name.* for\npriv_level, or just use * to specify the default database.\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a database using the CREATE      |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. You can      |\n|                                  | grant the CREATE privilege on           |\n|                                  | databases that do not yet exist. This   |\n|                                  | also grants the CREATE privilege on     |\n|                                  | all tables in the database.             |\n+----------------------------------+-----------------------------------------+\n| CREATE ROUTINE                   | Create Stored Programs using the        |\n|                                  | CREATE PROCEDURE and CREATE FUNCTION    |\n|                                  | statements.                             |\n+----------------------------------+-----------------------------------------+\n| CREATE TEMPORARY TABLES          | Create temporary tables with the        |\n|                                  | CREATE TEMPORARY TABLE statement. This  |\n|                                  | privilege enable writing and dropping   |\n|                                  | those temporary tables                  |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a database using the DROP          |\n|                                  | DATABASE statement, when the privilege  |\n|                                  | is granted for a database. This also    |\n|                                  | grants the DROP privilege on all        |\n|                                  | tables in the database.                 |\n+----------------------------------+-----------------------------------------+\n| EVENT                            | Create, drop and alter EVENTs.          |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant database privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n| LOCK TABLES                      | Acquire explicit locks using the LOCK   |\n|                                  | TABLES statement; you also need to      |\n|                                  | have the SELECT privilege on a table,   |\n|                                  | in order to lock it.                    |\n+----------------------------------+-----------------------------------------+\n\nTable Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER                            | Change the structure of an existing     |\n|                                  | table using the ALTER TABLE statement.  |\n+----------------------------------+-----------------------------------------+\n| CREATE                           | Create a table using the CREATE TABLE   |\n|                                  | statement.  You can grant the CREATE    |\n|                                  | privilege on tables that do not yet     |\n|                                  | exist.                                  |\n+----------------------------------+-----------------------------------------+\n| CREATE VIEW                      | Create a view using the CREATE_VIEW     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| DELETE                           | Remove rows from a table using the      |\n|                                  | DELETE statement.                       |\n+----------------------------------+-----------------------------------------+\n| DELETE HISTORY                   | Remove historical rows from a table     |\n|                                  | using the DELETE HISTORY statement.     |\n|                                  | Displays as DELETE VERSIONING ROWS      |\n|                                  | when running SHOW GRANTS until MariaDB  |\n|                                  | 10.3.15 and until MariaDB 10.4.5        |\n|                                  | (MDEV-17655), or when running SHOW      |\n|                                  | PRIVILEGES until MariaDB 10.5.2,        |\n|                                  | MariaDB 10.4.13 and MariaDB 10.3.23     |\n|                                  | (MDEV-20382). From MariaDB 10.3.4.      |\n|                                  | From MariaDB 10.3.5, if a user has the  |\n|                                  | SUPER privilege but not this            |\n|                                  | privilege, running mariadb-upgrade      |\n|                                  | will grant this privilege as well.      |\n+----------------------------------+-----------------------------------------+\n| DROP                             | Drop a table using the DROP TABLE       |\n|                                  | statement or a view using the DROP      |\n|                                  | VIEW statement. Also required to        |\n|                                  | execute the TRUNCATE TABLE statement.   |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant table privileges. You can only    |\n|                                  | grant privileges that you have.         |\n+----------------------------------+-----------------------------------------+\n| INDEX                            | Create an index on a table using the    |\n|                                  | CREATE INDEX statement. Without the     |\n|                                  | INDEX privilege, you can still create   |\n|                                  | indexes when creating a table using     |\n|                                  | the CREATE TABLE statement if the you   |\n|                                  | have the CREATE privilege, and you can  |\n|                                  | create indexes using the ALTER TABLE    |\n|                                  | statement if you have the ALTER         |\n|                                  | privilege.                              |\n+----------------------------------+-----------------------------------------+\n| INSERT                           | Add rows to a table using the INSERT    |\n|                                  | statement.  The INSERT privilege can    |\n|                                  | also be set on individual columns; see  |\n|                                  | Column Privileges below for details.    |\n+----------------------------------+-----------------------------------------+\n| REFERENCES                       | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT                           | Read data from a table using the        |\n|                                  | SELECT statement. The SELECT privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n| SHOW VIEW                        | Show the CREATE VIEW statement to       |\n|                                  | create a view using the SHOW CREATE     |\n|                                  | VIEW statement.                         |\n+----------------------------------+-----------------------------------------+\n| TRIGGER                          | Execute triggers associated to tables   |\n|                                  | you update, execute the CREATE          |\n|                                  | TRIGGER, DROP TRIGGER, and SHOW CREATE  |\n|                                  | TRIGGER statements.                     |\n+----------------------------------+-----------------------------------------+\n| UPDATE                           | Update existing rows in a table using   |\n|                                  | the UPDATE statement. UPDATE            |\n|                                  | statements usually include a WHERE      |\n|                                  | clause to update only certain rows.     |\n|                                  | You must have SELECT privileges on the  |\n|                                  | table or the appropriate columns for    |\n|                                  | the WHERE clause. The UPDATE privilege  |\n|                                  | can also be set on individual columns;  |\n|                                  | see Column Privileges below for         |\n|                                  | details.                                |\n+----------------------------------+-----------------------------------------+\n\nColumn Privileges\n-----------------\n\nSome table privileges can be set for individual columns of a table. To use\ncolumn privileges, specify the table explicitly and provide a list of column\nnames after the privilege type. For example, the following statement would\nallow the user to read the names and positions of employees, but not other\ninformation from the same table, such as salaries.\n\nGRANT SELECT (name, position) on Employee to \'jeffrey\'@\'localhost\';\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| INSERT (column_list)             | Add rows specifying values in columns   |\n|                                  | using the INSERT statement. If you      |\n|                                  | only have column-level INSERT           |\n|                                  | privileges, you must specify the        |\n|                                  | columns you are setting in the INSERT   |\n|                                  | statement. All other columns will be    |\n|                                  | set to their default values, or NULL.   |\n+----------------------------------+-----------------------------------------+\n| REFERENCES (column_list)         | Unused.                                 |\n+----------------------------------+-----------------------------------------+\n| SELECT (column_list)             | Read values in columns using the        |\n|                                  | SELECT statement. You cannot access or  |\n|                                  | query any columns for which you do not  |\n|                                  | have SELECT privileges, including in    |\n|                                  | WHERE, ON, GROUP BY, and ORDER BY       |\n|                                  | clauses.                                |\n+----------------------------------+-----------------------------------------+\n| UPDATE (column_list)             | Update values in columns of existing    |\n|                                  | rows using the UPDATE statement.        |\n|                                  | UPDATE statements usually include a     |\n|                                  | WHERE clause to update only certain     |') WHERE help_topic_id = 108;
update help_topic set description = CONCAT(description, '\n|                                  | rows. You must have SELECT privileges   |\n|                                  | on the table or the appropriate         |\n|                                  | columns for the WHERE clause.           |\n+----------------------------------+-----------------------------------------+\n\nFunction Privileges\n-------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | function using the ALTER FUNCTION       |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Use a stored function. You need SELECT  |\n|                                  | privileges for any tables or columns    |\n|                                  | accessed by the function.               |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant function privileges. You can      |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nProcedure Privileges\n--------------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| ALTER ROUTINE                    | Change the characteristics of a stored  |\n|                                  | procedure using the ALTER PROCEDURE     |\n|                                  | statement.                              |\n+----------------------------------+-----------------------------------------+\n| EXECUTE                          | Execute a stored procedure using the    |\n|                                  | CALL statement. The privilege to call   |\n|                                  | a procedure may allow you to perform    |\n|                                  | actions you wouldn\'t otherwise be able  |\n|                                  | to do, such as insert rows into a       |\n|                                  | table.                                  |\n+----------------------------------+-----------------------------------------+\n| GRANT OPTION                     | Grant procedure privileges. You can     |\n|                                  | only grant privileges that you have.    |\n+----------------------------------+-----------------------------------------+\n\nGRANT EXECUTE ON PROCEDURE mysql.create_db TO maintainer;\n\nProxy Privileges\n----------------\n\n+----------------------------------+-----------------------------------------+\n| Privilege                        | Description                             |\n+----------------------------------+-----------------------------------------+\n| PROXY                            | Permits one user to be a proxy for      |\n|                                  | another.                                |\n+----------------------------------+-----------------------------------------+\n\nThe PROXY privilege allows one user to proxy as another user, which means\ntheir privileges change to that of the proxy user, and the CURRENT_USER()\nfunction returns the user name of the proxy user.\n\nThe PROXY privilege only works with authentication plugins that support it.\nThe default mysql_native_password authentication plugin does not support proxy\nusers.\n\nThe pam authentication plugin is the only plugin included with MariaDB that\ncurrently supports proxy users. The PROXY privilege is commonly used with the\npam authentication plugin to enable user and group mapping with PAM.\n\nFor example, to grant the PROXY privilege to an anonymous account that\nauthenticates with the pam authentication plugin, you could execute the\nfollowing:\n\nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n\nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n\nA user account can only grant the PROXY privilege for a specific user account\nif the granter also has the PROXY privilege for that specific user account,\nand if that privilege is defined WITH GRANT OPTION. For example, the following\nexample fails because the granter does not have the PROXY privilege for that\nspecific user account at all:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nAnd the following example fails because the granter does have the PROXY\nprivilege for that specific user account, but it is not defined WITH GRANT\nOPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------+\n| Grants for alice@localhost                                                  \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\'                     \n                    |\n+------------------------------------------------------------------------------\n----------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nERROR 1698 (28000): Access denied for user \'alice\'@\'localhost\'\n\nBut the following example succeeds because the granter does have the PROXY\nprivilege for that specific user account, and it is defined WITH GRANT OPTION:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO \'alice\'@\'localhost\' WITH GRANT OPTION   \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'dba\'@\'localhost\' TO \'bob\'@\'localhost\';\n\nA user account can grant the PROXY privilege for any other user account if the\ngranter has the PROXY privilege for the \'\'@\'%\' anonymous user account, like\nthis:\n\nGRANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH GRANT OPTION;\n\nFor example, the following example succeeds because the user can grant the\nPROXY privilege for any other user account:\n\nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER()          | CURRENT_USER()  |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n\nSHOW GRANTS;\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| Grants for alice@localhost                                                  \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\' IDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT OPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH GRANT OPTION              \n                             |\n+------------------------------------------------------------------------------\n----------------------------------------------------------+\n\nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO \'bob\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO \'carol\'@\'localhost\';\nQuery OK, 0 rows affected (0.004 sec)\n\nThe default root user accounts created by mariadb-install-db have this\nprivilege. For example:\n\nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION;\nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH GRANT OPTION;\n\nThis allows the default root user accounts to grant the PROXY privilege for\nany other user account, and it also allows the default root user accounts to\ngrant others the privilege to do the same.\n\nAuthentication Options\n----------------------\n\nThe authentication options for the GRANT statement are the same as those for\nthe CREATE USER statement.\n\nIDENTIFIED BY \'password\'\n------------------------\n\nThe optional IDENTIFIED BY clause can be used to provide an account with a\npassword. The password should be specified in plain text. It will be hashed by\nthe PASSWORD function prior to being stored.\n\nFor example, if our password is mariadb, then we can create the user with:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED BY PASSWORD \'password_hash\'\n--------------------------------------\n\nThe optional IDENTIFIED BY PASSWORD clause can be used to provide an account\nwith a password that has already been hashed. The password should be specified\nas a hash that was provided by the PASSWORD function. It will be stored as-is.\n\nFor example, if our password is mariadb, then we can find the hash with:\n\nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\')                       |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n\nAnd then we can create a user with the hash:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \n PASSWORD \'*54958E764CE10E50764C2EECBB71D01F08549980\';\n\nIf you do not specify a password with the IDENTIFIED BY clause, the user will\nbe able to connect without a password. A blank password is not a wildcard to\nmatch any password. The user must connect without providing a password if no\npassword is set.\n\nIf the user account already exists and if you provide the IDENTIFIED BY\nclause, then the user\'s password will be changed. You must have the privileges\nneeded for the SET PASSWORD statement to change a user\'s password with GRANT.\n\nThe only authentication plugins that this clause supports are\nmysql_native_password and mysql_old_password.\n\nIDENTIFIED {VIA|WITH} authentication_plugin\n-------------------------------------------\n\nThe optional IDENTIFIED VIA authentication_plugin allows you to specify that\nthe account should be authenticated by a specific authentication plugin. The\nplugin name must be an active authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to install it with INSTALL\nPLUGIN or INSTALL SONAME.\n\nFor example, this could be used with the PAM authentication plugin:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n\nSome authentication plugins allow additional arguments to be specified after a\nUSING or AS keyword. For example, the PAM authentication plugin accepts a\nservice name:\n\nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n\nThe exact meaning of the additional argument would depend on the specific\nauthentication plugin.\n\nMariaDB starting with 10.4.0\n----------------------------\nThe USING or AS keyword can also be used to provide a plain-text password to a\nplugin if it\'s provided as an argument to the PASSWORD() function. This is\nonly valid for authentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication plugin supports\nthis:\n\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\');\n\nMariaDB starting with 10.4.3\n----------------------------\nOne can specify many authentication plugins, they all work as alternatives\nways of authenticating a user:\n') WHERE help_topic_id = 108;
update help_topic set description = CONCAT(description, '\nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 \n USING PASSWORD(\'secret\') OR unix_socket;\n\nBy default, when you create a user without specifying an authentication\nplugin, MariaDB uses the mysql_native_password plugin.\n\nResource Limit Options\n----------------------\n\nIt is possible to set per-account limits for certain server resources. The\nfollowing table shows the values that can be set per account:\n\n+--------------------------------------+--------------------------------------+\n| Limit Type                           | Decription                           |\n+--------------------------------------+--------------------------------------+\n| MAX_QUERIES_PER_HOUR                 | Number of statements that the        |\n|                                      | account can issue per hour           |\n|                                      | (including updates)                  |\n+--------------------------------------+--------------------------------------+\n| MAX_UPDATES_PER_HOUR                 | Number of updates (not queries)      |\n|                                      | that the account can issue per hour  |\n+--------------------------------------+--------------------------------------+\n| MAX_CONNECTIONS_PER_HOUR             | Number of connections that the       |\n|                                      | account can start per hour           |\n+--------------------------------------+--------------------------------------+\n| MAX_USER_CONNECTIONS                 | Number of simultaneous connections   |\n|                                      | that can be accepted from the same   |\n|                                      | account; if it is 0,                 |\n|                                      | max_connections will be used         |\n|                                      | instead; if max_connections is 0,    |\n|                                      | there is no limit for this           |\n|                                      | account\'s simultaneous connections.  |\n+--------------------------------------+--------------------------------------+\n| MAX_STATEMENT_TIME                   | Timeout, in seconds, for statements  |\n|                                      | executed by the user. See also       |\n|                                      | Aborting Statements that Exceed a    |\n|                                      | Certain Time to Execute.             |\n+--------------------------------------+--------------------------------------+\n\nIf any of these limits are set to 0, then there is no limit for that resource\nfor that user.\n\nTo set resource limits for an account, if you do not want to change that\naccount\'s privileges, you can issue a GRANT statement with the USAGE\nprivilege, which has no meaning. The statement can name some or all limit\ntypes, in any order.\n\nHere is an example showing how to set resource limits:\n\nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n  MAX_USER_CONNECTIONS 0\n  MAX_QUERIES_PER_HOUR 200;\n\nThe resources are tracked per account, which means \'user\'@\'server\'; not per\nuser name or per connection.\n\nThe count can be reset for all users using FLUSH USER_RESOURCES, FLUSH\nPRIVILEGES or mariadb-admin reload.\n\nUsers with the CONNECTION ADMIN privilege (in MariaDB 10.5.2 and later) or the\nSUPER privilege are not restricted by max_user_connections, max_connections,\nor max_password_errors.\n\nPer account resource limits are stored in the user table, in the mysql\ndatabase. Columns used for resources limits are named max_questions,\nmax_updates, max_connections (for MAX_CONNECTIONS_PER_HOUR), and\nmax_user_connections (for MAX_USER_CONNECTIONS).\n\nTLS Options\n-----------\n\nBy default, MariaDB transmits data between the server and clients without\nencrypting it. This is generally acceptable when the server and client run on\nthe same host or in networks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on separate networks or\nthey are in a high-risk network, the lack of encryption does introduce\nsecurity concerns as a malicious actor could potentially eavesdrop on the\ntraffic as it is sent over the network between them.\n\nTo mitigate this concern, MariaDB allows you to encrypt data in transit\nbetween the server and clients using the Transport Layer Security (TLS)\nprotocol. TLS was formerly known as Secure Socket Layer (SSL), but strictly\nspeaking the SSL protocol is a predecessor to TLS and, that version of the\nprotocol is now considered insecure. The documentation still uses the term SSL\noften and for compatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB only supports its\nsecure successors.\n\nSee Secure Connections Overview for more information about how to determine\nwhether your MariaDB server has TLS support.\n\nYou can set certain TLS-related restrictions for specific user accounts. For\ninstance, you might use this with user accounts that require access to\nsensitive data while sending it across networks that you do not control. These\nrestrictions can be enabled for a user account with the CREATE USER, ALTER\nUSER, or GRANT statements. The following options are available:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| REQUIRE NONE              | TLS is not required for this account, but can  |\n|                           | still be used.                                 |\n+---------------------------+------------------------------------------------+\n| REQUIRE SSL               | The account must use TLS, but no valid X509    |\n|                           | certificate is required. This option cannot    |\n|                           | be combined with other TLS options.            |\n+---------------------------+------------------------------------------------+\n| REQUIRE X509              | The account must use TLS and must have a       |\n|                           | valid X509 certificate. This option implies    |\n|                           | REQUIRE SSL. This option cannot be combined    |\n|                           | with other TLS options.                        |\n+---------------------------+------------------------------------------------+\n| REQUIRE ISSUER \'issuer\'   | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the Certificate  |\n|                           | Authority must be the one specified via the    |\n|                           | string issuer. This option implies REQUIRE     |\n|                           | X509. This option can be combined with the     |\n|                           | SUBJECT, and CIPHER options in any order.      |\n+---------------------------+------------------------------------------------+\n| REQUIRE SUBJECT \'subject\' | The account must use TLS and must have a       |\n|                           | valid X509 certificate. Also, the              |\n|                           | certificate\'s Subject must be the one          |\n|                           | specified via the string subject. This option  |\n|                           | implies REQUIRE X509. This option can be       |\n|                           | combined with the ISSUER, and CIPHER options   |\n|                           | in any order.                                  |\n+---------------------------+------------------------------------------------+\n| REQUIRE CIPHER \'cipher\'   | The account must use TLS, but no valid X509    |\n|                           | certificate is required. Also, the encryption  |\n|                           | used for the connection must use a specific    |\n|                           | cipher method specified in the string cipher.  |\n|                           | This option implies REQUIRE SSL. This option   |\n|                           | can be combined with the ISSUER, and SUBJECT   |\n|                           | options in any order.                          |\n+---------------------------+------------------------------------------------+\n\nThe REQUIRE keyword must be used only once for all specified options, and the\nAND keyword can be used to separate individual options, but it is not required.\n\nFor example, you can create a user account that requires these TLS options\nwith the following:\n\nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom, Inc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some Company/CN=Peter\nParker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'SHA-DES-CBC3-EDH-RSA\';\n\nIf any of these options are set for a specific user account, then any client\nwho tries to connect with that user account will have to be configured to\nconnect with TLS.\n\nSee Securing Connections for Client and Server for information on how to\nenable TLS on the client and server.\n\nRoles\n-----\n\nSyntax\n------\n\nGRANT role TO grantee [, grantee ... ]\n[ WITH ADMIN OPTION ]\n\ngrantee:\n  rolename\n  username [authentication_option]\n\nThe GRANT statement is also used to grant the use of a role to one or more\nusers or other roles. In order to be able to grant a role, the grantor doing\nso must have permission to do so (see WITH ADMIN in the CREATE ROLE article).\n\nSpecifying the WITH ADMIN OPTION permits the grantee to in turn grant the role\nto another.\n\nFor example, the following commands show how to grant the same role to a\ncouple different users.\n\nGRANT journalist TO hulda;\n\nGRANT journalist TO berengar WITH ADMIN OPTION;\n\nIf a user has been granted a role, they do not automatically obtain all\npermissions associated with that role. These permissions are only in use when\nthe user activates the role with the SET ROLE statement.\n\nTO PUBLIC\n---------\n\nMariaDB starting with 10.11\n---------------------------\n\nSyntax\n------\n\nGRANT <privilege> ON <database>.<object> TO PUBLIC;\nREVOKE <privilege> ON <database>.<object> FROM PUBLIC;\n\nGRANT ... TO PUBLIC grants privileges to all users with access to the server.\nThe privileges also apply to users created after the privileges are granted.\nThis can be useful when one only wants to state once that all users need to\nhave a certain set of privileges.\n\nWhen running SHOW GRANTS, a user will also see all privileges inherited from\nPUBLIC. SHOW GRANTS FOR PUBLIC will only show TO PUBLIC grants.\n\nGrant Examples\n--------------\n\nGranting Root-like Privileges\n-----------------------------\n\nYou can create a user that has privileges similar to the default root accounts\nby executing the following:\n\nCREATE USER \'alexander\'@\'localhost\';\nGRANT ALL PRIVILEGES ON  *.* to \'alexander\'@\'localhost\' WITH GRANT OPTION;\n\nURL: https://mariadb.com/kb/en/grant/') WHERE help_topic_id = 108;
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (109,10,'RENAME USER','Syntax\n------\n\nRENAME USER old_user TO new_user\n  [, old_user TO new_user] ...\n\nDescription\n-----------\n\nThe RENAME USER statement renames existing MariaDB accounts. To use it, you\nmust have the global CREATE USER privilege or the UPDATE privilege for the\nmysql database. Each account is named using the same format as for the CREATE\nUSER statement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used.\n\nIf any of the old user accounts do not exist or any of the new user accounts\nalready exist, ERROR 1396 (HY000) results. If an error occurs, RENAME USER\nwill still rename the accounts that do not result in an error.\n\nExamples\n--------\n\nCREATE USER \'donald\', \'mickey\';\nRENAME USER \'donald\' TO \'duck\'@\'localhost\', \'mickey\' TO \'mouse\'@\'localhost\';\n\nURL: https://mariadb.com/kb/en/rename-user/','','https://mariadb.com/kb/en/rename-user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (110,10,'REVOKE','Privileges\n----------\n\nSyntax\n------\n\nREVOKE \n  priv_type [(column_list)]\n   [, priv_type [(column_list)]] ...\n  ON [object_type] priv_level\n  FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n  FROM user [, user] ...\n\nDescription\n-----------\n\nThe REVOKE statement enables system administrators to revoke privileges (or\nroles - see section below) from MariaDB accounts. Each account is named using\nthe same format as for the GRANT statement; for example,\n\'jeffrey\'@\'localhost\'. If you specify only the user name part of the account\nname, a host name part of \'%\' is used. For details on the levels at which\nprivileges exist, the allowable priv_type and priv_level values, and the\nsyntax for specifying users and passwords, see GRANT.\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION privilege, and\nyou must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all global,\ndatabase, table, column, and routine privileges for the named user or users:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nTo use this REVOKE syntax, you must have the global CREATE USER privilege or\nthe UPDATE privilege for the mysql database. See GRANT.\n\nExamples\n--------\n\nREVOKE SUPER ON *.* FROM \'alexander\'@\'localhost\';\n\nRoles\n-----\n\nSyntax\n------\n\nREVOKE role  [, role ...]\n  FROM grantee [, grantee2 ... ]\n\nREVOKE ADMIN OPTION FOR role FROM grantee [, grantee2]\n\nDescription\n-----------\n\nREVOKE is also used to remove a role from a user or another role that it\'s\npreviously been assigned to. If a role has previously been set as a default\nrole, REVOKE does not remove the record of the default role from the\nmysql.user table. If the role is subsequently granted again, it will again be\nthe user\'s default. Use SET DEFAULT ROLE NONE to explicitly remove this.\n\nBefore MariaDB 10.1.13, the REVOKE role statement was not permitted in\nprepared statements.\n\nExample\n-------\n\nREVOKE journalist FROM hulda\n\nURL: https://mariadb.com/kb/en/revoke/','','https://mariadb.com/kb/en/revoke/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (111,10,'SET PASSWORD','Syntax\n------\n\nSET PASSWORD [FOR user] =\n  {\n    PASSWORD(\'some password\')\n   | OLD_PASSWORD(\'some password\')\n   | \'encrypted password\'\n  }\n\nDescription\n-----------\n\nThe SET PASSWORD statement assigns a password to an existing MariaDB user\naccount.\n\nIf the password is specified using the PASSWORD() or OLD_PASSWORD() function,\nthe literal text of the password should be given. If the password is specified\nwithout using either function, the password should be the already-encrypted\npassword value as returned by PASSWORD().\n\nOLD_PASSWORD() should only be used if your MariaDB/MySQL clients are very old\n(< 4.0.0).\n\nWith no FOR clause, this statement sets the password for the current user. Any\nclient that has connected to the server using a non-anonymous account can\nchange the password for that account.\n\nWith a FOR clause, this statement sets the password for a specific account on\nthe current server host. Only clients that have the UPDATE privilege for the\nmysql database can do this. The user value should be given in\nuser_name@host_name format, where user_name and host_name are exactly as they\nare listed in the User and Host columns of the mysql.user table (or view in\nMariaDB-10.4 onwards) entry.\n\nThe argument to PASSWORD() and the password given to MariaDB clients can be of\narbitrary length.\n\nAuthentication Plugin Support\n-----------------------------\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, SET PASSWORD (with or without PASSWORD()) works for\naccounts authenticated via any authentication plugin that supports passwords\nstored in the mysql.global_priv table.\n\nThe ed25519, mysql_native_password, and mysql_old_password authentication\nplugins store passwords in the mysql.global_priv table.\n\nIf you run SET PASSWORD on an account that authenticates with one of these\nauthentication plugins that stores passwords in the mysql.global_priv table,\nthen the PASSWORD() function is evaluated by the specific authentication\nplugin used by the account. The authentication plugin hashes the password with\na method that is compatible with that specific authentication plugin.\n\nThe unix_socket, named_pipe, gssapi, and pam authentication plugins do not\nstore passwords in the mysql.global_priv table. These authentication plugins\nrely on other methods to authenticate the user.\n\nIf you attempt to run SET PASSWORD on an account that authenticates with one\nof these authentication plugins that doesn\'t store a password in the\nmysql.global_priv table, then MariaDB Server will raise a warning like the\nfollowing:\n\nSET PASSWORD is ignored for users authenticating via unix_socket plugin\n\nSee Authentication from MariaDB 10.4 for an overview of authentication changes\nin MariaDB 10.4.\n\nMariaDB until 10.3\n------------------\nIn MariaDB 10.3 and before, SET PASSWORD (with or without PASSWORD()) only\nworks for accounts authenticated via mysql_native_password or\nmysql_old_password authentication plugins\n\nPasswordless User Accounts\n--------------------------\n\nUser accounts do not always require passwords to login.\n\nThe unix_socket , named_pipe and gssapi authentication plugins do not require\na password to authenticate the user.\n\nThe pam authentication plugin may or may not require a password to\nauthenticate the user, depending on the specific configuration.\n\nThe mysql_native_password and mysql_old_password authentication plugins\nrequire passwords for authentication, but the password can be blank. In that\ncase, no password is required.\n\nIf you provide a password while attempting to log into the server as an\naccount that doesn\'t require a password, then MariaDB server will simply\nignore the password.\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, a user account can be defined to use multiple\nauthentication plugins in a specific order of preference. This specific\nscenario may be more noticeable in these versions, since an account could be\nassociated with some authentication plugins that require a password, and some\nthat do not.\n\nExample\n-------\n\nFor example, if you had an entry with User and Host column values of \'bob\' and\n\'%.loc.gov\', you would write the statement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nIf you want to delete a password for a user, you would do:\n\nSET PASSWORD FOR \'bob\'@localhost = PASSWORD(\"\");\n\nURL: https://mariadb.com/kb/en/set-password/','','https://mariadb.com/kb/en/set-password/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (112,10,'CREATE ROLE','Syntax\n------\n\nCREATE [OR REPLACE] ROLE [IF NOT EXISTS] role \n [WITH ADMIN\n  {CURRENT_USER | CURRENT_ROLE | user | role}]\n\nDescription\n-----------\n\nThe CREATE ROLE statement creates one or more MariaDB roles. To use it, you\nmust have the global CREATE USER privilege or the INSERT privilege for the\nmysql database. For each account, CREATE ROLE creates a new row in the\nmysql.user table that has no privileges, and with the corresponding is_role\nfield set to Y. It also creates a record in the mysql.roles_mapping table.\n\nIf any of the specified roles already exist, ERROR 1396 (HY000) results. If an\nerror occurs, CREATE ROLE will still create the roles that do not result in an\nerror. The maximum length for a role is 128 characters. Role names can be\nquoted, as explained in the Identifier names page. Only one error is produced\nfor all roles which have not been created:\n\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nPUBLIC and NONE are reserved, and cannot be used as role names. NONE is used\nto unset a role and PUBLIC has a special use in other systems, such as Oracle,\nso is reserved for compatibility purposes.\n\nFor valid identifiers to use as role names, see Identifier Names.\n\nWITH ADMIN\n----------\n\nThe optional WITH ADMIN clause determines whether the current user, the\ncurrent role or another user or role has use of the newly created role. If the\nclause is omitted, WITH ADMIN CURRENT_USER is treated as the default, which\nmeans that the current user will be able to GRANT this role to users.\n\nOR REPLACE\n----------\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP ROLE IF EXISTS name;\nCREATE ROLE name ...;\n\nIF NOT EXISTS\n-------------\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified role already exists. Cannot be used together with\nthe OR REPLACE clause.\n\nExamples\n--------\n\nCREATE ROLE journalist;\n\nCREATE ROLE developer WITH ADMIN lorinda@localhost;\n\nGranting the role to another user. Only user lorinda@localhost has permission\nto grant the developer role:\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| henning@localhost |\n+-------------------+\n...\nGRANT developer TO ian@localhost;\nAccess denied for user \'henning\'@\'localhost\'\n\nSELECT USER();\n+-------------------+\n| USER()            |\n+-------------------+\n| lorinda@localhost |\n+-------------------+\n\nGRANT m_role TO ian@localhost;\n\nThe OR REPLACE and IF NOT EXISTS clauses. The journalist role already exists:\n\nCREATE ROLE journalist;\nERROR 1396 (HY000): Operation CREATE ROLE failed for \'journalist\'\n\nCREATE OR REPLACE ROLE journalist;\nQuery OK, 0 rows affected (0.00 sec)\n\nCREATE ROLE IF NOT EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------------+\n| Level | Code | Message                                           |\n+-------+------+---------------------------------------------------+\n| Note  | 1975 | Can\'t create role \'journalist\'; it already exists |\n+-------+------+---------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/create-role/','','https://mariadb.com/kb/en/create-role/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (113,10,'DROP ROLE','Syntax\n------\n\nDROP ROLE [IF EXISTS] role_name [,role_name ...]\n\nDescription\n-----------\n\nThe DROP ROLE statement removes one or more MariaDB roles. To use this\nstatement, you must have the global CREATE USER privilege or the DELETE\nprivilege for the mysql database.\n\nDROP ROLE does not disable roles for connections which selected them with SET\nROLE. If a role has previously been set as a default role, DROP ROLE does not\nremove the record of the default role from the mysql.user table. If the role\nis subsequently recreated and granted, it will again be the user\'s default.\nUse SET DEFAULT ROLE NONE to explicitly remove this.\n\nIf any of the specified user accounts do not exist, ERROR 1396 (HY000)\nresults. If an error occurs, DROP ROLE will still drop the roles that do not\nresult in an error. Only one error is produced for all roles which have not\nbeen dropped:\n\nERROR 1396 (HY000): Operation DROP ROLE failed for \'a\',\'b\',\'c\'\n\nFailed CREATE or DROP operations, for both users and roles, produce the same\nerror code.\n\nIF EXISTS\n---------\n\nIf the IF EXISTS clause is used, MariaDB will return a warning instead of an\nerror if the role does not exist.\n\nExamples\n--------\n\nDROP ROLE journalist;\n\nThe same thing using the optional IF EXISTS clause:\n\nDROP ROLE journalist;\nERROR 1396 (HY000): Operation DROP ROLE failed for \'journalist\'\n\nDROP ROLE IF EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nNote (Code 1975): Can\'t drop role \'journalist\'; it doesn\'t exist\n\nURL: https://mariadb.com/kb/en/drop-role/','','https://mariadb.com/kb/en/drop-role/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (114,10,'SET ROLE','Syntax\n------\n\nSET ROLE { role | NONE }\n\nDescription\n-----------\n\nThe SET ROLE statement enables a role, along with all of its associated\npermissions, for the current session. To unset a role, use NONE .\n\nIf a role that doesn\'t exist, or to which the user has not been assigned, is\nspecified, an ERROR 1959 (OP000): Invalid role specification error occurs.\n\nAn automatic SET ROLE is implicitly performed when a user connects if that\nuser has been assigned a default role. See SET DEFAULT ROLE.\n\nExample\n-------\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE staff;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| staff        |\n+--------------+\n\nSET ROLE NONE;\n\nSELECT CURRENT_ROLE();\n+----------------+\n| CURRENT_ROLE() |\n+----------------+\n| NULL           |\n+----------------+\n\nURL: https://mariadb.com/kb/en/set-role/','','https://mariadb.com/kb/en/set-role/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (115,10,'SET DEFAULT ROLE','Syntax\n------\n\nSET DEFAULT ROLE { role | NONE } [ FOR user@host ]\n\nDescription\n-----------\n\nThe SET DEFAULT ROLE statement sets a default role for a specified (or\ncurrent) user. A default role is automatically enabled when a user connects\n(an implicit SET ROLE statement is executed immediately after a connection is\nestablished).\n\nTo be able to set a role as a default, the role must already have been granted\nto that user, and one needs the privileges to enable this role (if you cannot\ndo SET ROLE X, you won\'t be able to do SET DEFAULT ROLE X). To set a default\nrole for another user one needs to have write access to the mysql database.\n\nTo remove a user\'s default role, use SET DEFAULT ROLE NONE [ FOR user@host ].\nThe record of the default role is not removed if the role is dropped or\nrevoked, so if the role is subsequently re-created or granted, it will again\nbe the user\'s default role.\n\nThe default role is stored in the default_role column in the mysql.user\ntable/view, as well as in the Information Schema APPLICABLE_ROLES table, so\nthese can be viewed to see which role has been assigned to a user as the\ndefault.\n\nExamples\n--------\n\nSetting a default role for the current user:\n\nSET DEFAULT ROLE journalist;\n\nRemoving a default role from the current user:\n\nSET DEFAULT ROLE NONE;\n\nSetting a default role for another user. The role has to have been granted to\nthe user before it can be set as default:\n\nCREATE ROLE journalist;\nCREATE USER taniel;\n\nSET DEFAULT ROLE journalist FOR taniel;\nERROR 1959 (OP000): Invalid role specification `journalist`\n\nGRANT journalist TO taniel;\nSET DEFAULT ROLE journalist FOR taniel;\n\nViewing mysql.user:\n\nselect * from mysql.user where user=\'taniel\'\\G\n*************************** 1. row ***************************\n         Host: %\n         User: taniel\n...\n       is_role: N\n     default_role: journalist\n...\n\nRemoving a default role for another user\n\nSET DEFAULT ROLE NONE FOR taniel;\n\nURL: https://mariadb.com/kb/en/set-default-role/','','https://mariadb.com/kb/en/set-default-role/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (116,10,'Roles Overview','Description\n-----------\n\nA role bundles a number of privileges together. It assists larger\norganizations where, typically, a number of users would have the same\nprivileges, and, previously, the only way to change the privileges for a group\nof users was by changing each user\'s privileges individually.\n\nAlternatively, multiple external users could have been assigned the same user,\nand there would have been no way to see which actual user was responsible for\nwhich action.\n\nWith roles, managing this is easy. For example, there could be a number of\nusers assigned to a journalist role, with identical privileges. Changing the\nprivileges for all the journalists is a matter of simply changing the role\'s\nprivileges, while the individual user is still linked with any changes that\ntake place.\n\nRoles are created with the CREATE ROLE statement, and dropped with the DROP\nROLE statement. Roles are then assigned to a user with an extension to the\nGRANT statement, while privileges are assigned to a role in the regular way\nwith GRANT. Similarly, the REVOKE statement can be used to both revoke a role\nfrom a user, or revoke a privilege from a role.\n\nOnce a user has connected, he can obtain all privileges associated with a role\nby setting a role with the SET ROLE statement. The CURRENT_ROLE function\nreturns the currently set role for the session, if any.\n\nOnly roles granted directly to a user can be set, roles granted to other roles\ncannot. Instead the privileges granted to a role, which is, in turn, granted\nto another role (grantee), will be immediately available to any user who sets\nthis second grantee role.\n\nThe SET DEFAULT ROLE statement allows one to set a default role for a user. A\ndefault role is automatically enabled when a user connects (an implicit SET\nROLE statement is executed immediately after a connection is established).\n\nRoles were implemented as a GSoC 2013 project by Vicentiu Ciorbaru.\n\nSystem Tables\n-------------\n\nInformation about roles and who they\'ve been granted to can be found in the\nInformation Schema APPLICABLE_ROLES table as well as the mysql.ROLES_MAPPING\ntable.\n\nThe Information Schema ENABLED_ROLES table shows the enabled roles for the\ncurrent session.\n\nExamples\n--------\n\nCreating a role and granting a privilege:\n\nCREATE ROLE journalist;\n\nGRANT SHOW DATABASES ON *.* TO journalist;\n\nGRANT journalist to hulda;\n\nNote, that hulda has no SHOW DATABASES privilege, even though she was granted\nthe journalist role. She needs to set the role first:\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| information_schema |\n+--------------------+\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE journalist;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist   |\n+--------------+\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| ...                |\n| information_schema |\n| mysql              |\n| performance_schema |\n| test               |\n| ...                |\n+--------------------+\n\nSET ROLE NONE;\n\nRoles can be granted to roles:\n\nCREATE ROLE writer;\n\nGRANT SELECT ON data.* TO writer;\n\nGRANT writer TO journalist;\n\nBut one does not need to set a role granted to a role. For example, hulda will\nautomatically get all writer privileges when she sets the journalist role:\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSHOW TABLES FROM data;\nEmpty set (0.01 sec)\n\nSET ROLE journalist;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist   |\n+--------------+\n\nSHOW TABLES FROM data;\n+------------------------------+\n| Tables_in_data               |\n+------------------------------+\n| set1                         |\n| ...                          |\n+------------------------------+\n\nRoles and Views (and Stored Routines)\n-------------------------------------\n\nWhen a user sets a role, he, in a sense, has two identities with two\nassociated sets of privileges. But a view (or a stored routine) can have only\none definer. So, when a view (or a stored routine) is created with the SQL\nSECURITY DEFINER, one can specify whether the definer should be CURRENT_USER\n(and the view will have none of the privileges of the user\'s role) or\nCURRENT_ROLE (in this case, the view will use role\'s privileges, but none of\nthe user\'s privileges). As a result, sometimes one can create a view that is\nimpossible to use.\n\nCREATE ROLE r1;\n\nGRANT ALL ON db1.* TO r1;\n\nGRANT r1 TO foo@localhost;\n\nGRANT ALL ON db.* TO foo@localhost;\n\nSELECT CURRENT_USER\n+---------------+\n| current_user  |\n+---------------+\n| foo@localhost |\n+---------------+\n\nSET ROLE r1;\n\nCREATE TABLE db1.t1 (i int);\n\nCREATE VIEW db.v1 AS SELECT * FROM db1.t1;\n\nSHOW CREATE VIEW db.v1;\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n| View | Create View                                                          \n                                 |\ncharacter_set_client | collation_connection |\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n| v1   | CREATE ALGORITHM=UNDEFINED DEFINER=`foo`@`localhost` SQL SECURITY\nDEFINER VIEW `db`.`v1` AS SELECT `db1`.`t1`.`i` AS `i` from `db1`.`t1` | utf8 \n       | utf8_general_ci      |\n+------+-----------------------------------------------------------------------\n------------------------------------------------------------------+------------\n---------+----------------------+\n\nCREATE DEFINER=CURRENT_ROLE VIEW db.v2 AS SELECT * FROM db1.t1;\n\nSHOW CREATE VIEW db.b2;\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n| View | Create View                                                          \n                           | character_set_client |\ncollation_connection |\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n| v2   | CREATE ALGORITHM=UNDEFINED DEFINER=`r1` SQL SECURITY DEFINER VIEW\n`db`.`v2` AS select `db1`.`t1`.`a` AS `a` from `db1`.`t1` | utf8              \n | utf8_general_ci      |\n+------+-----------------------------------------------------------------------\n-----------------------------------------------------+----------------------+--\n-------------------+\n\nOther Resources\n---------------\n\n* Roles Review by Peter Gulutzan\n\nURL: https://mariadb.com/kb/en/roles_overview/','','https://mariadb.com/kb/en/roles_overview/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (117,10,'Account Locking','MariaDB starting with 10.4.2\n----------------------------\nAccount locking was introduced in MariaDB 10.4.2.\n\nDescription\n-----------\n\nAccount locking permits privileged administrators to lock/unlock user\naccounts. No new client connections will be permitted if an account is locked\n(existing connections are not affected).\n\nUser accounts can be locked at creation, with the CREATE USER statement, or\nmodified after creation with the ALTER USER statement. For example:\n\nCREATE USER \'lorin\'@\'localhost\' ACCOUNT LOCK;\n\nor\n\nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n\nThe server will return an ER_ACCOUNT_HAS_BEEN_LOCKED error when locked users\nattempt to connect:\n\nmysql -ulorin\n ERROR 4151 (HY000): Access denied, this account is locked\n\nThe ALTER USER statement is also used to unlock a user:\n\nALTER USER \'lorin\'@\'localhost\' ACCOUNT UNLOCK;\n\nThe SHOW CREATE USER statement will show whether the account is locked:\n\nSHOW CREATE USER \'marijn\'@\'localhost\';\n+-----------------------------------------------+\n| CREATE USER for marijn@localhost              |\n+-----------------------------------------------+\n| CREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK |\n+-----------------------------------------------+\n\nas well as querying the mysql.global_priv table:\n\nSELECT CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) FROM\nmysql.global_priv \n WHERE user=\'marijn\';\n+------------------------------------------------------------------------------\n-------+\n| CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv))                        \n    |\n+------------------------------------------------------------------------------\n-------+\n| marijn@localhost => {\n  \"access\": 0,\n  \"plugin\": \"mysql_native_password\",\n  \"authentication_string\": \"\",\n  \"account_locked\": true,\n  \"password_last_changed\": 1558017158\n} |\n+------------------------------------------------------------------------------\n-------+\n\nURL: https://mariadb.com/kb/en/account-locking/','','https://mariadb.com/kb/en/account-locking/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (118,10,'Authentication from MariaDB 10.4','MariaDB starting with 10.4\n--------------------------\nMariaDB 10.4 introduced a number of changes to the authentication process,\nintended to make things easier and more intuitive.\n\nOverview\n--------\n\nThere are four new main features in 10.4 relating to authentication:\n\n* It is possible to use more than one authentication plugin for each user\naccount. For example, this can be useful to slowly migrate users to the more\nsecure ed25519 authentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an alternative for the\ntransitional period.\n* The root@localhost user account created by mariadb-install-db is created\nwith the ability to use two authentication plugins.\nFirst, it is configured to try to use the unix_socket authentication plugin.\nThis allows the root@localhost user to login without a password via the local\nUnix socket file defined by the socket system variable, as long as the login\nis attempted from a process owned by the operating system root user account.\nSecond, if authentication fails with the unix_socket authentication plugin,\nthen it is configured to try to use the mysql_native_password authentication\nplugin. However, an invalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET PASSWORD.\nHowever, just using the unix_socket authentication plugin may be fine for many\nusers, and it is very secure. You may want to try going without password\nauthentication to see how well it works for you. Remember, the best way to\nkeep your password safe is not to have one!\n\n* All user accounts, passwords, and global privileges are now stored in the\nmysql.global_priv table. The mysql.user table still exists and has exactly the\nsame set of columns as before, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user table should\ncontinue to work as before. From MariaDB 10.4.13, the dedicated mariadb.sys\nuser is created as the definer of this view. Previously root was the definer,\nwhich resulted in privilege problems when this username was changed.\n* MariaDB 10.4 adds supports for User Password Expiry, which is not active by\ndefault.\n\nDescription\n-----------\n\nAs a result of the above changes, the open-for-everyone all-powerful root\naccount is finally gone. And installation scripts will no longer demand that\nyou \"PLEASE REMEMBER TO SET A PASSWORD FOR THE MariaDB root USER !\", because\nthe root account is securely created automatically.\n\nTwo all-powerful accounts are created by default — root and the OS user that\nowns the data directory, typically mysql. They are created as:\n\nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR mysql_native_password\nUSING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n\nUsing unix_socket means that if you are the system root user, you can login as\nroot@locahost without a password. This technique was pioneered by Otto\nKekäläinen in Debian MariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0.\n\nIt is based on a simple fact that asking the system root for a password adds\nno extra security — root has full access to all the data files and all process\nmemory anyway. But not asking for a password means, there is no root password\nto forget (no need for the numerous tutorials on \"how to reset MariaDB root\npassword\"). And if you want to script some tedious database work, there is no\nneed to store the root password in plain text for the script to use (no need\nfor debian-sys-maint user).\n\nStill, some users may wish to log in as MariaDB root without using sudo. Hence\nthe old authentication method — conventional MariaDB password — is still\navailable. By default it is disabled (\"invalid\" is not a valid password hash),\nbut one can set the password with a usual SET PASSWORD statement. And still\nretain the password-less access via sudo.\n\nIf you install MariaDB locally (say from a tarball), you would not want to use\nsudo to be able to login. This is why MariaDB creates a second all-powerful\nuser with the same name as a system user that owns the data directory. In\nlocal (not system-wide) installations, this will be the user who installed\nMariaDB — they automatically get convenient password-less root-like access,\nbecause they can access all the data files anyway.\n\nEven if MariaDB is installed system-wide, you may not want to run your\ndatabase maintenance scripts as system root — now you can run them as system\nmysql user. And you will know that they will never destroy your entire system,\neven if you make a typo in a shell script.\n\nHowever, seasoned MariaDB DBAs who are used to the old ways do need to make\nsome changes. See the examples below for common tasks.\n\nCookbook\n--------\n\nAfter installing MariaDB system-wide the first thing you’ve got used to doing\nis logging in into the unprotected root account and protecting it, that is,\nsetting the root password:\n\n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n\nThis is not only unnecessary now, it will simply not work — there is no\nunprotected root account. To login as root use\n\n$ sudo dnf install MariaDB-server\n$ sudo mysql\n\nNote that it implies you are connecting via the unix socket, not tcp. If you\nhappen to have protocol=tcp in a system-wide /etc/my.cnf file, use sudo mysql\n--protocol=socket.\n\nAfter installing MariaDB locally you’ve also used to connect to the\nunprotected root account using mysql -uroot. This will not work either, simply\nuse mysql without specifying a username.\n\nIf you\'ve forgotten your root password, no problem — you can still connect\nusing sudo and change the password. And if you\'ve also removed unix_socket\nauthentication, to restore access do as follows:\n\n* restart MariaDB with --skip-grant-tables\n* login into the unprotected server\n* run FLUSH PRIVILEGES (note, before 10.4 this would’ve been the last step,\nnot anymore). This disables --skip-grant-tables and allows you to change the\nstored authentication method\n* run SET PASSWORD FOR root@localhost to change the root password.\n\nTo view inside privilege tables, the old mysql.user table still exists. You\ncan select from it as before, although you cannot update it anymore. It\ndoesn’t show alternative authentication plugins and this was one of the\nreasons for switching to the mysql.global_priv table — complex authentication\nrules did not fit into rigid structure of a relational table. You can select\nfrom the new table, for example:\n\nselect concat(user, \'@\', host, \' => \', json_detailed(priv)) from\nmysql.global_priv;\n\nReverting to the Previous Authentication Method for root@localhost\n------------------------------------------------------------------\n\nIf you don\'t want the root@localhost user account created by\nmariadb-install-db to use unix_socket authentication by default, then there\nare a few ways to revert to the previous mysql_native_password authentication\nmethod for this user account.\n\nConfiguring mariadb-install-db to Revert to the Previous Authentication Method\n------------------------------------------------------------------------------\n\nOne way to revert to the previous mysql_native_password authentication method\nfor the root@localhost user account is to execute mariadb-install-db with a\nspecial option. If mariadb-install-db is executed while\n--auth-root-authentication-method=normal is specified, then it will create the\ndefault user accounts using the default behavior of MariaDB 10.3 and before.\n\nThis means that the root@localhost user account will use mysql_native_password\nauthentication by default. There are some other differences as well. See\nmariadb-install-db: User Accounts Created by Default for more information.\n\nFor example, the option can be set on the command-line while running\nmariadb-install-db:\n\nmariadb-install-db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n\nThe option can also be set in an option file in an option group supported by\nmariadb-install-db. For example:\n\n[mysql_install_db]\nauth_root_authentication_method=normal\n\nIf the option is set in an option file and if mariadb-install-db is executed,\nthen mariadb-install-db will read this option from the option file, and it\nwill automatically set this option.\n\nAltering the User Account to Revert to the Previous Authentication Method\n-------------------------------------------------------------------------\n\nIf you have already installed MariaDB, and if the root@localhost user account\nis already using unix_socket authentication, then you can revert to the old\nmysql_native_password authentication method for the user account by executing\nthe following:\n\nALTER USER root@localhost IDENTIFIED VIA mysql_native_password USING\nPASSWORD(\"verysecret\")\n\nURL: https://mariadb.com/kb/en/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/authentication-from-mariadb-104/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (119,10,'User Password Expiry','MariaDB starting with 10.4.3\n----------------------------\nUser password expiry was introduced in MariaDB 10.4.3.\n\nPassword expiry permits administrators to expire user passwords, either\nmanually or automatically.\n\nSystem Variables\n----------------\n\nThere are two system variables which affect password expiry:\ndefault_password_lifetime, which determines the amount of time between\nrequiring the user to change their password. 0, the default, means automatic\npassword expiry is not active.\n\nThe second variable, disconnect_on_expired_password determines whether a\nclient is permitted to connect if their password has expired, or whether they\nare permitted to connect in sandbox mode, able to perform a limited subset of\nqueries related to resetting the password, in particular SET PASSWORD and SET.\n\nSetting a Password Expiry Limit for a User\n------------------------------------------\n\nBesides automatic password expiry, as determined by default_password_lifetime,\npassword expiry times can be set on an individual user basis, overriding the\nglobal using the CREATE USER or ALTER USER statements, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nLimits can be disabled by use of the NEVER keyword, for example:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n\nA manually set limit can be restored the system default by use of DEFAULT, for\nexample:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSHOW CREATE USER\n----------------\n\nThe SHOW CREATE USER statement will display information about the password\nexpiry status of the user. Unlike MySQL, it will not display if the user is\nunlocked, or if the password expiry is set to default.\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\nCREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE NEVER;\nCREATE USER \'amse\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n\nSHOW CREATE USER \'monty\'@\'localhost\';\n+------------------------------------------------------------------+\n| CREATE USER for monty@localhost                                  |\n+------------------------------------------------------------------+\n| CREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY |\n+------------------------------------------------------------------+\n\nSHOW CREATE USER \'konstantin\'@\'localhost\';\n+------------------------------------------------------------+\n| CREATE USER for konstantin@localhost                       |\n+------------------------------------------------------------+\n| CREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE NEVER |\n+------------------------------------------------------------+\n\nSHOW CREATE USER \'amse\'@\'localhost\';\n+--------------------------------+\n| CREATE USER for amse@localhost |\n+--------------------------------+\n| CREATE USER \'amse\'@\'localhost\' |\n+--------------------------------+\n\nChecking When Passwords Expire\n------------------------------\n\nThe following query can be used to check when the current passwords expire for\nall users:\n\nWITH password_expiration_info AS (\n SELECT User, Host,\n IF(\n IFNULL(JSON_EXTRACT(Priv, \'$.password_lifetime\'), -1) = -1,\n @@global.default_password_lifetime,\n JSON_EXTRACT(Priv, \'$.password_lifetime\')\n ) AS password_lifetime,\n JSON_EXTRACT(Priv, \'$.password_last_changed\') AS password_last_changed\n FROM mysql.global_priv\n)\nSELECT pei.User, pei.Host,\n pei.password_lifetime,\n FROM_UNIXTIME(pei.password_last_changed) AS password_last_changed_datetime,\n FROM_UNIXTIME(\n pei.password_last_changed +\n (pei.password_lifetime * 60 * 60 * 24)\n ) AS password_expiration_datetime\n FROM password_expiration_info pei\n WHERE pei.password_lifetime != 0\n AND pei.password_last_changed IS NOT NULL\nUNION\nSELECT pei.User, pei.Host,\n pei.password_lifetime,\n FROM_UNIXTIME(pei.password_last_changed) AS password_last_changed_datetime,\n 0 AS password_expiration_datetime\n FROM password_expiration_info pei\n WHERE pei.password_lifetime = 0\n OR pei.password_last_changed IS NULL;\n\n--connect-expired-password Client Option\n----------------------------------------\n\nThe mariadb client --connect-expired-password option notifies the server that\nthe client is prepared to handle expired password sandbox mode (even if the\n--batch option was specified).\n\nURL: https://mariadb.com/kb/en/user-password-expiry/','','https://mariadb.com/kb/en/user-password-expiry/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (120,11,'ST_X','Syntax\n------\n\nST_X(p)\nX(p)\n\nDescription\n-----------\n\nReturns the X-coordinate value for the point p as a double-precision number.\n\nST_X() and X() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_x/','','https://mariadb.com/kb/en/st_x/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (121,11,'ST_Y','Syntax\n------\n\nST_Y(p)\nY(p)\n\nDescription\n-----------\n\nReturns the Y-coordinate value for the point p as a double-precision number.\n\nST_Y() and Y() are synonyms.\n\nExamples\n--------\n\nSET @pt = \'Point(56.7 53.34)\';\n\nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/st_y/','','https://mariadb.com/kb/en/st_y/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (122,11,'X','A synonym for ST_X.\n\nURL: https://mariadb.com/kb/en/point-properties-x/','','https://mariadb.com/kb/en/point-properties-x/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (123,11,'Y','A synonym for ST_Y.\n\nURL: https://mariadb.com/kb/en/point-properties-y/','','https://mariadb.com/kb/en/point-properties-y/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (124,12,'UNCOMPRESS','Syntax\n------\n\nUNCOMPRESS(string_to_uncompress)\n\nDescription\n-----------\n\nUncompresses a string compressed by the COMPRESS() function. If the argument\nis not a compressed value, the result is NULL. This function requires MariaDB\nto have been compiled with a compression library such as zlib. Otherwise, the\nreturn value is always NULL. The have_compress server system variable\nindicates whether a compression library is present.\n\nExamples\n--------\n\nSELECT UNCOMPRESS(COMPRESS(\'a string\'));\n+----------------------------------+\n| UNCOMPRESS(COMPRESS(\'a string\')) |\n+----------------------------------+\n| a string                         |\n+----------------------------------+\n\nSELECT UNCOMPRESS(\'a string\');\n+------------------------+\n| UNCOMPRESS(\'a string\') |\n+------------------------+\n| NULL                   |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/uncompress/','','https://mariadb.com/kb/en/uncompress/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (125,12,'DECODE','Syntax\n------\n\nDECODE(crypt_str,pass_str)\n\nIn Oracle mode from MariaDB 10.3.2:\n\nDECODE(expr, search_expr, result_expr [, search_expr2, result_expr2 ...]\n[default_expr])\n\nIn all modes from MariaDB 10.3.2:\n\nDECODE_ORACLE(expr, search_expr, result_expr [, search_expr2, result_expr2\n...] [default_expr])\n\nDescription\n-----------\n\nIn the default mode, DECODE decrypts the encrypted string crypt_str using\npass_str as the password. crypt_str should be a string returned from ENCODE().\nThe resulting string will be the original string only if pass_str is the same.\n\nIn Oracle mode from MariaDB 10.3.2, DECODE compares expr to the search\nexpressions, in order. If it finds a match, the corresponding result\nexpression is returned. If no matches are found, the default expression is\nreturned, or NULL if no default is provided.\n\nNULLs are treated as equivalent.\n\nDECODE_ORACLE is a synonym for the Oracle-mode version of the function, and is\navailable in all modes.\n\nExamples\n--------\n\nFrom MariaDB 10.3.2:\n\nSELECT DECODE_ORACLE(2+1,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+1,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| found1                                                 |\n+--------------------------------------------------------+\n\nSELECT DECODE_ORACLE(2+4,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+4,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| found2                                                 |\n+--------------------------------------------------------+\n\nSELECT DECODE_ORACLE(2+2,3*1,\'found1\',3*2,\'found2\',\'default\');\n+--------------------------------------------------------+\n| DECODE_ORACLE(2+2,3*1,\'found1\',3*2,\'found2\',\'default\') |\n+--------------------------------------------------------+\n| default                                                |\n+--------------------------------------------------------+\n\nNulls are treated as equivalent:\n\nSELECT DECODE_ORACLE(NULL,NULL,\'Nulls are equivalent\',\'Nulls are not\nequivalent\');\n+----------------------------------------------------------------------------+\n| DECODE_ORACLE(NULL,NULL,\'Nulls are equivalent\',\'Nulls are not equivalent\') |\n+----------------------------------------------------------------------------+\n| Nulls are equivalent                                                       |\n+----------------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/decode/','','https://mariadb.com/kb/en/decode/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (126,12,'DECODE_ORACLE','MariaDB starting with 10.3.2\n----------------------------\nDECODE_ORACLE is a synonym for the Oracle mode version of the DECODE function,\nand is available in all modes.\n\nURL: https://mariadb.com/kb/en/decode_oracle/','','https://mariadb.com/kb/en/decode_oracle/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (127,12,'AES_DECRYPT','Syntax\n------\n\nAES_DECRYPT(crypt_str,key_str)\n\nFrom MariaDB 11.2.0\n\nAES_ENCRYPT(crypt_str, key_str, [, iv [, mode]])\n\nDescription\n-----------\n\nThis function allows decryption of data using the official AES (Advanced\nEncryption Standard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nMariaDB starting with 11.2\n--------------------------\nFrom MariaDB 11.2, the function supports an initialization vector, and control\nof the block encryption mode. The default mode is specified by the\nblock_encryption_mode system variable, which can be changed when calling the\nfunction with a mode. mode is aes-{128,192,256}-{ecb,cbc,ctr} for example:\n\"AES-128-cbc\".\n\nFor modes that require it, the initialization_vector iv should be 16 bytes (it\ncan be longer, but the extra bytes are ignored). A shorter iv, where one is\nrequired, results in the function returning NULL. Calling RANDOM_BYTES(16)\nwill generate a random series of bytes that can be used for the iv.\n\nExamples\n--------\n\nFrom MariaDB 11.2.0:\n\nSELECT HEX(AES_ENCRYPT(\'foo\', \'bar\', \'0123456789abcdef\', \'aes-128-ctr\')) AS x; \n+--------+\n| x      |\n+--------+\n| C57C4B |\n+--------+\n\nSELECT AES_DECRYPT(x\'C57C4B\', \'bar\', \'0123456789abcdef\', \'aes-128-ctr\'); \n+------------------------------------------------------------------+\n| AES_DECRYPT(x\'C57C4B\', \'bar\', \'0123456789abcdef\', \'aes-128-ctr\') |\n+------------------------------------------------------------------+\n| foo                                                              |\n+------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/aes_decrypt/','','https://mariadb.com/kb/en/aes_decrypt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (128,12,'AES_ENCRYPT','Syntax\n------\n\nAES_ENCRYPT(str,key_str)\n\nFrom MariaDB 11.2.0\n\nAES_ENCRYPT(str, key, [, iv [, mode]])\n\nDescription\n-----------\n\nAES_ENCRYPT() and AES_DECRYPT() allow encryption and decryption of data using\nthe official AES (Advanced Encryption Standard) algorithm, previously known as\n\"Rijndael.\" Encoding with a 128-bit key length is used (from MariaDB 11.2.0,\nthis is the default, and can be changed). 128 bits is much faster and is\nsecure enough for most purposes.\n\nAES_ENCRYPT() encrypts a string str using the key key_str, and returns a\nbinary string.\n\nAES_DECRYPT() decrypts the encrypted string and returns the original string.\n\nThe input arguments may be any length. If either argument is NULL, the result\nof this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode uneven\nlength strings and so the result string length may be calculated using this\nformula:\n\n16 x (trunc(string_length / 16) + 1)\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns NULL.\nHowever, it is possible for AES_DECRYPT() to return a non-NULL value (possibly\ngarbage) if the input data or the key is invalid.\n\nMariaDB starting with 11.2\n--------------------------\nFrom MariaDB 11.2, the function supports an initialization vector, and control\nof the block encryption mode. The default mode is specified by the\nblock_encryption_mode system variable, which can be changed when calling the\nfunction with a mode. mode is aes-{128,192,256}-{ecb,cbc,ctr} for example:\n\"AES-128-cbc\".\n\nAES_ENCRYPT(str, key) can no longer be used in persistent virtual columns (and\nthe like).\n\nExamples\n--------\n\nINSERT INTO t VALUES (AES_ENCRYPT(\'text\',SHA2(\'password\',512)));\n\nFrom MariaDB 11.2.0:\n\nSELECT HEX(AES_ENCRYPT(\'foo\', \'bar\', \'0123456789abcdef\', \'aes-256-cbc\')) AS x;\n+----------------------------------+\n| x                                |\n+----------------------------------+\n| 42A3EB91E6DFC40A900D278F99E0726E |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/aes_encrypt/','','https://mariadb.com/kb/en/aes_encrypt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (129,12,'COMPRESS','Syntax\n------\n\nCOMPRESS(string_to_compress)\n\nDescription\n-----------\n\nCompresses a string and returns the result as a binary string. This function\nrequires MariaDB to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL. The compressed string can be\nuncompressed with UNCOMPRESS().\n\nThe have_compress server system variable indicates whether a compression\nlibrary is present.\n\nExamples\n--------\n\nSELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n+------------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',1000))) |\n+------------------------------------+\n|                                 21 |\n+------------------------------------+\n\nSELECT LENGTH(COMPRESS(\'\'));\n+----------------------+\n| LENGTH(COMPRESS(\'\')) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nSELECT LENGTH(COMPRESS(\'a\'));\n+-----------------------+\n| LENGTH(COMPRESS(\'a\')) |\n+-----------------------+\n|                    13 |\n+-----------------------+\n\nSELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n+----------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',16))) |\n+----------------------------------+\n|                               15 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/compress/','','https://mariadb.com/kb/en/compress/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (130,12,'DES_DECRYPT','DES_DECRYPT has been deprecated from MariaDB 10.10.0, and will be removed in a\nfuture release.\n\nSyntax\n------\n\nDES_DECRYPT(crypt_str[,key_str])\n\nDescription\n-----------\n\nDecrypts a string encrypted with DES_ENCRYPT(). If an error occurs, this\nfunction returns NULL.\n\nThis function works only if MariaDB has been configured with TLS support.\n\nIf no key_str argument is given, DES_DECRYPT() examines the first byte of the\nencrypted string to determine the DES key number that was used to encrypt the\noriginal string, and then reads the key from the DES key file to decrypt the\nmessage. For this to work, the user must have the SUPER privilege. The key\nfile can be specified with the --des-key-file server option.\n\nIf you pass this function a key_str argument, that string is used as the key\nfor decrypting the message.\n\nIf the crypt_str argument does not appear to be an encrypted string, MariaDB\nreturns the given crypt_str.\n\nURL: https://mariadb.com/kb/en/des_decrypt/','','https://mariadb.com/kb/en/des_decrypt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (131,12,'DES_ENCRYPT','DES_ENCRYPT has been deprecated from MariaDB 10.10.0, and will be removed in a\nfuture release.\n\nSyntax\n------\n\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nDescription\n-----------\n\nEncrypts the string with the given key using the Triple-DES algorithm.\n\nThis function works only if MariaDB has been configured with TLS support.\n\nThe encryption key to use is chosen based on the second argument to\nDES_ENCRYPT(), if one was given. With no argument, the first key from the DES\nkey file is used. With a key_num argument, the given key number (0-9) from the\nDES key file is used. With a key_str argument, the given key string is used to\nencrypt str.\n\nThe key file can be specified with the --des-key-file server option.\n\nThe return string is a binary string where the first character is CHAR(128 |\nkey_num). If an error occurs, DES_ENCRYPT() returns NULL.\n\nThe 128 is added to make it easier to recognize an encrypted key. If you use a\nstring key, key_num is 127.\n\nThe string length for the result is given by this formula:\n\nnew_len = orig_len + (8 - (orig_len % 8)) + 1\n\nEach line in the DES key file has the following format:\n\nkey_num des_key_str\n\nEach key_num value must be a number in the range from 0 to 9. Lines in the\nfile may be in any order. des_key_str is the string that is used to encrypt\nthe message. There should be at least one space between the number and the\nkey. The first key is the default key that is used if you do not specify any\nkey argument to DES_ENCRYPT().\n\nYou can tell MariaDB to read new key values from the key file with the FLUSH\nDES_KEY_FILE statement. This requires the RELOAD privilege.\n\nOne benefit of having a set of default keys is that it gives applications a\nway to check for the existence of encrypted column values, without giving the\nend user the right to decrypt those values.\n\nExamples\n--------\n\nSELECT customer_address FROM customer_table \n WHERE crypted_credit_card = DES_ENCRYPT(\'credit_card_number\');\n\nURL: https://mariadb.com/kb/en/des_encrypt/','','https://mariadb.com/kb/en/des_encrypt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (132,12,'ENCODE','Syntax\n------\n\nENCODE(str,pass_str)\n\nDescription\n-----------\n\nENCODE is not considered cryptographically secure, and should not be used for\npassword encryption.\n\nEncrypt str using pass_str as the password. To decrypt the result, use\nDECODE().\n\nThe result is a binary string of the same length as str.\n\nThe strength of the encryption is based on how good the random generator is.\n\nIt is not recommended to rely on the encryption performed by the ENCODE\nfunction. Using a salt value (changed when a password is updated) will improve\nmatters somewhat, but for storing passwords, consider a more cryptographically\nsecure function, such as SHA2().\n\nExamples\n--------\n\nENCODE(\'not so secret text\', CONCAT(\'random_salt\',\'password\'))\n\nURL: https://mariadb.com/kb/en/encode/','','https://mariadb.com/kb/en/encode/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (133,12,'ENCRYPT','Syntax\n------\n\nENCRYPT(str[,salt])\n\nDescription\n-----------\n\nEncrypts a string using the Unix crypt() system call, returning an encrypted\nbinary string. The salt argument should be a string with at least two\ncharacters or the returned result will be NULL. If no salt argument is given,\na random value of sufficient length is used.\n\nIt is not recommended to use ENCRYPT() with utf16, utf32 or ucs2 multi-byte\ncharacter sets because the crypt() system call expects a string terminated\nwith a zero byte.\n\nNote that the underlying crypt() system call may have some limitations, such\nas ignoring all but the first eight characters.\n\nIf the have_crypt system variable is set to NO (because the crypt() system\ncall is not available), the ENCRYPT function will always return NULL.\n\nExamples\n--------\n\nSELECT ENCRYPT(\'encrypt me\');\n+-----------------------+\n| ENCRYPT(\'encrypt me\') |\n+-----------------------+\n| 4I5BsEx0lqTDk         |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/encrypt/','','https://mariadb.com/kb/en/encrypt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (134,12,'MD5','Syntax\n------\n\nMD5(str)\n\nDescription\n-----------\n\nCalculates an MD5 128-bit checksum for the string.\n\nThe return value is a 32-hex digit string, and as of MariaDB 5.5, is a\nnonbinary string in the connection character set and collation, determined by\nthe values of the character_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n\nNULL is returned if the argument was NULL.\n\nExamples\n--------\n\nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\')                   |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/md5/','','https://mariadb.com/kb/en/md5/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (135,12,'OLD_PASSWORD','Syntax\n------\n\nOLD_PASSWORD(str)\n\nDescription\n-----------\n\nOLD_PASSWORD() was added to MySQL when the implementation of PASSWORD() was\nchanged to improve security. OLD_PASSWORD() returns the value of the old\n(pre-MySQL 4.1) implementation of PASSWORD() as a string, and is intended to\npermit you to reset passwords for any pre-4.1 clients that need to connect to\na more recent MySQL server version, or any version of MariaDB, without locking\nthem out.\n\nAs of MariaDB 5.5, the return value is a nonbinary string in the connection\ncharacter set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system variables. Before\n5.5, the return value was a binary string.\n\nThe return value is 16 bytes in length, or NULL if the argument was NULL.\n\nURL: https://mariadb.com/kb/en/old_password/','','https://mariadb.com/kb/en/old_password/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (136,12,'PASSWORD','Syntax\n------\n\nPASSWORD(str)\n\nDescription\n-----------\n\nThe PASSWORD() function is used for hashing passwords for use in\nauthentication by the MariaDB server. It is not intended for use in other\napplications.\n\nCalculates and returns a hashed password string from the plaintext password\nstr. Returns an empty string (>= MariaDB 10.0.4) if the argument was NULL.\n\nThe return value is a nonbinary string in the connection character set and\ncollation, determined by the values of the character_set_connection and\ncollation_connection system variables.\n\nThis is the function that is used for hashing MariaDB passwords for storage in\nthe Password column of the user table (see privileges), usually used with the\nSET PASSWORD statement. It is not intended for use in other applications.\n\nUntil MariaDB 10.3, the return value is 41-bytes in length, and the first\ncharacter is always \'*\'. From MariaDB 10.4, the function takes into account\nthe authentication plugin where applicable (A CREATE USER or SET PASSWORD\nstatement). For example, when used in conjunction with a user authenticated by\nthe ed25519 plugin, the statement will create a longer hash:\n\nCREATE USER edtest@localhost IDENTIFIED VIA ed25519 USING PASSWORD(\'secret\');\n\nCREATE USER edtest2@localhost IDENTIFIED BY \'secret\';\n\nSELECT CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) FROM\nmysql.global_priv\n WHERE user LIKE \'edtest%\'\\G\n*************************** 1. row ***************************\nCONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)): edtest@localhost => {\n...\n  \"plugin\": \"ed25519\",\n  \"authentication_string\": \"ZIgUREUg5PVgQ6LskhXmO+eZLS0nC8be6HPjYWR4YJY\",\n...\n}\n*************************** 2. row ***************************\nCONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)): edtest2@localhost => {\n...\n  \"plugin\": \"mysql_native_password\",\n  \"authentication_string\": \"*14E65567ABDB5135D0CFD9A70B3032C179A49EE7\",\n...\n}\n\nThe behavior of this function is affected by the value of the old_passwords\nsystem variable. If this is set to 1 (0 is default), MariaDB reverts to using\nthe mysql_old_password authentication plugin by default for newly created\nusers and passwords.\n\nExamples\n--------\n\nSELECT PASSWORD(\'notagoodpwd\');\n+-------------------------------------------+\n| PASSWORD(\'notagoodpwd\')                   |\n+-------------------------------------------+\n| *3A70EE9FC6594F88CE9E959CD51C5A1C002DC937 |\n+-------------------------------------------+\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nURL: https://mariadb.com/kb/en/password/','','https://mariadb.com/kb/en/password/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (137,12,'RANDOM_BYTES','MariaDB starting with 10.10.0\n-----------------------------\nThe RANDOM_BYTES function generates a binary string of random bytes. It was\nadded in MariaDB 10.10.0.\n\nSyntax\n------\n\nRANDOM_BYTES(length)\n\nDescription\n-----------\n\nGiven a length from 1 to 1024, generates a binary string of length consisting\nof random bytes generated by the SSL library\'s random number generator.\n\nSee the RAND_bytes() function documentation of your SSL library for\ninformation on the random number generator. In the case of OpenSSL, a\ncryptographically secure pseudo random generator (CSPRNG) is used.\n\nStatements containing the RANDOM_BYTES function are unsafe for statement-based\nreplication.\n\nAn error occurs if length is outside the range 1 to 1024.\n\nURL: https://mariadb.com/kb/en/random_bytes/','','https://mariadb.com/kb/en/random_bytes/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (138,12,'SHA1','Syntax\n------\n\nSHA1(str), SHA(str)\n\nDescription\n-----------\n\nCalculates an SHA-1 160-bit checksum for the string str, as described in RFC\n3174 (Secure Hash Algorithm).\n\nThe value is returned as a string of 40 hex digits, or NULL if the argument\nwas NULL. As of MariaDB 5.5, the return value is a nonbinary string in the\nconnection character set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system variables. Before\n5.5, the return value was a binary string.\n\nExamples\n--------\n\nSELECT SHA1(\'some boring text\');\n+------------------------------------------+\n| SHA1(\'some boring text\')                 |\n+------------------------------------------+\n| af969fc2085b1bb6d31e517d5c456def5cdd7093 |\n+------------------------------------------+\n\nURL: https://mariadb.com/kb/en/sha1/','','https://mariadb.com/kb/en/sha1/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (139,12,'SHA2','Syntax\n------\n\nSHA2(str,hash_len)\n\nDescription\n-----------\n\nGiven a string str, calculates an SHA-2 checksum, which is considered more\ncryptographically secure than its SHA-1 equivalent. The SHA-2 family includes\nSHA-224, SHA-256, SHA-384, and SHA-512, and the hash_len must correspond to\none of these, i.e. 224, 256, 384 or 512. 0 is equivalent to 256.\n\nThe return value is a nonbinary string in the connection character set and\ncollation, determined by the values of the character_set_connection and\ncollation_connection system variables.\n\nNULL is returned if the hash length is not valid, or the string str is NULL.\n\nSHA2 will only work if MariaDB was has been configured with TLS support.\n\nExamples\n--------\n\nSELECT SHA2(\'Maria\',224);\n+----------------------------------------------------------+\n| SHA2(\'Maria\',224)                                        |\n+----------------------------------------------------------+\n| 6cc67add32286412efcab9d0e1675a43a5c2ef3cec8879f81516ff83 |\n+----------------------------------------------------------+\n\nSELECT SHA2(\'Maria\',256);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',256)                                                |\n+------------------------------------------------------------------+\n| 9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16 |\n+------------------------------------------------------------------+\n\nSELECT SHA2(\'Maria\',0);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',0)                                                  |\n+------------------------------------------------------------------+\n| 9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16 |\n+------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/sha2/','','https://mariadb.com/kb/en/sha2/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (140,13,'ENDPOINT','A synonym for ST_ENDPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-endpoint/','','https://mariadb.com/kb/en/linestring-properties-endpoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (141,13,'GLENGTH','Syntax\n------\n\nGLength(ls)\n\nDescription\n-----------\n\nReturns as a double-precision number the length of the LineString value ls in\nits associated spatial reference.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|           2.82842712474619 |\n+----------------------------+\n\nURL: https://mariadb.com/kb/en/glength/','','https://mariadb.com/kb/en/glength/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (142,13,'NumPoints','A synonym for ST_NumPoints.\n\nURL: https://mariadb.com/kb/en/linestring-properties-numpoints/','','https://mariadb.com/kb/en/linestring-properties-numpoints/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (143,13,'PointN','A synonym for ST_PointN.\n\nURL: https://mariadb.com/kb/en/linestring-properties-pointn/','','https://mariadb.com/kb/en/linestring-properties-pointn/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (144,13,'STARTPOINT','A synonym for ST_STARTPOINT.\n\nURL: https://mariadb.com/kb/en/linestring-properties-startpoint/','','https://mariadb.com/kb/en/linestring-properties-startpoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (145,13,'ST_ENDPOINT','Syntax\n------\n\nST_EndPoint(ls)\nEndPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nST_EndPoint() and EndPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_endpoint/','','https://mariadb.com/kb/en/st_endpoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (146,13,'ST_NUMPOINTS','Syntax\n------\n\nST_NumPoints(ls)\nNumPoints(ls)\n\nDescription\n-----------\n\nReturns the number of Point objects in the LineString value ls.\n\nST_NumPoints() and NumPoints() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n\nURL: https://mariadb.com/kb/en/st_numpoints/','','https://mariadb.com/kb/en/st_numpoints/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (147,13,'ST_POINTN','Syntax\n------\n\nST_PointN(ls,N)\nPointN(ls,N)\n\nDescription\n-----------\n\nReturns the N-th Point in the LineString value ls. Points are numbered\nbeginning with 1.\n\nST_PointN() and PointN() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_pointn/','','https://mariadb.com/kb/en/st_pointn/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (148,13,'ST_STARTPOINT','Syntax\n------\n\nST_StartPoint(ls)\nStartPoint(ls)\n\nDescription\n-----------\n\nReturns the Point that is the start point of the LineString value ls.\n\nST_StartPoint() and StartPoint() are synonyms.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_startpoint/','','https://mariadb.com/kb/en/st_startpoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (149,14,'GET_LOCK','Syntax\n------\n\nGET_LOCK(str,timeout)\n\nDescription\n-----------\n\nTries to obtain a lock with a name given by the string str, using a timeout of\ntimeout seconds. Returns 1 if the lock was obtained successfully, 0 if the\nattempt timed out (for example, because another client has previously locked\nthe name), or NULL if an error occurred (such as running out of memory or the\nthread was killed with mariadb-admin kill).\n\nA lock is released with RELEASE_LOCK(), when the connection terminates (either\nnormally or abnormally). A connection can hold multiple locks at the same\ntime, so a lock that is no longer needed needs to be explicitly released.\n\nThe IS_FREE_LOCK function returns whether a specified lock a free or not, and\nthe IS_USED_LOCK whether the function is in use or not.\n\nLocks obtained with GET_LOCK() do not interact with transactions. That is,\ncommitting a transaction does not release any such locks obtained during the\ntransaction.\n\nIt is also possible to recursively set the same lock. If a lock with the same\nname is set n times, it needs to be released n times as well.\n\nstr is case insensitive for GET_LOCK() and related functions. If str is an\nempty string or NULL, GET_LOCK() returns NULL and does nothing. timeout\nsupports microseconds.\n\nIf the metadata_lock_info plugin is installed, locks acquired with this\nfunction are visible in the Information Schema METADATA_LOCK_INFO table.\n\nThis function can be used to implement application locks or to simulate record\nlocks. Names are locked on a server-wide basis. If a name has been locked by\none client, GET_LOCK() blocks any request by another client for a lock with\nthe same name. This allows clients that agree on a given lock name to use the\nname to perform cooperative advisory locking. But be aware that it also allows\na client that is not among the set of cooperating clients to lock a name,\neither inadvertently or deliberately, and thus prevent any of the cooperating\nclients from locking that name. One way to reduce the likelihood of this is to\nuse lock names that are database-specific or application-specific. For\nexample, use lock names of the form db_name.str or app_name.str.\n\nStatements using the GET_LOCK function are not safe for statement-based\nreplication.\n\nThe patch to permit multiple locks was contributed by Konstantin \"Kostja\"\nOsipov (MDEV-3917).\n\nExamples\n--------\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT IS_FREE_LOCK(\'lock1\'), IS_USED_LOCK(\'lock1\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_USED_LOCK(\'lock1\') |\n+-----------------------+-----------------------+\n|                     0 |                    46 |\n+-----------------------+-----------------------+\n\nSELECT IS_FREE_LOCK(\'lock2\'), IS_USED_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock2\') | IS_USED_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     1 |                  NULL |\n+-----------------------+-----------------------+\n\nMultiple locks can be held:\n\nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT IS_FREE_LOCK(\'lock1\'), IS_FREE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_FREE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     0 |                     0 |\n+-----------------------+-----------------------+\n\nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n|                     1 |                     1 |\n+-----------------------+-----------------------+\n\nIt is possible to hold the same lock recursively. This example is viewed using\nthe metadata_lock_info plugin:\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\nEmpty set (0.000 sec)\n\nTimeout example: Connection 1:\n\nSELECT GET_LOCK(\'lock4\',10);\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock4\',10);\n\nAfter 10 seconds...\n\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nDeadlocks are automatically detected and resolved. Connection 1:\n\nSELECT GET_LOCK(\'lock5\',10); \n+----------------------+\n| GET_LOCK(\'lock5\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock6\',10);\n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 1:\n\nSELECT GET_LOCK(\'lock6\',10); \n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n|                    0 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock5\',10);\nERROR 1213 (40001): Deadlock found when trying to get lock; try restarting\ntransaction\n\nURL: https://mariadb.com/kb/en/get_lock/','','https://mariadb.com/kb/en/get_lock/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (150,14,'INET6_ATON','Syntax\n------\n\nINET6_ATON(expr)\n\nDescription\n-----------\n\nGiven an IPv6 or IPv4 network address as a string, returns a binary string\nthat represents the numeric value of the address.\n\nNo trailing zone ID\'s or traling network masks are permitted. For IPv4\naddresses, or IPv6 addresses with IPv4 address parts, no classful addresses or\ntrailing port numbers are permitted and octal numbers are not supported.\n\nThe returned binary string will be VARBINARY(16) or VARBINARY(4) for IPv6 and\nIPv4 addresses respectively.\n\nReturns NULL if the argument is not understood.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, INET6_ATON can take INET6 as an argument.\n\nExamples\n--------\n\nSELECT HEX(INET6_ATON(\'10.0.1.1\'));\n+-----------------------------+\n| HEX(INET6_ATON(\'10.0.1.1\')) |\n+-----------------------------+\n| 0A000101                    |\n+-----------------------------+\n\nSELECT HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\'));\n+----------------------------------------------+\n| HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\')) |\n+----------------------------------------------+\n| 48F3000000000000D4321431BA23846F             |\n+----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/inet6_aton/','','https://mariadb.com/kb/en/inet6_aton/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (151,14,'INET6_NTOA','Syntax\n------\n\nINET6_NTOA(expr)\n\nDescription\n-----------\n\nGiven an IPv6 or IPv4 network address as a numeric binary string, returns the\naddress as a nonbinary string in the connection character set.\n\nThe return string is lowercase, and is platform independent, since it does not\nuse functions specific to the operating system. It has a maximum length of 39\ncharacters.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET6_NTOA(UNHEX(\'0A000101\'));\n+-------------------------------+\n| INET6_NTOA(UNHEX(\'0A000101\')) |\n+-------------------------------+\n| 10.0.1.1                      |\n+-------------------------------+\n\nSELECT INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\'));\n+-------------------------------------------------------+\n| INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\')) |\n+-------------------------------------------------------+\n| 48f3::d432:1431:ba23:846f                             |\n+-------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/inet6_ntoa/','','https://mariadb.com/kb/en/inet6_ntoa/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (152,14,'INET_ATON','Syntax\n------\n\nINET_ATON(expr)\n\nDescription\n-----------\n\nGiven the dotted-quad representation of an IPv4 network address as a string,\nreturns an integer that represents the numeric value of the address. Addresses\nmay be 4- or 8-byte addresses.\n\nReturns NULL if the argument is not understood.\n\nExamples\n--------\n\nSELECT INET_ATON(\'192.168.1.1\');\n+--------------------------+\n| INET_ATON(\'192.168.1.1\') |\n+--------------------------+\n|               3232235777 |\n+--------------------------+\n\nThis is calculated as follows: 192 x 2563 + 168 x 256 2 + 1 x 256 + 1\n\nURL: https://mariadb.com/kb/en/inet_aton/','','https://mariadb.com/kb/en/inet_aton/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (153,14,'INET_NTOA','Syntax\n------\n\nINET_NTOA(expr)\n\nDescription\n-----------\n\nGiven a numeric IPv4 network address in network byte order (4 or 8 byte),\nreturns the dotted-quad representation of the address as a string.\n\nExamples\n--------\n\nSELECT INET_NTOA(3232235777);\n+-----------------------+\n| INET_NTOA(3232235777) |\n+-----------------------+\n| 192.168.1.1           |\n+-----------------------+\n\n192.168.1.1 corresponds to 3232235777 since 192 x 2563 + 168 x 256 2 + 1 x 256\n+ 1 = 3232235777\n\nURL: https://mariadb.com/kb/en/inet_ntoa/','','https://mariadb.com/kb/en/inet_ntoa/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (154,14,'IS_FREE_LOCK','Syntax\n------\n\nIS_FREE_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock is in\nuse, and NULL if an error occurs (such as an incorrect argument, like an empty\nstring or NULL). str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_FREE_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_free_lock/','','https://mariadb.com/kb/en/is_free_lock/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (155,14,'IS_IPV4','Syntax\n------\n\nIS_IPV4(expr)\n\nDescription\n-----------\n\nIf the expression is a valid IPv4 address, returns 1, otherwise returns 0.\n\nIS_IPV4() is stricter than INET_ATON(), but as strict as INET6_ATON(), in\ndetermining the validity of an IPv4 address. This implies that if IS_IPV4\nreturns 1, the same expression will always return a non-NULL result when\npassed to INET_ATON(), but that the reverse may not apply.\n\nExamples\n--------\n\nSELECT IS_IPV4(\'1110.0.1.1\');\n+-----------------------+\n| IS_IPV4(\'1110.0.1.1\') |\n+-----------------------+\n|                     0 |\n+-----------------------+\n\nSELECT IS_IPV4(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV4(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    0 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4/','','https://mariadb.com/kb/en/is_ipv4/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (156,14,'IS_IPV4_COMPAT','Syntax\n------\n\nIS_IPV4_COMPAT(expr)\n\nDescription\n-----------\n\nReturns 1 if a given numeric binary string IPv6 address, such as returned by\nINET6_ATON(), is IPv4-compatible, otherwise returns 0.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, when the argument is not INET6, automatic implicit CAST\nto INET6 is applied. As a consequence, IS_IPV4_COMPAT now understands\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, the function understood only binary(16) representation.\n\nExamples\n--------\n\nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n|                                        1 |\n+------------------------------------------+\n\nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\'));\n+-----------------------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\')) |\n+-----------------------------------------------------------+\n|                                                         0 |\n+-----------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4_compat/','','https://mariadb.com/kb/en/is_ipv4_compat/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (157,14,'IS_IPV4_MAPPED','Syntax\n------\n\nIS_IPV4_MAPPED(expr)\n\nDescription\n-----------\n\nReturns 1 if a given a numeric binary string IPv6 address, such as returned by\nINET6_ATON(), is a valid IPv4-mapped address, otherwise returns 0.\n\nMariaDB starting with 10.5.0\n----------------------------\nFrom MariaDB 10.5.0, when the argument is not INET6, automatic implicit CAST\nto INET6 is applied. As a consequence, IS_IPV4_MAPPED now understands\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, the function understood only binary(16) representation.\n\nExamples\n--------\n\nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n|                                        0 |\n+------------------------------------------+\n\nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\'));\n+-----------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\')) |\n+-----------------------------------------------+\n|                                             1 |\n+-----------------------------------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv4_mapped/','','https://mariadb.com/kb/en/is_ipv4_mapped/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (158,14,'IS_IPV6','Syntax\n------\n\nIS_IPV6(expr)\n\nDescription\n-----------\n\nReturns 1 if the expression is a valid IPv6 address specified as a string,\notherwise returns 0. Does not consider IPv4 addresses to be valid IPv6\naddresses.\n\nExamples\n--------\n\nSELECT IS_IPV6(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV6(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n|                                    1 |\n+--------------------------------------+\n1 row in set (0.02 sec)\n\nSELECT IS_IPV6(\'10.0.1.1\');\n+---------------------+\n| IS_IPV6(\'10.0.1.1\') |\n+---------------------+\n|                   0 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/is_ipv6/','','https://mariadb.com/kb/en/is_ipv6/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (159,14,'IS_USED_LOCK','Syntax\n------\n\nIS_USED_LOCK(str)\n\nDescription\n-----------\n\nChecks whether the lock named str is in use (that is, locked). If so, it\nreturns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL. str is case insensitive.\n\nIf the metadata_lock_info plugin is installed, the Information Schema\nmetadata_lock_info table contains information about locks of this kind (as\nwell as metadata locks).\n\nStatements using the IS_USED_LOCK function are not safe for statement-based\nreplication.\n\nURL: https://mariadb.com/kb/en/is_used_lock/','','https://mariadb.com/kb/en/is_used_lock/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (160,14,'MASTER_GTID_WAIT','Syntax\n------\n\nMASTER_GTID_WAIT(gtid-list[, timeout)\n\nDescription\n-----------\n\nThis function takes a string containing a comma-separated list of global\ntransaction id\'s (similar to the value of, for example, gtid_binlog_pos). It\nwaits until the value of gtid_slave_pos has the same or higher seq_no within\nall replication domains specified in the gtid-list; in other words, it waits\nuntil the slave has reached the specified GTID position.\n\nAn optional second argument gives a timeout in seconds. If the timeout expires\nbefore the specified GTID position is reached, then the function returns -1.\nPassing NULL or a negative number for the timeout means no timeout, and the\nfunction will wait indefinitely.\n\nIf the wait completes without a timeout, 0 is returned. Passing NULL for the\ngtid-list makes the function return NULL immediately, without waiting.\n\nThe gtid-list may be the empty string, in which case MASTER_GTID_WAIT()\nreturns immediately. If the gtid-list contains fewer domains than\ngtid_slave_pos, then only those domains are waited upon. If gtid-list contains\na domain that is not present in @@gtid_slave_pos, then MASTER_GTID_WAIT() will\nwait until an event containing such domain_id arrives on the slave (or until\ntimed out or killed).\n\nMASTER_GTID_WAIT() can be useful to ensure that a slave has caught up to a\nmaster. Simply take the value of gtid_binlog_pos on the master, and use it in\na MASTER_GTID_WAIT() call on the slave; when the call completes, the slave\nwill have caught up with that master position.\n\nMASTER_GTID_WAIT() can also be used in client applications together with the\nlast_gtid session variable. This is useful in a read-scaleout replication\nsetup, where the application writes to a single master but divides the reads\nout to a number of slaves to distribute the load. In such a setup, there is a\nrisk that an application could first do an update on the master, and then a\nbit later do a read on a slave, and if the slave is not fast enough, the data\nread from the slave might not include the update just made, possibly confusing\nthe application and/or the end-user. One way to avoid this is to request the\nvalue of last_gtid on the master just after the update. Then before doing the\nread on the slave, do a MASTER_GTID_WAIT() on the value obtained from the\nmaster; this will ensure that the read is not performed until the slave has\nreplicated sufficiently far for the update to have become visible.\n\nNote that MASTER_GTID_WAIT() can be used even if the slave is configured not\nto use GTID for connections (CHANGE MASTER TO master_use_gtid=no). This is\nbecause from MariaDB 10, GTIDs are always logged on the master server, and\nalways recorded on the slave servers.\n\nDifferences to MASTER_POS_WAIT()\n--------------------------------\n\n* MASTER_GTID_WAIT() is global; it waits for any master connection to reach\n the specified GTID position. MASTER_POS_WAIT() works only against a\n specific connection. This also means that while MASTER_POS_WAIT() aborts if\n its master connection is terminated with STOP SLAVE or due to an error,\n MASTER_GTID_WAIT() continues to wait while slaves are stopped.\n\n* MASTER_GTID_WAIT() can take its timeout as a floating-point value, so a\n timeout in fractional seconds is supported, eg. MASTER_GTID_WAIT(\"0-1-100\",\n 0.5). (The minimum wait is one microsecond, 0.000001 seconds).\n\n* MASTER_GTID_WAIT() allows one to specify a timeout of zero in order to do a\n non-blocking check to see if the slaves have progressed to a specific GTID\nposition\n (MASTER_POS_WAIT() takes a zero timeout as meaning an infinite wait). To do\n an infinite MASTER_GTID_WAIT(), specify a negative timeout, or omit the\n timeout argument.\n\n* MASTER_GTID_WAIT() does not return the number of events executed since the\n wait started, nor does it return NULL if a slave thread is stopped. It\n always returns either 0 for successful wait completed, or -1 for timeout\n reached (or NULL if the specified gtid-pos is NULL).\n\nSince MASTER_GTID_WAIT() looks only at the seq_no part of the GTIDs, not the\nserver_id, care is needed if a slave becomes diverged from another server so\nthat two different GTIDs with the same seq_no (in the same domain) arrive at\nthe same server. This situation is in any case best avoided; setting\ngtid_strict_mode is recommended, as this will prevent any such out-of-order\nsequence numbers from ever being replicated on a slave.\n\nURL: https://mariadb.com/kb/en/master_gtid_wait/','','https://mariadb.com/kb/en/master_gtid_wait/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (161,14,'MASTER_POS_WAIT','Syntax\n------\n\nMASTER_POS_WAIT(log_name,log_pos[,timeout,[\"connection_name\"]])\n\nDescription\n-----------\n\nThis function is useful in replication for controlling primary/replica\nsynchronization. It blocks until the replica has read and applied all updates\nup to the specified position (log_name,log_pos) in the primary log. The return\nvalue is the number of log events the replica had to wait for to advance to\nthe specified position. The function returns NULL if the replica SQL thread is\nnot started, the replica\'s primary information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the timeout has\nbeen exceeded. If the replica SQL thread stops while MASTER_POS_WAIT() is\nwaiting, the function returns NULL. If the replica is past the specified\nposition, the function returns immediately.\n\nIf a timeout value is specified, MASTER_POS_WAIT() stops waiting when timeout\nseconds have elapsed. timeout must be greater than 0; a zero or negative\ntimeout means no timeout.\n\nThe connection_name is used when you are using multi-source-replication. If\nyou don\'t specify it, it\'s set to the value of the default_master_connection\nsystem variable.\n\nStatements using the MASTER_POS_WAIT() function are not safe for replication.\n\nURL: https://mariadb.com/kb/en/master_pos_wait/','','https://mariadb.com/kb/en/master_pos_wait/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (162,14,'NAME_CONST','Syntax\n------\n\nNAME_CONST(name,value)\n\nDescription\n-----------\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments should be\nconstants.\n\nThis function is used internally when replicating stored procedures. It makes\nlittle sense to use it explicitly in SQL statements, and it was not supposed\nto be used like that.\n\nSELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: https://mariadb.com/kb/en/name_const/','','https://mariadb.com/kb/en/name_const/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (163,14,'RELEASE_ALL_LOCKS','MariaDB until 10.5.2\n--------------------\nRELEASE_ALL_LOCKS was added in MariaDB 10.5.2.\n\nSyntax\n------\n\nRELEASE_ALL_LOCKS()\n\nDescription\n-----------\n\nReleases all named locks held by the current session. Returns the number of\nlocks released, or 0 if none were held.\n\nStatements using the RELEASE_ALL_LOCKS function are not safe for\nstatement-based replication.\n\nExamples\n--------\n\nSELECT RELEASE_ALL_LOCKS();\n+---------------------+\n| RELEASE_ALL_LOCKS() | \n+---------------------+\n|                   0 |\n+---------------------+\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT RELEASE_ALL_LOCKS();\n+---------------------+\n| RELEASE_ALL_LOCKS() | \n+---------------------+\n|                   1 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/release_all_locks/','','https://mariadb.com/kb/en/release_all_locks/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (164,14,'RELEASE_LOCK','Syntax\n------\n\nRELEASE_LOCK(str)\n\nDescription\n-----------\n\nReleases the lock named by the string str that was obtained with GET_LOCK().\nReturns 1 if the lock was released, 0 if the lock was not established by this\nthread (in which case the lock is not released), and NULL if the named lock\ndid not exist. The lock does not exist if it was never obtained by a call to\nGET_LOCK() or if it has previously been released.\n\nstr is case insensitive. If str is an empty string or NULL, RELEASE_LOCK()\nreturns NULL and does nothing.\n\nStatements using the RELEASE_LOCK() function are not safe for replication.\n\nThe DO statement is convenient to use with RELEASE_LOCK().\n\nExamples\n--------\n\nConnection1:\n\nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 2:\n\nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nConnection 1:\n\nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\'), RELEASE_LOCK(\'lock3\');\n+-----------------------+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') | RELEASE_LOCK(\'lock3\') |\n+-----------------------+-----------------------+-----------------------+\n|                     1 |                     0 |                  NULL |\n+-----------------------+-----------------------+-----------------------+\n\nFrom MariaDB 10.0.2, it is possible to hold the same lock recursively. This\nexample is viewed using the metadata_lock_info plugin:\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n| THREAD_ID | LOCK_MODE           | LOCK_DURATION | LOCK_TYPE | TABLE_SCHEMA |\nTABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n|        46 | MDL_SHARED_NO_WRITE | NULL          | User lock | lock3        |\n     |\n+-----------+---------------------+---------------+-----------+--------------+-\n----------+\n\nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\nEmpty set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/release_lock/','','https://mariadb.com/kb/en/release_lock/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (165,14,'SLEEP','Syntax\n------\n\nSLEEP(duration)\n\nDescription\n-----------\n\nSleeps (pauses) for the number of seconds given by the duration argument, then\nreturns 0. If SLEEP() is interrupted, it returns 1. The duration may have a\nfractional part given in microseconds.\n\nStatements using the SLEEP() function are not safe for replication.\n\nExample\n-------\n\nSELECT SLEEP(5.5);\n+------------+\n| SLEEP(5.5) |\n+------------+\n|          0 |\n+------------+\n1 row in set (5.50 sec)\n\nURL: https://mariadb.com/kb/en/sleep/','','https://mariadb.com/kb/en/sleep/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (166,14,'SYS_GUID','MariaDB starting with 10.6.1\n----------------------------\nThe SYS_GUID function was introduced in MariaDB 10.6.1 to enhance Oracle\ncompatibility. Similar functionality can be achieved with the UUID function.\n\nSyntax\n------\n\nSYS_GUID()\n\nDescription\n-----------\n\nReturns a 16-byte globally unique identifier (GUID), similar to the UUID\nfunction, but without the - character.\n\nExample\n-------\n\nSELECT SYS_GUID();\n+----------------------------------+\n| SYS_GUID()                       |\n+----------------------------------+\n| 2C574E45BA2811EBB265F859713E4BE4 |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/sys_guid/','','https://mariadb.com/kb/en/sys_guid/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (167,14,'UUID','Syntax\n------\n\nUUID()\n\nDescription\n-----------\n\nReturns a Universally Unique Identifier (UUID).\n\nA UUID is designed as a number that is globally unique in space and time. Two\ncalls to UUID() are expected to generate two different values, even if these\ncalls are performed on two separate computers that are not connected to each\nother.\n\nUUID() results are intended to be unique, but cannot always be relied upon to\nunpredictable and unguessable, so should not be relied upon for these purposes.\n\nA UUID is a 128-bit number represented by a utf8 string of five hexadecimal\nnumbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee format:\n\n* The first three numbers are generated from a timestamp.\n* The fourth number preserves temporal uniqueness in case the timestamp value\n loses monotonicity (for example, due to daylight saving time).\n* The fifth number is an IEEE 802 node number that provides spatial uniqueness.\n A random number is substituted if the latter is not available (for example,\n because the host computer has no Ethernet card, or we do not know how to find\n the hardware address of an interface on your operating system). In this case,\n spatial uniqueness cannot be guaranteed. Nevertheless, a collision should\n have very low probability.\n\nCurrently, the MAC address of an interface is taken into account only on\nFreeBSD and Linux. On other operating systems, MariaDB uses a randomly\ngenerated 48-bit number.\n\nStatements using the UUID() function are not safe for replication.\n\nThe results are generated according to the \"DCE 1.1:Remote Procedure Call\"\n(Appendix A) CAE (Common Applications Environment) Specifications published by\nThe Open Group in October 1997 (Document Number C706).\n\nExamples\n--------\n\nSELECT UUID();\n+--------------------------------------+\n| UUID()                               |\n+--------------------------------------+\n| cd41294a-afb0-11df-bc9b-00241dd75637 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/uuid/','','https://mariadb.com/kb/en/uuid/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (168,14,'UUID_SHORT','Syntax\n------\n\nUUID_SHORT()\n\nDescription\n-----------\n\nReturns a \"short\" universally unique identifier as a 64-bit unsigned integer\n(rather than a string-form 128-bit identifier as returned by the UUID()\nfunction).\n\nThe value of UUID_SHORT() is guaranteed to be unique if the following\nconditions hold:\n\n* The server_id of the current host is unique among your set of master and\n slave servers\n* server_id is between 0 and 255\n* You don\'t set back your system time for your server between mysqld restarts\n* You do not invoke UUID_SHORT() on average more than 16\n million times per second between mysqld restarts\n\nThe UUID_SHORT() return value is constructed this way:\n\n(server_id & 255) << 56\n+ (server_startup_time_in_seconds << 24)\n+ incremented_variable++;\n\nStatements using the UUID_SHORT() function are not safe for statement-based\nreplication.\n\nExamples\n--------\n\nSELECT UUID_SHORT();\n+-------------------+\n| UUID_SHORT()      |\n+-------------------+\n| 21517162376069120 |\n+-------------------+\n\ncreate table t1 (a bigint unsigned default(uuid_short()) primary key);\ninsert into t1 values(),();\nselect * from t1;\n+-------------------+\n| a                 |\n+-------------------+\n| 98113699159474176 |\n| 98113699159474177 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/uuid_short/','','https://mariadb.com/kb/en/uuid_short/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (169,14,'VALUES / VALUE','Syntax\n------\n\nMariaDB starting with 10.3.3\n----------------------------\n\nVALUE(col_name)\n\nMariaDB until 10.3.2\n--------------------\n\nVALUES(col_name)\n\nDescription\n-----------\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column values from\nthe INSERT portion of the statement. In other words, VALUES(col_name) in the\nUPDATE clause refers to the value of col_name that would be inserted, had no\nduplicate-key conflict occurred. This function is especially useful in\nmultiple-row inserts.\n\nThe VALUES() function is meaningful only in INSERT ... ON DUPLICATE KEY UPDATE\nstatements and returns NULL otherwise.\n\nIn MariaDB 10.3.3 this function was renamed to VALUE(), because it\'s\nincompatible with the standard Table Value Constructors syntax, implemented in\nMariaDB 10.3.3.\n\nThe VALUES() function can still be used even from MariaDB 10.3.3, but only in\nINSERT ... ON DUPLICATE KEY UPDATE statements; it\'s a syntax error otherwise.\n\nExamples\n--------\n\nMariaDB starting with 10.3.3\n----------------------------\n\nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n  ON DUPLICATE KEY UPDATE c=VALUE(a)+VALUE(b);\n\nMariaDB until 10.3.2\n--------------------\n\nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n  ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n\nURL: https://mariadb.com/kb/en/values-value/','','https://mariadb.com/kb/en/values-value/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (170,15,'!','Syntax\n------\n\nNOT, !\n\nDescription\n-----------\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnon-zero, and NOT NULL returns NULL.\n\nBy default, the ! operator has a higher precedence. If the HIGH_NOT_PRECEDENCE\nSQL_MODE flag is set, NOT and ! have the same precedence.\n\nExamples\n--------\n\nSELECT NOT 10;\n+--------+\n| NOT 10 |\n+--------+\n|      0 |\n+--------+\n\nSELECT NOT 0;\n+-------+\n| NOT 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT NOT NULL;\n+----------+\n| NOT NULL |\n+----------+\n|     NULL |\n+----------+\n\nSELECT ! (1+1);\n+---------+\n| ! (1+1) |\n+---------+\n|       0 |\n+---------+\n\nSELECT ! 1+1;\n+-------+\n| ! 1+1 |\n+-------+\n|     1 |\n+-------+\n\nURL: https://mariadb.com/kb/en/not/','','https://mariadb.com/kb/en/not/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (171,15,'&&','Syntax\n------\n\nAND, &&\n\nDescription\n-----------\n\nLogical AND. Evaluates to 1 if all operands are non-zero and not NULL, to 0 if\none or more operands are 0, otherwise NULL is returned.\n\nFor this operator, short-circuit evaluation can be used.\n\nExamples\n--------\n\nSELECT 1 && 1;\n+--------+\n| 1 && 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 && 0;\n+--------+\n| 1 && 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 1 && NULL;\n+-----------+\n| 1 && NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 0 && NULL;\n+-----------+\n| 0 && NULL |\n+-----------+\n|         0 |\n+-----------+\n\nSELECT NULL && 0;\n+-----------+\n| NULL && 0 |\n+-----------+\n|         0 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/and/','','https://mariadb.com/kb/en/and/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (172,15,'XOR','Syntax\n------\n\nXOR\n\nDescription\n-----------\n\nXOR stands for eXclusive OR. Returns NULL if either operand is NULL. For\nnon-NULL operands, evaluates to 1 if an odd number of operands is non-zero,\notherwise 0 is returned.\n\nExamples\n--------\n\nSELECT 1 XOR 1;\n+---------+\n| 1 XOR 1 |\n+---------+\n|       0 |\n+---------+\n\nSELECT 1 XOR 0;\n+---------+\n| 1 XOR 0 |\n+---------+\n|       1 |\n+---------+\n\nSELECT 1 XOR NULL;\n+------------+\n| 1 XOR NULL |\n+------------+\n|       NULL |\n+------------+\n\nIn the following example, the right 1 XOR 1 is evaluated first, and returns 0.\nThen, 1 XOR 0 is evaluated, and 1 is returned.\n\nSELECT 1 XOR 1 XOR 1;\n+---------------+\n| 1 XOR 1 XOR 1 |\n+---------------+\n|             1 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/xor/','','https://mariadb.com/kb/en/xor/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (173,15,'||','Syntax\n------\n\nOR, ||\n\nDescription\n-----------\n\nLogical OR. When both operands are non-NULL, the result is 1 if any operand is\nnon-zero, and 0 otherwise. With a NULL operand, the result is 1 if the other\noperand is non-zero, and NULL otherwise. If both operands are NULL, the result\nis NULL.\n\nFor this operator, short-circuit evaluation can be used.\n\nNote that, if the PIPES_AS_CONCAT SQL_MODE is set, || is used as a string\nconcatenation operator. This means that a || b is the same as CONCAT(a,b). See\nCONCAT() for details.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, || ignores NULL.\n\nExamples\n--------\n\nSELECT 1 || 1;\n+--------+\n| 1 || 1 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 1 || 0;\n+--------+\n| 1 || 0 |\n+--------+\n|      1 |\n+--------+\n\nSELECT 0 || 0;\n+--------+\n| 0 || 0 |\n+--------+\n|      0 |\n+--------+\n\nSELECT 0 || NULL;\n+-----------+\n| 0 || NULL |\n+-----------+\n|      NULL |\n+-----------+\n\nSELECT 1 || NULL;\n+-----------+\n| 1 || NULL |\n+-----------+\n|         1 |\n+-----------+\n\nIn Oracle mode, from MariaDB 10.3:\n\nSELECT 0 || NULL;\n+-----------+\n| 0 || NULL |\n+-----------+\n| 0         |\n+-----------+\n\nURL: https://mariadb.com/kb/en/or/','','https://mariadb.com/kb/en/or/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (174,16,'Stored Aggregate Functions','MariaDB starting with 10.3.3\n----------------------------\nThe ability to create stored aggregate functions was added in MariaDB 10.3.3.\n\nAggregate functions are functions that are computed over a sequence of rows\nand return one result for the sequence of rows.\n\nCreating a custom aggregate function is done using the CREATE FUNCTION\nstatement with two main differences:\n\n* The addition of the AGGREGATE keyword, so CREATE AGGREGATE FUNCTION\n* The FETCH GROUP NEXT ROW instruction inside the loop\n* Oracle PL/SQL compatibility using SQL/PL is provided\n\nStandard Syntax\n---------------\n\nCREATE AGGREGATE FUNCTION function_name (parameters) RETURNS return_type\nBEGIN\n   All types of declarations\n   DECLARE CONTINUE HANDLER FOR NOT FOUND RETURN return_val;\n   LOOP\n     FETCH GROUP NEXT ROW; // fetches next row from table\n     other instructions\n   END LOOP;\nEND\n\nStored aggregate functions were a 2016 Google Summer of Code project by Varun\nGupta.\n\nUsing SQL/PL\n------------\n\nSET sql_mode=Oracle;\nDELIMITER //\n\nCREATE AGGREGATE FUNCTION function_name (parameters) RETURN return_type\n declarations\nBEGIN\n LOOP\n   FETCH GROUP NEXT ROW; -- fetches next row from table\n   -- other instructions\n\nEND LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n   RETURN return_val;\nEND //\n\nDELIMITER ;\n\nExamples\n--------\n\nFirst a simplified example:\n\nCREATE TABLE marks(stud_id INT, grade_count INT);\n\nINSERT INTO marks VALUES (1,6), (2,4), (3,7), (4,5), (5,8);\n\nSELECT * FROM marks;\n+---------+-------------+\n| stud_id | grade_count |\n+---------+-------------+\n|       1 |           6 |\n|       2 |           4 |\n|       3 |           7 |\n|       4 |           5 |\n|       5 |           8 |\n+---------+-------------+\n\nDELIMITER //\nCREATE AGGREGATE FUNCTION IF NOT EXISTS aggregate_count(x INT) RETURNS INT\nBEGIN\n DECLARE count_students INT DEFAULT 0;\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n RETURN count_students;\n   LOOP\n     FETCH GROUP NEXT ROW;\n     IF x  THEN\n      SET count_students = count_students+1;\n     END IF;\n   END LOOP;\nEND //\nDELIMITER ;\n\nA non-trivial example that cannot easily be rewritten using existing functions:\n\nDELIMITER //\nCREATE AGGREGATE FUNCTION medi_int(x INT) RETURNS DOUBLE\nBEGIN\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n  BEGIN\n   DECLARE res DOUBLE;\n   DECLARE cnt INT DEFAULT (SELECT COUNT(*) FROM tt);\n   DECLARE lim INT DEFAULT (cnt-1) DIV 2;\n   IF cnt % 2 = 0 THEN\n    SET res = (SELECT AVG(a) FROM (SELECT a FROM tt ORDER BY a LIMIT\nlim,2) ttt);\n   ELSE\n    SET res = (SELECT a FROM tt ORDER BY a LIMIT lim,1);\n   END IF;\n   DROP TEMPORARY TABLE tt;\n   RETURN res;\n  END;\n CREATE TEMPORARY TABLE tt (a INT);\n LOOP\n  FETCH GROUP NEXT ROW;\n  INSERT INTO tt VALUES (x);\n END LOOP;\nEND //\nDELIMITER ;\n\nSQL/PL Example\n--------------\n\nThis uses the same marks table as created above.\n\nSET sql_mode=Oracle;\nDELIMITER //\n\nCREATE AGGREGATE FUNCTION aggregate_count(x INT) RETURN INT AS count_students\nINT DEFAULT 0;\nBEGIN\n LOOP\n   FETCH GROUP NEXT ROW;\n   IF x  THEN\n    SET count_students := count_students+1;\n   END IF;\n END LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n   RETURN count_students;\nEND aggregate_count //\nDELIMITER ;\n\nSELECT aggregate_count(stud_id) FROM marks;\n\nURL: https://mariadb.com/kb/en/stored-aggregate-functions/','','https://mariadb.com/kb/en/stored-aggregate-functions/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (175,16,'AVG','Syntax\n------\n\nAVG([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the average value of expr. The DISTINCT option can be used to return\nthe average of the distinct values of expr. NULL values are ignored. It is an\naggregate function, and so can be used with the GROUP BY clause.\n\nAVG() returns NULL if there were no matching rows.\n\nAVG() can be used as a window function.\n\nExamples\n--------\n\nCREATE TABLE sales (sales_value INT);\n\nINSERT INTO sales VALUES(10),(20),(20),(40);\n\nSELECT AVG(sales_value) FROM sales;\n+------------------+\n| AVG(sales_value) |\n+------------------+\n|          22.5000 |\n+------------------+\n\nSELECT AVG(DISTINCT(sales_value)) FROM sales;\n+----------------------------+\n| AVG(DISTINCT(sales_value)) |\n+----------------------------+\n|                    23.3333 |\n+----------------------------+\n\nCommonly, AVG() is used with a GROUP BY clause:\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, AVG(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | AVG(score) |\n+---------+------------+\n| Chun    |    74.0000 |\n| Esben   |    37.0000 |\n| Kaolin  |    72.0000 |\n| Tatiana |    85.0000 |\n+---------+------------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,AVG(score) FROM student;\n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL  |         31 |\n+------+------+------------+\n\nAs a window function:\n\nCREATE TABLE student_test (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, test, score, AVG(score) OVER (PARTITION BY test) \n  AS average_by_test FROM student_test;\n+---------+--------+-------+-----------------+\n| name    | test   | score | average_by_test |\n+---------+--------+-------+-----------------+\n| Chun    | SQL    |    75 |         65.2500 |\n| Chun    | Tuning |    73 |         68.7500 |\n| Esben   | SQL    |    43 |         65.2500 |\n| Esben   | Tuning |    31 |         68.7500 |\n| Kaolin  | SQL    |    56 |         65.2500 |\n| Kaolin  | Tuning |    88 |         68.7500 |\n| Tatiana | SQL    |    87 |         65.2500 |\n| Tatiana | Tuning |    83 |         68.7500 |\n+---------+--------+-------+-----------------+\n\nURL: https://mariadb.com/kb/en/avg/','','https://mariadb.com/kb/en/avg/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (176,16,'BIT_AND','Syntax\n------\n\nBIT_AND(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise AND of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_AND will return a value with all bits set to 1. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_AND can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_AND(NULL);\n+----------------------+\n| BIT_AND(NULL)        |\n+----------------------+\n| 18446744073709551615 |\n+----------------------+\n\nURL: https://mariadb.com/kb/en/bit_and/','','https://mariadb.com/kb/en/bit_and/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (177,16,'BIT_OR','Syntax\n------\n\nBIT_OR(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise OR of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_OR will return a value with all bits set to 0. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_OR can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_OR(NULL);\n+--------------+\n| BIT_OR(NULL) |\n+--------------+\n|            0 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/bit_or/','','https://mariadb.com/kb/en/bit_or/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (178,16,'BIT_XOR','Syntax\n------\n\nBIT_XOR(expr) [over_clause]\n\nDescription\n-----------\n\nReturns the bitwise XOR of all bits in expr. The calculation is performed with\n64-bit (BIGINT) precision. It is an aggregate function, and so can be used\nwith the GROUP BY clause.\n\nIf no rows match, BIT_XOR will return a value with all bits set to 0. NULL\nvalues have no effect on the result unless all results are NULL, which is\ntreated as no match.\n\nBIT_XOR can be used as a window function with the addition of the over_clause.\n\nExamples\n--------\n\nCREATE TABLE vals (x INT);\n\nINSERT INTO vals VALUES(111),(110),(100);\n\nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n|        100 |       111 |        101 |\n+------------+-----------+------------+\n\nAs an aggregate function:\n\nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n\nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n\nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a        |        100 |       111 |        101 |\n| b        |          0 |        11 |         10 |\n+----------+------------+-----------+------------+\n\nNo match:\n\nSELECT BIT_XOR(NULL);\n+---------------+\n| BIT_XOR(NULL) |\n+---------------+\n|             0 |\n+---------------+\n\nURL: https://mariadb.com/kb/en/bit_xor/','','https://mariadb.com/kb/en/bit_xor/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (179,16,'COUNT','Syntax\n------\n\nCOUNT(expr)\n\nDescription\n-----------\n\nReturns a count of the number of non-NULL values of expr in the rows retrieved\nby a SELECT statement. The result is a BIGINT value. It is an aggregate\nfunction, and so can be used with the GROUP BY clause.\n\nCOUNT(*) counts the total number of rows in a table.\n\nCOUNT() returns 0 if there were no matching rows.\n\nCOUNT() can be used as a window function.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT COUNT(*) FROM student;\n+----------+\n| COUNT(*) |\n+----------+\n|        8 |\n+----------+\n\nCOUNT(DISTINCT) example:\n\nSELECT COUNT(DISTINCT (name)) FROM student;\n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n|                      4 |\n+------------------------+\n\nAs a window function\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, COUNT(score) OVER (PARTITION BY name) \n  AS tests_written FROM student_test;\n+---------+--------+-------+---------------+\n| name    | test   | score | tests_written |\n+---------+--------+-------+---------------+\n| Chun    | SQL    |    75 |             2 |\n| Chun    | Tuning |    73 |             2 |\n| Esben   | SQL    |    43 |             2 |\n| Esben   | Tuning |    31 |             2 |\n| Kaolin  | SQL    |    56 |             2 |\n| Kaolin  | Tuning |    88 |             2 |\n| Tatiana | SQL    |    87 |             1 |\n+---------+--------+-------+---------------+\n\nURL: https://mariadb.com/kb/en/count/','','https://mariadb.com/kb/en/count/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (180,16,'COUNT DISTINCT','Syntax\n------\n\nCOUNT(DISTINCT expr,[expr...])\n\nDescription\n-----------\n\nReturns a count of the number of different non-NULL values.\n\nCOUNT(DISTINCT) returns 0 if there were no matching rows.\n\nAlthough, from MariaDB 10.2.0, COUNT can be used as a window function, COUNT\nDISTINCT cannot be.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT COUNT(*) FROM student;\n+----------+\n| COUNT(*) |\n+----------+\n|        8 |\n+----------+\n\nSELECT COUNT(DISTINCT (name)) FROM student;\n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n|                      4 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/count-distinct/','','https://mariadb.com/kb/en/count-distinct/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (181,16,'GROUP_CONCAT','Syntax\n------\n\nGROUP_CONCAT(expr)\n\nDescription\n-----------\n\nThis function returns a string result with the concatenated non-NULL values\nfrom a group. It returns NULL if there are no non-NULL values.\n\nThe maximum returned length in bytes is determined by the group_concat_max_len\nserver system variable, which defaults to 1M (>= MariaDB 10.2.4) or 1K (<=\nMariaDB 10.2.3).\n\nIf group_concat_max_len <= 512, the return type is VARBINARY or VARCHAR;\notherwise, the return type is BLOB or TEXT. The choice between binary or\nnon-binary types depends from the input.\n\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n      [ORDER BY {unsigned_integer | col_name | expr}\n        [ASC | DESC] [,col_name ...]]\n      [SEPARATOR str_val]\n      [LIMIT {[offset,] row_count | row_count OFFSET offset}])\n\nDISTINCT eliminates duplicate values from the output string.\n\nORDER BY determines the order of returned values.\n\nSEPARATOR specifies a separator between the values. The default separator is a\ncomma (,). It is possible to avoid using a separator by specifying an empty\nstring.\n\nLIMIT\n-----\n\nMariaDB starting with 10.3.3\n----------------------------\nUntil MariaDB 10.3.2, it was not possible to use the LIMIT clause with\nGROUP_CONCAT. This restriction was lifted in MariaDB 10.3.3.\n\nExamples\n--------\n\nSELECT student_name,\n   GROUP_CONCAT(test_score)\n   FROM student\n   GROUP BY student_name;\n\nGet a readable list of MariaDB users from the mysql.user table:\n\nSELECT GROUP_CONCAT(DISTINCT User ORDER BY User SEPARATOR \'\\n\')\n FROM mysql.user;\n\nIn the former example, DISTINCT is used because the same user may occur more\nthan once. The new line (\\n) used as a SEPARATOR makes the results easier to\nread.\n\nGet a readable list of hosts from which each user can connect:\n\nSELECT User, GROUP_CONCAT(Host ORDER BY Host SEPARATOR \', \') \n FROM mysql.user GROUP BY User ORDER BY User;\n\nThe former example shows the difference between the GROUP_CONCAT\'s ORDER BY\n(which sorts the concatenated hosts), and the SELECT\'s ORDER BY (which sorts\nthe rows).\n\nFrom MariaDB 10.3.3, LIMIT can be used with GROUP_CONCAT, so, for example,\ngiven the following table:\n\nCREATE TABLE d (dd DATE, cc INT);\n\nINSERT INTO d VALUES (\'2017-01-01\',1);\nINSERT INTO d VALUES (\'2017-01-02\',2);\nINSERT INTO d VALUES (\'2017-01-04\',3);\n\nthe following query:\n\nSELECT SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc\nDESC),\",\",1) FROM d;\n+----------------------------------------------------------------------------+\n| SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC),\",\",1) |\n+----------------------------------------------------------------------------+\n| 2017-01-04:3                                                               |\n+----------------------------------------------------------------------------+\n\ncan be more simply rewritten as:\n\nSELECT GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT 1) FROM d;\n+-------------------------------------------------------------+\n| GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT 1) |\n+-------------------------------------------------------------+\n| 2017-01-04:3                                                |\n+-------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/group_concat/','','https://mariadb.com/kb/en/group_concat/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (182,16,'MAX','Syntax\n------\n\nMAX([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the largest, or maximum, value of expr. MAX() can also take a string\nargument in which case it returns the maximum string value. The DISTINCT\nkeyword can be used to find the maximum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nNote that SET and ENUM fields are currently compared by their string value\nrather than their relative position in the set, so MAX() may produce a\ndifferent highest result than ORDER BY DESC.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nMAX() can be used as a window function.\n\nMAX() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, MAX(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | MAX(score) |\n+---------+------------+\n| Chun    |         75 |\n| Esben   |         43 |\n| Kaolin  |         88 |\n| Tatiana |         87 |\n+---------+------------+\n\nMAX string:\n\nSELECT MAX(name) FROM student;\n+-----------+\n| MAX(name) |\n+-----------+\n| Tatiana   |\n+-----------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,MAX(SCORE) FROM student;\n+------+------+------------+\n| name | test | MAX(SCORE) |\n+------+------+------------+\n| Chun | SQL  |         88 |\n+------+------+------------+\n\nDifference between ORDER BY DESC and MAX():\n\nCREATE TABLE student2(name CHAR(10),grade ENUM(\'b\',\'c\',\'a\'));\n\nINSERT INTO student2 VALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n\nSELECT MAX(grade) FROM student2;\n+------------+\n| MAX(grade) |\n+------------+\n| c          |\n+------------+\n\nSELECT grade FROM student2 ORDER BY grade DESC LIMIT 1;\n+-------+\n| grade |\n+-------+\n| a     |\n+-------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, MAX(score) \n OVER (PARTITION BY name) AS highest_score FROM student_test;\n+---------+--------+-------+---------------+\n| name    | test   | score | highest_score |\n+---------+--------+-------+---------------+\n| Chun    | SQL    |    75 |            75 |\n| Chun    | Tuning |    73 |            75 |\n| Esben   | SQL    |    43 |            43 |\n| Esben   | Tuning |    31 |            43 |\n| Kaolin  | SQL    |    56 |            88 |\n| Kaolin  | Tuning |    88 |            88 |\n| Tatiana | SQL    |    87 |            87 |\n+---------+--------+-------+---------------+\n\nURL: https://mariadb.com/kb/en/max/','','https://mariadb.com/kb/en/max/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (183,16,'MIN','Syntax\n------\n\nMIN([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the minimum value of expr. MIN() may take a string argument, in which\ncase it returns the minimum string value. The DISTINCT keyword can be used to\nfind the minimum of the distinct values of expr, however, this produces the\nsame result as omitting DISTINCT.\n\nNote that SET and ENUM fields are currently compared by their string value\nrather than their relative position in the set, so MIN() may produce a\ndifferent lowest result than ORDER BY ASC.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nMIN() can be used as a window function.\n\nMIN() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nSELECT name, MIN(score) FROM student GROUP BY name;\n+---------+------------+\n| name    | MIN(score) |\n+---------+------------+\n| Chun    |         73 |\n| Esben   |         31 |\n| Kaolin  |         56 |\n| Tatiana |         83 |\n+---------+------------+\n\nMIN() with a string:\n\nSELECT MIN(name) FROM student;\n+-----------+\n| MIN(name) |\n+-----------+\n| Chun      |\n+-----------+\n\nBe careful to avoid this common mistake, not grouping correctly and returning\nmismatched data:\n\nSELECT name,test,MIN(score) FROM student;\n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL  |         31 |\n+------+------+------------+\n\nDifference between ORDER BY ASC and MIN():\n\nCREATE TABLE student2(name CHAR(10),grade ENUM(\'b\',\'c\',\'a\'));\n\nINSERT INTO student2 VALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n\nSELECT MIN(grade) FROM student2;\n+------------+\n| MIN(grade) |\n+------------+\n| a          |\n+------------+\n\nSELECT grade FROM student2 ORDER BY grade ASC LIMIT 1;\n+-------+\n| grade |\n+-------+\n| b     |\n+-------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, MIN(score) \n OVER (PARTITION BY name) AS lowest_score FROM student_test;\n+---------+--------+-------+--------------+\n| name    | test   | score | lowest_score |\n+---------+--------+-------+--------------+\n| Chun    | SQL    |    75 |           73 |\n| Chun    | Tuning |    73 |           73 |\n| Esben   | SQL    |    43 |           31 |\n| Esben   | Tuning |    31 |           31 |\n| Kaolin  | SQL    |    56 |           56 |\n| Kaolin  | Tuning |    88 |           56 |\n| Tatiana | SQL    |    87 |           87 |\n+---------+--------+-------+--------------+\n\nURL: https://mariadb.com/kb/en/min/','','https://mariadb.com/kb/en/min/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (184,16,'STD','Syntax\n------\n\nSTD(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr. This is an extension to\nstandard SQL. The standard SQL function STDDEV_POP() can be used instead.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTD() can be used as a window function.\n\nThis function returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/std/','','https://mariadb.com/kb/en/std/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (185,16,'STDDEV','Syntax\n------\n\nSTDDEV(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr. This function is provided\nfor compatibility with Oracle. The standard SQL function STDDEV_POP() can be\nused instead.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV() can be used as a window function.\n\nThis function returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/stddev/','','https://mariadb.com/kb/en/stddev/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (186,16,'STDDEV_POP','Syntax\n------\n\nSTDDEV_POP(expr)\n\nDescription\n-----------\n\nReturns the population standard deviation of expr (the square root of\nVAR_POP()). You can also use STD() or STDDEV(), which are equivalent but not\nstandard SQL.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV_POP() can be used as a window function.\n\nSTDDEV_POP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM student_test;\n+---------+--------+-------+----------------+\n| name    | test   | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun    | SQL    |    75 |        16.9466 |\n| Chun    | Tuning |    73 |        24.1247 |\n| Esben   | SQL    |    43 |        16.9466 |\n| Esben   | Tuning |    31 |        24.1247 |\n| Kaolin  | SQL    |    56 |        16.9466 |\n| Kaolin  | Tuning |    88 |        24.1247 |\n| Tatiana | SQL    |    87 |        16.9466 |\n+---------+--------+-------+----------------+\n\nURL: https://mariadb.com/kb/en/stddev_pop/','','https://mariadb.com/kb/en/stddev_pop/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (187,16,'STDDEV_SAMP','Syntax\n------\n\nSTDDEV_SAMP(expr)\n\nDescription\n-----------\n\nReturns the sample standard deviation of expr (the square root of VAR_SAMP()).\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nSTDDEV_SAMP() can be used as a window function.\n\nSTDDEV_SAMP() returns NULL if there were no matching rows.\n\nURL: https://mariadb.com/kb/en/stddev_samp/','','https://mariadb.com/kb/en/stddev_samp/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (188,16,'SUM','Syntax\n------\n\nSUM([DISTINCT] expr)\n\nDescription\n-----------\n\nReturns the sum of expr. If the return set has no rows, SUM() returns NULL.\nThe DISTINCT keyword can be used to sum only the distinct values of expr.\n\nSUM() can be used as a window function, although not with the DISTINCT\nspecifier.\n\nExamples\n--------\n\nCREATE TABLE sales (sales_value INT);\nINSERT INTO sales VALUES(10),(20),(20),(40);\n\nSELECT SUM(sales_value) FROM sales;\n+------------------+\n| SUM(sales_value) |\n+------------------+\n|               90 |\n+------------------+\n\nSELECT SUM(DISTINCT(sales_value)) FROM sales;\n+----------------------------+\n| SUM(DISTINCT(sales_value)) |\n+----------------------------+\n|                         70 |\n+----------------------------+\n\nCommonly, SUM is used with a GROUP BY clause:\n\nCREATE TABLE sales (name CHAR(10), month CHAR(10), units INT);\n\nINSERT INTO sales VALUES \n (\'Chun\', \'Jan\', 75), (\'Chun\', \'Feb\', 73),\n (\'Esben\', \'Jan\', 43), (\'Esben\', \'Feb\', 31),\n (\'Kaolin\', \'Jan\', 56), (\'Kaolin\', \'Feb\', 88),\n (\'Tatiana\', \'Jan\', 87), (\'Tatiana\', \'Feb\', 83);\n\nSELECT name, SUM(units) FROM sales GROUP BY name;\n+---------+------------+\n| name    | SUM(units) |\n+---------+------------+\n| Chun    |        148 |\n| Esben   |         74 |\n| Kaolin  |        144 |\n| Tatiana |        170 |\n+---------+------------+\n\nThe GROUP BY clause is required when using an aggregate function along with\nregular column data, otherwise the result will be a mismatch, as in the\nfollowing common type of mistake:\n\nSELECT name,SUM(units) FROM sales\n;+------+------------+\n| name | SUM(units) |\n+------+------------+\n| Chun |        536 |\n+------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, SUM(score) OVER (PARTITION BY name) AS total_score\nFROM student_test;\n+---------+--------+-------+-------------+\n| name    | test   | score | total_score |\n+---------+--------+-------+-------------+\n| Chun    | SQL    |    75 |         148 |\n| Chun    | Tuning |    73 |         148 |\n| Esben   | SQL    |    43 |          74 |\n| Esben   | Tuning |    31 |          74 |\n| Kaolin  | SQL    |    56 |         144 |\n| Kaolin  | Tuning |    88 |         144 |\n| Tatiana | SQL    |    87 |          87 |\n+---------+--------+-------+-------------+\n\nURL: https://mariadb.com/kb/en/sum/','','https://mariadb.com/kb/en/sum/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (189,16,'VARIANCE','Syntax\n------\n\nVARIANCE(expr)\n\nDescription\n-----------\n\nReturns the population standard variance of expr. This is an extension to\nstandard SQL. The standard SQL function VAR_POP() can be used instead.\n\nVariance is calculated by\n\n* working out the mean for the set\n* for each number, subtracting the mean and squaring the result\n* calculate the average of the resulting differences\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVARIANCE() can be used as a window function.\n\nVARIANCE() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE v(i tinyint);\n\nINSERT INTO v VALUES(101),(99);\n\nSELECT VARIANCE(i) FROM v;\n+-------------+\n| VARIANCE(i) |\n+-------------+\n|      1.0000 |\n+-------------+\n\nINSERT INTO v VALUES(120),(80);\n\nSELECT VARIANCE(i) FROM v;\n+-------------+\n| VARIANCE(i) |\n+-------------+\n|    200.5000 |\n+-------------+\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_POP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         287.1875 |\n| Chun    | Tuning |    73 |         582.0000 |\n| Esben   | SQL    |    43 |         287.1875 |\n| Esben   | Tuning |    31 |         582.0000 |\n| Kaolin  | SQL    |    56 |         287.1875 |\n| Kaolin  | Tuning |    88 |         582.0000 |\n| Tatiana | SQL    |    87 |         287.1875 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/variance/','','https://mariadb.com/kb/en/variance/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (190,16,'VAR_POP','Syntax\n------\n\nVAR_POP(expr)\n\nDescription\n-----------\n\nReturns the population standard variance of expr. It considers rows as the\nwhole population, not as a sample, so it has the number of rows as the\ndenominator. You can also use VARIANCE(), which is equivalent but is not\nstandard SQL.\n\nVariance is calculated by\n\n* working out the mean for the set\n* for each number, subtracting the mean and squaring the result\n* calculate the average of the resulting differences\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVAR_POP() can be used as a window function.\n\nVAR_POP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nCREATE TABLE v(i tinyint);\n\nINSERT INTO v VALUES(101),(99);\n\nSELECT VAR_POP(i) FROM v;\n+------------+\n| VAR_POP(i) |\n+------------+\n|     1.0000 |\n+------------+\n\nINSERT INTO v VALUES(120),(80);\n\nSELECT VAR_POP(i) FROM v;\n+------------+\n| VAR_POP(i) |\n+------------+\n|   200.5000 |\n+------------+\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_POP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         287.1875 |\n| Esben   | SQL    |    43 |         287.1875 |\n| Kaolin  | SQL    |    56 |         287.1875 |\n| Tatiana | SQL    |    87 |         287.1875 |\n| Chun    | Tuning |    73 |         582.0000 |\n| Esben   | Tuning |    31 |         582.0000 |\n| Kaolin  | Tuning |    88 |         582.0000 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/var_pop/','','https://mariadb.com/kb/en/var_pop/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (191,16,'VAR_SAMP','Syntax\n------\n\nVAR_SAMP(expr)\n\nDescription\n-----------\n\nReturns the sample variance of expr. That is, the denominator is the number of\nrows minus one.\n\nIt is an aggregate function, and so can be used with the GROUP BY clause.\n\nVAR_SAMP() can be used as a window function.\n\nVAR_SAMP() returns NULL if there were no matching rows.\n\nExamples\n--------\n\nAs an aggregate function:\n\nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n\nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n\nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a        |        0.8165 |         1.0000 |     0.6667 |\n| b        |       18.0400 |        20.1693 |   325.4400 |\n+----------+---------------+----------------+------------+\n\nAs a window function:\n\nCREATE OR REPLACE TABLE student_test (name CHAR(10), test CHAR(10), score\nTINYINT);\n\nINSERT INTO student_test VALUES \n  (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n  (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n  (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n  (\'Tatiana\', \'SQL\', 87);\n\nSELECT name, test, score, VAR_SAMP(score) \n OVER (PARTITION BY test) AS variance_results FROM student_test;\n+---------+--------+-------+------------------+\n| name    | test   | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun    | SQL    |    75 |         382.9167 |\n| Chun    | Tuning |    73 |         873.0000 |\n| Esben   | SQL    |    43 |         382.9167 |\n| Esben   | Tuning |    31 |         873.0000 |\n| Kaolin  | SQL    |    56 |         382.9167 |\n| Kaolin  | Tuning |    88 |         873.0000 |\n| Tatiana | SQL    |    87 |         382.9167 |\n+---------+--------+-------+------------------+\n\nURL: https://mariadb.com/kb/en/var_samp/','','https://mariadb.com/kb/en/var_samp/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (192,17,'BENCHMARK','Syntax\n------\n\nBENCHMARK(count,expr)\n\nDescription\n-----------\n\nThe BENCHMARK() function executes the expression expr repeatedly count times.\nIt may be used to time how quickly MariaDB processes the expression. The\nresult value is always 0. The intended use is from within the mariadb client,\nwhich reports query execution times.\n\nExamples\n--------\n\nSELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (0.21 sec)\n\nURL: https://mariadb.com/kb/en/benchmark/','','https://mariadb.com/kb/en/benchmark/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (193,17,'BINLOG_GTID_POS','Syntax\n------\n\nBINLOG_GTID_POS(binlog_filename,binlog_offset)\n\nDescription\n-----------\n\nThe BINLOG_GTID_POS() function takes as input an old-style binary log position\nin the form of a file name and a file offset. It looks up the position in the\ncurrent binlog, and returns a string representation of the corresponding GTID\nposition. If the position is not found in the current binlog, NULL is returned.\n\nExamples\n--------\n\nSELECT BINLOG_GTID_POS(\"master-bin.000001\", 600);\n\nURL: https://mariadb.com/kb/en/binlog_gtid_pos/','','https://mariadb.com/kb/en/binlog_gtid_pos/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (194,17,'CHARSET','Syntax\n------\n\nCHARSET(str)\n\nDescription\n-----------\n\nReturns the character set of the string argument. If str is not a string, it\nis considered as a binary string (so the function returns \'binary\'). This\napplies to NULL, too. The return value is a string in the utf8 character set.\n\nExamples\n--------\n\nSELECT CHARSET(\'abc\');\n+----------------+\n| CHARSET(\'abc\') |\n+----------------+\n| latin1         |\n+----------------+\n\nSELECT CHARSET(CONVERT(\'abc\' USING utf8));\n+------------------------------------+\n| CHARSET(CONVERT(\'abc\' USING utf8)) |\n+------------------------------------+\n| utf8                               |\n+------------------------------------+\n\nSELECT CHARSET(USER());\n+-----------------+\n| CHARSET(USER()) |\n+-----------------+\n| utf8            |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/charset/','','https://mariadb.com/kb/en/charset/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (195,17,'COERCIBILITY','Syntax\n------\n\nCOERCIBILITY(str)\n\nDescription\n-----------\n\nReturns the collation coercibility value of the string argument. Coercibility\ndefines what will be converted to what in case of collation conflict, with an\nexpression with higher coercibility being converted to the collation of an\nexpression with lower coercibility.\n\n+-----------------------------+---------------------------+------------------+\n| Coercibility                | Description               | Example          |\n+-----------------------------+---------------------------+------------------+\n| 0                           | Explicit                  | Value using a    |\n|                             |                           | COLLATE clause   |\n+-----------------------------+---------------------------+------------------+\n| 1                           | No collation              | Concatenated     |\n|                             |                           | strings using    |\n|                             |                           | different        |\n|                             |                           | collations       |\n+-----------------------------+---------------------------+------------------+\n| 2                           | Implicit                  | Column value     |\n+-----------------------------+---------------------------+------------------+\n| 3                           | Constant                  | USER() return    |\n|                             |                           | value            |\n+-----------------------------+---------------------------+------------------+\n| 4                           | Coercible                 | Literal string   |\n+-----------------------------+---------------------------+------------------+\n| 5                           | Ignorable                 | NULL or derived  |\n|                             |                           | from NULL        |\n+-----------------------------+---------------------------+------------------+\n\nExamples\n--------\n\nSELECT COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci);\n+-----------------------------------------------+\n| COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci) |\n+-----------------------------------------------+\n|                                             0 |\n+-----------------------------------------------+\n\nSELECT COERCIBILITY(USER());\n+----------------------+\n| COERCIBILITY(USER()) |\n+----------------------+\n|                    3 |\n+----------------------+\n\nSELECT COERCIBILITY(\'abc\');\n+---------------------+\n| COERCIBILITY(\'abc\') |\n+---------------------+\n|                   4 |\n+---------------------+\n\nURL: https://mariadb.com/kb/en/coercibility/','','https://mariadb.com/kb/en/coercibility/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (196,17,'COLLATION','Syntax\n------\n\nCOLLATION(str)\n\nDescription\n-----------\n\nReturns the collation of the string argument. If str is not a string, it is\nconsidered as a binary string (so the function returns \'binary\'). This applies\nto NULL, too. The return value is a string in the utf8 character set.\n\nSee Character Sets and Collations.\n\nExamples\n--------\n\nSELECT COLLATION(\'abc\');\n+-------------------+\n| COLLATION(\'abc\')  |\n+-------------------+\n| latin1_swedish_ci |\n+-------------------+\n\nSELECT COLLATION(_utf8\'abc\');\n+-----------------------+\n| COLLATION(_utf8\'abc\') |\n+-----------------------+\n| utf8_general_ci       |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/collation/','','https://mariadb.com/kb/en/collation/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (197,17,'CONNECTION_ID','Syntax\n------\n\nCONNECTION_ID()\n\nDescription\n-----------\n\nReturns the connection ID for the connection. Every connection (including\nevents) has an ID that is unique among the set of currently connected clients.\n\nUntil MariaDB 10.3.1, returns MYSQL_TYPE_LONGLONG, or bigint(10), in all\ncases. From MariaDB 10.3.1, returns MYSQL_TYPE_LONG, or int(10), when the\nresult would fit within 32-bits.\n\nExamples\n--------\n\nSELECT CONNECTION_ID();\n+-----------------+\n| CONNECTION_ID() |\n+-----------------+\n|               3 |\n+-----------------+\n\nURL: https://mariadb.com/kb/en/connection_id/','','https://mariadb.com/kb/en/connection_id/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (198,17,'CURRENT_ROLE','Syntax\n------\n\nCURRENT_ROLE, CURRENT_ROLE()\n\nDescription\n-----------\n\nReturns the current role name. This determines your access privileges. The\nreturn value is a string in the utf8 character set.\n\nIf there is no current role, NULL is returned.\n\nThe output of SELECT CURRENT_ROLE is equivalent to the contents of the\nENABLED_ROLES Information Schema table.\n\nUSER() returns the combination of user and host used to login. CURRENT_USER()\nreturns the account used to determine current connection\'s privileges.\n\nExamples\n--------\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL         |\n+--------------+\n\nSET ROLE staff;\n\nSELECT CURRENT_ROLE;\n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| staff        |\n+--------------+\n\nURL: https://mariadb.com/kb/en/current_role/','','https://mariadb.com/kb/en/current_role/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (199,17,'CURRENT_USER','Syntax\n------\n\nCURRENT_USER, CURRENT_USER()\n\nDescription\n-----------\n\nReturns the user name and host name combination for the MariaDB account that\nthe server used to authenticate the current client. This account determines\nyour access privileges. The return value is a string in the utf8 character set.\n\nThe value of CURRENT_USER() can differ from the value of USER().\nCURRENT_ROLE() returns the current active role.\n\nExamples\n--------\n\nshell> mysql --user=\"anonymous\"\n\nselect user(),current_user();\n+---------------------+----------------+\n| user()              | current_user() |\n+---------------------+----------------+\n| anonymous@localhost | @localhost     |\n+---------------------+----------------+\n\nWhen calling CURRENT_USER() in a stored procedure, it returns the owner of the\nstored procedure, as defined with DEFINER.\n\nURL: https://mariadb.com/kb/en/current_user/','','https://mariadb.com/kb/en/current_user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (200,17,'DATABASE','Syntax\n------\n\nDATABASE()\nSCHEMA()\n\nDescription\n-----------\n\nReturns the default (current) database name as a string in the utf8 character\nset. If there is no default database, DATABASE() returns NULL. Within a stored\nroutine, the default database is the database that the routine is associated\nwith, which is not necessarily the same as the database that is the default in\nthe calling context.\n\nSCHEMA() is a synonym for DATABASE().\n\nTo select a default database, the USE statement can be run. Another way to set\nthe default database is specifying its name at mariadb command line client\nstartup.\n\nExamples\n--------\n\nSELECT DATABASE();\n+------------+\n| DATABASE() |\n+------------+\n| NULL       |\n+------------+\n\nUSE test;\nDatabase changed\n\nSELECT DATABASE();\n+------------+\n| DATABASE() |\n+------------+\n| test       |\n+------------+\n\nURL: https://mariadb.com/kb/en/database/','','https://mariadb.com/kb/en/database/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (201,17,'DECODE_HISTOGRAM','Syntax\n------\n\nDECODE_HISTOGRAM(hist_type,histogram)\n\nDescription\n-----------\n\nReturns a string of comma separated numeric values corresponding to a\nprobability distribution represented by the histogram of type hist_type\n(SINGLE_PREC_HB or DOUBLE_PREC_HB). The hist_type and histogram would be\ncommonly used from the mysql.column_stats table.\n\nSee Histogram Based Statistics for details.\n\nExamples\n--------\n\nCREATE TABLE origin (\n i INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,\n v INT UNSIGNED NOT NULL\n);\n\nINSERT INTO origin(v) VALUES \n (1),(2),(3),(4),(5),(10),(20),\n (30),(40),(50),(60),(70),(80),\n (90),(100),(200),(400),(800);\n\nSET histogram_size=10,histogram_type=SINGLE_PREC_HB;\n\nANALYZE TABLE origin PERSISTENT FOR ALL;\n+-------------+---------+----------+-----------------------------------------+\n| Table       | Op      | Msg_type | Msg_text                                |\n+-------------+---------+----------+-----------------------------------------+\n| test.origin | analyze | status   | Engine-independent statistics collected |\n| test.origin | analyze | status   | OK                                      |\n+-------------+---------+----------+-----------------------------------------+\n\nSELECT db_name,table_name,column_name,hist_type,\n hex(histogram),decode_histogram(hist_type,histogram)\n FROM mysql.column_stats WHERE db_name=\'test\' and table_name=\'origin\';\n+---------+------------+-------------+----------------+----------------------+-\n-----------------------------------------------------------------+\n| db_name | table_name | column_name | hist_type      | hex(histogram)       |\ndecode_histogram(hist_type,histogram)                             |\n+---------+------------+-------------+----------------+----------------------+-\n-----------------------------------------------------------------+\n| test    | origin     | i           | SINGLE_PREC_HB | 0F2D3C5A7887A5C3D2F0 |\n0.059,0.118,0.059,0.118,0.118,0.059,0.118,0.118,0.059,0.118,0.059 |\n| test    | origin     | v           | SINGLE_PREC_HB | 000001060C0F161C1F7F |\n0.000,0.000,0.004,0.020,0.024,0.012,0.027,0.024,0.012,0.376,0.502 |\n+---------+------------+-------------+----------------+----------------------+-\n-----------------------------------------------------------------+\n\nSET histogram_size=20,histogram_type=DOUBLE_PREC_HB;\n\nANALYZE TABLE origin PERSISTENT FOR ALL;\n+-------------+---------+----------+-----------------------------------------+\n| Table       | Op      | Msg_type | Msg_text                                |\n+-------------+---------+----------+-----------------------------------------+\n| test.origin | analyze | status   | Engine-independent statistics collected |\n| test.origin | analyze | status   | OK                                      |\n+-------------+---------+----------+-----------------------------------------+\n\nSELECT db_name,table_name,column_name,\n hist_type,hex(histogram),decode_histogram(hist_type,histogram)\n FROM mysql.column_stats WHERE db_name=\'test\' and table_name=\'origin\';\n+---------+------------+-------------+----------------+------------------------\n-----------------+-------------------------------------------------------------\n---------------------------+\n| db_name | table_name | column_name | hist_type      | hex(histogram)        \n         | decode_histogram(hist_type,histogram)\n              |\n+---------+------------+-------------+----------------+------------------------\n-----------------+-------------------------------------------------------------\n---------------------------+\n| test    | origin     | i           | DOUBLE_PREC_HB |\n0F0F2D2D3C3C5A5A78788787A5A5C3C3D2D2F0F0 |\n0.05882,0.11765,0.05882,0.11765,0.11765,0.05882,0.11765,0.11765,0.05882,0.11765\n0.05882 |\n| test    | origin     | v           | DOUBLE_PREC_HB |\n5200F600480116067E0CB30F1B16831CB81FD67F |\n0.00125,0.00250,0.00125,0.01877,0.02502,0.01253,0.02502,0.02502,0.01253,0.37546\n0.50063 |\n\nURL: https://mariadb.com/kb/en/decode_histogram/','','https://mariadb.com/kb/en/decode_histogram/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (202,17,'DEFAULT','Syntax\n------\n\nDEFAULT(col_name)\n\nDescription\n-----------\n\nReturns the default value for a table column. If the column has no default\nvalue (and is not NULLABLE - NULLABLE fields have a NULL default), an error is\nreturned.\n\nFor integer columns using AUTO_INCREMENT, 0 is returned.\n\nWhen using DEFAULT as a value to set in an INSERT or UPDATE statement, you can\nuse the bare keyword DEFAULT without the parentheses and argument to refer to\nthe column in context. You can only use DEFAULT as a bare keyword if you are\nusing it alone without a surrounding expression or function.\n\nExamples\n--------\n\nSelect only non-default values for a column:\n\nSELECT i FROM t WHERE i != DEFAULT(i);\n\nUpdate values to be one greater than the default value:\n\nUPDATE t SET i = DEFAULT(i)+1 WHERE i < 100;\n\nWhen referring to the default value exactly in UPDATE or INSERT, you can omit\nthe argument:\n\nINSERT INTO t (i) VALUES (DEFAULT);\nUPDATE t SET i = DEFAULT WHERE i < 100;\n\nCREATE OR REPLACE TABLE t (\n i INT NOT NULL AUTO_INCREMENT,\n j INT NOT NULL,\n k INT DEFAULT 3,\n l INT NOT NULL DEFAULT 4,\n m INT,\n PRIMARY KEY (i)\n);\n\nDESC t;\n+-------+---------+------+-----+---------+----------------+\n| Field | Type    | Null | Key | Default | Extra          |\n+-------+---------+------+-----+---------+----------------+\n| i     | int(11) | NO   | PRI | NULL    | auto_increment |\n| j     | int(11) | NO   |     | NULL    |                |\n| k     | int(11) | YES  |     | 3       |                |\n| l     | int(11) | NO   |     | 4       |                |\n| m     | int(11) | YES  |     | NULL    |                |\n+-------+---------+------+-----+---------+----------------+\n\nINSERT INTO t (j) VALUES (1);\nINSERT INTO t (j,m) VALUES (2,2);\nINSERT INTO t (j,l,m) VALUES (3,3,3);\n\nSELECT * FROM t;\n+---+---+------+---+------+\n| i | j | k    | l | m    |\n+---+---+------+---+------+\n| 1 | 1 |    3 | 4 | NULL |\n| 2 | 2 |    3 | 4 |    2 |\n| 3 | 3 |    3 | 3 |    3 |\n+---+---+------+---+------+\n\nSELECT DEFAULT(i), DEFAULT(k), DEFAULT (l), DEFAULT(m) FROM t;\n+------------+------------+-------------+------------+\n| DEFAULT(i) | DEFAULT(k) | DEFAULT (l) | DEFAULT(m) |\n+------------+------------+-------------+------------+\n|          0 |          3 |           4 |       NULL |\n|          0 |          3 |           4 |       NULL |\n|          0 |          3 |           4 |       NULL |\n+------------+------------+-------------+------------+\n\nSELECT DEFAULT(i), DEFAULT(k), DEFAULT (l), DEFAULT(m), DEFAULT(j)  FROM t;\nERROR 1364 (HY000): Field \'j\' doesn\'t have a default value\n\nSELECT * FROM t WHERE i = DEFAULT(i);\nEmpty set (0.001 sec)\n\nSELECT * FROM t WHERE j = DEFAULT(j);\nERROR 1364 (HY000): Field \'j\' doesn\'t have a default value\n\nSELECT * FROM t WHERE k = DEFAULT(k);\n+---+---+------+---+------+\n| i | j | k    | l | m    |\n+---+---+------+---+------+\n| 1 | 1 |    3 | 4 | NULL |\n| 2 | 2 |    3 | 4 |    2 |\n| 3 | 3 |    3 | 3 |    3 |\n+---+---+------+---+------+\n\nSELECT * FROM t WHERE l = DEFAULT(l);\n+---+---+------+---+------+\n| i | j | k    | l | m    |\n+---+---+------+---+------+\n| 1 | 1 |    3 | 4 | NULL |\n| 2 | 2 |    3 | 4 |    2 |\n+---+---+------+---+------+\n\nSELECT * FROM t WHERE m = DEFAULT(m);\nEmpty set (0.001 sec)\n\nSELECT * FROM t WHERE m <=> DEFAULT(m);\n+---+---+------+---+------+\n| i | j | k    | l | m    |\n+---+---+------+---+------+\n| 1 | 1 |    3 | 4 | NULL |\n+---+---+------+---+------+\n\nURL: https://mariadb.com/kb/en/default/','','https://mariadb.com/kb/en/default/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (203,17,'FOUND_ROWS','Syntax\n------\n\nFOUND_ROWS()\n\nDescription\n-----------\n\nA SELECT statement may include a LIMIT clause to restrict the number of rows\nthe server returns to the client. In some cases, it is desirable to know how\nmany rows the statement would have returned without the LIMIT, but without\nrunning the statement again. To obtain this row count, include a\nSQL_CALC_FOUND_ROWS option in the SELECT statement, and then invoke\nFOUND_ROWS() afterwards.\n\nYou can also use FOUND_ROWS() to obtain the number of rows returned by a\nSELECT which does not contain a LIMIT clause. In this case you don\'t need to\nuse the SQL_CALC_FOUND_ROWS option. This can be useful for example in a stored\nprocedure.\n\nAlso, this function works with some other statements which return a resultset,\nincluding SHOW, DESC and HELP. For DELETE ... RETURNING you should use\nROW_COUNT(). It also works as a prepared statement, or after executing a\nprepared statement.\n\nStatements which don\'t return any results don\'t affect FOUND_ROWS() - the\nprevious value will still be returned.\n\nWarning: When used after a CALL statement, this function returns the number of\nrows selected by the last query in the procedure, not by the whole procedure.\n\nStatements using the FOUND_ROWS() function are not safe for replication.\n\nExamples\n--------\n\nSHOW ENGINES\\G\n*************************** 1. row ***************************\n   Engine: CSV\n  Support: YES\n  Comment: Stores tables as CSV files\nTransactions: NO\n     XA: NO\n Savepoints: NO\n*************************** 2. row ***************************\n   Engine: MRG_MyISAM\n  Support: YES\n  Comment: Collection of identical MyISAM tables\nTransactions: NO\n     XA: NO\n Savepoints: NO\n\n...\n\n*************************** 8. row ***************************\n   Engine: PERFORMANCE_SCHEMA\n  Support: YES\n  Comment: Performance Schema\nTransactions: NO\n     XA: NO\n Savepoints: NO\n8 rows in set (0.000 sec)\n\nSELECT FOUND_ROWS();\n+--------------+\n| FOUND_ROWS() |\n+--------------+\n|           8 |\n+--------------+\n\nSELECT SQL_CALC_FOUND_ROWS * FROM tbl_name WHERE id > 100 LIMIT 10;\n\nSELECT FOUND_ROWS();\n+--------------+\n| FOUND_ROWS() |\n+--------------+\n|           23 |\n+--------------+\n\nURL: https://mariadb.com/kb/en/found_rows/','','https://mariadb.com/kb/en/found_rows/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (204,17,'LAST_INSERT_ID','Syntax\n------\n\nLAST_INSERT_ID(), LAST_INSERT_ID(expr)\n\nDescription\n-----------\n\nLAST_INSERT_ID() (no arguments) returns the first automatically generated\nvalue successfully inserted for an AUTO_INCREMENT column as a result of the\nmost recently executed INSERT statement. The value of LAST_INSERT_ID() remains\nunchanged if no rows are successfully inserted.\n\nIf one gives an argument to LAST_INSERT_ID(), then it will return the value of\nthe expression and the next call to LAST_INSERT_ID() will return the same\nvalue. The value will also be sent to the client and can be accessed by the\nmysql_insert_id function.\n\nFor example, after inserting a row that generates an AUTO_INCREMENT value, you\ncan get the value like this:\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                9 |\n+------------------+\n\nYou can also use LAST_INSERT_ID() to delete the last inserted row:\n\nDELETE FROM product WHERE id = LAST_INSERT_ID();\n\nIf no rows were successfully inserted, LAST_INSERT_ID() returns 0.\n\nThe value of LAST_INSERT_ID() will be consistent across all versions if all\nrows in the INSERT or UPDATE statement were successful.\n\nThe currently executing statement does not affect the value of\nLAST_INSERT_ID(). Suppose that you generate an AUTO_INCREMENT value with one\nstatement, and then refer to LAST_INSERT_ID() in a multiple-row INSERT\nstatement that inserts rows into a table with its own AUTO_INCREMENT column.\nThe value of LAST_INSERT_ID() will remain stable in the second statement; its\nvalue for the second and later rows is not affected by the earlier row\ninsertions. (However, if you mix references to LAST_INSERT_ID() and\nLAST_INSERT_ID(expr), the effect is undefined.)\n\nIf the previous statement returned an error, the value of LAST_INSERT_ID() is\nundefined. For transactional tables, if the statement is rolled back due to an\nerror, the value of LAST_INSERT_ID() is left undefined. For manual ROLLBACK,\nthe value of LAST_INSERT_ID() is not restored to that before the transaction;\nit remains as it was at the point of the ROLLBACK.\n\nWithin the body of a stored routine (procedure or function) or a trigger, the\nvalue of LAST_INSERT_ID() changes the same way as for statements executed\noutside the body of these kinds of objects. The effect of a stored routine or\ntrigger upon the value of LAST_INSERT_ID() that is seen by following\nstatements depends on the kind of routine:\n\n* If a stored procedure executes statements that change the value of\nLAST_INSERT_ID(), the new value will be seen by statements that follow the\nprocedure call.\n\n* For stored functions and triggers that change the value, the value is\nrestored when the function or trigger ends, so following statements will not\nsee a changed value.\n\nExamples\n--------\n\nCREATE TABLE t (\n id INTEGER UNSIGNED AUTO_INCREMENT PRIMARY KEY,\n f VARCHAR(1))\nENGINE = InnoDB;\n\nINSERT INTO t(f) VALUES(\'a\');\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                1 |\n+------------------+\n\nINSERT INTO t(f) VALUES(\'b\');\n\nINSERT INTO t(f) VALUES(\'c\');\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                3 |\n+------------------+\n\nINSERT INTO t(f) VALUES(\'d\'),(\'e\');\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                4 |\n+------------------+\n\nSELECT * FROM t;\n+----+------+\n| id | f    |\n+----+------+\n|  1 | a    |\n|  2 | b    |\n|  3 | c    |\n|  4 | d    |\n|  5 | e    |\n+----+------+\n\nSELECT LAST_INSERT_ID(12);\n+--------------------+\n| LAST_INSERT_ID(12) |\n+--------------------+\n|                 12 |\n+--------------------+\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|               12 |\n+------------------+\n\nINSERT INTO t(f) VALUES(\'f\');\n\nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                6 |\n+------------------+\n\nSELECT * FROM t;\n+----+------+\n| id | f    |\n+----+------+\n|  1 | a    |\n|  2 | b    |\n|  3 | c    |\n|  4 | d    |\n|  5 | e    |\n|  6 | f    |\n+----+------+\n\nSELECT LAST_INSERT_ID(12);\n+--------------------+\n| LAST_INSERT_ID(12) |\n+--------------------+\n|                 12 |\n+--------------------+\n\nINSERT INTO t(f) VALUES(\'g\');\n\nSELECT * FROM t;\n+----+------+\n| id | f    |\n+----+------+\n|  1 | a    |\n|  2 | b    |\n|  3 | c    |\n|  4 | d    |\n|  5 | e    |\n|  6 | f    |\n|  7 | g    |\n+----+------+\n\nURL: https://mariadb.com/kb/en/last_insert_id/','','https://mariadb.com/kb/en/last_insert_id/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (205,17,'LAST_VALUE','Syntax\n------\n\nLAST_VALUE(expr,[expr,...])\n\nLAST_VALUE(expr) OVER (\n [ PARTITION BY partition_expression ]\n [ ORDER BY order_list ]\n)\n\nDescription\n-----------\n\nLAST_VALUE() evaluates all expressions and returns the last.\n\nThis is useful together with setting user variables to a value with\n@var:=expr, for example when you want to get data of rows updated/deleted\nwithout having to do two queries against the table.\n\nLAST_VALUE can be used as a window function.\n\nReturns NULL if no last value exists.\n\nExamples\n--------\n\nCREATE TABLE t1 (a int, b int);\nINSERT INTO t1 VALUES(1,10),(2,20);\nDELETE FROM t1 WHERE a=1 AND last_value(@a:=a,@b:=b,1);\nSELECT @a,@b;\n+------+------+\n| @a   | @b   |\n+------+------+\n|    1 |   10 |\n+------+------+\n\nAs a window function:\n\nCREATE TABLE t1 (\n pk int primary key,\n a int,\n b int,\n c char(10),\n d decimal(10, 3),\n e real\n);\n\nINSERT INTO t1 VALUES\n( 1, 0, 1,    \'one\',    0.1,  0.001),\n( 2, 0, 2,    \'two\',    0.2,  0.002),\n( 3, 0, 3,    \'three\',  0.3,  0.003),\n( 4, 1, 2,    \'three\',  0.4,  0.004),\n( 5, 1, 1,    \'two\',    0.5,  0.005),\n( 6, 1, 1,    \'one\',    0.6,  0.006),\n( 7, 2, NULL, \'n_one\',  0.5,  0.007),\n( 8, 2, 1,    \'n_two\',  NULL, 0.008),\n( 9, 2, 2,    NULL,     0.7,  0.009),\n(10, 2, 0,    \'n_four\', 0.8,  0.010),\n(11, 2, 10,   NULL,     0.9,  NULL);\n\nSELECT pk, FIRST_VALUE(pk) OVER (ORDER BY pk) AS first_asc,\n     LAST_VALUE(pk) OVER (ORDER BY pk) AS last_asc,\n     FIRST_VALUE(pk) OVER (ORDER BY pk DESC) AS first_desc,\n     LAST_VALUE(pk) OVER (ORDER BY pk DESC) AS last_desc\nFROM t1\nORDER BY pk DESC;\n\n+----+-----------+----------+------------+-----------+\n| pk | first_asc | last_asc | first_desc | last_desc |\n+----+-----------+----------+------------+-----------+\n| 11 |         1 |       11 |         11 |        11 |\n| 10 |         1 |       10 |         11 |        10 |\n|  9 |         1 |        9 |         11 |         9 |\n|  8 |         1 |        8 |         11 |         8 |\n|  7 |         1 |        7 |         11 |         7 |\n|  6 |         1 |        6 |         11 |         6 |\n|  5 |         1 |        5 |         11 |         5 |\n|  4 |         1 |        4 |         11 |         4 |\n|  3 |         1 |        3 |         11 |         3 |\n|  2 |         1 |        2 |         11 |         2 |\n|  1 |         1 |        1 |         11 |         1 |\n+----+-----------+----------+------------+-----------+\n\nCREATE OR REPLACE TABLE t1 (i int);\nINSERT INTO t1 VALUES (1),(2),(3),(4),(5),(6),(7),(8),(9),(10);\n\nSELECT i,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN CURRENT ROW and 1 FOLLOWING) AS\nf_1f,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN CURRENT ROW and 1 FOLLOWING) AS\nl_1f,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) AS\nf_1p1f,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) AS\nl_1p1f,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 2 PRECEDING AND 1 PRECEDING) AS\nf_2p1p,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 2 PRECEDING AND 1 PRECEDING) AS\nl_2p1p,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 FOLLOWING AND 2 FOLLOWING) AS\nf_1f2f,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 FOLLOWING AND 2 FOLLOWING) AS\nl_1f2f\nFROM t1;\n\n+------+------+------+--------+--------+--------+--------+--------+--------+\n| i    | f_1f | l_1f | f_1p1f | l_1p1f | f_2p1p | l_2p1p | f_1f2f | l_1f2f |\n+------+------+------+--------+--------+--------+--------+--------+--------+\n|    1 |    1 |    2 |      1 |      2 |   NULL |   NULL |      2 |      3 |\n|    2 |    2 |    3 |      1 |      3 |      1 |      1 |      3 |      4 |\n|    3 |    3 |    4 |      2 |      4 |      1 |      2 |      4 |      5 |\n|    4 |    4 |    5 |      3 |      5 |      2 |      3 |      5 |      6 |\n|    5 |    5 |    6 |      4 |      6 |      3 |      4 |      6 |      7 |\n|    6 |    6 |    7 |      5 |      7 |      4 |      5 |      7 |      8 |\n|    7 |    7 |    8 |      6 |      8 |      5 |      6 |      8 |      9 |\n|    8 |    8 |    9 |      7 |      9 |      6 |      7 |      9 |     10 |\n|    9 |    9 |   10 |      8 |     10 |      7 |      8 |     10 |     10 |\n|   10 |   10 |   10 |      9 |     10 |      8 |      9 |   NULL |   NULL |\n+------+------+------+--------+--------+--------+--------+--------+--------+\n\nURL: https://mariadb.com/kb/en/last_value/','','https://mariadb.com/kb/en/last_value/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (206,17,'PROCEDURE ANALYSE','Syntax\n------\n\nanalyse([max_elements[,max_memory]])\n\nDescription\n-----------\n\nThis procedure is defined in the sql/sql_analyse.cc file. It examines the\nresult from a query and returns an analysis of the results that suggests\noptimal data types for each column. To obtain this analysis, append PROCEDURE\nANALYSE to the end of a SELECT statement:\n\nSELECT ... FROM ... WHERE ... PROCEDURE ANALYSE([max_elements,[max_memory]])\n\nFor example:\n\nSELECT col1, col2 FROM table1 PROCEDURE ANALYSE(10, 2000);\n\nThe results show some statistics for the values returned by the query, and\npropose an optimal data type for the columns. This can be helpful for checking\nyour existing tables, or after importing new data. You may need to try\ndifferent settings for the arguments so that PROCEDURE ANALYSE() does not\nsuggest the ENUM data type when it is not appropriate.\n\nThe arguments are optional and are used as follows:\n\n* max_elements (default 256) is the maximum number of distinct values that\nanalyse notices per column. This is used by analyse to check whether the\noptimal data type should be of type ENUM; if there are more than max_elements\ndistinct values, then ENUM is not a suggested type.\n* max_memory (default 8192) is the maximum amount of memory that analyse\nshould allocate per column while trying to find all distinct values.\n\nURL: https://mariadb.com/kb/en/procedure-analyse/','','https://mariadb.com/kb/en/procedure-analyse/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (207,17,'ROWNUM','MariaDB starting with 10.6.1\n----------------------------\nFrom MariaDB 10.6.1, the ROWNUM() function is supported.\n\nSyntax\n------\n\nROWNUM()\n\nIn Oracle mode one can just use ROWNUM, without the parentheses.\n\nDescription\n-----------\n\nROWNUM() returns the current number of accepted rows in the current context.\nIt main purpose is to emulate the ROWNUM pseudo column in Oracle. For MariaDB\nnative applications, we recommend the usage of LIMIT, as it is easier to use\nand gives more predictable results than the usage of ROWNUM().\n\nThe main difference between using LIMIT and ROWNUM() to limit the rows in the\nresult is that LIMIT works on the result set while ROWNUM works on the number\nof accepted rows (before any ORDER or GROUP BY clauses).\n\nThe following queries will return the same results:\n\nSELECT * from t1 LIMIT 10;\nSELECT * from t1 WHERE ROWNUM() <= 10;\n\nWhile the following may return different results based on in which orders the\nrows are found:\n\nSELECT * from t1 ORDER BY a LIMIT 10;\nSELECT * from t1 ORDER BY a WHERE ROWNUM() <= 10;\n\nThe recommended way to use ROWNUM to limit the number of returned rows and get\npredictable results is to have the query in a subquery and test for ROWNUM()\nin the outer query:\n\nSELECT * FROM (select * from t1 ORDER BY a) WHERE ROWNUM() <= 10;\n\nROWNUM() can be used in the following contexts:\n\n* SELECT\n* INSERT\n* UPDATE\n* DELETE\n* LOAD DATA INFILE\n\nUsed in other contexts, ROWNUM() will return 0.\n\nExamples\n--------\n\nINSERT INTO t1 VALUES (1,ROWNUM()),(2,ROWNUM()),(3,ROWNUM());\n\nINSERT INTO t1 VALUES (1),(2) returning a, ROWNUM();\n\nUPDATE t1 SET row_num_column=ROWNUM();\n\nDELETE FROM t1 WHERE a < 10 AND ROWNUM() < 2;\n\nLOAD DATA INFILE \'filename\' into table t1 fields terminated by \',\' \n lines terminated by \"\\r\\n\" (a,b) set c=ROWNUM();\n\nOptimizations\n-------------\n\nIn many cases where ROWNUM() is used, MariaDB will use the same optimizations\nit uses with LIMIT.\n\nLIMIT optimization is possible when using ROWNUM in the following manner:\n\n* When one is in a top level WHERE clause comparing ROWNUM() with a numerical\nconstant using any of the following expressions:\nROWNUM() < number\nROWNUM() <= number\nROWNUM() = 1\nROWNUM() can be also be the right argument to the comparison function.\n\nIn the above cases, LIMIT optimization can be done in the following cases:\n\n* For the current sub query when the ROWNUM comparison is done on the top\nlevel:\n\nSELECT * from t1 WHERE ROWNUM() <= 2 AND t1.a > 0\n\n* For an inner sub query, when the upper level has only a ROWNUM() comparison\nin the WHERE clause:\n\nSELECT * from (select * from t1) as t WHERE ROWNUM() <= 2\n\nOther Changes Related to ROWNUM\n-------------------------------\n\nWhen ROWNUM() is used anywhere in a query, the optimization to ignore ORDER BY\nin subqueries are disabled.\n\nThis was done to get the following common Oracle query to work as expected:\n\nselect * from (select * from t1 order by a desc) as t where rownum() <= 2;\n\nBy default MariaDB ignores any ORDER BY in subqueries both because the SQL\nstandard defines results sets in subqueries to be un-ordered and because of\nperformance reasons (especially when using views in subqueries). See MDEV-3926\n\"Wrong result with GROUP BY ... WITH ROLLUP\" for a discussion of this topic.\n\nOther Considerations\n--------------------\n\nWhile MariaDB tries to emulate Oracle\'s usage of ROWNUM() as closely as\npossible, there are cases where the result is different:\n\n* When the optimizer finds rows in a different order (because of different\nstorage methods or optimization). This may also happen in Oracle if one adds\nor deletes an index, in which case the rows may be found in a different order.\n\nNote that usage of ROWNUM() in functions or stored procedures will use their\nown context, not the caller\'s context.\n\nURL: https://mariadb.com/kb/en/rownum/','','https://mariadb.com/kb/en/rownum/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (208,17,'ROW_COUNT','Syntax\n------\n\nROW_COUNT()\n\nDescription\n-----------\n\nROW_COUNT() returns the number of rows updated, inserted or deleted by the\npreceding statement. This is the same as the row count that the mariadb client\ndisplays and the value from the mysql_affected_rows() C API function.\n\nGenerally:\n\n* For statements which return a result set (such as SELECT, SHOW, DESC or\nHELP), returns -1, even when the result set is empty. This is also true for\nadministrative statements, such as OPTIMIZE.\n* For DML statements other than SELECT and for ALTER TABLE, returns the number\nof affected rows.\n* For DDL statements (including TRUNCATE) and for other statements which don\'t\nreturn any result set (such as USE, DO, SIGNAL or DEALLOCATE PREPARE), returns\n0.\n\nFor UPDATE, affected rows is by default the number of rows that were actually\nchanged. If the CLIENT_FOUND_ROWS flag to mysql_real_connect() is specified\nwhen connecting to mysqld, affected rows is instead the number of rows matched\nby the WHERE clause.\n\nFor REPLACE, deleted rows are also counted. So, if REPLACE deletes a row and\nadds a new row, ROW_COUNT() returns 2.\n\nFor INSERT ... ON DUPLICATE KEY, updated rows are counted twice. So, if INSERT\nadds a new rows and modifies another row, ROW_COUNT() returns 3.\n\nROW_COUNT() does not take into account rows that are not directly\ndeleted/updated by the last statement. This means that rows deleted by foreign\nkeys or triggers are not counted.\n\nWarning: You can use ROW_COUNT() with prepared statements, but you need to\ncall it after EXECUTE, not after DEALLOCATE PREPARE, because the row count for\nallocate prepare is always 0.\n\nWarning: When used after a CALL statement, this function returns the number of\nrows affected by the last statement in the procedure, not by the whole\nprocedure.\n\nWarning: After INSERT DELAYED, ROW_COUNT() returns the number of the rows you\ntried to insert, not the number of the successful writes.\n\nThis information can also be found in the diagnostics area.\n\nStatements using the ROW_COUNT() function are not safe for replication.\n\nExamples\n--------\n\nCREATE TABLE t (A INT);\n\nINSERT INTO t VALUES(1),(2),(3);\n\nSELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           3 |\n+-------------+\n\nDELETE FROM t WHERE A IN(1,2);\n\nSELECT ROW_COUNT(); \n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           2 |\n+-------------+\n\nExample with prepared statements:\n\nSET @q = \'INSERT INTO t VALUES(1),(2),(3);\';\n\nPREPARE stmt FROM @q;\n\nEXECUTE stmt;\nQuery OK, 3 rows affected (0.39 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nSELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           3 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/row_count/','','https://mariadb.com/kb/en/row_count/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (209,17,'SCHEMA','Syntax\n------\n\nSCHEMA()\n\nDescription\n-----------\n\nThis function is a synonym for DATABASE().\n\nURL: https://mariadb.com/kb/en/schema/','','https://mariadb.com/kb/en/schema/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (210,17,'SESSION_USER','Syntax\n------\n\nSESSION_USER()\n\nDescription\n-----------\n\nSESSION_USER() is a synonym for USER().\n\nURL: https://mariadb.com/kb/en/session_user/','','https://mariadb.com/kb/en/session_user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (211,17,'SYSTEM_USER','Syntax\n------\n\nSYSTEM_USER()\n\nDescription\n-----------\n\nSYSTEM_USER() is a synonym for USER().\n\nURL: https://mariadb.com/kb/en/system_user/','','https://mariadb.com/kb/en/system_user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (212,17,'USER','Syntax\n------\n\nUSER()\n\nDescription\n-----------\n\nReturns the current MariaDB user name and host name, given when authenticating\nto MariaDB, as a string in the utf8 character set.\n\nNote that the value of USER() may differ from the value of CURRENT_USER(),\nwhich is the user used to authenticate the current client. CURRENT_ROLE()\nreturns the current active role.\n\nSYSTEM_USER() and SESSION_USER are synonyms for USER().\n\nStatements using the USER() function or one of its synonyms are not safe for\nstatement level replication.\n\nExamples\n--------\n\nshell> mysql --user=\"anonymous\"\n\nSELECT USER(),CURRENT_USER();\n+---------------------+----------------+\n| USER()              | CURRENT_USER() |\n+---------------------+----------------+\n| anonymous@localhost | @localhost     |\n+---------------------+----------------+\n\nTo select only the IP address, use SUBSTRING_INDEX(),\n\nSELECT SUBSTRING_INDEX(USER(), \'@\', -1);\n+----------------------------------+\n| SUBSTRING_INDEX(USER(), \'@\', -1) |\n+----------------------------------+\n| 192.168.0.101                    |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/user/','','https://mariadb.com/kb/en/user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (213,17,'VERSION','Syntax\n------\n\nVERSION()\n\nDescription\n-----------\n\nReturns a string that indicates the MariaDB server version. The string uses\nthe utf8 character set.\n\nExamples\n--------\n\nSELECT VERSION();\n+----------------+\n| VERSION()      |\n+----------------+\n| 10.4.7-MariaDB |\n+----------------+\n\nThe VERSION() string may have one or more of the following suffixes:\n\n+---------------------------+------------------------------------------------+\n| Suffix                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| -embedded                 | The server is an embedded server               |\n|                           | (libmariadbd).                                 |\n+---------------------------+------------------------------------------------+\n| -log                      | General logging, slow logging or binary        |\n|                           | (replication) logging is enabled.              |\n+---------------------------+------------------------------------------------+\n| -debug                    | The server is compiled for debugging.          |\n+---------------------------+------------------------------------------------+\n| -valgrind                 | The server is compiled to be instrumented      |\n|                           | with valgrind.                                 |\n+---------------------------+------------------------------------------------+\n\nChanging the Version String\n---------------------------\n\nSome old legacy code may break because they are parsing the VERSION string and\nexpecting a MySQL string or a simple version string like Joomla til API17, see\nMDEV-7780.\n\nOne can fool these applications by setting the version string from the command\nline or the my.cnf files with --version=....\n\nURL: https://mariadb.com/kb/en/version/','','https://mariadb.com/kb/en/version/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (214,18,'Assignment Operator (:=)','Syntax\n------\n\nvar_name := expr\n\nDescription\n-----------\n\nAssignment operator for assigning a value. The value on the right is assigned\nto the variable on left.\n\nUnlike the = operator, := can always be used to assign a value to a variable.\n\nThis operator works with both user-defined variables and local variables.\n\nWhen assigning the same value to several variables, LAST_VALUE() can be useful.\n\nExamples\n--------\n\nSELECT @x := 10;\n+----------+\n| @x := 10 |\n+----------+\n|       10 |\n+----------+\n\nSELECT @x, @y := @x;\n+------+----------+\n| @x   | @y := @x |\n+------+----------+\n|   10 |       10 |\n+------+----------+\n\nURL: https://mariadb.com/kb/en/assignment-operator/','','https://mariadb.com/kb/en/assignment-operator/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (215,18,'Assignment Operator (=)','Syntax\n------\n\nidentifier = expr\n\nDescription\n-----------\n\nThe equal sign is used as both an assignment operator in certain contexts, and\nas a comparison operator. When used as assignment operator, the value on the\nright is assigned to the variable (or column, in some contexts) on the left.\n\nSince its use can be ambiguous, unlike the := assignment operator, the =\nassignment operator cannot be used in all contexts, and is only valid as part\nof a SET statement, or the SET clause of an UPDATE statement\n\nThis operator works with both user-defined variables and local variables.\n\nExamples\n--------\n\nUPDATE table_name SET x = 2 WHERE x > 100;\n\nSET @x = 1, @y := 2;\n\nURL: https://mariadb.com/kb/en/assignment-operators-assignment-operator/','','https://mariadb.com/kb/en/assignment-operators-assignment-operator/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (216,19,'Not Equal Operator','Syntax\n------\n\n<>, !=\n\nDescription\n-----------\n\nNot equal operator. Evaluates both SQL expressions and returns 1 if they are\nnot equal and 0 if they are equal, or NULL if either expression is NULL. If\nthe expressions return different data types, (for instance, a number and a\nstring), performs type conversion.\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) != (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a != t2.x) OR (t1.b != t2.y)\nFROM t1 INNER JOIN t2;\n\nExamples\n--------\n\nSELECT \'.01\' <> \'0.01\';\n+-----------------+\n| \'.01\' <> \'0.01\' |\n+-----------------+\n|               1 |\n+-----------------+\n\nSELECT .01 <> \'0.01\';\n+---------------+\n| .01 <> \'0.01\' |\n+---------------+\n|             0 |\n+---------------+\n\nSELECT \'zapp\' <> \'zappp\';\n+-------------------+\n| \'zapp\' <> \'zappp\' |\n+-------------------+\n|                 1 |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/not-equal/','','https://mariadb.com/kb/en/not-equal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (217,19,'<','Syntax\n------\n\n<\n\nDescription\n-----------\n\nLess than operator. Evaluates both SQL expressions and returns 1 if the left\nvalue is less than the right value and 0 if it is not, or NULL if either\nexpression is NULL. If the expressions return different data types, (for\ninstance, a number and a string), performs type conversion.\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) < (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a < t2.x) OR ((t1.a = t2.x) AND (t1.b < t2.y))\nFROM t1 INNER JOIN t2;\n\nExamples\n--------\n\nSELECT 2 < 2;\n+-------+\n| 2 < 2 |\n+-------+\n|     0 |\n+-------+\n\nType conversion:\n\nSELECT 3<\'4\';\n+-------+\n| 3<\'4\' |\n+-------+\n|     1 |\n+-------+\n\nCase insensitivity - see Character Sets and Collations:\n\nSELECT \'a\'<\'A\';\n+---------+\n| \'a\'<\'A\' |\n+---------+\n|       0 |\n+---------+\n\nURL: https://mariadb.com/kb/en/less-than/','','https://mariadb.com/kb/en/less-than/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (218,19,'<=','Syntax\n------\n\n<=\n\nDescription\n-----------\n\nLess than or equal operator. Evaluates both SQL expressions and returns 1 if\nthe left value is less than or equal to the right value and 0 if it is not, or\nNULL if either expression is NULL. If the expressions return different data\ntypes, (for instance, a number and a string), performs type conversion.\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) <= (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a < t2.x) OR ((t1.a = t2.x) AND (t1.b <= t2.y))\nFROM t1 INNER JOIN t2;\n\nExamples\n--------\n\nSELECT 0.1 <= 2;\n+----------+\n| 0.1 <= 2 |\n+----------+\n|        1 |\n+----------+\n\nSELECT \'a\'<=\'A\';\n+----------+\n| \'a\'<=\'A\' |\n+----------+\n|        1 |\n+----------+\n\nURL: https://mariadb.com/kb/en/less-than-or-equal/','','https://mariadb.com/kb/en/less-than-or-equal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (219,19,'<=>','Syntax\n------\n\n<=>\n\nDescription\n-----------\n\nNULL-safe equal operator. It performs an equality comparison like the =\noperator, but returns 1 rather than NULL if both operands are NULL, and 0\nrather than NULL if one operand is NULL.\n\na <=> b is equivalent to a = b OR (a IS NULL AND b IS NULL).\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) <=> (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a <=> t2.x) AND (t1.b <=> t2.y)\nFROM t1 INNER JOIN t2;\n\nSee also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\n+---------+---------------+------------+\n| 1 <=> 1 | NULL <=> NULL | 1 <=> NULL |\n+---------+---------------+------------+\n|       1 |             1 |          0 |\n+---------+---------------+------------+\n\nSELECT 1 = 1, NULL = NULL, 1 = NULL;\n+-------+-------------+----------+\n| 1 = 1 | NULL = NULL | 1 = NULL |\n+-------+-------------+----------+\n|     1 |        NULL |     NULL |\n+-------+-------------+----------+\n\nURL: https://mariadb.com/kb/en/null-safe-equal/','','https://mariadb.com/kb/en/null-safe-equal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (220,19,'=','Syntax\n------\n\nleft_expr = right_expr\n\nDescription\n-----------\n\nEqual operator. Evaluates both SQL expressions and returns 1 if they are\nequal, 0 if they are not equal, or NULL if either expression is NULL. If the\nexpressions return different data types (for example, a number and a string),\na type conversion is performed.\n\nWhen used in row comparisons these two queries are synonymous and return the\nsame results:\n\nSELECT (t1.a, t1.b) = (t2.x, t2.y) FROM t1 INNER JOIN t2;\n\nSELECT (t1.a = t2.x) AND (t1.b = t2.y) FROM t1 INNER JOIN t2;\n\nTo perform a NULL-safe comparison, use the <=> operator.\n\n= can also be used as an assignment operator.\n\nExamples\n--------\n\nSELECT 1 = 0;\n+-------+\n| 1 = 0 |\n+-------+\n|     0 |\n+-------+\n\nSELECT \'0\' = 0;\n+---------+\n| \'0\' = 0 |\n+---------+\n|       1 |\n+---------+\n\nSELECT \'0.0\' = 0;\n+-----------+\n| \'0.0\' = 0 |\n+-----------+\n|         1 |\n+-----------+\n\nSELECT \'0.01\' = 0;\n+------------+\n| \'0.01\' = 0 |\n+------------+\n|          0 |\n+------------+\n\nSELECT \'.01\' = 0.01;\n+--------------+\n| \'.01\' = 0.01 |\n+--------------+\n|            1 |\n+--------------+\n\nSELECT (5 * 2) = CONCAT(\'1\', \'0\');\n+----------------------------+\n| (5 * 2) = CONCAT(\'1\', \'0\') |\n+----------------------------+\n|                          1 |\n+----------------------------+\n\nSELECT 1 = NULL;\n+----------+\n| 1 = NULL |\n+----------+\n|     NULL |\n+----------+\n\nSELECT NULL = NULL;\n+-------------+\n| NULL = NULL |\n+-------------+\n|        NULL |\n+-------------+\n\nURL: https://mariadb.com/kb/en/equal/','','https://mariadb.com/kb/en/equal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (221,19,'>','Syntax\n------\n\n>\n\nDescription\n-----------\n\nGreater than operator. Evaluates both SQL expressions and returns 1 if the\nleft value is greater than the right value and 0 if it is not, or NULL if\neither expression is NULL. If the expressions return different data types,\n(for instance, a number and a string), performs type conversion.\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) > (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a > t2.x) OR ((t1.a = t2.x) AND (t1.b > t2.y))\nFROM t1 INNER JOIN t2;\n\nExamples\n--------\n\nSELECT 2 > 2;\n+-------+\n| 2 > 2 |\n+-------+\n|     0 |\n+-------+\n\nSELECT \'b\' > \'a\';\n+-----------+\n| \'b\' > \'a\' |\n+-----------+\n|         1 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/greater-than/','','https://mariadb.com/kb/en/greater-than/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (222,19,'>=','Syntax\n------\n\n>=\n\nDescription\n-----------\n\nGreater than or equal operator. Evaluates both SQL expressions and returns 1\nif the left value is greater than or equal to the right value and 0 if it is\nnot, or NULL if either expression is NULL. If the expressions return different\ndata types, (for instance, a number and a string), performs type conversion.\n\nWhen used in row comparisons these two queries return the same results:\n\nSELECT (t1.a, t1.b) >= (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n\nSELECT (t1.a > t2.x) OR ((t1.a = t2.x) AND (t1.b >= t2.y))\nFROM t1 INNER JOIN t2;\n\nExamples\n--------\n\nSELECT 2 >= 2;\n+--------+\n| 2 >= 2 |\n+--------+\n|      1 |\n+--------+\n\nSELECT \'A\' >= \'a\';\n+------------+\n| \'A\' >= \'a\' |\n+------------+\n|          1 |\n+------------+\n\nURL: https://mariadb.com/kb/en/greater-than-or-equal/','','https://mariadb.com/kb/en/greater-than-or-equal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (223,19,'BETWEEN AND','Syntax\n------\n\nexpr BETWEEN min AND max\n\nDescription\n-----------\n\nIf expr is greater than or equal to min and expr is less than or equal to max,\nBETWEEN returns 1, otherwise it returns 0. This is equivalent to the\nexpression (min <= expr AND expr <= max) if all the arguments are of the same\ntype. Otherwise type conversion takes place according to the rules described\nat Type Conversion, but applied to all the three arguments.\n\nExamples\n--------\n\nSELECT 1 BETWEEN 2 AND 3;\n+-------------------+\n| 1 BETWEEN 2 AND 3 |\n+-------------------+\n|                 0 |\n+-------------------+\n\nSELECT \'b\' BETWEEN \'a\' AND \'c\';\n+-------------------------+\n| \'b\' BETWEEN \'a\' AND \'c\' |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSELECT 2 BETWEEN 2 AND \'3\';\n+---------------------+\n| 2 BETWEEN 2 AND \'3\' |\n+---------------------+\n|                   1 |\n+---------------------+\n\nSELECT 2 BETWEEN 2 AND \'x-3\';\n+-----------------------+\n| 2 BETWEEN 2 AND \'x-3\' |\n+-----------------------+\n|                     0 |\n+-----------------------+\n1 row in set, 1 warning (0.00 sec)\n\nWarning (Code 1292): Truncated incorrect DOUBLE value: \'x-3\'\n\nNULL:\n\nSELECT 1 BETWEEN 1 AND NULL;\n+----------------------+\n| 1 BETWEEN 1 AND NULL |\n+----------------------+\n|                 NULL |\n+----------------------+\n\nDATE, DATETIME and TIMESTAMP examples. Omitting the time component compares\nagainst 00:00, so later times on the same date are not returned:\n\nCREATE TABLE `x` (\n a date ,\n b datetime,\n c timestamp\n)\n\nINSERT INTO x VALUES \n (\'2018-11-11\', \'2018-11-11 05:15\', \'2018-11-11 05:15\'), \n (\'2018-11-12\', \'2018-11-12 05:15\', \'2018-11-12 05:15\');\n\nSELECT * FROM x WHERE a BETWEEN \'2018-11-11\' AND \'2018-11-12\';\n+------------+---------------------+---------------------+\n| a          | b                   | c                   |\n+------------+---------------------+---------------------+\n| 2018-11-11 | 2018-11-11 05:15:00 | 2018-11-11 05:15:00 |\n| 2018-11-12 | 2018-11-12 05:15:00 | 2018-11-12 05:15:00 |\n+------------+---------------------+---------------------+\n\nSELECT * FROM x WHERE b BETWEEN \'2018-11-11\' AND \'2018-11-12\';\n+------------+---------------------+---------------------+\n| a          | b                   | c                   |\n+------------+---------------------+---------------------+\n| 2018-11-11 | 2018-11-11 05:15:00 | 2018-11-11 05:15:00 |\n+------------+---------------------+---------------------+\n\nSELECT * FROM x WHERE c BETWEEN \'2018-11-11\' AND \'2018-11-12\';\n+------------+---------------------+---------------------+\n| a          | b                   | c                   |\n+------------+---------------------+---------------------+\n| 2018-11-11 | 2018-11-11 05:15:00 | 2018-11-11 05:15:00 |\n+------------+---------------------+---------------------+\n\nURL: https://mariadb.com/kb/en/between-and/','','https://mariadb.com/kb/en/between-and/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (224,19,'COALESCE','Syntax\n------\n\nCOALESCE(value,...)\n\nDescription\n-----------\n\nReturns the first non-NULL value in the list, or NULL if there are no non-NULL\nvalues. At least one parameter must be passed.\n\nThe function is useful when substituting a default value for null values when\ndisplaying data.\n\nSee also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT COALESCE(NULL,1);\n+------------------+\n| COALESCE(NULL,1) |\n+------------------+\n|                1 |\n+------------------+\n\nSELECT COALESCE(NULL,NULL,NULL);\n+--------------------------+\n| COALESCE(NULL,NULL,NULL) |\n+--------------------------+\n|                     NULL |\n+--------------------------+\n\nWhen two arguments are given, COALESCE() is the same as IFNULL():\n\nSET @a=NULL, @b=1;\n\nSELECT COALESCE(@a, @b), IFNULL(@a, @b);\n+------------------+----------------+\n| COALESCE(@a, @b) | IFNULL(@a, @b) |\n+------------------+----------------+\n|                1 |              1 |\n+------------------+----------------+\n\nHex type confusion:\n\nCREATE TABLE t1 (a INT, b VARCHAR(10));\nINSERT INTO t1 VALUES (0x31, 0x61),(COALESCE(0x31), COALESCE(0x61));\n\nSELECT * FROM t1;\n+------+------+\n| a    | b    |\n+------+------+\n|   49 | a    |\n|    1 | a    |\n+------+------+\n\nThe reason for the differing results above is that when 0x31 is inserted\ndirectly to the column, it\'s treated as a number (see Hexadecimal Literals),\nwhile when 0x31 is passed to COALESCE(), it\'s treated as a string, because:\n\n* HEX values have a string data type by default.\n* COALESCE() has the same data type as the argument.\n\nSubstituting zero for NULL (in this case when the aggregate function returns\nNULL after finding no rows):\n\nSELECT SUM(score) FROM student;\n+------------+\n| SUM(score) |\n+------------+\n|       NULL |\n+------------+\n\nSELECT COALESCE(SUM(score),0) FROM student;\n+------------------------+\n| COALESCE(SUM(score),0) |\n+------------------------+\n|                      0 |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/coalesce/','','https://mariadb.com/kb/en/coalesce/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (225,19,'GREATEST','Syntax\n------\n\nGREATEST(value1,value2,...)\n\nDescription\n-----------\n\nWith two or more arguments, returns the largest (maximum-valued) argument. The\narguments are compared using the same rules as for LEAST().\n\nExamples\n--------\n\nSELECT GREATEST(2,0);\n+---------------+\n| GREATEST(2,0) |\n+---------------+\n|             2 |\n+---------------+\n\nSELECT GREATEST(34.0,3.0,5.0,767.0);\n+------------------------------+\n| GREATEST(34.0,3.0,5.0,767.0) |\n+------------------------------+\n|                        767.0 |\n+------------------------------+\n\nSELECT GREATEST(\'B\',\'A\',\'C\');\n+-----------------------+\n| GREATEST(\'B\',\'A\',\'C\') |\n+-----------------------+\n| C                     |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/greatest/','','https://mariadb.com/kb/en/greatest/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (226,19,'IN','Syntax\n------\n\nexpr IN (value,...)\n\nDescription\n-----------\n\nReturns 1 if expr is equal to any of the values in the IN list, else returns\n0. If all values are constants, they are evaluated according to the type of\nexpr and sorted. The search for the item then is done using a binary search.\nThis means IN is very quick if the IN value list consists entirely of\nconstants. Otherwise, type conversion takes place according to the rules\ndescribed at Type Conversion, but applied to all the arguments.\n\nIf expr is NULL, IN always returns NULL. If at least one of the values in the\nlist is NULL, and one of the comparisons is true, the result is 1. If at least\none of the values in the list is NULL and none of the comparisons is true, the\nresult is NULL.\n\nExamples\n--------\n\nSELECT 2 IN (0,3,5,7);\n+----------------+\n| 2 IN (0,3,5,7) |\n+----------------+\n|              0 |\n+----------------+\n\nSELECT \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\');\n+----------------------------------+\n| \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\') |\n+----------------------------------+\n|                                1 |\n+----------------------------------+\n\nType conversion:\n\nSELECT 1 IN (\'1\', \'2\', \'3\');\n+----------------------+\n| 1 IN (\'1\', \'2\', \'3\') |\n+----------------------+\n|                    1 |\n+----------------------+\n\nSELECT NULL IN (1, 2, 3);\n+-------------------+\n| NULL IN (1, 2, 3) |\n+-------------------+\n|              NULL |\n+-------------------+\n\nSELECT 1 IN (1, 2, NULL);\n+-------------------+\n| 1 IN (1, 2, NULL) |\n+-------------------+\n|                 1 |\n+-------------------+\n\nSELECT 5 IN (1, 2, NULL);\n+-------------------+\n| 5 IN (1, 2, NULL) |\n+-------------------+\n|              NULL |\n+-------------------+\n\nURL: https://mariadb.com/kb/en/in/','','https://mariadb.com/kb/en/in/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (227,19,'INTERVAL','Syntax\n------\n\nINTERVAL(N,N1,N2,N3,...)\n\nDescription\n-----------\n\nReturns the index of the last argument that is less than the first argument or\nis NULL.\n\nReturns 0 if N < N1, 1 if N < N2, 2 if N < N3 and so on or -1 if N is NULL.\nAll arguments are treated as integers. It is required that N1 < N2 < N3 < ...\n< Nn for this function to work correctly. This is because a fast binary search\nis used.\n\nExamples\n--------\n\nSELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\n+--------------------------------------+\n| INTERVAL(23, 1, 15, 17, 30, 44, 200) |\n+--------------------------------------+\n|                                    3 |\n+--------------------------------------+\n\nSELECT INTERVAL(10, 1, 10, 100, 1000);\n+--------------------------------+\n| INTERVAL(10, 1, 10, 100, 1000) |\n+--------------------------------+\n|                              2 |\n+--------------------------------+\n\nSELECT INTERVAL(22, 23, 30, 44, 200);\n+-------------------------------+\n| INTERVAL(22, 23, 30, 44, 200) |\n+-------------------------------+\n|                             0 |\n+-------------------------------+\n\nSELECT INTERVAL(10, 2, NULL);\n+-----------------------+\n| INTERVAL(10, 2, NULL) |\n+-----------------------+\n|                     2 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/interval/','','https://mariadb.com/kb/en/interval/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (228,19,'IS','Syntax\n------\n\nIS boolean_value\n\nDescription\n-----------\n\nTests a value against a boolean value, where boolean_value can be TRUE, FALSE,\nor UNKNOWN.\n\nThere is an important difference between using IS TRUE or comparing a value\nwith TRUE using =. When using =, only 1 equals to TRUE. But when using IS\nTRUE, all values which are logically true (like a number > 1) return TRUE.\n\nExamples\n--------\n\nSELECT 1 IS TRUE, 0 IS FALSE, NULL IS UNKNOWN;\n+-----------+------------+-----------------+\n| 1 IS TRUE | 0 IS FALSE | NULL IS UNKNOWN |\n+-----------+------------+-----------------+\n|         1 |          1 |               1 |\n+-----------+------------+-----------------+\n\nDifference between = and IS TRUE:\n\nSELECT 2 = TRUE, 2 IS TRUE;\n+----------+-----------+\n| 2 = TRUE | 2 IS TRUE |\n+----------+-----------+\n|        0 |         1 |\n+----------+-----------+\n\nURL: https://mariadb.com/kb/en/is/','','https://mariadb.com/kb/en/is/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (229,19,'IS NOT','Syntax\n------\n\nIS NOT boolean_value\n\nDescription\n-----------\n\nTests a value against a boolean value, where boolean_value can be TRUE, FALSE,\nor UNKNOWN.\n\nExamples\n--------\n\nSELECT 1 IS NOT UNKNOWN, 0 IS NOT UNKNOWN, NULL IS NOT UNKNOWN;\n+------------------+------------------+---------------------+\n| 1 IS NOT UNKNOWN | 0 IS NOT UNKNOWN | NULL IS NOT UNKNOWN |\n+------------------+------------------+---------------------+\n|                1 |                1 |                   0 |\n+------------------+------------------+---------------------+\n\nSELECT NULL IS NOT TRUE, NULL IS NOT FALSE;\n+------------------+-------------------+\n| NULL IS NOT TRUE | NULL IS NOT FALSE |\n+------------------+-------------------+\n|                1 |                 1 |\n+------------------+-------------------+\n\nURL: https://mariadb.com/kb/en/is-not/','','https://mariadb.com/kb/en/is-not/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (230,19,'IS NOT NULL','Syntax\n------\n\nIS NOT NULL\n\nDescription\n-----------\n\nTests whether a value is not NULL. See also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n+---------------+---------------+------------------+\n| 1 IS NOT NULL | 0 IS NOT NULL | NULL IS NOT NULL |\n+---------------+---------------+------------------+\n|             1 |             1 |                0 |\n+---------------+---------------+------------------+\n\nURL: https://mariadb.com/kb/en/is-not-null/','','https://mariadb.com/kb/en/is-not-null/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (231,19,'IS NULL','Syntax\n------\n\nIS NULL\n\nDescription\n-----------\n\nTests whether a value is NULL. See also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n+-----------+-----------+--------------+\n| 1 IS NULL | 0 IS NULL | NULL IS NULL |\n+-----------+-----------+--------------+\n|         0 |         0 |            1 |\n+-----------+-----------+--------------+\n\nCompatibility\n-------------\n\nSome ODBC applications use the syntax auto_increment_field IS NOT NULL to find\nthe latest row that was inserted with an autogenerated key value. If your\napplications need this, you can set the sql_auto_is_null variable to 1.\n\nSET @@sql_auto_is_null=1;\nCREATE TABLE t1 (auto_increment_column INT NOT NULL AUTO_INCREMENT PRIMARY\nKEY);\nINSERT INTO t1 VALUES (NULL);\nSELECT * FROM t1 WHERE auto_increment_column IS NULL;\n\n+-----------------------+\n| auto_increment_column |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/is-null/','','https://mariadb.com/kb/en/is-null/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (232,19,'ISNULL','Syntax\n------\n\nISNULL(expr)\n\nDescription\n-----------\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n\nSee also NULL Values in MariaDB.\n\nExamples\n--------\n\nSELECT ISNULL(1+1);\n+-------------+\n| ISNULL(1+1) |\n+-------------+\n|           0 |\n+-------------+\n\nSELECT ISNULL(1/0);\n+-------------+\n| ISNULL(1/0) |\n+-------------+\n|           1 |\n+-------------+\n\nURL: https://mariadb.com/kb/en/isnull/','','https://mariadb.com/kb/en/isnull/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (233,19,'LEAST','Syntax\n------\n\nLEAST(value1,value2,...)\n\nDescription\n-----------\n\nWith two or more arguments, returns the smallest (minimum-valued) argument.\nThe arguments are compared using the following rules:\n\n* If the return value is used in an INTEGER context or all arguments are\ninteger-valued, they are compared as integers.\n* If the return value is used in a REAL context or all arguments are\nreal-valued, they are compared as reals.\n* If any argument is a case-sensitive string, the arguments are compared as\ncase-sensitive strings.\n* In all other cases, the arguments are compared as case-insensitive strings.\n\nLEAST() returns NULL if any argument is NULL.\n\nExamples\n--------\n\nSELECT LEAST(2,0);\n+------------+\n| LEAST(2,0) |\n+------------+\n|          0 |\n+------------+\n\nSELECT LEAST(34.0,3.0,5.0,767.0);\n+---------------------------+\n| LEAST(34.0,3.0,5.0,767.0) |\n+---------------------------+\n|                       3.0 |\n+---------------------------+\n\nSELECT LEAST(\'B\',\'A\',\'C\');\n+--------------------+\n| LEAST(\'B\',\'A\',\'C\') |\n+--------------------+\n| A                  |\n+--------------------+\n\nURL: https://mariadb.com/kb/en/least/','','https://mariadb.com/kb/en/least/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (234,19,'NOT BETWEEN','Syntax\n------\n\nexpr NOT BETWEEN min AND max\n\nDescription\n-----------\n\nThis is the same as NOT (expr BETWEEN min AND max).\n\nNote that the meaning of the alternative form NOT expr BETWEEN min AND max is\naffected by the HIGH_NOT_PRECEDENCE SQL_MODE flag.\n\nExamples\n--------\n\nSELECT 1 NOT BETWEEN 2 AND 3;\n+-----------------------+\n| 1 NOT BETWEEN 2 AND 3 |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSELECT \'b\' NOT BETWEEN \'a\' AND \'c\';\n+-----------------------------+\n| \'b\' NOT BETWEEN \'a\' AND \'c\' |\n+-----------------------------+\n|                           0 |\n+-----------------------------+\n\nNULL:\n\nSELECT 1 NOT BETWEEN 1 AND NULL;\n+--------------------------+\n| 1 NOT BETWEEN 1 AND NULL |\n+--------------------------+\n|                     NULL |\n+--------------------------+\n\nURL: https://mariadb.com/kb/en/not-between/','','https://mariadb.com/kb/en/not-between/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (235,19,'NOT IN','Syntax\n------\n\nexpr NOT IN (value,...)\n\nDescription\n-----------\n\nThis is the same as NOT (expr IN (value,...)).\n\nExamples\n--------\n\nSELECT 2 NOT IN (0,3,5,7);\n+--------------------+\n| 2 NOT IN (0,3,5,7) |\n+--------------------+\n|                  1 |\n+--------------------+\n\nSELECT \'wefwf\' NOT IN (\'wee\',\'wefwf\',\'weg\');\n+--------------------------------------+\n| \'wefwf\' NOT IN (\'wee\',\'wefwf\',\'weg\') |\n+--------------------------------------+\n|                                    0 |\n+--------------------------------------+\n\nSELECT 1 NOT IN (\'1\', \'2\', \'3\');\n+--------------------------+\n| 1 NOT IN (\'1\', \'2\', \'3\') |\n+--------------------------+\n|                        0 |\n+--------------------------+\n\nNULL:\n\nSELECT NULL NOT IN (1, 2, 3);\n+-----------------------+\n| NULL NOT IN (1, 2, 3) |\n+-----------------------+\n|                  NULL |\n+-----------------------+\n\nSELECT 1 NOT IN (1, 2, NULL);\n+-----------------------+\n| 1 NOT IN (1, 2, NULL) |\n+-----------------------+\n|                     0 |\n+-----------------------+\n\nSELECT 5 NOT IN (1, 2, NULL);\n+-----------------------+\n| 5 NOT IN (1, 2, NULL) |\n+-----------------------+\n|                  NULL |\n+-----------------------+\n\nURL: https://mariadb.com/kb/en/not-in/','','https://mariadb.com/kb/en/not-in/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (236,20,'&','Syntax\n------\n\n&\n\nDescription\n-----------\n\nBitwise AND. Converts the values to binary and compares bits. Only if both the\ncorresponding bits are 1 is the resulting bit also 1.\n\nSee also bitwise OR.\n\nExamples\n--------\n\nSELECT 2&1;\n+-----+\n| 2&1 |\n+-----+\n|   0 |\n+-----+\n\nSELECT 3&1;\n+-----+\n| 3&1 |\n+-----+\n|   1 |\n+-----+\n\nSELECT 29 & 15;\n+---------+\n| 29 & 15 |\n+---------+\n|      13 |\n+---------+\n\nURL: https://mariadb.com/kb/en/bitwise_and/','','https://mariadb.com/kb/en/bitwise_and/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (237,20,'<<','Syntax\n------\n\nvalue1 << value2\n\nDescription\n-----------\n\nConverts a longlong (BIGINT) number (value1) to binary and shifts value2 units\nto the left.\n\nExamples\n--------\n\nSELECT 1 << 2;\n+--------+\n| 1 << 2 |\n+--------+\n|      4 |\n+--------+\n\nURL: https://mariadb.com/kb/en/shift-left/','','https://mariadb.com/kb/en/shift-left/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (238,20,'>>','Syntax\n------\n\nvalue1 >> value2\n\nDescription\n-----------\n\nConverts a longlong (BIGINT) number (value1) to binary and shifts value2 units\nto the right.\n\nExamples\n--------\n\nSELECT 4 >> 2;\n+--------+\n| 4 >> 2 |\n+--------+\n|      1 |\n+--------+\n\nURL: https://mariadb.com/kb/en/shift-right/','','https://mariadb.com/kb/en/shift-right/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (239,20,'BIT_COUNT','Syntax\n------\n\nBIT_COUNT(N)\n\nDescription\n-----------\n\nReturns the number of bits that are set in the argument N.\n\nExamples\n--------\n\nSELECT BIT_COUNT(29), BIT_COUNT(b\'101010\');\n+---------------+----------------------+\n| BIT_COUNT(29) | BIT_COUNT(b\'101010\') |\n+---------------+----------------------+\n|             4 |                    3 |\n+---------------+----------------------+\n\nURL: https://mariadb.com/kb/en/bit_count/','','https://mariadb.com/kb/en/bit_count/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (240,20,'^','Syntax\n------\n\n^\n\nDescription\n-----------\n\nBitwise XOR. Converts the values to binary and compares bits. If one (and only\none) of the corresponding bits is 1 is the resulting bit also 1.\n\nExamples\n--------\n\nSELECT 1 ^ 1;\n+-------+\n| 1 ^ 1 |\n+-------+\n|     0 |\n+-------+\n\nSELECT 1 ^ 0;\n+-------+\n| 1 ^ 0 |\n+-------+\n|     1 |\n+-------+\n\nSELECT 11 ^ 3;\n+--------+\n| 11 ^ 3 |\n+--------+\n|      8 |\n+--------+\n\nURL: https://mariadb.com/kb/en/bitwise-xor/','','https://mariadb.com/kb/en/bitwise-xor/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (241,20,'|','Syntax\n------\n\n|\n\nDescription\n-----------\n\nBitwise OR. Converts the values to binary and compares bits. If either of the\ncorresponding bits has a value of 1, the resulting bit is also 1.\n\nSee also bitwise AND.\n\nExamples\n--------\n\nSELECT 2|1;\n+-----+\n| 2|1 |\n+-----+\n|   3 |\n+-----+\n\nSELECT 29 | 15;\n+---------+\n| 29 | 15 |\n+---------+\n|      31 |\n+---------+\n\nURL: https://mariadb.com/kb/en/bitwise-or/','','https://mariadb.com/kb/en/bitwise-or/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (242,20,'~','Syntax\n------\n\n~\n\nDescription\n-----------\n\nBitwise NOT. Converts the value to 4 bytes binary and inverts all bits.\n\nExamples\n--------\n\nSELECT 3 & ~1;\n+--------+\n| 3 & ~1 |\n+--------+\n|      2 |\n+--------+\n\nSELECT 5 & ~1;\n+--------+\n| 5 & ~1 |\n+--------+\n|      4 |\n+--------+\n\nURL: https://mariadb.com/kb/en/bitwise-not/','','https://mariadb.com/kb/en/bitwise-not/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (243,20,'Parentheses','Parentheses are sometimes called precedence operators - this means that they\ncan be used to change the other operator\'s precedence in an expression. The\nexpressions that are written between parentheses are computed before the\nexpressions that are written outside. Parentheses must always contain an\nexpression (that is, they cannot be empty), and can be nested.\n\nFor example, the following expressions could return different results:\n\n* NOT a OR b\n* NOT (a OR b)\n\nIn the first case, NOT applies to a, so if a is FALSE or b is TRUE, the\nexpression returns TRUE. In the second case, NOT applies to the result of a OR\nb, so if at least one of a or b is TRUE, the expression is TRUE.\n\nWhen the precedence of operators is not intuitive, you can use parentheses to\nmake it immediately clear for whoever reads the statement.\n\nThe precedence of the NOT operator can also be affected by the\nHIGH_NOT_PRECEDENCE SQL_MODE flag.\n\nOther uses\n----------\n\nParentheses must always be used to enclose subqueries.\n\nParentheses can also be used in a JOIN statement between multiple tables to\ndetermine which tables must be joined first.\n\nAlso, parentheses are used to enclose the list of parameters to be passed to\nbuilt-in functions, user-defined functions and stored routines. However, when\nno parameter is passed to a stored procedure, parentheses are optional. For\nbuiltin functions and user-defined functions, spaces are not allowed between\nthe function name and the open parenthesis, unless the IGNORE_SPACE SQL_MODE\nis set. For stored routines (and for functions if IGNORE_SPACE is set) spaces\nare allowed before the open parenthesis, including tab characters and new line\ncharacters.\n\nSyntax errors\n-------------\n\nIf there are more open parentheses than closed parentheses, the error usually\nlooks like this:\n\nERROR 1064 (42000): You have an error in your SQL syntax; check the manual that\ncorresponds to your MariaDB server version for the right syntax to use near \'\'\na\nt line 1\n\nNote the empty string.\n\nIf there are more closed parentheses than open parentheses, the error usually\nlooks like this:\n\nERROR 1064 (42000): You have an error in your SQL syntax; check the manual that\ncorresponds to your MariaDB server version for the right syntax to use near \')\'\nat line 1\n\nNote the quoted closed parenthesis.\n\nURL: https://mariadb.com/kb/en/parentheses/','','https://mariadb.com/kb/en/parentheses/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (244,20,'TRUE FALSE','Description\n-----------\n\nThe constants TRUE and FALSE evaluate to 1 and 0, respectively. The constant\nnames can be written in any lettercase.\n\nExamples\n--------\n\nSELECT TRUE, true, FALSE, false;\n+------+------+-------+-------+\n| TRUE | TRUE | FALSE | FALSE |\n+------+------+-------+-------+\n|    1 |    1 |     0 |     0 |\n+------+------+-------+-------+\n\nURL: https://mariadb.com/kb/en/true-false/','','https://mariadb.com/kb/en/true-false/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (245,21,'ANALYZE TABLE','Syntax\n------\n\nANALYZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE tbl_name [,tbl_name ...]\n [PERSISTENT FOR\n  { ALL\n   | COLUMNS ([col_name [,col_name ...]]) INDEXES ([index_name [,index_name\n...]])\n  }\n ]\n\nDescription\n-----------\n\nANALYZE TABLE analyzes and stores the key distribution for a table (index\nstatistics). This statement works with MyISAM, Aria and InnoDB tables. During\nthe analysis, InnoDB will allow reads/writes, and MyISAM/Aria reads/inserts.\nFor MyISAM tables, this statement is equivalent to using myisamchk --analyze.\n\nFor more information on how the analysis works within InnoDB, see InnoDB\nLimitations.\n\nMariaDB uses the stored key distribution to decide the order in which tables\nshould be joined when you perform a join on something other than a constant.\nIn addition, key distributions can be used when deciding which indexes to use\nfor a specific table within a query.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nBy default, ANALYZE TABLE statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nFrom MariaDB 10.3.19, ANALYZE TABLE statements are not logged to the binary\nlog if read_only is set. See also Read-Only Replicas.\n\nANALYZE TABLE is also supported for partitioned tables. You can use ALTER\nTABLE ... ANALYZE PARTITION to analyze one or more partitions.\n\nThe Aria storage engine supports progress reporting for the ANALYZE TABLE\nstatement.\n\nEngine-Independent Statistics\n-----------------------------\n\nANALYZE TABLE supports engine-independent statistics. See Engine-Independent\nTable Statistics: Collecting Statistics with the ANALYZE TABLE Statement for\nmore information.\n\nUseful Variables\n----------------\n\nFor calculating the number of duplicates, ANALYZE TABLE uses a buffer of\nsort_buffer_size bytes per column. You can slightly increase the speed of\nANALYZE TABLE by increasing this variable.\n\nExamples\n--------\n\n-- update all engine-independent statistics for all columns and indexes\nANALYZE TABLE tbl PERSISTENT FOR ALL;\n\n-- update specific columns and indexes:\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS (col1,col2,...) INDEXES\n(idx1,idx2,...);\n\n-- empty lists are allowed:\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS (col1,col2,...) INDEXES ();\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS () INDEXES (idx1,idx2,...);\n\n-- the following will only update mysql.table_stats fields:\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS () INDEXES ();\n\n-- when use_stat_tables is set to \'COMPLEMENTARY\' or \'PREFERABLY\', \n-- a simple ANALYZE TABLE  collects engine-independent statistics for all\ncolumns and indexes.\nSET SESSION use_stat_tables=\'COMPLEMENTARY\';\nANALYZE TABLE tbl;\n\nURL: https://mariadb.com/kb/en/analyze-table/','','https://mariadb.com/kb/en/analyze-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (246,21,'CHECK TABLE','Syntax\n------\n\nCHECK TABLE tbl_name [, tbl_name] ... [option] ...\n\noption = {FOR UPGRADE | QUICK | FAST | MEDIUM | EXTENDED | CHANGED}\n\nDescription\n-----------\n\nCHECK TABLE checks a table or tables for errors. CHECK TABLE works for\nArchive, Aria, CSV, InnoDB and MyISAM tables. For Aria and MyISAM tables, the\nkey statistics are updated as well. For CSV, see also Checking and Repairing\nCSV Tables.\n\nAs an alternative, myisamchk is a commandline tool for checking MyISAM tables\nwhen the tables are not being accessed. For Aria tables, there is a similar\ntool: aria_chk.\n\nFor checking dynamic columns integrity, COLUMN_CHECK() can be used.\n\nCHECK TABLE can also check views for problems, such as tables that are\nreferenced in the view definition that no longer exist.\n\nCHECK TABLE is also supported for partitioned tables. You can use ALTER TABLE\n... CHECK PARTITION to check one or more partitions.\n\nThe meaning of the different options are as follows - note that this can vary\na bit between storage engines:\n\n+-----+----------------------------------------------------------------------+\n| FOR | Do a very quick check if the storage format for the table has        |\n| UPG | changed so that one needs to do a REPAIR. This is only needed when   |\n| ADE | one upgrades between major versions of MariaDB or MySQL. This is     |\n|     | usually done by running mariadb-upgrade.                             |\n+-----+----------------------------------------------------------------------+\n| FAS | Only check tables that has not been closed properly or are marked    |\n|     | as corrupt. Only supported by the MyISAM and Aria engines. For       |\n|     | other engines the table is checked normally                          |\n+-----+----------------------------------------------------------------------+\n| CHA | Check only tables that has changed since last REPAIR / CHECK. Only   |\n| GED | supported by the MyISAM and Aria engines. For other engines the      |\n|     | table is checked normally.                                           |\n+-----+----------------------------------------------------------------------+\n| QUI | Do a fast check. For MyISAM and Aria, this means skipping the check  |\n| K   | of the delete link chain, which may take some time.                  |\n+-----+----------------------------------------------------------------------+\n| MED | Scan also the data files. Checks integrity between data and index    |\n| UM  | files with checksums. In most cases this should find all possible    |\n|     | errors.                                                              |\n+-----+----------------------------------------------------------------------+\n| EXT | Does a full check to verify every possible error. For InnoDB, Aria,  |\n| NDE | and MyISAM, verify for each row that all its keys exists, and for    |\n|     | those index keys, they point back to the primary clustered key.      |\n|     | This may take a long time on large tables. This option was           |\n|     | previously ignored by InnoDB before MariaDB 10.6.11, MariaDB         |\n|     | 10.7.7, MariaDB 10.8.6 and MariaDB 10.9.4.                           |\n+-----+----------------------------------------------------------------------+\n\nFor most cases running CHECK TABLE without options or MEDIUM should be good\nenough.\n\nThe Aria storage engine supports progress reporting for this statement.\n\nIf you want to know if two tables are identical, take a look at CHECKSUM TABLE.\n\nInnoDB\n------\n\nIf CHECK TABLE finds an error in an InnoDB table, MariaDB might shutdown to\nprevent the error propagation. In this case, the problem will be reported in\nthe error log. Otherwise the table or an index might be marked as corrupted,\nto prevent use. This does not happen with some minor problems, like a wrong\nnumber of entries in a secondary index. Those problems are reported in the\noutput of CHECK TABLE.\n\nEach tablespace contains a header with metadata. This header is not checked by\nthis statement.\n\nDuring the execution of CHECK TABLE, other threads may be blocked.\n\nURL: https://mariadb.com/kb/en/check-table/','','https://mariadb.com/kb/en/check-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (247,21,'CHECK VIEW','Syntax\n------\n\nCHECK VIEW view_name\n\nDescription\n-----------\n\nThe CHECK VIEW statement was introduced in MariaDB 10.0.18 to assist with\nfixing MDEV-6916, an issue introduced in MariaDB 5.2 where the view algorithms\nwere swapped. It checks whether the view algorithm is correct. It is run as\npart of mariadb-upgrade, and should not normally be required in regular use.\n\nURL: https://mariadb.com/kb/en/check-view/','','https://mariadb.com/kb/en/check-view/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (248,21,'CHECKSUM TABLE','Syntax\n------\n\nCHECKSUM TABLE tbl_name [, tbl_name] ... [ QUICK | EXTENDED ]\n\nDescription\n-----------\n\nCHECKSUM TABLE reports a table checksum. This is very useful if you want to\nknow if two tables are the same (for example on a master and slave).\n\nWith QUICK, the live table checksum is reported if it is available, or NULL\notherwise. This is very fast. A live checksum is enabled by specifying the\nCHECKSUM=1 table option when you create the table; currently, this is\nsupported only for Aria and MyISAM tables.\n\nWith EXTENDED, the entire table is read row by row and the checksum is\ncalculated. This can be very slow for large tables.\n\nIf neither QUICK nor EXTENDED is specified, MariaDB returns a live checksum if\nthe table storage engine supports it and scans the table otherwise.\n\nCHECKSUM TABLE requires the SELECT privilege for the table.\n\nFor a nonexistent table, CHECKSUM TABLE returns NULL and generates a warning.\n\nThe table row format affects the checksum value. If the row format changes,\nthe checksum will change. This means that when a table created with a\nMariaDB/MySQL version is upgraded to another version, the checksum value will\nprobably change.\n\nTwo identical tables should always match to the same checksum value; however,\nalso for non-identical tables there is a very slight chance that they will\nreturn the same value as the hashing algorithm is not completely\ncollision-free.\n\nIdentical Tables\n----------------\n\nIdentical tables mean that the CREATE statement is identical and that the\nfollowing variable, which affects the storage formats, was the same when the\ntables were created:\n\n* mysql56-temporal-format\n\nDifferences Between MariaDB and MySQL\n-------------------------------------\n\nCHECKSUM TABLE may give a different result as MariaDB doesn\'t ignore NULLs in\nthe columns as MySQL 5.1 does (Later MySQL versions should calculate checksums\nthe same way as MariaDB). You can get the \'old style\' checksum in MariaDB by\nstarting mysqld with the --old option. Note however that that the MyISAM and\nAria storage engines in MariaDB are using the new checksum internally, so if\nyou are using --old, the CHECKSUM command will be slower as it needs to\ncalculate the checksum row by row. Starting from MariaDB Server 10.9, --old is\ndeprecated and will be removed in a future release. Set --old-mode or OLD_MODE\nto COMPAT_5_1_CHECKSUM to get \'old style\' checksum.\n\nURL: https://mariadb.com/kb/en/checksum-table/','','https://mariadb.com/kb/en/checksum-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (249,21,'OPTIMIZE TABLE','Syntax\n------\n\nOPTIMIZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n  tbl_name [, tbl_name] ...\n  [WAIT n | NOWAIT]\n\nDescription\n-----------\n\nOPTIMIZE TABLE has two main functions. It can either be used to defragment\ntables, or to update the InnoDB fulltext index.\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nDefragmenting\n-------------\n\nOPTIMIZE TABLE works for InnoDB (before MariaDB 10.1.1, only if the\ninnodb_file_per_table server system variable is set), Aria, MyISAM and ARCHIVE\ntables, and should be used if you have deleted a large part of a table or if\nyou have made many changes to a table with variable-length rows (tables that\nhave VARCHAR, VARBINARY, BLOB, or TEXT columns). Deleted rows are maintained\nin a linked list and subsequent INSERT operations reuse old row positions.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nBy default, OPTIMIZE TABLE statements are written to the binary log and will\nbe replicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure\nthe statement is not written to the binary log.\n\nOPTIMIZE TABLE statements are not logged to the binary log if read_only is\nset. See also Read-Only Replicas.\n\nOPTIMIZE TABLE is also supported for partitioned tables. You can use ALTER\nTABLE ... OPTIMIZE PARTITION to optimize one or more partitions.\n\nYou can use OPTIMIZE TABLE to reclaim the unused space and to defragment the\ndata file. With other storage engines, OPTIMIZE TABLE does nothing by default,\nand returns this message: \" The storage engine for the table doesn\'t support\noptimize\". However, if the server has been started with the --skip-new option,\nOPTIMIZE TABLE is linked to ALTER TABLE, and recreates the table. This\noperation frees the unused space and updates index statistics.\n\nThe Aria storage engine supports progress reporting for this statement.\n\nIf a MyISAM table is fragmented, concurrent inserts will not be performed\nuntil an OPTIMIZE TABLE statement is executed on that table, unless the\nconcurrent_insert server system variable is set to ALWAYS.\n\nUpdating an InnoDB fulltext index\n---------------------------------\n\nWhen rows are added or deleted to an InnoDB fulltext index, the index is not\nimmediately re-organized, as this can be an expensive operation. Change\nstatistics are stored in a separate location . The fulltext index is only\nfully re-organized when an OPTIMIZE TABLE statement is run.\n\nBy default, an OPTIMIZE TABLE will defragment a table. In order to use it to\nupdate fulltext index statistics, the innodb_optimize_fulltext_only system\nvariable must be set to 1. This is intended to be a temporary setting, and\nshould be reset to 0 once the fulltext index has been re-organized.\n\nSince fulltext re-organization can take a long time, the\ninnodb_ft_num_word_optimize variable limits the re-organization to a number of\nwords (2000 by default). You can run multiple OPTIMIZE statements to fully\nre-organize the index.\n\nDefragmenting InnoDB tablespaces\n--------------------------------\n\nMariaDB 10.1.1 merged the Facebook/Kakao defragmentation patch, allowing one\nto use OPTIMIZE TABLE to defragment InnoDB tablespaces. For this functionality\nto be enabled, the innodb_defragment system variable must be enabled. No new\ntables are created and there is no need to copy data from old tables to new\ntables. Instead, this feature loads n pages (determined by\ninnodb-defragment-n-pages) and tries to move records so that pages would be\nfull of records and then frees pages that are fully empty after the operation.\nNote that tablespace files (including ibdata1) will not shrink as the result\nof defragmentation, but one will get better memory utilization in the InnoDB\nbuffer pool as there are fewer data pages in use.\n\nSee Defragmenting InnoDB Tablespaces for more details.\n\nURL: https://mariadb.com/kb/en/optimize-table/','','https://mariadb.com/kb/en/optimize-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (250,21,'REPAIR TABLE','Syntax\n------\n\nREPAIR [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n  tbl_name [, tbl_name] ...\n  [QUICK] [EXTENDED] [USE_FRM]\n\nDescription\n-----------\n\nREPAIR TABLE repairs a possibly corrupted table. By default, it has the same\neffect as\n\nmyisamchk --recover tbl_name\n\nor\n\naria_chk --recover tbl_name\n\nSee aria_chk and myisamchk for more.\n\nREPAIR TABLE works for Archive, Aria, CSV and MyISAM tables. For InnoDB, see\nrecovery modes. For CSV, see also Checking and Repairing CSV Tables. For\nArchive, this statement also improves compression. If the storage engine does\nnot support this statement, a warning is issued.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nBy default, REPAIR TABLE statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nFrom MariaDB 10.3.19, REPAIR TABLE statements are not logged to the binary log\nif read_only is set. See also Read-Only Replicas.\n\nWhen an index is recreated, the storage engine may use a configurable buffer\nin the process. Incrementing the buffer speeds up the index creation. Aria and\nMyISAM allocate a buffer whose size is defined by aria_sort_buffer_size or\nmyisam_sort_buffer_size, also used for ALTER TABLE.\n\nREPAIR TABLE is also supported for partitioned tables. However, the USE_FRM\noption cannot be used with this statement on a partitioned table.\n\nALTER TABLE ... REPAIR PARTITION can be used to repair one or more partitions.\n\nThe Aria storage engine supports progress reporting for this statement.\n\nURL: https://mariadb.com/kb/en/repair-table/','','https://mariadb.com/kb/en/repair-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (251,21,'REPAIR VIEW','Syntax\n------\n\nREPAIR [NO_WRITE_TO_BINLOG | LOCAL] VIEW  view_name[, view_name] ... [FROM\nMYSQL]\n\nDescription\n-----------\n\nThe REPAIR VIEW statement was introduced to assist with fixing MDEV-6916, an\nissue introduced in MariaDB 5.2 where the view algorithms were swapped\ncompared to their MySQL on disk representation. It checks whether the view\nalgorithm is correct. It is run as part of mariadb-upgrade, and should not\nnormally be required in regular use.\n\nBy default it corrects the checksum and if necessary adds the mariadb-version\nfield. If the optional FROM MYSQL clause is used, and no mariadb-version field\nis present, the MERGE and TEMPTABLE algorithms are toggled.\n\nBy default, REPAIR VIEW statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nURL: https://mariadb.com/kb/en/repair-view/','','https://mariadb.com/kb/en/repair-view/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (252,22,'mysql.func Table','The mysql.func table stores information about user-defined functions (UDFs)\ncreated with the CREATE FUNCTION UDF statement.\n\nMariaDB starting with 10.4\n--------------------------\nIn MariaDB 10.4 and later, this table uses the Aria storage engine.\n\nMariaDB until 10.3\n------------------\nIn MariaDB 10.3 and before, this table uses the MyISAM storage engine.\n\nThe mysql.func table contains the following fields:\n\n+----------+---------+---------+-------+--------------+---------------------+\n| Field    | Type    | Null    | Key   | Default      | Description         |\n+----------+---------+---------+-------+--------------+---------------------+\n| name     | char(64 | NO      | PRI   |              | UDF name            |\n|          |         |         |       |              |                     |\n+----------+---------+---------+-------+--------------+---------------------+\n| ret      | tinyint | NO      |       | 0            |                     |\n|          | 1)      |         |       |              |                     |\n+----------+---------+---------+-------+--------------+---------------------+\n| dl       | char(12 | NO      |       |              | Shared library name |\n|          | )       |         |       |              |                     |\n+----------+---------+---------+-------+--------------+---------------------+\n| type     | enum(\'f | NO      |       | NULL         | Type, either        |\n|          | nction\' |         |       |              | function or         |\n|          | \'aggreg |         |       |              | aggregate.          |\n|          | te\')    |         |       |              | Aggregate           |\n|          |         |         |       |              | functions are       |\n|          |         |         |       |              | summary functions   |\n|          |         |         |       |              | such as SUM() and   |\n|          |         |         |       |              | AVG().              |\n+----------+---------+---------+-------+--------------+---------------------+\n\nExample\n-------\n\nSELECT * FROM mysql.func;\n+------------------------------+-----+--------------+-----------+\n| name                         | ret | dl           | type      |\n+------------------------------+-----+--------------+-----------+\n| spider_direct_sql            |   2 | ha_spider.so | function  |\n| spider_bg_direct_sql         |   2 | ha_spider.so | aggregate |\n| spider_ping_table            |   2 | ha_spider.so | function  |\n| spider_copy_tables           |   2 | ha_spider.so | function  |\n| spider_flush_table_mon_cache |   2 | ha_spider.so | function  |\n+------------------------------+-----+--------------+-----------+\n\nURL: https://mariadb.com/kb/en/mysqlfunc-table/','','https://mariadb.com/kb/en/mysqlfunc-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (253,22,'CREATE FUNCTION UDF','Syntax\n------\n\nCREATE [OR REPLACE] [AGGREGATE] FUNCTION [IF NOT EXISTS] function_name\n  RETURNS {STRING|INTEGER|REAL|DECIMAL}\n  SONAME shared_library_name\n\nDescription\n-----------\n\nA user-defined function (UDF) is a way to extend MariaDB with a new function\nthat works like a native (built-in) MariaDB function such as ABS() or CONCAT().\n\nfunction_name is the name that should be used in SQL statements to invoke the\nfunction.\n\nTo create a function, you must have the INSERT privilege for the mysql\ndatabase. This is necessary becauseCREATE FUNCTION adds a row to the\nmysql.func system table that records the function\'s name, type, and shared\nlibrary name. If you do not have this table, you should run the\nmariadb-upgrade command to create it.\n\nUDFs need to be written in C, C++ or another language that uses C calling\nconventions, MariaDB needs to have been dynamically compiled, and your\noperating system must support dynamic loading.\n\nFor an example, see sql/udf_example.cc in the source tree. For a collection of\nexisting UDFs see http://www.mysqludf.org/.\n\nStatements making use of user-defined functions are not safe for replication.\n\nFor creating a stored function as opposed to a user-defined function, see\nCREATE FUNCTION.\n\nFor valid identifiers to use as function names, see Identifier Names.\n\nRETURNS\n-------\n\nThe RETURNS clause indicates the type of the function\'s return value, and can\nbe one of STRING, INTEGER, REAL or DECIMAL. DECIMAL functions currently return\nstring values and should be written like STRING functions.\n\nshared_library_name\n-------------------\n\nshared_library_name is the basename of the shared object file that contains\nthe code that implements the function. The file must be located in the plugin\ndirectory. This directory is given by the value of the plugin_dir system\nvariable. Note that before MariaDB/MySQL 5.1, the shared object could be\nlocated in any directory that was searched by your system\'s dynamic linker.\n\nAGGREGATE\n---------\n\nAggregate functions are summary functions such as SUM() and AVG().\n\nMariaDB starting with 10.4\n--------------------------\nAggregate UDF functions can be used as window functions.\n\nOR REPLACE\n----------\n\nMariaDB starting with 10.1.3\n----------------------------\nThe OR REPLACE clause was added in MariaDB 10.1.3\n\nIf the optional OR REPLACE clause is used, it acts as a shortcut for:\n\nDROP FUNCTION IF EXISTS function_name;\nCREATE FUNCTION name ...;\n\nIF NOT EXISTS\n-------------\n\nMariaDB starting with 10.1.3\n----------------------------\nThe IF NOT EXISTS clause was added in MariaDB 10.1.3\n\nWhen the IF NOT EXISTS clause is used, MariaDB will return a warning instead\nof an error if the specified function already exists. Cannot be used together\nwith OR REPLACE.\n\nUpgrading a UDF\n---------------\n\nTo upgrade the UDF\'s shared library, first run a DROP FUNCTION statement, then\nupgrade the shared library and finally run the CREATE FUNCTION statement. If\nyou upgrade without following this process, you may crash the server.\n\nExamples\n--------\n\nCREATE FUNCTION jsoncontains_path RETURNS integer SONAME \'ha_connect.so\';\nQuery OK, 0 rows affected (0.00 sec)\n\nOR REPLACE and IF NOT EXISTS:\n\nCREATE FUNCTION jsoncontains_path RETURNS integer SONAME \'ha_connect.so\';\nERROR 1125 (HY000): Function \'jsoncontains_path\' already exists\n\nCREATE OR REPLACE FUNCTION jsoncontains_path RETURNS integer SONAME\n\'ha_connect.so\';\nQuery OK, 0 rows affected (0.00 sec)\n\nCREATE FUNCTION IF NOT EXISTS jsoncontains_path RETURNS integer SONAME\n\'ha_connect.so\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+---------------------------------------------+\n| Level | Code | Message                                     |\n+-------+------+---------------------------------------------+\n| Note  | 1125 | Function \'jsoncontains_path\' already exists |\n+-------+------+---------------------------------------------+\n\nURL: https://mariadb.com/kb/en/create-function-udf/','','https://mariadb.com/kb/en/create-function-udf/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (254,22,'DROP FUNCTION UDF','Syntax\n------\n\nDROP FUNCTION [IF EXISTS] function_name\n\nDescription\n-----------\n\nThis statement drops the user-defined function (UDF) named function_name.\n\nTo drop a function, you must have the DELETE privilege for the mysql database.\nThis is because DROP FUNCTION removes the row from the mysql.func system table\nthat records the function\'s name, type and shared library name.\n\nFor dropping a stored function, see DROP FUNCTION.\n\nUpgrading a UDF\n---------------\n\nTo upgrade the UDF\'s shared library, first run a DROP FUNCTION statement, then\nupgrade the shared library and finally run the CREATE FUNCTION statement. If\nyou upgrade without following this process, you may crash the server.\n\nExamples\n--------\n\nDROP FUNCTION jsoncontains_path;\n\nIF EXISTS:\n\nDROP FUNCTION jsoncontains_path;\nERROR 1305 (42000): FUNCTION test.jsoncontains_path does not exist\n\nDROP FUNCTION IF EXISTS jsoncontains_path;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n+-------+------+------------------------------------------------+\n| Level | Code | Message                                        |\n+-------+------+------------------------------------------------+\n| Note  | 1305 | FUNCTION test.jsoncontains_path does not exist |\n+-------+------+------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/drop-function-udf/','','https://mariadb.com/kb/en/drop-function-udf/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (255,22,'Creating User-Defined Functions','User-defined functions allow MariaDB to be extended with a new function that\nworks like a native (built-in) MariaDB function such as ABS() or CONCAT().\nThere are alternative ways to add a new function: writing a native function\n(which requires modifying and compiling the server source code), or writing a\nstored function.\n\nStatements making use of user-defined functions are not safe for replication.\n\nFunctions are written in C or C++, and to make use of them, the operating\nsystem must support dynamic loading.\n\nEach new SQL function requires corresponding functions written in C/C++. In\nthe list below, at least the main function - x() - and one other, are\nrequired. x should be replaced by the name of the function you are creating.\n\nAll functions need to be thread-safe, so not global or static variables that\nchange can be allocated. Memory is allocated in x_init()/ and freed in\nx_deinit().\n\nSimple Functions\n----------------\n\nx()\n---\n\nRequired for all UDFs; this is where the results are calculated.\n\n+------------------------------------------+----------------------------------+\n| C/C++ type                               | SQL type                         |\n+------------------------------------------+----------------------------------+\n| char *                                   | STRING                           |\n+------------------------------------------+----------------------------------+\n| long long                                | INTEGER                          |\n+------------------------------------------+----------------------------------+\n| double                                   | REAL                             |\n+------------------------------------------+----------------------------------+\n\nDECIMAL functions return string values, and so should be written accordingly.\nIt is not possible to create ROW functions.\n\nx_init()\n--------\n\nInitialization function for x(). Can be used for the following:\n\n* Check the number of arguments to X() (the SQL equivalent).\n* Verify the argument types, or to force arguments to be of a particular type\nafter the function is called.\n* Specify whether the result can be NULL.\n* Specify the maximum result length.\n* For REAL functions, specify the maximum number of decimals for the result.\n* Allocate any required memory.\n\nx_deinit()\n----------\n\nDe-initialization function for x(). Used to de-allocate memory that was\nallocated in x_init().\n\nDescription\n-----------\n\nEach time the SQL function X() is called:\n\n* MariaDB will first call the C/C++ initialization function, x_init(),\nassuming it exists. All setup will be performed, and if it returns an error,\nthe SQL statement is aborted and no further functions are called.\n* If there is no x_init() function, or it has been called and did not return\nan error, x() is then called once per row.\n* After all rows have finished processing, x_deinit() is called, if present,\nto clean up by de-allocating any memory that was allocated in x_init().\n* See User-defined Functions Calling Sequences for more details on the\nfunctions.\n\nAggregate Functions\n-------------------\n\nThe following functions are required for aggregate functions, such as AVG()\nand SUM(). When using CREATE FUNCTION, the AGGREGATE keyword is required.\n\nx_clear()\n---------\n\nUsed to reset the current aggregate, but without inserting the argument as the\ninitial aggregate value for the new group.\n\nx_add()\n-------\n\nUsed to add the argument to the current aggregate.\n\nx_remove()\n----------\n\nStarting from MariaDB 10.4, improves the support of window functions (so it is\nnot obligatory to add it) and should remove the argument from the current\naggregate.\n\nDescription\n-----------\n\nEach time the aggregate SQL function X() is called:\n\n* MariaDB will first call the C/C++ initialization function, x_init(),\nassuming it exists. All setup will be performed, and if it returns an error,\nthe SQL statement is aborted and no further functions are called.\n* If there is no x_init() function, or it has been called and did not return\nan error, x() is then called once per row.\n* After all rows have finished processing, x_deinit() is called, if present,\nto clean up by de-allocating any memory that was allocated in x_init().\n\n* MariaDB will first call the C/C++ initialization function, x_init(),\nassuming it exists. All setup will be performed, and if it returns an error,\nthe SQL statement is aborted and no further functions are called.\n* The table is sorted according to the GROUP BY expression.\n* x_clear() is called for the first row of each new group.\n* x_add() is called once per row for each row in the same group.\n* x() is called when the group changes, or after the last row, to get the\naggregate result. \n* The latter three steps are repeated until all rows have been processed.\n* After all rows have finished processing, x_deinit() is called, if present,\nto clean up by de-allocating any memory that was allocated in x_init().\n\nExamples\n--------\n\nFor an example, see sql/udf_example.cc in the source tree. For a collection of\nexisting UDFs see https://github.com/mysqludf.\n\nURL: https://mariadb.com/kb/en/creating-user-defined-functions/','','https://mariadb.com/kb/en/creating-user-defined-functions/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (256,22,'User-Defined Functions Calling Sequences','The functions described in Creating User-defined Functions are expanded on\nthis page. They are declared as follows:\n\nSimple Functions\n----------------\n\nx()\n---\n\nIf x() returns an integer, it is declared as follows:\n\nlong long x(UDF_INIT *initid, UDF_ARGS *args,\n       char *is_null, char *error);\n\nIf x() returns a string (DECIMAL functions also return string values), it is\ndeclared as follows:\n\nchar *x(UDF_INIT *initid, UDF_ARGS *args,\n     char *result, unsigned long *length,\n     char *is_null, char *error);\n\nIf x() returns a real, it is declared as follows:\n\ndouble x(UDF_INIT *initid, UDF_ARGS *args,\n       char *is_null, char *error);\n\nx_init()\n--------\n\nmy_bool x_init(UDF_INIT *initid, UDF_ARGS *args, char *message);\n\nx_deinit()\n----------\n\nvoid x_deinit(UDF_INIT *initid);\n\nDescription\n-----------\n\ninitid is a parameter passed to all three functions that points to a UDF_INIT\nstructure, used for communicating information between the functions. Its\nstructure members are:\n\n* my_bool maybe_null\nmaybe_null should be set to 1 if x_init can return a NULL value, Defaults to 1\nif any arguments are declared maybe_null.\n\n* unsigned int decimals\nNumber of decimals after the decimal point. The default, if an explicit number\nof decimals is passed in the arguments to the main function, is the maximum\nnumber of decimals, so if 9.5, 9.55 and 9.555 are passed to the function, the\ndefault would be three (based on 9.555, the maximum).  If there are no\nexplicit number of decimals, the default is set to 31, or one more than the\nmaximum for the DOUBLE, FLOAT and DECIMAL types. This default can be changed\nin the function to suit the actual calculation.\n\n* unsigned int max_length\nMaximum length of the result. For integers, the default is 21. For strings,\nthe length of the longest argument. For reals, the default is 13 plus the\nnumber of decimals indicated by initid->decimals. The length includes any\nsigns or decimal points. Can also be set to 65KB or 16MB in order to return a\nBLOB. The memory remains unallocated, but this is used to decide on the data\ntype to use if the data needs to be temporarily stored.\n\n* char *ptr\nA pointer for use as required by the function. Commonly, initid->ptr is used\nto communicate allocated memory, with x_init() allocating the memory and\nassigning it to this pointer, x() using it, and x_deinit() de-allocating it.\n\n* my_bool const_item\nShould be set to 1 in x_init() if x() always returns the same value, otherwise\n0.\n\nAggregate Functions\n-------------------\n\nx_clear()\n---------\n\nx_clear() is a required function for aggregate functions, and is declared as\nfollows:\n\nvoid x_clear(UDF_INIT *initid, char *is_null, char *error);\n\nIt is called when the summary results need to be reset, that is at the\nbeginning of each new group. but also to reset the values when there were no\nmatching rows.\n\nis_null is set to point to CHAR(0) before calling x_clear().\n\nIn the case of an error, you can store the value to which the error argument\npoints (a single-byte variable, not a string string buffer) in the variable.\n\nx_reset()\n---------\n\nx_reset() is declared as follows:\n\nvoid x_reset(UDF_INIT *initid, UDF_ARGS *args,\n       char *is_null, char *error);\n\nIt is called on finding the first row in a new group. Should reset the summary\nvariables, and then use UDF_ARGS as the first value in the group\'s internal\nsummary value. The function is not required if the UDF interface uses\nx_clear().\n\nx_add()\n-------\n\nx_add() is declared as follows:\n\nvoid x_add(UDF_INIT *initid, UDF_ARGS *args,\n      char *is_null, char *error);\n\nIt is called for all rows belonging to the same group, and should be used to\nadd the value in UDF_ARGS to the internal summary variable.\n\nx_remove()\n----------\n\nx_remove() was added in MariaDB 10.4 and is declared as follows (same as\nx_add()):\n\nvoid x_remove(UDF_INIT* initid, UDF_ARGS* args,\n       char* is_null, char *error );\n\nIt adds more efficient support of aggregate UDFs as window functions.\nx_remove() should \"subtract\" the row (reverse x_add()). In MariaDB 10.4\naggregate UDFs will work as WINDOW functions without x_remove() but it will\nnot be so efficient.\n\nIf x_remove() supported (defined) detected automatically.\n\nURL: https://mariadb.com/kb/en/user-defined-functions-calling-sequences/','','https://mariadb.com/kb/en/user-defined-functions-calling-sequences/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (257,22,'User-Defined Functions Security','The MariaDB server imposes a number of limitations on user-defined functions\nfor security purposes.\n\n* The INSERT privilege for the mysql database is required to run CREATE\nFUNCTION, as a record will be added to the mysql.func-table.\n* The DELETE privilege for the mysql database is required to run DROP FUNCTION\nas the corresponding record will be removed from the mysql.func-table.\n* UDF object files can only be placed in the plugin directory, as specified by\nthe value of the plugin_dir system variable.\n* At least one symbol, beyond the required x() - corresponding to an SQL\nfunction X()) - is required. These can be x_init(), x_deinit(), xxx_reset(),\nx_clear() and x_add() functions (see Creating User-defined Functions). The\nallow-suspicious-udfs mysqld option (by default unset) provides a workaround,\npermitting only one symbol to be used. This is not recommended, as it opens\nthe possibility of loading shared objects that are not legitimate user-defined\nfunctions.\n\nURL: https://mariadb.com/kb/en/user-defined-functions-security/','','https://mariadb.com/kb/en/user-defined-functions-security/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (258,23,'Numeric Data Type Overview','There are a number of numeric data types:\n\n* TINYINT\n* BOOLEAN - Synonym for TINYINT(1)\n* INT1 - Synonym for TINYINT\n* SMALLINT\n* INT2 - Synonym for SMALLINT\n* MEDIUMINT\n* INT3 - Synonym for MEDIUMINT\n* INT, INTEGER\n* INT4 - Synonym for INT\n* BIGINT\n* INT8 - Synonym for BIGINT\n* DECIMAL, DEC, NUMERIC, FIXED\n* FLOAT\n* DOUBLE, DOUBLE PRECISION, REAL\n* BIT\n\nSee the specific articles for detailed information on each.\n\nSIGNED, UNSIGNED and ZEROFILL\n-----------------------------\n\nMost numeric types can be defined as SIGNED, UNSIGNED or ZEROFILL, for example:\n\nTINYINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nIf SIGNED, or no attribute, is specified, a portion of the numeric type will\nbe reserved for the sign (plus or minus). For example, a TINYINT SIGNED can\nrange from -128 to 127.\n\nIf UNSIGNED is specified, no portion of the numeric type is reserved for the\nsign, so for integer types range can be larger. For example, a TINYINT\nUNSIGNED can range from 0 to 255. Floating point and fixed-point types also\ncan be UNSIGNED, but this only prevents negative values from being stored and\ndoesn\'t alter the range.\n\nIf ZEROFILL is specified, the column will be set to UNSIGNED and the spaces\nused by default to pad the field are replaced with zeros. ZEROFILL is ignored\nin expressions or as part of a UNION. ZEROFILL is a non-standard MySQL and\nMariaDB enhancement.\n\nNote that although the preferred syntax indicates that the attributes are\nexclusive, more than one attribute can be specified.\n\nUntil MariaDB 10.2.7 (MDEV-8659), any combination of the attributes could be\nused in any order, with duplicates. In this case:\n\n* the presence of ZEROFILL makes the column UNSIGNED ZEROFILL.\n* the presence of UNSIGNED makes the column UNSIGNED.\n\nFrom MariaDB 10.2.8, only the following combinations are supported:\n\n* SIGNED\n* UNSIGNED\n* ZEROFILL\n* UNSIGNED ZEROFILL\n* ZEROFILL UNSIGNED\n\nThe latter two should be replaced with simply ZEROFILL, but are still accepted\nby the parser.\n\nExamples\n--------\n\nCREATE TABLE zf (\n i1 TINYINT SIGNED,\n i2 TINYINT UNSIGNED,\n i3 TINYINT ZEROFILL\n);\n\nINSERT INTO zf VALUES (2,2,2);\n\nSELECT * FROM zf;\n+------+------+------+\n| i1   | i2   | i3   |\n+------+------+------+\n|    2 |    2 |  002 |\n+------+------+------+\n\nRange\n-----\n\nWhen attempting to add a value that is out of the valid range for the numeric\ntype, MariaDB will react depending on the strict SQL_MODE setting.\n\nIf strict_mode has been set (the default from MariaDB 10.2.4), MariaDB will\nreturn an error.\n\nIf strict_mode has not been set (the default until MariaDB 10.2.3), MariaDB\nwill adjust the number to fit in the field, returning a warning.\n\nExamples\n--------\n\nWith strict_mode set:\n\nSHOW VARIABLES LIKE \'sql_mode\';\n+---------------+--------------------------------------------------------------\n----------------------------+\n| Variable_name | Value                                                       \n              |\n+---------------+--------------------------------------------------------------\n----------------------------+\n| sql_mode      |\nSTRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SU\nSTITUTION |\n+---------------+--------------------------------------------------------------\n----------------------------+\n\nCREATE TABLE ranges (i1 TINYINT, i2 SMALLINT, i3 TINYINT UNSIGNED);\n\nINSERT INTO ranges VALUES (257,257,257);\nERROR 1264 (22003): Out of range value for column \'i1\' at row 1\n\nSELECT * FROM ranges;\nEmpty set (0.10 sec)\n\nWith strict_mode unset:\n\nSHOW VARIABLES LIKE \'sql_mode%\';\n+---------------+-------+\n| Variable_name | Value |\n+---------------+-------+\n| sql_mode      |       |\n+---------------+-------+\n\nCREATE TABLE ranges (i1 TINYINT, i2 SMALLINT, i3 TINYINT UNSIGNED);\n\nINSERT INTO ranges VALUES (257,257,257);\nQuery OK, 1 row affected, 2 warnings (0.00 sec)\n\nSHOW WARNINGS;\n+---------+------+---------------------------------------------+\n| Level   | Code | Message                                     |\n+---------+------+---------------------------------------------+\n| Warning | 1264 | Out of range value for column \'i1\' at row 1 |\n| Warning | 1264 | Out of range value for column \'i3\' at row 1 |\n+---------+------+---------------------------------------------+\n2 rows in set (0.00 sec)\n\nSELECT * FROM ranges;\n+------+------+------+\n| i1   | i2   | i3   |\n+------+------+------+\n|  127 |  257 |  255 |\n+------+------+------+\n\nAuto_increment\n--------------\n\nThe AUTO_INCREMENT attribute can be used to generate a unique identity for new\nrows. For more details, see auto_increment.\n\nURL: https://mariadb.com/kb/en/numeric-data-type-overview/','','https://mariadb.com/kb/en/numeric-data-type-overview/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (259,23,'TINYINT','Syntax\n------\n\nTINYINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA very small integer. The signed range is -128 to 127. The unsigned range is 0\nto 255. For details on the attributes, see Numeric Data Type Overview.\n\nINT1 is a synonym for TINYINT. BOOL and BOOLEAN are synonyms for TINYINT(1).\n\nExamples\n--------\n\nCREATE TABLE tinyints (a TINYINT,b TINYINT UNSIGNED,c TINYINT ZEROFILL);\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO tinyints VALUES (-10,-10,-10);\nERROR 1264 (22003): Out of range value for column \'b\' at row 1\n\nINSERT INTO tinyints VALUES (-10,10,-10);\nERROR 1264 (22003): Out of range value for column \'c\' at row 1\n\nINSERT INTO tinyints VALUES (-10,10,10);\n\nSELECT * FROM tinyints;\n+------+------+------+\n| a    | b    | c    |\n+------+------+------+\n|  -10 |   10 |  010 |\n+------+------+------+\n\nINSERT INTO tinyints VALUES (128,128,128);\nERROR 1264 (22003): Out of range value for column \'a\' at row 1\n\nINSERT INTO tinyints VALUES (127,128,128);\n\nSELECT * FROM tinyints;\n+------+------+------+\n| a    | b    | c    |\n+------+------+------+\n|  -10 |   10 |  010 |\n|  127 |  128 |  128 |\n+------+------+------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO tinyints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.08 sec)\nWarning (Code 1264): Out of range value for column \'b\' at row 1\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO tinyints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.11 sec)\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO tinyints VALUES (-10,10,10);\n\nSELECT * FROM tinyints;\n+------+------+------+\n| a    | b    | c    |\n+------+------+------+\n|  -10 |    0 |  000 |\n|  -10 |   10 |  000 |\n|  -10 |   10 |  010 |\n+------+------+------+\n\nINSERT INTO tinyints VALUES (128,128,128);\nQuery OK, 1 row affected, 1 warning (0.19 sec)\nWarning (Code 1264): Out of range value for column \'a\' at row 1\n\nINSERT INTO tinyints VALUES (127,128,128);\n\nSELECT * FROM tinyints;\n+------+------+------+\n| a    | b    | c    |\n+------+------+------+\n|  -10 |    0 |  000 |\n|  -10 |   10 |  000 |\n|  -10 |   10 |  010 |\n|  127 |  128 |  128 |\n|  127 |  128 |  128 |\n+------+------+------+\n\nURL: https://mariadb.com/kb/en/tinyint/','','https://mariadb.com/kb/en/tinyint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (260,23,'BOOLEAN','Syntax\n------\n\nBOOL, BOOLEAN\n\nDescription\n-----------\n\nThese types are synonyms for TINYINT(1). A value of zero is considered false.\nNon-zero values are considered true.\n\nHowever, the values TRUE and FALSE are merely aliases for 1 and 0. See Boolean\nLiterals, as well as the IS operator for testing values against a boolean.\n\nExamples\n--------\n\nCREATE TABLE boo (i BOOLEAN);\n\nDESC boo;\n+-------+------------+------+-----+---------+-------+\n| Field | Type       | Null | Key | Default | Extra |\n+-------+------------+------+-----+---------+-------+\n| i     | tinyint(1) | YES  |     | NULL    |       |\n+-------+------------+------+-----+---------+-------+\n\nSELECT IF(0, \'true\', \'false\');\n+------------------------+\n| IF(0, \'true\', \'false\') |\n+------------------------+\n| false                  |\n+------------------------+\n\nSELECT IF(1, \'true\', \'false\');\n+------------------------+\n| IF(1, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nSELECT IF(2, \'true\', \'false\');\n+------------------------+\n| IF(2, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nTRUE and FALSE as aliases for 1 and 0:\n\nSELECT IF(0 = FALSE, \'true\', \'false\');\n\n+--------------------------------+\n| IF(0 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| true                           |\n+--------------------------------+\n\nSELECT IF(1 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(1 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| true                          |\n+-------------------------------+\n\nSELECT IF(2 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(2 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| false                         |\n+-------------------------------+\n\nSELECT IF(2 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(2 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| false                          |\n+--------------------------------+\n\nThe last two statements display the results shown because 2 is equal to\nneither 1 nor 0.\n\nURL: https://mariadb.com/kb/en/boolean/','','https://mariadb.com/kb/en/boolean/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (261,23,'SMALLINT','Syntax\n------\n\nSMALLINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA small integer. The signed range is -32768 to 32767. The unsigned range is 0\nto 65535.\n\nIf a column has been set to ZEROFILL, all values will be prepended by zeros so\nthat the SMALLINT value contains a number of M digits.\n\nNote: If the ZEROFILL attribute has been specified, the column will\nautomatically become UNSIGNED.\n\nINT2 is a synonym for SMALLINT.\n\nFor more details on the attributes, see Numeric Data Type Overview.\n\nExamples\n--------\n\nCREATE TABLE smallints (a SMALLINT,b SMALLINT UNSIGNED,c SMALLINT ZEROFILL);\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO smallints VALUES (-10,-10,-10);\nERROR 1264 (22003): Out of range value for column \'b\' at row 1\n\nINSERT INTO smallints VALUES (-10,10,-10);\nERROR 1264 (22003): Out of range value for column \'c\' at row 1\n\nINSERT INTO smallints VALUES (-10,10,10);\n\nINSERT INTO smallints VALUES (32768,32768,32768);\nERROR 1264 (22003): Out of range value for column \'a\' at row 1\n\nINSERT INTO smallints VALUES (32767,32768,32768);\n\nSELECT * FROM smallints;\n+-------+-------+-------+\n| a     | b     | c     |\n+-------+-------+-------+\n|   -10 |    10 | 00010 |\n| 32767 | 32768 | 32768 |\n+-------+-------+-------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO smallints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.09 sec)\nWarning (Code 1264): Out of range value for column \'b\' at row 1\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO smallints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO smallints VALUES (-10,10,10);\n\nINSERT INTO smallints VALUES (32768,32768,32768);\nQuery OK, 1 row affected, 1 warning (0.04 sec)\nWarning (Code 1264): Out of range value for column \'a\' at row 1\n\nINSERT INTO smallints VALUES (32767,32768,32768);\n\nSELECT * FROM smallints;\n+-------+-------+-------+\n| a     | b     | c     |\n+-------+-------+-------+\n|   -10 |     0 | 00000 |\n|   -10 |    10 | 00000 |\n|   -10 |    10 | 00010 |\n| 32767 | 32768 | 32768 |\n| 32767 | 32768 | 32768 |\n+-------+-------+-------+\n\nURL: https://mariadb.com/kb/en/smallint/','','https://mariadb.com/kb/en/smallint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (262,23,'MEDIUMINT','Syntax\n------\n\nMEDIUMINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA medium-sized integer. The signed range is -8388608 to 8388607. The unsigned\nrange is 0 to 16777215.\n\nZEROFILL pads the integer with zeroes and assumes UNSIGNED (even if UNSIGNED\nis not specified).\n\nINT3 is a synonym for MEDIUMINT.\n\nFor details on the attributes, see Numeric Data Type Overview.\n\nExamples\n--------\n\nCREATE TABLE mediumints (a MEDIUMINT,b MEDIUMINT UNSIGNED,c MEDIUMINT\nZEROFILL);\n\nDESCRIBE mediumints;\n+-------+--------------------------------+------+-----+---------+-------+\n| Field | Type                           | Null | Key | Default | Extra |\n+-------+--------------------------------+------+-----+---------+-------+\n| a     | mediumint(9)                   | YES  |     | NULL    |       |\n| b     | mediumint(8) unsigned          | YES  |     | NULL    |       |\n| c     | mediumint(8) unsigned zerofill | YES  |     | NULL    |       |\n+-------+--------------------------------+------+-----+---------+-------+\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO mediumints VALUES (-10,-10,-10);\nERROR 1264 (22003): Out of range value for column \'b\' at row 1\n\nINSERT INTO mediumints VALUES (-10,10,-10);\nERROR 1264 (22003): Out of range value for column \'c\' at row 1\n\nINSERT INTO mediumints VALUES (-10,10,10);\n\nINSERT INTO mediumints VALUES (8388608,8388608,8388608);\nERROR 1264 (22003): Out of range value for column \'a\' at row 1\n\nINSERT INTO mediumints VALUES (8388607,8388608,8388608);\n\nSELECT * FROM mediumints;\n+---------+---------+----------+\n| a       | b       | c        |\n+---------+---------+----------+\n|     -10 |      10 | 00000010 |\n| 8388607 | 8388608 | 08388608 |\n+---------+---------+----------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO mediumints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.05 sec)\nWarning (Code 1264): Out of range value for column \'b\' at row 1\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO mediumints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO mediumints VALUES (-10,10,10);\n\nINSERT INTO mediumints VALUES (8388608,8388608,8388608);\nQuery OK, 1 row affected, 1 warning (0.05 sec)\nWarning (Code 1264): Out of range value for column \'a\' at row 1\n\nINSERT INTO mediumints VALUES (8388607,8388608,8388608);\n\nSELECT * FROM mediumints;\n+---------+---------+----------+\n| a       | b       | c        |\n+---------+---------+----------+\n|     -10 |       0 | 00000000 |\n|     -10 |       0 | 00000000 |\n|     -10 |      10 | 00000000 |\n|     -10 |      10 | 00000010 |\n| 8388607 | 8388608 | 08388608 |\n| 8388607 | 8388608 | 08388608 |\n+---------+---------+----------+\n\nURL: https://mariadb.com/kb/en/mediumint/','','https://mariadb.com/kb/en/mediumint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (263,23,'INT','Syntax\n------\n\nINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\nINTEGER[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA normal-size integer. When marked UNSIGNED, it ranges from 0 to 4294967295,\notherwise its range is -2147483648 to 2147483647 (SIGNED is the default). If a\ncolumn has been set to ZEROFILL, all values will be prepended by zeros so that\nthe INT value contains a number of M digits. INTEGER is a synonym for INT.\n\nNote: If the ZEROFILL attribute has been specified, the column will\nautomatically become UNSIGNED.\n\nINT4 is a synonym for INT.\n\nFor details on the attributes, see Numeric Data Type Overview.\n\nExamples\n--------\n\nCREATE TABLE ints (a INT,b INT UNSIGNED,c INT ZEROFILL);\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO ints VALUES (-10,-10,-10);\nERROR 1264 (22003): Out of range value for column \'b\' at row 1\n\nINSERT INTO ints VALUES (-10,10,-10);\nERROR 1264 (22003): Out of range value for column \'c\' at row 1\n\nINSERT INTO ints VALUES (-10,10,10);\n\nINSERT INTO ints VALUES (2147483648,2147483648,2147483648);\nERROR 1264 (22003): Out of range value for column \'a\' at row 1\n\nINSERT INTO ints VALUES (2147483647,2147483648,2147483648);\n\nSELECT * FROM ints;\n+------------+------------+------------+\n| a          | b          | c          |\n+------------+------------+------------+\n|        -10 |         10 | 0000000010 |\n| 2147483647 | 2147483648 | 2147483648 |\n+------------+------------+------------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO ints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.10 sec)\nWarning (Code 1264): Out of range value for column \'b\' at row 1\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO ints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO ints VALUES (-10,10,10);\n\nINSERT INTO ints VALUES (2147483648,2147483648,2147483648);\nQuery OK, 1 row affected, 1 warning (0.07 sec)\nWarning (Code 1264): Out of range value for column \'a\' at row 1\n\nINSERT INTO ints VALUES (2147483647,2147483648,2147483648);\n\nSELECT * FROM ints;\n+------------+------------+------------+\n| a          | b          | c          |\n+------------+------------+------------+\n|        -10 |          0 | 0000000000 |\n|        -10 |         10 | 0000000000 |\n|        -10 |         10 | 0000000010 |\n| 2147483647 | 2147483648 | 2147483648 |\n| 2147483647 | 2147483648 | 2147483648 |\n+------------+------------+------------+\n\nURL: https://mariadb.com/kb/en/int/','','https://mariadb.com/kb/en/int/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (264,23,'BIGINT','Syntax\n------\n\nBIGINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to 18446744073709551615.\n\nIf a column has been set to ZEROFILL, all values will be prepended by zeros so\nthat the BIGINT value contains a number of M digits.\n\nNote: If the ZEROFILL attribute has been specified, the column will\nautomatically become UNSIGNED.\n\nFor more details on the attributes, see Numeric Data Type Overview.\n\nSERIAL is an alias for:\n\nBIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE\n\nINT8 is a synonym for BIGINT.\n\nExamples\n--------\n\nCREATE TABLE bigints (a BIGINT,b BIGINT UNSIGNED,c BIGINT ZEROFILL);\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO bigints VALUES (-10,-10,-10);\nERROR 1264 (22003): Out of range value for column \'b\' at row 1\n\nINSERT INTO bigints VALUES (-10,10,-10);\nERROR 1264 (22003): Out of range value for column \'c\' at row 1\n\nINSERT INTO bigints VALUES (-10,10,10);\n\nINSERT INTO bigints VALUES\n(9223372036854775808,9223372036854775808,9223372036854775808);\nERROR 1264 (22003): Out of range value for column \'a\' at row 1\n\nINSERT INTO bigints VALUES\n(9223372036854775807,9223372036854775808,9223372036854775808);\n\nSELECT * FROM bigints;\n+---------------------+---------------------+----------------------+\n| a                   | b                   | c                    |\n+---------------------+---------------------+----------------------+\n|                 -10 |                  10 | 00000000000000000010 |\n| 9223372036854775807 | 9223372036854775808 | 09223372036854775808 |\n+---------------------+---------------------+----------------------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO bigints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.08 sec)\nWarning (Code 1264): Out of range value for column \'b\' at row 1\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO bigints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at row 1\n\nINSERT INTO bigints VALUES (-10,10,10);\n\nINSERT INTO bigints VALUES\n(9223372036854775808,9223372036854775808,9223372036854775808);\nQuery OK, 1 row affected, 1 warning (0.07 sec)\nWarning (Code 1264): Out of range value for column \'a\' at row 1\n\nINSERT INTO bigints VALUES\n(9223372036854775807,9223372036854775808,9223372036854775808);\n\nSELECT * FROM bigints;\n+---------------------+---------------------+----------------------+\n| a                   | b                   | c                    |\n+---------------------+---------------------+----------------------+\n|                 -10 |                   0 | 00000000000000000000 |\n|                 -10 |                  10 | 00000000000000000000 |\n|                 -10 |                  10 | 00000000000000000010 |\n| 9223372036854775807 | 9223372036854775808 | 09223372036854775808 |\n| 9223372036854775807 | 9223372036854775808 | 09223372036854775808 |\n+---------------------+---------------------+----------------------+\n\nURL: https://mariadb.com/kb/en/bigint/','','https://mariadb.com/kb/en/bigint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (265,23,'DECIMAL','Syntax\n------\n\nDECIMAL[(M[,D])] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA packed \"exact\" fixed-point number. M is the total number of digits (the\nprecision) and D is the number of digits after the decimal point (the scale).\n\n* The decimal point and (for negative numbers) the \"-\" sign are not\ncounted in M. \n* If D is 0, values have no decimal point or fractional\npart and on INSERT the value will be rounded to the nearest DECIMAL. \n* The maximum number of digits (M) for DECIMAL is 65. \n* The maximum number of supported decimals (D) is 30 before MariadB 10.2.1 and\n38 afterwards. \n* If D is omitted, the default is 0. If M is omitted, the default is 10.\n\nUNSIGNED, if specified, disallows negative values.\n\nZEROFILL, if specified, pads the number with zeros, up to the total number of\ndigits specified by M.\n\nAll basic calculations (+, -, *, /) with DECIMAL columns are done with a\nprecision of 65 digits.\n\nFor more details on the attributes, see Numeric Data Type Overview.\n\nDEC, NUMERIC and FIXED are synonyms, as well as NUMBER in Oracle mode from\nMariaDB 10.3.\n\nExamples\n--------\n\nCREATE TABLE t1 (d DECIMAL UNSIGNED ZEROFILL);\n\nINSERT INTO t1 VALUES (1),(2),(3),(4.0),(5.2),(5.7);\nQuery OK, 6 rows affected, 2 warnings (0.16 sec)\nRecords: 6  Duplicates: 0  Warnings: 2\n\nNote (Code 1265): Data truncated for column \'d\' at row 5\nNote (Code 1265): Data truncated for column \'d\' at row 6\n\nSELECT * FROM t1;\n+------------+\n| d          |\n+------------+\n| 0000000001 |\n| 0000000002 |\n| 0000000003 |\n| 0000000004 |\n| 0000000005 |\n| 0000000006 |\n+------------+\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO t1 VALUES (-7);\nERROR 1264 (22003): Out of range value for column \'d\' at row 1\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO t1 VALUES (-7);\nQuery OK, 1 row affected, 1 warning (0.02 sec)\nWarning (Code 1264): Out of range value for column \'d\' at row 1\n\nSELECT * FROM t1;\n+------------+\n| d          |\n+------------+\n| 0000000001 |\n| 0000000002 |\n| 0000000003 |\n| 0000000004 |\n| 0000000005 |\n| 0000000006 |\n| 0000000000 |\n+------------+\n\nURL: https://mariadb.com/kb/en/decimal/','','https://mariadb.com/kb/en/decimal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (266,23,'FLOAT','Syntax\n------\n\nFLOAT[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA small (single-precision) floating-point number (see DOUBLE for a\nregular-size floating point number). Allowable values are:\n\n* -3.402823466E+38 to -1.175494351E-38\n* 0\n* 1.175494351E-38 to 3.402823466E+38.\n\nThese are the theoretical limits, based on the IEEE standard. The actual range\nmight be slightly smaller depending on your hardware or operating system.\n\nM is the total number of digits and D is the number of digits following the\ndecimal point. If M and D are omitted, values are stored to the limits allowed\nby the hardware. A single-precision floating-point number is accurate to\napproximately 7 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nUsing FLOAT might give you some unexpected problems because all calculations\nin MariaDB are done with double precision. See Floating Point Accuracy.\n\nFor more details on the attributes, see Numeric Data Type Overview.\n\nURL: https://mariadb.com/kb/en/float/','','https://mariadb.com/kb/en/float/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (267,23,'DOUBLE','Syntax\n------\n\nDOUBLE[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\nDOUBLE PRECISION[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\nREAL[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\n\nDescription\n-----------\n\nA normal-size (double-precision) floating-point number (see FLOAT for a\nsingle-precision floating-point number).\n\nAllowable values are:\n\n* -1.7976931348623157E+308 to -2.2250738585072014E-308\n* 0\n* 2.2250738585072014E-308 to 1.7976931348623157E+308\n\nThese are the theoretical limits, based on the IEEE standard. The actual range\nmight be slightly smaller depending on your hardware or operating system.\n\nM is the total number of digits and D is the number of digits following the\ndecimal point. If M and D are omitted, values are stored to the limits allowed\nby the hardware. A double-precision floating-point number is accurate to\napproximately 15 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nZEROFILL, if specified, pads the number with zeros, up to the total number of\ndigits specified by M.\n\nREAL and DOUBLE PRECISION are synonyms, unless the REAL_AS_FLOAT SQL mode is\nenabled, in which case REAL is a synonym for FLOAT rather than DOUBLE.\n\nSee Floating Point Accuracy for issues when using floating-point numbers.\n\nFor more details on the attributes, see Numeric Data Type Overview.\n\nExamples\n--------\n\nCREATE TABLE t1 (d DOUBLE(5,0) zerofill);\n\nINSERT INTO t1 VALUES (1),(2),(3),(4);\n\nSELECT * FROM t1;\n+-------+\n| d     |\n+-------+\n| 00001 |\n| 00002 |\n| 00003 |\n| 00004 |\n+-------+\n\nURL: https://mariadb.com/kb/en/double/','','https://mariadb.com/kb/en/double/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (268,23,'BIT','Syntax\n------\n\nBIT[(M)]\n\nDescription\n-----------\n\nA bit-field type. M indicates the number of bits per value, from 1 to 64. The\ndefault is 1 if M is omitted.\n\nBit values can be inserted with b\'value\' notation, where value is the bit\nvalue in 0\'s and 1\'s.\n\nBit fields are automatically zero-padded from the left to the full length of\nthe bit, so for example in a BIT(4) field, \'10\' is equivalent to \'0010\'.\n\nBits are returned as binary, so to display them, either add 0, or use a\nfunction such as HEX, OCT or BIN to convert them.\n\nExamples\n--------\n\nCREATE TABLE b ( b1 BIT(8) );\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nINSERT INTO b VALUES (b\'11111111\');\n\nINSERT INTO b VALUES (b\'01010101\');\n\nINSERT INTO b VALUES (b\'1111111111111\');\nERROR 1406 (22001): Data too long for column \'b1\' at row 1\n\nSELECT b1+0, HEX(b1), OCT(b1), BIN(b1) FROM b;\n+------+---------+---------+----------+\n| b1+0 | HEX(b1) | OCT(b1) | BIN(b1)  |\n+------+---------+---------+----------+\n|  255 | FF      | 377     | 11111111 |\n|   85 | 55      | 125     | 1010101  |\n+------+---------+---------+----------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nINSERT INTO b VALUES (b\'11111111\'),(b\'01010101\'),(b\'1111111111111\');\nQuery OK, 3 rows affected, 1 warning (0.10 sec)\nRecords: 3  Duplicates: 0  Warnings: 1\n\nSHOW WARNINGS;\n+---------+------+---------------------------------------------+\n| Level   | Code | Message                                     |\n+---------+------+---------------------------------------------+\n| Warning | 1264 | Out of range value for column \'b1\' at row 3 |\n+---------+------+---------------------------------------------+\n\nSELECT b1+0, HEX(b1), OCT(b1), BIN(b1) FROM b;\n+------+---------+---------+----------+\n| b1+0 | HEX(b1) | OCT(b1) | BIN(b1)  |\n+------+---------+---------+----------+\n|  255 | FF      | 377     | 11111111 |\n|   85 | 55      | 125     | 1010101  |\n|  255 | FF      | 377     | 11111111 |\n+------+---------+---------+----------+\n\nURL: https://mariadb.com/kb/en/bit/','','https://mariadb.com/kb/en/bit/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (269,23,'Floating-point Accuracy','Due to their nature, not all floating-point numbers can be stored with exact\nprecision. Hardware architecture, the CPU or even the compiler version and\noptimization level may affect the precision.\n\nIf you are comparing DOUBLEs or FLOATs with numeric decimals, it is not safe\nto use the equality operator.\n\nSometimes, changing a floating-point number from single-precision (FLOAT) to\ndouble-precision (DOUBLE) will fix the problem.\n\nExample\n-------\n\nf1, f2 and f3 have seemingly identical values across each row, but due to\nfloating point accuracy, the results may be unexpected.\n\nCREATE TABLE fpn (id INT, f1 FLOAT, f2 DOUBLE, f3 DECIMAL (10,3));\nINSERT INTO fpn VALUES (1,2,2,2),(2,0.1,0.1,0.1);\n\nSELECT * FROM fpn WHERE f1*f1 = f2*f2;\n+------+------+------+-------+\n| id   | f1   | f2   | f3    |\n+------+------+------+-------+\n|    1 |    2 |    2 | 2.000 |\n+------+------+------+-------+\n\nThe reason why only one instead of two rows was returned becomes clear when we\nsee how the floating point squares were evaluated.\n\nSELECT f1*f1, f2*f2, f3*f3 FROM fpn;\n+----------------------+----------------------+----------+\n| f1*f1                | f2*f2                | f3*f3    |\n+----------------------+----------------------+----------+\n|                    4 |                    4 | 4.000000 |\n| 0.010000000298023226 | 0.010000000000000002 | 0.010000 |\n+----------------------+----------------------+----------+\n\nURL: https://mariadb.com/kb/en/floating-point-accuracy/','','https://mariadb.com/kb/en/floating-point-accuracy/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (270,23,'BINARY','This page describes the BINARY data type. For details about the operator, see\nBinary Operator.\n\nSyntax\n------\n\nBINARY(M)\n\nDescription\n-----------\n\nThe BINARY type is similar to the CHAR type, but stores binary byte strings\nrather than non-binary character strings. M represents the column length in\nbytes.\n\nIt contains no character set, and comparison and sorting are based on the\nnumeric value of the bytes.\n\nIf the maximum length is exceeded, and SQL strict mode is not enabled , the\nextra characters will be dropped with a warning. If strict mode is enabled, an\nerror will occur.\n\nBINARY values are right-padded with 0x00 (the zero byte) to the specified\nlength when inserted. The padding is not removed on select, so this needs to\nbe taken into account when sorting and comparing, where all bytes are\nsignificant. The zero byte, 0x00 is less than a space for comparison purposes.\n\nExamples\n--------\n\nInserting too many characters, first with strict mode off, then with it on:\n\nCREATE TABLE bins (a BINARY(10));\n\nINSERT INTO bins VALUES(\'12345678901\');\nQuery OK, 1 row affected, 1 warning (0.04 sec)\n\nSELECT * FROM bins;\n+------------+\n| a          |\n+------------+\n| 1234567890 |\n+------------+\n\nSET sql_mode=\'STRICT_ALL_TABLES\';\n\nINSERT INTO bins VALUES(\'12345678901\');\nERROR 1406 (22001): Data too long for column \'a\' at row 1\n\nSorting is performed with the byte value:\n\nTRUNCATE bins;\n\nINSERT INTO bins VALUES(\'A\'),(\'B\'),(\'a\'),(\'b\');\n\nSELECT * FROM bins ORDER BY a;\n+------+\n| a    |\n+------+\n| A    |\n| B    |\n| a    |\n| b    |\n+------+\n\nUsing CAST to sort as a CHAR instead:\n\nSELECT * FROM bins ORDER BY CAST(a AS CHAR);\n+------+\n| a    |\n+------+\n| a    |\n| A    |\n| b    |\n| B    |\n+------+\n\nThe field is a BINARY(10), so padding of two \'\\0\'s are inserted, causing\ncomparisons that don\'t take this into account to fail:\n\nTRUNCATE bins;\n\nINSERT INTO bins VALUES(\'12345678\');\n\nSELECT a = \'12345678\', a = \'12345678\\0\\0\' from bins;\n+----------------+--------------------+\n| a = \'12345678\' | a = \'12345678\\0\\0\' |\n+----------------+--------------------+\n|              0 |                  1 |\n+----------------+--------------------+\n\nURL: https://mariadb.com/kb/en/binary/','','https://mariadb.com/kb/en/binary/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (271,23,'BLOB','Syntax\n------\n\nBLOB[(M)]\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 65,535 (216 - 1) bytes. Each BLOB value\nis stored using a two-byte length prefix that indicates the number of bytes in\nthe value.\n\nAn optional length M can be given for this type. If this is done, MariaDB\ncreates the column as the smallest BLOB type large enough to hold values M\nbytes long.\n\nBLOBS can also be used to store dynamic columns.\n\nBLOB and TEXT columns can both be assigned a DEFAULT value.\n\nIndexing\n--------\n\nMariaDB starting with 10.4\n--------------------------\nFrom MariaDB 10.4, it is possible to set a unique index on a column that uses\nthe BLOB data type. In previous releases this was not possible, as the index\nwould only guarantee the uniqueness of a fixed number of characters.\n\nOracle Mode\n-----------\n\nIn Oracle mode from MariaDB 10.3, BLOB is a synonym for LONGBLOB.\n\nURL: https://mariadb.com/kb/en/blob/','','https://mariadb.com/kb/en/blob/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (272,23,'BLOB and TEXT Data Types','Description\n-----------\n\nA BLOB is a binary large object that can hold a variable amount of data. The\nfour BLOB types are\n\n* TINYBLOB,\n* BLOB, \n* MEDIUMBLOB, and\n* LONGBLOB.\n\nThese differ only in the maximum length of the values they can hold.\n\nThe TEXT types are\n\n* TINYTEXT,\n* TEXT,\n* MEDIUMTEXT, and\n* LONGTEXT.\n* JSON (alias for LONGTEXT)\n\nThese correspond to the four BLOB types and have the same maximum lengths and\nstorage requirements.\n\nBLOB and TEXT columns can have a DEFAULT value.\n\nMariaDB starting with 10.4.3\n----------------------------\nFrom MariaDB 10.4, it is possible to set a unique index on columns that use\nthe BLOB or TEXT data types.\n\nURL: https://mariadb.com/kb/en/blob-and-text-data-types/','','https://mariadb.com/kb/en/blob-and-text-data-types/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (273,23,'CHAR','This article covers the CHAR data type. See CHAR Function for the function.\n\nSyntax\n------\n\n[NATIONAL] CHAR[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA fixed-length string that is always right-padded with spaces to the specified\nlength when stored. M represents the column length in characters. The range of\nM is 0 to 255. If M is omitted, the length is 1.\n\nCHAR(0) columns can contain 2 values: an empty string or NULL. Such columns\ncannot be part of an index. The CONNECT storage engine does not support\nCHAR(0).\n\nNote: Trailing spaces are removed when CHAR values are retrieved unless the\nPAD_CHAR_TO_FULL_LENGTH SQL mode is enabled.\n\nBefore MariaDB 10.2, all collations were of type PADSPACE, meaning that CHAR\n(as well as VARCHAR and TEXT) values are compared without regard for trailing\nspaces. This does not apply to the LIKE pattern-matching operator, which takes\ninto account trailing spaces.\n\nIf a unique index consists of a column where trailing pad characters are\nstripped or ignored, inserts into that column where values differ only by the\nnumber of trailing pad characters will result in a duplicate-key error.\n\nExamples\n--------\n\nTrailing spaces:\n\nCREATE TABLE strtest (c CHAR(10));\nINSERT INTO strtest VALUES(\'Maria   \');\n\nSELECT c=\'Maria\',c=\'Maria   \' FROM strtest;\n+-----------+--------------+\n| c=\'Maria\' | c=\'Maria   \' |\n+-----------+--------------+\n|         1 |            1 |\n+-----------+--------------+\n\nSELECT c LIKE \'Maria\',c LIKE \'Maria   \' FROM strtest;\n+----------------+-------------------+\n| c LIKE \'Maria\' | c LIKE \'Maria   \' |\n+----------------+-------------------+\n|              1 |                 0 |\n+----------------+-------------------+\n\nNO PAD Collations\n-----------------\n\nNO PAD collations regard trailing spaces as normal characters. You can get a\nlist of all NO PAD collations by querying the Information Schema Collations\ntable, for example:\n\nSELECT collation_name FROM information_schema.collations \n WHERE collation_name LIKE \"%nopad%\";\n+------------------------------+\n| collation_name               |\n+------------------------------+\n| big5_chinese_nopad_ci        |\n| big5_nopad_bin               |\n...\n\nURL: https://mariadb.com/kb/en/char/','','https://mariadb.com/kb/en/char/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (274,23,'CHAR BYTE','Description\n-----------\n\nThe CHAR BYTE data type is an alias for the BINARY data type. This is a\ncompatibility feature.\n\nURL: https://mariadb.com/kb/en/char-byte/','','https://mariadb.com/kb/en/char-byte/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (275,23,'ENUM','Syntax\n------\n\nENUM(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nDescription\n-----------\n\nAn enumeration. A string object that can have only one value, chosen from the\nlist of values \'value1\', \'value2\', ..., NULL or the special \'\' error value. In\ntheory, an ENUM column can have a maximum of 65,535 distinct values; in\npractice, the real maximum depends on many factors. ENUM values are\nrepresented internally as integers.\n\nTrailing spaces are automatically stripped from ENUM values on table creation.\n\nENUMs require relatively little storage space compared to strings, either one\nor two bytes depending on the number of enumeration values.\n\nNULL and empty values\n---------------------\n\nAn ENUM can also contain NULL and empty values. If the ENUM column is declared\nto permit NULL values, NULL becomes a valid value, as well as the default\nvalue (see below). If strict SQL Mode is not enabled, and an invalid value is\ninserted into an ENUM, a special empty string, with an index value of zero\n(see Numeric index, below), is inserted, with a warning. This may be\nconfusing, because the empty string is also a possible value, and the only\ndifference if that is this case its index is not 0. Inserting will fail with\nan error if strict mode is active.\n\nIf a DEFAULT clause is missing, the default value will be:\n\n* NULL if the column is nullable;\n* otherwise, the first value in the enumeration.\n\nNumeric index\n-------------\n\nENUM values are indexed numerically in the order they are defined, and sorting\nwill be performed in this numeric order. We suggest not using ENUM to store\nnumerals, as there is little to no storage space benefit, and it is easy to\nconfuse the enum integer with the enum numeral value by leaving out the quotes.\n\nAn ENUM defined as ENUM(\'apple\',\'orange\',\'pear\') would have the following\nindex values:\n\n+--------------------------------------+--------------------------------------+\n| Index                                | Value                                |\n+--------------------------------------+--------------------------------------+\n| NULL                                 | NULL                                 |\n+--------------------------------------+--------------------------------------+\n| 0                                    | \'\'                                   |\n+--------------------------------------+--------------------------------------+\n| 1                                    | \'apple\'                              |\n+--------------------------------------+--------------------------------------+\n| 2                                    | \'orange\'                             |\n+--------------------------------------+--------------------------------------+\n| 3                                    | \'pear\'                               |\n+--------------------------------------+--------------------------------------+\n\nExamples\n--------\n\nCREATE TABLE fruits (\n id INT NOT NULL auto_increment PRIMARY KEY,\n fruit ENUM(\'apple\',\'orange\',\'pear\'),\n bushels INT);\n\nDESCRIBE fruits;\n+---------+-------------------------------+------+-----+---------+-------------\n--+\n| Field   | Type                          | Null | Key | Default | Extra      \n |\n+---------+-------------------------------+------+-----+---------+-------------\n--+\n| id      | int(11)                       | NO   | PRI | NULL    |\nauto_increment |\n| fruit   | enum(\'apple\',\'orange\',\'pear\') | YES  |     | NULL    |            \n |\n| bushels | int(11)                       | YES  |     | NULL    |            \n |\n+---------+-------------------------------+------+-----+---------+-------------\n--+\n\nINSERT INTO fruits\n  (fruit,bushels) VALUES\n  (\'pear\',20),\n  (\'apple\',100),\n  (\'orange\',25);\n\nINSERT INTO fruits\n  (fruit,bushels) VALUES\n  (\'avocado\',10);\nERROR 1265 (01000): Data truncated for column \'fruit\' at row 1\n\nSELECT * FROM fruits;\n+----+--------+---------+\n| id | fruit  | bushels |\n+----+--------+---------+\n|  1 | pear   |      20 |\n|  2 | apple  |     100 |\n|  3 | orange |      25 |\n+----+--------+---------+\n\nSelecting by numeric index:\n\nSELECT * FROM fruits WHERE fruit=2;\n+----+--------+---------+\n| id | fruit  | bushels |\n+----+--------+---------+\n|  3 | orange |      25 |\n+----+--------+---------+\n\nSorting is according to the index value:\n\nCREATE TABLE enums (a ENUM(\'2\',\'1\'));\n\nINSERT INTO enums VALUES (\'1\'),(\'2\');\n\nSELECT * FROM enums ORDER BY a ASC;\n+------+\n| a    |\n+------+\n| 2    |\n| 1    |\n+------+\n\nIt\'s easy to get confused between returning the enum integer with the stored\nvalue, so we don\'t suggest using ENUM to store numerals. The first example\nreturns the 1st indexed field (\'2\' has an index value of 1, as it\'s defined\nfirst), while the second example returns the string value \'1\'.\n\nSELECT * FROM enums WHERE a=1;\n+------+\n| a    |\n+------+\n| 2    |\n+------+\n\nSELECT * FROM enums WHERE a=\'1\';\n+------+\n| a    |\n+------+\n| 1    |\n+------+\n\nURL: https://mariadb.com/kb/en/enum/','','https://mariadb.com/kb/en/enum/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (276,23,'INET4','MariaDB starting with 10.10.0\n-----------------------------\nThe INET4 data type was added in MariaDB 10.10.0\n\nSyntax\n------\n\nINET4\n\nDescription\n-----------\n\nINET4 is a data type to store IPv4 addresses, as 4-byte binary strings.\n\nExamples\n--------\n\nCREATE OR REPLACE TABLE t1 (a INET4);\n\nINSERT INTO t1 VALUES(\'0.0.0.0\'), (\'255.10.0.0\'), (\'255.255.255.255\');\n\nINSERT INTO t1 VALUES (0xa0000001);\nINSERT INTO t1 VALUES (0xf0000000);\nINSERT INTO t1 VALUES (0xff000001);\n\nSELECT HEX(a), a FROM t1 ORDER BY a;\n+----------+-----------------+\n| HEX(a)   | a               |\n+----------+-----------------+\n| 00000000 | 0.0.0.0         |\n| A0000001 | 160.0.0.1       |\n| F0000000 | 240.0.0.0       |\n| FF000001 | 255.0.0.1       |\n| FF0A0000 | 255.10.0.0      |\n| FFFFFFFF | 255.255.255.255 |\n+----------+-----------------+\n\nURL: https://mariadb.com/kb/en/inet4/','','https://mariadb.com/kb/en/inet4/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (277,23,'INET6','MariaDB starting with 10.5.0\n----------------------------\nThe INET6 data type was added in MariaDB 10.5.0\n\nSyntax\n------\n\nINET6\n\nDescription\n-----------\n\nThe INET6 data type is intended for storage of IPv6 addresses, as well as IPv4\naddresses assuming conventional mapping of IPv4 addresses into IPv6 addresses.\n\nBoth short and long IPv6 notation are permitted, according to RFC-5952.\n\n* Values are stored as a 16-byte fixed length binary string, with most\nsignificant byte first.\n* Storage engines see INET6 as BINARY(16).\n* Clients see INET6 as CHAR(39) and get text representation on retrieval.\n\nThe IPv4-compatible notation is considered as deprecated. It is supported for\ncompatibility with the INET6_ATON function, which also understands this\nformat. It\'s recommended to use the mapped format to store IPv4 addresses in\nINET6.\n\nWhen an IPv4 mapped (or compatible) value is stored in INET6, it still\noccupies 16 bytes:\n\nRetrieval\n---------\n\nOn retrieval, in the client-server text protocol, INET6 values are converted\nto the short text representation, according to RFC-5952, that is with all\nleading zeroes in each group removed and with consequent zero groups\ncompressed.\n\nBesides creating one\'s own stored function, there is no a way to retrieve an\nINET6 value using long text representation.\n\nCasting\n-------\n\n* CAST from a character string to INET6 understands addresses in short or long\ntext notation (including IPv4 mapped and compatible addresses). NULL is\nreturned if the format is not understood.\n* CAST from a binary string to INET6 requires a 16-byte string as an argument.\nNULL is returned if the argument length is not equal to 16.\n* CAST from other data types to INET6 first converts data to a character\nstring, then CAST from character string to INET6 is applied.\n* CAST from INET6 to CHAR returns short text address notation.\n* CAST from INET6 to BINARY returns its 16-byte binary string representation.\n* CAST from INET6 to data types other than CHAR (e.g. SIGNED, UNSIGNED, TIME,\netc) returns an error.\n\nComparisons\n-----------\n\nAn INET6 expression can be compared to:\n\n* another INET6 expression\n* a character string expression with a text (short or long) address\nrepresentation:\n* a 16-byte binary string expression:\n\nAttempting to compare INET6 to an expression of any other data type returns an\nerror.\n\nMixing INET6 Values for Result\n------------------------------\n\nAn INET6 expression can be mixed for result (i.e. UNION, CASE..THEN, COALESCE\netc) with:\n\n* another INET6 expression. The resulting data type is INET6.\n* a character string in text (short or long) address representation. The\nresult data type is INET6. The character string counterpart is automatically\nconverted to INET6. If the string format is not understood, it\'s converted\nwith a warning to either NULL or to \'::\', depending on the NULL-ability of the\nresult.\n* a 16-byte binary string. The resulting data type is INET6. The binary string\ncounterpart is automatically converted to INET6. If the length of the binary\nstring is not equal to 16, it\'s converted with a warning to NULL or to \'::\'\ndepending on the NULL-ability of the result.\n\nAttempts to mix INET6 for result with other data types will return an error.\n\nMixing INET6 with other data types for LEAST and GREATEST, when mixing for\ncomparison and mixing for result are involved at the same time, uses the same\nrules with mixing for result, described in the previous paragraphs.\n\nFunctions and Operators\n-----------------------\n\n* HEX() with an INET6 argument returns a hexadecimal representation of the\nunderlying 16-byte binary string\n* Arithmetic operators (+,-,*,/,MOD,DIV) are not supported for INET6. This may\nchange in the future.\n* The INET6_ATON function now understands INET6 values as an argument\n* The prototypes of the IS_IPV4_COMPAT and IS_IPV4_MAPPED functions have\nchanged from a BINARY(16) to a INET6,\n* When the argument for these two functions is not INET6, automatic implicit\nCAST to INET6 is applied. As a consequence, both functions now understand\narguments in both text representation and binary(16) representation. Before\nMariaDB 10.5.0, these functions understood only binary(16) representation.\n\nPrepared Statement Parameters\n-----------------------------\n\nINET6 understands both text and binary(16) address representation in prepared\nstatement parameters (PREPARE..EXECUTE and EXECUTE IMMEDIATE statements).\n\nMigration between  BINARY(16) and INET6\n---------------------------------------\n\nBefore MariaDB 10.5.0, you may have used BINARY(16) as a storage for IPv6\ninternet addresses, in combination with INET6_ATON and INET6_NTOA to\nrespectively insert and retrieve data.\n\nFrom 10.5, you can ALTER BINARY(16) columns storing IPv6 addresses to INET6.\nAfter such an alter, there is no a need to use INET6_ATON() and INET6_NTOA().\nAddresses can be inserted and retrieved directly.\n\nIt is also possible to convert INET6 columns to BINARY(16) and continue using\nthe data in combination with INET6_NTOA() and INET6_ATON().\n\nExamples\n--------\n\nCREATE TABLE t1 (a INET6);\n\nInserting using short text address notation:\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nLong text address notation:\n\nINSERT INTO t1 VALUES (\'2001:0db8:0000:0000:0000:ff00:0042:8329\');\n\n16-byte binary string notation:\n\nINSERT INTO t1 VALUES (0x20010DB8000000000000FF0000428329);\nINSERT INTO t1 VALUES (UNHEX(\'20010DB8000000000000FF0000428329\'));\n\nIPv4 addresses, using IPv4-mapped and IPv4-compatible notations:\n\nINSERT INTO t1 VALUES (\'::ffff:192.0.2.128\'); -- mapped\nINSERT INTO t1 VALUES (\'::192.0.2.128\'); -- compatible\n\nSELECT * FROM t1;\n+------------------------+\n| a                      |\n+------------------------+\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| 2001:db8::ff00:42:8329 |\n| ::ffff:192.0.2.128     |\n| ::192.0.2.128          |\n+------------------------+\n\nIPv4 mapped (or compatible) values still occupy 16 bytes:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'::ffff:192.0.2.128\');\n\nSELECT * FROM t1;\n+--------------------+\n| a                  |\n+--------------------+\n| ::ffff:192.0.2.128 |\n+--------------------+\n\nSELECT HEX(a) FROM t1;\n+----------------------------------+\n| HEX(a)                           |\n+----------------------------------+\n| 00000000000000000000FFFFC0000280 |\n+----------------------------------+\n\nCasting from INET6 to anything other than CHAR returns an error:\n\nSELECT CAST(a AS DECIMAL) FROM t1;\n\nERROR 4079 (HY000): Illegal parameter data type inet6 for operation\n\'decimal_typecast\'\n\nComparison Examples\n-------------------\n\nComparison with another INET6 expression:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n  CREATE OR REPLACE TABLE t2 (a INET6);\n\nINSERT INTO t1 VALUES\n(\'2001:db8::ff00:42:8328\'),(\'2001:db8::ff00:42:8329\');\n  INSERT INTO t2 VALUES\n(\'2001:db8::ff00:42:832a\'),(\'2001:db8::ff00:42:8329\');\n\nSELECT t1.* FROM t1,t2 WHERE t1.a=t2.a;\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith a character string expression with a text (short or long) address\nrepresentation:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT * FROM t1 WHERE a=\'2001:db8::ff00:42:8329\';\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith a 16-byte binary string expression:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT * FROM t1 WHERE a=X\'20010DB8000000000000FF0000428329\';\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nWith an expression of another data type:\n\nSELECT * FROM t1 WHERE a=1;\nERROR 4078 (HY000): Illegal parameter data types inet6 and int for operation\n\'=\'\n\nMixing for Result Examples\n--------------------------\n\nMixed with another INET6 expression, returning an INET6 data type:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b INET6);\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:8329\');\n\nSELECT a FROM t1 UNION SELECT b FROM t1;\n  +------------------------+\n  | a                      |\n  +------------------------+\n  | NULL                   |\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nSELECT COALESCE(a, b) FROM t1;\n  +------------------------+\n  | COALESCE(a, b)         |\n  +------------------------+\n  | 2001:db8::ff00:42:8329 |\n  +------------------------+\n\nMixed with a character string in text (short or long) address representation:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b VARCHAR(64));\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:8328\');\n\nINSERT INTO t1 VALUES (NULL,\'2001:db8::ff00:42:832a garbage\');\n\nSELECT COALESCE(a,b) FROM t1;\n  +------------------------+\n  | COALESCE(a,b)          |\n  +------------------------+\n  | 2001:db8::ff00:42:8328 |\n  | NULL                   |\n  +------------------------+\n  2 rows in set, 1 warning (0.001 sec)\n\nSHOW WARNINGS;\n\n+---------+------+---------------------------------------------------------+\n  | Level   | Code | Message\n|\n\n+---------+------+---------------------------------------------------------+\n  | Warning | 1292 | Incorrect inet6 value: \'2001:db8::ff00:42:832a garbage\'\n|\n\n+---------+------+---------------------------------------------------------+\n\nMixed with a 16-byte binary string:\n\nCREATE OR REPLACE TABLE t1 (a INET6, b VARBINARY(16));\n\nINSERT INTO t1 VALUES (NULL,CONCAT(0xFFFF,REPEAT(0x0000,6),0xFFFF));\n\nINSERT INTO t1 VALUES (NULL,0x00/*garbage*/);\n\nSELECT COALESCE(a,b) FROM t1;\n  +---------------+\n  | COALESCE(a,b) |\n  +---------------+\n  | ffff::ffff    |\n  | NULL          |\n  +---------------+\n  2 rows in set, 1 warning (0.001 sec)\n\nSHOW WARNINGS;\n  +---------+------+-------------------------------+\n  | Level   | Code | Message                       |\n  +---------+------+-------------------------------+\n  | Warning | 1292 | Incorrect inet6 value: \'\\x00\' |\n  +---------+------+-------------------------------+\n\nMixing with other data types:\n\nSELECT CAST(\'ffff::ffff\' AS INET6) UNION SELECT 1;\nERROR 4078 (HY000): Illegal parameter data types inet6 and int for operation\n\'UNION\'\n\nFunctions and Operators Examples\n--------------------------------\n\nHEX with an INET6 argument returning a hexadecimal representation:\n\nSELECT HEX(CAST(\'2001:db8::ff00:42:8329\' AS INET6));\n  +----------------------------------------------+\n  | HEX(CAST(\'2001:db8::ff00:42:8329\' AS INET6)) |\n  +----------------------------------------------+\n  | 20010DB8000000000000FF0000428329             |\n  +----------------------------------------------+\n\nINET6_ATON now understands INET6 values as an argument:\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n\nSELECT a, HEX(INET6_ATON(a)) FROM t1;\n  +------------------------+----------------------------------+\n  | a                      | HEX(INET6_ATON(a))               |\n  +------------------------+----------------------------------+\n  | 2001:db8::ff00:42:8329 | 20010DB8000000000000FF0000428329 |\n  +------------------------+----------------------------------+\n\nIS_IPV4_COMPAT and IS_IPV4_MAPPED prototype now a BINARY(16)):\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\n  INSERT INTO t1 VALUES (\'::ffff:192.168.0.1\');\n  INSERT INTO t1 VALUES (\'::192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), IS_IPV4_COMPAT(a) FROM t1;\n  +------------------------+-------------------+-------------------+\n  | a                      | IS_IPV4_MAPPED(a) | IS_IPV4_COMPAT(a) |\n  +------------------------+-------------------+-------------------+\n  | 2001:db8::ff00:42:8329 |                 0 |                 0 |\n  | ::ffff:192.168.0.1     |                 1 |                 0 |\n  | ::192.168.0.1          |                 0 |                 1 |\n  +------------------------+-------------------+-------------------+\n\nAutomatic implicit CAST to INET6:\n\nCREATE OR REPLACE TABLE t1 (\n   a INET6,\n   b VARCHAR(39) DEFAULT a\n  );\n\nINSERT INTO t1 (a) VALUES (\'ffff::ffff\'),(\'::ffff:192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), b, IS_IPV4_MAPPED(b) FROM t1;\n\n+--------------------+-------------------+--------------------+----------------\n--+\n  | a                  | IS_IPV4_MAPPED(a) | b                  |\nIS_IPV4_MAPPED(b) |\n\n+--------------------+-------------------+--------------------+----------------\n--+\n  | ffff::ffff         |                 0 | ffff::ffff         |\n  0 |\n  | ::ffff:192.168.0.1 |                 1 | ::ffff:192.168.0.1 |\n  1 |\n\n+--------------------+-------------------+--------------------+----------------\n--+\n\nCREATE OR REPLACE TABLE t1 (\n   a INET6,\n   b BINARY(16) DEFAULT UNHEX(HEX(a))\n  );\n\nINSERT INTO t1 (a) VALUES (\'ffff::ffff\'),(\'::ffff:192.168.0.1\');\n\nSELECT a, IS_IPV4_MAPPED(a), HEX(b), IS_IPV4_MAPPED(b) FROM t1;\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n  | a                  | IS_IPV4_MAPPED(a) | HEX(b)\n | IS_IPV4_MAPPED(b) |\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n  | ffff::ffff         |                 0 |\nFFFF000000000000000000000000FFFF |                 0 |\n  | ::ffff:192.168.0.1 |                 1 |\n00000000000000000000FFFFC0A80001 |                 1 |\n\n+--------------------+-------------------+----------------------------------+--\n----------------+\n\nPrepared Statement Parameters Examples\n--------------------------------------\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING \'ffff::fffe\';\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING\nX\'FFFF000000000000000000000000FFFF\';\n\nSELECT * FROM t1;\n+------------+\n| a          |\n+------------+\n| ffff::fffe |\n| ffff::ffff |\n+------------+\n\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING \'ffff::fffe\';\n+------------+\n| a          |\n+------------+\n| ffff::fffe |\n+------------+\n\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING','','https://mariadb.com/kb/en/inet6/');
update help_topic set description = CONCAT(description, '\nX\'FFFF000000000000000000000000FFFF\';\n+------------+\n| a          |\n+------------+\n| ffff::ffff |\n+------------+\n\nMigration between BINARY(16) and INET6 Examples\n-----------------------------------------------\n\nBefore MariaDB 10.5:\n\nCREATE OR REPLACE TABLE t1 (a BINARY(16));\n\nINSERT INTO t1 VALUES (INET6_ATON(\'ffff::ffff\'));\n\nSELECT INET6_NTOA(a) FROM t1;\n+---------------+\n| INET6_NTOA(a) |\n+---------------+\n| ffff::ffff    |\n+---------------+\n\nMigrating to INET6, from MariaDB 10.5:\n\nALTER TABLE t1 MODIFY a INET6;\n\nINSERT INTO t1 VALUES (\'ffff::fffe\');\n\nSELECT * FROM t1;\n+------------+\n| a          |\n+------------+\n| ffff::ffff |\n| ffff::fffe |\n+------------+\n\nMigration from INET6 to BINARY(16):\n\nCREATE OR REPLACE TABLE t1 (a INET6);\n\nINSERT INTO t1 VALUES (\'2001:db8::ff00:42:8329\');\nINSERT INTO t1 VALUES (\'::ffff:192.168.0.1\');\nINSERT INTO t1 VALUES (\'::192.168.0.1\');\n\nALTER TABLE t1 MODIFY a BINARY(16);\n\nSELECT INET6_NTOA(a) FROM t1;\n+------------------------+\n| INET6_NTOA(a)          |\n+------------------------+\n| 2001:db8::ff00:42:8329 |\n| ::ffff:192.168.0.1     |\n| ::192.168.0.1          |\n+------------------------+\n\nURL: https://mariadb.com/kb/en/inet6/') WHERE help_topic_id = 277;
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (278,23,'JSON Data Type','The JSON alias was added to make it possible to use JSON columns in statement\nbased replication from MySQL to MariaDB and to make it possible for MariaDB to\nread mysqldumps from MySQL.\n\nJSON is an alias for LONGTEXT introduced for compatibility reasons with\nMySQL\'s JSON data type. MariaDB implements this as a LONGTEXT rather, as the\nJSON data type contradicts the SQL standard, and MariaDB\'s benchmarks indicate\nthat performance is at least equivalent.\n\nIn order to ensure that a a valid json document is inserted, the JSON_VALID\nfunction can be used as a CHECK constraint. This constraint is automatically\nincluded for types using the JSON alias from MariaDB 10.4.3.\n\nExamples\n--------\n\nCREATE TABLE t (j JSON);\n\nDESC t;\n+-------+----------+------+-----+---------+-------+\n| Field | Type     | Null | Key | Default | Extra |\n+-------+----------+------+-----+---------+-------+\n| j     | longtext | YES  |     | NULL    |       |\n+-------+----------+------+-----+---------+-------+\n\nWith validation:\n\nCREATE TABLE t2 (\n j JSON\n CHECK (JSON_VALID(j))\n);\n\nINSERT INTO t2 VALUES (\'invalid\');\nERROR 4025 (23000): CONSTRAINT `j` failed for `test`.`t2`\n\nINSERT INTO t2 VALUES (\'{\"id\": 1, \"name\": \"Monty\"}\');\nQuery OK, 1 row affected (0.13 sec)\n\nReplicating JSON Data Between MySQL and MariaDB\n-----------------------------------------------\n\nThe JSON type in MySQL stores the JSON object in a compact form, not as\nLONGTEXT as in MariaDB. This means that row based replication will not work\nfor JSON types from MySQL to MariaDB.\n\nThere are a a few different ways to solve this:\n\n* Use statement based replication.\n* Change the JSON column to type TEXT in MySQL\n* If you must use row-based replication and cannot change the MySQL master\nfrom JSON to TEXT, you can try to introduce an intermediate MySQL slave and\nchange the column type from JSON to TEXT on it. Then you replicate from this\nintermediate slave to MariaDB.\n\nConverting a MySQL TABLE with JSON Fields to MariaDB\n----------------------------------------------------\n\nMariaDB can\'t directly access MySQL\'s JSON format.\n\nThere are a a few different ways to move the table to MariaDB:\n\n* From MariaDB 10.5.7, see the you can use the mysql_json plugin. See Making\nMariaDB understand MySQL JSON.\n* Change the JSON column to type TEXT in MySQL.  After this, MariaDB can\ndirectly use the table without any need for a dump and restore.\n* Use mysqldump to copy the table.\n\nDifferences Between MySQL JSON Strings and MariaDB JSON Strings\n---------------------------------------------------------------\n\n* In MySQL, JSON is an object and is compared according to json values. In\nMariaDB JSON strings are normal strings and compared as strings. One exception\nis when using JSON_EXTRACT() in which case strings are unescaped before\ncomparison.\n\nURL: https://mariadb.com/kb/en/json-data-type/','','https://mariadb.com/kb/en/json-data-type/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (279,23,'MEDIUMBLOB','Syntax\n------\n\nMEDIUMBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 16,777,215 (224 - 1) bytes. Each\nMEDIUMBLOB value is stored using a three-byte length prefix that indicates the\nnumber of bytes in the value.\n\nURL: https://mariadb.com/kb/en/mediumblob/','','https://mariadb.com/kb/en/mediumblob/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (280,23,'MEDIUMTEXT','Syntax\n------\n\nMEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 16,777,215 (224 - 1) characters. The\neffective maximum length is less if the value contains multi-byte characters.\nEach MEDIUMTEXT value is stored using a three-byte length prefix that\nindicates the number of bytes in the value.\n\nURL: https://mariadb.com/kb/en/mediumtext/','','https://mariadb.com/kb/en/mediumtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (281,23,'LONGBLOB','Syntax\n------\n\nLONGBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 4,294,967,295 bytes or 4GB (232 - 1).\nThe effective maximum length of LONGBLOB columns depends on the configured\nmaximum packet size in the client/server protocol and available memory. Each\nLONGBLOB value is stored using a four-byte length prefix that indicates the\nnumber of bytes in the value.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, BLOB is a synonym for LONGBLOB.\n\nURL: https://mariadb.com/kb/en/longblob/','','https://mariadb.com/kb/en/longblob/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (282,23,'LONGTEXT','Syntax\n------\n\nLONGTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 4,294,967,295 or 4GB (232 - 1)\ncharacters. The effective maximum length is less if the value contains\nmulti-byte characters. The effective maximum length of LONGTEXT columns also\ndepends on the configured maximum packet size in the client/server protocol\nand available memory. Each LONGTEXT value is stored using a four-byte length\nprefix that indicates the number of bytes in the value.\n\nFrom MariaDB 10.2.7, JSON is an alias for LONGTEXT. See JSON Data Type for\ndetails.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, CLOB is a synonym for LONGTEXT.\n\nURL: https://mariadb.com/kb/en/longtext/','','https://mariadb.com/kb/en/longtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (283,23,'ROW','MariaDB starting with 10.3.0\n----------------------------\nThe ROW data type was introduced in MariaDB 10.3.0.\n\nSyntax\n------\n\nROW (<field name> <data type> [{, <field name> <data type>}... ])\n\nDescription\n-----------\n\nROW is a data type for stored procedure variables.\n\nFeatures\n--------\n\nROW fields as normal variables\n------------------------------\n\nROW fields (members) act as normal variables, and are able to appear in all\nquery parts where a stored procedure variable is allowed:\n\n* Assignment is using the := operator and the SET command:\n\na.x:= 10;\na.x:= b.x;\nSET a.x= 10, a.y=20, a.z= b.z;\n\n* Passing to functions and operators:\n\nSELECT f1(rec.a), rec.a<10;\n\n* Clauses (select list, WHERE, HAVING, LIMIT, etc...,):\n\nSELECT var.a, t1.b FROM t1 WHERE t1.b=var.b LIMIT var.c;\n\n* INSERT values:\n\nINSERT INTO t1 VALUES (rec.a, rec.b, rec.c);\n\n* SELECT .. INTO targets\n\nSELECT a,b INTO rec.a, rec.b FROM t1 WHERE t1.id=10;\n\n* Dynamic SQL out parameters (EXECUTE and EXECUTE IMMEDIATE)\n\nEXECUTE IMMEDIATE \'CALL proc_with_out_param(?)\' USING rec.a;\n\nROW type variables as FETCH targets\n-----------------------------------\n\nROW type variables are allowed as FETCH targets:\n\nFETCH cur INTO rec;\n\nwhere cur is a CURSOR and rec is a ROW type stored procedure variable.\n\nNote, currently an attempt to use FETCH for a ROW type variable returns this\nerror:\n\nERROR 1328 (HY000): Incorrect number of FETCH variables\n\nFETCH from a cursor cur into a ROW variable rec works as follows:\n\n* The number of fields in cur must match the number of fields in rec.\n Otherwise, an error is reported.\n\n* Assignment is done from left to right. The first cursor field is assigned to\n the first variable field, the second cursor field is assigned to the second\n variable field, etc.\n\n* Field names in rec are not important and can differ from field names\n in cur.\n\nSee FETCH Examples (below) for examples of using this with sql_mode=ORACLE and\nsql_mode=DEFAULT.\n\nROW type variables as SELECT...INTO targets\n-------------------------------------------\n\nROW type variables are allowed as SELECT..INTO targets with some differences\ndepending on which sql_mode is in use.\n\n* When using sql_mode=ORACLE, table%ROWTYPE and cursor%ROWTYPE\n variables can be used as SELECT...INTO targets.\n\n* Using multiple ROW variables in the SELECT..INTO list will report an\n error.\n\n* Using ROW variables with a different column count than in\n the SELECT..INTO list will report an error.\n\nSee SELECT...INTO Examples (below) for examples of using this with\nsql_mode=ORACLE and sql_mode=DEFAULT.\n\nFeatures not implemented\n------------------------\n\nThe following features are planned, but not implemented yet:\n\n* Returning a ROW type expression from a stored function (see MDEV-12252).\nThis will need some grammar change to support field names after parentheses:\n\nSELECT f1().x FROM DUAL;\n\n* Returning a ROW type expression from a built-in hybrid type function, such\nas CASE, IF, etc. \n* ROW of ROWs\n\nExamples\n--------\n\nDeclaring a ROW in a stored procedure\n-------------------------------------\n\nDELIMITER $$\nCREATE PROCEDURE p1()\nBEGIN\n DECLARE r ROW (c1 INT, c2 VARCHAR(10));\n SET r.c1= 10;\n SET r.c2= \'test\';\n INSERT INTO t1 VALUES (r.c1, r.c2);\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nFETCH Examples\n--------------\n\nA complete FETCH example for sql_mode=ORACLE:\n\nDROP TABLE IF EXISTS t1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nINSERT INTO t1 VALUES (20,\'b20\');\nINSERT INTO t1 VALUES (30,\'b30\');\n\nSET sql_mode=oracle;\nDROP PROCEDURE IF EXISTS p1;\nDELIMITER $$\nCREATE PROCEDURE p1 AS\n rec ROW(a INT, b VARCHAR(32));\n CURSOR c IS SELECT a,b FROM t1;\nBEGIN\n OPEN c;\n LOOP\n  FETCH c INTO rec;\n  EXIT WHEN c%NOTFOUND;\n  SELECT (\'rec=(\' || rec.a ||\',\'|| rec.b||\')\');\n END LOOP;\n CLOSE c;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nA complete FETCH example for sql_mode=DEFAULT:\n\nDROP TABLE IF EXISTS t1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nINSERT INTO t1 VALUES (20,\'b20\');\nINSERT INTO t1 VALUES (30,\'b30\');\n\nSET sql_mode=DEFAULT;\nDROP PROCEDURE IF EXISTS p1;\nDELIMITER $$\nCREATE PROCEDURE p1()\nBEGIN\n DECLARE done INT DEFAULT FALSE;\n DECLARE rec ROW(a INT, b VARCHAR(32));\n DECLARE c CURSOR FOR SELECT a,b FROM t1;\n DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;\n OPEN c;\nread_loop:\n LOOP\n  FETCH c INTO rec;\n  IF done THEN\n   LEAVE read_loop;\n  END IF;\n  SELECT CONCAT(\'rec=(\',rec.a,\',\',rec.b,\')\');\n END LOOP;\n CLOSE c;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nSELECT...INTO Examples\n----------------------\n\nA SELECT...INTO example for sql_mode=DEFAULT:\n\nSET sql_mode=DEFAULT;\nDROP TABLE IF EXISTS t1;\nDROP PROCEDURE IF EXISTS p1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nDELIMITER $$\nCREATE PROCEDURE p1()\nBEGIN\n DECLARE rec1 ROW(a INT, b VARCHAR(32));\n SELECT * FROM t1 INTO rec1;\n SELECT rec1.a, rec1.b;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nThe above example returns:\n\n+--------+--------+\n| rec1.a | rec1.b |\n+--------+--------+\n|     10 | b10    |\n+--------+--------+\n\nA SELECT...INTO example for sql_mode=ORACLE:\n\nSET sql_mode=ORACLE;\nDROP TABLE IF EXISTS t1;\nDROP PROCEDURE IF EXISTS p1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nDELIMITER $$\nCREATE PROCEDURE p1 AS\n rec1 ROW(a INT, b VARCHAR(32));\nBEGIN\n SELECT * FROM t1 INTO rec1;\n SELECT rec1.a, rec1.b;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nThe above example returns:\n\n+--------+--------+\n| rec1.a | rec1.b |\n+--------+--------+\n|     10 | b10    |\n+--------+--------+\n\nAn example for sql_mode=ORACLE using table%ROWTYPE variables as SELECT..INTO\ntargets:\n\nSET sql_mode=ORACLE;\nDROP TABLE IF EXISTS t1;\nDROP PROCEDURE IF EXISTS p1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nDELIMITER $$\nCREATE PROCEDURE p1 AS\n rec1 t1%ROWTYPE;\nBEGIN\n SELECT * FROM t1 INTO rec1;\n SELECT rec1.a, rec1.b;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nThe above example returns:\n\n+--------+--------+\n| rec1.a | rec1.b |\n+--------+--------+\n|     10 | b10    |\n+--------+--------+\n\nAn example for sql_mode=ORACLE using cursor%ROWTYPE variables as SELECT..INTO\ntargets:\n\nSET sql_mode=ORACLE;\nDROP TABLE IF EXISTS t1;\nDROP PROCEDURE IF EXISTS p1;\nCREATE TABLE t1 (a INT, b VARCHAR(32));\nINSERT INTO t1 VALUES (10,\'b10\');\nDELIMITER $$\nCREATE PROCEDURE p1 AS\n CURSOR cur1 IS SELECT * FROM t1;\n rec1 cur1%ROWTYPE;\nBEGIN\n SELECT * FROM t1 INTO rec1;\n SELECT rec1.a, rec1.b;\nEND;\n$$\nDELIMITER ;\nCALL p1();\n\nThe above example returns:\n\n+--------+--------+\n| rec1.a | rec1.b |\n+--------+--------+\n|     10 | b10    |\n+--------+--------+\n\nURL: https://mariadb.com/kb/en/row/','','https://mariadb.com/kb/en/row/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (284,23,'TEXT','Syntax\n------\n\nTEXT[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 65,535 (216 - 1) characters. The\neffective maximum length is less if the value contains multi-byte characters.\nEach TEXT value is stored using a two-byte length prefix that indicates the\nnumber of bytes in the value. If you need a bigger storage, consider using\nMEDIUMTEXT instead.\n\nAn optional length M can be given for this type. If this is done, MariaDB\ncreates the column as the smallest TEXT type large enough to hold values M\ncharacters long.\n\nBefore MariaDB 10.2, all MariaDB collations were of type PADSPACE, meaning\nthat TEXT (as well as VARCHAR and CHAR values) are compared without regard for\ntrailing spaces. This does not apply to the LIKE pattern-matching operator,\nwhich takes into account trailing spaces.\n\nBefore MariaDB 10.2.1, BLOB and TEXT columns could not be assigned a DEFAULT\nvalue. This restriction was lifted in MariaDB 10.2.1.\n\nExamples\n--------\n\nTrailing spaces:\n\nCREATE TABLE strtest (d TEXT(10));\nINSERT INTO strtest VALUES(\'Maria   \');\n\nSELECT d=\'Maria\',d=\'Maria   \' FROM strtest;\n+-----------+--------------+\n| d=\'Maria\' | d=\'Maria   \' |\n+-----------+--------------+\n|         1 |            1 |\n+-----------+--------------+\n\nSELECT d LIKE \'Maria\',d LIKE \'Maria   \' FROM strtest;\n+----------------+-------------------+\n| d LIKE \'Maria\' | d LIKE \'Maria   \' |\n+----------------+-------------------+\n|              0 |                 1 |\n+----------------+-------------------+\n\nIndexing\n--------\n\nTEXT columns can only be indexed over a specified length. This means that they\ncannot be used as the primary key of a table norm until MariaDB 10.4, can a\nunique index be created on them.\n\nMariaDB starting with 10.4\n--------------------------\nStarting with MariaDB 10.4, a unique index can be created on a TEXT column.\n\nInternally, this uses hash indexing to quickly check the values and if a hash\ncollision is found, the actual stored values are compared in order to retain\nthe uniqueness.\n\nDifference between VARCHAR and TEXT\n-----------------------------------\n\n* VARCHAR columns can be fully indexed. TEXT columns can only be indexed over\na specified length.\n* Using TEXT or BLOB in a SELECT query that uses temporary tables for storing\nintermediate results will force the temporary table to be disk based (using\nthe Aria storage engine instead of the memory storage engine, which is a bit\nslower. This is not that bad as the Aria storage engine caches the rows in\nmemory. To get the benefit of this, one should ensure that the\naria_pagecache_buffer_size variable is big enough to hold most of the row and\nindex data for temporary tables.\n\nFor Storage Engine Developers\n-----------------------------\n\n* Internally the full length of the VARCHAR column is allocated inside each\nTABLE objects record[] structure. As there are three such buffers, each open\ntable will allocate 3 times max-length-to-store-varchar bytes of memory.\n* TEXT and BLOB columns are stored with a pointer (4 or 8 bytes) + a 1-4 bytes\nlength.  The TEXT data is only stored once. This means that internally TEXT\nuses less memory for each open table but instead has the additional overhead\nthat each TEXT object needs to be allocated and freed for each row access\n(with some caching in between).\n\nURL: https://mariadb.com/kb/en/text/','','https://mariadb.com/kb/en/text/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (285,23,'TINYBLOB','Syntax\n------\n\nTINYBLOB\n\nDescription\n-----------\n\nA BLOB column with a maximum length of 255 (28 - 1) bytes. Each TINYBLOB value\nis stored using a one-byte length prefix that indicates the number of bytes in\nthe value.\n\nURL: https://mariadb.com/kb/en/tinyblob/','','https://mariadb.com/kb/en/tinyblob/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (286,23,'TINYTEXT','Syntax\n------\n\nTINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA TEXT column with a maximum length of 255 (28 - 1) characters. The effective\nmaximum length is less if the value contains multi-byte characters. Each\nTINYTEXT value is stored using a one-byte length prefix that indicates the\nnumber of bytes in the value.\n\nURL: https://mariadb.com/kb/en/tinytext/','','https://mariadb.com/kb/en/tinytext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (287,23,'VARBINARY','Syntax\n------\n\nVARBINARY(M)\n\nDescription\n-----------\n\nThe VARBINARY type is similar to the VARCHAR type, but stores binary byte\nstrings rather than non-binary character strings. M represents the maximum\ncolumn length in bytes.\n\nIt contains no character set, and comparison and sorting are based on the\nnumeric value of the bytes.\n\nIf the maximum length is exceeded, and SQL strict mode is not enabled , the\nextra characters will be dropped with a warning. If strict mode is enabled, an\nerror will occur.\n\nUnlike BINARY values, VARBINARYs are not right-padded when inserting.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, RAW is a synonym for VARBINARY.\n\nExamples\n--------\n\nInserting too many characters, first with strict mode off, then with it on:\n\nCREATE TABLE varbins (a VARBINARY(10));\n\nINSERT INTO varbins VALUES(\'12345678901\');\nQuery OK, 1 row affected, 1 warning (0.04 sec)\n\nSELECT * FROM varbins;\n+------------+\n| a          |\n+------------+\n| 1234567890 |\n+------------+\n\nSET sql_mode=\'STRICT_ALL_TABLES\';\n\nINSERT INTO varbins VALUES(\'12345678901\');\nERROR 1406 (22001): Data too long for column \'a\' at row 1\n\nSorting is performed with the byte value:\n\nTRUNCATE varbins;\n\nINSERT INTO varbins VALUES(\'A\'),(\'B\'),(\'a\'),(\'b\');\n\nSELECT * FROM varbins ORDER BY a;\n+------+\n| a    |\n+------+\n| A    |\n| B    |\n| a    |\n| b    |\n+------+\n\nUsing CAST to sort as a CHAR instead:\n\nSELECT * FROM varbins ORDER BY CAST(a AS CHAR);\n+------+\n| a    |\n+------+\n| a    |\n| A    |\n| b    |\n| B    |\n+------+\n\nURL: https://mariadb.com/kb/en/varbinary/','','https://mariadb.com/kb/en/varbinary/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (288,23,'VARCHAR','Syntax\n------\n\n[NATIONAL] VARCHAR(M) [CHARACTER SET charset_name] [COLLATE collation_name]\n\nDescription\n-----------\n\nA variable-length string. M represents the maximum column length in\ncharacters. The range of M is 0 to 65,532. The effective maximum length of a\nVARCHAR is subject to the maximum row size and the character set used. For\nexample, utf8 characters can require up to three bytes per character, so a\nVARCHAR column that uses the utf8 character set can be declared to be a\nmaximum of 21,844 characters.\n\nNote: For the ColumnStore engine, M represents the maximum column length in\nbytes.\n\nMariaDB stores VARCHAR values as a one-byte or two-byte length prefix plus\ndata. The length prefix indicates the number of bytes in the value. A VARCHAR\ncolumn uses one length byte if values require no more than 255 bytes, two\nlength bytes if values may require more than 255 bytes.\n\nMariaDB follows the standard SQL specification, and does not remove trailing\nspaces from VARCHAR values.\n\nVARCHAR(0) columns can contain 2 values: an empty string or NULL. Such columns\ncannot be part of an index. The CONNECT storage engine does not support\nVARCHAR(0).\n\nVARCHAR is shorthand for CHARACTER VARYING. NATIONAL VARCHAR is the standard\nSQL way to define that a VARCHAR column should use some predefined character\nset. MariaDB uses utf8 as this predefined character set, as does MySQL 4.1 and\nup. NVARCHAR is shorthand for NATIONAL VARCHAR.\n\nBefore MariaDB 10.2, all MariaDB collations were of type PADSPACE, meaning\nthat VARCHAR (as well as CHAR and TEXT values) are compared without regard for\ntrailing spaces. This does not apply to the LIKE pattern-matching operator,\nwhich takes into account trailing spaces. From MariaDB 10.2, a number of NO\nPAD collations are available.\n\nIf a unique index consists of a column where trailing pad characters are\nstripped or ignored, inserts into that column where values differ only by the\nnumber of trailing pad characters will result in a duplicate-key error.\n\nExamples\n--------\n\nThe following are equivalent:\n\nVARCHAR(30) CHARACTER SET utf8\nNATIONAL VARCHAR(30)\nNVARCHAR(30)\nNCHAR VARCHAR(30)\nNATIONAL CHARACTER VARYING(30)\nNATIONAL CHAR VARYING(30)\n\nTrailing spaces:\n\nCREATE TABLE strtest (v VARCHAR(10));\nINSERT INTO strtest VALUES(\'Maria   \');\n\nSELECT v=\'Maria\',v=\'Maria   \' FROM strtest;\n+-----------+--------------+\n| v=\'Maria\' | v=\'Maria   \' |\n+-----------+--------------+\n|         1 |            1 |\n+-----------+--------------+\n\nSELECT v LIKE \'Maria\',v LIKE \'Maria   \' FROM strtest;\n+----------------+-------------------+\n| v LIKE \'Maria\' | v LIKE \'Maria   \' |\n+----------------+-------------------+\n|              0 |                 1 |\n+----------------+-------------------+\n\nTruncation\n----------\n\n* Depending on whether or not strict sql mode is set, you will either get a\nwarning or an error if you try to insert a string that is too long into a\nVARCHAR column. If the extra characters are spaces, the spaces that can\'t fit\nwill be removed and you will always get a warning, regardless of the sql mode\nsetting.\n\nDifference Between VARCHAR and TEXT\n-----------------------------------\n\n* VARCHAR columns can be fully indexed. TEXT columns can only be indexed over\na specified length.\n* Using TEXT or BLOB in a SELECT query that uses temporary tables for storing\nintermediate results will force the temporary table to be disk based (using\nthe Aria storage engine instead of the memory storage engine, which is a bit\nslower. This is not that bad as the Aria storage engine caches the rows in\nmemory. To get the benefit of this, one should ensure that the\naria_pagecache_buffer_size variable is big enough to hold most of the row and\nindex data for temporary tables.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, VARCHAR2 is a synonym.\n\nFor Storage Engine Developers\n-----------------------------\n\n* Internally the full length of the VARCHAR column is allocated inside each\nTABLE objects record[] structure. As there are three such buffers, each open\ntable will allocate 3 times max-length-to-store-varchar bytes of memory.\n* TEXT and BLOB columns are stored with a pointer (4 or 8 bytes) + a 1-4 bytes\nlength.  The TEXT data is only stored once. This means that internally TEXT\nuses less memory for each open table but instead has the additional overhead\nthat each TEXT object needs to be allocated and freed for each row access\n(with some caching in between).\n\nURL: https://mariadb.com/kb/en/varchar/','','https://mariadb.com/kb/en/varchar/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (289,23,'SET Data Type','Syntax\n------\n\nSET(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nDescription\n-----------\n\nA set. A string object that can have zero or more values, each of which must\nbe chosen from the list of values \'value1\', \'value2\', ... A SET column can\nhave a maximum of 64 members. SET values are represented internally as\nintegers.\n\nSET values cannot contain commas.\n\nIf a SET contains duplicate values, an error will be returned if strict mode\nis enabled, or a warning if strict mode is not enabled.\n\nURL: https://mariadb.com/kb/en/set-data-type/','','https://mariadb.com/kb/en/set-data-type/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (290,23,'UUID Data Type','MariaDB starting with 10.7.0\n----------------------------\nThe UUID data type was added in a MariaDB 10.7.0 preview.\n\nSyntax\n------\n\nUUID\n\nDescription\n-----------\n\nThe UUID data type is intended for the storage of 128-bit UUID (Universally\nUnique Identifier) data. See the UUID function page for more details on UUIDs\nthemselves.\n\nRetrieval\n---------\n\nData retrieved by this data type is in the string representation defined in\nRFC4122.\n\nCasting\n-------\n\nString literals of hexadecimal characters and CHAR/VARCHAR/TEXT can be cast to\nthe UUID data type. Likewise hexadecimal literals, binary-literals, and\nBINARY/VARBINARY/BLOB types can also be cast to UUID.\n\nThe data type will not accept a short UUID generated with the UUID_SHORT\nfunction, but will accept a value without the - character generated by the\nSYS_GUID function (or inserted directly). Hyphens can be partially omitted as\nwell, or included after any group of two digits.\n\nThe type does not accept UUIDs in braces, permitted by some implementations.\n\nStorage\n-------\n\nUUID are stored in an index friendly manner, the order of a UUID of\nllllllll-mmmm-Vhhh-vsss-nnnnnnnnnnnn is stored as:\n\nnnnnnnnnnnnn-vsss-Vhhh-mmmm-llllllll\n\nThis provides a sorting order, if a UUIDv1 (node and timestamp) is used, of\nthe node, followed by the timestamp.\n\nExamples\n--------\n\nCREATE TABLE t1 (id UUID);\n\nDirectly Inserting via string literals:\n\nINSERT INTO t1 VALUES(\'123e4567-e89b-12d3-a456-426655440000\');\n\nDirectly Inserting via hexadecimal literals:\n\nINSERT INTO t1 VALUES (x\'fffffffffffffffffffffffffffffffe\');\n\nGenerating and inserting via the UUID function.\n\nINSERT INTO t1 VALUES (UUID());\n\nRetrieval:\n\nSELECT * FROM t1;\n+--------------------------------------+\n| id                                   |\n+--------------------------------------+\n| 123e4567-e89b-12d3-a456-426655440000 |\n| ffffffff-ffff-ffff-ffff-fffffffffffe |\n| 93aac041-1a14-11ec-ab4e-f859713e4be4 |\n+--------------------------------------+\n\nThe UUID_SHORT function does not generate valid full-length UUID:\n\nINSERT INTO t1 VALUES (UUID_SHORT());\nERROR 1292 (22007): Incorrect uuid value: \'99440417627439104\' \n for column `test`.`t1`.`id` at row 1\n\nAccepting a value without the - character, either directly or generated by the\nSYS_GUID function:\n\nINSERT INTO t1 VALUES (SYS_GUID());\n\nSELECT * FROM t1;\n+--------------------------------------+\n| id                                   |\n+--------------------------------------+\n| 123e4567-e89b-12d3-a456-426655440000 |\n| ffffffff-ffff-ffff-ffff-fffffffffffe |\n| 93aac041-1a14-11ec-ab4e-f859713e4be4 |\n| ea0368d3-1a14-11ec-ab4e-f859713e4be4 |\n+--------------------------------------+\n\nSELECT SYS_GUID();\n+----------------------------------+\n| SYS_GUID()                       |\n+----------------------------------+\n| ff5b6bcc1a1411ecab4ef859713e4be4 |\n+----------------------------------+\n\nINSERT INTO t1 VALUES (\'ff5b6bcc1a1411ecab4ef859713e4be4\');\n\nSELECT * FROM t1;\n+--------------------------------------+\n| id                                   |\n+--------------------------------------+\n| 123e4567-e89b-12d3-a456-426655440000 |\n| ffffffff-ffff-ffff-ffff-fffffffffffe |\n| 93aac041-1a14-11ec-ab4e-f859713e4be4 |\n| ea0368d3-1a14-11ec-ab4e-f859713e4be4 |\n| ff5b6bcc-1a14-11ec-ab4e-f859713e4be4 |\n+--------------------------------------+\n\nValid and invalid hyphen and brace usage:\n\nTRUNCATE t1;\n\nINSERT INTO t1 VALUES (\'f8aa-ed66-1a1b-11ec-ab4e-f859-713e-4be4\');\n\nINSERT INTO t1 VALUES (\'1b80667f1a1c-11ecab4ef859713e4be4\');\n\nINSERT INTO t1 VALUES (\'2fd6c945-1a-1c-11ec-ab4e-f859713e4be4\');\n\nINSERT INTO t1 VALUES (\'49-c9-f9-59-1a-1c-11ec-ab4e-f859713e4be4\');\n\nINSERT INTO t1 VALUES (\'57-96-da-c1-1a-1c-11-ec-ab-4e-f8-59-71-3e-4b-e4\');\n\nINSERT INTO t1 VALUES (\'6-eb74f8f-1a1c-11ec-ab4e-f859713e4be4\');\n\nINSERT INTO t1 VALUES (\'{29bad136-1a1d-11ec-ab4e-f859713e4be4}\');\nERROR 1292 (22007): Incorrect uuid value:\n\'{29bad136-1a1d-11ec-ab4e-f859713e4be4}\' \n for column `test`.`t1`.`id` at row 1\n\nSELECT * FROM t1;\n+--------------------------------------+\n| id                                   |\n+--------------------------------------+\n| f8aaed66-1a1b-11ec-ab4e-f859713e4be4 |\n| 1b80667f-1a1c-11ec-ab4e-f859713e4be4 |\n| 2fd6c945-1a1c-11ec-ab4e-f859713e4be4 |\n| 49c9f959-1a1c-11ec-ab4e-f859713e4be4 |\n| 5796dac1-1a1c-11ec-ab4e-f859713e4be4 |\n| 6eb74f8f-1a1c-11ec-ab4e-f859713e4be4 |\n+--------------------------------------+\n\nURL: https://mariadb.com/kb/en/uuid-data-type/','','https://mariadb.com/kb/en/uuid-data-type/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (291,23,'DATE','Syntax\n------\n\nDATE\n\nDescription\n-----------\n\nA date. The supported range is \'1000-01-01\' to \'9999-12-31\'. MariaDB displays\nDATE values in \'YYYY-MM-DD\' format, but can be assigned dates in looser\nformats, including strings or numbers, as long as they make sense. These\ninclude a short year, YY-MM-DD, no delimiters, YYMMDD, or any other acceptable\ndelimiter, for example YYYY/MM/DD. For details, see date and time literals.\n\n\'0000-00-00\' is a permitted special value (zero-date), unless the NO_ZERO_DATE\nSQL_MODE is used. Also, individual components of a date can be set to 0 (for\nexample: \'2015-00-12\'), unless the NO_ZERO_IN_DATE SQL_MODE is used. In many\ncases, the result of en expression involving a zero-date, or a date with\nzero-parts, is NULL. If the ALLOW_INVALID_DATES SQL_MODE is enabled, if the\nday part is in the range between 1 and 31, the date does not produce any\nerror, even for months that have less than 31 days.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, DATE with a time portion is a synonym for\nDATETIME. See also mariadb_schema.\n\nExamples\n--------\n\nCREATE TABLE t1 (d DATE);\n\nINSERT INTO t1 VALUES (\"2010-01-12\"), (\"2011-2-28\"), (\'120314\'),(\'13*04*21\');\n\nSELECT * FROM t1;\n+------------+\n| d          |\n+------------+\n| 2010-01-12 |\n| 2011-02-28 |\n| 2012-03-14 |\n| 2013-04-21 |\n+------------+\n\nURL: https://mariadb.com/kb/en/date/','','https://mariadb.com/kb/en/date/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (292,23,'TIME','Syntax\n------\n\nTIME [(<microsecond precision>)]\n\nDescription\n-----------\n\nA time. The range is \'-838:59:59.999999\' to \'838:59:59.999999\'. Microsecond\nprecision can be from 0-6; if not specified 0 is used. Microseconds have been\navailable since MariaDB 5.3.\n\nMariaDB displays TIME values in \'HH:MM:SS.ssssss\' format, but allows\nassignment of times in looser formats, including \'D HH:MM:SS\', \'HH:MM:SS\',\n\'HH:MM\', \'D HH:MM\', \'D HH\', \'SS\', or \'HHMMSS\', as well as permitting dropping\nof any leading zeros when a delimiter is provided, for example \'3:9:10\'. For\ndetails, see date and time literals.\n\nMariaDB 10.1.2 introduced the --mysql56-temporal-format option, on by default,\nwhich allows MariaDB to store TIMEs using the same low-level format MySQL 5.6\nuses.\n\nInternal Format\n---------------\n\nIn MariaDB 10.1.2 a new temporal format was introduced from MySQL 5.6 that\nalters how the TIME, DATETIME and TIMESTAMP columns operate at lower levels.\nThese changes allow these temporal data types to have fractional parts and\nnegative values. You can disable this feature using the\nmysql56_temporal_format system variable.\n\nTables that include TIMESTAMP values that were created on an older version of\nMariaDB or that were created while the mysql56_temporal_format system variable\nwas disabled continue to store data using the older data type format.\n\nIn order to update table columns from the older format to the newer format,\nexecute an ALTER TABLE... MODIFY COLUMN statement that changes the column to\nthe *same* data type. This change may be needed if you want to export the\ntable\'s tablespace and import it onto a server that has\nmysql56_temporal_format=ON set (see MDEV-15225).\n\nFor instance, if you have a TIME column in your table:\n\nSHOW VARIABLES LIKE \'mysql56_temporal_format\';\n\n+-------------------------+-------+\n| Variable_name           | Value |\n+-------------------------+-------+\n| mysql56_temporal_format | ON    |\n+-------------------------+-------+\n\nALTER TABLE example_table MODIFY ts_col TIME;\n\nWhen MariaDB executes the ALTER TABLE statement, it converts the data from the\nolder temporal format to the newer one.\n\nIn the event that you have several tables and columns using temporal data\ntypes that you want to switch over to the new format, make sure the system\nvariable is enabled, then perform a dump and restore using mariadb-dump. The\ncolumns using relevant temporal data types are restored using the new temporal\nformat.\n\nStarting from MariaDB 10.5.1 columns with old temporal formats are marked with\na /* mariadb-5.3 */ comment in the output of SHOW CREATE TABLE, SHOW COLUMNS,\nDESCRIBE statements, as well as in the COLUMN_TYPE column of the\nINFORMATION_SCHEMA.COLUMNS Table.\n\nSHOW CREATE TABLE mariadb5312_time\\G\n*************************** 1. row ***************************\n   Table: mariadb5312_time\nCreate Table: CREATE TABLE `mariadb5312_time` (\n `t0` time /* mariadb-5.3 */ DEFAULT NULL,\n `t6` time(6) /* mariadb-5.3 */ DEFAULT NULL\n) ENGINE=MyISAM DEFAULT CHARSET=latin1\n\nNote, columns with the current format are not marked with a comment.\n\nExamples\n--------\n\nINSERT INTO time VALUES (\'90:00:00\'), (\'800:00:00\'), (800), (22), (151413),\n(\'9:6:3\'), (\'12 09\');\n\nSELECT * FROM time;\n+-----------+\n| t         |\n+-----------+\n| 90:00:00  |\n| 800:00:00 |\n| 00:08:00  |\n| 00:00:22  |\n| 15:14:13  |\n| 09:06:03  |\n| 297:00:00 |\n+-----------+\n\nURL: https://mariadb.com/kb/en/time/','','https://mariadb.com/kb/en/time/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (293,23,'DATETIME','Syntax\n------\n\nDATETIME [(microsecond precision)]\n\nDescription\n-----------\n\nA date and time combination.\n\nMariaDB displays DATETIME values in \'YYYY-MM-DD HH:MM:SS.ffffff\' format, but\nallows assignment of values to DATETIME columns using either strings or\nnumbers. For details, see date and time literals.\n\nDATETIME columns also accept CURRENT_TIMESTAMP as the default value.\n\nMariaDB 10.1.2 introduced the --mysql56-temporal-format option, on by default,\nwhich allows MariaDB to store DATETMEs using the same low-level format MySQL\n5.6 uses. For more information, see Internal Format, below.\n\nFor storage requirements, see Data Type Storage Requirements.\n\nSupported Values\n----------------\n\nMariaDB stores values that use the DATETIME data type in a format that\nsupports values between 1000-01-01 00:00:00.000000 and 9999-12-31\n23:59:59.999999.\n\nMariaDB can also store microseconds with a precision between 0 and 6. If no\nmicrosecond precision is specified, then 0 is used by default.\n\nMariaDB also supports \'0000-00-00\' as a special zero-date value, unless\nNO_ZERO_DATE is specified in the SQL_MODE. Similarly, individual components of\na date can be set to 0 (for example: \'2015-00-12\'), unless NO_ZERO_IN_DATE is\nspecified in the SQL_MODE. In many cases, the result of en expression\ninvolving a zero-date, or a date with zero-parts, is NULL. If the\nALLOW_INVALID_DATES SQL_MODE is enabled, if the day part is in the range\nbetween 1 and 31, the date does not produce any error, even for months that\nhave less than 31 days.\n\nOracle Mode\n-----------\n\nMariaDB starting with 10.3\n--------------------------\nIn Oracle mode from MariaDB 10.3, DATE with a time portion is a synonym for\nDATETIME. See also mariadb_schema.\n\nInternal Format\n---------------\n\nIn MariaDB 10.1.2 a new temporal format was introduced from MySQL 5.6 that\nalters how the TIME, DATETIME and TIMESTAMP columns operate at lower levels.\nThese changes allow these temporal data types to have fractional parts and\nnegative values. You can disable this feature using the\nmysql56_temporal_format system variable.\n\nTables that include TIMESTAMP values that were created on an older version of\nMariaDB or that were created while the mysql56_temporal_format system variable\nwas disabled continue to store data using the older data type format.\n\nIn order to update table columns from the older format to the newer format,\nexecute an ALTER TABLE... MODIFY COLUMN statement that changes the column to\nthe *same* data type. This change may be needed if you want to export the\ntable\'s tablespace and import it onto a server that has\nmysql56_temporal_format=ON set (see MDEV-15225).\n\nFor instance, if you have a DATETIME column in your table:\n\nSHOW VARIABLES LIKE \'mysql56_temporal_format\';\n\n+-------------------------+-------+\n| Variable_name           | Value |\n+-------------------------+-------+\n| mysql56_temporal_format | ON    |\n+-------------------------+-------+\n\nALTER TABLE example_table MODIFY ts_col DATETIME;\n\nWhen MariaDB executes the ALTER TABLE statement, it converts the data from the\nolder temporal format to the newer one.\n\nIn the event that you have several tables and columns using temporal data\ntypes that you want to switch over to the new format, make sure the system\nvariable is enabled, then perform a dump and restore using mysqldump. The\ncolumns using relevant temporal data types are restored using the new temporal\nformat.\n\nStarting from MariaDB 10.5.1 columns with old temporal formats are marked with\na /* mariadb-5.3 */ comment in the output of SHOW CREATE TABLE, SHOW COLUMNS,\nDESCRIBE statements, as well as in the COLUMN_TYPE column of the\nINFORMATION_SCHEMA.COLUMNS Table.\n\nSHOW CREATE TABLE mariadb5312_datetime\\G\n*************************** 1. row ***************************\n   Table: mariadb5312_datetime\nCreate Table: CREATE TABLE `mariadb5312_datetime` (\n `dt0` datetime /* mariadb-5.3 */ DEFAULT NULL,\n `dt6` datetime(6) /* mariadb-5.3 */ DEFAULT NULL\n) ENGINE=MyISAM DEFAULT CHARSET=latin1\n\nExamples\n--------\n\nCREATE TABLE t1 (d DATETIME);\n\nINSERT INTO t1 VALUES (\"2011-03-11\"), (\"2012-04-19 13:08:22\"),\n (\"2013-07-18 13:44:22.123456\");\n\nSELECT * FROM t1;\n+---------------------+\n| d                   |\n+---------------------+\n| 2011-03-11 00:00:00 |\n| 2012-04-19 13:08:22 |\n| 2013-07-18 13:44:22 |\n+---------------------+\n\nCREATE TABLE t2 (d DATETIME(6));\n\nINSERT INTO t2 VALUES (\"2011-03-11\"), (\"2012-04-19 13:08:22\"),\n (\"2013-07-18 13:44:22.123456\");\n\nSELECT * FROM t2;\n+----------------------------+\n| d                          |\n+----------------------------+\n| 2011-03-11 00:00:00.000000 |\n| 2012-04-19 13:08:22.000000 |\n| 2013-07-18 13:44:22.123456 |\n+----------------------------++\n\nStrings used in datetime context are automatically converted to datetime(6).\nIf you want to have a datetime without seconds, you should use\nCONVERT(..,datetime).\n\nSELECT CONVERT(\'2007-11-30 10:30:19\',datetime);\n+-----------------------------------------+\n| CONVERT(\'2007-11-30 10:30:19\',datetime) |\n+-----------------------------------------+\n| 2007-11-30 10:30:19                     |\n+-----------------------------------------+\n\nSELECT CONVERT(\'2007-11-30 10:30:19\',datetime(6));\n+--------------------------------------------+\n| CONVERT(\'2007-11-30 10:30:19\',datetime(6)) |\n+--------------------------------------------+\n| 2007-11-30 10:30:19.000000                 |\n+--------------------------------------------+\n\nURL: https://mariadb.com/kb/en/datetime/','','https://mariadb.com/kb/en/datetime/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (294,23,'TIMESTAMP','Syntax\n------\n\nTIMESTAMP [(<microsecond precision)]\n\nDescription\n-----------\n\nA timestamp in the format YYYY-MM-DD HH:MM:SS.ffffff.\n\nThe timestamp field is generally used to define at which moment in time a row\nwas added or updated and by default will automatically be assigned the current\ndatetime when a record is inserted or updated. The automatic properties only\napply to the first TIMESTAMP in the record; subsequent TIMESTAMP columns will\nnot be changed.\n\nMariaDB includes the --mysql56-temporal-format option, on by default, which\nallows MariaDB to store TIMESTAMPs using the same low-level format MySQL 5.6\nuses.\n\nFor more information, see Internal Format.\n\nSupported Values\n----------------\n\nMariaDB stores values that use the TIMESTAMP data type as the number of\nseconds since \'1970-01-01 00:00:00\' (UTC). This means that the TIMESTAMP data\ntype can hold values between \'1970-01-01 00:00:01\' (UTC) and \'2038-01-19\n03:14:07\' (UTC).\n\nMariaDB can also store microseconds with a precision between 0 and 6. If no\nmicrosecond precision is specified, then 0 is used by default.\n\nAutomatic Values\n----------------\n\nMariaDB has special behavior for the first column that uses the TIMESTAMP data\ntype in a specific table when the system variable\nexplicit_defaults_for_timestamp is not set (which is the default until MariaDB\n10.10). For the first column that uses the TIMESTAMP data type in a specific\ntable, MariaDB automatically assigns the following properties to the column:\n\n* DEFAULT CURRENT_TIMESTAMP\n* ON UPDATE CURRENT_TIMESTAMP\n\nThis means that if the column is not explicitly assigned a value in an INSERT\nor UPDATE query, then MariaDB will automatically initialize the column\'s value\nwith the current date and time.\n\nThis automatic initialization for INSERT and UPDATE queries can also be\nexplicitly enabled for a column that uses the TIMESTAMP data type by\nspecifying the DEFAULT CURRENT_TIMESTAMP and ON UPDATE CURRENT_TIMESTAMP\nclauses for the column. In these clauses, any synonym of CURRENT_TIMESTAMP is\naccepted, including CURRENT_TIMESTAMP(), NOW(), LOCALTIME, LOCALTIME(),\nLOCALTIMESTAMP, and LOCALTIMESTAMP().\n\nThis automatic initialization for INSERT queries can also be explicitly\ndisabled for a column that uses the TIMESTAMP data type by specifying a\nconstant DEFAULT value. For example, DEFAULT 0.\n\nThis automatic initialization for UPDATE queries can also be explicitly\ndisabled for a column that uses the TIMESTAMP data type by specifying a\nDEFAULT clause for the column, but no ON UPDATE clause. If a DEFAULT clause is\nexplicitly specified for a column that uses the TIMESTAMP data type, but an ON\nUPDATE clause is not specified for the column, then the timestamp value will\nnot automatically change when an UPDATE statement is executed.\n\nMariaDB also has special behavior if NULL is assigned to column that uses the\nTIMESTAMP data type. If the column is assigned the NULL value in an INSERT or\nUPDATE query, then MariaDB will automatically initialize the column\'s value\nwith the current date and time. For details, see NULL values in MariaDB.\n\nThis automatic initialization for NULL values can also be explicitly disabled\nfor a column that uses the TIMESTAMP data type by specifying the NULL\nattribute for the column. In this case, if the column\'s value is set to NULL,\nthen the column\'s value will actually be set to NULL.\n\nTime Zones\n----------\n\nIf a column uses the TIMESTAMP data type, then any inserted values are\nconverted from the session\'s time zone to Coordinated Universal Time (UTC)\nwhen stored, and converted back to the session\'s time zone when retrieved.\n\nMariaDB validates TIMESTAMP literals against the session\'s time zone. For\nexample, if a specific time range never occurred in a specific time zone due\nto daylight savings time, then TIMESTAMP values within that range would be\ninvalid for that time zone.\n\nMariaDB does not currently store any time zone identifier with the value of\nthe TIMESTAMP data type. See MDEV-10018 for more information.\n\nMariaDB does not currently support time zone literals that contain time zone\nidentifiers. See MDEV-11829 for more information.\n\nLimitations\n-----------\n\n* Because the TIMESTAMP value is stored as Epoch Seconds, the timestamp value\n\'1970-01-01 00:00:00\' (UTC) is reserved since the second #0 is used to\nrepresent \'0000-00-00 00:00:00\'.\n* In MariaDB 5.5 and before there could only be one TIMESTAMP column per table\nthat had CURRENT_TIMESTAMP defined as its default value. This limit has no\nlonger applied since MariaDB 10.0.\n\nSQL_MODE=MAXDB\n--------------\n\nIf the SQL_MODE is set to MAXDB, TIMESTAMP fields will be silently converted\nto DATETIME.\n\nInternal Format\n---------------\n\nIn MariaDB 10.1.2 a new temporal format was introduced from MySQL 5.6 that\nalters how the TIME, DATETIME and TIMESTAMP columns operate at lower levels.\nThese changes allow these temporal data types to have fractional parts and\nnegative values. You can disable this feature using the\nmysql56_temporal_format system variable.\n\nTables that include TIMESTAMP values that were created on an older version of\nMariaDB or that were created while the mysql56_temporal_format system variable\nwas disabled continue to store data using the older data type format.\n\nIn order to update table columns from the older format to the newer format,\nexecute an ALTER TABLE... MODIFY COLUMN statement that changes the column to\nthe *same* data type. This change may be needed if you want to export the\ntable\'s tablespace and import it onto a server that has\nmysql56_temporal_format=ON set (see MDEV-15225).\n\nFor instance, if you have a TIMESTAMP column in your table:\n\nSHOW VARIABLES LIKE \'mysql56_temporal_format\';\n\n+-------------------------+-------+\n| Variable_name           | Value |\n+-------------------------+-------+\n| mysql56_temporal_format | ON    |\n+-------------------------+-------+\n\nALTER TABLE example_table MODIFY ts_col TIMESTAMP;\n\nWhen MariaDB executes the ALTER TABLE statement, it converts the data from the\nolder temporal format to the newer one.\n\nIn the event that you have several tables and columns using temporal data\ntypes that you want to switch over to the new format, make sure the system\nvariable is enabled, then perform a dump and restore using mysqldump. The\ncolumns using relevant temporal data types are restored using the new temporal\nformat.\n\nStarting from MariaDB 10.5.1 columns with old temporal formats are marked with\na /* mariadb-5.3 */ comment in the output of SHOW CREATE TABLE, SHOW COLUMNS,\nDESCRIBE statements, as well as in the COLUMN_TYPE column of the\nINFORMATION_SCHEMA.COLUMNS Table.\n\nSHOW CREATE TABLE mariadb5312_timestamp\\G\n*************************** 1. row ***************************\n   Table: mariadb5312_timestamp\nCreate Table: CREATE TABLE `mariadb5312_timestamp` (\n `ts0` timestamp /* mariadb-5.3 */ NOT NULL DEFAULT current_timestamp() ON\nUPDATE current_timestamp(),\n `ts6` timestamp(6) /* mariadb-5.3 */ NOT NULL DEFAULT \'0000-00-00\n00:00:00.000000\'\n) ENGINE=MyISAM DEFAULT CHARSET=latin1\n\nNote: Prior to MySQL 4.1 a different format for the TIMESTAMP datatype was\nused. This format is unsupported in MariaDB 5.1 and upwards.\n\nExamples\n--------\n\nCREATE TABLE t (id INT, ts TIMESTAMP);\n\nDESC t;\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n| Field | Type      | Null | Key | Default           | Extra                  \n  |\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n| id    | int(11)   | YES  |     | NULL              |                        \n  |\n| ts    | timestamp | NO   |     | CURRENT_TIMESTAMP | on update\nCURRENT_TIMESTAMP |\n+-------+-----------+------+-----+-------------------+-------------------------\n---+\n\nINSERT INTO t(id)  VALUES (1),(2);\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    1 | 2013-07-22 12:50:05 |\n|    2 | 2013-07-22 12:50:05 |\n+------+---------------------+\n\nINSERT INTO t  VALUES (3,NULL),(4,\'2001-07-22 12:12:12\');\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    1 | 2013-07-22 12:50:05 |\n|    2 | 2013-07-22 12:50:05 |\n|    3 | 2013-07-22 12:51:56 |\n|    4 | 2001-07-22 12:12:12 |\n+------+---------------------+\n\nConverting to Unix epoch:\n\nSELECT ts, UNIX_TIMESTAMP(ts) FROM t;\n+---------------------+--------------------+\n| ts                  | UNIX_TIMESTAMP(ts) |\n+---------------------+--------------------+\n| 2013-07-22 12:50:05 |         1374490205 |\n| 2013-07-22 12:50:05 |         1374490205 |\n| 2013-07-22 12:51:56 |         1374490316 |\n| 2001-07-22 12:12:12 |          995796732 |\n+---------------------+--------------------+\n\nUpdate also changes the timestamp:\n\nUPDATE t set id=5 WHERE id=1;\n\nSELECT * FROM t;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    5 | 2013-07-22 14:52:33 |\n|    2 | 2013-07-22 12:50:05 |\n|    3 | 2013-07-22 12:51:56 |\n|    4 | 2001-07-22 12:12:12 |\n+------+---------------------+\n\nDefault NULL:\n\nCREATE TABLE t2 (id INT, ts TIMESTAMP NULL ON UPDATE CURRENT_TIMESTAMP);\n\nINSERT INTO t(id)  VALUES (1),(2);\n\nSELECT * FROM t2;\n\nINSERT INTO t2(id)  VALUES (1),(2);\n\nSELECT * FROM t2;\n+------+------+\n| id   | ts   |\n+------+------+\n|    1 | NULL |\n|    2 | NULL |\n+------+------+\n\nUPDATE t2 SET id=3 WHERE id=1;\n\nSELECT * FROM t2;\n+------+---------------------+\n| id   | ts                  |\n+------+---------------------+\n|    3 | 2013-07-22 15:32:22 |\n|    2 | NULL                |\n+------+---------------------+\n\nOnly the first timestamp is automatically inserted and updated:\n\nCREATE TABLE t3 (id INT, ts1 TIMESTAMP, ts2 TIMESTAMP);\n\nINSERT INTO t3(id)  VALUES (1),(2);\n\nSELECT * FROM t3;\n+------+---------------------+---------------------+\n| id   | ts1                 | ts2                 |\n+------+---------------------+---------------------+\n|    1 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    2 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n+------+---------------------+---------------------+\n\nDESC t3;\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n| Field | Type      | Null | Key | Default             | Extra                \n   |\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n| id    | int(11)   | YES  |     | NULL                |                      \n   |\n| ts1   | timestamp | NO   |     | CURRENT_TIMESTAMP   | on update\nCURRENT_TIMESTAMP |\n| ts2   | timestamp | NO   |     | 0000-00-00 00:00:00 |                      \n   |\n+-------+-----------+------+-----+---------------------+-----------------------\n-----+\n\nExplicitly setting a timestamp with the CURRENT_TIMESTAMP function:\n\nINSERT INTO t3(id,ts2)  VALUES (3,CURRENT_TIMESTAMP());\n\nSELECT * FROM t3;\n+------+---------------------+---------------------+\n| id   | ts1                 | ts2                 |\n+------+---------------------+---------------------+\n|    1 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    2 | 2013-07-22 15:35:07 | 0000-00-00 00:00:00 |\n|    3 | 2013-07-22 15:38:52 | 2013-07-22 15:38:52 |\n+------+---------------------+---------------------+\n\nSpecifying the timestamp as NOT NULL:\n\nCREATE TABLE t4 (id INT, ts TIMESTAMP NOT NULL);\n\nINSERT INTO t4(id)  VALUES (1);\nSELECT SLEEP(1);\nINSERT INTO t4(id,ts) VALUES (2,NULL);\n\nSELECT * FROM t4;\n\nURL: https://mariadb.com/kb/en/timestamp/','','https://mariadb.com/kb/en/timestamp/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (295,23,'YEAR Data Type','Syntax\n------\n\nYEAR[(4)]\n\nDescription\n-----------\n\nA year in two-digit or four-digit format. The default is four-digit format.\nNote that the two-digit format has been deprecated since MariaDB 5.5.27.\n\nIn four-digit format, the allowable values are 1901 to 2155, and 0000. In\ntwo-digit format, the allowable values are 70 to 69, representing years from\n1970 to 2069. MariaDB displays YEAR values in YYYY format, but allows you to\nassign values to YEAR columns using either strings or numbers.\n\nInserting numeric zero has a different result for YEAR(4) and YEAR(2). For\nYEAR(2), the value 00 reflects the year 2000. For YEAR(4), the value 0000\nreflects the year zero. This only applies to numeric zero. String zero always\nreflects the year 2000.\n\nExamples\n--------\n\nAccepting a string or a number:\n\nCREATE TABLE y(y YEAR);\n\nINSERT INTO y VALUES (1990),(\'2012\');\n\nSELECT * FROM y;\n+------+\n| y    |\n+------+\n| 1990 |\n| 2012 |\n+------+\n\nWith strict_mode set, the default from MariaDB 10.2.4:\n\nOut of range:\n\nINSERT INTO y VALUES (1005),(\'3080\');\nERROR 1264 (22003): Out of range value for column \'y\' at row 1\n\nINSERT INTO y VALUES (\'2013-12-12\');\nERROR 1265 (01000): Data truncated for column \'y\' at row 1\n\nSELECT * FROM y;\n+------+\n| y    |\n+------+\n| 1990 |\n| 2012 |\n+------+\n\nWith strict_mode unset, the default until MariaDB 10.2.3:\n\nOut of range:\n\nINSERT INTO y VALUES (1005),(\'3080\');\nQuery OK, 2 rows affected, 2 warnings (0.05 sec)\nRecords: 2  Duplicates: 0  Warnings: 2\n\nSHOW WARNINGS;\n+---------+------+--------------------------------------------+\n| Level   | Code | Message                                    |\n+---------+------+--------------------------------------------+\n| Warning | 1264 | Out of range value for column \'y\' at row 1 |\n| Warning | 1264 | Out of range value for column \'y\' at row 2 |\n+---------+------+--------------------------------------------+\n\nSELECT * FROM y;\n+------+\n| y    |\n+------+\n| 1990 |\n| 2012 |\n| 0000 |\n| 0000 |\n+------+\n\nTruncating:\n\nINSERT INTO y VALUES (\'2013-12-12\');\nQuery OK, 1 row affected, 1 warning (0.05 sec)\n\nSHOW WARNINGS;\n+---------+------+----------------------------------------+\n| Level   | Code | Message                                |\n+---------+------+----------------------------------------+\n| Warning | 1265 | Data truncated for column \'y\' at row 1 |\n+---------+------+----------------------------------------+\n\nSELECT * FROM y;\n+------+\n| y    |\n+------+\n| 1990 |\n| 2012 |\n| 0000 |\n| 0000 |\n| 2013 |\n+------+\n\nDifference between YEAR(2) and YEAR(4), and string and numeric zero:\n\nCREATE TABLE y2(y YEAR(4), y2 YEAR(2));\nQuery OK, 0 rows affected, 1 warning (0.40 sec)\n\nNote (Code 1287): \'YEAR(2)\' is deprecated and will be removed in a future\nrelease. \n Please use YEAR(4) instead\n\nINSERT INTO y2 VALUES(0,0),(\'0\',\'0\');\n\nSELECT YEAR(y),YEAR(y2) FROM y2;\n+---------+----------+\n| YEAR(y) | YEAR(y2) |\n+---------+----------+\n|       0 |     2000 |\n|    2000 |     2000 |\n+---------+----------+\n\nURL: https://mariadb.com/kb/en/year-data-type/','','https://mariadb.com/kb/en/year-data-type/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (296,23,'AUTO_INCREMENT','Description\n-----------\n\nThe AUTO_INCREMENT attribute can be used to generate a unique identity for new\nrows. When you insert a new record to the table (or upon adding an\nAUTO_INCREMENT attribute with the ALTER TABLE statement), and the\nauto_increment field is NULL or DEFAULT (in the case of an INSERT), the value\nwill automatically be incremented. This also applies to 0, unless the\nNO_AUTO_VALUE_ON_ZERO SQL_MODE is enabled.\n\nAUTO_INCREMENT columns start from 1 by default. The automatically generated\nvalue can never be lower than 0.\n\nEach table can have only one AUTO_INCREMENT column. It must defined as a key\n(not necessarily the PRIMARY KEY or UNIQUE key). In some storage engines\n(including the default InnoDB), if the key consists of multiple columns, the\nAUTO_INCREMENT column must be the first column. Storage engines that permit\nthe column to be placed elsewhere are Aria, MyISAM, MERGE, Spider, TokuDB,\nBLACKHOLE, FederatedX and Federated.\n\nCREATE TABLE animals (\n  id MEDIUMINT NOT NULL AUTO_INCREMENT,\n  name CHAR(30) NOT NULL,\n  PRIMARY KEY (id)\n );\n\nINSERT INTO animals (name) VALUES\n  (\'dog\'),(\'cat\'),(\'penguin\'),\n  (\'fox\'),(\'whale\'),(\'ostrich\');\n\nSELECT * FROM animals;\n+----+---------+\n| id | name    |\n+----+---------+\n|  1 | dog     |\n|  2 | cat     |\n|  3 | penguin |\n|  4 | fox     |\n|  5 | whale   |\n|  6 | ostrich |\n+----+---------+\n\nSERIAL is an alias for BIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE.\n\nCREATE TABLE t (id SERIAL, c CHAR(1)) ENGINE=InnoDB;\n\nSHOW CREATE TABLE t \\G\n*************************** 1. row ***************************\n   Table: t\nCreate Table: CREATE TABLE `t` (\n `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,\n `c` char(1) DEFAULT NULL,\n UNIQUE KEY `id` (`id`)\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n\nSetting or Changing the Auto_Increment Value\n--------------------------------------------\n\nYou can use an ALTER TABLE statement to assign a new value to the\nauto_increment table option, or set the insert_id server system variable to\nchange the next AUTO_INCREMENT value inserted by the current session.\n\nLAST_INSERT_ID() can be used to see the last AUTO_INCREMENT value inserted by\nthe current session.\n\nALTER TABLE animals AUTO_INCREMENT=8;\n\nINSERT INTO animals (name) VALUES (\'aardvark\');\n\nSELECT * FROM animals;\n+----+-----------+\n| id | name      |\n+----+-----------+\n|  1 | dog       |\n|  2 | cat       |\n|  3 | penguin   |\n|  4 | fox       |\n|  5 | whale     |\n|  6 | ostrich   |\n|  8 | aardvark  |\n+----+-----------+\n\nSET insert_id=12;\n\nINSERT INTO animals (name) VALUES (\'gorilla\');\n\nSELECT * FROM animals;\n+----+-----------+\n| id | name      |\n+----+-----------+\n|  1 | dog       |\n|  2 | cat       |\n|  3 | penguin   |\n|  4 | fox       |\n|  5 | whale     |\n|  6 | ostrich   |\n|  8 | aardvark  |\n| 12 | gorilla   |\n+----+-----------+\n\nInnoDB\n------\n\nUntil MariaDB 10.2.3, InnoDB used an auto-increment counter that is stored in\nmemory. When the server restarts, the counter is re-initialized to the highest\nvalue used in the table, which cancels the effects of any AUTO_INCREMENT = N\noption in the table statements.\n\nFrom MariaDB 10.2.4, this restriction has been lifted and AUTO_INCREMENT is\npersistent.\n\nSee also AUTO_INCREMENT Handling in InnoDB.\n\nSetting Explicit Values\n-----------------------\n\nIt is possible to specify a value for an AUTO_INCREMENT column. If the key is\nprimary or unique, the value must not already exist in the key.\n\nIf the new value is higher than the current maximum value, the AUTO_INCREMENT\nvalue is updated, so the next value will be higher. If the new value is lower\nthan the current maximum value, the AUTO_INCREMENT value remains unchanged.\n\nThe following example demonstrates these behaviors:\n\nCREATE TABLE t (id INTEGER UNSIGNED AUTO_INCREMENT PRIMARY KEY) ENGINE =\nInnoDB;\n\nINSERT INTO t VALUES (NULL);\nSELECT id FROM t;\n+----+\n| id |\n+----+\n|  1 |\n+----+\n\nINSERT INTO t VALUES (10); -- higher value\nSELECT id FROM t;\n+----+\n| id |\n+----+\n|  1 |\n| 10 |\n+----+\n\nINSERT INTO t VALUES (2); -- lower value\nINSERT INTO t VALUES (NULL); -- auto value\nSELECT id FROM t;\n+----+\n| id |\n+----+\n|  1 |\n|  2 |\n| 10 |\n| 11 |\n+----+\n\nThe ARCHIVE storage engine does not allow to insert a value that is lower than\nthe current maximum.\n\nMissing Values\n--------------\n\nAn AUTO_INCREMENT column normally has missing values. This happens because if\na row is deleted, or an AUTO_INCREMENT value is explicitly updated, old values\nare never re-used. The REPLACE statement also deletes a row, and its value is\nwasted. With InnoDB, values can be reserved by a transaction; but if the\ntransaction fails (for example, because of a ROLLBACK) the reserved value will\nbe lost.\n\nThus AUTO_INCREMENT values can be used to sort results in a chronological\norder, but not to create a numeric sequence.\n\nReplication\n-----------\n\nTo make master-master or Galera safe to use AUTO_INCREMENT one should use the\nsystem variables auto_increment_increment and auto_increment_offset to\ngenerate unique values for each server.\n\nCHECK Constraints, DEFAULT Values and Virtual Columns\n-----------------------------------------------------\n\nMariaDB starting with 10.2.6\n----------------------------\nFrom MariaDB 10.2.6 auto_increment columns are no longer permitted in CHECK\nconstraints, DEFAULT value expressions and virtual columns. They were\npermitted in earlier versions, but did not work correctly. See MDEV-11117.\n\nGenerating Auto_Increment Values When Adding the Attribute\n----------------------------------------------------------\n\nCREATE OR REPLACE TABLE t1 (a INT);\nINSERT t1 VALUES (0),(0),(0);\nALTER TABLE t1 MODIFY a INT NOT NULL AUTO_INCREMENT PRIMARY KEY;\nSELECT * FROM t1;\n+---+\n| a |\n+---+\n| 1 |\n| 2 |\n| 3 |\n+---+\n\nCREATE OR REPLACE TABLE t1 (a INT);\nINSERT t1 VALUES (5),(0),(8),(0);\nALTER TABLE t1 MODIFY a INT NOT NULL AUTO_INCREMENT PRIMARY KEY;\nSELECT * FROM t1;\n+---+\n| a |\n+---+\n| 5 |\n| 6 |\n| 8 |\n| 9 |\n+---+\n\nIf the NO_AUTO_VALUE_ON_ZERO SQL_MODE is set, zero values will not be\nautomatically incremented:\n\nSET SQL_MODE=\'no_auto_value_on_zero\';\nCREATE OR REPLACE TABLE t1 (a INT);\nINSERT t1 VALUES (3), (0);\nALTER TABLE t1 MODIFY a INT NOT NULL AUTO_INCREMENT PRIMARY KEY;\nSELECT * FROM t1;\n+---+\n| a |\n+---+\n| 0 |\n| 3 |\n+---+\n\nURL: https://mariadb.com/kb/en/auto_increment/','','https://mariadb.com/kb/en/auto_increment/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (297,24,'Using Compound Statements Outside of Stored Programs','Compound statements can also be used outside of stored programs.\n\ndelimiter |\nIF @have_innodb THEN\n CREATE TABLE IF NOT EXISTS innodb_index_stats (\n  database_name    VARCHAR(64) NOT NULL,\n  table_name       VARCHAR(64) NOT NULL,\n  index_name       VARCHAR(64) NOT NULL,\n  last_update      TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE\nCURRENT_TIMESTAMP,\n  stat_name        VARCHAR(64) NOT NULL,\n  stat_value       BIGINT UNSIGNED NOT NULL,\n  sample_size      BIGINT UNSIGNED,\n  stat_description VARCHAR(1024) NOT NULL,\n  PRIMARY KEY (database_name, table_name, index_name, stat_name)\n ) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin STATS_PERSISTENT=0;\nEND IF|\nQuery OK, 0 rows affected, 2 warnings (0.00 sec)\n\nNote, that using compound statements this way is subject to following\nlimitations:\n\n* Only BEGIN, IF, CASE, LOOP, WHILE, REPEAT statements may start a compound\nstatement outside of stored programs.\n* BEGIN must use the BEGIN NOT ATOMIC syntax (otherwise it\'ll be confused with\nBEGIN that starts a transaction).\n* A compound statement might not start with a label.\n* A compound statement is parsed completely—note \"2 warnings\" in the above\nexample, even if the condition was false (InnoDB was, indeed, disabled), and\nthe CREATE TABLE statement was not executed, it was still parsed and the\nparser produced \"Unknown storage engine\" warning.\n\nInside a compound block first three limitations do not apply, one can use\nanything that can be used inside a stored program — including labels,\ncondition handlers, variables, and so on:\n\nBEGIN NOT ATOMIC\n  DECLARE foo CONDITION FOR 1146;\n  DECLARE x INT DEFAULT 0;\n  DECLARE CONTINUE HANDLER FOR SET x=1;\n  INSERT INTO test.t1 VALUES (\"hndlr1\", val, 2);\n  END|\n\nExample how to use IF:\n\nIF (1>0) THEN BEGIN NOT ATOMIC SELECT 1; END ; END IF;;\n\nExample of how to use WHILE loop:\n\nDELIMITER |\nBEGIN NOT ATOMIC\n  DECLARE x INT DEFAULT 0;\n  WHILE x <= 10 DO\n    SET x = x + 1;\n    SELECT x;\n  END WHILE;\nEND|\nDELIMITER ;\n\nURL:\nhttps://mariadb.com/kb/en/using-compound-statements-outside-of-stored-programs/','','https://mariadb.com/kb/en/using-compound-statements-outside-of-stored-programs/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (298,24,'BEGIN END','Syntax\n------\n\n[begin_label:] BEGIN [NOT ATOMIC]\n  [statement_list]\nEND [end_label]\n\nNOT ATOMIC is required when used outside of a stored procedure. Inside stored\nprocedures or within an anonymous block, BEGIN alone starts a new anonymous\nblock.\n\nDescription\n-----------\n\nBEGIN ... END syntax is used for writing compound statements. A compound\nstatement can contain multiple statements, enclosed by the BEGIN and END\nkeywords. statement_list represents a list of one or more statements, each\nterminated by a semicolon (i.e., ;) statement delimiter. statement_list is\noptional, which means that the empty compound statement (BEGIN END) is legal.\n\nNote that END will perform a commit. If you are running in autocommit mode,\nevery statement will be committed separately. If you are not running in\nautocommit mode, you must execute a COMMIT or ROLLBACK after END to get the\ndatabase up to date.\n\nUse of multiple statements requires that a client is able to send statement\nstrings containing the ; statement delimiter. This is handled in the mysql\ncommand-line client with the DELIMITER command. Changing the ;\nend-of-statement delimiter (for example, to //) allows ; to be used in a\nprogram body.\n\nA compound statement within a stored program can be labeled. end_label cannot\nbe given unless begin_label also is present. If both are present, they must be\nthe same.\n\nBEGIN ... END constructs can be nested. Each block can define its own\nvariables, a CONDITION, a HANDLER and a CURSOR, which don\'t exist in the outer\nblocks. The most local declarations override the outer objects which use the\nsame name (see example below).\n\nThe declarations order is the following:\n\n* DECLARE local variables;\n* DECLARE CONDITIONs;\n* DECLARE CURSORs;\n* DECLARE HANDLERs;\n\nNote that DECLARE HANDLER contains another BEGIN ... END construct.\n\nHere is an example of a very simple, anonymous block:\n\nBEGIN NOT ATOMIC\nSET @a=1;\nCREATE TABLE test.t1(a INT);\nEND|\n\nBelow is an example of nested blocks in a stored procedure:\n\nCREATE PROCEDURE t( )\nBEGIN\n DECLARE x TINYINT UNSIGNED DEFAULT 1;\n BEGIN\n   DECLARE x CHAR(2) DEFAULT \'02\';\n   DECLARE y TINYINT UNSIGNED DEFAULT 10;\n   SELECT x, y;\n END;\n SELECT x;\nEND;\n\nIn this example, a TINYINT variable, x is declared in the outter block. But in\nthe inner block x is re-declared as a CHAR and an y variable is declared. The\ninner SELECT shows the \"new\" value of x, and the value of y. But when x is\nselected in the outer block, the \"old\" value is returned. The final SELECT\ndoesn\'t try to read y, because it doesn\'t exist in that context.\n\nURL: https://mariadb.com/kb/en/begin-end/','','https://mariadb.com/kb/en/begin-end/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (299,24,'CASE Statement','Syntax\n------\n\nCASE case_value\n  WHEN when_value THEN statement_list\n  [WHEN when_value THEN statement_list] ...\n  [ELSE statement_list]\nEND CASE\n\nOr:\n\nCASE\n  WHEN search_condition THEN statement_list\n  [WHEN search_condition THEN statement_list] ...\n  [ELSE statement_list]\nEND CASE\n\nDescription\n-----------\n\nThe text on this page describes the CASE statement for stored programs. See\nthe CASE OPERATOR for details on the CASE operator outside of stored programs.\n\nThe CASE statement for stored programs implements a complex conditional\nconstruct. If a search_condition evaluates to true, the corresponding SQL\nstatement list is executed. If no search condition matches, the statement list\nin the ELSE clause is executed. Each statement_list consists of one or more\nstatements.\n\nThe CASE statement cannot have an ELSE NULL clause, and it is terminated with\nEND CASE instead of END. implements a complex conditional construct. If a\nsearch_condition evaluates to true, the corresponding SQL statement list is\nexecuted. If no search condition matches, the statement list in the ELSE\nclause is executed. Each statement_list consists of one or more statements.\n\nIf no when_value or search_condition matches the value tested and the CASE\nstatement contains no ELSE clause, a Case not found for CASE statement error\nresults.\n\nEach statement_list consists of one or more statements; an empty\nstatement_list is not allowed. To handle situations where no value is matched\nby any WHEN clause, use an ELSE containing an empty BEGIN ... END block, as\nshown in this example:\n\nDELIMITER |\nCREATE PROCEDURE p()\nBEGIN\n DECLARE v INT DEFAULT 1;\n CASE v\n  WHEN 2 THEN SELECT v;\n  WHEN 3 THEN SELECT 0;\n  ELSE BEGIN END;\n END CASE;\nEND;\n|\n\nThe indentation used here in the ELSE clause is for purposes of clarity only,\nand is not otherwise significant. See Delimiters in the mariadb client for\nmore on the use of the delimiter command.\n\nNote: The syntax of the CASE statement used inside stored programs differs\nslightly from that of the SQL CASE expression described in CASE OPERATOR. The\nCASE statement cannot have an ELSE NULL clause, and it is terminated with END\nCASE instead of END.\n\nURL: https://mariadb.com/kb/en/case-statement/','','https://mariadb.com/kb/en/case-statement/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (300,24,'DECLARE CONDITION','Syntax\n------\n\nDECLARE condition_name CONDITION FOR condition_value\n\ncondition_value:\n  SQLSTATE [VALUE] sqlstate_value\n | mysql_error_code\n\nDescription\n-----------\n\nThe DECLARE ... CONDITION statement defines a named error condition. It\nspecifies a condition that needs specific handling and associates a name with\nthat condition. Later, the name can be used in a DECLARE ... HANDLER, SIGNAL\nor RESIGNAL statement (as long as the statement is located in the same BEGIN\n... END block).\n\nConditions must be declared after local variables, but before CURSORs and\nHANDLERs.\n\nA condition_value for DECLARE ... CONDITION can be an SQLSTATE value (a\n5-character string literal) or a MySQL error code (a number). You should not\nuse SQLSTATE value \'00000\' or MySQL error code 0, because those indicate\nsucess rather than an error condition. If you try, or if you specify an\ninvalid SQLSTATE value, an error like this is produced:\n\nERROR 1407 (42000): Bad SQLSTATE: \'00000\'\n\nFor a list of SQLSTATE values and MariaDB error codes, see MariaDB Error Codes.\n\nURL: https://mariadb.com/kb/en/declare-condition/','','https://mariadb.com/kb/en/declare-condition/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (301,24,'DECLARE HANDLER','Syntax\n------\n\nDECLARE handler_type HANDLER\n  FOR condition_value [, condition_value] ...\n  statement\n\nhandler_type:\n  CONTINUE\n | EXIT\n | UNDO\n\ncondition_value:\n  SQLSTATE [VALUE] sqlstate_value\n | condition_name\n | SQLWARNING\n | NOT FOUND\n | SQLEXCEPTION\n | mariadb_error_code\n\nDescription\n-----------\n\nThe DECLARE ... HANDLER statement specifies handlers that each may deal with\none or more conditions. If one of these conditions occurs, the specified\nstatement is executed. statement can be a simple statement (for example, SET\nvar_name = value), or it can be a compound statement written using BEGIN and\nEND.\n\nHandlers must be declared after local variables, a CONDITION and a CURSOR.\n\nFor a CONTINUE handler, execution of the current program continues after\nexecution of the handler statement. For an EXIT handler, execution terminates\nfor the BEGIN ... END compound statement in which the handler is declared.\n(This is true even if the condition occurs in an inner block.) The UNDO\nhandler type statement is not supported.\n\nIf a condition occurs for which no handler has been declared, the default\naction is EXIT.\n\nA condition_value for DECLARE ... HANDLER can be any of the following values:\n\n* An SQLSTATE value (a 5-character string literal) or a MariaDB error\ncode (a number). You should not use SQLSTATE value \'00000\' or MariaDB\nerror code 0, because those indicate sucess rather than an error\ncondition. For a list of SQLSTATE values and MariaDB error codes, see\nMariaDB Error Codes.\n* A condition name previously specified with DECLARE ... CONDITION. It must be\nin the same stored program. See DECLARE CONDITION.\n* SQLWARNING is shorthand for the class of SQLSTATE values that begin\nwith \'01\'.\n* NOT FOUND is shorthand for the class of SQLSTATE values that begin\nwith \'02\'. This is relevant only the context of cursors and is used to\ncontrol what happens when a cursor reaches the end of a data set. If\nno more rows are available, a No Data condition occurs with SQLSTATE\nvalue 02000. To detect this condition, you can set up a handler for it\n(or for a NOT FOUND condition). An example is shown in Cursor Overview. This\ncondition also occurs for SELECT ... INTO var_list statements that retrieve no\nrows.\n* SQLEXCEPTION is shorthand for the class of SQLSTATE values that do\nnot begin with \'00\', \'01\', or \'02\'.\n\nWhen an error raises, in some cases it could be handled by multiple HANDLERs.\nFor example, there may be an handler for 1050 error, a separate handler for\nthe 42S01 SQLSTATE, and another separate handler for the SQLEXCEPTION class:\nin theory all occurrences of HANDLER may catch the 1050 error, but MariaDB\nchooses the HANDLER with the highest precedence. Here are the precedence rules:\n\n* Handlers which refer to an error code have the highest precedence.\n* Handlers which refer to a SQLSTATE come next.\n* Handlers which refer to an error class have the lowest precedence.\n\nIn some cases, a statement could produce multiple errors. If this happens, in\nsome cases multiple handlers could have the highest precedence. In such cases,\nthe choice of the handler is indeterminate.\n\nNote that if an error occurs within a CONTINUE HANDLER block, it can be\nhandled by another HANDLER. However, a HANDLER which is already in the stack\n(that is, it has been called to handle an error and its execution didn\'t\nfinish yet) cannot handle new errors—this prevents endless loops. For example,\nsuppose that a stored procedure contains a CONTINUE HANDLER for SQLWARNING and\nanother CONTINUE HANDLER for NOT FOUND. At some point, a NOT FOUND error\noccurs, and the execution enters the NOT FOUND HANDLER. But within that\nhandler, a warning occurs, and the execution enters the SQLWARNING HANDLER. If\nanother NOT FOUND error occurs, it cannot be handled again by the NOT FOUND\nHANDLER, because its execution is not finished.\n\nWhen a DECLARE HANDLER block can handle more than one error condition, it may\nbe useful to know which errors occurred. To do so, you can use the GET\nDIAGNOSTICS statement.\n\nAn error that is handled by a DECLARE HANDLER construct can be issued again\nusing the RESIGNAL statement.\n\nBelow is an example using DECLARE HANDLER:\n\nCREATE TABLE test.t (s1 INT, PRIMARY KEY (s1));\n\nDELIMITER //\n\nCREATE PROCEDURE handlerdemo ( )\n  BEGIN\n   DECLARE CONTINUE HANDLER FOR SQLSTATE \'23000\' SET @x2 = 1;\n   SET @x = 1;\n   INSERT INTO test.t VALUES (1);\n   SET @x = 2;\n   INSERT INTO test.t VALUES (1);\n   SET @x = 3;\n  END;\n  //\n\nDELIMITER ;\n\nCALL handlerdemo( );\n\nSELECT @x;\n+------+\n| @x   |\n+------+\n|    3 |\n+------+\n\nURL: https://mariadb.com/kb/en/declare-handler/','','https://mariadb.com/kb/en/declare-handler/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (302,24,'DECLARE Variable','Syntax\n------\n\nDECLARE var_name [, var_name] ... [[ROW] TYPE OF]] type [DEFAULT value]\n\nDescription\n-----------\n\nThis statement is used to declare local variables within stored programs. To\nprovide a default value for the variable, include a DEFAULT clause. The value\ncan be specified as an expression (even subqueries are permitted); it need not\nbe a constant. If the DEFAULT clause is missing, the initial value is NULL.\n\nLocal variables are treated like stored routine parameters with respect to\ndata type and overflow checking. See CREATE PROCEDURE.\n\nLocal variables must be declared before CONDITIONs, CURSORs and HANDLERs.\n\nLocal variable names are not case sensitive.\n\nThe scope of a local variable is within the BEGIN ... END block where it is\ndeclared. The variable can be referred to in blocks nested within the\ndeclaring block, except those blocks that declare a variable with the same\nname.\n\nTYPE OF / ROW TYPE OF\n---------------------\n\nMariaDB starting with 10.3\n--------------------------\nTYPE OF and ROW TYPE OF anchored data types for stored routines were\nintroduced in MariaDB 10.3.\n\nAnchored data types allow a data type to be defined based on another object,\nsuch as a table row, rather than specifically set in the declaration. If the\nanchor object changes, so will the anchored data type. This can lead to\nroutines being easier to maintain, so that if the data type in the table is\nchanged, it will automatically be changed in the routine as well.\n\nVariables declared with ROW TYPE OF will have the same features as implicit\nROW variables. It is not possible to use ROW TYPE OF variables in a LIMIT\nclause.\n\nThe real data type of TYPE OF and ROW TYPE OF table_name will become known at\nthe very beginning of the stored routine call. ALTER TABLE or DROP TABLE\nstatements performed inside the current routine on the tables that appear in\nanchors won\'t affect the data type of the anchored variables, even if the\nvariable is declared after an ALTER TABLE or DROP TABLE statement.\n\nThe real data type of a ROW TYPE OF cursor_name variable will become known\nwhen execution enters into the block where the variable is declared. Data type\ninstantiation will happen only once. In a cursor ROW TYPE OF variable that is\ndeclared inside a loop, its data type will become known on the very first\niteration and won\'t change on further loop iterations.\n\nThe tables referenced in TYPE OF and ROW TYPE OF declarations will be checked\nfor existence at the beginning of the stored routine call. CREATE PROCEDURE or\nCREATE FUNCTION will not check the referenced tables for existence.\n\nExamples\n--------\n\nTYPE OF and ROW TYPE OF from MariaDB 10.3:\n\nDECLARE tmp TYPE OF t1.a; -- Get the data type from the column {{a}} in the\ntable {{t1}}\n\nDECLARE rec1 ROW TYPE OF t1; -- Get the row data type from the table {{t1}}\n\nDECLARE rec2 ROW TYPE OF cur1; -- Get the row data type from the cursor\n{{cur1}}\n\nURL: https://mariadb.com/kb/en/declare-variable/','','https://mariadb.com/kb/en/declare-variable/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (303,24,'FOR','MariaDB starting with 10.3\n--------------------------\nFOR loops were introduced in MariaDB 10.3.\n\nSyntax\n------\n\nInteger range FOR loop:\n\n[begin_label:]\nFOR var_name IN [ REVERSE ] lower_bound .. upper_bound\nDO statement_list\nEND FOR [ end_label ]\n\nExplicit cursor FOR loop\n\n[begin_label:]\nFOR record_name IN cursor_name [ ( cursor_actual_parameter_list)]\nDO statement_list\nEND FOR [ end_label ]\n\nExplicit cursor FOR loop (Oracle mode)\n\n[begin_label:]\nFOR record_name IN cursor_name [ ( cursor_actual_parameter_list)]\nLOOP\n statement_list\nEND LOOP [ end_label ]\n\nImplicit cursor FOR loop\n\n[begin_label:]\nFOR record_name IN ( select_statement )\nDO statement_list\nEND FOR [ end_label ]\n\nDescription\n-----------\n\nFOR loops allow code to be executed a fixed number of times.\n\nIn an integer range FOR loop, MariaDB will compare the lower bound and upper\nbound values, and assign the lower bound value to a counter. If REVERSE is not\nspecified, and the upper bound value is greater than or equal to the counter,\nthe counter will be incremented and the statement will continue, after which\nthe loop is entered again. If the upper bound value is greater than the\ncounter, the loop will be exited.\n\nIf REVERSE is specified, the counter is decremented, and the upper bound value\nneeds to be less than or equal for the loop to continue.\n\nExamples\n--------\n\nIntger range FOR loop:\n\nCREATE TABLE t1 (a INT);\n\nDELIMITER //\n\nFOR i IN 1..3\nDO\n INSERT INTO t1 VALUES (i);\nEND FOR;\n//\n\nDELIMITER ;\n\nSELECT * FROM t1;\n+------+\n| a    |\n+------+\n|    1 |\n|    2 |\n|    3 |\n+------+\n\nREVERSE integer range FOR loop:\n\nCREATE OR REPLACE TABLE t1 (a INT);\n\nDELIMITER //\nFOR i IN REVERSE 4..12\n  DO\n  INSERT INTO t1 VALUES (i);\nEND FOR;\n//\nQuery OK, 9 rows affected (0.422 sec)\n\nDELIMITER ;\n\nSELECT * FROM t1;\n+------+\n| a    |\n+------+\n|   12 |\n|   11 |\n|   10 |\n|    9 |\n|    8 |\n|    7 |\n|    6 |\n|    5 |\n|    4 |\n+------+\n\nExplicit cursor in Oracle mode:\n\nSET sql_mode=ORACLE;\n\nCREATE OR REPLACE TABLE t1 (a INT, b VARCHAR(32));\n\nINSERT INTO t1 VALUES (10,\'b0\');\nINSERT INTO t1 VALUES (11,\'b1\');\nINSERT INTO t1 VALUES (12,\'b2\');\n\nDELIMITER //\n\nCREATE OR REPLACE PROCEDURE p1(pa INT) AS \n CURSOR cur(va INT) IS\n  SELECT a, b FROM t1 WHERE a=va;\nBEGIN\n FOR rec IN cur(pa)\n LOOP\n  SELECT rec.a, rec.b;\n END LOOP;\nEND;\n//\n\nDELIMITER ;\n\nCALL p1(10);\n+-------+-------+\n| rec.a | rec.b |\n+-------+-------+\n|    10 | b0    |\n+-------+-------+\n\nCALL p1(11);\n+-------+-------+\n| rec.a | rec.b |\n+-------+-------+\n|    11 | b1    |\n+-------+-------+\n\nCALL p1(12);\n+-------+-------+\n| rec.a | rec.b |\n+-------+-------+\n|    12 | b2    |\n+-------+-------+\n\nCALL p1(13);\nQuery OK, 0 rows affected (0.000 sec)\n\nURL: https://mariadb.com/kb/en/for/','','https://mariadb.com/kb/en/for/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (304,24,'GOTO','MariaDB starting with 10.3\n--------------------------\nThe GOTO statement was introduced in MariaDB 10.3 for Oracle compatibility.\n\nSyntax\n------\n\nGOTO label\n\nDescription\n-----------\n\nThe GOTO statement causes the code to jump to the specified label, and\ncontinue operating from there. It is only accepted when in Oracle mode.\n\nExample\n-------\n\nSET sql_mode=ORACLE;\n\nDELIMITER //\n\nCREATE OR REPLACE PROCEDURE p1 AS\n\nBEGIN\n\nSELECT 1;\n GOTO label;\n SELECT 2;\n <<label>>\n SELECT 3;\n\nEND;\n\n//\n\nDELIMITER\n\ncall p1();\n+---+\n| 1 |\n+---+\n| 1 |\n+---+\n1 row in set (0.000 sec)\n\n+---+\n| 3 |\n+---+\n| 3 |\n+---+\n1 row in set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/goto/','','https://mariadb.com/kb/en/goto/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (305,24,'IF','Syntax\n------\n\nIF search_condition THEN statement_list\n  [ELSEIF search_condition THEN statement_list] ...\n  [ELSE statement_list]\nEND IF;\n\nDescription\n-----------\n\nIF implements a basic conditional construct. If the search_condition evaluates\nto true, the corresponding SQL statement list is executed. If no\nsearch_condition matches, the statement list in the ELSE clause is executed.\nEach statement_list consists of one or more statements.\n\nURL: https://mariadb.com/kb/en/if/','','https://mariadb.com/kb/en/if/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (306,24,'ITERATE','Syntax\n------\n\nITERATE label\n\nITERATE can appear only within LOOP, REPEAT, and WHILE statements. ITERATE\nmeans \"do the loop again\", and uses the statement\'s label to determine which\nstatements to repeat. The label must be in the same stored program, not in a\ncaller procedure.\n\nIf you try to use ITERATE with a non-existing label, or if the label is\nassociated to a construct which is not a loop, the following error will be\nproduced:\n\nERROR 1308 (42000): ITERATE with no matching label: <label_name>\n\nBelow is an example of how ITERATE might be used:\n\nCREATE PROCEDURE doiterate(p1 INT)\nBEGIN\n label1: LOOP\n  SET p1 = p1 + 1;\n  IF p1 < 10 THEN ITERATE label1; END IF;\n  LEAVE label1;\n END LOOP label1;\n SET @x = p1;\nEND\n\nURL: https://mariadb.com/kb/en/iterate/','','https://mariadb.com/kb/en/iterate/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (307,24,'Labels','Syntax\n------\n\nlabel: <construct>\n[label]\n\nLabels are MariaDB identifiers which can be used to identify a BEGIN ... END\nconstruct or a loop. They have a maximum length of 16 characters and can be\nquoted with backticks (i.e.., `).\n\nLabels have a start part and an end part. The start part must precede the\nportion of code it refers to, must be followed by a colon (:) and can be on\nthe same or different line. The end part is optional and adds nothing, but can\nmake the code more readable. If used, the end part must precede the\nconstruct\'s delimiter (;). Constructs identified by a label can be nested.\nEach construct can be identified by only one label.\n\nLabels need not be unique in the stored program they belong to. However, a\nlabel for an inner loop cannot be identical to a label for an outer loop. In\nthis case, the following error would be produced:\n\nERROR 1309 (42000): Redefining label <label_name>\n\nLEAVE and ITERATE statements can be used to exit or repeat a portion of code\nidentified by a label. They must be in the same Stored Routine, Trigger or\nEvent which contains the target label.\n\nBelow is an example using a simple label that is used to exit a LOOP:\n\nCREATE PROCEDURE `test_sp`()\nBEGIN\n `my_label`:\n LOOP\n   SELECT \'looping\';\n   LEAVE `my_label`;\n END LOOP;\n SELECT \'out of loop\';\nEND;\n\nThe following label is used to exit a procedure, and has an end part:\n\nCREATE PROCEDURE `test_sp`()\n`my_label`:\nBEGIN\n IF @var = 1 THEN\n   LEAVE `my_label`;\n END IF;\n DO something();\nEND `my_label`;\n\nURL: https://mariadb.com/kb/en/labels/','','https://mariadb.com/kb/en/labels/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (308,24,'LEAVE','Syntax\n------\n\nLEAVE label\n\nThis statement is used to exit the flow control construct that has the given\nlabel. The label must be in the same stored program, not in a caller\nprocedure. LEAVE can be used within BEGIN ... END or loop constructs (LOOP,\nREPEAT, WHILE). In Stored Procedures, Triggers and Events, LEAVE can refer to\nthe outmost BEGIN ... END construct; in that case, the program exits the\nprocedure. In Stored Functions, RETURN can be used instead.\n\nNote that LEAVE cannot be used to exit a DECLARE HANDLER block.\n\nIf you try to LEAVE a non-existing label, or if you try to LEAVE a HANDLER\nblock, the following error will be produced:\n\nERROR 1308 (42000): LEAVE with no matching label: <label_name>\n\nThe following example uses LEAVE to exit the procedure if a condition is true:\n\nCREATE PROCEDURE proc(IN p TINYINT)\nCONTAINS SQL\n`whole_proc`:\nBEGIN\n SELECT 1;\n IF p < 1 THEN\n   LEAVE `whole_proc`;\n END IF;\n SELECT 2;\nEND;\n\nCALL proc(0);\n+---+\n| 1 |\n+---+\n| 1 |\n+---+\n\nURL: https://mariadb.com/kb/en/leave/','','https://mariadb.com/kb/en/leave/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (309,24,'LOOP','Syntax\n------\n\n[begin_label:] LOOP\n  statement_list\nEND LOOP [end_label]\n\nDescription\n-----------\n\nLOOP implements a simple loop construct, enabling repeated execution of the\nstatement list, which consists of one or more statements, each terminated by a\nsemicolon (i.e., ;) statement delimiter. The statements within the loop are\nrepeated until the loop is exited; usually this is accomplished with a LEAVE\nstatement.\n\nA LOOP statement can be labeled. end_label cannot be given unless begin_label\nalso is present. If both are present, they must be the same.\n\nSee Delimiters in the mariadb client for more on delimiter usage in the client.\n\nURL: https://mariadb.com/kb/en/loop/','','https://mariadb.com/kb/en/loop/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (310,24,'REPEAT LOOP','Syntax\n------\n\n[begin_label:] REPEAT\n  statement_list\nUNTIL search_condition\nEND REPEAT [end_label]\n\nThe statement list within a REPEAT statement is repeated until the\nsearch_condition is true. Thus, a REPEAT always enters the loop at least once.\nstatement_list consists of one or more statements, each terminated by a\nsemicolon (i.e., ;) statement delimiter.\n\nA REPEAT statement can be labeled. end_label cannot be given unless\nbegin_label also is present. If both are present, they must be the same.\n\nSee Delimiters in the mariadb client for more on client delimiter usage.\n\nDELIMITER //\n\nCREATE PROCEDURE dorepeat(p1 INT)\n BEGIN\n  SET @x = 0;\n  REPEAT SET @x = @x + 1; UNTIL @x > p1 END REPEAT;\n END\n//\n\nCALL dorepeat(1000)//\n\nSELECT @x//\n+------+\n| @x   |\n+------+\n| 1001 |\n+------+\n\nURL: https://mariadb.com/kb/en/repeat-loop/','','https://mariadb.com/kb/en/repeat-loop/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (311,24,'RESIGNAL','Syntax\n------\n\nRESIGNAL [error_condition]\n  [SET error_property\n  [, error_property] ...]\n\nerror_condition:\n  SQLSTATE [VALUE] \'sqlstate_value\'\n | condition_name\n\nerror_property:\n  error_property_name = <error_property_value>\n\nerror_property_name:\n  CLASS_ORIGIN\n | SUBCLASS_ORIGIN\n | MESSAGE_TEXT\n | MYSQL_ERRNO\n | CONSTRAINT_CATALOG\n | CONSTRAINT_SCHEMA\n | CONSTRAINT_NAME\n | CATALOG_NAME\n | SCHEMA_NAME\n | TABLE_NAME\n | COLUMN_NAME\n | CURSOR_NAME\n\nDescription\n-----------\n\nThe syntax of RESIGNAL and its semantics are very similar to SIGNAL. This\nstatement can only be used within an error HANDLER. It produces an error, like\nSIGNAL. RESIGNAL clauses are the same as SIGNAL, except that they all are\noptional, even SQLSTATE. All the properties which are not specified in\nRESIGNAL, will be identical to the properties of the error that was received\nby the error HANDLER. For a description of the clauses, see diagnostics area.\n\nNote that RESIGNAL does not empty the diagnostics area: it just appends\nanother error condition.\n\nRESIGNAL, without any clauses, produces an error which is identical to the\nerror that was received by HANDLER.\n\nIf used out of a HANDLER construct, RESIGNAL produces the following error:\n\nERROR 1645 (0K000): RESIGNAL when handler not active\n\nIn MariaDB 5.5, if a HANDLER contained a CALL to another procedure, that\nprocedure could use RESIGNAL. Since MariaDB 10.0, trying to do this raises the\nabove error.\n\nFor a list of SQLSTATE values and MariaDB error codes, see MariaDB Error Codes.\n\nThe following procedure tries to query two tables which don\'t exist, producing\na 1146 error in both cases. Those errors will trigger the HANDLER. The first\ntime the error will be ignored and the client will not receive it, but the\nsecond time, the error is re-signaled, so the client will receive it.\n\nCREATE PROCEDURE test_error( )\nBEGIN\n DECLARE CONTINUE HANDLER\n   FOR 1146\n BEGIN\n IF @hide_errors IS FALSE THEN\n   RESIGNAL;\n END IF;\n END;\n SET @hide_errors = TRUE;\n SELECT \'Next error will be ignored\' AS msg;\n SELECT `c` FROM `temptab_one`;\n SELECT \'Next error won\'\'t be ignored\' AS msg;\n SET @hide_errors = FALSE;\n SELECT `c` FROM `temptab_two`;\nEND;\n\nCALL test_error( );\n\n+----------------------------+\n| msg                        |\n+----------------------------+\n| Next error will be ignored |\n+----------------------------+\n\n+-----------------------------+\n| msg                         |\n+-----------------------------+\n| Next error won\'t be ignored |\n+-----------------------------+\n\nERROR 1146 (42S02): Table \'test.temptab_two\' doesn\'t exist\n\nThe following procedure re-signals an error, modifying only the error message\nto clarify the cause of the problem.\n\nCREATE PROCEDURE test_error()\nBEGIN\n DECLARE CONTINUE HANDLER\n FOR 1146\n BEGIN\n   RESIGNAL SET\n   MESSAGE_TEXT = \'`temptab` does not exist\';\n END;\n SELECT `c` FROM `temptab`;\nEND;\n\nCALL test_error( );\nERROR 1146 (42S02): `temptab` does not exist\n\nAs explained above, this works on MariaDB 5.5, but produces a 1645 error since\n10.0.\n\nCREATE PROCEDURE handle_error()\nBEGIN\n RESIGNAL;\nEND;\nCREATE PROCEDURE p()\nBEGIN\n DECLARE EXIT HANDLER FOR SQLEXCEPTION CALL p();\n SIGNAL SQLSTATE \'45000\';\nEND;\n\nURL: https://mariadb.com/kb/en/resignal/','','https://mariadb.com/kb/en/resignal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (312,24,'RETURN','Syntax\n------\n\nRETURN expr\n\nThe RETURN statement terminates execution of a stored function and returns the\nvalue expr to the function caller. There must be at least one RETURN statement\nin a stored function. If the function has multiple exit points, all exit\npoints must have a RETURN.\n\nThis statement is not used in stored procedures, triggers, or events. LEAVE\ncan be used instead.\n\nThe following example shows that RETURN can return the result of a scalar\nsubquery:\n\nCREATE FUNCTION users_count() RETURNS BOOL\n READS SQL DATA\nBEGIN\n RETURN (SELECT COUNT(DISTINCT User) FROM mysql.user);\nEND;\n\nURL: https://mariadb.com/kb/en/return/','','https://mariadb.com/kb/en/return/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (313,24,'SELECT INTO','Syntax\n------\n\nSELECT col_name [, col_name] ...\n  INTO var_name [, var_name] ...\n  table_expr\n\nDescription\n-----------\n\nSELECT ... INTO enables selected columns to be stored directly into variables.\nNo resultset is produced. The query should return a single row. If the query\nreturns no rows, a warning with error code 1329 occurs (No data), and the\nvariable values remain unchanged. If the query returns multiple rows, error\n1172 occurs (Result consisted of more than one row). If it is possible that\nthe statement may retrieve multiple rows, you can use LIMIT 1 to limit the\nresult set to a single row.\n\nThe INTO clause can also be specified at the end of the statement.\n\nIn the context of such statements that occur as part of events executed by the\nEvent Scheduler, diagnostics messages (not only errors, but also warnings) are\nwritten to the error log, and, on Windows, to the application event log.\n\nThis statement can be used with both local variables and user-defined\nvariables.\n\nFor the complete syntax, see SELECT.\n\nAnother way to set a variable\'s value is the SET statement.\n\nSELECT ... INTO results are not stored in the query cache even if SQL_CACHE is\nspecified.\n\nExamples\n--------\n\nSELECT id, data INTO @x,@y \nFROM test.t1 LIMIT 1;\nSELECT * from t1 where t1.a=@x and t1.b=@y\n\nIf you want to use this construct with UNION you have to use the syntax:\n\nSELECT  * INTO @x FROM (SELECT t1.a FROM t1 UNION SELECT t2.a FROM t2);\n\nURL: https://mariadb.com/kb/en/selectinto/','','https://mariadb.com/kb/en/selectinto/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (314,24,'SIGNAL','Syntax\n------\n\nSIGNAL error_condition\n  [SET error_property\n  [, error_property] ...]\n\nerror_condition:\n  SQLSTATE [VALUE] \'sqlstate_value\'\n | condition_name\n\nerror_property:\n  error_property_name = <error_property_value>\n\nerror_property_name:\n  CLASS_ORIGIN\n | SUBCLASS_ORIGIN\n | MESSAGE_TEXT\n | MYSQL_ERRNO\n | CONSTRAINT_CATALOG\n | CONSTRAINT_SCHEMA\n | CONSTRAINT_NAME\n | CATALOG_NAME\n | SCHEMA_NAME\n | TABLE_NAME\n | COLUMN_NAME\n | CURSOR_NAME\n\nSIGNAL empties the diagnostics area and produces a custom error. This\nstatement can be used anywhere, but is generally useful when used inside a\nstored program. When the error is produced, it can be caught by a HANDLER. If\nnot, the current stored program, or the current statement, will terminate with\nthe specified error.\n\nSometimes an error HANDLER just needs to SIGNAL the same error it received,\noptionally with some changes. Usually the RESIGNAL statement is the most\nconvenient way to do this.\n\nerror_condition can be an SQLSTATE value or a named error condition defined\nvia DECLARE CONDITION. SQLSTATE must be a constant string consisting of five\ncharacters. These codes are standard to ODBC and ANSI SQL. For customized\nerrors, the recommended SQLSTATE is \'45000\'. For a list of SQLSTATE values\nused by MariaDB, see the MariaDB Error Codes page. The SQLSTATE can be read\nvia the API method mysql_sqlstate( ).\n\nTo specify error properties user-defined variables and local variables can be\nused, as well as character set conversions (but you can\'t set a collation).\n\nThe error properties, their type and their default values are explained in the\ndiagnostics area page.\n\nErrors\n------\n\nIf the SQLSTATE is not valid, the following error like this will be produced:\n\nERROR 1407 (42000): Bad SQLSTATE: \'123456\'\n\nIf a property is specified more than once, an error like this will be produced:\n\nERROR 1641 (42000): Duplicate condition information item \'MESSAGE_TEXT\'\n\nIf you specify a condition name which is not declared, an error like this will\nbe produced:\n\nERROR 1319 (42000): Undefined CONDITION: cond_name\n\nIf MYSQL_ERRNO is out of range, you will get an error like this:\n\nERROR 1231 (42000): Variable \'MYSQL_ERRNO\' can\'t be set to the value of \'0\'\n\nExamples\n--------\n\nHere\'s what happens if SIGNAL is used in the client to generate errors:\n\nSIGNAL SQLSTATE \'01000\';\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nSHOW WARNINGS;\n\n+---------+------+------------------------------------------+\n| Level   | Code | Message                                  |\n+---------+------+------------------------------------------+\n| Warning | 1642 | Unhandled user-defined warning condition |\n+---------+------+------------------------------------------+\n1 row in set (0.06 sec)\n\nSIGNAL SQLSTATE \'02000\';\nERROR 1643 (02000): Unhandled user-defined not found condition\n\nHow to specify MYSQL_ERRNO and MESSAGE_TEXT properties:\n\nSIGNAL SQLSTATE \'45000\' SET MYSQL_ERRNO=30001, MESSAGE_TEXT=\'H\nello, world!\';\n\nERROR 30001 (45000): Hello, world!\n\nThe following code shows how to use user variables, local variables and\ncharacter set conversion with SIGNAL:\n\nCREATE PROCEDURE test_error(x INT)\nBEGIN\n DECLARE errno SMALLINT UNSIGNED DEFAULT 31001;\n SET @errmsg = \'Hello, world!\';\n IF x = 1 THEN\n   SIGNAL SQLSTATE \'45000\' SET\n   MYSQL_ERRNO = errno,\n   MESSAGE_TEXT = @errmsg;\n ELSE\n   SIGNAL SQLSTATE \'45000\' SET\n   MYSQL_ERRNO = errno,\n   MESSAGE_TEXT = _utf8\'Hello, world!\';\n END IF;\nEND;\n\nHow to use named error conditions:\n\nCREATE PROCEDURE test_error(n INT)\nBEGIN\n DECLARE `too_big` CONDITION FOR SQLSTATE \'45000\';\n IF n > 10 THEN\n   SIGNAL `too_big`;\n END IF;\nEND;\n\nIn this example, we\'ll define a HANDLER for an error code. When the error\noccurs, we SIGNAL a more informative error which makes sense for our procedure:\n\nCREATE PROCEDURE test_error()\nBEGIN\n DECLARE EXIT HANDLER\n FOR 1146\n BEGIN\n   SIGNAL SQLSTATE \'45000\' SET\n   MESSAGE_TEXT = \'Temporary tables not found; did you call init()\nprocedure?\';\n END;\n -- this will produce a 1146 error\n SELECT `c` FROM `temptab`;\nEND;\n\nURL: https://mariadb.com/kb/en/signal/','','https://mariadb.com/kb/en/signal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (315,24,'WHILE','Syntax\n------\n\n[begin_label:] WHILE search_condition DO\n  statement_list\nEND WHILE [end_label]\n\nDescription\n-----------\n\nThe statement list within a WHILE statement is repeated as long as the\nsearch_condition is true. statement_list consists of one or more statements.\nIf the loop must be executed at least once, REPEAT ... LOOP can be used\ninstead.\n\nA WHILE statement can be labeled. end_label cannot be given unless begin_label\nalso is present. If both are present, they must be the same.\n\nExamples\n--------\n\nCREATE PROCEDURE dowhile()\nBEGIN\n DECLARE v1 INT DEFAULT 5;\n\nWHILE v1 > 0 DO\n  ...\n  SET v1 = v1 - 1;\n END WHILE;\nEND\n\nURL: https://mariadb.com/kb/en/while/','','https://mariadb.com/kb/en/while/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (316,24,'Cursor Overview','Description\n-----------\n\nA cursor is a structure that allows you to go over records sequentially, and\nperform processing based on the result.\n\nMariaDB permits cursors inside stored programs, and MariaDB cursors are\nnon-scrollable, read-only and asensitive.\n\n* Non-scrollable means that the rows can only be fetched in the order\nspecified by the SELECT statement. Rows cannot be skipped, you cannot jump to\na specific row, and you cannot fetch rows in reverse order.\n* Read-only means that data cannot be updated through the cursor.\n* Asensitive means that the cursor points to the actual underlying data. This\nkind of cursor is quicker than the alternative, an insensitive cursor, as no\ndata is copied to a temporary table. However, changes to the data being used\nby the cursor will affect the cursor data.\n\nCursors are created with a DECLARE CURSOR statement and opened with an OPEN\nstatement. Rows are read with a FETCH statement before the cursor is finally\nclosed with a CLOSE statement.\n\nWhen FETCH is issued and there are no more rows to extract, the following\nerror is produced:\n\nERROR 1329 (02000): No data - zero rows fetched, selected, or processed\n\nTo avoid problems, a DECLARE HANDLER statement is generally used. The HANDLER\nshould handler the 1329 error, or the \'02000\' SQLSTATE, or the NOT FOUND error\nclass.\n\nOnly SELECT statements are allowed for cursors, and they cannot be contained\nin a variable - so, they cannot be composed dynamically. However, it is\npossible to SELECT from a view. Since the CREATE VIEW statement can be\nexecuted as a prepared statement, it is possible to dynamically create the\nview that is queried by the cursor.\n\nFrom MariaDB 10.3.0, cursors can have parameters. Cursor parameters can appear\nin any part of the DECLARE CURSOR select_statement where a stored procedure\nvariable is allowed (select list, WHERE, HAVING, LIMIT etc). See DECLARE\nCURSOR and OPEN for syntax, and below for an example:\n\nExamples\n--------\n\nCREATE TABLE c1(i INT);\n\nCREATE TABLE c2(i INT);\n\nCREATE TABLE c3(i INT);\n\nDELIMITER //\n\nCREATE PROCEDURE p1()\nBEGIN\n DECLARE done INT DEFAULT FALSE;\n DECLARE x, y INT;\n DECLARE cur1 CURSOR FOR SELECT i FROM test.c1;\n DECLARE cur2 CURSOR FOR SELECT i FROM test.c2;\n DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;\n\nOPEN cur1;\n OPEN cur2;\n\nread_loop: LOOP\n  FETCH cur1 INTO x;\n  FETCH cur2 INTO y;\n  IF done THEN\n   LEAVE read_loop;\n  END IF;\n  IF x < y THEN\n   INSERT INTO test.c3 VALUES (x);\n  ELSE\n   INSERT INTO test.c3 VALUES (y);\n  END IF;\n END LOOP;\n\nCLOSE cur1;\n CLOSE cur2;\nEND; //\n\nDELIMITER ;\n\nINSERT INTO c1 VALUES(5),(50),(500);\n\nINSERT INTO c2 VALUES(10),(20),(30);\n\nCALL p1;\n\nSELECT * FROM c3;\n+------+\n| i    |\n+------+\n|    5 |\n|   20 |\n|   30 |\n+------+\n\nFrom MariaDB 10.3.0\n\nDROP PROCEDURE IF EXISTS p1;\nDROP TABLE IF EXISTS t1;\nCREATE TABLE t1 (a INT, b VARCHAR(10));\n\nINSERT INTO t1 VALUES (1,\'old\'),(2,\'old\'),(3,\'old\'),(4,\'old\'),(5,\'old\');\n\nDELIMITER //\n\nCREATE PROCEDURE p1(min INT,max INT)\nBEGIN\n DECLARE done INT DEFAULT FALSE;\n DECLARE va INT;\n DECLARE cur CURSOR(pmin INT, pmax INT) FOR SELECT a FROM t1 WHERE a BETWEEN\npmin AND pmax;\n DECLARE CONTINUE HANDLER FOR NOT FOUND SET done=TRUE;\n OPEN cur(min,max);\n read_loop: LOOP\n  FETCH cur INTO va;\n  IF done THEN\n   LEAVE read_loop;\n  END IF;\n  INSERT INTO t1 VALUES (va,\'new\');\n END LOOP;\n CLOSE cur;\nEND;\n//\n\nDELIMITER ;\n\nCALL p1(2,4);\n\nSELECT * FROM t1;\n+------+------+\n| a    | b    |\n+------+------+\n|    1 | old  |\n|    2 | old  |\n|    3 | old  |\n|    4 | old  |\n|    5 | old  |\n|    2 | new  |\n|    3 | new  |\n|    4 | new  |\n+------+------+\n\nURL: https://mariadb.com/kb/en/cursor-overview/','','https://mariadb.com/kb/en/cursor-overview/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (317,24,'DECLARE CURSOR','Syntax\n------\n\n<= MariaDB 10.2\n\nDECLARE cursor_name CURSOR FOR select_statement\n\nFrom MariaDB 10.3\n\nDECLARE cursor_name CURSOR [(cursor_formal_parameter[,...])] FOR\nselect_statement\n\ncursor_formal_parameter:\n  name type [collate clause]\n\nFrom MariaDB 10.8\n\nDECLARE cursor_name CURSOR [(cursor_formal_parameter[,...])] FOR\nselect_statement\n\ncursor_formal_parameter:\n  [IN] name type [collate clause]\n\nDescription\n-----------\n\nThis statement declares a cursor. Multiple cursors may be declared in a stored\nprogram, but each cursor in a given block must have a unique name.\n\nselect_statement is not executed until the OPEN statement is executed. It is\nimportant to remember this if the query produces an error, or calls functions\nwhich have side effects.\n\nA SELECT associated to a cursor can use variables, but the query itself cannot\nbe a variable, and cannot be dynamically composed. The SELECT statement cannot\nhave an INTO clause.\n\nCursors must be declared before HANDLERs, but after local variables and\nCONDITIONs.\n\nParameters\n----------\n\nMariaDB starting with 10.3.0\n----------------------------\nFrom MariaDB 10.3.0, cursors can have parameters. This is a non-standard SQL\nextension. Cursor parameters can appear in any part of the DECLARE CURSOR\nselect_statement where a stored procedure variable is allowed (select list,\nWHERE, HAVING, LIMIT etc).\n\nIN\n--\n\nMariaDB starting with 10.8.0\n----------------------------\nFrom MariaDB 10.8.0 preview release, the IN qualifier is supported in the\ncursor_format_parameter part of the syntax.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/declare-cursor/','','https://mariadb.com/kb/en/declare-cursor/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (318,24,'OPEN','Syntax\n------\n\n<= MariaDB 10.2\n\nOPEN cursor_name\n\nFrom MariaDB 10.3\n\nOPEN cursor_name [expression[,...]];\n\nDescription\n-----------\n\nThis statement opens a cursor which was previously declared with DECLARE\nCURSOR.\n\nThe query associated to the DECLARE CURSOR is executed when OPEN is executed.\nIt is important to remember this if the query produces an error, or calls\nfunctions which have side effects.\n\nThis is necessary in order to FETCH rows from a cursor.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/open/','','https://mariadb.com/kb/en/open/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (319,24,'FETCH','Syntax\n------\n\nFETCH cursor_name INTO var_name [, var_name] ...\n\nDescription\n-----------\n\nThis statement fetches the next row (if a row exists) using the specified open\ncursor, and advances the cursor pointer.\n\nvar_name can be a local variable, but not a user-defined variable.\n\nIf no more rows are available, a No Data condition occurs with SQLSTATE value\n02000. To detect this condition, you can set up a handler for it (or for a NOT\nFOUND condition).\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/fetch/','','https://mariadb.com/kb/en/fetch/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (320,24,'CLOSE','Syntax\n------\n\nCLOSE cursor_name\n\nDescription\n-----------\n\nThis statement closes a previously opened cursor. The cursor must have been\npreviously opened or else an error occurs.\n\nIf not closed explicitly, a cursor is closed at the end of the compound\nstatement in which it was declared.\n\nSee Cursor Overview for an example.\n\nURL: https://mariadb.com/kb/en/close/','','https://mariadb.com/kb/en/close/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (321,25,'BUFFER','A synonym for ST_BUFFER.\n\nURL: https://mariadb.com/kb/en/buffer/','','https://mariadb.com/kb/en/buffer/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (322,25,'CONVEXHULL','A synonym for ST_CONVEXHULL.\n\nURL: https://mariadb.com/kb/en/convexhull/','','https://mariadb.com/kb/en/convexhull/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (323,25,'GEOMETRYCOLLECTION','Syntax\n------\n\nGeometryCollection(g1,g2,...)\n\nDescription\n-----------\n\nConstructs a WKB GeometryCollection. If any argument is not a well-formed WKB\nrepresentation of a geometry, the return value is NULL.\n\nExamples\n--------\n\nCREATE TABLE gis_geometrycollection  (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\nINSERT INTO gis_geometrycollection VALUES\n  (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0,10\n10))\')),\n  (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n  (GeomFromText(\'GeometryCollection()\')),\n  (GeomFromText(\'GeometryCollection EMPTY\'));\n\nURL: https://mariadb.com/kb/en/geometrycollection/','','https://mariadb.com/kb/en/geometrycollection/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (324,25,'LINESTRING','Syntax\n------\n\nLineString(pt1,pt2,...)\n\nDescription\n-----------\n\nConstructs a WKB LineString value from a number of WKB Point arguments. If any\nargument is not a WKB Point, the return value is NULL. If the number of Point\narguments is less than two, the return value is NULL.\n\nExamples\n--------\n\nSET @ls = \'LineString(1 1,2 2,3 3)\';\n\nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n\nCREATE TABLE gis_line  (g LINESTRING);\nINSERT INTO gis_line VALUES\n  (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n  (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10 10)\')),\n  (LineStringFromWKB(AsWKB(LineString(Point(10, 10), Point(40, 10)))));\n\nURL: https://mariadb.com/kb/en/linestring/','','https://mariadb.com/kb/en/linestring/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (325,25,'MULTILINESTRING','Syntax\n------\n\nMultiLineString(ls1,ls2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiLineString value using WKB LineString arguments. If any\nargument is not a WKB LineString, the return value is NULL.\n\nExample\n-------\n\nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nINSERT INTO gis_multi_line VALUES\n (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10 0),(16 0,16 23,16\n48))\')),\n (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n (MLineFromWKB(AsWKB(MultiLineString(LineString(Point(1, 2), \n  Point(3, 5)), LineString(Point(2, 5),Point(5, 8),Point(21, 7))))));\n\nURL: https://mariadb.com/kb/en/multilinestring/','','https://mariadb.com/kb/en/multilinestring/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (326,25,'MULTIPOINT','Syntax\n------\n\nMultiPoint(pt1,pt2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiPoint value using WKB Point arguments. If any argument\nis not a WKB Point, the return value is NULL.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'MultiPoint( 1 1, 2 2, 5 3, 7 2, 9 3, 8 4, 6 6, 6 9,\n4 9, 1 5 )\');\n\nCREATE TABLE gis_multi_point (g MULTIPOINT);\nINSERT INTO gis_multi_point VALUES\n  (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20 20)\')),\n  (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n  (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4, 10)))));\n\nURL: https://mariadb.com/kb/en/multipoint/','','https://mariadb.com/kb/en/multipoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (327,25,'MULTIPOLYGON','Syntax\n------\n\nMultiPolygon(poly1,poly2,...)\n\nDescription\n-----------\n\nConstructs a WKB MultiPolygon value from a set of WKB Polygon arguments. If\nany argument is not a WKB Polygon, the return value is NULL.\n\nExample\n-------\n\nCREATE TABLE gis_multi_polygon  (g MULTIPOLYGON);\nINSERT INTO gis_multi_polygon VALUES\n  (MultiPolygonFromText(\'MULTIPOLYGON(((28 26,28 0,84 0,84 42,28 26),(52\n18,66 23,73 9,48 6,52 18)),\n  ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromText(\'MULTIPOLYGON(((28 26,28 0,84 0,84 42,28 26),(52 18,66\n23,73 9,48 6,52 18)),\n    ((59 18,67 18,67 13,59 13,59 18)))\')),\n  (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(LineString(\n   Point(0, 3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n\nURL: https://mariadb.com/kb/en/multipolygon/','','https://mariadb.com/kb/en/multipolygon/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (328,25,'POINT','Syntax\n------\n\nPoint(x,y)\n\nDescription\n-----------\n\nConstructs a WKB Point using the given coordinates.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'Point(1 1)\');\n\nCREATE TABLE gis_point  (g POINT);\nINSERT INTO gis_point VALUES\n  (PointFromText(\'POINT(10 10)\')),\n  (PointFromText(\'POINT(20 10)\')),\n  (PointFromText(\'POINT(20 20)\')),\n  (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n\nURL: https://mariadb.com/kb/en/point/','','https://mariadb.com/kb/en/point/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (329,25,'PointOnSurface','A synonym for ST_PointOnSurface.\n\nURL: https://mariadb.com/kb/en/pointonsurface/','','https://mariadb.com/kb/en/pointonsurface/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (330,25,'POLYGON','Syntax\n------\n\nPolygon(ls1,ls2,...)\n\nDescription\n-----------\n\nConstructs a WKB Polygon value from a number of WKB LineString arguments. If\nany argument does not represent the WKB of a LinearRing (that is, not a closed\nand simple LineString) the return value is NULL.\n\nNote that according to the OpenGIS standard, a POLYGON should have exactly one\nExteriorRing and all other rings should lie within that ExteriorRing and thus\nbe the InteriorRings. Practically, however, some systems, including MariaDB\'s,\npermit polygons to have several \'ExteriorRings\'. In the case of there being\nmultiple, non-overlapping exterior rings ST_NUMINTERIORRINGS() will return 1.\n\nExamples\n--------\n\nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1))\');\n\nCREATE TABLE gis_polygon   (g POLYGON);\nINSERT INTO gis_polygon VALUES\n  (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10 10))\')),\n  (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10 10,20 10,20 20,10\n20,10 10))\')),\n  (PolyFromWKB(AsWKB(Polygon(LineString(Point(0, 0), Point(30, 0), Point(30,\n30), Point(0, 0))))));\n\nNon-overlapping \'polygon\':\n\nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10 0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n+------------------+\n| NumInteriorRings |\n+------------------+\n|                1 |\n+------------------+\n\nURL: https://mariadb.com/kb/en/polygon/','','https://mariadb.com/kb/en/polygon/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (331,25,'ST_BUFFER','Syntax\n------\n\nST_BUFFER(g1,r)\nBUFFER(g1,r)\n\nDescription\n-----------\n\nReturns a geometry that represents all points whose distance from geometry g1\nis less than or equal to distance, or radius, r.\n\nUses for this function could include creating for example a new geometry\nrepresenting a buffer zone around an island.\n\nBUFFER() is a synonym.\n\nExamples\n--------\n\nDetermining whether a point is within a buffer zone:\n\nSET @g1 = ST_GEOMFROMTEXT(\'POLYGON((10 10, 10 20, 20 20, 20 10, 10 10))\');\n\nSET @g2 = ST_GEOMFROMTEXT(\'POINT(8 8)\');\n\nSELECT ST_WITHIN(@g2,ST_BUFFER(@g1,5));\n+---------------------------------+\n| ST_WITHIN(@g2,ST_BUFFER(@g1,5)) |\n+---------------------------------+\n|                               1 |\n+---------------------------------+\n\nSELECT ST_WITHIN(@g2,ST_BUFFER(@g1,1));\n+---------------------------------+\n| ST_WITHIN(@g2,ST_BUFFER(@g1,1)) |\n+---------------------------------+\n|                               0 |\n+---------------------------------+\n\nURL: https://mariadb.com/kb/en/st_buffer/','','https://mariadb.com/kb/en/st_buffer/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (332,25,'ST_CONVEXHULL','MariaDB starting with 10.1.2\n----------------------------\nST_ConvexHull() was introduced in MariaDB 10.1.2\n\nSyntax\n------\n\nST_ConvexHull(g)\nConvexHull(g)\n\nDescription\n-----------\n\nGiven a geometry, returns a geometry that is the minimum convex geometry\nenclosing all geometries within the set. Returns NULL if the geometry value is\nNULL or an empty value.\n\nST_ConvexHull() and ConvexHull() are synonyms.\n\nExamples\n--------\n\nThe ConvexHull of a single point is simply the single point:\n\nSET @g = ST_GEOMFROMTEXT(\'Point(0 0)\');\n\nSELECT ST_ASTEXT(ST_CONVEXHULL(@g));\n+------------------------------+\n| ST_ASTEXT(ST_CONVEXHULL(@g)) |\n+------------------------------+\n| POINT(0 0)                   |\n+------------------------------+\n\nSET @g = ST_GEOMFROMTEXT(\'MultiPoint(0 0, 1 2, 2 3)\');\n\nSELECT ST_ASTEXT(ST_CONVEXHULL(@g));\n+------------------------------+\n| ST_ASTEXT(ST_CONVEXHULL(@g)) |\n+------------------------------+\n| POLYGON((0 0,1 2,2 3,0 0))   |\n+------------------------------+\n\nSET @g = ST_GEOMFROMTEXT(\'MultiPoint( 1 1, 2 2, 5 3, 7 2, 9 3, 8 4, 6 6, 6 9,\n4 9, 1 5 )\');\n\nSELECT ST_ASTEXT(ST_CONVEXHULL(@g));\n+----------------------------------------+\n| ST_ASTEXT(ST_CONVEXHULL(@g))           |\n+----------------------------------------+\n| POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1)) |\n+----------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_convexhull/','','https://mariadb.com/kb/en/st_convexhull/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (333,25,'ST_INTERSECTION','Syntax\n------\n\nST_INTERSECTION(g1,g2)\n\nDescription\n-----------\n\nReturns a geometry that is the intersection, or shared portion, of geometry g1\nand geometry g2.\n\nExamples\n--------\n\nSET @g1 = ST_GEOMFROMTEXT(\'POINT(2 1)\');\n\nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(2 1, 0 2)\');\n\nSELECT ASTEXT(ST_INTERSECTION(@g1,@g2));\n+----------------------------------+\n| ASTEXT(ST_INTERSECTION(@g1,@g2)) |\n+----------------------------------+\n| POINT(2 1)                       |\n+----------------------------------+\n\nURL: https://mariadb.com/kb/en/st_intersection/','','https://mariadb.com/kb/en/st_intersection/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (334,25,'ST_POINTONSURFACE','MariaDB starting with 10.1.2\n----------------------------\nST_POINTONSURFACE() was introduced in MariaDB 10.1.2\n\nSyntax\n------\n\nST_PointOnSurface(g)\nPointOnSurface(g)\n\nDescription\n-----------\n\nGiven a geometry, returns a POINT guaranteed to intersect a surface. However,\nsee MDEV-7514.\n\nST_PointOnSurface() and PointOnSurface() are synonyms.\n\nURL: https://mariadb.com/kb/en/st_pointonsurface/','','https://mariadb.com/kb/en/st_pointonsurface/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (335,25,'ST_SYMDIFFERENCE','Syntax\n------\n\nST_SYMDIFFERENCE(g1,g2)\n\nDescription\n-----------\n\nReturns a geometry that represents the portions of geometry g1 and geometry g2\nthat don\'t intersect.\n\nExamples\n--------\n\nSET @g1 = ST_GEOMFROMTEXT(\'LINESTRING(10 20, 10 40)\');\n\nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(10 15, 10 25)\');\n\nSELECT ASTEXT(ST_SYMDIFFERENCE(@g1,@g2));\n+----------------------------------------------+\n| ASTEXT(ST_SYMDIFFERENCE(@g1,@g2))            |\n+----------------------------------------------+\n| MULTILINESTRING((10 15,10 20),(10 25,10 40)) |\n+----------------------------------------------+\n\nSET @g2 = ST_GeomFromText(\'LINESTRING(10 20, 10 41)\');\n\nSELECT ASTEXT(ST_SYMDIFFERENCE(@g1,@g2));\n+-----------------------------------+\n| ASTEXT(ST_SYMDIFFERENCE(@g1,@g2)) |\n+-----------------------------------+\n| LINESTRING(10 40,10 41)           |\n+-----------------------------------+\n\nURL: https://mariadb.com/kb/en/st_symdifference/','','https://mariadb.com/kb/en/st_symdifference/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (336,25,'ST_UNION','Syntax\n------\n\nST_UNION(g1,g2)\n\nDescription\n-----------\n\nReturns a geometry that is the union of the geometry g1 and geometry g2.\n\nExamples\n--------\n\nSET @g1 = GEOMFROMTEXT(\'POINT (0 2)\');\n\nSET @g2 = GEOMFROMTEXT(\'POINT (2 0)\');\n\nSELECT ASTEXT(ST_UNION(@g1,@g2));\n+---------------------------+\n| ASTEXT(ST_UNION(@g1,@g2)) |\n+---------------------------+\n| MULTIPOINT(2 0,0 2)       |\n+---------------------------+\n\nSET @g1 = GEOMFROMTEXT(\'POLYGON((0 0,0 3,3 3,3 0,0 0))\');\n\nSET @g2 = GEOMFROMTEXT(\'POLYGON((2 2,4 2,4 4,2 4,2 2))\');\n\nSELECT ASTEXT(ST_UNION(@g1,@g2));\n+------------------------------------------------+\n| ASTEXT(ST_UNION(@g1,@g2))                      |\n+------------------------------------------------+\n| POLYGON((0 0,0 3,2 3,2 4,4 4,4 2,3 2,3 0,0 0)) |\n+------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/st_union/','','https://mariadb.com/kb/en/st_union/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (337,26,'SHOW GRANTS','Syntax\n------\n\nSHOW GRANTS [FOR user|role]\n\nDescription\n-----------\n\nThe SHOW GRANTS statement lists privileges granted to a particular user or\nrole.\n\nUsers\n-----\n\nThe statement lists the GRANT statement or statements that must be issued to\nduplicate the privileges that are granted to a MariaDB user account. The\naccount is named using the same format as for the GRANT statement; for\nexample, \'jeffrey\'@\'localhost\'. If you specify only the user name part of the\naccount name, a host name part of \'%\' is used. For additional information\nabout specifying account names, see GRANT.\n\nSHOW GRANTS FOR \'root\'@\'localhost\';\n+---------------------------------------------------------------------+\n| Grants for root@localhost                                           |\n+---------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION |\n+---------------------------------------------------------------------+\n\nTo list the privileges granted to the account that you are using to connect to\nthe server, you can use any of the following statements:\n\nSHOW GRANTS;\nSHOW GRANTS FOR CURRENT_USER;\nSHOW GRANTS FOR CURRENT_USER();\n\nIf SHOW GRANTS FOR CURRENT_USER (or any of the equivalent syntaxes) is used in\nDEFINER context (such as within a stored procedure that is defined with SQL\nSECURITY DEFINER), the grants displayed are those of the definer and not the\ninvoker.\n\nNote that the DELETE HISTORY privilege, introduced in MariaDB 10.3.4, was\ndisplayed as DELETE VERSIONING ROWS when running SHOW GRANTS until MariaDB\n10.3.15 (MDEV-17655).\n\nRoles\n-----\n\nSHOW GRANTS can also be used to view the privileges granted to a role.\n\nExample\n-------\n\nSHOW GRANTS FOR journalist;\n+------------------------------------------+\n| Grants for journalist                    |\n+------------------------------------------+\n| GRANT USAGE ON *.* TO \'journalist\'       |\n| GRANT DELETE ON `test`.* TO \'journalist\' |\n+------------------------------------------+\n\nFOR PUBLIC\n----------\n\nMariaDB starting with 10.11\n---------------------------\nGRANT ... TO PUBLIC was introduced in MariaDB 10.11 to grant privileges to all\nusers. SHOW GRANTS FOR PUBLIC shows all these grants.\n\nSHOW GRANTS FOR public;\n+------------------------------------------------+\n| Grants for PUBLIC                              |\n+------------------------------------------------+\n| GRANT ALL PRIVILEGES ON `dev_db`.* TO `PUBLIC` |\n+------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/show-grants/','','https://mariadb.com/kb/en/show-grants/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (338,26,'SHOW CREATE USER','Syntax\n------\n\nSHOW CREATE USER user_name\n\nDescription\n-----------\n\nShows the CREATE USER statement that created the given user. The statement\nrequires the SELECT privilege for the mysql database, except for the current\nuser.\n\nExamples\n--------\n\nCREATE USER foo4@test require cipher \'text\' \n issuer \'foo_issuer\' subject \'foo_subject\';\n\nSHOW CREATE USER foo4@test\\G\n*************************** 1. row ***************************\nCREATE USER \'foo4\'@\'test\' \n REQUIRE ISSUER \'foo_issuer\'\n SUBJECT \'foo_subject\'\n CIPHER \'text\'\n\nUser Password Expiry:\n\nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY;\n\nSHOW CREATE USER \'monty\'@\'localhost\';\n+------------------------------------------------------------------+\n| CREATE USER for monty@localhost                                  |\n+------------------------------------------------------------------+\n| CREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL 120 DAY |\n+------------------------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/show-create-user/','','https://mariadb.com/kb/en/show-create-user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (339,26,'SHOW COLUMNS','Syntax\n------\n\nSHOW [FULL] {COLUMNS | FIELDS} FROM tbl_name [FROM db_name]\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nSHOW COLUMNS displays information about the columns in a given table. It also\nworks for views. The LIKE clause, if present on its own, indicates which\ncolumn names to match. The WHERE and LIKE clauses can be given to select rows\nusing more general conditions, as discussed in Extended SHOW.\n\nIf the data types differ from what you expect them to be based on a CREATE\nTABLE statement, note that MariaDB sometimes changes data types when you\ncreate or alter a table. The conditions under which this occurs are described\nin the Silent Column Changes article.\n\nThe FULL keyword causes the output to include the column collation and\ncomments, as well as the privileges you have for each column.\n\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM db_name\nsyntax. In other words, these two statements are equivalent:\n\nSHOW COLUMNS FROM mytable FROM mydb;\nSHOW COLUMNS FROM mydb.mytable;\n\nSHOW COLUMNS displays the following values for each table column:\n\nField indicates the column name.\n\nType indicates the column data type.\n\nCollation indicates the collation for non-binary string columns, or NULL for\nother columns. This value is displayed only if you use the FULL keyword.\n\nThe Null field contains YES if NULL values can be stored in the column, NO if\nnot.\n\nThe Key field indicates whether the column is indexed:\n\n* If Key is empty, the column either is not indexed or is indexed only as a\n secondary column in a multiple-column, non-unique index.\n* If Key is PRI, the column is a PRIMARY KEY or\n is one of the columns in a multiple-column PRIMARY KEY.\n* If Key is UNI, the column is the first column of a unique-valued\n index that cannot contain NULL values.\n* If Key is MUL, multiple occurrences of a given value are allowed\n within the column. The column is the first column of a non-unique index or a\n unique-valued index that can contain NULL values.\n\nIf more than one of the Key values applies to a given column of a table, Key\ndisplays the one with the highest priority, in the order PRI, UNI, MUL.\n\nA UNIQUE index may be displayed as PRI if it cannot contain NULL values and\nthere is no PRIMARY KEY in the table. A UNIQUE index may display as MUL if\nseveral columns form a composite UNIQUE index; although the combination of the\ncolumns is unique, each column can still hold multiple occurrences of a given\nvalue.\n\nThe Default field indicates the default value that is assigned to the column.\n\nThe Extra field contains any additional information that is available about a\ngiven column.\n\n+------------------------+---------------------------------------------------+\n| Value                  | Description                                       |\n+------------------------+---------------------------------------------------+\n| AUTO_INCREMENT         | The column was created with the AUTO_INCREMENT    |\n|                        | keyword.                                          |\n+------------------------+---------------------------------------------------+\n| PERSISTENT             | The column was created with the PERSISTENT        |\n|                        | keyword. (New in 5.3)                             |\n+------------------------+---------------------------------------------------+\n| VIRTUAL                | The column was created with the VIRTUAL keyword.  |\n|                        | (New in 5.3)                                      |\n+------------------------+---------------------------------------------------+\n| on update              | The column is a TIMESTAMP column that is          |\n| CURRENT_TIMESTAMP      | automatically updated on INSERT and UPDATE.       |\n+------------------------+---------------------------------------------------+\n\nPrivileges indicates the privileges you have for the column. This value is\ndisplayed only if you use the FULL keyword.\n\nComment indicates any comment the column has. This value is displayed only if\nyou use the FULL keyword.\n\nSHOW FIELDS is a synonym for SHOW COLUMNS. Also DESCRIBE and EXPLAIN can be\nused as shortcuts.\n\nYou can also list a table\'s columns with:\n\nmariadb-show db_name tbl_name\n\nSee the mariadb-show command for more details.\n\nThe DESCRIBE statement provides information similar to SHOW COLUMNS. The\ninformation_schema.COLUMNS table provides similar, but more complete,\ninformation.\n\nThe SHOW CREATE TABLE, SHOW TABLE STATUS, and SHOW INDEX statements also\nprovide information about tables.\n\nExamples\n--------\n\nSHOW COLUMNS FROM city;\n+------------+----------+------+-----+---------+----------------+\n| Field      | Type     | Null | Key | Default | Extra          |\n+------------+----------+------+-----+---------+----------------+\n| Id         | int(11)  | NO   | PRI | NULL    | auto_increment |\n| Name       | char(35) | NO   |     |         |                |\n| Country    | char(3)  | NO   | UNI |         |                |\n| District   | char(20) | YES  | MUL |         |                |\n| Population | int(11)  | NO   |     | 0       |                |\n+------------+----------+------+-----+---------+----------------+\n\nSHOW COLUMNS FROM employees WHERE Type LIKE \'Varchar%\';\n+---------------+-------------+------+-----+---------+-------+\n| Field         | Type        | Null | Key | Default | Extra |\n+---------------+-------------+------+-----+---------+-------+\n| first_name    | varchar(30) | NO   | MUL | NULL    |       |\n| last_name     | varchar(40) | NO   |     | NULL    |       |\n| position      | varchar(25) | NO   |     | NULL    |       |\n| home_address  | varchar(50) | NO   |     | NULL    |       |\n| home_phone    | varchar(12) | NO   |     | NULL    |       |\n| employee_code | varchar(25) | NO   | UNI | NULL    |       |\n+---------------+-------------+------+-----+---------+-------+\n\nURL: https://mariadb.com/kb/en/show-columns/','','https://mariadb.com/kb/en/show-columns/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (340,26,'SHOW CREATE TABLE','Syntax\n------\n\nSHOW CREATE TABLE tbl_name\n\nDescription\n-----------\n\nShows the CREATE TABLE statement that created the given table. The statement\nrequires the SELECT privilege for the table. This statement also works with\nviews and SEQUENCE.\n\nSHOW CREATE TABLE quotes table and column names according to the value of the\nsql_quote_show_create server system variable.\n\nCertain SQL_MODE values can result in parts of the original CREATE statement\nnot being included in the output. MariaDB-specific table options, column\noptions, and index options are not included in the output of this statement if\nthe NO_TABLE_OPTIONS, NO_FIELD_OPTIONS and NO_KEY_OPTIONS SQL_MODE flags are\nused. All MariaDB-specific table attributes are also not shown when a\nnon-MariaDB/MySQL emulation mode is used, which includes ANSI, DB2,\nPOSTGRESQL, MSSQL, MAXDB or ORACLE.\n\nInvalid table options, column options and index options are normally commented\nout (note, that it is possible to create a table with invalid options, by\naltering a table of a different engine, where these options were valid). To\nhave them uncommented, enable the IGNORE_BAD_TABLE_OPTIONS SQL_MODE. Remember\nthat replaying a CREATE TABLE statement with uncommented invalid options will\nfail with an error, unless the IGNORE_BAD_TABLE_OPTIONS SQL_MODE is in effect.\n\nNote that SHOW CREATE TABLE is not meant to provide metadata about a table. It\nprovides information about how the table was declared, but the real table\nstructure could differ a bit. For example, if an index has been declared as\nHASH, the CREATE TABLE statement returned by SHOW CREATE TABLE will declare\nthat index as HASH; however, it is possible that the index is in fact a BTREE,\nbecause the storage engine does not support HASH.\n\nMariaDB starting with 10.2.1\n----------------------------\nMariaDB 10.2.1 permits TEXT and BLOB data types to be assigned a DEFAULT\nvalue. As a result, from MariaDB 10.2.1, SHOW CREATE TABLE will append a\nDEFAULT NULL to nullable TEXT or BLOB fields if no specific default is\nprovided.\n\nMariaDB starting with 10.2.2\n----------------------------\nFrom MariaDB 10.2.2, numbers are no longer quoted in the DEFAULT clause in\nSHOW CREATE statement. Previously, MariaDB quoted numbers.\n\nIndex Order\n-----------\n\nIndexes are sorted and displayed in the following order, which may differ from\nthe order of the CREATE TABLE statement.\n\n* PRIMARY KEY\n* UNIQUE keys where all column are NOT NULL\n* UNIQUE keys that don\'t contain partial segments\n* Other UNIQUE keys\n* LONG UNIQUE keys\n* Normal keys\n* Fulltext keys\n\nSee sql/sql_table.cc for details.\n\nExamples\n--------\n\nSHOW CREATE TABLE t\\G\n*************************** 1. row ***************************\n   Table: t\nCreate Table: CREATE TABLE `t` (\n `id` int(11) NOT NULL AUTO_INCREMENT,\n `s` char(60) DEFAULT NULL,\n PRIMARY KEY (`id`)\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n\nWith sql_quote_show_create off:\n\nSHOW CREATE TABLE t\\G\n*************************** 1. row ***************************\n   Table: t\nCreate Table: CREATE TABLE t (\n id int(11) NOT NULL AUTO_INCREMENT,\n s char(60) DEFAULT NULL,\n PRIMARY KEY (id)\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n\nUnquoted numeric DEFAULTs, from MariaDB 10.2.2:\n\nCREATE TABLE td (link TINYINT DEFAULT 1);\n\nSHOW CREATE TABLE td\\G\n*************************** 1. row ***************************\n   Table: td\nCreate Table: CREATE TABLE `td` (\n `link` tinyint(4) DEFAULT 1\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n\nQuoted numeric DEFAULTs, until MariaDB 10.2.1:\n\nCREATE TABLE td (link TINYINT DEFAULT 1);\n\nSHOW CREATE TABLE td\\G\n*************************** 1. row ***************************\n   Table: td\nCreate Table: CREATE TABLE `td` (\n `link` tinyint(4) DEFAULT \'1\'\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n\nSQL_MODE impacting the output:\n\nSELECT @@sql_mode;\n+------------------------------------------------------------------------------\n------------+\n| @@sql_mode                                                                  \n      |\n+------------------------------------------------------------------------------\n------------+\n|\nSTRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SU\nSTITUTION |\n+------------------------------------------------------------------------------\n------------+\n\nCREATE TABLE `t1` (\n   `id` int(11) NOT NULL AUTO_INCREMENT,\n   `msg` varchar(100) DEFAULT NULL,\n   PRIMARY KEY (`id`)\n  ) ENGINE=InnoDB DEFAULT CHARSET=latin1\n;\n\nSHOW CREATE TABLE t1\\G\n*************************** 1. row ***************************\n   Table: t1\nCreate Table: CREATE TABLE `t1` (\n `id` int(11) NOT NULL AUTO_INCREMENT,\n `msg` varchar(100) DEFAULT NULL,\n PRIMARY KEY (`id`)\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n\nSET SQL_MODE=ORACLE;\n\nSHOW CREATE TABLE t1\\G\n*************************** 1. row ***************************\n   Table: t1\nCreate Table: CREATE TABLE \"t1\" (\n \"id\" int(11) NOT NULL,\n \"msg\" varchar(100) DEFAULT NULL,\n PRIMARY KEY (\"id\")\n\nURL: https://mariadb.com/kb/en/show-create-table/','','https://mariadb.com/kb/en/show-create-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (341,26,'SHOW INDEX','Syntax\n------\n\nSHOW {INDEX | INDEXES | KEYS} \n FROM tbl_name [FROM db_name]\n [WHERE expr]\n\nDescription\n-----------\n\nSHOW INDEX returns table index information. The format resembles that of the\nSQLStatistics call in ODBC.\n\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM db_name\nsyntax. These two statements are equivalent:\n\nSHOW INDEX FROM mytable FROM mydb;\nSHOW INDEX FROM mydb.mytable;\n\nSHOW KEYS and SHOW INDEXES are synonyms for SHOW INDEX.\n\nYou can also list a table\'s indexes with the mariadb-show command:\n\nmariadb-show -k db_name tbl_name\n\nThe information_schema.STATISTICS table stores similar information.\n\nThe following fields are returned by SHOW INDEX.\n\n+------------------------+---------------------------------------------------+\n| Field                  | Description                                       |\n+------------------------+---------------------------------------------------+\n| Table                  | Table name                                        |\n+------------------------+---------------------------------------------------+\n| Non_unique             | 1 if the index permits duplicate values, 0 if     |\n|                        | values must be unique.                            |\n+------------------------+---------------------------------------------------+\n| Key_name               | Index name. The primary key is always named       |\n|                        | PRIMARY.                                          |\n+------------------------+---------------------------------------------------+\n| Seq_in_index           | The column\'s sequence in the index, beginning     |\n|                        | with 1.                                           |\n+------------------------+---------------------------------------------------+\n| Column_name            | Column name.                                      |\n+------------------------+---------------------------------------------------+\n| Collation              | Either A, if the column is sorted in ascending    |\n|                        | order in the index, or NULL if it\'s not sorted.   |\n+------------------------+---------------------------------------------------+\n| Cardinality            | Estimated number of unique values in the index.   |\n|                        | The cardinality statistics are calculated at      |\n|                        | various times, and can help the optimizer make    |\n|                        | improved decisions.                               |\n+------------------------+---------------------------------------------------+\n| Sub_part               | NULL if the entire column is included in the      |\n|                        | index, or the number of included characters if    |\n|                        | not.                                              |\n+------------------------+---------------------------------------------------+\n| Packed                 | NULL if the index is not packed, otherwise how    |\n|                        | the index is packed.                              |\n+------------------------+---------------------------------------------------+\n| Null                   | NULL if NULL values are permitted in the column,  |\n|                        | an empty string if NULLs are not permitted.       |\n+------------------------+---------------------------------------------------+\n| Index_type             | The index type, which can be BTREE, FULLTEXT,     |\n|                        | HASH or RTREE. See Storage Engine Index Types.    |\n+------------------------+---------------------------------------------------+\n| Comment                | Other information, such as whether the index is   |\n|                        | disabled.                                         |\n+------------------------+---------------------------------------------------+\n| Index_comment          | Contents of the COMMENT attribute when the index  |\n|                        | was created.                                      |\n+------------------------+---------------------------------------------------+\n| Ignored                | Whether or not an index will be ignored by the    |\n|                        | optimizer. See Ignored Indexes. From MariaDB      |\n|                        | 10.6.0.                                           |\n+------------------------+---------------------------------------------------+\n\nThe WHERE and LIKE clauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW.\n\nExamples\n--------\n\nCREATE TABLE IF NOT EXISTS `employees_example` (\n `id` int(11) NOT NULL AUTO_INCREMENT,\n `first_name` varchar(30) NOT NULL,\n `last_name` varchar(40) NOT NULL,\n `position` varchar(25) NOT NULL,\n `home_address` varchar(50) NOT NULL,\n `home_phone` varchar(12) NOT NULL,\n `employee_code` varchar(25) NOT NULL,\n PRIMARY KEY (`id`),\n UNIQUE KEY `employee_code` (`employee_code`),\n KEY `first_name` (`first_name`,`last_name`)\n) ENGINE=Aria;\n\nINSERT INTO `employees_example` (`first_name`, `last_name`, `position`,\n`home_address`, `home_phone`, `employee_code`)\n VALUES\n (\'Mustapha\', \'Mond\', \'Chief Executive Officer\', \'692 Promiscuous Plaza\',\n\'326-555-3492\', \'MM1\'),\n (\'Henry\', \'Foster\', \'Store Manager\', \'314 Savage Circle\', \'326-555-3847\',\n\'HF1\'),\n (\'Bernard\', \'Marx\', \'Cashier\', \'1240 Ambient Avenue\', \'326-555-8456\', \'BM1\'),\n (\'Lenina\', \'Crowne\', \'Cashier\', \'281 Bumblepuppy Boulevard\', \'328-555-2349\',\n\'LC1\'),\n (\'Fanny\', \'Crowne\', \'Restocker\', \'1023 Bokanovsky Lane\', \'326-555-6329\',\n\'FC1\'),\n (\'Helmholtz\', \'Watson\', \'Janitor\', \'944 Soma Court\', \'329-555-2478\', \'HW1\');\n\nSHOW INDEXES FROM employees_example\\G\n*************************** 1. row ***************************\n    Table: employees_example\n Non_unique: 0\n  Key_name: PRIMARY\n Seq_in_index: 1\n Column_name: id\n  Collation: A\n Cardinality: 6\n  Sub_part: NULL\n   Packed: NULL\n    Null:\n Index_type: BTREE\n   Comment:\nIndex_comment: \n   Ignored: NO\n*************************** 2. row ***************************\n    Table: employees_example\n Non_unique: 0\n  Key_name: employee_code\n Seq_in_index: 1\n Column_name: employee_code\n  Collation: A\n Cardinality: 6\n  Sub_part: NULL\n   Packed: NULL\n    Null:\n Index_type: BTREE\n   Comment:\nIndex_comment: \n   Ignored: NO\n*************************** 3. row ***************************\n    Table: employees_example\n Non_unique: 1\n  Key_name: first_name\n Seq_in_index: 1\n Column_name: first_name\n  Collation: A\n Cardinality: NULL\n  Sub_part: NULL\n   Packed: NULL\n    Null:\n Index_type: BTREE\n   Comment:\nIndex_comment: \n   Ignored: NO\n*************************** 4. row ***************************\n    Table: employees_example\n Non_unique: 1\n  Key_name: first_name\n Seq_in_index: 2\n Column_name: last_name\n  Collation: A\n Cardinality: NULL\n  Sub_part: NULL\n   Packed: NULL\n    Null:\n Index_type: BTREE\n   Comment:\nIndex_comment: \n   Ignored: NO\n\nURL: https://mariadb.com/kb/en/show-index/','','https://mariadb.com/kb/en/show-index/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (342,26,'SHOW EXPLAIN','Syntax\n------\n\nSHOW EXPLAIN [FORMAT=JSON] FOR <connection_id>;\nEXPLAIN [FORMAT=JSON] FOR CONNECTION <connection_id>;\n\nDescription\n-----------\n\nThe SHOW EXPLAIN command allows one to get an EXPLAIN (that is, a description\nof a query plan) of a query running in a certain connection.\n\nSHOW EXPLAIN FOR <connection_id>;\n\nwill produce an EXPLAIN output for the query that connection number\nconnection_id is running. The connection id can be obtained with SHOW\nPROCESSLIST.\n\nSHOW EXPLAIN FOR 1;\n+------+-------------+-------+-------+---------------+------+---------+------+-\n-------+-------------+\n| id   | select_type | table | type  | possible_keys | key  | key_len | ref  |\nrows    | Extra       |\n+------+-------------+-------+-------+---------------+------+---------+------+-\n-------+-------------+\n|    1 | SIMPLE      | tbl   | index | NULL          | a    | 5       | NULL |\n1000107 | Using index |\n+------+-------------+-------+-------+---------------+------+---------+------+-\n-------+-------------+\n1 row in set, 1 warning (0.00 sec)\n\nThe output is always accompanied with a warning which shows the query the\ntarget connection is running (this shows what the EXPLAIN is for):\n\nSHOW WARNINGS;\n+-------+------+------------------------+\n| Level | Code | Message                |\n+-------+------+------------------------+\n| Note  | 1003 | select sum(a) from tbl |\n+-------+------+------------------------+\n1 row in set (0.00 sec)\n\nEXPLAIN FOR CONNECTION\n----------------------\n\nMariaDB starting with 10.9\n--------------------------\nThe EXPLAIN FOR CONNECTION syntax was added for MySQL compatibility.\n\nFORMAT=JSON\n-----------\n\nMariaDB starting with 10.9\n--------------------------\nSHOW EXPLAIN [FORMAT=JSON] FOR <connection_id> extends SHOW EXPLAIN to return\nmore detailed JSON output.\n\nPossible Errors\n---------------\n\nThe output can be only produced if the target connection is currently running\na query, which has a ready query plan. If this is not the case, the output\nwill be:\n\nSHOW EXPLAIN FOR 2;\nERROR 1932 (HY000): Target is not running an EXPLAINable command\n\nYou will get this error when:\n\n* the target connection is not running a command for which one can run EXPLAIN\n* the target connection is running a command for which one can run EXPLAIN, but\nthere is no query plan yet (for example, tables are open and locks are\n acquired before the query plan is produced)\n\nDifferences Between SHOW EXPLAIN and EXPLAIN Outputs\n----------------------------------------------------\n\nBackground\n----------\n\nIn MySQL, EXPLAIN execution takes a slightly different route from the way the\nreal query (typically the SELECT) is optimized. This is unfortunate, and has\ncaused a number of bugs in EXPLAIN. (For example, see MDEV-326, MDEV-410, and\nlp:1013343. lp:992942 is not directly about EXPLAIN, but it also would not\nhave existed if MySQL didn\'t try to delete parts of a query plan in the middle\nof the query)\n\nSHOW EXPLAIN examines a running SELECT, and hence its output may be slightly\ndifferent from what EXPLAIN SELECT would produce. We did our best to make sure\nthat either the difference is negligible, or SHOW EXPLAIN\'s output is closer\nto reality than EXPLAIN\'s output.\n\nList of Recorded Differences\n----------------------------\n\n* SHOW EXPLAIN may have Extra=\'no matching row in const table\', where  EXPLAIN\nwould produce Extra=\'Impossible WHERE ...\'\n* For queries with subqueries, SHOW EXPLAIN may print select_type==PRIMARY\nwhere regular EXPLAIN used to print select_type==SIMPLE, or vice versa.\n\nRequired Permissions\n--------------------\n\nRunning SHOW EXPLAIN requires the same permissions as running SHOW PROCESSLIST\nwould.\n\nURL: https://mariadb.com/kb/en/show-explain/','','https://mariadb.com/kb/en/show-explain/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (343,26,'BACKUP STAGE','MariaDB starting with 10.4.1\n----------------------------\nThe BACKUP STAGE commands were introduced in MariaDB 10.4.1.\n\nThe BACKUP STAGE commands are a set of commands to make it possible to make an\nefficient external backup tool.\n\nSyntax\n------\n\nBACKUP STAGE [START | FLUSH | BLOCK_DDL | BLOCK_COMMIT | END ]\n\nIn the following text, a transactional table means InnoDB or \"InnoDB-like\nengine with redo log that can lock redo purges and can be copied without locks\nby an outside process\".\n\nGoals with BACKUP STAGE Commands\n--------------------------------\n\n* To be able to do a majority of the backup with the minimum possible server\nlocks. Especially for transactional tables (InnoDB, MyRocks etc) there is only\nneed for a very short block of new commits while copying statistics and log\ntables.\n* DDL are only needed to be blocked for a very short duration of the backup\nwhile mariabackup is copying the tables affected by DDL during the initial\npart of the backup.\n* Most non transactional tables (those that are not in use) will be copied\nduring BACKUP STAGE START.  The exceptions are system statistic and log tables\nthat are not blocked during the backup until BLOCK_COMMIT.\n* Should work efficiently with backup tools that use disk snapshots.\n* Should work as efficiently as possible for all table types that store data\non the local disks.\n* As little copying as possible under higher level stages/locks. For example,\n.frm (dictionary) and .trn (trigger) files should be copying while copying the\ntable data.\n\nBACKUP STAGE Commands\n---------------------\n\nBACKUP STAGE START\n------------------\n\nThe START stage is designed for the following tasks:\n\n* Blocks purge of redo files for storage engines that needs this (Aria)\n* Start logging of DDL commands into \'datadir\'/ddl.log. This may take a short\ntime as the command has to wait until there are no active DDL commands.\n\nBACKUP STAGE FLUSH\n------------------\n\nThe FLUSH stage is designed for the following tasks:\n\n* FLUSH all changes for inactive non-transactional tables, except for\nstatistics and log tables.\n* Close all tables that are not in use, to ensure they are marked as closed\nfor the backup.\n* BLOCK all new write locks for all non transactional tables (except\nstatistics and log tables).  The command will not wait for tables that are in\nuse by read-only transactions.\n\nDDLs don\'t have to be blocked at this stage as they can\'t cause the table to\nbe in an inconsistent state. This is true also for non-transactional tables.\n\nBACKUP STAGE BLOCK_DDL\n----------------------\n\nThe BLOCK_DDL stage is designed for the following tasks:\n\n* Wait for all statements using write locked non-transactional tables to end.\n* Blocks CREATE TABLE, DROP TABLE, TRUNCATE TABLE, and RENAME TABLE.\n* Blocks also start off a new ALTER TABLE and the final rename phase of ALTER\nTABLE. Running ALTER TABLES are not blocked.\n\nBACKUP STAGE BLOCK_COMMIT\n-------------------------\n\nThe BLOCK_COMMIT stage is designed for the following tasks:\n\n* Lock the binary log and commit/rollback to ensure that no changes are\ncommitted to any tables. If there are active commits or data to be copied to\nthe binary log this will be allowed to finish.  Active transactions will not\naffect BLOCK_COMMIT.\n* This doesn\'t lock temporary tables that are not used by replication. However\nthese will be blocked when it\'s time to write to the binary log.\n* Lock system log tables and statistics tables, flush them and mark them\nclosed.\n\nWhen the BLOCK_COMMIT\'s stages return, this is the \'backup time\'. Everything\ncommitted will be in the backup and everything not committed will roll back.\n\nTransactional engines will continue to do changes to the redo log during the\nBLOCK COMMIT stage, but this is not important as all of these will roll back\nlater as the changes will not be committed.\n\nBACKUP STAGE END\n----------------\n\nThe END stage is designed for the following tasks:\n\n* End DDL logging\n* Free resources\n\nUsing BACKUP STAGE Commands with Backup Tools\n---------------------------------------------\n\nUsing BACKUP STAGE Commands with Mariabackup\n--------------------------------------------\n\nThe BACKUP STAGE commands are a set of commands to make it possible to make an\nefficient external backup tool. How Mariabackup uses these commands depends on\nwhether you are using the version that is bundled with MariaDB Community\nServer or the version that is bundled with MariaDB Enterprise Server. See\nMariabackup and BACKUP STAGE Commands for some examples on how Mariabackup\nuses these commands.\n\nIf you would like to use a version of Mariabackup that uses the BACKUP STAGE\ncommands in an efficient way, then one option is to use MariaDB Enterprise\nBackup that is bundled with MariaDB Enterprise Server.\n\nUsing BACKUP STAGE Commands with Storage Snapshots\n--------------------------------------------------\n\nThe BACKUP STAGE commands are a set of commands to make it possible to make an\nefficient external backup tool. These commands could even be used by tools\nthat perform backups by taking a snapshot of a file system, SAN, or some other\nkind of storage device. See Storage Snapshots and BACKUP STAGE Commands for\nsome examples on how to use each BACKUP STAGE command in an efficient way.\n\nPrivileges\n----------\n\nBACKUP STAGE requires the RELOAD privilege.\n\nNotes\n-----\n\n* Only one connection can run BACKUP STAGE START. If a second connection\ntries, it will wait until the first one has executed BACKUP STAGE END.\n* If the user skips a BACKUP STAGE, then all intermediate backup stages will\nautomatically be run. This will allow us to add new stages within the BACKUP\nSTAGE hierarchy in the future with even more precise locks without causing\nproblems for tools using an earlier version of the BACKUP STAGE implementation.\n* One can use the max_statement_time or lock_wait_timeout system variables to\nensure that a BACKUP STAGE command doesn\'t block the server too long.\n* DDL logging will only be available in MariaDB Enterprise Server 10.2 and\nlater.\n* A disconnect will automatically release backup stages.\n* There is no easy way to see which is the current stage.\n\nURL: https://mariadb.com/kb/en/backup-stage/','','https://mariadb.com/kb/en/backup-stage/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (344,26,'BACKUP LOCK','MariaDB starting with 10.4.2\n----------------------------\nThe BACKUP LOCK command was introduced in MariaDB 10.4.2.\n\nBACKUP LOCK blocks a table from DDL statements. This is mainly intended to be\nused by tools like mariabackup that need to ensure there are no DDLs on a\ntable while the table files are opened. For example, for an Aria table that\nstores data in 3 files with extensions .frm, .MAI and .MAD. Normal read/write\noperations can continue as normal.\n\nSyntax\n------\n\nTo lock a table:\n\nBACKUP LOCK table_name\n\nTo unlock a table:\n\nBACKUP UNLOCK\n\nUsage in a Backup Tool\n----------------------\n\nBACKUP LOCK [database.]table_name;\n - Open all files related to a table (for example, t.frm, t.MAI and t.MYD)\nBACKUP UNLOCK;\n- Copy data\n- Close files\n\nThis ensures that all files are from the same generation, that is created at\nthe same time by the MariaDB server. This works, because the open files will\npoint to the original table files which will not be affected if there is any\nALTER TABLE while copying the files.\n\nPrivileges\n----------\n\nBACKUP LOCK requires the RELOAD privilege.\n\nNotes\n-----\n\n* The idea is that the BACKUP LOCK should be held for as short a time as\npossible by the backup tool. The time to take an uncontested lock is very\nshort! One can easily do 50,000 locks/unlocks per second on low end hardware.\n* One should use different connections for BACKUP STAGE commands and BACKUP\nLOCK.\n\nImplementation\n--------------\n\n* Internally, BACKUP LOCK is implemented by taking an MDLSHARED_HIGH_PRIO MDL\nlock on the table object, which protects the table from any DDL operations.\n\nURL: https://mariadb.com/kb/en/backup-lock/','','https://mariadb.com/kb/en/backup-lock/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (345,26,'FLUSH','Syntax\n------\n\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL]\n  flush_option [, flush_option] ...\n\nor when flushing tables:\n\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL] TABLES [table_list]  [table_flush_option]\n\nwhere table_list is a list of tables separated by , (comma).\n\nDescription\n-----------\n\nThe FLUSH statement clears or reloads various internal caches used by MariaDB.\nTo execute FLUSH, you must have the RELOAD privilege. See GRANT.\n\nThe RESET statement is similar to FLUSH. See RESET.\n\nYou cannot issue a FLUSH statement from within a stored function or a trigger.\nDoing so within a stored procedure is permitted, as long as it is not called\nby a stored function or trigger. See Stored Routine Limitations, Stored\nFunction Limitations and Trigger Limitations.\n\nIf a listed table is a view, an error like the following will be produced:\n\nERROR 1347 (HY000): \'test.v\' is not BASE TABLE\n\nBy default, FLUSH statements are written to the binary log and will be\nreplicated. The NO_WRITE_TO_BINLOG keyword (LOCAL is an alias) will ensure the\nstatement is not written to the binary log.\n\nThe different flush options are:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| CHANGED_PAGE_BITMAPS      | XtraDB only. Internal command used for backup  |\n|                           | purposes. See the Information Schema           |\n|                           | CHANGED_PAGE_BITMAPS Table.                    |\n+---------------------------+------------------------------------------------+\n| CLIENT_STATISTICS         | Reset client statistics (see SHOW              |\n|                           | CLIENT_STATISTICS).                            |\n+---------------------------+------------------------------------------------+\n| DES_KEY_FILE              | Reloads the DES key file (Specified with the   |\n|                           | --des-key-file startup option).                |\n+---------------------------+------------------------------------------------+\n| HOSTS                     | Flush the hostname cache (used for converting  |\n|                           | ip to host names and for unblocking blocked    |\n|                           | hosts. See max_connect_errors and              |\n|                           | performance_schema.host_cache                  |\n+---------------------------+------------------------------------------------+\n| INDEX_STATISTICS          | Reset index statistics (see SHOW               |\n|                           | INDEX_STATISTICS).                             |\n+---------------------------+------------------------------------------------+\n| [ERROR | ENGINE |         | Close and reopen the specified log type, or    |\n| GENERAL | SLOW | BINARY   | all log types if none are specified. FLUSH     |\n| | RELAY] LOGS             | RELAY LOGS [connection-name] can be used to    |\n|                           | flush the relay logs for a specific            |\n|                           | connection. Only one connection can be         |\n|                           | specified per FLUSH command. See Multi-source  |\n|                           | replication. FLUSH ENGINE LOGS will delete     |\n|                           | all unneeded Aria redo logs. FLUSH BINARY      |\n|                           | LOGS DELETE_DOMAIN_ID=(list-of-domains) can    |\n|                           | be used to discard obsolete GTID domains from  |\n|                           | the server\'s binary log state. In order for    |\n|                           | this to be successful, no event group from     |\n|                           | the listed GTID domains can be present in      |\n|                           | existing binary log files. If some still       |\n|                           | exist, then they must be purged prior to       |\n|                           | executing this command. If the command         |\n|                           | completes successfully, then it also rotates   |\n|                           | the binary log.                                |\n+---------------------------+------------------------------------------------+\n| MASTER                    | Deprecated option, use RESET MASTER instead.   |\n+---------------------------+------------------------------------------------+\n| PRIVILEGES                | Reload all privileges from the privilege       |\n|                           | tables in the mysql database. If the server    |\n|                           | is started with --skip-grant-table option,     |\n|                           | this will activate the privilege tables again. |\n+---------------------------+------------------------------------------------+\n| QUERY CACHE               | Defragment the query cache to better utilize   |\n|                           | its memory. If you want to reset the query     |\n|                           | cache, you can do it with RESET QUERY CACHE.   |\n+---------------------------+------------------------------------------------+\n| QUERY_RESPONSE_TIME       | See the QUERY_RESPONSE_TIME plugin.            |\n+---------------------------+------------------------------------------------+\n| SLAVE                     | Deprecated option, use RESET REPLICA or RESET  |\n|                           | SLAVE instead.                                 |\n+---------------------------+------------------------------------------------+\n| SSL                       | Used to dynamically reinitialize the server\'s  |\n|                           | TLS context by reloading the files defined by  |\n|                           | several TLS system variables. See FLUSH SSL    |\n|                           | for more information.                          |\n+---------------------------+------------------------------------------------+\n| STATUS                    | Resets all server status variables that can    |\n|                           | be reset to 0. Not all global status           |\n|                           | variables support this, so not all global      |\n|                           | values are reset. See FLUSH STATUS for more    |\n|                           | information.                                   |\n+---------------------------+------------------------------------------------+\n| TABLE                     | Close tables given as options or all open      |\n|                           | tables if no table list was used. From         |\n|                           | MariaDB 10.4.1, using without any table list   |\n|                           | will only close tables not in use, and tables  |\n|                           | not locked by the FLUSH TABLES connection. If  |\n|                           | there are no locked tables, FLUSH TABLES will  |\n|                           | be instant and will not cause any waits, as    |\n|                           | it no longer waits for tables in use. When a   |\n|                           | table list is provided, from MariaDB 10.4.1,   |\n|                           | the server will wait for the end of any        |\n|                           | transactions that are using the tables.        |\n|                           | Previously, FLUSH TABLES only waited for the   |\n|                           | statements to complete.                        |\n+---------------------------+------------------------------------------------+\n| TABLES                    | Same as FLUSH TABLE.                           |\n+---------------------------+------------------------------------------------+\n| TABLES ... FOR EXPORT     | For InnoDB tables, flushes table changes to    |\n|                           | disk to permit binary table copies while the   |\n|                           | server is running. See FLUSH TABLES ... FOR    |\n|                           | EXPORT for more.                               |\n+---------------------------+------------------------------------------------+\n| TABLES WITH READ LOCK     | Closes all open tables. New tables are only    |\n|                           | allowed to be opened with read locks until an  |\n|                           | UNLOCK TABLES is given.                        |\n+---------------------------+------------------------------------------------+\n| TABLES WITH READ LOCK     | As TABLES WITH READ LOCK but also disable all  |\n| AND DISABLE CHECKPOINT    | checkpoint writes by transactional table       |\n|                           | engines. This is useful when doing a disk      |\n|                           | snapshot of all tables.                        |\n+---------------------------+------------------------------------------------+\n| TABLE_STATISTICS          | Reset table statistics (see SHOW               |\n|                           | TABLE_STATISTICS).                             |\n+---------------------------+------------------------------------------------+\n| USER_RESOURCES            | Resets all per hour user resources. This       |\n|                           | enables clients that have exhausted their      |\n|                           | resources to connect again.                    |\n+---------------------------+------------------------------------------------+\n| USER_STATISTICS           | Reset user statistics (see SHOW                |\n|                           | USER_STATISTICS).                              |\n+---------------------------+------------------------------------------------+\n| USER_VARIABLES            | Reset user variables (see User-defined         |\n|                           | variables).                                    |\n+---------------------------+------------------------------------------------+\n\nYou can also use the mariadb-admin client to flush things. Use mariadb-admin\n--help to examine what flush commands it supports.\n\nFLUSH RELAY LOGS\n----------------\n\nFLUSH RELAY LOGS \'connection_name\';\n\nCompatibility with MySQL\n------------------------\n\nMariaDB starting with 10.7.0\n----------------------------\nThe FOR CHANNEL keyword was added for MySQL compatibility. This is identical\nas using the channel_name directly after the FLUSH command.\n\nFor example, one can now use:\n\nFLUSH RELAY LOGS FOR CHANNEL \'connection_name\';\n\nFLUSH STATUS\n------------\n\nServer status variables can be reset by executing the following:\n\nFLUSH STATUS;\n\nGlobal Status Variables that Support FLUSH STATUS\n-------------------------------------------------\n\nNot all global status variables support being reset by FLUSH STATUS.\nCurrently, the following status variables are reset by FLUSH STATUS:\n\n* Aborted_clients\n* Aborted_connects\n* Binlog_cache_disk_use\n* Binlog_cache_use\n* Binlog_stmt_cache_disk_use\n* Binlog_stmt_cache_use\n* Connection_errors_accept\n* Connection_errors_internal\n* Connection_errors_max_connections\n* Connection_errors_peer_address\n* Connection_errors_select\n* Connection_errors_tcpwrap\n* Created_tmp_files\n* Delayed_errors\n* Delayed_writes\n* Feature_check_constraint\n* Feature_delay_key_write\n* Max_used_connections\n* Opened_plugin_libraries\n* Performance_schema_accounts_lost\n* Performance_schema_cond_instances_lost\n* Performance_schema_digest_lost\n* Performance_schema_file_handles_lost\n* Performance_schema_file_instances_lost\n* Performance_schema_hosts_lost\n* Performance_schema_locker_lost\n* Performance_schema_mutex_instances_lost\n* Performance_schema_rwlock_instances_lost\n* Performance_schema_session_connect_attrs_lost\n* Performance_schema_socket_instances_lost\n* Performance_schema_stage_classes_lost\n* Performance_schema_statement_classes_lost\n* Performance_schema_table_handles_lost\n* Performance_schema_table_instances_lost\n* Performance_schema_thread_instances_lost\n* Performance_schema_users_lost\n* Qcache_hits\n* Qcache_inserts\n* Qcache_lowmem_prunes\n* Qcache_not_cached\n* Rpl_semi_sync_master_no_times\n* Rpl_semi_sync_master_no_tx\n* Rpl_semi_sync_master_timefunc_failures\n* Rpl_semi_sync_master_wait_pos_backtraverse\n* Rpl_semi_sync_master_yes_tx\n* Rpl_transactions_multi_engine\n* Server_audit_writes_failed\n* Slave_retried_transactions\n* Slow_launch_threads\n* Ssl_accept_renegotiates\n* Ssl_accepts\n* Ssl_callback_cache_hits\n* Ssl_client_connects\n* Ssl_connect_renegotiates\n* Ssl_ctx_verify_depth\n* Ssl_ctx_verify_mode\n* Ssl_finished_accepts\n* Ssl_finished_connects\n* Ssl_session_cache_hits\n* Ssl_session_cache_misses\n* Ssl_session_cache_overflows\n* Ssl_session_cache_size\n* Ssl_session_cache_timeouts\n* Ssl_sessions_reused\n* Ssl_used_session_cache_entries\n* Subquery_cache_hit\n* Subquery_cache_miss\n* Table_locks_immediate\n* Table_locks_waited\n* Tc_log_max_pages_used\n* Tc_log_page_waits\n* Transactions_gtid_foreign_engine\n* Transactions_multi_engine\n\nThe different usage of FLUSH TABLES\n-----------------------------------\n\nThe purpose of FLUSH TABLES\n---------------------------\n\nThe purpose of FLUSH TABLES is to clean up the open table cache and table\ndefinition cache from not in use tables. This frees up memory and file\ndescriptors. Normally this is not needed as the caches works on a FIFO bases,\nbut can be useful if the server seams to use up to much memory for some reason.\n\nThe purpose of FLUSH TABLES WITH READ LOCK \n-------------------------------------------\n\nFLUSH TABLES WITH READ LOCK is useful if you want to take a backup of some\ntables. When FLUSH TABLES WITH READ LOCK returns, all write access to tables\nare blocked and all tables are marked as \'properly closed\' on disk. The tables\ncan still be used for read operations.\n\nThe purpose of FLUSH TABLES table_list\n--------------------------------------\n\nFLUSH TABLES table_list is useful if you want to copy a table object/files to\nor from the server. This command puts a lock that stops new users of the table\nand will wait until everyone has stopped using the table. The table is then\nremoved from the table definition and table cache.\n\nNote that it\'s up to the user to ensure that no one is accessing the table\nbetween FLUSH TABLES and the table is copied to or from the server. This can\nbe secured by using LOCK TABLES.\n\nIf there are any tables locked by the connection that is using FLUSH TABLES\nall the locked tables will be closed as part of the flush and reopened and','','https://mariadb.com/kb/en/flush/');
update help_topic set description = CONCAT(description, '\nrelocked before FLUSH TABLES returns. This allows one to copy the table after\nFLUSH TABLES returns without having any writes on the table. For now this\nworks works with most tables, except InnoDB as InnoDB may do background purges\non the table even while it\'s write locked.\n\nThe purpose of FLUSH TABLES table_list WITH READ LOCK\n-----------------------------------------------------\n\nFLUSH TABLES table_list WITH READ LOCK should work as FLUSH TABLES WITH READ\nLOCK, but only those tables that are listed will be properly closed. However\nin practice this works exactly like FLUSH TABLES WITH READ LOCK as the FLUSH\ncommand has anyway to wait for all WRITE operations to end because we are\ndepending on a global read lock for this code. In the future we should\nconsider fixing this to instead use meta data locks.\n\nImplementation of FLUSH TABLES commands in MariaDB 10.4.8 and above\n-------------------------------------------------------------------\n\nImplementation of FLUSH TABLES\n------------------------------\n\n* Free memory and file descriptors not in use\n\nImplementation of FLUSH TABLES WITH READ LOCK\n---------------------------------------------\n\n* Lock all tables read only for simple old style backup.\n* All background writes are suspended and tables are marked as closed.\n* No statement requiring table changes are allowed for any user until UNLOCK\nTABLES.\n\nInstead of using FLUSH TABLE WITH READ LOCK one should in most cases instead\nuse BACKUP STAGE BLOCK_COMMIT.\n\nImplementation of FLUSH TABLES table_list\n-----------------------------------------\n\n* Free memory and file descriptors for tables not in use from table list.\n* Lock given tables as read only.\n* Wait until all translations has ended that uses any of the given tables.\n* Wait until all background writes are suspended and tables are marked as\nclosed.\n\nImplementation of FLUSH TABLES table_list FOR EXPORT\n----------------------------------------------------\n\n* Free memory and file descriptors for tables not in use from table list\n* Lock given tables as read.\n* Wait until all background writes are suspended and tables are marked as\nclosed.\n* Check that all tables supports FOR EXPORT\n* No changes to these tables allowed until UNLOCK TABLES\n\nThis is basically the same behavior as in old MariaDB version if one first\nlock the tables, then do FLUSH TABLES. The tables will be copyable until\nUNLOCK TABLES.\n\nFLUSH SSL\n---------\n\nMariaDB starting with 10.4\n--------------------------\nThe FLUSH SSL command was first added in MariaDB 10.4.\n\nIn MariaDB 10.4 and later, the FLUSH SSL command can be used to dynamically\nreinitialize the server\'s TLS context. This is most useful if you need to\nreplace a certificate that is about to expire without restarting the server.\n\nThis operation is performed by reloading the files defined by the following\nTLS system variables:\n\n* ssl_cert\n* ssl_key\n* ssl_ca\n* ssl_capath\n* ssl_crl\n* ssl_crlpath\n\nThese TLS system variables are not dynamic, so their values can not be changed\nwithout restarting the server.\n\nIf you want to dynamically reinitialize the server\'s TLS context, then you\nneed to change the certificate and key files at the relevant paths defined by\nthese TLS system variables, without actually changing the values of the\nvariables. See MDEV-19341 for more information.\n\nReducing Memory Usage\n---------------------\n\nTo flush some of the global caches that take up memory, you could execute the\nfollowing command:\n\nFLUSH LOCAL HOSTS,\n QUERY CACHE,\n TABLE_STATISTICS,\n INDEX_STATISTICS,\n USER_STATISTICS;\n\nURL: https://mariadb.com/kb/en/flush/') WHERE help_topic_id = 345;
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (346,26,'FLUSH QUERY CACHE','Description\n-----------\n\nYou can defragment the query cache to better utilize its memory with the FLUSH\nQUERY CACHE statement. The statement does not remove any queries from the\ncache.\n\nThe RESET QUERY CACHE statement removes all query results from the query\ncache. The FLUSH TABLES statement also does this.\n\nURL: https://mariadb.com/kb/en/flush-query-cache/','','https://mariadb.com/kb/en/flush-query-cache/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (347,26,'FLUSH TABLES FOR EXPORT','Syntax\n------\n\nFLUSH TABLES table_name [, table_name] FOR EXPORT\n\nDescription\n-----------\n\nFLUSH TABLES ... FOR EXPORT flushes changes to the specified tables to disk so\nthat binary copies can be made while the server is still running. This works\nfor Archive, Aria, CSV, InnoDB, MyISAM, MERGE, and XtraDB tables.\n\nThe table is read locked until one has issued UNLOCK TABLES.\n\nIf a storage engine does not support FLUSH TABLES FOR EXPORT, a 1031 error\n(SQLSTATE \'HY000\') is produced.\n\nIf FLUSH TABLES ... FOR EXPORT is in effect in the session, the following\nstatements will produce an error if attempted:\n\n* FLUSH TABLES WITH READ LOCK\n* FLUSH TABLES ... WITH READ LOCK\n* FLUSH TABLES ... FOR EXPORT\n* Any statement trying to update any table\n\nIf any of the following statements is in effect in the session, attempting\nFLUSH TABLES ... FOR EXPORT will produce an error.\n\n* FLUSH TABLES ... WITH READ LOCK\n* FLUSH TABLES ... FOR EXPORT\n* LOCK TABLES ... READ\n* LOCK TABLES ... WRITE\n\nFLUSH FOR EXPORT is not written to the binary log.\n\nThis statement requires the RELOAD and the LOCK TABLES privileges.\n\nIf one of the specified tables cannot be locked, none of the tables will be\nlocked.\n\nIf a table does not exist, an error like the following will be produced:\n\nERROR 1146 (42S02): Table \'test.xxx\' doesn\'t exist\n\nIf a table is a view, an error like the following will be produced:\n\nERROR 1347 (HY000): \'test.v\' is not BASE TABLE\n\nExample\n-------\n\nFLUSH TABLES test.t1 FOR EXPORT;\n#  Copy files related to the table (see below)\nUNLOCK TABLES;\n\nFor a full description, please see copying MariaDB tables.\n\nURL: https://mariadb.com/kb/en/flush-tables-for-export/','','https://mariadb.com/kb/en/flush-tables-for-export/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (348,26,'SHOW RELAYLOG EVENTS','The terms master and slave have historically been used in replication, but the\nterms terms primary and replica are now preferred. The old terms are used\nstill used in parts of the documentation, and in MariaDB commands, although\nMariaDB 10.5 has begun the process of renaming. The documentation process is\nongoing. See MDEV-18777 to follow progress on this effort.\n\nSyntax\n------\n\nSHOW RELAYLOG [\'connection_name\'] EVENTS\n  [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n  [ FOR CHANNEL \'channel_name\']\n\nDescription\n-----------\n\nOn replicas, this command shows the events in the relay log. If \'log_name\' is\nnot specified, the first relay log is shown.\n\nSyntax for the LIMIT clause is the same as for SELECT ... LIMIT.\n\nUsing the LIMIT clause is highly recommended because the SHOW RELAYLOG EVENTS\ncommand returns the complete contents of the relay log, which can be quite\nlarge.\n\nThis command does not return events related to setting user and system\nvariables. If you need those, use mariadb-binlog.\n\nOn the primary, this command does nothing.\n\nRequires the REPLICA MONITOR privilege (>= MariaDB 10.5.9), the REPLICATION\nSLAVE ADMIN privilege (>= MariaDB 10.5.2) or the REPLICATION SLAVE privilege\n(<= MariaDB 10.5.1).\n\nconnection_name\n---------------\n\nIf there is only one nameless primary, or the default primary (as specified by\nthe default_master_connection system variable) is intended, connection_name\ncan be omitted. If provided, the SHOW RELAYLOG statement will apply to the\nspecified primary. connection_name is case-insensitive.\n\nMariaDB starting with 10.7.0\n----------------------------\nThe FOR CHANNEL keyword was added for MySQL compatibility. This is identical\nas using the channel_name directly after SHOW RELAYLOG.\n\nURL: https://mariadb.com/kb/en/show-relaylog-events/','','https://mariadb.com/kb/en/show-relaylog-events/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (349,26,'SHOW SLAVE STATUS','Syntax\n------\n\nSHOW SLAVE [\"connection_name\"] STATUS [FOR CHANNEL \"connection_name\"]\nSHOW REPLICA [\"connection_name\"] STATUS -- From MariaDB 10.5.1\n\nor\n\nSHOW ALL SLAVES STATUS\nSHOW ALL REPLICAS STATUS -- From MariaDB 10.5.1\n\nDescription\n-----------\n\nThis statement is to be run on a replica and provides status information on\nessential parameters of the replica threads.\n\nThis statement requires the SUPER privilege, the REPLICATION_CLIENT privilege,\nor, from MariaDB 10.5.2, the REPLICATION SLAVE ADMIN privilege, or, from\nMariaDB 10.5.9, the REPLICA MONITOR privilege.\n\nMulti-Source\n------------\n\nThe ALL and \"connection_name\" options allow you to connect to many primaries\nat the same time.\n\nALL SLAVES (or ALL REPLICAS from MariaDB 10.5.1) gives you a list of all\nconnections to the primary nodes.\n\nThe rows will be sorted according to Connection_name.\n\nIf you specify a connection_name, you only get the information about that\nconnection. If connection_name is not used, then the name set by\ndefault_master_connection is used. If the connection name doesn\'t exist you\nwill get an error: There is no master connection for \'xxx\'.\n\nMariaDB starting with 10.7.0\n----------------------------\nThe FOR CHANNEL keyword was added for MySQL compatibility. This is identical\nto using the channel_name directly after SHOW SLAVE.\n\nColumn Descriptions\n-------------------\n\n+---------------------+------------------------------------------------------+\n| Name                | Description                                          |\n+---------------------+------------------------------------------------------+\n| Connection_name     | Name of the primary connection. Returned with SHOW   |\n|                     | ALL SLAVES STATUS (or SHOW ALL REPLICAS STATUS from  |\n|                     | MariaDB 10.5.1) only.                                |\n+---------------------+------------------------------------------------------+\n| Slave_SQL_State     | State of SQL thread. Returned with SHOW ALL SLAVES   |\n|                     | STATUS (or SHOW ALL REPLICAS STATUS from MariaDB     |\n|                     | 10.5.1) only. See Slave SQL Thread States.           |\n+---------------------+------------------------------------------------------+\n| Slave_IO_State      | State of I/O thread. See Slave I/O Thread States.    |\n+---------------------+------------------------------------------------------+\n| Master_host         | Master host that the replica is connected to.        |\n+---------------------+------------------------------------------------------+\n| Master_user         | Account user name being used to connect to the       |\n|                     | primary.                                             |\n+---------------------+------------------------------------------------------+\n| Master_port         | The port being used to connect to the primary.       |\n+---------------------+------------------------------------------------------+\n| Connect_Retry       | Time in seconds between retries to connect. The      |\n|                     | default is 60. The CHANGE MASTER TO statement can    |\n|                     | set this. The master-retry-count option determines   |\n|                     | the maximum number of reconnection attempts.         |\n+---------------------+------------------------------------------------------+\n| Master_Log_File     | Name of the primary binary log file that the I/O     |\n|                     | thread is currently reading from.                    |\n+---------------------+------------------------------------------------------+\n| Read_Master_Log_Pos | Position up to which the I/O thread has read in the  |\n|                     | current primary binary log file.                     |\n+---------------------+------------------------------------------------------+\n| Relay_Log_File      | Name of the relay log file that the SQL thread is    |\n|                     | currently processing.                                |\n+---------------------+------------------------------------------------------+\n| Relay_Log_Pos       | Position up to which the SQL thread has finished     |\n|                     | processing in the current relay log file.            |\n+---------------------+------------------------------------------------------+\n| Relay_Master_Log_Fi | Name of the primary binary log file that contains    |\n| e                   | the most recent event executed by the SQL thread.    |\n+---------------------+------------------------------------------------------+\n| Slave_IO_Running    | Whether the replica I/O thread is running and        |\n|                     | connected (Yes), running but not connected to a      |\n|                     | primary (Connecting) or not running (No).            |\n+---------------------+------------------------------------------------------+\n| Slave_SQL_Running   | Whether or not the SQL thread is running.            |\n+---------------------+------------------------------------------------------+\n| Replicate_Rewrite_D | Databases specified for replicating  and rewriting   |\n|                     | with the replicate_rewrite_db option. Added in       |\n|                     | MariaDB 10.11                                        |\n+---------------------+------------------------------------------------------+\n| Replicate_Do_DB     | Databases specified for replicating with the         |\n|                     | replicate_do_db option.                              |\n+---------------------+------------------------------------------------------+\n| Replicate_Ignore_DB | Databases specified for ignoring with the            |\n|                     | replicate_ignore_db option.                          |\n+---------------------+------------------------------------------------------+\n| Replicate_Do_Table  | Tables specified for replicating with the            |\n|                     | replicate_do_table option.                           |\n+---------------------+------------------------------------------------------+\n| Replicate_Ignore_Ta | Tables specified for ignoring with the               |\n| le                  | replicate_ignore_table option.                       |\n+---------------------+------------------------------------------------------+\n| Replicate_Wild_Do_T | Tables specified for replicating with the            |\n| ble                 | replicate_wild_do_table option.                      |\n+---------------------+------------------------------------------------------+\n| Replicate_Wild_Igno | Tables specified for ignoring with the               |\n| e_Table             | replicate_wild_ignore_table option.                  |\n+---------------------+------------------------------------------------------+\n| Last_Errno          | Alias for Last_SQL_Errno (see below)                 |\n+---------------------+------------------------------------------------------+\n| Last Error          | Alias for Last_SQL_Error (see below)                 |\n+---------------------+------------------------------------------------------+\n| Skip_Counter        | Number of events that a replica skips from the       |\n|                     | master, as recorded in the sql_slave_skip_counter    |\n|                     | system variable.                                     |\n+---------------------+------------------------------------------------------+\n| Exec_Master_Log_Pos | Position up to which the SQL thread has processed    |\n|                     | in the current master binary log file. Can be used   |\n|                     | to start a new replica from a current replica with   |\n|                     | the CHANGE MASTER TO ... MASTER_LOG_POS option.      |\n+---------------------+------------------------------------------------------+\n| Relay_Log_Space     | Total size of all relay log files combined.          |\n+---------------------+------------------------------------------------------+\n| Until_Condition     |                                                      |\n+---------------------+------------------------------------------------------+\n| Until_Log_File      | The MASTER_LOG_FILE value of the START SLAVE UNTIL   |\n|                     | condition.                                           |\n+---------------------+------------------------------------------------------+\n| Until_Log_Pos       | The MASTER_LOG_POS value of the START SLAVE UNTIL    |\n|                     | condition.                                           |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Allowed  | Whether an SSL connection is permitted (Yes), not    |\n|                     | permitted (No) or permitted but without the replica  |\n|                     | having SSL support enabled (Ignored)                 |\n+---------------------+------------------------------------------------------+\n| Master_SSL_CA_File  | The MASTER_SSL_CA option of the CHANGE MASTER TO     |\n|                     | statement.                                           |\n+---------------------+------------------------------------------------------+\n| Master_SSL_CA_Path  | The MASTER_SSL_CAPATH option of the CHANGE MASTER    |\n|                     | TO statement.                                        |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Cert     | The MASTER_SSL_CERT option of the CHANGE MASTER TO   |\n|                     | statement.                                           |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Cipher   | The MASTER_SSL_CIPHER option of the CHANGE MASTER    |\n|                     | TO statement.                                        |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Key      | The MASTER_SSL_KEY option of the CHANGE MASTER TO    |\n|                     | statement.                                           |\n+---------------------+------------------------------------------------------+\n| Seconds_Behind_Mast | Difference between the timestamp logged on the       |\n| r                   | master for the event that the replica is currently   |\n|                     | processing, and the current timestamp on the         |\n|                     | replica. Zero if the replica is not currently        |\n|                     | processing an event. With serial replication,        |\n|                     | seconds_behind_master is updated when the SQL        |\n|                     | thread begins executing a transaction. With          |\n|                     | parallel replication, seconds_behind_master is       |\n|                     | updated only after transactions commit. Starting in  |\n|                     | MariaDB 10.3.38, 10.4.28, 10.5.19, 10.6.12, 10.8.7,  |\n|                     | 10.9.5, 10.10.3, and 10.11.2, an exception is drawn  |\n|                     | on the parallel replica to additionally update       |\n|                     | seconds_behind_master when the first transaction     |\n|                     | received after idling is queued to a worker for      |\n|                     | execution, to provide a reliable initial value for   |\n|                     | the duration until a transaction commits.            |\n|                     | Additional behaviors to be aware of are as follows:  |\n|                     | 1) Seconds_Behind_Master will update for ignored     |\n|                     | events, e.g. those skipped due to                    |\n|                     | sql_slave_skip_counter. 2) On the serial replica,    |\n|                     | transactions with prior timestamps can update        |\n|                     | Seconds_Behind_Master such that it can go            |\n|                     | backwards, though this is not true for the parallel  |\n|                     | replica. 3) When configured with MASTER_DELAY, as a  |\n|                     | replicated transaction begins executing (i.e. on a   |\n|                     | serial or post-idle parallel replica),               |\n|                     | Seconds_Behind_Master will update before delaying,   |\n|                     | and while delaying occurs will grow to encompass     |\n|                     | the configured value. 4) There is a known issue,     |\n|                     | tracked by MDEV-17516, such that                     |\n|                     | Seconds_Behind_Master will initially present as 0    |\n|                     | on replica restart until a replicated transaction    |\n|                     | begins executing, even if the last replica session   |\n|                     | was lagging behind when stopped.                     |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Verify_S | The MASTER_SSL_VERIFY_SERVER_CERT option of the      |\n| rver_Cert           | CHANGE MASTER TO statement.                          |\n+---------------------+------------------------------------------------------+\n| Last_IO_Errno       | Error code of the most recent error that caused the  |\n|                     | I/O thread to stop (also recorded in the replica\'s   |\n|                     | error log). 0 means no error. RESET SLAVE or RESET   |\n|                     | MASTER will reset this value.                        |\n+---------------------+------------------------------------------------------+\n| Last_IO_Error       | Error message of the most recent error that caused   |\n|                     | the I/O thread to stop (also recorded in the         |\n|                     | replica\'s error log). An empty string means no       |\n|                     | error. RESET SLAVE or RESET MASTER will reset this   |\n|                     | value.                                               |\n+---------------------+------------------------------------------------------+\n| Last_SQL_Errno      | Error code of the most recent error that caused the  |\n|                     | SQL thread to stop (also recorded in the replica\'s   |\n|                     | error log). 0 means no error. RESET SLAVE or RESET   |\n|                     | MASTER will reset this value.                        |\n+---------------------+------------------------------------------------------+','','https://mariadb.com/kb/en/show-replica-status/');
update help_topic set description = CONCAT(description, '\n| Last_SQL_Error      | Error message of the most recent error that caused   |\n|                     | the SQL thread to stop (also recorded in the         |\n|                     | replica\'s error log). An empty string means no       |\n|                     | error. RESET SLAVE or RESET MASTER will reset this   |\n|                     | value.                                               |\n+---------------------+------------------------------------------------------+\n| Replicate_Ignore_Se | List of server_ids that are currently being ignored  |\n| ver_Ids             | for replication purposes, or an empty string for     |\n|                     | none, as specified in the IGNORE_SERVER_IDS option   |\n|                     | of the CHANGE MASTER TO statement.                   |\n+---------------------+------------------------------------------------------+\n| Master_Server_Id    | The master\'s server_id value.                        |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Crl      | The MASTER_SSL_CRL option of the CHANGE MASTER TO    |\n|                     | statement.                                           |\n+---------------------+------------------------------------------------------+\n| Master_SSL_Crlpath  | The MASTER_SSL_CRLPATH option of the CHANGE MASTER   |\n|                     | TO statement.                                        |\n+---------------------+------------------------------------------------------+\n| Using_Gtid          | Whether or not global transaction ID\'s are being     |\n|                     | used for replication (can be No, Slave_Pos, or       |\n|                     | Current_Pos).                                        |\n+---------------------+------------------------------------------------------+\n| Gtid_IO_Pos         | Current global transaction ID value.                 |\n+---------------------+------------------------------------------------------+\n| Retried_transaction | Number of retried transactions for this connection.  |\n|                     | Returned with SHOW ALL SLAVES STATUS only.           |\n+---------------------+------------------------------------------------------+\n| Max_relay_log_size  | Max relay log size for this connection. Returned     |\n|                     | with SHOW ALL SLAVES STATUS only.                    |\n+---------------------+------------------------------------------------------+\n| Executed_log_entrie | How many log entries the replica has executed.       |\n|                     | Returned with SHOW ALL SLAVES STATUS only.           |\n+---------------------+------------------------------------------------------+\n| Slave_received_hear | How many heartbeats we have got from the master.     |\n| beats               | Returned with SHOW ALL SLAVES STATUS only.           |\n+---------------------+------------------------------------------------------+\n| Slave_heartbeat_per | How often to request a heartbeat packet from the     |\n| od                  | master (in seconds). Returned with SHOW ALL SLAVES   |\n|                     | STATUS only.                                         |\n+---------------------+------------------------------------------------------+\n| Gtid_Slave_Pos      | GTID of the last event group replicated on a         |\n|                     | replica server, for each replication domain, as      |\n|                     | stored in the gtid_slave_pos system variable.        |\n|                     | Returned with SHOW ALL SLAVES STATUS only.           |\n+---------------------+------------------------------------------------------+\n| SQL_Delay           | Value specified by MASTER_DELAY in CHANGE MASTER     |\n|                     | (or 0 if none).                                      |\n+---------------------+------------------------------------------------------+\n| SQL_Remaining_Delay | When the replica is delaying the execution of an     |\n|                     | event due to MASTER_DELAY, this is the number of     |\n|                     | seconds of delay remaining before the event will be  |\n|                     | applied. Otherwise, the value is NULL.               |\n+---------------------+------------------------------------------------------+\n| Slave_SQL_Running_S | The state of the SQL driver threads, same as in      |\n| ate                 | SHOW PROCESSLIST. When the replica is delaying the   |\n|                     | execution of an event due to MASTER_DELAY, this      |\n|                     | field displays: \"Waiting until MASTER_DELAY seconds  |\n|                     | after master executed event\".                        |\n+---------------------+------------------------------------------------------+\n| Slave_DDL_Groups    | This status variable counts the occurrence of DDL    |\n|                     | statements.  This is a replica-side counter for      |\n|                     | optimistic parallel replication.                     |\n+---------------------+------------------------------------------------------+\n| Slave_Non_Transacti | This status variable counts the occurrence of        |\n| nal_Groups          | non-transactional event groups.  This is a           |\n|                     | replica-side counter for optimistic parallel         |\n|                     | replication.                                         |\n+---------------------+------------------------------------------------------+\n| Slave_Transactional | This status variable counts the occurrence of        |\n| Groups              | transactional event groups.  This is a replica-side  |\n|                     | counter for optimistic parallel replication.         |\n+---------------------+------------------------------------------------------+\n\nSHOW REPLICA STATUS\n-------------------\n\nMariaDB starting with 10.5.1\n----------------------------\nSHOW REPLICA STATUS is an alias for SHOW SLAVE STATUS from MariaDB 10.5.1.\n\nExamples\n--------\n\nIf you issue this statement using the mariadb client, you can use a \\G\nstatement terminator rather than a semicolon to obtain a more readable\nvertical layout.\n\nSHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n       Slave_IO_State: Waiting for master to send event\n         Master_Host: db01.example.com\n         Master_User: replicant\n         Master_Port: 3306\n        Connect_Retry: 60\n       Master_Log_File: mariadb-bin.000010\n     Read_Master_Log_Pos: 548\n       Relay_Log_File: relay-bin.000004\n        Relay_Log_Pos: 837\n    Relay_Master_Log_File: mariadb-bin.000010\n      Slave_IO_Running: Yes\n      Slave_SQL_Running: Yes\n       Replicate_Do_DB:\n     Replicate_Ignore_DB:\n     Replicate_Do_Table:\n   Replicate_Ignore_Table:\n   Replicate_Wild_Do_Table:\n Replicate_Wild_Ignore_Table:\n         Last_Errno: 0\n         Last_Error:\n        Skip_Counter: 0\n     Exec_Master_Log_Pos: 548\n       Relay_Log_Space: 1497\n       Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n     Master_SSL_Allowed: No\n     Master_SSL_CA_File:\n     Master_SSL_CA_Path:\n       Master_SSL_Cert:\n      Master_SSL_Cipher:\n       Master_SSL_Key:\n    Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n        Last_IO_Errno: 0\n        Last_IO_Error:\n       Last_SQL_Errno: 0\n       Last_SQL_Error:\n Replicate_Ignore_Server_Ids:\n      Master_Server_Id: 101\n       Master_SSL_Crl:\n     Master_SSL_Crlpath:\n         Using_Gtid: No\n         Gtid_IO_Pos:\n\nSHOW ALL SLAVES STATUS\\G\n*************************** 1. row ***************************\n       Connection_name:\n       Slave_SQL_State: Slave has read all relay log; waiting for the\nslave I/O thread to update it\n       Slave_IO_State: Waiting for master to send event\n         Master_Host: db01.example.com\n         Master_User: replicant\n         Master_Port: 3306\n        Connect_Retry: 60\n       Master_Log_File: mariadb-bin.000010\n     Read_Master_Log_Pos: 3608\n       Relay_Log_File: relay-bin.000004\n        Relay_Log_Pos: 3897\n    Relay_Master_Log_File: mariadb-bin.000010\n      Slave_IO_Running: Yes\n      Slave_SQL_Running: Yes\n       Replicate_Do_DB:\n     Replicate_Ignore_DB:\n     Replicate_Do_Table:\n   Replicate_Ignore_Table:\n   Replicate_Wild_Do_Table:\n Replicate_Wild_Ignore_Table:\n         Last_Errno: 0\n         Last_Error:\n        Skip_Counter: 0\n     Exec_Master_Log_Pos: 3608\n       Relay_Log_Space: 4557\n       Until_Condition: None\n       Until_Log_File:\n        Until_Log_Pos: 0\n     Master_SSL_Allowed: No\n     Master_SSL_CA_File:\n     Master_SSL_CA_Path:\n       Master_SSL_Cert:\n      Master_SSL_Cipher:\n       Master_SSL_Key:\n    Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n        Last_IO_Errno: 0\n        Last_IO_Error:\n       Last_SQL_Errno: 0\n       Last_SQL_Error:\n Replicate_Ignore_Server_Ids:\n      Master_Server_Id: 101\n       Master_SSL_Crl:\n     Master_SSL_Crlpath:\n         Using_Gtid: No\n         Gtid_IO_Pos:\n    Retried_transactions: 0\n     Max_relay_log_size: 104857600\n    Executed_log_entries: 40\n  Slave_received_heartbeats: 11\n   Slave_heartbeat_period: 1800.000\n       Gtid_Slave_Pos: 0-101-2320\n\nYou can also access some of the variables directly from status variables:\n\nSET @@default_master_connection=\"test\" ;\nshow status like \"%slave%\"\n\nVariable_name   Value\nCom_show_slave_hosts    0\nCom_show_slave_status   0\nCom_start_all_slaves    0\nCom_start_slave 0\nCom_stop_all_slaves     0\nCom_stop_slave  0\nRpl_semi_sync_slave_status      OFF\nSlave_connections       0\nSlave_heartbeat_period  1800.000\nSlave_open_temp_tables  0\nSlave_received_heartbeats       0\nSlave_retried_transactions      0\nSlave_running   OFF\nSlaves_connected        0\nSlaves_running  1\n\nURL: https://mariadb.com/kb/en/show-replica-status/') WHERE help_topic_id = 349;
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (350,26,'SHOW MASTER STATUS','Syntax\n------\n\nSHOW MASTER STATUS\nSHOW BINLOG STATUS -- From MariaDB 10.5.2\n\nDescription\n-----------\n\nProvides status information about the binary log files of the primary.\n\nThis statement requires the SUPER privilege, the REPLICATION_CLIENT privilege,\nor, from MariaDB 10.5.2, the BINLOG MONITOR privilege.\n\nTo see information about the current GTIDs in the binary log, use the\ngtid_binlog_pos variable.\n\nSHOW MASTER STATUS was renamed to SHOW BINLOG STATUS in MariaDB 10.5.2, but\nthe old name remains an alias for compatibility purposes.\n\nExample\n-------\n\nSHOW MASTER STATUS;\n+--------------------+----------+--------------+------------------+\n| File               | Position | Binlog_Do_DB | Binlog_Ignore_DB |\n+--------------------+----------+--------------+------------------+\n| mariadb-bin.000016 |      475 |              |                  |\n+--------------------+----------+--------------+------------------+\nSELECT @@global.gtid_binlog_pos;\n+--------------------------+\n| @@global.gtid_binlog_pos |\n+--------------------------+\n| 0-1-2                    |\n+--------------------------+\n\nURL: https://mariadb.com/kb/en/show-binlog-status/','','https://mariadb.com/kb/en/show-binlog-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (351,26,'SHOW SLAVE HOSTS','Syntax\n------\n\nSHOW SLAVE HOSTS\nSHOW REPLICA HOSTS -- from MariaDB 10.5.1\n\nDescription\n-----------\n\nThis command is run on the primary and displays a list of replicas that are\ncurrently registered with it. Only replicas started with the\n--report-host=host_name option are visible in this list.\n\nThe output looks like this:\n\nSHOW SLAVE HOSTS;\n+------------+-----------+------+-----------+\n| Server_id  | Host      | Port | Master_id |\n+------------+-----------+------+-----------+\n|  192168010 | iconnect2 | 3306 | 192168011 |\n| 1921680101 | athena    | 3306 | 192168011 |\n+------------+-----------+------+-----------+\n\n* Server_id: The unique server ID of the replica server, as configured in the\nserver\'s option file, or on the command line with --server-id=value.\n* Host: The host name of the replica server, as configured in the server\'s\noption file, or on the command line with --report-host=host_name. Note that\nthis can differ from the machine name as configured in the operating system.\n* Port: The port the replica server is listening on.\n* Master_id: The unique server ID of the primary server that the replica\nserver is replicating from.\n\nSome MariaDB and MySQL versions report another variable, rpl_recovery_rank.\nThis variable was never used, and was eventually removed in MariaDB 10.1.2 .\n\nRequires the REPLICATION MASTER ADMIN privilege (>= MariaDB 10.5.2) or the\nREPLICATION SLAVE privilege (<= MariaDB 10.5.1).\n\nSHOW REPLICA HOSTS\n------------------\n\nMariaDB starting with 10.5.1\n----------------------------\nSHOW REPLICA HOSTS is an alias for SHOW SLAVE HOSTS from MariaDB 10.5.1.\n\nURL: https://mariadb.com/kb/en/show-replica-hosts/','','https://mariadb.com/kb/en/show-replica-hosts/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (352,26,'SHOW PLUGINS','Syntax\n------\n\nSHOW PLUGINS;\n\nDescription\n-----------\n\nSHOW PLUGINS displays information about installed plugins. The Library column\nindicates the plugin library - if it is NULL, the plugin is built-in and\ncannot be uninstalled.\n\nThe PLUGINS table in the information_schema database contains more detailed\ninformation.\n\nFor specific information about storage engines (a particular type of plugin),\nsee the information_schema.ENGINES table and the SHOW ENGINES statement.\n\nExamples\n--------\n\nSHOW PLUGINS;\n+----------------------------+----------+--------------------+-------------+---\n-----+\n| Name                       | Status   | Type               | Library     |\nLicense |\n+----------------------------+----------+--------------------+-------------+---\n-----+\n| binlog                     | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| mysql_native_password      | ACTIVE   | AUTHENTICATION     | NULL        |\nGPL     |\n| mysql_old_password         | ACTIVE   | AUTHENTICATION     | NULL        |\nGPL     |\n| MRG_MyISAM                 | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| MyISAM                     | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| CSV                        | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| MEMORY                     | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| FEDERATED                  | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| PERFORMANCE_SCHEMA         | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| Aria                       | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| InnoDB                     | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| INNODB_TRX                 | ACTIVE   | INFORMATION SCHEMA | NULL        |\nGPL     |\n...\n| INNODB_SYS_FOREIGN         | ACTIVE   | INFORMATION SCHEMA | NULL        |\nGPL     |\n| INNODB_SYS_FOREIGN_COLS    | ACTIVE   | INFORMATION SCHEMA | NULL        |\nGPL     |\n| SPHINX                     | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| ARCHIVE                    | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| BLACKHOLE                  | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| FEEDBACK                   | DISABLED | INFORMATION SCHEMA | NULL        |\nGPL     |\n| partition                  | ACTIVE   | STORAGE ENGINE     | NULL        |\nGPL     |\n| pam                        | ACTIVE   | AUTHENTICATION     | auth_pam.so |\nGPL     |\n+----------------------------+----------+--------------------+-------------+---\n-----+\n\nURL: https://mariadb.com/kb/en/show-plugins/','','https://mariadb.com/kb/en/show-plugins/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (353,26,'SHOW PLUGINS SONAME','Syntax\n------\n\nSHOW PLUGINS SONAME { library | LIKE \'pattern\' | WHERE expr };\n\nDescription\n-----------\n\nSHOW PLUGINS SONAME displays information about compiled-in and all server\nplugins in the plugin_dir directory, including plugins that haven\'t been\ninstalled.\n\nExamples\n--------\n\nSHOW PLUGINS SONAME \'ha_example.so\';\n+----------+---------------+----------------+---------------+---------+\n| Name     | Status        | Type           | Library       | License |\n+----------+---------------+----------------+---------------+---------+\n| EXAMPLE  | NOT INSTALLED | STORAGE ENGINE | ha_example.so | GPL     |\n| UNUSABLE | NOT INSTALLED | DAEMON         | ha_example.so | GPL     |\n+----------+---------------+----------------+---------------+---------+\n\nThere is also a corresponding information_schema table, called ALL_PLUGINS,\nwhich contains more complete information.\n\nURL: https://mariadb.com/kb/en/show-plugins-soname/','','https://mariadb.com/kb/en/show-plugins-soname/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (354,26,'SET','Syntax\n------\n\nSET variable_assignment [, variable_assignment] ...\n\nvariable_assignment:\n   user_var_name = expr\n  | [GLOBAL | SESSION] system_var_name = expr\n  | [@@global. | @@session. | @@]system_var_name = expr\n\nOne can also set a user variable in any expression with this syntax:\n\nuser_var_name:= expr\n\nDescription\n-----------\n\nThe SET statement assigns values to different types of variables that affect\nthe operation of the server or your client. Older versions of MySQL employed\nSET OPTION, but this syntax was deprecated in favor of SET without OPTION, and\nwas removed in MariaDB 10.0.\n\nChanging a system variable by using the SET statement does not make the change\npermanently. To do so, the change must be made in a configuration file.\n\nFor setting variables on a per-query basis, see SET STATEMENT.\n\nSee SHOW VARIABLES for documentation on viewing server system variables.\n\nSee Server System Variables for a list of all the system variables.\n\nGLOBAL / SESSION\n----------------\n\nWhen setting a system variable, the scope can be specified as either GLOBAL or\nSESSION.\n\nA global variable change affects all new sessions. It does not affect any\ncurrently open sessions, including the one that made the change.\n\nA session variable change affects the current session only.\n\nIf the variable has a session value, not specifying either GLOBAL or SESSION\nwill be the same as specifying SESSION. If the variable only has a global\nvalue, not specifying GLOBAL or SESSION will apply to the change to the global\nvalue.\n\nDEFAULT\n-------\n\nSetting a global variable to DEFAULT will restore it to the server default,\nand setting a session variable to DEFAULT will restore it to the current\nglobal value.\n\nExamples\n--------\n\n* innodb_sync_spin_loops is a global variable.\n* skip_parallel_replication is a session variable.\n* max_error_count is both global and session.\n\nSELECT VARIABLE_NAME, SESSION_VALUE, GLOBAL_VALUE FROM\n INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE \n VARIABLE_NAME IN (\'max_error_count\', \'skip_parallel_replication\',\n\'innodb_sync_spin_loops\');\n+---------------------------+---------------+--------------+\n| VARIABLE_NAME             | SESSION_VALUE | GLOBAL_VALUE |\n+---------------------------+---------------+--------------+\n| MAX_ERROR_COUNT           | 64            | 64           |\n| SKIP_PARALLEL_REPLICATION | OFF           | NULL         |\n| INNODB_SYNC_SPIN_LOOPS    | NULL          | 30           |\n+---------------------------+---------------+--------------+\n\nSetting the session values:\n\nSET max_error_count=128;Query OK, 0 rows affected (0.000 sec)\n\nSET skip_parallel_replication=ON;Query OK, 0 rows affected (0.000 sec)\n\nSET innodb_sync_spin_loops=60;\nERROR 1229 (HY000): Variable \'innodb_sync_spin_loops\' is a GLOBAL variable \n and should be set with SET GLOBAL\n\nSELECT VARIABLE_NAME, SESSION_VALUE, GLOBAL_VALUE FROM\n INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE \n VARIABLE_NAME IN (\'max_error_count\', \'skip_parallel_replication\',\n\'innodb_sync_spin_loops\');\n+---------------------------+---------------+--------------+\n| VARIABLE_NAME             | SESSION_VALUE | GLOBAL_VALUE |\n+---------------------------+---------------+--------------+\n| MAX_ERROR_COUNT           | 128           | 64           |\n| SKIP_PARALLEL_REPLICATION | ON            | NULL         |\n| INNODB_SYNC_SPIN_LOOPS    | NULL          | 30           |\n+---------------------------+---------------+--------------+\n\nSetting the global values:\n\nSET GLOBAL max_error_count=256;\n\nSET GLOBAL skip_parallel_replication=ON;\nERROR 1228 (HY000): Variable \'skip_parallel_replication\' is a SESSION variable \n and can\'t be used with SET GLOBAL\n\nSET GLOBAL innodb_sync_spin_loops=120;\n\nSELECT VARIABLE_NAME, SESSION_VALUE, GLOBAL_VALUE FROM\n INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE \n VARIABLE_NAME IN (\'max_error_count\', \'skip_parallel_replication\',\n\'innodb_sync_spin_loops\');\n+---------------------------+---------------+--------------+\n| VARIABLE_NAME             | SESSION_VALUE | GLOBAL_VALUE |\n+---------------------------+---------------+--------------+\n| MAX_ERROR_COUNT           | 128           | 256          |\n| SKIP_PARALLEL_REPLICATION | ON            | NULL         |\n| INNODB_SYNC_SPIN_LOOPS    | NULL          | 120          |\n+---------------------------+---------------+--------------+\n\nSHOW VARIABLES will by default return the session value unless the variable is\nglobal only.\n\nSHOW VARIABLES LIKE \'max_error_count\';\n+-----------------+-------+\n| Variable_name   | Value |\n+-----------------+-------+\n| max_error_count | 128   |\n+-----------------+-------+\n\nSHOW VARIABLES LIKE \'skip_parallel_replication\';\n+---------------------------+-------+\n| Variable_name             | Value |\n+---------------------------+-------+\n| skip_parallel_replication | ON    |\n+---------------------------+-------+\n\nSHOW VARIABLES LIKE \'innodb_sync_spin_loops\';\n+------------------------+-------+\n| Variable_name          | Value |\n+------------------------+-------+\n| innodb_sync_spin_loops | 120   |\n+------------------------+-------+\n\nUsing the inplace syntax:\n\nSELECT (@a:=1);\n+---------+\n| (@a:=1) |\n+---------+\n|       1 |\n+---------+\n\nSELECT @a;\n+------+\n| @a   |\n+------+\n|    1 |\n+------+\n\nURL: https://mariadb.com/kb/en/set/','','https://mariadb.com/kb/en/set/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (355,26,'SET CHARACTER SET','Syntax\n------\n\nSET {CHARACTER SET | CHARSET}\n  {charset_name | DEFAULT}\n\nDescription\n-----------\n\nSets the character_set_client and character_set_results session system\nvariables to the specified character set and collation_connection to the value\nof collation_database, which implicitly sets character_set_connection to the\nvalue of character_set_database.\n\nThis maps all strings sent between the current client and the server with the\ngiven mapping.\n\nExample\n-------\n\nSHOW VARIABLES LIKE \'character_set\\_%\';\n+--------------------------+--------+\n| Variable_name            | Value  |\n+--------------------------+--------+\n| character_set_client     | utf8   |\n| character_set_connection | utf8   |\n| character_set_database   | latin1 |\n| character_set_filesystem | binary |\n| character_set_results    | utf8   |\n| character_set_server     | latin1 |\n| character_set_system     | utf8   |\n+--------------------------+--------+\n\nSHOW VARIABLES LIKE \'collation%\';\n+----------------------+-------------------+\n| Variable_name        | Value             |\n+----------------------+-------------------+\n| collation_connection | utf8_general_ci   |\n| collation_database   | latin1_swedish_ci |\n| collation_server     | latin1_swedish_ci |\n+----------------------+-------------------+\n\nSET CHARACTER SET utf8mb4;\n\nSHOW VARIABLES LIKE \'character_set\\_%\';\n+--------------------------+---------+\n| Variable_name            | Value   |\n+--------------------------+---------+\n| character_set_client     | utf8mb4 |\n| character_set_connection | latin1  |\n| character_set_database   | latin1  |\n| character_set_filesystem | binary  |\n| character_set_results    | utf8mb4 |\n| character_set_server     | latin1  |\n| character_set_system     | utf8    |\n+--------------------------+---------+\n\nSHOW VARIABLES LIKE \'collation%\';\n+----------------------+-------------------+\n| Variable_name        | Value             |\n+----------------------+-------------------+\n| collation_connection | latin1_swedish_ci |\n| collation_database   | latin1_swedish_ci |\n| collation_server     | latin1_swedish_ci |\n+----------------------+-------------------+\n\nURL: https://mariadb.com/kb/en/set-character-set/','','https://mariadb.com/kb/en/set-character-set/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (356,26,'SET NAMES','Syntax\n------\n\nSET NAMES {\'charset_name\'\n  [COLLATE \'collation_name\'] | DEFAULT}\n\nDescription\n-----------\n\nSets the character_set_client, character_set_connection, character_set_results\nand, implicitly, the collation_connection session system variables to the\nspecified character set and collation.\n\nThis determines which character set the client will use to send statements to\nthe server, and the server will use for sending results back to the client.\n\nucs2, utf16, utf16le and utf32 are not valid character sets for SET NAMES, as\nthey cannot be used as client character sets.\n\nThe collation clause is optional. If not defined (or if DEFAULT is specified),\nthe default collation for the character set will be used.\n\nQuotes are optional for the character set or collation clauses.\n\nExamples\n--------\n\nSELECT VARIABLE_NAME, SESSION_VALUE \n FROM INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE\n VARIABLE_NAME LIKE \'character_set_c%\' OR\n VARIABLE_NAME LIKE \'character_set_re%\' OR\n VARIABLE_NAME LIKE \'collation_c%\';\n+--------------------------+-----------------+\n| VARIABLE_NAME            | SESSION_VALUE   |\n+--------------------------+-----------------+\n| CHARACTER_SET_RESULTS    | utf8            |\n| CHARACTER_SET_CONNECTION | utf8            |\n| CHARACTER_SET_CLIENT     | utf8            |\n| COLLATION_CONNECTION     | utf8_general_ci |\n+--------------------------+-----------------+\n\nSET NAMES big5;\n\nSELECT VARIABLE_NAME, SESSION_VALUE \n FROM INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE\n VARIABLE_NAME LIKE \'character_set_c%\' OR\n VARIABLE_NAME LIKE \'character_set_re%\' OR\n VARIABLE_NAME LIKE \'collation_c%\';\n+--------------------------+-----------------+\n| VARIABLE_NAME            | SESSION_VALUE   |\n+--------------------------+-----------------+\n| CHARACTER_SET_RESULTS    | big5            |\n| CHARACTER_SET_CONNECTION | big5            |\n| CHARACTER_SET_CLIENT     | big5            |\n| COLLATION_CONNECTION     | big5_chinese_ci |\n+--------------------------+-----------------+\n\nSET NAMES \'latin1\' COLLATE \'latin1_bin\';\n\nSELECT VARIABLE_NAME, SESSION_VALUE \n FROM INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE\n VARIABLE_NAME LIKE \'character_set_c%\' OR\n VARIABLE_NAME LIKE \'character_set_re%\' OR\n VARIABLE_NAME LIKE \'collation_c%\';\n+--------------------------+---------------+\n| VARIABLE_NAME            | SESSION_VALUE |\n+--------------------------+---------------+\n| CHARACTER_SET_RESULTS    | latin1        |\n| CHARACTER_SET_CONNECTION | latin1        |\n| CHARACTER_SET_CLIENT     | latin1        |\n| COLLATION_CONNECTION     | latin1_bin    |\n+--------------------------+---------------+\n\nSET NAMES DEFAULT;\n\nSELECT VARIABLE_NAME, SESSION_VALUE \n FROM INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE\n VARIABLE_NAME LIKE \'character_set_c%\' OR\n VARIABLE_NAME LIKE \'character_set_re%\' OR\n VARIABLE_NAME LIKE \'collation_c%\';\n+--------------------------+-------------------+\n| VARIABLE_NAME            | SESSION_VALUE     |\n+--------------------------+-------------------+\n| CHARACTER_SET_RESULTS    | latin1            |\n| CHARACTER_SET_CONNECTION | latin1            |\n| CHARACTER_SET_CLIENT     | latin1            |\n| COLLATION_CONNECTION     | latin1_swedish_ci |\n+--------------------------+-------------------+\n\nURL: https://mariadb.com/kb/en/set-names/','','https://mariadb.com/kb/en/set-names/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (357,26,'SET SQL_LOG_BIN','Syntax\n------\n\nSET [SESSION] sql_log_bin = {0|1}\n\nDescription\n-----------\n\nSets the sql_log_bin system variable, which disables or enables binary logging\nfor the current connection, if the client has the SUPER privilege. The\nstatement is refused with an error if the client does not have that privilege.\n\nBefore MariaDB 5.5 and before MySQL 5.6 one could also set sql_log_bin as a\nglobal variable. This was disabled as this was too dangerous as it could\ndamage replication.\n\nURL: https://mariadb.com/kb/en/set-sql_log_bin/','','https://mariadb.com/kb/en/set-sql_log_bin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (358,26,'SET STATEMENT','MariaDB starting with 10.1.2\n----------------------------\nPer-query variables were introduced in MariaDB 10.1.2\n\nSET STATEMENT can be used to set the value of a system variable for the\nduration of the statement. It is also possible to set multiple variables.\n\nSyntax\n------\n\nSET STATEMENT var1=value1 [, var2=value2, ...] \n FOR <statement>\n\nwhere varN is a system variable (list of allowed variables is provided below),\nand valueN is a constant literal.\n\nDescription\n-----------\n\nSET STATEMENT var1=value1 FOR stmt\n\nis roughly equivalent to\n\nSET @save_value=@@var1;\nSET SESSION var1=value1;\nstmt;\nSET SESSION var1=@save_value;\n\nThe server parses the whole statement before executing it, so any variables\nset in this fashion that affect the parser may not have the expected effect.\nExamples include the charset variables, sql_mode=ansi_quotes, etc.\n\nExamples\n--------\n\nOne can limit statement execution time max_statement_time:\n\nSET STATEMENT max_statement_time=1000 FOR SELECT ... ;\n\nOne can switch on/off individual optimizations:\n\nSET STATEMENT optimizer_switch=\'materialization=off\' FOR SELECT ....;\n\nIt is possible to enable MRR/BKA for a query:\n\nSET STATEMENT  join_cache_level=6, optimizer_switch=\'mrr=on\'  FOR SELECT ...\n\nNote that it makes no sense to try to set a session variable inside a SET\nSTATEMENT:\n\n#USELESS STATEMENT\nSET STATEMENT sort_buffer_size = 100000 for SET SESSION sort_buffer_size =\n200000;\n\nFor the above, after setting sort_buffer_size to 200000 it will be reset to\nits original state (the state before the SET STATEMENT started) after the\nstatement execution.\n\nLimitations\n-----------\n\nThere are a number of variables that cannot be set on per-query basis. These\ninclude:\n\n* autocommit\n* character_set_client\n* character_set_connection\n* character_set_filesystem\n* collation_connection\n* default_master_connection\n* debug_sync\n* interactive_timeout\n* gtid_domain_id\n* last_insert_id\n* log_slow_filter\n* log_slow_rate_limit\n* log_slow_verbosity\n* long_query_time\n* min_examined_row_limit\n* profiling\n* profiling_history_size\n* query_cache_type\n* rand_seed1\n* rand_seed2\n* skip_replication\n* slow_query_log\n* sql_log_off\n* tx_isolation\n* wait_timeout\n\nSource\n------\n\n* The feature was originally implemented as a Google Summer of Code 2009\nproject by Joseph Lukas. \n* Percona Server 5.6 included it as Per-query variable statement\n* MariaDB ported the patch and fixed many bugs. The task in MariaDB Jira is\nMDEV-5231.\n\nURL: https://mariadb.com/kb/en/set-statement/','','https://mariadb.com/kb/en/set-statement/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (359,26,'SET Variable','Syntax\n------\n\nSET var_name = expr [, var_name = expr] ...\n\nDescription\n-----------\n\nThe SET statement in stored programs is an extended version of the general SET\nstatement. Referenced variables may be ones declared inside a stored program,\nglobal system variables, or user-defined variables.\n\nThe SET statement in stored programs is implemented as part of the\npre-existing SET syntax. This allows an extended syntax of SET a=x, b=y, ...\nwhere different variable types (locally declared variables, global and session\nserver variables, user-defined variables) can be mixed. This also allows\ncombinations of local variables and some options that make sense only for\nsystem variables; in that case, the options are recognized but ignored.\n\nSET can be used with both local variables and user-defined variables.\n\nWhen setting several variables using the columns returned by a query, SELECT\nINTO should be preferred.\n\nTo set many variables to the same value, the LAST_VALUE( ) function can be\nused.\n\nBelow is an example of how a user-defined variable may be set:\n\nSET @x = 1;\n\nURL: https://mariadb.com/kb/en/set-variable/','','https://mariadb.com/kb/en/set-variable/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (360,26,'About SHOW','SHOW has many forms that provide information about databases, tables, columns,\nor status information about the server. These include:\n\n* SHOW AUTHORS\n* SHOW CHARACTER SET [like_or_where]\n* SHOW COLLATION [like_or_where]\n* SHOW [FULL] COLUMNS FROM tbl_name [FROM db_name] [like_or_where]\n* SHOW CONTRIBUTORS\n* SHOW CREATE DATABASE db_name\n* SHOW CREATE EVENT event_name\n* SHOW CREATE PACKAGE package_name\n* SHOW CREATE PACKAGE BODY package_name\n* SHOW CREATE PROCEDURE proc_name\n* SHOW CREATE TABLE tbl_name\n* SHOW CREATE TRIGGER trigger_name\n* SHOW CREATE VIEW view_name\n* SHOW DATABASES [like_or_where]\n* SHOW ENGINE engine_name {STATUS | MUTEX}\n* SHOW [STORAGE] ENGINES\n* SHOW ERRORS [LIMIT [offset,] row_count]\n* SHOW [FULL] EVENTS\n* SHOW FUNCTION CODE func_name\n* SHOW FUNCTION STATUS [like_or_where]\n* SHOW GRANTS FOR user\n* SHOW INDEX FROM tbl_name [FROM db_name]\n* SHOW INNODB STATUS\n* SHOW OPEN TABLES [FROM db_name] [like_or_where]\n* SHOW PLUGINS\n* SHOW PROCEDURE CODE proc_name\n* SHOW PROCEDURE STATUS [like_or_where]\n* SHOW PRIVILEGES\n* SHOW [FULL] PROCESSLIST\n* SHOW PROFILE [types] [FOR QUERY n] [OFFSET n] [LIMIT n]\n* SHOW PROFILES\n* SHOW [GLOBAL | SESSION] STATUS [like_or_where]\n* SHOW TABLE STATUS [FROM db_name] [like_or_where]\n* SHOW TABLES [FROM db_name] [like_or_where]\n* SHOW TRIGGERS [FROM db_name] [like_or_where]\n* SHOW [GLOBAL | SESSION] VARIABLES [like_or_where]\n* SHOW WARNINGS [LIMIT [offset,] row_count]\n\nlike_or_where:\n  LIKE \'pattern\'\n | WHERE expr\n\nIf the syntax for a given SHOW statement includes a LIKE \'pattern\' part,\n\'pattern\' is a string that can contain the SQL \"%\" and \"_\" wildcard\ncharacters. The pattern is useful for restricting statement output to matching\nvalues.\n\nSeveral SHOW statements also accept a WHERE clause that provides more\nflexibility in specifying which rows to display. See Extended Show.\n\nURL: https://mariadb.com/kb/en/about-show/','','https://mariadb.com/kb/en/about-show/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (361,26,'Extended Show','The following SHOW statements can be extended by using a WHERE clause and a\nLIKE clause to refine the results:\n\n* SHOW CHARACTER SET\n* SHOW COLLATION\n* SHOW COLUMNS\n* SHOW DATABASES\n* SHOW FUNCTION STATUS\n* SHOW INDEX\n* SHOW OPEN TABLES\n* SHOW PACKAGE STATUS\n* SHOW PACKAGE BODY STATUS\n* SHOW INDEX\n* SHOW PROCEDURE STATUS\n* SHOW STATUS\n* SHOW TABLE STATUS\n* SHOW TABLES\n* SHOW TRIGGERS\n* SHOW VARIABLES\n\nAs with a regular SELECT, the WHERE clause can be used for the specific\ncolumns returned, and the LIKE clause with the regular wildcards.\n\nExamples\n--------\n\nSHOW TABLES;\n+----------------------+\n| Tables_in_test       |\n+----------------------+\n| animal_count         |\n| animals              |\n| are_the_mooses_loose |\n| aria_test2           |\n| t1                   |\n| view1                |\n+----------------------+\n\nShowing the tables beginning with a only.\n\nSHOW TABLES WHERE Tables_in_test LIKE \'a%\';\n+----------------------+\n| Tables_in_test       |\n+----------------------+\n| animal_count         |\n| animals              |\n| are_the_mooses_loose |\n| aria_test2           |\n+----------------------+\n\nVariables whose name starts with aria and with a valued of greater than 8192:\n\nSHOW VARIABLES WHERE Variable_name LIKE \'aria%\' AND Value >8192;\n+------------------------------+---------------------+\n| Variable_name                | Value               |\n+------------------------------+---------------------+\n| aria_checkpoint_log_activity | 1048576             |\n| aria_log_file_size           | 1073741824          |\n| aria_max_sort_file_size      | 9223372036853727232 |\n| aria_pagecache_buffer_size   | 134217728           |\n| aria_sort_buffer_size        | 134217728           |\n+------------------------------+---------------------+\n\nShortcut, just returning variables whose name begins with aria.\n\nSHOW VARIABLES LIKE \'aria%\';\n+------------------------------------------+---------------------+\n| Variable_name                            | Value               |\n+------------------------------------------+---------------------+\n| aria_block_size                          | 8192                |\n| aria_checkpoint_interval                 | 30                  |\n| aria_checkpoint_log_activity             | 1048576             |\n| aria_force_start_after_recovery_failures | 0                   |\n| aria_group_commit                        | none                |\n| aria_group_commit_interval               | 0                   |\n| aria_log_file_size                       | 1073741824          |\n| aria_log_purge_type                      | immediate           |\n| aria_max_sort_file_size                  | 9223372036853727232 |\n| aria_page_checksum                       | ON                  |\n| aria_pagecache_age_threshold             | 300                 |\n| aria_pagecache_buffer_size               | 134217728           |\n| aria_pagecache_division_limit            | 100                 |\n| aria_recover                             | NORMAL              |\n| aria_repair_threads                      | 1                   |\n| aria_sort_buffer_size                    | 134217728           |\n| aria_stats_method                        | nulls_unequal       |\n| aria_sync_log_dir                        | NEWFILE             |\n| aria_used_for_temp_tables                | ON                  |\n+------------------------------------------+---------------------+\n\nURL: https://mariadb.com/kb/en/extended-show/','','https://mariadb.com/kb/en/extended-show/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (362,26,'SHOW AUTHORS','Syntax\n------\n\nSHOW AUTHORS\n\nDescription\n-----------\n\nThe SHOW AUTHORS statement displays information about the people who work on\nMariaDB. For each author, it displays Name, Location, and Comment values. All\ncolumns are encoded as latin1.\n\nThese include:\n\n* First the active people in MariaDB are listed.\n* Then the active people in MySQL.\n* Last the people that have contributed to MariaDB/MySQL in the past.\n\nThe order is somewhat related to importance of the contribution given to the\nMariaDB project, but this is not 100% accurate. There is still room for\nimprovement and debate...\n\nExample\n-------\n\nSHOW AUTHORS\\G\n*************************** 1. row ***************************\n  Name: Michael (Monty) Widenius\nLocation: Tusby, Finland\n Comment: Lead developer and main author\n*************************** 2. row ***************************\n  Name: Sergei Golubchik\nLocation: Kerpen, Germany\n Comment: Architect, Full-text search, precision math, plugin framework,\nmerges etc\n*************************** 3. row ***************************\n  Name: Igor Babaev\nLocation: Bellevue, USA\n Comment: Optimizer, keycache, core work\n*************************** 4. row ***************************\n  Name: Sergey Petrunia\nLocation: St. Petersburg, Russia\n Comment: Optimizer\n*************************** 5. row ***************************\n  Name: Oleksandr Byelkin\nLocation: Lugansk, Ukraine\n Comment: Query Cache (4.0), Subqueries (4.1), Views (5.0)\n*************************** 6. row ***************************\n  Name: Timour Katchaounov\nLocation: Sofia , Bulgaria\n Comment: Optimizer\n*************************** 7. row ***************************\n  Name: Kristian Nielsen\nLocation: Copenhagen, Denmark\n Comment: Replication, Async client prototocol, General buildbot stuff\n*************************** 8. row ***************************\n  Name: Alexander (Bar) Barkov\nLocation: Izhevsk, Russia\n Comment: Unicode and character sets\n*************************** 9. row ***************************\n  Name: Alexey Botchkov (Holyfoot)\nLocation: Izhevsk, Russia\n Comment: GIS extensions, embedded server, precision math\n*************************** 10. row ***************************\n  Name: Daniel Bartholomew\nLocation: Raleigh, USA\n Comment: MariaDB documentation, Buildbot, releases\n*************************** 11. row ***************************\n  Name: Colin Charles\nLocation: Selangor, Malesia\n Comment: MariaDB documentation, talks at a LOT of conferences\n*************************** 12. row ***************************\n  Name: Sergey Vojtovich\nLocation: Izhevsk, Russia\n Comment: initial implementation of plugin architecture, maintained native\nstorage engines (MyISAM, MEMORY, ARCHIVE, etc), rewrite of table cache\n*************************** 13. row ***************************\n  Name: Vladislav Vaintroub\nLocation: Mannheim, Germany\n Comment: MariaDB Java connector, new thread pool, Windows optimizations\n*************************** 14. row ***************************\n  Name: Elena Stepanova\nLocation: Sankt Petersburg, Russia\n Comment: QA, test cases\n*************************** 15. row ***************************\n  Name: Georg Richter\nLocation: Heidelberg, Germany\n Comment: New LGPL C connector, PHP connector\n*************************** 16. row ***************************\n  Name: Jan Lindström\nLocation: Ylämylly, Finland\n Comment: Working on InnoDB\n*************************** 17. row ***************************\n  Name: Lixun Peng\nLocation: Hangzhou, China\n Comment: Multi Source replication\n*************************** 18. row ***************************\n  Name: Olivier Bertrand\nLocation: Paris, France\n Comment: CONNECT storage engine\n*************************** 19. row ***************************\n  Name: Kentoku Shiba\nLocation: Tokyo, Japan\n Comment: Spider storage engine, metadata_lock_info Information schema\n*************************** 20. row ***************************\n  Name: Percona\nLocation: CA, USA\n Comment: XtraDB, microslow patches, extensions to slow log\n*************************** 21. row ***************************\n  Name: Vicentiu Ciorbaru\nLocation: Bucharest, Romania\n Comment: Roles\n*************************** 22. row ***************************\n  Name: Sudheera Palihakkara\nLocation: \n Comment: PCRE Regular Expressions\n*************************** 23. row ***************************\n  Name: Pavel Ivanov\nLocation: USA\n Comment: Some patches and bug fixes\n*************************** 24. row ***************************\n  Name: Konstantin Osipov\nLocation: Moscow, Russia\n Comment: Prepared statements (4.1), Cursors (5.0), GET_LOCK (10.0)\n*************************** 25. row ***************************\n  Name: Ian Gilfillan\nLocation: South Africa\n Comment: MariaDB documentation\n*************************** 26. row ***************************\n  Name: Federico Razolli\nLocation: Italy\n Comment: MariaDB documentation Italian translation\n*************************** 27. row ***************************\n  Name: Guilhem Bichot\nLocation: Bordeaux, France\n Comment: Replication (since 4.0)\n*************************** 28. row ***************************\n  Name: Andrei Elkin\nLocation: Espoo, Finland\n Comment: Replication\n*************************** 29. row ***************************\n  Name: Dmitri Lenev\nLocation: Moscow, Russia\n Comment: Time zones support (4.1), Triggers (5.0)\n*************************** 30. row ***************************\n  Name: Marc Alff\nLocation: Denver, CO, USA\n Comment: Signal, Resignal, Performance schema\n*************************** 31. row ***************************\n  Name: Mikael Ronström\nLocation: Stockholm, Sweden\n Comment: NDB Cluster, Partitioning, online alter table\n*************************** 32. row ***************************\n  Name: Ingo Strüwing\nLocation: Berlin, Germany\n Comment: Bug fixing in MyISAM, Merge tables etc\n*************************** 33. row ***************************\n  Name: Marko Mäkelä\nLocation: Helsinki, Finland\n Comment: InnoDB core developer\n...\n\nURL: https://mariadb.com/kb/en/show-authors/','','https://mariadb.com/kb/en/show-authors/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (363,26,'SHOW BINARY LOGS','Syntax\n------\n\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nDescription\n-----------\n\nLists the binary log files on the server. This statement is used as part of\nthe procedure described in PURGE BINARY LOGS, that shows how to determine\nwhich logs can be purged.\n\nThis statement requires the SUPER privilege, the REPLICATION_CLIENT privilege,\nor, from MariaDB 10.5.2, the BINLOG MONITOR privilege.\n\nExamples\n--------\n\nSHOW BINARY LOGS;\n+--------------------+-----------+\n| Log_name           | File_size |\n+--------------------+-----------+\n| mariadb-bin.000001 |     19039 |\n| mariadb-bin.000002 |    717389 |\n| mariadb-bin.000003 |       300 |\n| mariadb-bin.000004 |       333 |\n| mariadb-bin.000005 |       899 |\n| mariadb-bin.000006 |       125 |\n| mariadb-bin.000007 |     18907 |\n| mariadb-bin.000008 |     19530 |\n| mariadb-bin.000009 |       151 |\n| mariadb-bin.000010 |       151 |\n| mariadb-bin.000011 |       125 |\n| mariadb-bin.000012 |       151 |\n| mariadb-bin.000013 |       151 |\n| mariadb-bin.000014 |       125 |\n| mariadb-bin.000015 |       151 |\n| mariadb-bin.000016 |       314 |\n+--------------------+-----------+\n\nURL: https://mariadb.com/kb/en/show-binary-logs/','','https://mariadb.com/kb/en/show-binary-logs/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (364,26,'SHOW BINLOG EVENTS','Syntax\n------\n\nSHOW BINLOG EVENTS\n [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n\nDescription\n-----------\n\nShows the events in the binary log. If you do not specify \'log_name\', the\nfirst binary log is displayed.\n\nRequires the BINLOG MONITOR privilege (>= MariaDB 10.5.2) or the REPLICATION\nSLAVE privilege (<= MariaDB 10.5.1).\n\nExample\n-------\n\nSHOW BINLOG EVENTS IN \'mysql_sandbox10019-bin.000002\';\n+-------------------------------+-----+-------------------+-----------+--------\n----+------------------------------------------------+\n| Log_name                      | Pos | Event_type        | Server_id |\nEnd_log_pos | Info                                           |\n+-------------------------------+-----+-------------------+-----------+--------\n----+------------------------------------------------+\n| mysql_sandbox10019-bin.000002 |   4 | Format_desc       |         1 |       \n 248 | Server ver: 10.0.19-MariaDB-log, Binlog ver: 4 |\n| mysql_sandbox10019-bin.000002 | 248 | Gtid_list         |         1 |       \n 273 | []                                             |\n| mysql_sandbox10019-bin.000002 | 273 | Binlog_checkpoint |         1 |       \n 325 | mysql_sandbox10019-bin.000002                  |\n| mysql_sandbox10019-bin.000002 | 325 | Gtid              |         1 |       \n 363 | GTID 0-1-1                                     |\n| mysql_sandbox10019-bin.000002 | 363 | Query             |         1 |       \n 446 | CREATE DATABASE blog                           |\n| mysql_sandbox10019-bin.000002 | 446 | Gtid              |         1 |       \n 484 | GTID 0-1-2                                     |\n| mysql_sandbox10019-bin.000002 | 484 | Query             |         1 |       \n 571 | use `blog`; CREATE TABLE bb (id INT)           |\n+-------------------------------+-----+-------------------+-----------+--------\n----+------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/show-binlog-events/','','https://mariadb.com/kb/en/show-binlog-events/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (365,26,'SHOW CHARACTER SET','Syntax\n------\n\nSHOW CHARACTER SET\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nThe SHOW CHARACTER SET statement shows all available character sets. The LIKE\nclause, if present on its own, indicates which character set names to match.\nThe WHERE and LIKE clauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW.\n\nThe same information can be queried from the Information Schema CHARACTER_SETS\ntable.\n\nSee Setting Character Sets and Collations for details on specifying the\ncharacter set at the server, database, table and column levels.\n\nExamples\n--------\n\nSHOW CHARACTER SET LIKE \'latin%\';\n+---------+-----------------------------+-------------------+--------+\n| Charset | Description                 | Default collation | Maxlen |\n+---------+-----------------------------+-------------------+--------+\n| latin1  | cp1252 West European        | latin1_swedish_ci |      1 |\n| latin2  | ISO 8859-2 Central European | latin2_general_ci |      1 |\n| latin5  | ISO 8859-9 Turkish          | latin5_turkish_ci |      1 |\n| latin7  | ISO 8859-13 Baltic          | latin7_general_ci |      1 |\n+---------+-----------------------------+-------------------+--------+\n\nSHOW CHARACTER SET WHERE Maxlen LIKE \'2\';\n+---------+---------------------------+-------------------+--------+\n| Charset | Description               | Default collation | Maxlen |\n+---------+---------------------------+-------------------+--------+\n| big5    | Big5 Traditional Chinese  | big5_chinese_ci   |      2 |\n| sjis    | Shift-JIS Japanese        | sjis_japanese_ci  |      2 |\n| euckr   | EUC-KR Korean             | euckr_korean_ci   |      2 |\n| gb2312  | GB2312 Simplified Chinese | gb2312_chinese_ci |      2 |\n| gbk     | GBK Simplified Chinese    | gbk_chinese_ci    |      2 |\n| ucs2    | UCS-2 Unicode             | ucs2_general_ci   |      2 |\n| cp932   | SJIS for Windows Japanese | cp932_japanese_ci |      2 |\n+---------+---------------------------+-------------------+--------+\n\nURL: https://mariadb.com/kb/en/show-character-set/','','https://mariadb.com/kb/en/show-character-set/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (366,26,'SHOW CLIENT_STATISTICS','Syntax\n------\n\nSHOW CLIENT_STATISTICS\n\nDescription\n-----------\n\nThe SHOW CLIENT_STATISTICS statement is part of the User Statistics feature.\nIt was removed as a separate statement in MariaDB 10.1.1, but effectively\nreplaced by the generic SHOW information_schema_table statement. The\ninformation_schema.CLIENT_STATISTICS table holds statistics about client\nconnections.\n\nThe userstat system variable must be set to 1 to activate this feature. See\nthe User Statistics and information_schema.CLIENT_STATISTICS articles for more\ninformation.\n\nExample\n-------\n\nSHOW CLIENT_STATISTICS\\G\n*************************** 1. row ***************************\n        Client: localhost\n  Total_connections: 35\nConcurrent_connections: 0\n    Connected_time: 708\n      Busy_time: 2.5557979999999985\n       Cpu_time: 0.04123740000000002\n    Bytes_received: 3883\n      Bytes_sent: 21595\n Binlog_bytes_written: 0\n      Rows_read: 18\n      Rows_sent: 115\n     Rows_deleted: 0\n    Rows_inserted: 0\n     Rows_updated: 0\n   Select_commands: 70\n   Update_commands: 0\n    Other_commands: 0\n Commit_transactions: 1\n Rollback_transactions: 0\n  Denied_connections: 0\n   Lost_connections: 0\n    Access_denied: 0\n    Empty_queries: 35\n\nURL: https://mariadb.com/kb/en/show-client-statistics/','','https://mariadb.com/kb/en/show-client-statistics/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (367,26,'SHOW CONTRIBUTORS','Syntax\n------\n\nSHOW CONTRIBUTORS\n\nDescription\n-----------\n\nThe SHOW CONTRIBUTORS statement displays information about the companies and\npeople who financially contribute to MariaDB. For each contributor, it\ndisplays Name, Location, and Comment values. All columns are encoded as latin1.\n\nIt displays all members and sponsors of the MariaDB Foundation as well as\nother financial contributors.\n\nExample\n-------\n\nSHOW CONTRIBUTORS;\n+---------------------+-------------------------------+------------------------\n------------------------------------+\n| Name                | Location                      | Comment               \n                  |\n+---------------------+-------------------------------+------------------------\n------------------------------------+\n| Alibaba Cloud       | https://www.alibabacloud.com/ | Platinum Sponsor of\nthe MariaDB Foundation                  |\n| Tencent Cloud       | https://cloud.tencent.com     | Platinum Sponsor of\nthe MariaDB Foundation                  |\n| Microsoft           | https://microsoft.com/        | Platinum Sponsor of\nthe MariaDB Foundation                  |\n| MariaDB Corporation | https://mariadb.com           | Founding member,\nPlatinum Sponsor of the MariaDB Foundation |\n| ServiceNow          | https://servicenow.com        | Platinum Sponsor of\nthe MariaDB Foundation                  |\n| Intel               | https://www.intel.com         | Platinum Sponsor of\nthe MariaDB Foundation                  |\n| SIT                 | https://sit.org               | Platinum Sponsor of\nthe MariaDB Foundation                  |\n| Visma               | https://visma.com             | Gold Sponsor of the\nMariaDB Foundation                      |\n| DBS                 | https://dbs.com               | Gold Sponsor of the\nMariaDB Foundation                      |\n| IBM                 | https://www.ibm.com           | Gold Sponsor of the\nMariaDB Foundation                      |\n| Automattic          | https://automattic.com        | Silver Sponsor of the\nMariaDB Foundation                    |\n| Percona             | https://www.percona.com/      | Sponsor of the MariaDB\nFoundation                           |\n| Galera Cluster      | https://galeracluster.com     | Sponsor of the MariaDB\nFoundation                           |\n| Google              | USA                           | Sponsoring encryption,\nparallel replication and GTID        |\n| Facebook            | USA                           | Sponsoring\nnon-blocking API, LIMIT ROWS EXAMINED etc        |\n| Ronald Bradford     | Brisbane, Australia           | EFF contribution for\nUC2006 Auction                         |\n| Sheeri Kritzer      | Boston, Mass. USA             | EFF contribution for\nUC2006 Auction                         |\n| Mark Shuttleworth   | London, UK.                   | EFF contribution for\nUC2006 Auction                         |\n+---------------------+-------------------------------+------------------------\n------------------------------------+\n\nURL: https://mariadb.com/kb/en/show-contributors/','','https://mariadb.com/kb/en/show-contributors/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (368,26,'SHOW CREATE DATABASE','Syntax\n------\n\nSHOW CREATE {DATABASE | SCHEMA} db_name\n\nDescription\n-----------\n\nShows the CREATE DATABASE statement that creates the given database. SHOW\nCREATE SCHEMA is a synonym for SHOW CREATE DATABASE. SHOW CREATE DATABASE\nquotes database names according to the value of the sql_quote_show_create\nserver system variable.\n\nExamples\n--------\n\nSHOW CREATE DATABASE test;\n+----------+-----------------------------------------------------------------+\n| Database | Create Database                                                 |\n+----------+-----------------------------------------------------------------+\n| test     | CREATE DATABASE `test` /*!40100 DEFAULT CHARACTER SET latin1 */ |\n+----------+-----------------------------------------------------------------+\n\nSHOW CREATE SCHEMA test;\n+----------+-----------------------------------------------------------------+\n| Database | Create Database                                                 |\n+----------+-----------------------------------------------------------------+\n| test     | CREATE DATABASE `test` /*!40100 DEFAULT CHARACTER SET latin1 */ |\n+----------+-----------------------------------------------------------------+\n\nWith sql_quote_show_create off:\n\nSHOW CREATE DATABASE test;\n+----------+---------------------------------------------------------------+\n| Database | Create Database                                               |\n+----------+---------------------------------------------------------------+\n| test     | CREATE DATABASE test /*!40100 DEFAULT CHARACTER SET latin1 */ |\n+----------+---------------------------------------------------------------+\n\nWith a comment, from MariaDB 10.5:\n\nSHOW CREATE DATABASE p;\n+----------+-------------------------------------------------------------------\n------------------+\n| Database | Create Database                                                  \n         |\n+----------+-------------------------------------------------------------------\n------------------+\n| p        | CREATE DATABASE `p` /*!40100 DEFAULT CHARACTER SET latin1 */\nCOMMENT \'presentations\' |\n+----------+-------------------------------------------------------------------\n------------------+\n\nURL: https://mariadb.com/kb/en/show-create-database/','','https://mariadb.com/kb/en/show-create-database/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (369,26,'SHOW CREATE EVENT','Syntax\n------\n\nSHOW CREATE EVENT event_name\n\nDescription\n-----------\n\nThis statement displays the CREATE EVENT statement needed to re-create a given\nevent, as well as the SQL_MODE that was used when the trigger has been created\nand the character set used by the connection. To find out which events are\npresent, use SHOW EVENTS.\n\nThe output of this statement is unreliably affected by the\nsql_quote_show_create server system variable - see\nhttp://bugs.mysql.com/bug.php?id=12719\n\nThe information_schema.EVENTS table provides similar, but more complete,\ninformation.\n\nExamples\n--------\n\nSHOW CREATE EVENT test.e_daily\\G\n*************************** 1. row ***************************\n       Event: e_daily\n      sql_mode:\n     time_zone: SYSTEM\n    Create Event: CREATE EVENT `e_daily`\n            ON SCHEDULE EVERY 1 DAY\n            STARTS CURRENT_TIMESTAMP + INTERVAL 6 HOUR\n            ON COMPLETION NOT PRESERVE\n            ENABLE\n            COMMENT \'Saves total number of sessions then\n                clears the table each day\'\n            DO BEGIN\n             INSERT INTO site_activity.totals (time, total)\n              SELECT CURRENT_TIMESTAMP, COUNT(*)\n              FROM site_activity.sessions;\n             DELETE FROM site_activity.sessions;\n            END\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n Database Collation: latin1_swedish_ci\n\nURL: https://mariadb.com/kb/en/show-create-event/','','https://mariadb.com/kb/en/show-create-event/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (370,26,'SHOW CREATE FUNCTION','Syntax\n------\n\nSHOW CREATE FUNCTION func_name\n\nDescription\n-----------\n\nThis statement is similar to SHOW CREATE PROCEDURE but for stored functions.\n\nThe output of this statement is unreliably affected by the\nsql_quote_show_create server system variable - see\nhttp://bugs.mysql.com/bug.php?id=12719\n\nExample\n-------\n\nSHOW CREATE FUNCTION VatCents\\G\n*************************** 1. row ***************************\n      Function: VatCents\n      sql_mode:\n  Create Function: CREATE DEFINER=`root`@`localhost` FUNCTION\n`VatCents`(price DECIMAL(10,2)) RETURNS int(11)\n  DETERMINISTIC\nBEGIN\n DECLARE x INT;\n SET x = price * 114;\n RETURN x;\nEND\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\nURL: https://mariadb.com/kb/en/show-create-function/','','https://mariadb.com/kb/en/show-create-function/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (371,26,'SHOW CREATE PACKAGE','MariaDB starting with 10.3.5\n----------------------------\nOracle-style packages were introduced in MariaDB 10.3.5.\n\nSyntax\n------\n\nSHOW CREATE PACKAGE  [ db_name . ] package_name\n\nDescription\n-----------\n\nThe SHOW CREATE PACKAGE statement can be used when Oracle SQL_MODE is set.\n\nShows the CREATE statement that creates the given package specification.\n\nExamples\n--------\n\nSHOW CREATE PACKAGE employee_tools\\G\n*************************** 1. row ***************************\n      Package: employee_tools\n      sql_mode:\nPIPES_AS_CONCAT,ANSI_QUOTES,IGNORE_SPACE,ORACLE,NO_KEY_OPTIONS,NO_TABLE_OPTIONS\nNO_FIELD_OPTIONS,NO_AUTO_CREATE_USER\n   Create Package: CREATE DEFINER=\"root\"@\"localhost\" PACKAGE\n\"employee_tools\" AS\n FUNCTION getSalary(eid INT) RETURN DECIMAL(10,2);\n PROCEDURE raiseSalary(eid INT, amount DECIMAL(10,2));\n PROCEDURE raiseSalaryStd(eid INT);\n PROCEDURE hire(ename TEXT, esalary DECIMAL(10,2));\nEND\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\nURL: https://mariadb.com/kb/en/show-create-package/','','https://mariadb.com/kb/en/show-create-package/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (372,26,'SHOW CREATE PACKAGE BODY','MariaDB starting with 10.3.5\n----------------------------\nOracle-style packages were introduced in MariaDB 10.3.5.\n\nSyntax\n------\n\nSHOW CREATE PACKAGE BODY  [ db_name . ] package_name\n\nDescription\n-----------\n\nThe SHOW CREATE PACKAGE BODY statement can be used when Oracle SQL_MODE is set.\n\nShows the CREATE statement that creates the given package body (i.e. the\nimplementation).\n\nExamples\n--------\n\nSHOW CREATE PACKAGE BODY employee_tools\\G\n*************************** 1. row ***************************\n    Package body: employee_tools\n      sql_mode:\nPIPES_AS_CONCAT,ANSI_QUOTES,IGNORE_SPACE,ORACLE,NO_KEY_OPTIONS,NO_TABLE_OPTIONS\nNO_FIELD_OPTIONS,NO_AUTO_CREATE_USER\n Create Package Body: CREATE DEFINER=\"root\"@\"localhost\" PACKAGE BODY\n\"employee_tools\" AS\n\nstdRaiseAmount DECIMAL(10,2):=500;\n\nPROCEDURE log (eid INT, ecmnt TEXT) AS\n BEGIN\n  INSERT INTO employee_log (id, cmnt) VALUES (eid, ecmnt);\n END;\n\nPROCEDURE hire(ename TEXT, esalary DECIMAL(10,2)) AS\n  eid INT;\n BEGIN\n  INSERT INTO employee (name, salary) VALUES (ename, esalary);\n  eid:= last_insert_id();\n  log(eid, \'hire \' || ename);\n END;\n\nFUNCTION getSalary(eid INT) RETURN DECIMAL(10,2) AS\n  nSalary DECIMAL(10,2);\n BEGIN\n  SELECT salary INTO nSalary FROM employee WHERE id=eid;\n  log(eid, \'getSalary id=\' || eid || \' salary=\' || nSalary);\n  RETURN nSalary;\n END;\n\nPROCEDURE raiseSalary(eid INT, amount DECIMAL(10,2)) AS\n BEGIN\n  UPDATE employee SET salary=salary+amount WHERE id=eid;\n  log(eid, \'raiseSalary id=\' || eid || \' amount=\' || amount);\n END;\n\nPROCEDURE raiseSalaryStd(eid INT) AS\n BEGIN\n  raiseSalary(eid, stdRaiseAmount);\n  log(eid, \'raiseSalaryStd id=\' || eid);\n END;\n\nBEGIN  \n log(0, \'Session \' || connection_id() || \' \' || current_user || \' started\');\nEND\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\nURL: https://mariadb.com/kb/en/show-create-package-body/','','https://mariadb.com/kb/en/show-create-package-body/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (373,26,'SHOW CREATE PROCEDURE','Syntax\n------\n\nSHOW CREATE PROCEDURE proc_name\n\nDescription\n-----------\n\nThis statement is a MariaDB extension. It returns the exact string that can be\nused to re-create the named stored procedure, as well as the SQL_MODE that was\nused when the trigger has been created and the character set used by the\nconnection.. A similar statement, SHOW CREATE FUNCTION, displays information\nabout stored functions.\n\nBoth statements require that you are the owner of the routine or have the\nSELECT privilege on the mysql.proc table. When neither is true, the statements\ndisplay NULL for the Create Procedure or Create Function field.\n\nWarning Users with SELECT privileges on mysql.proc or USAGE privileges on *.*\ncan view the text of routines, even when they do not have privileges for the\nfunction or procedure itself.\n\nThe output of these statements is unreliably affected by the\nsql_quote_show_create server system variable - see\nhttp://bugs.mysql.com/bug.php?id=12719\n\nExamples\n--------\n\nHere\'s a comparison of the SHOW CREATE PROCEDURE and SHOW CREATE FUNCTION\nstatements.\n\nSHOW CREATE PROCEDURE test.simpleproc\\G\n*************************** 1. row ***************************\n     Procedure: simpleproc\n      sql_mode:\n  Create Procedure: CREATE PROCEDURE `simpleproc`(OUT param1 INT)\n           BEGIN\n           SELECT COUNT(*) INTO param1 FROM t;\n           END\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n Database Collation: latin1_swedish_ci\n\nSHOW CREATE FUNCTION test.hello\\G\n*************************** 1. row ***************************\n      Function: hello\n      sql_mode:\n  Create Function: CREATE FUNCTION `hello`(s CHAR(20))\n           RETURNS CHAR(50)\n           RETURN CONCAT(\'Hello, \',s,\'!\')\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n Database Collation: latin1_swedish_ci\n\nWhen the user issuing the statement does not have privileges on the routine,\nattempting to CALL the procedure raises Error 1370.\n\nCALL test.prc1();\nError 1370 (42000): execute command denieed to user \'test_user\'@\'localhost\'\nfor routine \'test\'.\'prc1\'\n\nIf the user neither has privilege to the routine nor the SELECT privilege on\nmysql.proc table, it raises Error 1305, informing them that the procedure does\nnot exist.\n\nSHOW CREATE TABLES test.prc1\\G\nError 1305 (42000): PROCEDURE prc1 does not exist\n\nURL: https://mariadb.com/kb/en/show-create-procedure/','','https://mariadb.com/kb/en/show-create-procedure/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (374,26,'SHOW CREATE SEQUENCE','Syntax\n------\n\nSHOW CREATE SEQUENCE sequence_name;\n\nDescription\n-----------\n\nShows the CREATE SEQUENCE statement that created the given sequence. The\nstatement requires the SELECT privilege for the table.\n\nExample\n-------\n\nCREATE SEQUENCE s1 START WITH 50;\nSHOW CREATE SEQUENCE s1\\G;\n*************************** 1. row ***************************\n   Table: s1\nCreate Table: CREATE SEQUENCE `s1` start with 50 minvalue 1 maxvalue\n9223372036854775806 \n increment by 1 cache 1000 nocycle ENGINE=InnoDB\n\nNotes\n-----\n\nIf you want to see the underlying table structure used for the SEQUENCE you\ncan use SHOW CREATE TABLE on the SEQUENCE. You can also use SELECT to read the\ncurrent recorded state of the SEQUENCE:\n\nSHOW CREATE TABLE s1\\G\n*************************** 1. row ***************************\n   Table: s1\nCreate Table: CREATE TABLE `s1` (\n `next_not_cached_value` bigint(21) NOT NULL,\n `minimum_value` bigint(21) NOT NULL,\n `maximum_value` bigint(21) NOT NULL,\n `start_value` bigint(21) NOT NULL COMMENT \'start value when sequences is\ncreated \n  or value if RESTART is used\',\n `increment` bigint(21) NOT NULL COMMENT \'increment value\',\n `cache_size` bigint(21) unsigned NOT NULL,\n `cycle_option` tinyint(1) unsigned NOT NULL COMMENT \'0 if no cycles are\nallowed, \n  1 if the sequence should begin a new cycle when maximum_value is passed\',\n `cycle_count` bigint(21) NOT NULL COMMENT \'How many cycles have been done\'\n) ENGINE=InnoDB SEQUENCE=1\n\nSELECT * FROM s1\\G\n*************************** 1. row ***************************\nnext_not_cached_value: 50\n    minimum_value: 1\n    maximum_value: 9223372036854775806\n     start_value: 50\n      increment: 1\n     cache_size: 1000\n    cycle_option: 0\n     cycle_count: 0\n\nURL: https://mariadb.com/kb/en/show-create-sequence/','','https://mariadb.com/kb/en/show-create-sequence/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (375,26,'SHOW CREATE TRIGGER','Syntax\n------\n\nSHOW CREATE TRIGGER trigger_name\n\nDescription\n-----------\n\nThis statement shows a CREATE TRIGGER statement that creates the given\ntrigger, as well as the SQL_MODE that was used when the trigger has been\ncreated and the character set used by the connection.\n\nThe TRIGGER privilege is required on the table the trigger is defined for to\nexecute this statement.\n\nThe output of this statement is unreliably affected by the\nsql_quote_show_create server system variable - see\nhttp://bugs.mysql.com/bug.php?id=12719\n\nExamples\n--------\n\nSHOW CREATE TRIGGER example\\G\n*************************** 1. row ***************************\n       Trigger: example\n       sql_mode:\nONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,STRICT_ALL_TABLES\n,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO\n\nENGINE_SUBSTITUTION\nSQL Original Statement: CREATE DEFINER=`root`@`localhost` TRIGGER example\nBEFORE\n INSERT ON t FOR EACH ROW\nBEGIN\n    SET NEW.c = NEW.c * 2;\nEND\n character_set_client: cp850\n collation_connection: cp850_general_ci\n Database Collation: utf8_general_ci\n Created: 2016-09-29 13:53:34.35\n\nMariaDB starting with 10.2.3\n----------------------------\nThe Created column was added in MySQL 5.7 and MariaDB 10.2.3 as part of\nintroducing multiple trigger events per action.\n\nURL: https://mariadb.com/kb/en/show-create-trigger/','','https://mariadb.com/kb/en/show-create-trigger/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (376,26,'SHOW CREATE VIEW','Syntax\n------\n\nSHOW CREATE VIEW view_name\n\nDescription\n-----------\n\nThis statement shows a CREATE VIEW statement that creates the given view, as\nwell as the character set used by the connection when the view was created.\nThis statement also works with views.\n\nSHOW CREATE VIEW quotes table, column and stored function names according to\nthe value of the sql_quote_show_create server system variable.\n\nExamples\n--------\n\nSHOW CREATE VIEW example\\G\n*************************** 1. row ***************************\n        View: example\n    Create View: CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL\nSECURITY DEFINER VIEW `example` AS (select `t`.`id` AS `id`,`t`.`s` AS `s` from\n`t`)\ncharacter_set_client: cp850\ncollation_connection: cp850_general_ci\n\nWith sql_quote_show_create off:\n\nSHOW CREATE VIEW example\\G\n*************************** 1. row ***************************\n        View: example\n    Create View: CREATE ALGORITHM=UNDEFINED DEFINER=root@localhost SQL\nSECU\nRITY DEFINER VIEW example AS (select t.id AS id,t.s AS s from t)\ncharacter_set_client: cp850\ncollation_connection: cp850_general_ci\n\nGrants\n------\n\nTo be able to see a view, you need to have the SHOW VIEW and the SELECT\nprivilege on the view:\n\nGRANT SHOW VIEW,SELECT ON test_database.test_view TO \'test\'@\'localhost\';\n\nURL: https://mariadb.com/kb/en/show-create-view/','','https://mariadb.com/kb/en/show-create-view/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (377,26,'SHOW DATABASES','Syntax\n------\n\nSHOW {DATABASES | SCHEMAS}\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nSHOW DATABASES lists the databases on the MariaDB server host. SHOW SCHEMAS is\na synonym for SHOW DATABASES. The LIKE clause, if present on its own,\nindicates which database names to match. The WHERE and LIKE clauses can be\ngiven to select rows using more general conditions, as discussed in Extended\nSHOW.\n\nYou see only those databases for which you have some kind of privilege, unless\nyou have the global SHOW DATABASES privilege. You can also get this list using\nthe mariadb-show command.\n\nIf the server was started with the --skip-show-database option, you cannot use\nthis statement at all unless you have the SHOW DATABASES privilege.\n\nThe list of results returned by SHOW DATABASES is based on directories in the\ndata directory, which is how MariaDB implements databases. It\'s possible that\noutput includes directories that do not correspond to actual databases.\n\nThe Information Schema SCHEMATA table also contains database information.\n\nExamples\n--------\n\nSHOW DATABASES;\n+--------------------+\n| Database           |\n+--------------------+\n| information_schema |\n| mysql              |\n| performance_schema |\n| test               |\n+--------------------+\n\nSHOW DATABASES LIKE \'m%\';\n+---------------+\n| Database (m%) |\n+---------------+\n| mysql         |\n+---------------+\n\nURL: https://mariadb.com/kb/en/show-databases/','','https://mariadb.com/kb/en/show-databases/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (378,26,'SHOW ENGINE','Syntax\n------\n\nSHOW ENGINE engine_name {STATUS | MUTEX}\n\nDescription\n-----------\n\nSHOW ENGINE displays operational information about a storage engine. The\nfollowing statements currently are supported:\n\nSHOW ENGINE INNODB STATUS\nSHOW ENGINE INNODB MUTEX\nSHOW ENGINE PERFORMANCE_SCHEMA STATUS\nSHOW ENGINE ROCKSDB STATUS\n\nIf the Sphinx Storage Engine is installed, the following is also supported:\n\nSHOW ENGINE SPHINX STATUS\n\nSee SHOW ENGINE SPHINX STATUS.\n\nOlder (and now removed) synonyms were SHOW INNODB STATUS for SHOW ENGINE\nINNODB STATUS and SHOW MUTEX STATUS for SHOW ENGINE INNODB MUTEX.\n\nSHOW ENGINE INNODB STATUS\n-------------------------\n\nSHOW ENGINE INNODB STATUS displays extensive information from the standard\nInnoDB Monitor about the state of the InnoDB storage engine. See SHOW ENGINE\nINNODB STATUS for more.\n\nSHOW ENGINE INNODB MUTEX\n------------------------\n\nSHOW ENGINE INNODB MUTEX displays InnoDB mutex statistics.\n\nThe statement displays the following output fields:\n\n* Type: Always InnoDB.\n* Name: The source file where the mutex is implemented, and the line number\n in the file where the mutex is created. The line number is dependent on the\nMariaDB version.\n* Status: This field displays the following values if UNIV_DEBUG was defined\nat compilation time (for example, in include/univ.h in the InnoDB part of the\nsource tree). Only the os_waits value is displayed if UNIV_DEBUG was not\ndefined. Without UNIV_DEBUG, the information on which the output is based is\ninsufficient to distinguish regular mutexes and mutexes that protect\n rw-locks (which allow multiple readers or a single writer). Consequently, the\n output may appear to contain multiple rows for the same mutex.\ncount indicates how many times the mutex was requested.\nspin_waits indicates how many times the spinlock had to run.\nspin_rounds indicates the number of spinlock rounds. (spin_rounds divided by\n spin_waits provides the average round count.)\nos_waits indicates the number of operating system waits. This occurs when\n the spinlock did not work (the mutex was not locked during the spinlock and\n it was necessary to yield to the operating system and wait).\nos_yields indicates the number of times a the thread trying to lock a mutex\n gave up its timeslice and yielded to the operating system (on the\n presumption that allowing other threads to run will free the mutex so that\n it can be locked).\nos_wait_times indicates the amount of time (in ms) spent in operating system\n waits, if the timed_mutexes system variable is 1 (ON). If timed_mutexes is 0\n (OFF), timing is disabled, so os_wait_times is 0. timed_mutexes is off by\n default.\n\nInformation from this statement can be used to diagnose system problems. For\nexample, large values of spin_waits and spin_rounds may indicate scalability\nproblems.\n\nThe information_schema.INNODB_MUTEXES table provides similar information.\n\nSHOW ENGINE PERFORMANCE_SCHEMA STATUS\n-------------------------------------\n\nThis statement shows how much memory is used for performance_schema tables and\ninternal buffers.\n\nThe output contains the following fields:\n\n* Type: Always performance_schema.\n* Name: The name of a table, the name of an internal buffer, or the\nperformance_schema word, followed by a dot and an attribute. Internal buffers\nnames are enclosed by parenthesis. performance_schema means that the attribute\nrefers to the whole database (it is a total). \n* Status: The value for the attribute.\n\nThe following attributes are shown, in this order, for all tables:\n\n* row_size: The memory used for an individual record. This value will never\nchange.\n* row_count: The number of rows in the table or buffer. For some tables, this\nvalue depends on a server system variable.\n* memory: For tables and performance_schema, this is the result of row_size *\nrow_count.\n\nFor internal buffers, the attributes are:\n\n* count\n* size\n\nSHOW ENGINE ROCKSDB STATUS\n--------------------------\n\nSee also MyRocks Performance Troubleshooting\n\nURL: https://mariadb.com/kb/en/show-engine/','','https://mariadb.com/kb/en/show-engine/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (379,26,'SHOW ENGINE INNODB STATUS','SHOW ENGINE INNODB STATUS is a specific form of the SHOW ENGINE statement that\ndisplays the InnoDB Monitor output, which is extensive InnoDB information\nwhich can be useful in diagnosing problems.\n\nThe following sections are displayed\n\n* Status: Shows the timestamp, monitor name and the number of seconds, or the\nelapsed time between the current time and the time the InnoDB Monitor output\nwas last displayed. The per-second averages are based upon this time.\n* BACKGROUND THREAD: srv_master_thread lines show work performed by the main\nbackground thread.\n* SEMAPHORES: Threads waiting for a semaphore and stats on how the number of\ntimes threads have needed a spin or a wait on a mutex or rw-lock semaphore. If\nthis number of threads is large, there may be I/O or contention issues.\nReducing the size of the innodb_thread_concurrency system variable may help if\ncontention is related to thread scheduling. Spin rounds per wait shows the\nnumber of spinlock rounds per OS wait for a mutex. \n* LATEST FOREIGN KEY ERROR: Only shown if there has been a foreign key\nconstraint error, it displays the failed statement and information about the\nconstraint and the related tables.\n* LATEST DETECTED DEADLOCK: Only shown if there has been a deadlock, it\ndisplays the transactions involved in the deadlock and the statements being\nexecuted, held and required locked and the transaction rolled back to.\n* TRANSACTIONS: The output of this section can help identify lock contention,\nas well as reasons for the deadlocks.\n* FILE I/O: InnoDB thread information as well as pending I/O operations and\nI/O performance statistics.\n* INSERT BUFFER AND ADAPTIVE HASH INDEX: InnoDB insert buffer (old name for\nthe change buffer) and adaptive hash index status information, including the\nnumber of each type of operation performed, and adaptive hash index\nperformance.\n* LOG: InnoDB log information, including current log sequence number, how far\nthe log has been flushed to disk, the position at which InnoDB last took a\ncheckpoint, pending writes and write performance statistics.\n* BUFFER POOL AND MEMORY: Information on buffer pool pages read and written,\nwhich allows you to see the number of data file I/O operations performed by\nyour queries. See InnoDB Buffer Pool for more. Similar information is also\navailable from the INFORMATION_SCHEMA.INNODB_BUFFER_POOL_STATS table.\n* ROW OPERATIONS:Information about the main thread, including the number and\nperformance rate for each type of row operation.\n\nIf the innodb_status_output_locks system variable is set to 1, extended lock\ninformation will be displayed.\n\nExample output:\n\n=====================================\n2019-09-06 12:44:13 0x7f93cc236700 INNODB MONITOR OUTPUT\n=====================================\nPer second averages calculated from the last 4 seconds\n-----------------\nBACKGROUND THREAD\n-----------------\nsrv_master_thread loops: 2 srv_active, 0 srv_shutdown, 83698 srv_idle\nsrv_master_thread log flush and writes: 83682\n----------\nSEMAPHORES\n----------\nOS WAIT ARRAY INFO: reservation count 15\nOS WAIT ARRAY INFO: signal count 8\nRW-shared spins 0, rounds 20, OS waits 7\nRW-excl spins 0, rounds 0, OS waits 0\nRW-sx spins 0, rounds 0, OS waits 0\nSpin rounds per wait: 20.00 RW-shared, 0.00 RW-excl, 0.00 RW-sx\n------------\nTRANSACTIONS\n------------\nTrx id counter 236\nPurge done for trx\'s n:o < 236 undo n:o < 0 state: running\nHistory list length 22\nLIST OF TRANSACTIONS FOR EACH SESSION:\n---TRANSACTION 421747401994584, not started\n0 lock struct(s), heap size 1136, 0 row lock(s)\n---TRANSACTION 421747401990328, not started\n0 lock struct(s), heap size 1136, 0 row lock(s)\n--------\nFILE I/O\n--------\nI/O thread 0 state: waiting for completed aio requests (insert buffer thread)\nI/O thread 1 state: waiting for completed aio requests (log thread)\nI/O thread 2 state: waiting for completed aio requests (read thread)\nI/O thread 3 state: waiting for completed aio requests (read thread)\nI/O thread 4 state: waiting for completed aio requests (read thread)\nI/O thread 5 state: waiting for completed aio requests (read thread)\nI/O thread 6 state: waiting for completed aio requests (write thread)\nI/O thread 7 state: waiting for completed aio requests (write thread)\nI/O thread 8 state: waiting for completed aio requests (write thread)\nI/O thread 9 state: waiting for completed aio requests (write thread)\nPending normal aio reads: [0, 0, 0, 0] , aio writes: [0, 0, 0, 0] ,\n ibuf aio reads:, log i/o\'s:, sync i/o\'s:\nPending flushes (fsync) log: 0; buffer pool: 0\n286 OS file reads, 171 OS file writes, 22 OS fsyncs\n0.00 reads/s, 0 avg bytes/read, 0.00 writes/s, 0.00 fsyncs/s\n-------------------------------------\nINSERT BUFFER AND ADAPTIVE HASH INDEX\n-------------------------------------\nIbuf: size 1, free list len 0, seg size 2, 0 merges\nmerged operations:\n insert 0, delete mark 0, delete 0\ndiscarded operations:\n insert 0, delete mark 0, delete 0\nHash table size 34679, node heap has 0 buffer(s)\nHash table size 34679, node heap has 0 buffer(s)\nHash table size 34679, node heap has 0 buffer(s)\nHash table size 34679, node heap has 0 buffer(s)\nHash table size 34679, node heap has 0 buffer(s)\nHash table size 34679, node heap has 0 buffer(s)\nHash table size 34679, node heap has 0 buffer(s)\nHash table size 34679, node heap has 0 buffer(s)\n0.00 hash searches/s, 0.00 non-hash searches/s\n---\nLOG\n---\nLog sequence number 445926\nLog flushed up to   445926\nPages flushed up to 445926\nLast checkpoint at  445917\n0 pending log flushes, 0 pending chkp writes\n18 log i/o\'s done, 0.00 log i/o\'s/second\n----------------------\nBUFFER POOL AND MEMORY\n----------------------\nTotal large memory allocated 167772160\nDictionary memory allocated 50768\nBuffer pool size   8012\nFree buffers       7611\nDatabase pages     401\nOld database pages 0\nModified db pages  0\nPercent of dirty pages(LRU & free pages): 0.000\nMax dirty pages percent: 75.000\nPending reads 0\nPending writes: LRU 0, flush list 0, single page 0\nPages made young 0, not young 0\n0.00 youngs/s, 0.00 non-youngs/s\nPages read 264, created 137, written 156\n0.00 reads/s, 0.00 creates/s, 0.00 writes/s\nNo buffer pool page gets since the last printout\nPages read ahead 0.00/s, evicted without access 0.00/s, Random read ahead\n0.00/s\nLRU len: 401, unzip_LRU len: 0\nI/O sum[0]:cur[0], unzip sum[0]:cur[0]\n--------------\nROW OPERATIONS\n--------------\n0 queries inside InnoDB, 0 queries in queue\n0 read views open inside InnoDB\nProcess ID=4267, Main thread ID=140272021272320, state: sleeping\nNumber of rows inserted 1, updated 0, deleted 0, read 1\n0.00 inserts/s, 0.00 updates/s, 0.00 deletes/s, 0.00 reads/s\nNumber of system rows inserted 0, updated 0, deleted 0, read 0\n0.00 inserts/s, 0.00 updates/s, 0.00 deletes/s, 0.00 reads/s\n----------------------------\nEND OF INNODB MONITOR OUTPUT\n============================\n\nURL: https://mariadb.com/kb/en/show-engine-innodb-status/','','https://mariadb.com/kb/en/show-engine-innodb-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (380,26,'SHOW ENGINES','Syntax\n------\n\nSHOW [STORAGE] ENGINES\n\nDescription\n-----------\n\nSHOW ENGINES displays status information about the server\'s storage engines.\nThis is particularly useful for checking whether a storage engine is\nsupported, or to see what the default engine is. SHOW TABLE TYPES is a\ndeprecated synonym.\n\nThe information_schema.ENGINES table provides the same information.\n\nSince storage engines are plugins, different information about them is also\nshown in the information_schema.PLUGINS table and by the SHOW PLUGINS\nstatement.\n\nNote that both MySQL\'s InnoDB and Percona\'s XtraDB replacement are labeled as\nInnoDB. However, if XtraDB is in use, it will be specified in the COMMENT\nfield. See XtraDB and InnoDB. The same applies to FederatedX.\n\nThe output consists of the following columns:\n\n* Engine indicates the engine\'s name.\n* Support indicates whether the engine is installed, and whether it is the\ndefault engine for the current session.\n* Comment is a brief description.\n* Transactions, XA and Savepoints indicate whether transactions, XA\ntransactions and transaction savepoints are supported by the engine.\n\nExamples\n--------\n\nSHOW ENGINES\\G\n*************************** 1. row ***************************\n   Engine: InnoDB\n  Support: DEFAULT\n  Comment: Supports transactions, row-level locking, and foreign keys\nTransactions: YES\n     XA: YES\n Savepoints: YES\n*************************** 2. row ***************************\n   Engine: CSV\n  Support: YES\n  Comment: CSV storage engine\nTransactions: NO\n     XA: NO\n Savepoints: NO\n*************************** 3. row ***************************\n   Engine: MyISAM\n  Support: YES\n  Comment: MyISAM storage engine\nTransactions: NO\n     XA: NO\n Savepoints: NO\n*************************** 4. row ***************************\n   Engine: BLACKHOLE\n  Support: YES\n  Comment: /dev/null storage engine (anything you write to it disappears)\nTransactions: NO\n     XA: NO\n Savepoints: NO\n*************************** 5. row ***************************\n   Engine: FEDERATED\n  Support: YES\n  Comment: FederatedX pluggable storage engine\nTransactions: YES\n     XA: NO\n Savepoints: YES\n*************************** 6. row ***************************\n   Engine: MRG_MyISAM\n  Support: YES\n  Comment: Collection of identical MyISAM tables\nTransactions: NO\n     XA: NO\n Savepoints: NO\n*************************** 7. row ***************************\n   Engine: ARCHIVE\n  Support: YES\n  Comment: Archive storage engine\nTransactions: NO\n     XA: NO\n Savepoints: NO\n*************************** 8. row ***************************\n   Engine: MEMORY\n  Support: YES\n  Comment: Hash based, stored in memory, useful for temporary tables\nTransactions: NO\n     XA: NO\n Savepoints: NO\n*************************** 9. row ***************************\n   Engine: PERFORMANCE_SCHEMA\n  Support: YES\n  Comment: Performance Schema\nTransactions: NO\n     XA: NO\n Savepoints: NO\n*************************** 10. row ***************************\n   Engine: Aria\n  Support: YES\n  Comment: Crash-safe tables with MyISAM heritage\nTransactions: NO\n     XA: NO\n Savepoints: NO\n10 rows in set (0.00 sec)\n\nURL: https://mariadb.com/kb/en/show-engines/','','https://mariadb.com/kb/en/show-engines/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (381,26,'SHOW ERRORS','Syntax\n------\n\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW ERRORS [LIMIT row_count OFFSET offset]\nSHOW COUNT(*) ERRORS\n\nDescription\n-----------\n\nThis statement is similar to SHOW WARNINGS, except that instead of displaying\nerrors, warnings, and notes, it displays only errors.\n\nThe LIMIT clause has the same syntax as for the SELECT statement.\n\nThe SHOW COUNT(*) ERRORS statement displays the number of errors. You can also\nretrieve this number from the error_count variable.\n\nSHOW COUNT(*) ERRORS;\nSELECT @@error_count;\n\nThe value of error_count might be greater than the number of messages\ndisplayed by SHOW WARNINGS if the max_error_count system variable is set so\nlow that not all messages are stored.\n\nFor a list of MariaDB error codes, see MariaDB Error Codes.\n\nExamples\n--------\n\nSELECT f();\nERROR 1305 (42000): FUNCTION f does not exist\n\nSHOW COUNT(*) ERRORS;\n+-----------------------+\n| @@session.error_count |\n+-----------------------+\n|                     1 |\n+-----------------------+\n\nSHOW ERRORS;\n+-------+------+---------------------------+\n| Level | Code | Message                   |\n+-------+------+---------------------------+\n| Error | 1305 | FUNCTION f does not exist |\n+-------+------+---------------------------+\n\nURL: https://mariadb.com/kb/en/show-errors/','','https://mariadb.com/kb/en/show-errors/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (382,26,'SHOW EVENTS','Syntax\n------\n\nSHOW EVENTS [{FROM | IN} schema_name]\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nShows information about Event Manager events (created with CREATE EVENT).\nRequires the EVENT privilege. Without any arguments, SHOW EVENTS lists all of\nthe events in the current schema:\n\nSELECT CURRENT_USER(), SCHEMA();\n+----------------+----------+\n| CURRENT_USER() | SCHEMA() |\n+----------------+----------+\n| jon@ghidora    | myschema |\n+----------------+----------+\n\nSHOW EVENTS\\G\n*************************** 1. row ***************************\n         Db: myschema\n        Name: e_daily\n      Definer: jon@ghidora\n     Time zone: SYSTEM\n        Type: RECURRING\n     Execute at: NULL\n   Interval value: 10\n   Interval field: SECOND\n       Starts: 2006-02-09 10:41:23\n        Ends: NULL\n       Status: ENABLED\n     Originator: 0\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n Database Collation: latin1_swedish_ci\n\nTo see the event action, use SHOW CREATE EVENT instead, or look at the\ninformation_schema.EVENTS table.\n\nTo see events for a specific schema, use the FROM clause. For example, to see\nevents for the test schema, use the following statement:\n\nSHOW EVENTS FROM test;\n\nThe LIKE clause, if present, indicates which event names to match. The WHERE\nclause can be given to select rows using more general conditions, as discussed\nin Extended Show.\n\nURL: https://mariadb.com/kb/en/show-events/','','https://mariadb.com/kb/en/show-events/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (383,26,'SHOW FUNCTION STATUS','Syntax\n------\n\nSHOW FUNCTION STATUS\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nThis statement is similar to SHOW PROCEDURE STATUS but for stored functions.\n\nThe LIKE clause, if present on its own, indicates which function names to\nmatch.\n\nThe WHERE and LIKE clauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW.\n\nThe information_schema.ROUTINES table contains more detailed information.\n\nExamples\n--------\n\nShowing all stored functions:\n\nSHOW FUNCTION STATUS\\G\n*************************** 1. row ***************************\n         Db: test\n        Name: VatCents\n        Type: FUNCTION\n      Definer: root@localhost\n      Modified: 2013-06-01 12:40:31\n      Created: 2013-06-01 12:40:31\n   Security_type: DEFINER\n      Comment:\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\nStored functions whose name starts with \'V\':\n\nSHOW FUNCTION STATUS LIKE \'V%\' \\G\n*************************** 1. row ***************************\n         Db: test\n        Name: VatCents\n        Type: FUNCTION\n      Definer: root@localhost\n      Modified: 2013-06-01 12:40:31\n      Created: 2013-06-01 12:40:31\n   Security_type: DEFINER\n      Comment:\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\nStored functions with a security type of \'DEFINER\':\n\nSHOW FUNCTION STATUS WHERE Security_type LIKE \'DEFINER\' \\G\n*************************** 1. row ***************************\n         Db: test\n        Name: VatCents\n        Type: FUNCTION\n      Definer: root@localhost\n      Modified: 2013-06-01 12:40:31\n      Created: 2013-06-01 12:40:31\n   Security_type: DEFINER\n      Comment:\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\nURL: https://mariadb.com/kb/en/show-function-status/','','https://mariadb.com/kb/en/show-function-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (384,26,'SHOW LOCALES','SHOW LOCALES was introduced as part of the Information Schema plugin extension.\n\nSHOW LOCALES is used to return locales information as part of the Locales\nplugin. While the information_schema.LOCALES table has 8 columns, the SHOW\nLOCALES statement will only display 4 of them:\n\nExample\n-------\n\nSHOW LOCALES;\n+-----+-------+-------------------------------------+------------------------+\n| Id  | Name  | Description                         | Error_Message_Language |\n+-----+-------+-------------------------------------+------------------------+\n|   0 | en_US | English - United States             | english                |\n|   1 | en_GB | English - United Kingdom            | english                |\n|   2 | ja_JP | Japanese - Japan                    | japanese               |\n|   3 | sv_SE | Swedish - Sweden                    | swedish                |\n...\n\nURL: https://mariadb.com/kb/en/show-locales/','','https://mariadb.com/kb/en/show-locales/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (385,26,'SHOW OPEN TABLES','Syntax\n------\n\nSHOW OPEN TABLES [FROM db_name]\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nSHOW OPEN TABLES lists the non-TEMPORARY tables that are currently open in the\ntable cache. See http://dev.mysql.com/doc/refman/5.1/en/table-cache.html.\n\nThe FROM and LIKE clauses may be used.\n\nThe FROM clause, if present, restricts the tables shown to those present in\nthe db_name database.\n\nThe LIKE clause, if present on its own, indicates which table names to match.\nThe WHERE and LIKE clauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW.\n\nThe following information is returned:\n\n+---------------------------+------------------------------------------------+\n| Column                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| Database                  | Database name.                                 |\n+---------------------------+------------------------------------------------+\n| Name                      | Table name.                                    |\n+---------------------------+------------------------------------------------+\n| In_use                    | Number of  table instances being used.         |\n+---------------------------+------------------------------------------------+\n| Name_locked               | 1 if the table is name-locked, e.g. if it is   |\n|                           | being dropped or renamed, otherwise 0.         |\n+---------------------------+------------------------------------------------+\n\nBefore MariaDB 5.5, each use of, for example, LOCK TABLE ... WRITE would\nincrement In_use for that table. With the implementation of the metadata\nlocking improvements in MariaDB 5.5, LOCK TABLE... WRITE acquires a strong MDL\nlock, and concurrent connections will wait on this MDL lock, so any subsequent\nLOCK TABLE... WRITE will not increment In_use.\n\nExample\n-------\n\nSHOW OPEN TABLES;\n+----------+---------------------------+--------+-------------+\n| Database | Table                     | In_use | Name_locked |\n+----------+---------------------------+--------+-------------+\n...\n| test     | xjson                     |      0 |           0 |\n| test     | jauthor                   |      0 |           0 |\n| test     | locks                     |      1 |           0 |\n...\n+----------+---------------------------+--------+-------------+\n\nURL: https://mariadb.com/kb/en/show-open-tables/','','https://mariadb.com/kb/en/show-open-tables/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (386,26,'SHOW PACKAGE BODY STATUS','MariaDB starting with 10.3.5\n----------------------------\nOracle-style packages were introduced in MariaDB 10.3.5.\n\nSyntax\n------\n\nSHOW PACKAGE BODY STATUS\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nThe SHOW PACKAGE BODY STATUS statement returns characteristics of stored\npackage bodies (implementations), such as the database, name, type, creator,\ncreation and modification dates, and character set information. A similar\nstatement, SHOW PACKAGE STATUS, displays information about stored package\nspecifications.\n\nThe LIKE clause, if present, indicates which package names to match. The WHERE\nand LIKE clauses can be given to select rows using more general conditions, as\ndiscussed in Extended SHOW.\n\nThe ROUTINES table in the INFORMATION_SCHEMA database contains more detailed\ninformation.\n\nExamples\n--------\n\nSHOW PACKAGE BODY STATUS LIKE \'pkg1\'\\G\n*************************** 1. row ***************************\n         Db: test\n        Name: pkg1\n        Type: PACKAGE BODY\n      Definer: root@localhost\n      Modified: 2018-02-27 14:44:14\n      Created: 2018-02-27 14:44:14\n   Security_type: DEFINER\n      Comment: This is my first package body\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\nURL: https://mariadb.com/kb/en/show-package-body-status/','','https://mariadb.com/kb/en/show-package-body-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (387,26,'SHOW PACKAGE STATUS','MariaDB starting with 10.3.5\n----------------------------\nOracle-style packages were introduced in MariaDB 10.3.5.\n\nSyntax\n------\n\nSHOW PACKAGE STATUS\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nThe SHOW PACKAGE STATUS statement returns characteristics of stored package\nspecifications, such as the database, name, type, creator, creation and\nmodification dates, and character set information. A similar statement, SHOW\nPACKAGE BODY STATUS, displays information about stored package bodies (i.e.\nimplementations).\n\nThe LIKE clause, if present, indicates which package names to match. The WHERE\nand LIKE clauses can be given to select rows using more general conditions, as\ndiscussed in Extended SHOW.\n\nThe ROUTINES table in the INFORMATION_SCHEMA database contains more detailed\ninformation.\n\nExamples\n--------\n\nSHOW PACKAGE STATUS LIKE \'pkg1\'\\G\n*************************** 1. row ***************************\n         Db: test\n        Name: pkg1\n        Type: PACKAGE\n      Definer: root@localhost\n      Modified: 2018-02-27 14:38:15\n      Created: 2018-02-27 14:38:15\n   Security_type: DEFINER\n      Comment: This is my first package\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\nURL: https://mariadb.com/kb/en/show-package-status/','','https://mariadb.com/kb/en/show-package-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (388,26,'SHOW PRIVILEGES','Syntax\n------\n\nSHOW PRIVILEGES\n\nDescription\n-----------\n\nSHOW PRIVILEGES shows the list of system privileges that the MariaDB server\nsupports. The exact list of privileges depends on the version of your server.\n\nNote that before MariaDB 10.3.23, MariaDB 10.4.13 and MariaDB 10.5.2 , the\nDelete history privilege displays as Delete versioning rows (MDEV-20382).\n\nExample\n-------\n\nFrom MariaDB 10.5.9\n\nSHOW PRIVILEGES;\n+--------------------------+---------------------------------------+-----------\n--------------------------------------------------------+\n| Privilege                | Context                               | Comment  \n                            |\n+--------------------------+---------------------------------------+-----------\n--------------------------------------------------------+\n| Alter                    | Tables                                | To alter\nthe table                                                 |\n| Alter routine            | Functions,Procedures                  | To alter\nor drop stored functions/procedures                       |\n| Create                   | Databases,Tables,Indexes              | To create\nnew databases and tables                                 |\n| Create routine           | Databases                             | To use\nCREATE FUNCTION/PROCEDURE                                   |\n| Create temporary tables  | Databases                             | To use\nCREATE TEMPORARY TABLE                                      |\n| Create view              | Tables                                | To create\nnew views                                                |\n| Create user              | Server Admin                          | To create\nnew users                                                |\n| Delete                   | Tables                                | To delete\nexisting rows                                            |\n| Delete history           | Tables                                | To delete\nversioning table historical rows                         |\n| Drop                     | Databases,Tables                      | To drop\ndatabases, tables, and views                               |\n| Event                    | Server Admin                          | To\ncreate, alter, drop and execute events                          |\n| Execute                  | Functions,Procedures                  | To\nexecute stored routines                                         |\n| File                     | File access on server                 | To read\nand write files on the server                              |\n| Grant option             | Databases,Tables,Functions,Procedures | To give\nto other users those privileges you possess                |\n| Index                    | Tables                                | To create\nor drop indexes                                          |\n| Insert                   | Tables                                | To insert\ndata into tables                                         |\n| Lock tables              | Databases                             | To use\nLOCK TABLES (together with SELECT privilege)                |\n| Process                  | Server Admin                          | To view\nthe plain text of currently executing queries              |\n| Proxy                    | Server Admin                          | To make\nproxy user possible                                        |\n| References               | Databases,Tables                      | To have\nreferences on tables                                       |\n| Reload                   | Server Admin                          | To reload\nor refresh tables, logs and privileges                   |\n| Binlog admin             | Server                                | To purge\nbinary logs                                               |\n| Binlog monitor           | Server                                | To use\nSHOW BINLOG STATUS and SHOW BINARY LOG                      |\n| Binlog replay            | Server                                | To use\nBINLOG (generated by mariadb-binlog)                        |\n| Replication master admin | Server                                | To\nmonitor connected slaves                                        |\n| Replication slave admin  | Server                                | To\nstart/stop slave and apply binlog events                        |\n| Slave monitor            | Server                                | To use\nSHOW SLAVE STATUS and SHOW RELAYLOG EVENTS                  |\n| Replication slave        | Server Admin                          | To read\nbinary log events from the master                          |\n| Select                   | Tables                                | To\nretrieve rows from table                                        |\n| Show databases           | Server Admin                          | To see\nall databases with SHOW DATABASES                           |\n| Show view                | Tables                                | To see\nviews with SHOW CREATE VIEW                                 |\n| Shutdown                 | Server Admin                          | To shut\ndown the server                                            |\n| Super                    | Server Admin                          | To use\nKILL thread, SET GLOBAL, CHANGE MASTER, etc.                |\n| Trigger                  | Tables                                | To use\ntriggers                                                    |\n| Create tablespace        | Server Admin                          | To\ncreate/alter/drop tablespaces                                   |\n| Update                   | Tables                                | To update\nexisting rows                                            |\n| Set user                 | Server                                | To create\nviews and stored routines with a different definer       |\n| Federated admin          | Server                                | To\nexecute the CREATE SERVER, ALTER SERVER, DROP SERVER statements |\n| Connection admin         | Server                                | To bypass\nconnection limits and kill other users\' connections      |\n| Read_only admin          | Server                                | To\nperform write operations even if @@read_only=ON                 |\n| Usage                    | Server Admin                          | No\nprivileges - allow connect only                                 |\n+--------------------------+---------------------------------------+-----------\n--------------------------------------------------------+\n41 rows in set (0.000 sec)\n\nURL: https://mariadb.com/kb/en/show-privileges/','','https://mariadb.com/kb/en/show-privileges/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (389,26,'SHOW PROCEDURE CODE','Syntax\n------\n\nSHOW PROCEDURE CODE proc_name\n\nDescription\n-----------\n\nThis statement is a MariaDB extension that is available only for servers that\nhave been built with debugging support. It displays a representation of the\ninternal implementation of the named stored procedure. A similar statement,\nSHOW FUNCTION CODE, displays information about stored functions.\n\nBoth statements require that you be the owner of the routine or have SELECT\naccess to the mysql.proc table.\n\nIf the named routine is available, each statement produces a result set. Each\nrow in the result set corresponds to one \"instruction\" in the routine. The\nfirst column is Pos, which is an ordinal number beginning with 0. The second\ncolumn is Instruction, which contains an SQL statement (usually changed from\nthe original source), or a directive which has meaning only to the\nstored-routine handler.\n\nExamples\n--------\n\nDELIMITER //\n\nCREATE PROCEDURE p1 ()\n BEGIN\n  DECLARE fanta INT DEFAULT 55;\n  DROP TABLE t2;\n  LOOP\n   INSERT INTO t3 VALUES (fanta);\n   END LOOP;\n END//\nQuery OK, 0 rows affected (0.00 sec)\n\nSHOW PROCEDURE CODE p1//\n+-----+----------------------------------------+\n| Pos | Instruction                            |\n+-----+----------------------------------------+\n|   0 | set fanta@0 55                         |\n|   1 | stmt 9 \"DROP TABLE t2\"                 |\n|   2 | stmt 5 \"INSERT INTO t3 VALUES (fanta)\" |\n|   3 | jump 2                                 |\n+-----+----------------------------------------+\n\nURL: https://mariadb.com/kb/en/show-procedure-code/','','https://mariadb.com/kb/en/show-procedure-code/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (390,26,'SHOW PROCEDURE STATUS','Syntax\n------\n\nSHOW PROCEDURE STATUS\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nThis statement is a MariaDB extension. It returns characteristics of a stored\nprocedure, such as the database, name, type, creator, creation and\nmodification dates, and character set information. A similar statement, SHOW\nFUNCTION STATUS, displays information about stored functions.\n\nThe LIKE clause, if present, indicates which procedure or function names to\nmatch. The WHERE and LIKE clauses can be given to select rows using more\ngeneral conditions, as discussed in Extended SHOW.\n\nThe ROUTINES table in the INFORMATION_SCHEMA database contains more detailed\ninformation.\n\nExamples\n--------\n\nSHOW PROCEDURE STATUS LIKE \'p1\'\\G\n*************************** 1. row ***************************\n         Db: test\n        Name: p1\n        Type: PROCEDURE\n      Definer: root@localhost\n      Modified: 2010-08-23 13:23:03\n      Created: 2010-08-23 13:23:03\n   Security_type: DEFINER\n      Comment:\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n Database Collation: latin1_swedish_ci\n\nURL: https://mariadb.com/kb/en/show-procedure-status/','','https://mariadb.com/kb/en/show-procedure-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (391,26,'SHOW PROCESSLIST','Syntax\n------\n\nSHOW [FULL] PROCESSLIST\n\nDescription\n-----------\n\nSHOW PROCESSLIST shows you which threads are running. You can also get this\ninformation from the information_schema.PROCESSLIST table or the mariadb-admin\nprocesslist command. If you have the PROCESS privilege, you can see all\nthreads. Otherwise, you can see only your own threads (that is, threads\nassociated with the MariaDB account that you are using). If you do not use the\nFULL keyword, only the first 100 characters of each statement are shown in the\nInfo field.\n\nThe columns shown in SHOW PROCESSLIST are:\n\n+---------------------+------------------------------------------------------+\n| Name                | Description                                          |\n+---------------------+------------------------------------------------------+\n| ID                  | The client\'s process ID.                             |\n+---------------------+------------------------------------------------------+\n| USER                | The username associated with the process.            |\n+---------------------+------------------------------------------------------+\n| HOST                | The host the client is connected to.                 |\n+---------------------+------------------------------------------------------+\n| DB                  | The default database of the process (NULL if no      |\n|                     | default).                                            |\n+---------------------+------------------------------------------------------+\n| COMMAND             | The command type. See Thread Command Values.         |\n+---------------------+------------------------------------------------------+\n| TIME                | The amount of time, in seconds, the process has      |\n|                     | been in its current state. For a replica SQL thread  |\n|                     | before MariaDB 10.1, this is the time in seconds     |\n|                     | between the last replicated event\'s timestamp and    |\n|                     | the replica machine\'s real time.                     |\n+---------------------+------------------------------------------------------+\n| STATE               | See Thread States.                                   |\n+---------------------+------------------------------------------------------+\n| INFO                | The statement being executed.                        |\n+---------------------+------------------------------------------------------+\n| PROGRESS            | The total progress of the process (0-100%) (see      |\n|                     | Progress Reporting).                                 |\n+---------------------+------------------------------------------------------+\n\nSee TIME_MS column in information_schema.PROCESSLIST for differences in the\nTIME column between MariaDB and MySQL.\n\nThe information_schema.PROCESSLIST table contains the following additional\ncolumns:\n\n+---------------------+------------------------------------------------------+\n| Name                | Description                                          |\n+---------------------+------------------------------------------------------+\n| TIME_MS             | The amount of time, in milliseconds, the process     |\n|                     | has been in its current state.                       |\n+---------------------+------------------------------------------------------+\n| STAGE               | The stage the process is currently in.               |\n+---------------------+------------------------------------------------------+\n| MAX_STAGE           | The maximum number of stages.                        |\n+---------------------+------------------------------------------------------+\n| PROGRESS            | The progress of the process within the current       |\n|                     | stage (0-100%).                                      |\n+---------------------+------------------------------------------------------+\n| MEMORY_USED         | The amount of memory used by the process.            |\n+---------------------+------------------------------------------------------+\n| EXAMINED_ROWS       | The number of rows the process has examined.         |\n+---------------------+------------------------------------------------------+\n| QUERY_ID            | Query ID.                                            |\n+---------------------+------------------------------------------------------+\n\nNote that the PROGRESS field from the information schema, and the PROGRESS\nfield from SHOW PROCESSLIST display different results. SHOW PROCESSLIST shows\nthe total progress, while the information schema shows the progress for the\ncurrent stage only.\n\nThreads can be killed using their thread_id or their query_id, with the KILL\nstatement.\n\nSince queries on this table are locking, if the performance_schema is enabled,\nyou may want to query the THREADS table instead.\n\nExamples\n--------\n\nSHOW PROCESSLIST;\n+----+-----------------+-----------+------+---------+------+-------------------\n----+------------------+----------+\n| Id | User            | Host      | db   | Command | Time | State            \n  | Info             | Progress |\n+----+-----------------+-----------+------+---------+------+-------------------\n----+------------------+----------+\n|  2 | event_scheduler | localhost | NULL | Daemon  | 2693 | Waiting on empty\nqueue | NULL             |    0.000 |\n|  4 | root            | localhost | NULL | Query   |    0 | Table lock       \n  | SHOW PROCESSLIST |    0.000 |\n+----+-----------------+-----------+------+---------+------+-------------------\n----+------------------+----------+\n\nURL: https://mariadb.com/kb/en/show-processlist/','','https://mariadb.com/kb/en/show-processlist/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (392,26,'SHOW PROFILE','Syntax\n------\n\nSHOW PROFILE [type [, type] ... ]\n  [FOR QUERY n]\n  [LIMIT row_count [OFFSET offset]]\n\ntype:\n  ALL\n | BLOCK IO\n | CONTEXT SWITCHES\n | CPU\n | IPC\n | MEMORY\n | PAGE FAULTS\n | SOURCE\n | SWAPS\n\nDescription\n-----------\n\nThe SHOW PROFILE and SHOW PROFILES statements display profiling information\nthat indicates resource usage for statements executed during the course of the\ncurrent session.\n\nProfiling is controlled by the profiling session variable, which has a default\nvalue of 0 (OFF). Profiling is enabled by setting profiling to 1 or ON:\n\nSET profiling = 1;\n\nSHOW PROFILES displays a list of the most recent statements sent to the\nmaster. The size of the list is controlled by the profiling_history_size\nsession variable, which has a default value of 15. The maximum value is 100.\nSetting the value to 0 has the practical effect of disabling profiling.\n\nAll statements are profiled except SHOW PROFILES and SHOW PROFILE, so you will\nfind neither of those statements in the profile list. Malformed statements are\nprofiled. For example, SHOW PROFILING is an illegal statement, and a syntax\nerror occurs if you try to execute it, but it will show up in the profiling\nlist.\n\nSHOW PROFILE displays detailed information about a single statement. Without\nthe FOR QUERY n clause, the output pertains to the most recently executed\nstatement. If FOR QUERY n is included, SHOW PROFILE displays information for\nstatement n. The values of n correspond to the Query_ID values displayed by\nSHOW PROFILES.\n\nThe LIMIT row_count clause may be given to limit the output to row_count rows.\nIf LIMIT is given, OFFSET offset may be added to begin the output offset rows\ninto the full set of rows.\n\nBy default, SHOW PROFILE displays Status and Duration columns. The Status\nvalues are like the State values displayed by SHOW PROCESSLIST, although there\nmight be some minor differences in interpretation for the two statements for\nsome status values (see\nhttp://dev.mysql.com/doc/refman/5.6/en/thread-information.html).\n\nOptional type values may be specified to display specific additional types of\ninformation:\n\n* ALL displays all information\n* BLOCK IO displays counts for block input and output operations\n* CONTEXT SWITCHES displays counts for voluntary and involuntary context\nswitches\n* CPU displays user and system CPU usage times\n* IPC displays counts for messages sent and received\n* MEMORY is not currently implemented\n* PAGE FAULTS displays counts for major and minor page faults\n* SOURCE displays the names of functions from the source code, together with\nthe name and line number of the file in which the function occurs\n* SWAPS displays swap counts\n\nProfiling is enabled per session. When a session ends, its profiling\ninformation is lost.\n\nThe information_schema.PROFILING table contains similar information.\n\nExamples\n--------\n\nSELECT @@profiling;\n+-------------+\n| @@profiling |\n+-------------+\n|           0 |\n+-------------+\n\nSET profiling = 1;\n\nUSE test;\n\nDROP TABLE IF EXISTS t1;\n\nCREATE TABLE T1 (id INT);\n\nSHOW PROFILES;\n+----------+------------+--------------------------+\n| Query_ID | Duration   | Query                    |\n+----------+------------+--------------------------+\n|        1 | 0.00009200 | SELECT DATABASE()        |\n|        2 | 0.00023800 | show databases           |\n|        3 | 0.00018900 | show tables              |\n|        4 | 0.00014700 | DROP TABLE IF EXISTS t1  |\n|        5 | 0.24476900 | CREATE TABLE T1 (id INT) |\n+----------+------------+--------------------------+\n\nSHOW PROFILE;\n+----------------------+----------+\n| Status               | Duration |\n+----------------------+----------+\n| starting             | 0.000042 |\n| checking permissions | 0.000044 |\n| creating table       | 0.244645 |\n| After create         | 0.000013 |\n| query end            | 0.000003 |\n| freeing items        | 0.000016 |\n| logging slow query   | 0.000003 |\n| cleaning up          | 0.000003 |\n+----------------------+----------+\n\nSHOW PROFILE FOR QUERY 4;\n+--------------------+----------+\n| Status             | Duration |\n+--------------------+----------+\n| starting           | 0.000126 |\n| query end          | 0.000004 |\n| freeing items      | 0.000012 |\n| logging slow query | 0.000003 |\n| cleaning up        | 0.000002 |\n+--------------------+----------+\n\nSHOW PROFILE CPU FOR QUERY 5;\n+----------------------+----------+----------+------------+\n| Status               | Duration | CPU_user | CPU_system |\n+----------------------+----------+----------+------------+\n| starting             | 0.000042 | 0.000000 |   0.000000 |\n| checking permissions | 0.000044 | 0.000000 |   0.000000 |\n| creating table       | 0.244645 | 0.000000 |   0.000000 |\n| After create         | 0.000013 | 0.000000 |   0.000000 |\n| query end            | 0.000003 | 0.000000 |   0.000000 |\n| freeing items        | 0.000016 | 0.000000 |   0.000000 |\n| logging slow query   | 0.000003 | 0.000000 |   0.000000 |\n| cleaning up          | 0.000003 | 0.000000 |   0.000000 |\n+----------------------+----------+----------+------------+\n\nURL: https://mariadb.com/kb/en/show-profile/','','https://mariadb.com/kb/en/show-profile/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (393,26,'SHOW PROFILES','Syntax\n------\n\nSHOW PROFILES\n\nDescription\n-----------\n\nThe SHOW PROFILES statement displays profiling information that indicates\nresource usage for statements executed during the course of the current\nsession. It is used together with SHOW PROFILE.\n\nURL: https://mariadb.com/kb/en/show-profiles/','','https://mariadb.com/kb/en/show-profiles/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (394,26,'SHOW QUERY_RESPONSE_TIME','It is possible to use SHOW QUERY_RESPONSE_TIME as an alternative for\nretrieving information from the QUERY_RESPONSE_TIME plugin.\n\nThis was introduced as part of the Information Schema plugin extension.\n\nURL: https://mariadb.com/kb/en/show-query_response_time/','','https://mariadb.com/kb/en/show-query_response_time/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (395,26,'SHOW STATUS','Syntax\n------\n\nSHOW [GLOBAL | SESSION] STATUS\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nSHOW STATUS provides server status information. This information also can be\nobtained using the mariadb-admin extended-status command, or by querying the\nInformation Schema GLOBAL_STATUS and SESSION_STATUS tables. The LIKE clause,\nif present, indicates which variable names to match. The WHERE clause can be\ngiven to select rows using more general conditions.\n\nWith the GLOBAL modifier, SHOW STATUS displays the status values for all\nconnections to MariaDB. With SESSION, it displays the status values for the\ncurrent connection. If no modifier is present, the default is SESSION. LOCAL\nis a synonym for SESSION. If you see a lot of 0 values, the reason is probably\nthat you have used SHOW STATUS with a new connection instead of SHOW GLOBAL\nSTATUS.\n\nSome status variables have only a global value. For these, you get the same\nvalue for both GLOBAL and SESSION.\n\nSee Server Status Variables for a full list, scope and description of the\nvariables that can be viewed with SHOW STATUS.\n\nThe LIKE clause, if present on its own, indicates which variable name to match.\n\nThe WHERE and LIKE clauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW.\n\nExamples\n--------\n\nSHOW GLOBAL STATUS;\n+--------------------------------------------------------------+---------------\n------------------------+\n| Variable_name                                                | Value        \n            |\n+--------------------------------------------------------------+---------------\n------------------------+\n| Aborted_clients                                              | 0            \n            |\n| Aborted_connects                                             | 0            \n            |\n| Access_denied_errors                                         | 0            \n            |\n| Acl_column_grants                                            | 0            \n            |\n| Acl_database_grants                                          | 2            \n            |\n| Acl_function_grants                                          | 0            \n            |\n| Acl_procedure_grants                                         | 0            \n            |\n| Acl_proxy_users                                              | 2            \n            |\n| Acl_role_grants                                              | 0            \n            |\n| Acl_roles                                                    | 0            \n            |\n| Acl_table_grants                                             | 0            \n            |\n| Acl_users                                                    | 6            \n            |\n| Aria_pagecache_blocks_not_flushed                            | 0            \n            |\n| Aria_pagecache_blocks_unused                                 | 15706        \n            |\n...\n| wsrep_local_index                                            |\n18446744073709551615                   |\n| wsrep_provider_name                                          |              \n            |\n| wsrep_provider_vendor                                        |              \n            |\n| wsrep_provider_version                                       |              \n            |\n| wsrep_ready                                                  | OFF          \n            |\n| wsrep_thread_count                                           | 0            \n            |\n+--------------------------------------------------------------+---------------\n------------------------+\n516 rows in set (0.00 sec)\n\nExample of filtered output:\n\nSHOW STATUS LIKE \'Key%\';\n+------------------------+--------+\n| Variable_name          | Value  |\n+------------------------+--------+\n| Key_blocks_not_flushed | 0      |\n| Key_blocks_unused      | 107163 |\n| Key_blocks_used        | 0      |\n| Key_blocks_warm        | 0      |\n| Key_read_requests      | 0      |\n| Key_reads              | 0      |\n| Key_write_requests     | 0      |\n| Key_writes             | 0      |\n+------------------------+--------+\n8 rows in set (0.00 sec)\n\nURL: https://mariadb.com/kb/en/show-status/','','https://mariadb.com/kb/en/show-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (396,26,'SHOW TABLE STATUS','Syntax\n------\n\nSHOW TABLE STATUS [{FROM | IN} db_name]\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nSHOW TABLE STATUS works like SHOW TABLES, but provides more extensive\ninformation about each table (until MariaDB 11.2.0, only non-TEMPORARY tables\nare shown).\n\nThe LIKE clause, if present on its own, indicates which table names to match.\nThe WHERE and LIKE clauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW.\n\nThe following information is returned:\n\n+---------------------------+------------------------------------------------+\n| Column                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| Name                      | Table name.                                    |\n+---------------------------+------------------------------------------------+\n| Engine                    | Table storage engine.                          |\n+---------------------------+------------------------------------------------+\n| Version                   | Version number from the table\'s .frm file.     |\n+---------------------------+------------------------------------------------+\n| Row_format                | Row format (see InnoDB, Aria and MyISAM row    |\n|                           | formats).                                      |\n+---------------------------+------------------------------------------------+\n| Rows                      | Number of rows in the table. Some engines,     |\n|                           | such as InnoDB may store an estimate.          |\n+---------------------------+------------------------------------------------+\n| Avg_row_length            | Average row length in the table.               |\n+---------------------------+------------------------------------------------+\n| Data_length               | For InnoDB, the index size, in pages,          |\n|                           | multiplied by the page size. For Aria and      |\n|                           | MyISAM, length of the data file, in bytes.     |\n|                           | For MEMORY, the approximate allocated memory.  |\n+---------------------------+------------------------------------------------+\n| Max_data_length           | Maximum length of the data file, ie the total  |\n|                           | number of bytes that could be stored in the    |\n|                           | table. Not used in InnoDB.                     |\n+---------------------------+------------------------------------------------+\n| Index_length              | Length of the index file.                      |\n+---------------------------+------------------------------------------------+\n| Data_free                 | Bytes allocated but unused. For InnoDB tables  |\n|                           | in a shared tablespace, the free space of the  |\n|                           | shared tablespace with small safety margin.    |\n|                           | An estimate in the case of partitioned tables  |\n|                           | - see the PARTITIONS table.                    |\n+---------------------------+------------------------------------------------+\n| Auto_increment            | Next AUTO_INCREMENT value.                     |\n+---------------------------+------------------------------------------------+\n| Create_time               | Time the table was created. Some engines just  |\n|                           | return the ctime information from the file     |\n|                           | system layer here, in that case the value is   |\n|                           | not necessarily the table creation time but    |\n|                           | rather the time the file system metadata for   |\n|                           | it had last changed.                           |\n+---------------------------+------------------------------------------------+\n| Update_time               | Time the table was last updated. On Windows,   |\n|                           | the timestamp is not updated on update, so     |\n|                           | MyISAM values will be inaccurate. In InnoDB,   |\n|                           | if shared tablespaces are used, will be NULL,  |\n|                           | while buffering can also delay the update, so  |\n|                           | the value will differ from the actual time of  |\n|                           | the last UPDATE, INSERT or DELETE.             |\n+---------------------------+------------------------------------------------+\n| Check_time                | Time the table was last checked. Not kept by   |\n|                           | all storage engines, in which case will be     |\n|                           | NULL.                                          |\n+---------------------------+------------------------------------------------+\n| Collation                 | Character set and collation.                   |\n+---------------------------+------------------------------------------------+\n| Checksum                  | Live checksum value, if any.                   |\n+---------------------------+------------------------------------------------+\n| Create_options            | Extra CREATE TABLE options.                    |\n+---------------------------+------------------------------------------------+\n| Comment                   | Table comment provided when MariaDB created    |\n|                           | the table.                                     |\n+---------------------------+------------------------------------------------+\n| Max_index_length          | Maximum index length (supported by MyISAM and  |\n|                           | Aria tables).                                  |\n+---------------------------+------------------------------------------------+\n| Temporary                 | Until MariaDB 11.2.0, placeholder to signal    |\n|                           | that a table is a temporary table and always   |\n|                           | \"N\", except \"Y\" for generated                  |\n|                           | information_schema tables and NULL for views.  |\n|                           | From MariaDB 11.2.0, will also be set to \"Y\"   |\n|                           | for local temporary tables.                    |\n+---------------------------+------------------------------------------------+\n\nSimilar information can be found in the information_schema.TABLES table as\nwell as by using mariadb-show:\n\nmariadb-show --status db_name\n\nViews\n-----\n\nFor views, all columns in SHOW TABLE STATUS are NULL except \'Name\' and\n\'Comment\'\n\nExample\n-------\n\nshow table status\\G\n*************************** 1. row ***************************\n     Name: bus_routes\n    Engine: InnoDB\n    Version: 10\n  Row_format: Dynamic\n     Rows: 5\n Avg_row_length: 3276\n  Data_length: 16384\nMax_data_length: 0\n Index_length: 0\n   Data_free: 0\n Auto_increment: NULL\n  Create_time: 2017-05-24 11:17:46\n  Update_time: NULL\n  Check_time: NULL\n   Collation: latin1_swedish_ci\n   Checksum: NULL\n Create_options: \n    Comment:\n\nURL: https://mariadb.com/kb/en/show-table-status/','','https://mariadb.com/kb/en/show-table-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (397,26,'SHOW TABLES','Syntax\n------\n\nSHOW [FULL] TABLES [FROM db_name]\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nSHOW TABLES lists the tables (until MariaDB 11.2.0, only non-TEMPORARY tables\nare shown), sequences and views in a given database.\n\nThe LIKE clause, if present on its own, indicates which table names to match.\nThe WHERE and LIKE clauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW. For example, when searching for\ntables in the test database, the column name for use in the WHERE and LIKE\nclauses will be Tables_in_test\n\nThe FULL modifier is supported such that SHOW FULL TABLES displays a second\noutput column. Values for the second column, Table_type, are BASE TABLE for a\ntable, VIEW for a view and SEQUENCE for a sequence.\n\nYou can also get this information using:\n\nmariadb-show db_name\n\nSee mariadb-show for more details.\n\nIf you have no privileges for a base table or view, it does not show up in the\noutput from SHOW TABLES or mariadb-show db_name.\n\nThe information_schema.TABLES table, as well as the SHOW TABLE STATUS\nstatement, provide extended information about tables.\n\nExamples\n--------\n\nSHOW TABLES;\n+----------------------+\n| Tables_in_test       |\n+----------------------+\n| animal_count         |\n| animals              |\n| are_the_mooses_loose |\n| aria_test2           |\n| t1                   |\n| view1                |\n+----------------------+\n\nShowing the tables beginning with a only.\n\nSHOW TABLES WHERE Tables_in_test LIKE \'a%\';\n+----------------------+\n| Tables_in_test       |\n+----------------------+\n| animal_count         |\n| animals              |\n| are_the_mooses_loose |\n| aria_test2           |\n+----------------------+\n\nShowing tables and table types:\n\nSHOW FULL TABLES;\n+----------------+------------+\n| Tables_in_test | Table_type |\n+----------------+------------+\n| s1             | SEQUENCE   |\n| student        | BASE TABLE |\n| v1             | VIEW       |\n+----------------+------------+\n\nShowing temporary tables: <= MariaDB 11.1\n\nCREATE TABLE t (t int(11));\nCREATE TEMPORARY TABLE t (t int(11));\nCREATE TEMPORARY TABLE te (t int(11));\n\nSHOW TABLES;\n+----------------+\n| Tables_in_test |\n+----------------+\n| t              |\n+----------------+\n\nFrom MariaDB 11.2.0:\n\nCREATE TABLE t (t int(11));\nCREATE TEMPORARY TABLE t (t int(11));\nCREATE TEMPORARY TABLE te (t int(11));\n\nSHOW TABLES;\n+----------------+\n| Tables_in_test |\n+----------------+\n| te             |\n| t              |\n| t              |\n+----------------+\n\nURL: https://mariadb.com/kb/en/show-tables/','','https://mariadb.com/kb/en/show-tables/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (398,26,'SHOW TABLE_STATISTICS','Syntax\n------\n\nSHOW TABLE_STATISTICS\n\nDescription\n-----------\n\nThe SHOW TABLE_STATISTICS statementis part of the User Statistics feature. It\nwas removed as a separate statement in MariaDB 10.1.1, but effectively\nreplaced by the generic SHOW information_schema_table statement. The\ninformation_schema.TABLE_STATISTICS table shows statistics on table usage\n\nThe userstat system variable must be set to 1 to activate this feature. See\nthe User Statistics and information_schema.TABLE_STATISTICS articles for more\ninformation.\n\nExample\n-------\n\nSHOW TABLE_STATISTICS\\G\n*************************** 1. row ***************************\n     Table_schema: mysql\n      Table_name: proxies_priv\n       Rows_read: 2\n     Rows_changed: 0\nRows_changed_x_#indexes: 0\n*************************** 2. row ***************************\n     Table_schema: test\n      Table_name: employees_example\n       Rows_read: 7\n     Rows_changed: 0\nRows_changed_x_#indexes: 0\n*************************** 3. row ***************************\n     Table_schema: mysql\n      Table_name: user\n       Rows_read: 16\n     Rows_changed: 0\nRows_changed_x_#indexes: 0\n*************************** 4. row ***************************\n     Table_schema: mysql\n      Table_name: db\n       Rows_read: 2\n     Rows_changed: 0\nRows_changed_x_#indexes: 0\n\nURL: https://mariadb.com/kb/en/show-table-statistics/','','https://mariadb.com/kb/en/show-table-statistics/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (399,26,'SHOW TRIGGERS','Syntax\n------\n\nSHOW TRIGGERS [FROM db_name]\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nSHOW TRIGGERS lists the triggers currently defined for tables in a database\n(the default database unless a FROM clause is given). This statement requires\nthe TRIGGER privilege (prior to MySQL 5.1.22, it required the SUPER privilege).\n\nThe LIKE clause, if present on its own, indicates which table names to match\nand causes the statement to display triggers for those tables. The WHERE and\nLIKE clauses can be given to select rows using more general conditions, as\ndiscussed in Extended SHOW.\n\nSimilar information is stored in the information_schema.TRIGGERS table.\n\nMariaDB starting with 10.2.3\n----------------------------\nIf there are multiple triggers for the same action, then the triggers are\nshown in action order.\n\nExamples\n--------\n\nFor the trigger defined at Trigger Overview:\n\nSHOW triggers Like \'animals\' \\G\n*************************** 1. row ***************************\n      Trigger: the_mooses_are_loose\n       Event: INSERT\n       Table: animals\n     Statement: BEGIN\n IF NEW.name = \'Moose\' THEN\n UPDATE animal_count SET animal_count.animals = animal_count.animals+100;\n ELSE \n UPDATE animal_count SET animal_count.animals = animal_count.animals+1;\n END IF;\nEND\n       Timing: AFTER\n      Created: 2016-09-29 13:53:34.35\n      sql_mode:\n      Definer: root@localhost\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\nListing all triggers associated with a certain table:\n\nSHOW TRIGGERS FROM test WHERE `Table` = \'user\' \\G\n*************************** 1. row ***************************\n      Trigger: user_ai\n       Event: INSERT\n       Table: user\n     Statement: BEGIN END\n       Timing: AFTER\n      Created:  2016-09-29 13:53:34.35\n      sql_mode:\n      Definer: root@%\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\nSHOW triggers WHERE Event Like \'Insert\' \\G\n*************************** 1. row ***************************\n      Trigger: the_mooses_are_loose\n       Event: INSERT\n       Table: animals\n     Statement: BEGIN\n IF NEW.name = \'Moose\' THEN\n UPDATE animal_count SET animal_count.animals = animal_count.animals+100;\n ELSE \n UPDATE animal_count SET animal_count.animals = animal_count.animals+1;\n END IF;\nEND\n       Timing: AFTER\n      Created: 2016-09-29 13:53:34.35\n      sql_mode:\n      Definer: root@localhost\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n\n* character_set_client is the session value of the character_set_client system\nvariable when the trigger was created. \n* collation_connection is the session value of the collation_connection system\nvariable when the trigger was\n created. \n* Database Collation is the collation of the database \n with which the trigger is associated.\n\nThese columns were added in MariaDB/MySQL 5.1.21.\n\nOld triggers created before MySQL 5.7 and MariaDB 10.2.3 has NULL in the\nCreated column.\n\nURL: https://mariadb.com/kb/en/show-triggers/','','https://mariadb.com/kb/en/show-triggers/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (400,26,'SHOW USER_STATISTICS','Syntax\n------\n\nSHOW USER_STATISTICS\n\nDescription\n-----------\n\nThe SHOW USER_STATISTICS statement is part of the User Statistics feature. It\nwas removed as a separate statement in MariaDB 10.1.1, but effectively\nreplaced by the generic SHOW information_schema_table statement. The\ninformation_schema.USER_STATISTICS table holds statistics about user activity.\nYou can use this table to find out such things as which user is causing the\nmost load and which users are being abusive. You can also use this table to\nmeasure how close to capacity the server may be.\n\nThe userstat system variable must be set to 1 to activate this feature. See\nthe User Statistics and information_schema.USER_STATISTICS table for more\ninformation.\n\nExample\n-------\n\nSHOW USER_STATISTICS\\G\n*************************** 1. row ***************************\n         User: root\n  Total_connections: 1\nConcurrent_connections: 0\n    Connected_time: 3297\n      Busy_time: 0.14113400000000006\n       Cpu_time: 0.017637000000000003\n    Bytes_received: 969\n      Bytes_sent: 22355\n Binlog_bytes_written: 0\n      Rows_read: 10\n      Rows_sent: 67\n     Rows_deleted: 0\n    Rows_inserted: 0\n     Rows_updated: 0\n   Select_commands: 7\n   Update_commands: 0\n    Other_commands: 0\n Commit_transactions: 1\n Rollback_transactions: 0\n  Denied_connections: 0\n   Lost_connections: 0\n    Access_denied: 0\n    Empty_queries: 7\n\nURL: https://mariadb.com/kb/en/show-user-statistics/','','https://mariadb.com/kb/en/show-user-statistics/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (401,26,'SHOW VARIABLES','Syntax\n------\n\nSHOW [GLOBAL | SESSION] VARIABLES\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nSHOW VARIABLES shows the values of MariaDB system variables. This information\nalso can be obtained using the mariadb-admin variables command. The LIKE\nclause, if present, indicates which variable names to match. The WHERE clause\ncan be given to select rows using more general conditions.\n\nWith the GLOBAL modifier, SHOW VARIABLES displays the values that are used for\nnew connections to MariaDB. With SESSION, it displays the values that are in\neffect for the current connection. If no modifier is present, the default is\nSESSION. LOCAL is a synonym for SESSION. With a LIKE clause, the statement\ndisplays only rows for those variables with names that match the pattern. To\nobtain the row for a specific variable, use a LIKE clause as shown:\n\nSHOW VARIABLES LIKE \'maria_group_commit\';\nSHOW SESSION VARIABLES LIKE \'maria_group_commit\';\n\nTo get a list of variables whose name match a pattern, use the \"%\" wildcard\ncharacter in a LIKE clause:\n\nSHOW VARIABLES LIKE \'%maria%\';\nSHOW GLOBAL VARIABLES LIKE \'%maria%\';\n\nWildcard characters can be used in any position within the pattern to be\nmatched. Strictly speaking, because \"_\" is a wildcard that matches any single\ncharacter, you should escape it as \"\\_\" to match it literally. In practice,\nthis is rarely necessary.\n\nThe WHERE and LIKE clauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW.\n\nSee SET for information on setting server system variables.\n\nSee Server System Variables for a list of all the variables that can be set.\n\nYou can also see the server variables by querying the Information Schema\nGLOBAL_VARIABLES and SESSION_VARIABLES tables.\n\nExamples\n--------\n\nSHOW VARIABLES LIKE \'aria%\';\n+------------------------------------------+---------------------+\n| Variable_name                            | Value               |\n+------------------------------------------+---------------------+\n| aria_block_size                          | 8192                |\n| aria_checkpoint_interval                 | 30                  |\n| aria_checkpoint_log_activity             | 1048576             |\n| aria_force_start_after_recovery_failures | 0                   |\n| aria_group_commit                        | none                |\n| aria_group_commit_interval               | 0                   |\n| aria_log_file_size                       | 1073741824          |\n| aria_log_purge_type                      | immediate           |\n| aria_max_sort_file_size                  | 9223372036853727232 |\n| aria_page_checksum                       | ON                  |\n| aria_pagecache_age_threshold             | 300                 |\n| aria_pagecache_buffer_size               | 134217728           |\n| aria_pagecache_division_limit            | 100                 |\n| aria_recover                             | NORMAL              |\n| aria_repair_threads                      | 1                   |\n| aria_sort_buffer_size                    | 134217728           |\n| aria_stats_method                        | nulls_unequal       |\n| aria_sync_log_dir                        | NEWFILE             |\n| aria_used_for_temp_tables                | ON                  |\n+------------------------------------------+---------------------+\n\nSELECT VARIABLE_NAME, SESSION_VALUE, GLOBAL_VALUE FROM\n INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE\n VARIABLE_NAME LIKE \'max_error_count\' OR\n VARIABLE_NAME LIKE \'innodb_sync_spin_loops\';\n+---------------------------+---------------+--------------+\n| VARIABLE_NAME             | SESSION_VALUE | GLOBAL_VALUE |\n+---------------------------+---------------+--------------+\n| MAX_ERROR_COUNT           | 64            | 64           |\n| INNODB_SYNC_SPIN_LOOPS    | NULL          | 30           |\n+---------------------------+---------------+--------------+\n\nSET GLOBAL max_error_count=128;\n\nSELECT VARIABLE_NAME, SESSION_VALUE, GLOBAL_VALUE FROM\n INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE\n VARIABLE_NAME LIKE \'max_error_count\' OR\n VARIABLE_NAME LIKE \'innodb_sync_spin_loops\';\n+---------------------------+---------------+--------------+\n| VARIABLE_NAME             | SESSION_VALUE | GLOBAL_VALUE |\n+---------------------------+---------------+--------------+\n| MAX_ERROR_COUNT           | 64            | 128          |\n| INNODB_SYNC_SPIN_LOOPS    | NULL          | 30           |\n+---------------------------+---------------+--------------+\n\nSET GLOBAL max_error_count=128;\n\nSHOW VARIABLES LIKE \'max_error_count\';\n+-----------------+-------+\n| Variable_name   | Value |\n+-----------------+-------+\n| max_error_count | 64    |\n+-----------------+-------+\n\nSHOW GLOBAL VARIABLES LIKE \'max_error_count\';\n+-----------------+-------+\n| Variable_name   | Value |\n+-----------------+-------+\n| max_error_count | 128   |\n+-----------------+-------+\n\nBecause the following variable only has a global scope, the global value is\nreturned even when specifying SESSION (in this case by default):\n\nSHOW VARIABLES LIKE \'innodb_sync_spin_loops\';\n+------------------------+-------+\n| Variable_name          | Value |\n+------------------------+-------+\n| innodb_sync_spin_loops | 30    |\n+------------------------+-------+\n\nURL: https://mariadb.com/kb/en/show-variables/','','https://mariadb.com/kb/en/show-variables/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (402,26,'SHOW WARNINGS','Syntax\n------\n\nSHOW WARNINGS [LIMIT [offset,] row_count]\nSHOW ERRORS [LIMIT row_count OFFSET offset]\nSHOW COUNT(*) WARNINGS\n\nDescription\n-----------\n\nSHOW WARNINGS shows the error, warning, and note messages that resulted from\nthe last statement that generated messages in the current session. It shows\nnothing if the last statement used a table and generated no messages. (That\nis, a statement that uses a table but generates no messages clears the message\nlist.) Statements that do not use tables and do not generate messages have no\neffect on the message list.\n\nA note is different to a warning in that it only appears if the sql_notes\nvariable is set to 1 (the default), and is not converted to an error if strict\nmode is enabled.\n\nA related statement, SHOW ERRORS, shows only the errors.\n\nThe SHOW COUNT(*) WARNINGS statement displays the total number of errors,\nwarnings, and notes. You can also retrieve this number from the warning_count\nvariable:\n\nSHOW COUNT(*) WARNINGS;\nSELECT @@warning_count;\n\nThe value of warning_count might be greater than the number of messages\ndisplayed by SHOW WARNINGS if the max_error_count system variable is set so\nlow that not all messages are stored.\n\nThe LIMIT clause has the same syntax as for the SELECT statement.\n\nSHOW WARNINGS can be used after EXPLAIN EXTENDED to see how a query is\ninternally rewritten by MariaDB.\n\nIf the sql_notes server variable is set to 1, Notes are included in the output\nof SHOW WARNINGS; if it is set to 0, this statement will not show (or count)\nNotes.\n\nThe results of SHOW WARNINGS and SHOW COUNT(*) WARNINGS are directly sent to\nthe client. If you need to access those information in a stored program, you\ncan use the GET DIAGNOSTICS statement instead.\n\nFor a list of MariaDB error codes, see MariaDB Error Codes.\n\nThe mariadb client also has a number of options related to warnings. The \\W\ncommand will show warnings after every statement, while \\w will disable this.\nStarting the client with the --show-warnings option will show warnings after\nevery statement.\n\nMariaDB implements a stored routine error stack trace. SHOW WARNINGS can also\nbe used to show more information. See the example below.\n\nExamples\n--------\n\nSELECT 1/0;\n+------+\n| 1/0  |\n+------+\n| NULL |\n+------+\n\nSHOW COUNT(*) WARNINGS;\n+-------------------------+\n| @@session.warning_count |\n+-------------------------+\n|                       1 |\n+-------------------------+\n\nSHOW WARNINGS;\n+---------+------+---------------+\n| Level   | Code | Message       |\n+---------+------+---------------+\n| Warning | 1365 | Division by 0 |\n+---------+------+---------------+\n\nStack Trace\n-----------\n\nDisplaying a stack trace:\n\nDELIMITER $$\nCREATE OR REPLACE PROCEDURE p1()\n BEGIN\n  DECLARE c CURSOR FOR SELECT * FROM not_existing;\n  OPEN c;\n  CLOSE c;\n END;\n$$\nCREATE OR REPLACE PROCEDURE p2()\n BEGIN\n  CALL p1;\n END;\n$$\nDELIMITER ;\nCALL p2;\nERROR 1146 (42S02): Table \'test.not_existing\' doesn\'t exist\n\nSHOW WARNINGS;\n+-------+------+-----------------------------------------+\n| Level | Code | Message                                 |\n+-------+------+-----------------------------------------+\n| Error | 1146 | Table \'test.not_existing\' doesn\'t exist |\n| Note  | 4091 | At line 6 in test.p1                    |\n| Note  | 4091 | At line 4 in test.p2                    |\n+-------+------+-----------------------------------------+\n\nSHOW WARNINGS displays a stack trace, showing where the error actually\nhappened:\n\n* Line 4 in test.p1 is the OPEN command which actually raised the error\n* Line 3 in test.p2 is the CALL statement, calling p1 from p2.\n\nURL: https://mariadb.com/kb/en/show-warnings/','','https://mariadb.com/kb/en/show-warnings/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (403,26,'SHOW WSREP_MEMBERSHIP','SHOW WSREP_MEMBERSHIP is part of the WSREP_INFO plugin.\n\nSyntax\n------\n\nSHOW WSREP_MEMBERSHIP\n\nDescription\n-----------\n\nThe SHOW WSREP_MEMBERSHIP statement returns Galera node cluster membership\ninformation. It returns the same information as found in the\ninformation_schema.WSREP_MEMBERSHIP table. Only users with the SUPER privilege\ncan access this information.\n\nExamples\n--------\n\nSHOW WSREP_MEMBERSHIP;\n+-------+--------------------------------------+----------+-----------------+\n| Index | Uuid                                 | Name     | Address         |\n+-------+--------------------------------------+----------+-----------------+\n|     0 | 19058073-8940-11e4-8570-16af7bf8fced | my_node1 | 10.0.2.15:16001 |\n|     1 | 19f2b0e0-8942-11e4-9cb8-b39e8ee0b5dd | my_node3 | 10.0.2.15:16003 |\n|     2 | d85e62db-8941-11e4-b1ef-4bc9980e476d | my_node2 | 10.0.2.15:16002 |\n+-------+--------------------------------------+----------+-----------------+\n\nURL: https://mariadb.com/kb/en/show-wsrep_membership/','','https://mariadb.com/kb/en/show-wsrep_membership/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (404,26,'SHOW WSREP_STATUS','SHOW WSREP_STATUS is part of the WSREP_INFO plugin.\n\nSyntax\n------\n\nSHOW WSREP_STATUS\n\nDescription\n-----------\n\nThe SHOW WSREP_STATUS statement returns Galera node and cluster status\ninformation. It returns the same information as found in the\ninformation_schema.WSREP_STATUS table. Only users with the SUPER privilege can\naccess this information.\n\nExamples\n--------\n\nSHOW WSREP_STATUS;\n+------------+-------------+----------------+--------------+\n| Node_Index | Node_Status | Cluster_Status | Cluster_Size |\n+------------+-------------+----------------+--------------+\n|          0 | Synced      | Primary        |            3 |\n+------------+-------------+----------------+--------------+\n\nURL: https://mariadb.com/kb/en/show-wsrep_status/','','https://mariadb.com/kb/en/show-wsrep_status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (405,26,'BINLOG','Syntax\n------\n\nBINLOG \'str\'\n\nDescription\n-----------\n\nBINLOG is an internal-use statement. It is generated by the mariadb-binlog\nprogram as the printable representation of certain events in binary log files.\nThe \'str\' value is a base 64-encoded string that the server decodes to\ndetermine the data change indicated by the corresponding event. This statement\nrequires the SUPER privilege (<= MariaDB 10.5.1) or the BINLOG REPLAY\nprivilege (>= MariaDB 10.5.2).\n\nURL: https://mariadb.com/kb/en/binlog/','','https://mariadb.com/kb/en/binlog/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (406,26,'PURGE BINARY LOGS','Syntax\n------\n\nPURGE { BINARY | MASTER } LOGS\n  { TO \'log_name\' | BEFORE datetime_expr }\n\nDescription\n-----------\n\nThe PURGE BINARY LOGS statement deletes all the binary log files listed in the\nlog index file prior to the specified log file name or date. BINARY and MASTER\nare synonyms. Deleted log files also are removed from the list recorded in the\nindex file, so that the given log file becomes the first in the list.\n\nThe datetime expression is in the format \'YYYY-MM-DD hh:mm:ss\'.\n\nIf a replica is active but has yet to read from a binary log file you attempt\nto delete, the statement will fail with an error. However, if the replica is\nnot connected and has yet to read from a log file you delete, the file will be\ndeleted, but the replica will be unable to continue replicating once it\nconnects again.\n\nThis statement has no effect if the server was not started with the --log-bin\noption to enable binary logging.\n\nTo list the binary log files on the server, use SHOW BINARY LOGS. To see which\nfiles they are reading, use SHOW SLAVE STATUS (or SHOW REPLICA STATUS from\nMariaDB 10.5.1). You can only delete the files that are older than the oldest\nfile that is used by the slaves.\n\nTo delete all binary log files, use RESET MASTER. To move to a new log file\n(for example if you want to remove the current log file), use FLUSH LOGS\nbefore you execute PURGE LOGS.\n\nIf the expire_logs_days server system variable is not set to 0, the server\nautomatically deletes binary log files after the given number of days. From\nMariaDB 10.6, the binlog_expire_logs_seconds variable allows more precise\ncontrol over binlog deletion, and takes precedence if both are non-zero.\n\nRequires the SUPER privilege or, from MariaDB 10.5.2, the BINLOG ADMIN\nprivilege, to run.\n\nExamples\n--------\n\nPURGE BINARY LOGS TO \'mariadb-bin.000063\';\n\nPURGE BINARY LOGS BEFORE \'2013-04-21\';\n\nPURGE BINARY LOGS BEFORE \'2013-04-22 09:55:22\';\n\nURL: https://mariadb.com/kb/en/purge-binary-logs/','','https://mariadb.com/kb/en/purge-binary-logs/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (407,26,'CACHE INDEX','Syntax\n------\n\nCACHE INDEX                      \n tbl_index_list [, tbl_index_list] ...\n IN key_cache_name\n\ntbl_index_list:\n tbl_name [[INDEX|KEY] (index_name[, index_name] ...)]\n\nDescription\n-----------\n\nThe CACHE INDEX statement assigns table indexes to a specific key cache. It is\nused only for MyISAM tables.\n\nA default key cache exists and cannot be destroyed. To create more key caches,\nthe key_buffer_size server system variable.\n\nThe associations between tables indexes and key caches are lost on server\nrestart. To recreate them automatically, it is necessary to configure caches\nin a configuration file and include some CACHE INDEX (and optionally LOAD\nINDEX) statements in the init file.\n\nExamples\n--------\n\nThe following statement assigns indexes from the tables t1, t2, and t3 to the\nkey cache named hot_cache:\n\nCACHE INDEX t1, t2, t3 IN hot_cache;\n+---------+--------------------+----------+----------+\n| Table   | Op                 | Msg_type | Msg_text |\n+---------+--------------------+----------+----------+\n| test.t1 | assign_to_keycache | status   | OK       |\n| test.t2 | assign_to_keycache | status   | OK       |\n| test.t3 | assign_to_keycache | status   | OK       |\n+---------+--------------------+----------+----------+\n\nImplementation (for MyISAM)\n---------------------------\n\nNormally CACHE INDEX should not take a long time to execute. Internally it\'s\nimplemented the following way:\n\n* Find the right key cache (under LOCK_global_system_variables)\n* Open the table with a TL_READ_NO_INSERT lock.\n* Flush the original key cache for the given file (under key cache lock)\n* Flush the new key cache for the given file (safety)\n* Move the file to the new key cache (under file share lock)\n\nThe only possible long operations are getting the locks for the table and\nflushing the original key cache, if there were many key blocks for the file in\nit.\n\nWe plan to also add CACHE INDEX for Aria tables if there is a need for this.\n\nURL: https://mariadb.com/kb/en/cache-index/','','https://mariadb.com/kb/en/cache-index/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (408,26,'HELP Command','Syntax\n------\n\nHELP search_string\n\nDescription\n-----------\n\nThe HELP command can be used in any MariaDB client, such as the mariadb\ncommand-line client, to get basic syntax help and a short description for most\ncommands and functions.\n\nIf you provide an argument to the HELP command, the mariadb client uses it as\na search string to access server-side help. The proper operation of this\ncommand requires that the help tables in the mysql database be initialized\nwith help topic information.\n\nIf there is no match for the search string, the search fails. Use HELP\ncontents to see a list of the help categories:\n\nHELP contents\nYou asked for help about help category: \"Contents\"\nFor more information, type \'help <item>\', where <item> is one of the following\ncategories:\n Account Management\n Administration\n Compound Statements\n Data Definition\n Data Manipulation\n Data Types\n Functions\n Functions and Modifiers for Use with GROUP BY\n Geographic Features\n Help Metadata\n Language Structure\n Plugins\n Procedures\n Sequences\n Table Maintenance\n Transactions\n User-Defined Functions\n Utility\n\nIf a search string matches multiple items, MariaDB shows a list of matching\ntopics:\n\nHELP drop\nMany help items for your request exist.\nTo make a more specific request, please type \'help <item>\',\nwhere <item> is one of the following\ntopics:\n ALTER TABLE\n DROP DATABASE\n DROP EVENT\n DROP FUNCTION\n DROP FUNCTION UDF\n DROP INDEX\n DROP PACKAGE\n DROP PACKAGE BODY\n DROP PROCEDURE\n DROP ROLE\n DROP SEQUENCE\n DROP SERVER\n DROP TABLE\n DROP TRIGGER\n DROP USER\n DROP VIEW\n\nThen you can enter a topic as the search string to see the help entry for that\ntopic.\n\nThe help is provided with the MariaDB server and makes use of four help tables\nfound in the mysql database: help_relation, help_topic, help_category and\nhelp_keyword. These tables are populated by the mariadb-install-db or\nfill_help_table.sql scripts.\n\nURL: https://mariadb.com/kb/en/help-command/','','https://mariadb.com/kb/en/help-command/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (409,26,'KILL [CONNECTION | QUERY]','Syntax\n------\n\nKILL [HARD | SOFT] { {CONNECTION|QUERY} thread_id | QUERY ID query_id | USER\nuser_name }\n\nDescription\n-----------\n\nEach connection to mysqld runs in a separate thread. You can see which threads\nare running with the SHOW PROCESSLIST statement and kill a thread with the\nKILL thread_id statement. KILL allows the optional CONNECTION or QUERY\nmodifier:\n\n* KILL CONNECTION is the same as KILL with no\n modifier: It terminates the connection associated with the given thread or\nquery id.\n* KILL QUERY terminates the statement that the connection thread_id is\n currently executing, but leaves the connection itself intact.\n* KILL QUERY ID terminates the query by query_id, leaving the connection\nintact.\n\nIf a connection is terminated that has an active transaction, the transaction\nwill be rolled back. If only a query is killed, the current transaction will\nstay active. See also idle_transaction_timeout.\n\nIf you have the PROCESS privilege, you can see all threads. If you have the\nSUPER privilege, or, from MariaDB 10.5.2, the CONNECTION ADMIN privilege, you\ncan kill all threads and statements. Otherwise, you can see and kill only your\nown threads and statements.\n\nKilling queries that repair or create indexes on MyISAM and Aria tables may\nresult in corrupted tables. Use the SOFT option to avoid this!\n\nThe HARD option (default) kills a command as soon as possible. If you use\nSOFT, then critical operations that may leave a table in an inconsistent state\nwill not be interrupted. Such operations include REPAIR and INDEX creation for\nMyISAM and Aria tables (REPAIR TABLE, OPTIMIZE TABLE).\n\nKILL ... USER username will kill all connections/queries for a given user.\nUSER can be specified one of the following ways:\n\n* username  (Kill without regard to hostname)\n* username@hostname\n* CURRENT_USER or CURRENT_USER()\n\nIf you specify a thread id and that thread does not exist, you get the\nfollowing error:\n\nERROR 1094 (HY000): Unknown thread id: <thread_id>\n\nIf you specify a query id that doesn\'t exist, you get the following error:\n\nERROR 1957 (HY000): Unknown query id: <query_id>\n\nHowever, if you specify a user name, no error is issued for non-connected (or\neven non-existing) users. To check if the connection/query has been killed,\nyou can use the ROW_COUNT() function.\n\nA client whose connection is killed receives the following error:\n\nERROR 1317 (70100): Query execution was interrupted\n\nTo obtain a list of existing sessions, use the SHOW PROCESSLIST statement or\nquery the Information Schema PROCESSLIST table.\n\nNote: You cannot use KILL with the Embedded MariaDB Server library because the\nembedded server merely runs inside the threads of the host application. It\ndoes not create any connection threads of its own.\n\nNote: You can also use mariadb-admin kill thread_id [,thread_id...] to kill\nconnections. To get a list of running queries, use mariadb-admin processlist.\nSee mariadb-admin.\n\nPercona Toolkit contains a program, pt-kill that can be used to automatically\nkill connections that match certain criteria. For example, it can be used to\nterminate idle connections, or connections that have been busy for more than\n60 seconds.\n\nURL: https://mariadb.com/kb/en/kill/','','https://mariadb.com/kb/en/kill/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (410,26,'LOAD INDEX','Syntax\n------\n\nLOAD INDEX INTO CACHE\n tbl_index_list [, tbl_index_list] ...\n\ntbl_index_list:\n tbl_name\n  [[INDEX|KEY] (index_name[, index_name] ...)]\n  [IGNORE LEAVES]\n\nDescription\n-----------\n\nThe LOAD INDEX INTO CACHE statement preloads a table index into the key cache\nto which it has been assigned by an explicit CACHE INDEX statement, or into\nthe default key cache otherwise. LOAD INDEX INTO CACHE is used only for MyISAM\nor Aria tables.\n\nThe IGNORE LEAVES modifier causes only blocks for the nonleaf nodes of the\nindex to be preloaded.\n\nURL: https://mariadb.com/kb/en/load-index/','','https://mariadb.com/kb/en/load-index/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (411,26,'RESET','Syntax\n------\n\nRESET reset_option [, reset_option] ...\n\nDescription\n-----------\n\nThe RESET statement is used to clear the state of various server operations.\nYou must have the RELOAD privilege to execute RESET.\n\nRESET acts as a stronger version of the FLUSH statement.\n\nThe different RESET options are:\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| SLAVE                     | Deletes all relay logs from the slave and      |\n| [\"connection_name\"] [ALL] | reset the replication position in the master   |\n|                           | binary log.                                    |\n+---------------------------+------------------------------------------------+\n| MASTER                    | Deletes all old binary logs, makes the binary  |\n|                           | index file (--log-bin-index) empty and         |\n|                           | creates a new binary log file.  This is        |\n|                           | useful when you want to reset the master to    |\n|                           | an initial state. If you want to just delete   |\n|                           | old, not used binary logs, you should use the  |\n|                           | PURGE BINARY LOGS command.                     |\n+---------------------------+------------------------------------------------+\n| QUERY CACHE               | Removes all queries from the query cache. See  |\n|                           | also FLUSH QUERY CACHE.                        |\n+---------------------------+------------------------------------------------+\n\nURL: https://mariadb.com/kb/en/reset/','','https://mariadb.com/kb/en/reset/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (412,26,'SHUTDOWN','Syntax\n------\n\nSHUTDOWN [WAIT FOR ALL { SLAVES | REPLICAS } ]\n\nDescription\n-----------\n\nThe SHUTDOWN command shuts the server down.\n\nWAIT FOR ALL REPLICAS / SLAVES\n------------------------------\n\nMariaDB starting with 10.4.4\n----------------------------\nThe WAIT FOR ALL SLAVES option was first added in MariaDB 10.4.4. WAIT FOR ALL\nREPLICAS has been a synonym since MariaDB 10.5.1.\n\nWhen a primary server is shutdown and it goes through the normal shutdown\nprocess, the primary kills client threads in random order. By default, the\nprimary also considers its binary log dump threads to be regular client\nthreads. As a consequence, the binary log dump threads can be killed while\nclient threads still exist, and this means that data can be written on the\nprimary during a normal shutdown that won\'t be replicated. This is true even\nif semi-synchronous replication is being used.\n\nIn MariaDB 10.4 and later, this problem can be solved by shutting down the\nserver with the SHUTDOWN command and by providing the WAIT FOR ALL\nREPLICAS/WAIT FOR ALL SLAVES option to the command. For example:\n\nSHUTDOWN WAIT FOR ALL REPLICAS;\n\nWhen the WAIT FOR ALL REPLICAS option is provided, the server only kills its\nbinary log dump threads after all client threads have been killed, and it only\ncompletes the shutdown after the last binary log has been sent to all\nconnected replicas.\n\nSee Replication Threads: Binary Log Dump Threads and the Shutdown Process for\nmore information.\n\nRequired Permissions\n--------------------\n\nOne must have a SHUTDOWN privilege (see GRANT) to use this command. It is the\nsame privilege one needs to use the mariadb-admin shutdown command.\n\nShutdown for Upgrades\n---------------------\n\nIf you are doing a shutdown to migrate to another major version of MariaDB,\nplease ensure that the innodb_fast_shutdown variable is not 2 (fast crash\nshutdown). The default of this variable is 1.\n\nExample\n-------\n\nThe following example shows how to create an event which turns off the server\nat a certain time:\n\nCREATE EVENT `test`.`shutd`\n  ON SCHEDULE\n    EVERY 1 DAY\n    STARTS \'2014-01-01 20:00:00\'\n  COMMENT \'Shutdown Maria when the office is closed\'\nDO BEGIN\n  SHUTDOWN;\nEND;\n\nOther Ways to Stop mysqld\n-------------------------\n\nYou can use the mariadb-admin shutdown command to take down mysqld cleanly.\n\nYou can also use the system kill command on Unix with signal SIGTERM (15)\n\nkill -SIGTERM pid-of-mysqld-process\n\nYou can find the process number of the server process in the file that ends\nwith .pid in your data directory.\n\nThe above is identical to mariadb-admin shutdown.\n\nOn windows you should use:\n\nNET STOP MySQL\n\nURL: https://mariadb.com/kb/en/shutdown/','','https://mariadb.com/kb/en/shutdown/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (413,26,'USE [DATABASE]','Syntax\n------\n\nUSE db_name\n\nIn MariaDB 11.3 one can also use\n\nUSE DATABASE db_name;\n\nDescription\n-----------\n\nThe \'USE db_name\' statement tells MariaDB to use the db_name database as the\ndefault (current) database for subsequent statements. The database remains the\ndefault until the end of the session or another USE statement is issued:\n\nUSE db1;\nSELECT COUNT(*) FROM mytable;   # selects from db1.mytable\nUSE db2;\nSELECT COUNT(*) FROM mytable;   # selects from db2.mytable\n\nThe DATABASE() function (SCHEMA() is a synonym) returns the default database.\n\nAnother way to set the default database is specifying its name at mariadb\ncommand line client startup.\n\nOne cannot use USE DATABASE to a database one has no privileges to. The reason\nis that a user with no privileges to a database should not be able to know if\na database exists or not.\n\nURL: https://mariadb.com/kb/en/use-database/','','https://mariadb.com/kb/en/use-database/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (414,26,'SHOW FUNCTION CODE','Syntax\n------\n\nSHOW FUNCTION CODE func_name\n\nDescription\n-----------\n\nSHOW FUNCTION CODE shows a representation of the internal implementation of\nthe stored function.\n\nIt is similar to SHOW PROCEDURE CODE but for stored functions.\n\nURL: https://mariadb.com/kb/en/show-function-code/','','https://mariadb.com/kb/en/show-function-code/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (415,26,'SHOW COLLATION','Syntax\n------\n\nSHOW COLLATION\n  [LIKE \'pattern\' | WHERE expr]\n\nDescription\n-----------\n\nThe output from SHOW COLLATION includes all available collations. The LIKE\nclause, if present on its own, indicates which collation names to match. The\nWHERE and LIKE clauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW.\n\nThe same information can be queried from the Information Schema COLLATIONS\ntable.\n\nSee Setting Character Sets and Collations for details on specifying the\ncollation at the server, database, table and column levels.\n\nExamples\n--------\n\nSHOW COLLATION LIKE \'latin1%\';\n+-------------------------+---------+------+---------+----------+---------+\n| Collation               | Charset | Id   | Default | Compiled | Sortlen |\n+-------------------------+---------+------+---------+----------+---------+\n| latin1_german1_ci       | latin1  |    5 |         | Yes      |       1 |\n| latin1_swedish_ci       | latin1  |    8 | Yes     | Yes      |       1 |\n| latin1_danish_ci        | latin1  |   15 |         | Yes      |       1 |\n| latin1_german2_ci       | latin1  |   31 |         | Yes      |       2 |\n| latin1_bin              | latin1  |   47 |         | Yes      |       1 |\n| latin1_general_ci       | latin1  |   48 |         | Yes      |       1 |\n| latin1_general_cs       | latin1  |   49 |         | Yes      |       1 |\n| latin1_spanish_ci       | latin1  |   94 |         | Yes      |       1 |\n| latin1_swedish_nopad_ci | latin1  | 1032 |         | Yes      |       1 |\n| latin1_nopad_bin        | latin1  | 1071 |         | Yes      |       1 |\n+-------------------------+---------+------+---------+----------+---------+\n\nSHOW COLLATION WHERE Sortlen LIKE \'8\' AND Charset LIKE \'utf8mb4\';\n+------------------------------+---------+------+---------+----------+---------\n\n| Collation                    | Charset | Id   | Default | Compiled | Sortlen\n|\n+------------------------------+---------+------+---------+----------+---------\n\n| utf8mb4_unicode_ci           | utf8mb4 |  224 |         | Yes      |       8\n|\n| utf8mb4_icelandic_ci         | utf8mb4 |  225 |         | Yes      |       8\n|\n| utf8mb4_latvian_ci           | utf8mb4 |  226 |         | Yes      |       8\n|\n| utf8mb4_romanian_ci          | utf8mb4 |  227 |         | Yes      |       8\n|\n| utf8mb4_slovenian_ci         | utf8mb4 |  228 |         | Yes      |       8\n|\n| utf8mb4_polish_ci            | utf8mb4 |  229 |         | Yes      |       8\n|\n| utf8mb4_estonian_ci          | utf8mb4 |  230 |         | Yes      |       8\n|\n| utf8mb4_spanish_ci           | utf8mb4 |  231 |         | Yes      |       8\n|\n| utf8mb4_swedish_ci           | utf8mb4 |  232 |         | Yes      |       8\n|\n| utf8mb4_turkish_ci           | utf8mb4 |  233 |         | Yes      |       8\n|\n| utf8mb4_czech_ci             | utf8mb4 |  234 |         | Yes      |       8\n|\n| utf8mb4_danish_ci            | utf8mb4 |  235 |         | Yes      |       8\n|\n| utf8mb4_lithuanian_ci        | utf8mb4 |  236 |         | Yes      |       8\n|\n| utf8mb4_slovak_ci            | utf8mb4 |  237 |         | Yes      |       8\n|\n| utf8mb4_spanish2_ci          | utf8mb4 |  238 |         | Yes      |       8\n|\n| utf8mb4_roman_ci             | utf8mb4 |  239 |         | Yes      |       8\n|\n| utf8mb4_persian_ci           | utf8mb4 |  240 |         | Yes      |       8\n|\n| utf8mb4_esperanto_ci         | utf8mb4 |  241 |         | Yes      |       8\n|\n| utf8mb4_hungarian_ci         | utf8mb4 |  242 |         | Yes      |       8\n|\n| utf8mb4_sinhala_ci           | utf8mb4 |  243 |         | Yes      |       8\n|\n| utf8mb4_german2_ci           | utf8mb4 |  244 |         | Yes      |       8\n|\n| utf8mb4_croatian_mysql561_ci | utf8mb4 |  245 |         | Yes      |       8\n|\n| utf8mb4_unicode_520_ci       | utf8mb4 |  246 |         | Yes      |       8\n|\n| utf8mb4_vietnamese_ci        | utf8mb4 |  247 |         | Yes      |       8\n|\n| utf8mb4_croatian_ci          | utf8mb4 |  608 |         | Yes      |       8\n|\n| utf8mb4_myanmar_ci           | utf8mb4 |  609 |         | Yes      |       8\n|\n| utf8mb4_unicode_nopad_ci     | utf8mb4 | 1248 |         | Yes      |       8\n|\n| utf8mb4_unicode_520_nopad_ci | utf8mb4 | 1270 |         | Yes      |       8\n|\n+------------------------------+---------+------+---------+----------+---------\n\nURL: https://mariadb.com/kb/en/show-collation/','','https://mariadb.com/kb/en/show-collation/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (416,27,'DELETE','Syntax\n------\n\nSingle-table syntax:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE] \n FROM tbl_name [PARTITION (partition_list)]\n [FOR PORTION OF period FROM expr1 TO expr2]\n [WHERE where_condition]\n [ORDER BY ...]\n [LIMIT row_count]\n [RETURNING select_expr\n  [, select_expr ...]]\n\nMultiple-table syntax:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n  tbl_name[.*] [, tbl_name[.*]] ...\n  FROM table_references\n  [WHERE where_condition]\n\nOr:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n  FROM tbl_name[.*] [, tbl_name[.*]] ...\n  USING table_references\n  [WHERE where_condition]\n\nTrimming history:\n\nDELETE HISTORY\n FROM tbl_name [PARTITION (partition_list)]\n [BEFORE SYSTEM_TIME [TIMESTAMP|TRANSACTION] expression]\n\nDescription\n-----------\n\n+---------------------------+------------------------------------------------+\n| Option                    | Description                                    |\n+---------------------------+------------------------------------------------+\n| LOW_PRIORITY              | Wait until all SELECT\'s are done before        |\n|                           | starting the statement. Used with storage      |\n|                           | engines that uses table locking (MyISAM, Aria  |\n|                           | etc). See HIGH_PRIORITY and LOW_PRIORITY       |\n|                           | clauses for details.                           |\n+---------------------------+------------------------------------------------+\n| QUICK                     | Signal the storage engine that it should       |\n|                           | expect that a lot of rows are deleted. The     |\n|                           | storage engine engine can do things to speed   |\n|                           | up the DELETE like ignoring merging of data    |\n|                           | blocks until all rows are deleted from the     |\n|                           | block (instead of when a block is half full).  |\n|                           | This speeds up things at the expanse of lost   |\n|                           | space in data blocks. At least MyISAM and      |\n|                           | Aria support this feature.                     |\n+---------------------------+------------------------------------------------+\n| IGNORE                    | Don\'t stop the query even if a not-critical    |\n|                           | error occurs (like data overflow). See How     |\n|                           | IGNORE works for a full description.           |\n+---------------------------+------------------------------------------------+\n\nFor the single-table syntax, the DELETE statement deletes rows from tbl_name\nand returns a count of the number of deleted rows. This count can be obtained\nby calling the ROW_COUNT() function. The WHERE clause, if given, specifies the\nconditions that identify which rows to delete. With no WHERE clause, all rows\nare deleted. If the ORDER BY clause is specified, the rows are deleted in the\norder that is specified. The LIMIT clause places a limit on the number of rows\nthat can be deleted.\n\nFor the multiple-table syntax, DELETE deletes from each tbl_name the rows that\nsatisfy the conditions. In this case, ORDER BY and LIMIT> cannot be used. A\nDELETE can also reference tables which are located in different databases; see\nIdentifier Qualifiers for the syntax.\n\nwhere_condition is an expression that evaluates to true for each row to be\ndeleted. It is specified as described in SELECT.\n\nCurrently, you cannot delete from a table and select from the same table in a\nsubquery.\n\nYou need the DELETE privilege on a table to delete rows from it. You need only\nthe SELECT privilege for any columns that are only read, such as those named\nin the WHERE clause. See GRANT.\n\nAs stated, a DELETE statement with no WHERE clause deletes all rows. A faster\nway to do this, when you do not need to know the number of deleted rows, is to\nuse TRUNCATE TABLE. However, within a transaction or if you have a lock on the\ntable, TRUNCATE TABLE cannot be used whereas DELETE can. See TRUNCATE TABLE,\nand LOCK.\n\nPARTITION\n---------\n\nSee Partition Pruning and Selection for details.\n\nFOR PORTION OF\n--------------\n\nMariaDB starting with 10.4.3\n----------------------------\nSee Application Time Periods - Deletion by Portion.\n\nRETURNING\n---------\n\nIt is possible to return a resultset of the deleted rows for a single table to\nthe client by using the syntax DELETE ... RETURNING select_expr [,\nselect_expr2 ...]]\n\nAny of SQL expression that can be calculated from a single row fields is\nallowed. Subqueries are allowed. The AS keyword is allowed, so it is possible\nto use aliases.\n\nThe use of aggregate functions is not allowed. RETURNING cannot be used in\nmulti-table DELETEs.\n\nMariaDB starting with 10.3.1\n----------------------------\n\nSame Source and Target Table\n----------------------------\n\nUntil MariaDB 10.3.1, deleting from a table with the same source and target\nwas not possible. From MariaDB 10.3.1, this is now possible. For example:\n\nDELETE FROM t1 WHERE c1 IN (SELECT b.c1 FROM t1 b WHERE b.c2=0);\n\nMariaDB starting with 10.3.4\n----------------------------\n\nDELETE HISTORY\n--------------\n\nOne can use DELETE HISTORY to delete historical information from\nSystem-versioned tables.\n\nExamples\n--------\n\nHow to use the ORDER BY and LIMIT clauses:\n\nDELETE FROM page_hit ORDER BY timestamp LIMIT 1000000;\n\nHow to use the RETURNING clause:\n\nDELETE FROM t RETURNING f1;\n+------+\n| f1   |\n+------+\n|    5 |\n|   50 |\n|  500 |\n+------+\n\nThe following statement joins two tables: one is only used to satisfy a WHERE\ncondition, but no row is deleted from it; rows from the other table are\ndeleted, instead.\n\nDELETE post FROM blog INNER JOIN post WHERE blog.id = post.blog_id;\n\nDeleting from the Same Source and Target\n----------------------------------------\n\nCREATE TABLE t1 (c1 INT, c2 INT);\nDELETE FROM t1 WHERE c1 IN (SELECT b.c1 FROM t1 b WHERE b.c2=0);\n\nUntil MariaDB 10.3.1, this returned:\n\nERROR 1093 (HY000): Table \'t1\' is specified twice, both as a target for\n\'DELETE\' \n and as a separate source for\n\nFrom MariaDB 10.3.1:\n\nQuery OK, 0 rows affected (0.00 sec)\n\nURL: https://mariadb.com/kb/en/delete/','','https://mariadb.com/kb/en/delete/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (417,27,'REPLACE','Syntax\n------\n\nREPLACE [LOW_PRIORITY | DELAYED]\n [INTO] tbl_name [PARTITION (partition_list)] [(col,...)]\n {VALUES | VALUE} ({expr | DEFAULT},...),(...),...\n[RETURNING select_expr \n   [, select_expr ...]]\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n  [INTO] tbl_name [PARTITION (partition_list)]\n  SET col={expr | DEFAULT}, ...\n[RETURNING select_expr \n   [, select_expr ...]]\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n  [INTO] tbl_name [PARTITION (partition_list)] [(col,...)]\n  SELECT ...\n[RETURNING select_expr \n   [, select_expr ...]]\n\nDescription\n-----------\n\nREPLACE works exactly like INSERT, except that if an old row in the table has\nthe same value as a new row for a PRIMARY KEY or a UNIQUE index, the old row\nis deleted before the new row is inserted. If the table has more than one\nUNIQUE keys, it is possible that the new row conflicts with more than one row.\nIn this case, all conflicting rows will be deleted.\n\nThe table name can be specified in the form db_name.tbl_name or, if a default\ndatabase is selected, in the form tbl_name (see Identifier Qualifiers). This\nallows to use REPLACE ... SELECT to copy rows between different databases.\n\nMariaDB starting with 10.5.0\n----------------------------\nThe RETURNING clause was introduced in MariaDB 10.5.0\n\nBasically it works like this:\n\nBEGIN;\nSELECT 1 FROM t1 WHERE key=# FOR UPDATE;\nIF found-row\n DELETE FROM t1 WHERE key=# ;\nENDIF\nINSERT INTO t1 VALUES (...);\nEND;\n\nThe above can be replaced with:\n\nREPLACE INTO t1 VALUES (...)\n\nREPLACE is a MariaDB/MySQL extension to the SQL standard. It either inserts,\nor deletes and inserts. For other MariaDB/MySQL extensions to standard SQL ---\nthat also handle duplicate values --- see IGNORE and INSERT ON DUPLICATE KEY\nUPDATE.\n\nNote that unless the table has a PRIMARY KEY or UNIQUE index, using a REPLACE\nstatement makes no sense. It becomes equivalent to INSERT, because there is no\nindex to be used to determine whether a new row duplicates another.\n\nValues for all columns are taken from the values sSee Partition Pruning and\nSelection for details.pecified in the REPLACE statement. Any missing columns\nare set to their default values, just as happens for INSERT. You cannot refer\nto values from the current row and use them in the new row. If you use an\nassignment such as \'SET col = col + 1\', the reference to the column name on\nthe right hand side is treated as DEFAULT(col), so the assignment is\nequivalent to \'SET col = DEFAULT(col) + 1\'.\n\nTo use REPLACE, you must have both the INSERT and DELETE privileges for the\ntable.\n\nThere are some gotchas you should be aware of, before using REPLACE:\n\n* If there is an AUTO_INCREMENT field, a new value will be generated.\n* If there are foreign keys, ON DELETE action will be activated by REPLACE.\n* Triggers on DELETE and INSERT will be activated by REPLACE.\n\nTo avoid some of these behaviors, you can use INSERT ... ON DUPLICATE KEY\nUPDATE.\n\nThis statement activates INSERT and DELETE triggers. See Trigger Overview for\ndetails.\n\nPARTITION\n---------\n\nSee Partition Pruning and Selection for details.\n\nREPLACE RETURNING\n-----------------\n\nREPLACE ... RETURNING returns a resultset of the replaced rows.\n\nThis returns the listed columns for all the rows that are replaced, or\nalternatively, the specified SELECT expression. Any SQL expressions which can\nbe calculated can be used in the select expression for the RETURNING clause,\nincluding virtual columns and aliases, expressions which use various operators\nsuch as bitwise, logical and arithmetic operators, string functions, date-time\nfunctions, numeric functions, control flow functions, secondary functions and\nstored functions. Along with this, statements which have subqueries and\nprepared statements can also be used.\n\nExamples\n--------\n\nSimple REPLACE statement\n\nREPLACE INTO t2 VALUES (1,\'Leopard\'),(2,\'Dog\') RETURNING id2, id2+id2 \nas Total ,id2|id2, id2&&id2;\n+-----+-------+---------+----------+\n| id2 | Total | id2|id2 | id2&&id2 |\n+-----+-------+---------+----------+\n|   1 |     2 |       1 |        1 |\n|   2 |     4 |       2 |        1 |\n+-----+-------+---------+----------+\n\nUsing stored functions in RETURNING\n\nDELIMITER |\nCREATE FUNCTION f(arg INT) RETURNS INT\n  BEGIN\n   RETURN (SELECT arg+arg);\n  END|\n\nDELIMITER ;\nPREPARE stmt FROM \"REPLACE INTO t2 SET id2=3, animal2=\'Fox\' RETURNING f2(id2),\nUPPER(animal2)\";\n\nEXECUTE stmt;\n+---------+----------------+\n| f2(id2) | UPPER(animal2) |\n+---------+----------------+\n|       6 | FOX            |\n+---------+----------------+\n\nSubqueries in the statement\n\nREPLACE INTO t1 SELECT * FROM t2 RETURNING (SELECT id2 FROM t2 WHERE \nid2 IN (SELECT id2 FROM t2 WHERE id2=1)) AS new_id;\n+--------+\n| new_id |\n+--------+\n|      1 |\n|      1 |\n|      1 |\n|      1 |\n+--------+\n\nSubqueries in the RETURNING clause that return more than one row or column\ncannot be used..\n\nAggregate functions cannot be used in the RETURNING clause. Since aggregate\nfunctions work on a set of values and if the purpose is to get the row count,\nROW_COUNT() with SELECT can be used, or it can be used in REPLACE...SEL==\nDescription\n\nREPLACE ... RETURNING returns a resultset of the replaced rows.\n\nThis returns the listed columns for all the rows that are replaced, or\nalternatively, the specified SELECT expression. Any SQL expressions which can\nbe calculated can be used in the select expression for the RETURNING clause,\nincluding virtual columns and aliases, expressions which use various operators\nsuch as bitwise, logical and arithmetic operators, string functions, date-time\nfunctions, numeric functions, control flow functions, secondary functions and\nstored functions. Along with this, statements which have subqueries and\nprepared statements can also be used.\n\nExamples\n--------\n\nSimple REPLACE statement\n\nREPLACE INTO t2 VALUES (1,\'Leopard\'),(2,\'Dog\') RETURNING id2, id2+id2 \nas Total ,id2|id2, id2&&id2;\n+-----+-------+---------+----------+\n| id2 | Total | id2|id2 | id2&&id2 |\n+-----+-------+---------+----------+\n|   1 |     2 |       1 |        1 |\n|   2 |     4 |       2 |        1 |\n+-----+-------+---------+----------+\n\nUsing stored functions in RETURNING\n\nDELIMITER |\nCREATE FUNCTION f(arg INT) RETURNS INT\n  BEGIN\n   RETURN (SELECT arg+arg);\n  END|\n\nDELIMITER ;\nPREPARE stmt FROM \"REPLACE INTO t2 SET id2=3, animal2=\'Fox\' RETURNING f2(id2),\nUPPER(animal2)\";\n\nEXECUTE stmt;\n+---------+----------------+\n| f2(id2) | UPPER(animal2) |\n+---------+----------------+\n|       6 | FOX            |\n+---------+----------------+\n\nSubqueries in the statement\n\nREPLACE INTO t1 SELECT * FROM t2 RETURNING (SELECT id2 FROM t2 WHERE \nid2 IN (SELECT id2 FROM t2 WHERE id2=1)) AS new_id;\n+--------+\n| new_id |\n+--------+\n|      1 |\n|      1 |\n|      1 |\n|      1 |\n+--------+\n\nSubqueries in the RETURNING clause that return more than one row or column\ncannot be used..\n\nAggregate functions cannot be used in the RETURNING clause. Since aggregate\nfunctions work on a set of values and if the purpose is to get the row count,\nROW_COUNT() with SELECT can be used, or it can be used in\nREPLACE...SELECT...RETURNING if the table in the RETURNING clause is not the\nsame as the REPLACE table. ECT...RETURNING if the table in the RETURNING\nclause is not the same as the REPLACE table.\n\nURL: https://mariadb.com/kb/en/replace/','','https://mariadb.com/kb/en/replace/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (418,27,'UPDATE','Syntax\n------\n\nSingle-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_reference \n [PARTITION (partition_list)]\n [FOR PORTION OF period FROM expr1 TO expr2]\n SET col1={expr1|DEFAULT} [,col2={expr2|DEFAULT}] ...\n [WHERE where_condition]\n [ORDER BY ...]\n [LIMIT row_count]\n\nMultiple-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_references\n  SET col1={expr1|DEFAULT} [, col2={expr2|DEFAULT}] ...\n  [WHERE where_condition]\n\nDescription\n-----------\n\nFor the single-table syntax, the UPDATE statement updates columns of existing\nrows in the named table with new values. The SET clause indicates which\ncolumns to modify and the values they should be given. Each value can be given\nas an expression, or the keyword DEFAULT to set a column explicitly to its\ndefault value. The WHERE clause, if given, specifies the conditions that\nidentify which rows to update. With no WHERE clause, all rows are updated. If\nthe ORDER BY clause is specified, the rows are updated in the order that is\nspecified. The LIMIT clause places a limit on the number of rows that can be\nupdated.\n\nUntil MariaDB 10.3.2, for the multiple-table syntax, UPDATE updates rows in\neach table named in table_references that satisfy the conditions. In this\ncase, ORDER BY and LIMIT cannot be used. This restriction was lifted in\nMariaDB 10.3.2 and both clauses can be used with multiple-table updates. An\nUPDATE can also reference tables which are located in different databases; see\nIdentifier Qualifiers for the syntax.\n\nwhere_condition is an expression that evaluates to true for each row to be\nupdated.\n\ntable_references and where_condition are as specified as described in SELECT.\n\nFor single-table updates, assignments are evaluated in left-to-right order,\nwhile for multi-table updates, there is no guarantee of a particular order. If\nthe SIMULTANEOUS_ASSIGNMENT sql_mode (available from MariaDB 10.3.5) is set,\nUPDATE statements evaluate all assignments simultaneously.\n\nYou need the UPDATE privilege only for columns referenced in an UPDATE that\nare actually updated. You need only the SELECT privilege for any columns that\nare read but not modified. See GRANT.\n\nThe UPDATE statement supports the following modifiers:\n\n* If you use the LOW_PRIORITY keyword, execution of\n the UPDATE is delayed until no other clients are reading from\n the table. This affects only storage engines that use only table-level\n locking (MyISAM, MEMORY, MERGE). See HIGH_PRIORITY and LOW_PRIORITY clauses\nfor details.\n* If you use the IGNORE keyword, the update statement does \n not abort even if errors occur during the update. Rows for which\n duplicate-key conflicts occur are not updated. Rows for which columns are\n updated to values that would cause data conversion errors are updated to the\n closest valid values instead.\n\nPARTITION\n---------\n\nSee Partition Pruning and Selection for details.\n\nFOR PORTION OF\n--------------\n\nMariaDB starting with 10.4.3\n----------------------------\nSee Application Time Periods - Updating by Portion.\n\nUPDATE Statements With the Same Source and Target\n-------------------------------------------------\n\nMariaDB starting with 10.3.2\n----------------------------\nFrom MariaDB 10.3.2, UPDATE statements may have the same source and target.\n\nFor example, given the following table:\n\nDROP TABLE t1;\nCREATE TABLE t1 (c1 INT, c2 INT);\nINSERT INTO t1 VALUES (10,10), (20,20);\n\nUntil MariaDB 10.3.1, the following UPDATE statement would not work:\n\nUPDATE t1 SET c1=c1+1 WHERE c2=(SELECT MAX(c2) FROM t1);\nERROR 1093 (HY000): Table \'t1\' is specified twice, \n both as a target for \'UPDATE\' and as a separate source for data\n\nFrom MariaDB 10.3.2, the statement executes successfully:\n\nUPDATE t1 SET c1=c1+1 WHERE c2=(SELECT MAX(c2) FROM t1);\n\nSELECT * FROM t1;\n+------+------+\n| c1   | c2   |\n+------+------+\n|   10 |   10 |\n|   21 |   20 |\n+------+------+\n\nExample\n-------\n\nSingle-table syntax:\n\nUPDATE table_name SET column1 = value1, column2 = value2 WHERE id=100;\n\nMultiple-table syntax:\n\nUPDATE tab1, tab2 SET tab1.column1 = value1, tab1.column2 = value2 WHERE\ntab1.id = tab2.id;\n\nURL: https://mariadb.com/kb/en/update/','','https://mariadb.com/kb/en/update/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (419,27,'IGNORE','The IGNORE option tells the server to ignore some common errors.\n\nIGNORE can be used with the following statements:\n\n* DELETE\n* INSERT (see also INSERT IGNORE)\n* LOAD DATA INFILE\n* UPDATE\n* ALTER TABLE\n* CREATE TABLE ... SELECT\n* INSERT ... SELECT\n\nThe logic used:\n\n* Variables out of ranges are replaced with the maximum/minimum value.\n\n* SQL_MODEs STRICT_TRANS_TABLES, STRICT_ALL_TABLES, NO_ZERO_IN_DATE,\nNO_ZERO_DATE are ignored.\n\n* Inserting NULL in a NOT NULL field will insert 0 ( in a numerical\n field), 0000-00-00 ( in a date field) or an empty string ( in a character\n field).\n\n* Rows that cause a duplicate key error or break a foreign key constraint are\n not inserted, updated, or deleted.\n\nThe following errors are ignored:\n\n+---------------------+---------------------------------+--------------------+\n| Error number        | Symbolic error name             | Description        |\n+---------------------+---------------------------------+--------------------+\n| 1022                | ER_DUP_KEY                      | Can\'t write;       |\n|                     |                                 | duplicate key in   |\n|                     |                                 | table \'%s\'         |\n+---------------------+---------------------------------+--------------------+\n| 1048                | ER_BAD_NULL_ERROR               | Column \'%s\'        |\n|                     |                                 | cannot be null     |\n+---------------------+---------------------------------+--------------------+\n| 1062                | ER_DUP_ENTRY                    | Duplicate entry    |\n|                     |                                 | \'%s\' for key %d    |\n+---------------------+---------------------------------+--------------------+\n| 1242                | ER_SUBQUERY_NO_1_ROW            | Subquery returns   |\n|                     |                                 | more than 1 row    |\n+---------------------+---------------------------------+--------------------+\n| 1264                | ER_WARN_DATA_OUT_OF_RANGE       | Out of range       |\n|                     |                                 | value for column   |\n|                     |                                 | \'%s\' at row %ld    |\n+---------------------+---------------------------------+--------------------+\n| 1265                | WARN_DATA_TRUNCATED             | Data truncated     |\n|                     |                                 | for column \'%s\'    |\n|                     |                                 | at row %ld         |\n+---------------------+---------------------------------+--------------------+\n| 1292                | ER_TRUNCATED_WRONG_VALUE        | Truncated          |\n|                     |                                 | incorrect %s       |\n|                     |                                 | value: \'%s\'        |\n+---------------------+---------------------------------+--------------------+\n| 1366                | ER_TRUNCATED_WRONG_VALUE_FOR_FI | Incorrect integer  |\n|                     | LD                              | value              |\n+---------------------+---------------------------------+--------------------+\n| 1369                | ER_VIEW_CHECK_FAILED            | CHECK OPTION       |\n|                     |                                 | failed \'%s.%s\'     |\n+---------------------+---------------------------------+--------------------+\n| 1451                | ER_ROW_IS_REFERENCED_2          | Cannot delete or   |\n|                     |                                 | update a parent    |\n|                     |                                 | row                |\n+---------------------+---------------------------------+--------------------+\n| 1452                | ER_NO_REFERENCED_ROW_2          | Cannot add or      |\n|                     |                                 | update a child     |\n|                     |                                 | row: a foreign     |\n|                     |                                 | key constraint     |\n|                     |                                 | fails (%s)         |\n+---------------------+---------------------------------+--------------------+\n| 1526                | ER_NO_PARTITION_FOR_GIVEN_VALUE | Table has no       |\n|                     |                                 | partition for      |\n|                     |                                 | value %s           |\n+---------------------+---------------------------------+--------------------+\n| 1586                | ER_DUP_ENTRY_WITH_KEY_NAME      | Duplicate entry    |\n|                     |                                 | \'%s\' for key \'%s\'  |\n+---------------------+---------------------------------+--------------------+\n| 1591                | ER_NO_PARTITION_FOR_GIVEN_VALUE | Table has no       |\n|                     | SILENT                          | partition for      |\n|                     |                                 | some existing      |\n|                     |                                 | values             |\n+---------------------+---------------------------------+--------------------+\n| 1748                | ER_ROW_DOES_NOT_MATCH_GIVEN_PAR | Found a row not    |\n|                     | ITION_SET                       | matching the       |\n|                     |                                 | given partition    |\n|                     |                                 | set                |\n+---------------------+---------------------------------+--------------------+\n\nIgnored errors normally generate a warning.\n\nA property of the IGNORE clause consists in causing transactional engines and\nnon-transactional engines (like InnoDB and Aria) to behave the same way. For\nexample, normally a multi-row insert which tries to violate a UNIQUE contraint\nis completely rolled back on InnoDB, but might be partially executed on Aria.\nWith the IGNORE clause, the statement will be partially executed in both\nengines.\n\nDuplicate key errors also generate warnings. The OLD_MODE server variable can\nbe used to prevent this.\n\nURL: https://mariadb.com/kb/en/ignore/','','https://mariadb.com/kb/en/ignore/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (420,27,'SELECT','Syntax\n------\n\nSELECT\n  [ALL | DISTINCT | DISTINCTROW]\n  [HIGH_PRIORITY]\n  [STRAIGHT_JOIN]\n  [SQL_SMALL_RESULT] [SQL_BIG_RESULT] [SQL_BUFFER_RESULT]\n  [SQL_CACHE | SQL_NO_CACHE] [SQL_CALC_FOUND_ROWS]\n  select_expr [, select_expr ...]\n  [ FROM table_references\n   [WHERE where_condition]\n   [GROUP BY {col_name | expr | position} [ASC | DESC], ... [WITH ROLLUP]]\n   [HAVING where_condition]\n   [ORDER BY {col_name | expr | position} [ASC | DESC], ...]\n   [LIMIT {[offset,] row_count | row_count OFFSET offset  [ROWS EXAMINED\nrows_limit] } |\n    [OFFSET start { ROW | ROWS }]\n    [FETCH { FIRST | NEXT } [ count ] { ROW | ROWS } { ONLY | WITH TIES }]\n]\n   procedure|[PROCEDURE procedure_name(argument_list)]\n   [INTO OUTFILE \'file_name\' [CHARACTER SET charset_name] [export_options] |\n    INTO DUMPFILE \'file_name\' | INTO var_name [, var_name] ]\n   [FOR UPDATE lock_option | LOCK IN SHARE MODE lock_option]\nexport_options:\n  [{FIELDS | COLUMNS}\n    [TERMINATED BY \'string\']\n    [[OPTIONALLY] ENCLOSED BY \'char\']\n    [ESCAPED BY \'char\']\n  ]\n  [LINES\n    [STARTING BY \'string\']\n    [TERMINATED BY \'string\']\n  ]\nlock_option:\n  [WAIT n | NOWAIT | SKIP LOCKED]\n\nDescription\n-----------\n\nSELECT is used to retrieve rows selected from one or more tables, and can\ninclude UNION statements and subqueries.\n\n* Each select_expr expression indicates a column or data that you want to\nretrieve. You\nmust have at least one select expression. See Select Expressions below.\n\n* The FROM clause indicates the table or tables from which to retrieve rows.\nUse either a single table name or a JOIN expression. See JOIN\nfor details. If no table is involved, FROM DUAL can be specified.\n\n* Each table can also be specified as db_name.tabl_name. Each column can also\nbe specified as tbl_name.col_name or even db_name.tbl_name.col_name. This\nallows one to write queries which involve multiple databases. See Identifier\nQualifiers for syntax details.\n\n* The WHERE clause, if given, indicates the condition or\n conditions that rows must satisfy to be selected.\n where_condition is an expression that evaluates to true for\n each row to be selected. The statement selects all rows if there is no WHERE\n clause.\nIn the WHERE clause, you can use any of the functions and\n operators that MariaDB supports, except for aggregate (summary) functions.\nSee Functions and Operators and Functions and Modifiers for use with GROUP BY\n(aggregate).\n\n* Use the ORDER BY clause to order the results.\n\n* Use the LIMIT clause allows you to restrict the results to only\na certain number of rows, optionally with an offset.\n\n* Use the GROUP BY and HAVING clauses to group\nrows together when they have columns or computed values in common.\n\nSELECT can also be used to retrieve rows computed without reference to any\ntable.\n\nSelect Expressions\n------------------\n\nA SELECT statement must contain one or more select expressions, separated by\ncommas. Each select expression can be one of the following:\n\n* The name of a column.\n* Any expression using functions and operators.\n* * to select all columns from all tables in the FROM clause.\n* tbl_name.* to select all columns from just the table tbl_name.\n\nWhen specifying a column, you can either use just the column name or qualify\nthe column name with the name of the table using tbl_name.col_name. The\nqualified form is useful if you are joining multiple tables in the FROM\nclause. If you do not qualify the column names when selecting from multiple\ntables, MariaDB will try to find the column in each table. It is an error if\nthat column name exists in multiple tables.\n\nYou can quote column names using backticks. If you are qualifying column names\nwith table names, quote each part separately as `tbl_name`.`col_name`.\n\nIf you use any grouping functions in any of the select expressions, all rows\nin your results will be implicitly grouped, as if you had used GROUP BY NULL.\n\nDISTINCT\n--------\n\nA query may produce some identical rows. By default, all rows are retrieved,\neven when their values are the same. To explicitly specify that you want to\nretrieve identical rows, use the ALL option. If you want duplicates to be\nremoved from the resultset, use the DISTINCT option. DISTINCTROW is a synonym\nfor DISTINCT. See also COUNT DISTINCT and SELECT UNIQUE in Oracle mode.\n\nINTO\n----\n\nThe INTO clause is used to specify that the query results should be written to\na file or variable.\n\n* SELECT INTO OUTFILE - formatting and writing the result to an external file.\n* SELECT INTO DUMPFILE - binary-safe writing of the unformatted results to an\nexternal file.\n* SELECT INTO Variable - selecting and setting variables.\n\nThe reverse of SELECT INTO OUTFILE is LOAD DATA.\n\nLIMIT\n-----\n\nRestricts the number of returned rows. See LIMIT and LIMIT ROWS EXAMINED for\ndetails.\n\nLOCK IN SHARE MODE/FOR UPDATE\n-----------------------------\n\nSee LOCK IN SHARE MODE and FOR UPDATE for details on the respective locking\nclauses.\n\nOFFSET ... FETCH\n----------------\n\nMariaDB starting with 10.6\n--------------------------\nSee SELECT ... OFFSET ... FETCH.\n\nORDER BY\n--------\n\nOrder a resultset. See ORDER BY for details.\n\nPARTITION\n---------\n\nSpecifies to the optimizer which partitions are relevant for the query. Other\npartitions will not be read. See Partition Pruning and Selection for details.\n\nPROCEDURE\n---------\n\nPasses the whole result set to a C Procedure. See PROCEDURE and PROCEDURE\nANALYSE (the only built-in procedure not requiring the server to be\nrecompiled).\n\nSKIP LOCKED\n-----------\n\nMariaDB starting with 10.6\n--------------------------\nThe SKIP LOCKED clause was introduced in MariaDB 10.6.0.\n\nThis causes those rows that couldn\'t be locked (LOCK IN SHARE MODE or FOR\nUPDATE) to be excluded from the result set. An explicit NOWAIT is implied\nhere. This is only implemented on InnoDB tables and ignored otherwise.\n\nSQL_CALC_FOUND_ROWS\n-------------------\n\nWhen SQL_CALC_FOUND_ROWS is used, then MariaDB will calculate how many rows\nwould have been in the result, if there would be no LIMIT clause. The result\ncan be found by calling the function FOUND_ROWS() in your next sql statement.\n\nmax_statement_time clause\n-------------------------\n\nBy using max_statement_time in conjunction with SET STATEMENT, it is possible\nto limit the execution time of individual queries. For example:\n\nSET STATEMENT max_statement_time=100 FOR \n SELECT field1 FROM table_name ORDER BY field1;\n\nWAIT/NOWAIT\n-----------\n\nSet the lock wait timeout. See WAIT and NOWAIT.\n\nExamples\n--------\n\nSELECT f1,f2 FROM t1 WHERE (f3<=10) AND (f4=\'y\');\n\nSee Getting Data from MariaDB (Beginner tutorial), or the various\nsub-articles, for more examples.\n\nURL: https://mariadb.com/kb/en/select/','','https://mariadb.com/kb/en/select/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (421,27,'JOIN Syntax','Description\n-----------\n\nMariaDB supports the following JOIN syntaxes for the table_references part of\nSELECT statements and multiple-table DELETE and UPDATE statements:\n\ntable_references:\n  table_reference [, table_reference] ...\n\ntable_reference:\n  table_factor\n | join_table\n\ntable_factor:\n  tbl_name [PARTITION (partition_list)]\n    [query_system_time_period_specification] [[AS] alias] [index_hint_list]\n | table_subquery [query_system_time_period_specification] [AS] alias\n | ( table_references )\n | { ON table_reference LEFT OUTER JOIN table_reference\n    ON conditional_expr }\n\njoin_table:\n  table_reference [INNER | CROSS] JOIN table_factor [join_condition]\n | table_reference STRAIGHT_JOIN table_factor\n | table_reference STRAIGHT_JOIN table_factor ON conditional_expr\n | table_reference {LEFT|RIGHT} [OUTER] JOIN table_reference join_condition\n | table_reference NATURAL [{LEFT|RIGHT} [OUTER]] JOIN table_factor\n\njoin_condition:\n  ON conditional_expr\n | USING (column_list)\n\nquery_system_time_period_specification:\n  FOR SYSTEM_TIME AS OF point_in_time\n | FOR SYSTEM_TIME BETWEEN point_in_time AND point_in_time\n | FOR SYSTEM_TIME FROM point_in_time TO point_in_time\n | FOR SYSTEM_TIME ALL\n\npoint_in_time:\n  [TIMESTAMP] expression\n | TRANSACTION expression\n\nindex_hint_list:\n  index_hint [, index_hint] ...\n\nindex_hint:\n  USE {INDEX|KEY}\n   [{FOR {JOIN|ORDER BY|GROUP BY}] ([index_list])\n | IGNORE {INDEX|KEY}\n   [{FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n | FORCE {INDEX|KEY}\n   [{FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n\nindex_list:\n  index_name [, index_name] ...\n\nA table reference is also known as a join expression.\n\nEach table can also be specified as db_name.tabl_name. This allows to write\nqueries which involve multiple databases. See Identifier Qualifiers for syntax\ndetails.\n\nThe syntax of table_factor is extended in comparison with the SQL Standard.\nThe latter accepts only table_reference, not a list of them inside a pair of\nparentheses.\n\nThis is a conservative extension if we consider each comma in a list of\ntable_reference items as equivalent to an inner join. For example:\n\nSELECT * FROM t1 LEFT JOIN (t2, t3, t4)\n        ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n\nis equivalent to:\n\nSELECT * FROM t1 LEFT JOIN (t2 CROSS JOIN t3 CROSS JOIN t4)\n        ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n\nIn MariaDB, CROSS JOIN is a syntactic equivalent to INNER JOIN (they can\nreplace each other). In standard SQL, they are not equivalent. INNER JOIN is\nused with an ON clause, CROSS JOIN is used otherwise.\n\nIn general, parentheses can be ignored in join expressions containing only\ninner join operations. MariaDB also supports nested joins (see\nhttp://dev.mysql.com/doc/refman/5.1/en/nested-join-optimization.html).\n\nSee System-versioned tables for more information about FOR SYSTEM_TIME syntax.\n\nIndex hints can be specified to affect how the MariaDB optimizer makes use of\nindexes. For more information, see How to force query plans.\n\nExamples\n--------\n\nSELECT left_tbl.*\n FROM left_tbl LEFT JOIN right_tbl ON left_tbl.id = right_tbl.id\n WHERE right_tbl.id IS NULL;\n\nURL: https://mariadb.com/kb/en/join-syntax/','','https://mariadb.com/kb/en/join-syntax/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (422,27,'Scalar Subqueries','A scalar subquery is a subquery that returns a single value. This is the\nsimplest form of a subquery, and can be used in most places a literal or\nsingle column value is valid.\n\nThe data type, length and character set and collation are all taken from the\nresult returned by the subquery. The result of a subquery can always be NULL,\nthat is, no result returned. Even if the original value is defined as NOT\nNULL, this is disregarded.\n\nA subquery cannot be used where only a literal is expected, for example LOAD\nDATA INFILE expects a literal string containing the file name, and LIMIT\nrequires a literal integer.\n\nExamples\n--------\n\nCREATE TABLE sq1 (num TINYINT);\n\nCREATE TABLE sq2 (num TINYINT);\n\nINSERT INTO sq1 VALUES (1);\n\nINSERT INTO sq2 VALUES (10* (SELECT num FROM sq1));\n\nSELECT * FROM sq2;\n+------+\n| num  |\n+------+\n|   10 |\n+------+\n\nInserting a second row means the subquery is no longer a scalar, and this\nparticular query is not valid:\n\nINSERT INTO sq1 VALUES (2);\n\nINSERT INTO sq2 VALUES (10* (SELECT num FROM sq1));\nERROR 1242 (21000): Subquery returns more than 1 row\n\nNo rows in the subquery, so the scalar is NULL:\n\nINSERT INTO sq2 VALUES (10* (SELECT num FROM sq3 WHERE num=\'3\'));\n\nSELECT * FROM sq2;\n+------+\n| num  |\n+------+\n|   10 |\n| NULL |\n+------+\n\nA more traditional scalar subquery, as part of a WHERE clause:\n\nSELECT * FROM sq1 WHERE num = (SELECT MAX(num)/10 FROM sq2); \n+------+\n| num  |\n+------+\n|    1 |\n+------+\n\nURL: https://mariadb.com/kb/en/subqueries-scalar-subqueries/','','https://mariadb.com/kb/en/subqueries-scalar-subqueries/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (423,27,'Row Subqueries','A row subquery is a subquery returning a single row, as opposed to a scalar\nsubquery, which returns a single column from a row, or a literal.\n\nExamples\n--------\n\nCREATE TABLE staff (name VARCHAR(10), age TINYINT);\n\nCREATE TABLE customer (name VARCHAR(10), age TINYINT);\n\nINSERT INTO staff VALUES (\'Bilhah\',37), (\'Valerius\',61), (\'Maia\',25);\n\nINSERT INTO customer VALUES (\'Thanasis\',48), (\'Valerius\',61), (\'Brion\',51);\n\nSELECT * FROM staff WHERE (name,age) = (SELECT name,age FROM customer WHERE\nname=\'Valerius\');\n+----------+------+\n| name     | age  |\n+----------+------+\n| Valerius |   61 |\n+----------+------+\n\nFinding all rows in one table also in another:\n\nSELECT name,age FROM staff WHERE (name,age) IN (SELECT name,age FROM customer);\n+----------+------+\n| name     | age  |\n+----------+------+\n| Valerius |   61 |\n+----------+------+\n\nURL: https://mariadb.com/kb/en/subqueries-row-subqueries/','','https://mariadb.com/kb/en/subqueries-row-subqueries/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (424,27,'Subqueries and ALL','Subqueries using the ALL keyword will return true if the comparison returns\ntrue for each row returned by the subquery, or the subquery returns no rows.\n\nSyntax\n------\n\nscalar_expression comparison_operator ALL <Table subquery>\n\n* scalar_expression may be any expression that evaluates to a single\nvalue\n* comparison_operator may be any one of: =, >, <, >=, <=, <> or !=\n\nALL returns:\n\n* NULL if the comparison operator returns NULL for at least one row returned\nby the Table subquery or scalar_expression returns NULL.\n* FALSE if the comparison operator returns FALSE for at least one row returned\nby the Table subquery.\n* TRUE if the comparison operator returns TRUE for all rows returned by the\nTable subquery, or if Table subquery returns no rows.\n\nNOT IN is an alias for <> ALL.\n\nExamples\n--------\n\nCREATE TABLE sq1 (num TINYINT);\n\nCREATE TABLE sq2 (num2 TINYINT);\n\nINSERT INTO sq1 VALUES(100);\n\nINSERT INTO sq2 VALUES(40),(50),(60);\n\nSELECT * FROM sq1 WHERE num > ALL (SELECT * FROM sq2);\n+------+\n| num  |\n+------+\n|  100 |\n+------+\n\nSince 100 > all of 40,50 and 60, the evaluation is true and the row is returned\n\nAdding a second row to sq1, where the evaluation for that record is false:\n\nINSERT INTO sq1 VALUES(30);\n\nSELECT * FROM sq1 WHERE num > ALL (SELECT * FROM sq2);\n+------+\n| num  |\n+------+\n|  100 |\n+------+\n\nAdding a new row to sq2, causing all evaluations to be false:\n\nINSERT INTO sq2 VALUES(120);\n\nSELECT * FROM sq1 WHERE num > ALL (SELECT * FROM sq2);\nEmpty set (0.00 sec)\n\nWhen the subquery returns no results, the evaluation is still true:\n\nSELECT * FROM sq1 WHERE num > ALL (SELECT * FROM sq2 WHERE num2 > 300);\n+------+\n| num  |\n+------+\n|  100 |\n|   30 |\n+------+\n\nEvaluating against a NULL will cause the result to be unknown, or not true,\nand therefore return no rows:\n\nINSERT INTO sq2 VALUES (NULL);\n\nSELECT * FROM sq1 WHERE num > ALL (SELECT * FROM sq2);\n\nURL: https://mariadb.com/kb/en/subqueries-and-all/','','https://mariadb.com/kb/en/subqueries-and-all/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (425,27,'Subqueries and ANY','Subqueries using the ANY keyword will return true if the comparison returns\ntrue for at least one row returned by the subquery.\n\nSyntax\n------\n\nThe required syntax for an ANY or SOME quantified comparison is:\n\nscalar_expression comparison_operator ANY <Table subquery>\n\nOr:\n\nscalar_expression comparison_operator SOME <Table subquery>\n\n* scalar_expression may be any expression that evaluates to a\nsingle value.\n* comparison_operator may be any one of =, >, <, >=, <=, <> or !=.\n\nANY returns:\n\n* TRUE if the comparison operator returns TRUE for at least one row returned\nby the Table subquery.\n* FALSE if the comparison operator returns FALSE for all rows returned by the\nTable subquery, or Table subquery has zero rows.\n* NULL if the comparison operator returns NULL for at least one row returned\nby the Table subquery and doesn\'t returns TRUE for any of them, or if\nscalar_expression returns NULL.\n\nSOME is a synmonym for ANY, and IN is a synonym for = ANY\n\nExamples\n--------\n\nCREATE TABLE sq1 (num TINYINT);\n\nCREATE TABLE sq2 (num2 TINYINT);\n\nINSERT INTO sq1 VALUES(100);\n\nINSERT INTO sq2 VALUES(40),(50),(120);\n\nSELECT * FROM sq1 WHERE num > ANY (SELECT * FROM sq2);\n+------+\n| num  |\n+------+\n|  100 |\n+------+\n\n100 is greater than two of the three values, and so the expression evaluates\nas true.\n\nSOME is a synonym for ANY:\n\nSELECT * FROM sq1 WHERE num < SOME (SELECT * FROM sq2);\n+------+\n| num  |\n+------+\n|  100 |\n+------+\n\nIN is a synonym for = ANY, and here there are no matches, so no results are\nreturned:\n\nSELECT * FROM sq1 WHERE num IN (SELECT * FROM sq2);\nEmpty set (0.00 sec)\n\nINSERT INTO sq2 VALUES(100);\nQuery OK, 1 row affected (0.05 sec)\n\nSELECT * FROM sq1 WHERE num <> ANY (SELECT * FROM sq2);\n+------+\n| num  |\n+------+\n|  100 |\n+------+\n\nReading this query, the results may be counter-intuitive. It may seem to read\nas \"SELECT * FROM sq1 WHERE num does not match any results in sq2. Since it\ndoes match 100, it could seem that the results are incorrect. However, the\nquery returns a result if the match does not match any of sq2. Since 100\nalready does not match 40, the expression evaluates to true immediately,\nregardless of the 100\'s matching. It may be more easily readable to use SOME\nin a case such as this:\n\nSELECT * FROM sq1 WHERE num <> SOME (SELECT * FROM sq2);\n+------+\n| num  |\n+------+\n|  100 |\n+------+\n\nURL: https://mariadb.com/kb/en/subqueries-and-any/','','https://mariadb.com/kb/en/subqueries-and-any/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (426,27,'Subqueries and EXISTS','Syntax\n------\n\nSELECT ... WHERE EXISTS <Table subquery>\n\nDescription\n-----------\n\nSubqueries using the EXISTS keyword will return true if the subquery returns\nany rows. Conversely, subqueries using NOT EXISTS will return true only if the\nsubquery returns no rows from the table.\n\nEXISTS subqueries ignore the columns specified by the SELECT of the subquery,\nsince they\'re not relevant. For example,\n\nSELECT col1 FROM t1 WHERE EXISTS (SELECT * FROM t2);\n\nand\n\nSELECT col1 FROM t1 WHERE EXISTS (SELECT col2 FROM t2);\n\nproduce identical results.\n\nExamples\n--------\n\nCREATE TABLE sq1 (num TINYINT);\n\nCREATE TABLE sq2 (num2 TINYINT);\n\nINSERT INTO sq1 VALUES(100);\n\nINSERT INTO sq2 VALUES(40),(50),(60);\n\nSELECT * FROM sq1 WHERE EXISTS (SELECT * FROM sq2 WHERE num2>50);\n+------+\n| num  |\n+------+\n|  100 |\n+------+\n\nSELECT * FROM sq1 WHERE NOT EXISTS (SELECT * FROM sq2 GROUP BY num2 HAVING\nMIN(num2)=40);\nEmpty set (0.00 sec)\n\nURL: https://mariadb.com/kb/en/subqueries-and-exists/','','https://mariadb.com/kb/en/subqueries-and-exists/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (427,27,'Subqueries in a FROM Clause','Although subqueries are more commonly placed in a WHERE clause, they can also\nform part of the FROM clause. Such subqueries are commonly called derived\ntables.\n\nIf a subquery is used in this way, you must also use an AS clause to name the\nresult of the subquery.\n\nORACLE mode\n-----------\n\nMariaDB starting with 10.6.0\n----------------------------\nFrom MariaDB 10.6.0, anonymous subqueries in a FROM clause (no AS clause) are\npermitted in ORACLE mode.\n\nExamples\n--------\n\nCREATE TABLE student (name CHAR(10), test CHAR(10), score TINYINT);\n\nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73),\n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31),\n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88),\n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n\nAssume that, given the data above, you want to return the average total for\nall students. In other words, the average of Chun\'s 148 (75+73), Esben\'s 74\n(43+31), etc.\n\nYou cannot do the following:\n\nSELECT AVG(SUM(score)) FROM student GROUP BY name;\nERROR 1111 (HY000): Invalid use of group function\n\nA subquery in the FROM clause is however permitted:\n\nSELECT AVG(sq_sum) FROM (SELECT SUM(score) AS sq_sum FROM student GROUP BY\nname) AS t;\n+-------------+\n| AVG(sq_sum) |\n+-------------+\n|    134.0000 |\n+-------------+\n\nFrom MariaDB 10.6 in ORACLE mode, the following is permitted:\n\nSELECT * FROM (SELECT 1 FROM DUAL), (SELECT 2 FROM DUAL);\n\nURL: https://mariadb.com/kb/en/subqueries-in-a-from-clause/','','https://mariadb.com/kb/en/subqueries-in-a-from-clause/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (428,27,'Subqueries and JOINs','A subquery can quite often, but not in all cases, be rewritten as a JOIN.\n\nRewriting Subqueries as JOINS\n-----------------------------\n\nA subquery using IN can be rewritten with the DISTINCT keyword, for example:\n\nSELECT * FROM table1 WHERE col1 IN (SELECT col1 FROM table2);\n\ncan be rewritten as:\n\nSELECT DISTINCT table1.* FROM table1, table2 WHERE table1.col1=table2.col1;\n\nNOT IN or NOT EXISTS queries can also be rewritten. For example, these two\nqueries returns the same result:\n\nSELECT * FROM table1 WHERE col1 NOT IN (SELECT col1 FROM table2);\nSELECT * FROM table1 WHERE NOT EXISTS (SELECT col1 FROM table2 WHERE\ntable1.col1=table2.col1);\n\nand both can be rewritten as:\n\nSELECT table1.* FROM table1 LEFT JOIN table2 ON table1.id=table2.id WHERE\ntable2.id IS NULL;\n\nSubqueries that can be rewritten as a LEFT JOIN are sometimes more efficient.\n\nUsing Subqueries instead of JOINS\n---------------------------------\n\nThere are some scenarios, though, which call for subqueries rather than joins:\n\n* When you want duplicates, but not false duplicates. Suppose Table_1\n has three rows — {1,1,2}\n — and Table_2 has two rows\n — {1,2,2}. If you need to list the rows\n in Table_1 which are also in Table_2, only this\n subquery-based SELECT statement will give the right answer\n (1,1,2):\n\nSELECT Table_1.column_1 \nFROM   Table_1 \nWHERE  Table_1.column_1 IN \n (SELECT Table_2.column_1\n  FROM   Table_2);\n\n* This SQL statement won\'t work:\n\nSELECT Table_1.column_1 \nFROM   Table_1,Table_2 \nWHERE  Table_1.column_1 = Table_2.column_1;\n\n* because the result will be {1,1,2,2}\n — and the duplication of 2 is an error.  This SQL\n statement won\'t work either:\n\nSELECT DISTINCT Table_1.column_1 \nFROM   Table_1,Table_2 \nWHERE  Table_1.column_1 = Table_2.column_1;\n\n* because the result will be {1,2} — and\n the removal of the duplicated 1 is an error too.\n\n* When the outermost statement is not a query. The SQL statement:\n\nUPDATE Table_1 SET column_1 = (SELECT column_1 FROM Table_2);\n\n* can\'t be expressed using a join unless some rare SQL3 features are used.\n\n* When the join is over an expression. The SQL statement:\n\nSELECT * FROM Table_1 \nWHERE column_1 + 5 =\n (SELECT MAX(column_1) FROM Table_2);\n\n* is hard to express with a join. In fact, the only way we can think of is\n this SQL statement:\n\nSELECT Table_1.*\nFROM   Table_1, \n   (SELECT MAX(column_1) AS max_column_1 FROM Table_2) AS Table_2\nWHERE  Table_1.column_1 + 5 = Table_2.max_column_1;\n\n* which still involves a parenthesized query, so nothing is gained from the\n transformation.\n\n* When you want to see the exception. For example, suppose the question is:\n what books are longer than Das Kapital? These two queries are effectively\n almost the same:\n\nSELECT DISTINCT Bookcolumn_1.*                     \nFROM   Books AS Bookcolumn_1 JOIN Books AS Bookcolumn_2 USING(page_count) \nWHERE  title = \'Das Kapital\';\n\nSELECT DISTINCT Bookcolumn_1.* \nFROM   Books AS Bookcolumn_1 \nWHERE  Bookcolumn_1.page_count > \n (SELECT DISTINCT page_count\n FROM   Books AS Bookcolumn_2\n WHERE  title = \'Das Kapital\');\n\n* The difference is between these two SQL statements is, if there are two\n editions of Das Kapital (with different page counts), then the self-join\n example will return the books which are  longer than the shortest edition\n of Das Kapital. That might be the wrong answer, since the original\n question didn\'t ask for \"... longer than ANY book named Das Kapital\"\n (it seems to contain a false assumption that there\'s only one edition).\n\nURL: https://mariadb.com/kb/en/subqueries-and-joins/','','https://mariadb.com/kb/en/subqueries-and-joins/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (429,27,'Subquery Limitations','There are a number of limitations regarding subqueries, which are discussed\nbelow. The following tables and data will be used in the examples that follow:\n\nCREATE TABLE staff(name VARCHAR(10),age TINYINT);\n\nCREATE TABLE customer(name VARCHAR(10),age TINYINT);\n\nINSERT INTO staff VALUES \n(\'Bilhah\',37), (\'Valerius\',61), (\'Maia\',25);\n\nINSERT INTO customer VALUES \n(\'Thanasis\',48), (\'Valerius\',61), (\'Brion\',51);\n\nORDER BY and LIMIT\n------------------\n\nTo use ORDER BY or limit LIMIT in subqueries both must be used.. For example:\n\nSELECT * FROM staff WHERE name IN (SELECT name FROM customer ORDER BY name);\n+----------+------+\n| name     | age  |\n+----------+------+\n| Valerius |   61 |\n+----------+------+\n\nis valid, but\n\nSELECT * FROM staff WHERE name IN (SELECT NAME FROM customer ORDER BY name\nLIMIT 1);\nERROR 1235 (42000): This version of MariaDB doesn\'t \n yet support \'LIMIT & IN/ALL/ANY/SOME subquery\'\n\nis not.\n\nModifying and Selecting from the Same Table\n-------------------------------------------\n\nIt\'s not possible to both modify and select from the same table in a subquery.\nFor example:\n\nDELETE FROM staff WHERE name = (SELECT name FROM staff WHERE age=61);\nERROR 1093 (HY000): Table \'staff\' is specified twice, both \n as a target for \'DELETE\' and as a separate source for data\n\nRow Comparison Operations\n-------------------------\n\nThere is only partial support for row comparison operations. The expression in\n\nexpr op {ALL|ANY|SOME} subquery,\n\nmust be scalar and the subquery can only return a single column.\n\nHowever, because of the way IN is implemented (it is rewritten as a sequence\nof = comparisons and AND), the expression in\n\nexpression [NOT] IN subquery\n\nis permitted to be an n-tuple and the subquery can return rows of n-tuples.\n\nFor example:\n\nSELECT * FROM staff WHERE (name,age) NOT IN (\n SELECT name,age FROM customer WHERE age >=51]\n);\n+--------+------+\n| name   | age  |\n+--------+------+\n| Bilhah |   37 |\n| Maia   |   25 |\n+--------+------+\n\nis permitted, but\n\nSELECT * FROM staff WHERE (name,age) = ALL (\n SELECT name,age FROM customer WHERE age >=51\n);\nERROR 1241 (21000): Operand should contain 1 column(s)\n\nis not.\n\nCorrelated Subqueries\n---------------------\n\nSubqueries in the FROM clause cannot be correlated subqueries. They cannot be\nevaluated for each row of the outer query since they are evaluated to produce\na result set during when the query is executed.\n\nStored Functions\n----------------\n\nA subquery can refer to a stored function which modifies data. This is an\nextension to the SQL standard, but can result in indeterminate outcomes. For\nexample, take:\n\nSELECT ... WHERE x IN (SELECT f() ...);\n\nwhere f() inserts rows. The function f() could be executed a different number\nof times depending on how the optimizer chooses to handle the query.\n\nThis sort of construct is therefore not safe to use in replication that is not\nrow-based, as there could be different results on the master and the slave.\n\nURL: https://mariadb.com/kb/en/subquery-limitations/','','https://mariadb.com/kb/en/subquery-limitations/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (430,27,'UNION','UNION is used to combine the results from multiple SELECT statements into a\nsingle result set.\n\nSyntax\n------\n\nSELECT ...\nUNION [ALL | DISTINCT] SELECT ...\n[UNION [ALL | DISTINCT] SELECT ...]\n[ORDER BY [column [, column ...]]]\n[LIMIT {[offset,] row_count | row_count OFFSET offset}]\n\nDescription\n-----------\n\nUNION is used to combine the results from multiple SELECT statements into a\nsingle result set.\n\nThe column names from the first SELECT statement are used as the column names\nfor the results returned. Selected columns listed in corresponding positions\nof each SELECT statement should have the same data type. (For example, the\nfirst column selected by the first statement should have the same type as the\nfirst column selected by the other statements.)\n\nIf they don\'t, the type and length of the columns in the result take into\naccount the values returned by all of the SELECTs, so there is no need for\nexplicit casting. Note that currently this is not the case for recursive CTEs\n- see MDEV-12325.\n\nTable names can be specified as db_name.tbl_name. This permits writing UNIONs\nwhich involve multiple databases. See Identifier Qualifiers for syntax details.\n\nUNION queries cannot be used with aggregate functions.\n\nEXCEPT and UNION have the same operation precedence and INTERSECT has a higher\nprecedence, unless running in Oracle mode, in which case all three have the\nsame precedence.\n\nALL/DISTINCT\n------------\n\nThe ALL keyword causes duplicate rows to be preserved. The DISTINCT keyword\n(the default if the keyword is omitted) causes duplicate rows to be removed by\nthe results.\n\nUNION ALL and UNION DISTINCT can both be present in a query. In this case,\nUNION DISTINCT will override any UNION ALLs to its left.\n\nMariaDB starting with 10.1.1\n----------------------------\nUntil MariaDB 10.1.1, all UNION ALL statements required the server to create a\ntemporary table. Since MariaDB 10.1.1, the server can in most cases execute\nUNION ALL without creating a temporary table, improving performance (see\nMDEV-334).\n\nORDER BY and LIMIT\n------------------\n\nIndividual SELECTs can contain their own ORDER BY and LIMIT clauses. In this\ncase, the individual queries need