/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;

public class TimeHeaderYearly
extends TimeHeaderCalendar {
    @Override
    public double getTimeHeaderHeight() {
        return 20.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 19.0;
    }

    public TimeHeaderYearly(TimeHeaderParameters thParam) {
        super(thParam, new TimeScaleCompressed(thParam.getStartingDay(), thParam.getScale()));
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawYears(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getFullHeaderHeight());
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        ug = ug.apply(UTranslate.dy(3.0));
        this.drawYears(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getTimeFooterHeight());
    }

    private void drawYears(UGraphic ug) {
        MonthYear last = null;
        double lastChange = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (last == null || wink.monthYear().year() != last.year()) {
                this.drawVbar(ug, x1, 0.0, 19.0, false);
                if (last != null) {
                    this.printYear(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChange) {
            this.printYear(ug, last, lastChange, x1);
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), 0.0, 19.0, false);
    }

    private void printYear(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock("" + monthYear.year(), 14, true, this.openFontColor());
        this.printCentered(ug, true, start, end, small);
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight();
    }
}

