/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.syntax;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.skin.SkinParam;
import net.sourceforge.plantuml.utils.Cypher;

public class LanguageDescriptor {
    private final Set<String> type = new TreeSet<String>();
    private final Set<String> keyword = new TreeSet<String>();
    private final Set<String> preproc = new TreeSet<String>();

    public LanguageDescriptor() {
        this.type.add("actor");
        this.type.add("participant");
        this.type.add("usecase");
        this.type.add("class");
        this.type.add("interface");
        this.type.add("abstract");
        this.type.add("enum");
        this.type.add("component");
        this.type.add("state");
        this.type.add("object");
        this.type.add("artifact");
        this.type.add("folder");
        this.type.add("rectangle");
        this.type.add("node");
        this.type.add("frame");
        this.type.add("cloud");
        this.type.add("database");
        this.type.add("storage");
        this.type.add("agent");
        this.type.add("stack");
        this.type.add("boundary");
        this.type.add("control");
        this.type.add("entity");
        this.type.add("card");
        this.type.add("file");
        this.type.add("package");
        this.type.add("queue");
        this.type.add("archimate");
        this.type.add("diamond");
        this.type.add("collections");
        this.type.add("hexagon");
        this.type.add("label");
        this.type.add("person");
        this.type.add("annotation");
        this.keyword.add("@startwire");
        this.keyword.add("@startbpm");
        this.keyword.add("@startuml");
        this.keyword.add("@startdot");
        this.keyword.add("@startjcckit");
        this.keyword.add("@startditaa");
        this.keyword.add("@startproject");
        this.keyword.add("@startsalt");
        this.keyword.add("@startflow");
        this.keyword.add("@startcreole");
        this.keyword.add("@starttree");
        this.keyword.add("@startcute");
        this.keyword.add("@startmath");
        this.keyword.add("@startlatex");
        this.keyword.add("@startdef");
        this.keyword.add("@startgantt");
        this.keyword.add("@startnwdiag");
        this.keyword.add("@startmindmap");
        this.keyword.add("@startwbs");
        this.keyword.add("@startjson");
        this.keyword.add("@startgit");
        this.keyword.add("@startboard");
        this.keyword.add("@startyaml");
        this.keyword.add("@endwire");
        this.keyword.add("@endbpm");
        this.keyword.add("@enduml");
        this.keyword.add("@enddot");
        this.keyword.add("@endjcckit");
        this.keyword.add("@endditaa");
        this.keyword.add("@endproject");
        this.keyword.add("@endsalt");
        this.keyword.add("@endflow");
        this.keyword.add("@endcreole");
        this.keyword.add("@endtree");
        this.keyword.add("@endcute");
        this.keyword.add("@endmath");
        this.keyword.add("@endlatex");
        this.keyword.add("@enddef");
        this.keyword.add("@endgantt");
        this.keyword.add("@endnwdiag");
        this.keyword.add("@endmindmap");
        this.keyword.add("@endwbs");
        this.keyword.add("@endjson");
        this.keyword.add("@endgit");
        this.keyword.add("@endboard");
        this.keyword.add("@endyaml");
        this.keyword.add("as");
        this.keyword.add("also");
        this.keyword.add("autonumber");
        this.keyword.add("caption");
        this.keyword.add("title");
        this.keyword.add("newpage");
        this.keyword.add("box");
        this.keyword.add("alt");
        this.keyword.add("else");
        this.keyword.add("opt");
        this.keyword.add("loop");
        this.keyword.add("par");
        this.keyword.add("break");
        this.keyword.add("critical");
        this.keyword.add("note");
        this.keyword.add("rnote");
        this.keyword.add("hnote");
        this.keyword.add("legend");
        this.keyword.add("group");
        this.keyword.add("left");
        this.keyword.add("right");
        this.keyword.add("of");
        this.keyword.add("on");
        this.keyword.add("link");
        this.keyword.add("over");
        this.keyword.add("end");
        this.keyword.add("activate");
        this.keyword.add("deactivate");
        this.keyword.add("destroy");
        this.keyword.add("create");
        this.keyword.add("footbox");
        this.keyword.add("hide");
        this.keyword.add("show");
        this.keyword.add("skinparam");
        this.keyword.add("skin");
        this.keyword.add("top");
        this.keyword.add("bottom");
        this.keyword.add("top to bottom direction");
        this.keyword.add("left to right direction");
        this.keyword.add("package");
        this.keyword.add("namespace");
        this.keyword.add("page");
        this.keyword.add("up");
        this.keyword.add("down");
        this.keyword.add("if");
        this.keyword.add("then");
        this.keyword.add("else");
        this.keyword.add("elseif");
        this.keyword.add("endif");
        this.keyword.add("partition");
        this.keyword.add("footer");
        this.keyword.add("header");
        this.keyword.add("center");
        this.keyword.add("rotate");
        this.keyword.add("ref");
        this.keyword.add("return");
        this.keyword.add("is");
        this.keyword.add("repeat");
        this.keyword.add("start");
        this.keyword.add("stop");
        this.keyword.add("while");
        this.keyword.add("endwhile");
        this.keyword.add("fork");
        this.keyword.add("again");
        this.keyword.add("kill");
        this.keyword.add("detach");
        this.keyword.add("order");
        this.keyword.add("allow_mixing");
        this.keyword.add("allowmixing");
        this.keyword.add("mainframe");
        this.keyword.add("across");
        this.keyword.add("stereotype");
        this.keyword.add("split");
        this.keyword.add("style");
        this.keyword.add("sprite");
        this.keyword.add("circle");
        this.keyword.add("empty");
        this.keyword.add("members");
        this.keyword.add("description");
        this.keyword.add("true");
        this.keyword.add("false");
        this.keyword.add("normal");
        this.keyword.add("italic");
        this.keyword.add("bold");
        this.keyword.add("plain");
        this.keyword.add("color");
        this.keyword.add("dotted");
        this.keyword.add("dashed");
        this.keyword.add("bold");
        this.keyword.add("map");
        this.preproc.add("!exit");
        this.preproc.add("!include");
        this.preproc.add("!theme");
        this.preproc.add("!pragma");
        this.preproc.add("!define");
        this.preproc.add("!undef");
        this.preproc.add("!if");
        this.preproc.add("!ifdef");
        this.preproc.add("!endif");
        this.preproc.add("!ifndef");
        this.preproc.add("!else");
        this.preproc.add("!definelong");
        this.preproc.add("!enddefinelong");
        this.preproc.add("!function");
        this.preproc.add("!procedure");
        this.preproc.add("!endfunction");
        this.preproc.add("!endprocedure");
        this.preproc.add("!unquoted");
        this.preproc.add("!return");
        this.preproc.add("!startsub");
        this.preproc.add("!endsub");
        this.preproc.add("!assert");
        this.preproc.add("!log");
        this.preproc.add("!local");
        this.preproc.add("!dump_memory");
        this.preproc.add("!import");
    }

    public Cypher getCypher() {
        Cypher cypher = new Cypher();
        for (String s : this.type) {
            cypher.addException(s);
        }
        for (String s : this.keyword) {
            cypher.addException(s.replace("@", ""));
        }
        for (String s : this.preproc) {
            cypher.addException(s.substring(1));
        }
        for (String s : SkinParam.getPossibleValues()) {
            cypher.addException(s);
        }
        for (String s : HColorSet.instance().names()) {
            cypher.addException(s);
        }
        cypher.addException("o");
        return cypher;
    }

    public void print(PrintStream ps) {
        LanguageDescriptor.print(ps, "type", this.type);
        LanguageDescriptor.print(ps, "keyword", this.keyword);
        LanguageDescriptor.print(ps, "preprocessor", this.preproc);
        LanguageDescriptor.print(ps, "skinparameter", SkinParam.getPossibleValues());
        LanguageDescriptor.print(ps, "color", HColorSet.instance().names());
        ps.println(";EOF");
    }

    private static void print(PrintStream ps, String name, Collection<String> data) {
        ps.println(";" + name);
        ps.println(";" + data.size());
        for (String k : data) {
            ps.println(k);
        }
        ps.println();
    }

    public final Set<String> getType() {
        return Collections.unmodifiableSet(this.type);
    }

    public final Set<String> getKeyword() {
        return Collections.unmodifiableSet(this.keyword);
    }

    public final Set<String> getPreproc() {
        return Collections.unmodifiableSet(this.preproc);
    }
}

