/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.EmptyGroupTitle;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GroupTitle;
import com.dickimawbooks.bib2gls.OtherGroupTitle;
import com.dickimawbooks.bib2gls.SortComparator;
import com.dickimawbooks.bib2gls.SortSettings;
import java.text.BreakIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.Vector;

public class Bib2GlsEntryComparator
extends SortComparator {
    private Collator collator;
    private BreakIterator breakIterator = null;
    public static final int BREAK_NONE = 0;
    public static final int BREAK_WORD = 1;
    public static final int BREAK_CHAR = 2;
    public static final int BREAK_SENTENCE = 3;
    public static final int BREAK_UPPER_NOTLOWER = 4;
    public static final int BREAK_UPPER_UPPER = 5;
    public static final int BREAK_UPPER_NOTLOWER_WORD = 6;
    public static final int BREAK_UPPER_UPPER_WORD = 7;

    public Bib2GlsEntryComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2, String string3, boolean bl) throws ParseException {
        super(bib2Gls, vector, sortSettings, string, string2, string3, bl);
        int n = sortSettings.getBreakPoint();
        if (sortSettings.isCustom()) {
            this.collator = new RuleBasedCollator(sortSettings.getCollationRule());
            if (n != 0) {
                Locale locale = bib2Gls.getDefaultLocale();
                this.setBreakPoint(n, locale);
            }
        } else {
            Locale locale = sortSettings.getLocale();
            this.collator = Collator.getInstance(locale);
            this.setBreakPoint(n, locale);
        }
        this.collator.setStrength(sortSettings.getCollatorStrength());
        this.collator.setDecomposition(sortSettings.getCollatorDecomposition());
        if (this.collator instanceof RuleBasedCollator && bib2Gls.getDebugLevel() > 0) {
            bib2Gls.logMessage(bib2Gls.getMessage("message.collator.rules", ((RuleBasedCollator)this.collator).getRules()));
        }
    }

    private void setBreakPoint(int n, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        switch (n) {
            case 0: 
            case 4: 
            case 5: {
                this.breakIterator = null;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                this.breakIterator = BreakIterator.getWordInstance(locale);
                break;
            }
            case 2: {
                this.breakIterator = BreakIterator.getCharacterInstance(locale);
                break;
            }
            case 3: {
                this.breakIterator = BreakIterator.getSentenceInstance(locale);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid break identifier: " + n);
            }
        }
    }

    public int getBreakPoint() {
        return this.settings.getBreakPoint();
    }

    public String getBreakPointMarker() {
        return this.settings.getBreakPointMarker();
    }

    @Override
    protected long getDefaultGroupId(Bib2GlsEntry bib2GlsEntry, int n, Object object) {
        String string = object.toString();
        if (string.isEmpty()) {
            return 0L;
        }
        return n;
    }

    @Override
    protected GroupTitle createDefaultGroupTitle(int n, Object object, String string, String string2) {
        String string3;
        String string4 = object.toString();
        if (string4.isEmpty()) {
            return new EmptyGroupTitle(this.bib2gls, string, string2);
        }
        String string5 = string3 = new String(Character.toChars(n));
        if (Character.isAlphabetic(n)) {
            string5 = string3.toUpperCase();
            int n2 = string5.codePointAt(0);
            return new GroupTitle(this.bib2gls, string5, string3, n2, string, string2);
        }
        if (string3.equals("\\") || string3.equals("{") || string3.equals("}")) {
            string3 = "\\char`\\" + string3;
        }
        return new OtherGroupTitle(this.bib2gls, string3, n, string, string2);
    }

    @Override
    protected String updateSortValue(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) {
        Object object;
        CharSequence charSequence;
        String string = super.updateSortValue(bib2GlsEntry, vector);
        String string2 = bib2GlsEntry.getId();
        String string3 = null;
        if (this.settings.isBreakAtOn(bib2GlsEntry)) {
            string = this.breakPoints(string).toString();
            this.bib2gls.debug(this.bib2gls.getMessage("message.break.points", string));
        }
        bib2GlsEntry.putField(this.sortStorageField, string);
        CollationKey collationKey = this.collator.getCollationKey(string);
        bib2GlsEntry.setCollationKey(collationKey);
        GlsResource glsResource = this.bib2gls.getCurrentResource();
        String string4 = this.getType(bib2GlsEntry);
        if (glsResource.useGroupField(bib2GlsEntry, vector)) {
            charSequence = null;
            object = null;
            if (bib2GlsEntry.getFieldValue(this.groupField) == null) {
                if (string.isEmpty()) {
                    String string5;
                    object = glsResource.getGroupTitle(string4, 0L, bib2GlsEntry.getParent());
                    if (object == null) {
                        object = new EmptyGroupTitle(this.bib2gls, string4, bib2GlsEntry.getParent());
                        glsResource.putGroupTitle((GroupTitle)object, bib2GlsEntry);
                        string5 = ((GroupTitle)object).format();
                    } else {
                        string5 = ((GroupTitle)object).format(string);
                    }
                    charSequence = String.format("\\%s%s", ((GroupTitle)object).getCsLabelName(), string5);
                } else if (this.collator instanceof RuleBasedCollator) {
                    String string6;
                    String string7;
                    CollationElementIterator collationElementIterator = ((RuleBasedCollator)this.collator).getCollationElementIterator(string);
                    int n = collationElementIterator.next();
                    int n2 = collationElementIterator.getOffset();
                    int n3 = 0;
                    while (n == 0) {
                        n3 = n2;
                        n = collationElementIterator.next();
                        n2 = collationElementIterator.getOffset();
                    }
                    int n4 = 0;
                    if (n == -1) {
                        this.bib2gls.debug(this.bib2gls.getMessage("message.no.collation.element", string));
                        if (this.collator.getStrength() == 0) {
                            string7 = Normalizer.normalize(string, Normalizer.Form.NFD);
                            string7 = string7.replaceAll("\\p{M}", "");
                            collationElementIterator = ((RuleBasedCollator)this.collator).getCollationElementIterator(string7);
                            n = collationElementIterator.next();
                            n2 = collationElementIterator.getOffset();
                        } else {
                            n4 = string.codePointAt(0);
                            n2 = Character.charCount(n4);
                            string7 = string;
                            n = n4;
                        }
                        string3 = string7 = string7.substring(0, n2);
                    } else {
                        string3 = string7 = string.substring(n3, n2 == 0 ? 1 : n2);
                        int n5 = this.collator.getStrength();
                        this.collator.setStrength(0);
                        string6 = Normalizer.normalize(string7.toLowerCase(), Normalizer.Form.NFD);
                        string6 = string6.replaceAll("\\p{M}", "");
                        if (this.collator.compare(string7, string6) == 0) {
                            string3 = string6;
                        }
                        this.collator.setStrength(n5);
                    }
                    if (!string3.isEmpty()) {
                        n4 = string3.codePointAt(0);
                    }
                    if (this.settings.getGroupFormation() != 0) {
                        string3 = this.setGroupTitle(bib2GlsEntry, n4, string, string7, string4);
                    } else {
                        String string8 = this.bib2gls.getMessageIfExists(String.format("grouptitle.case.%s", string3));
                        if (string8 != null) {
                            string3 = string8;
                            n4 = Character.toTitleCase(n4);
                        } else if (Character.isAlphabetic(n4)) {
                            int n6 = Character.toTitleCase(n4);
                            string3 = String.format("%c%s", n6, string3.substring(Character.charCount(n4)).toLowerCase());
                            n4 = n6;
                        }
                        if (Character.isAlphabetic(n4)) {
                            if (this.collator.getStrength() != 0) {
                                n = n4;
                            }
                            if ((object = glsResource.getGroupTitle(string4, n, bib2GlsEntry.getParent())) == null) {
                                object = new GroupTitle(this.bib2gls, string3, string7, n, string4, bib2GlsEntry.getParent());
                                glsResource.putGroupTitle((GroupTitle)object, bib2GlsEntry);
                                string6 = ((GroupTitle)object).format();
                            } else {
                                string6 = ((GroupTitle)object).format(string7);
                                if (((GroupTitle)object).getTitle().matches(".*[^\\p{ASCII}].*") && string3.matches("\\p{ASCII}+")) {
                                    ((GroupTitle)object).setTitle(string3);
                                }
                            }
                            charSequence = String.format("\\%s%s", ((GroupTitle)object).getCsLabelName(), string6);
                        } else {
                            if (string7.equals("\\") || string7.equals("{") || string7.equals("}")) {
                                string7 = "\\char`\\" + string7;
                            }
                            if ((object = glsResource.getGroupTitle(string4, n, bib2GlsEntry.getParent())) == null) {
                                object = new OtherGroupTitle(this.bib2gls, string7, n, string4, bib2GlsEntry.getParent());
                                glsResource.putGroupTitle((GroupTitle)object, bib2GlsEntry);
                                string6 = ((GroupTitle)object).toString();
                            } else {
                                string6 = ((GroupTitle)object).format(string7);
                            }
                            charSequence = String.format("\\%s%s", ((GroupTitle)object).getCsLabelName(), string6);
                        }
                    }
                } else {
                    int n = string.codePointAt(0);
                    String string9 = new String(Character.toChars(n));
                    if (Character.isAlphabetic(n)) {
                        string3 = string9.toUpperCase();
                        n = string3.codePointAt(0);
                    }
                    string3 = this.setGroupTitle(bib2GlsEntry, n, string, string9, string4);
                }
            }
            if (charSequence != null) {
                glsResource.assignGroupField(bib2GlsEntry, this.groupField, (String)charSequence, (GroupTitle)object);
            }
        }
        if (this.bib2gls.getVerboseLevel() > 0) {
            charSequence = new StringBuilder();
            object = collationKey.toByteArray();
            for (int n3 : object) {
                if (charSequence.length() > 0) {
                    charSequence.append(' ');
                }
                charSequence.append(n3);
            }
            if (string3 == null) {
                this.bib2gls.verbose(String.format("%s -> '%s' [%s]", string2, string, charSequence));
            } else {
                this.bib2gls.verbose(String.format("%s -> '%s' (%s) [%s]", string2, string, string3, charSequence));
            }
        }
        return string;
    }

    @Override
    public int compareElements(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        CollationKey collationKey = bib2GlsEntry.getCollationKey();
        CollationKey collationKey2 = bib2GlsEntry2.getCollationKey();
        return collationKey.compareTo(collationKey2);
    }

    public Collator getCollator() {
        return this.collator;
    }

    @Override
    public void sortEntries() throws Bib2GlsException {
        this.bib2gls.debug(this.bib2gls.getMessage("message.setting.sort", this.collator.getStrength(), this.collator.getDecomposition()));
        super.sortEntries();
    }

    protected CharSequence breakUpperNotLower(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            int n4 = string.codePointAt(n);
            stringBuffer.appendCodePoint(n4);
            if (!Character.isUpperCase(n4) || Character.isLowerCase(n3 = n < n2 ? string.codePointAt(n += Character.charCount(n4)) : -1)) continue;
            stringBuffer.append(this.getBreakPointMarker());
        }
        return stringBuffer;
    }

    protected CharSequence breakUpperUpper(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            int n4 = string.codePointAt(n);
            stringBuffer.appendCodePoint(n4);
            if (!Character.isUpperCase(n4) || !Character.isUpperCase(n3 = n < n2 ? string.codePointAt(n += Character.charCount(n4)) : -1)) continue;
            stringBuffer.append(this.getBreakPointMarker());
        }
        return stringBuffer;
    }

    public CharSequence breakPoints(String string) {
        switch (this.getBreakPoint()) {
            case 4: 
            case 6: {
                string = this.breakUpperNotLower(string).toString();
                break;
            }
            case 5: 
            case 7: {
                string = this.breakUpperUpper(string).toString();
            }
        }
        if (this.breakIterator == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.breakIterator.setText(string);
        int n = this.breakIterator.first();
        int n2 = this.breakIterator.next();
        while (n2 != -1) {
            String string2 = string.substring(n, n2);
            int n3 = string2.codePointAt(0);
            if (Character.isLetterOrDigit(n3)) {
                stringBuffer.append(string2);
                stringBuffer.append(this.getBreakPointMarker());
            }
            n = n2;
            n2 = this.breakIterator.next();
        }
        return stringBuffer;
    }
}

