# Seta/Allumer X1-010

a sound chip designed by Seta, mainly used in their own arcade hardware from the late 80s to the early 2000s.
it has 2 output channels, but there is no known hardware taking advantage of stereo sound capabilities.
later hardware paired this with external bankswitching logic, but this isn't emulated yet.
Allumer rebadged it for their own arcade hardware.

it has 16 channels, which can all be switched between PCM sample or wavetable playback mode.
wavetable playback needs to paired with envelope, similar to AY PSG, but shapes are stored in RAM and as such are user-definable.

in Furnace, this chip can be configured for original arcade mono output or stereo output - it simulates early 'incorrect' emulation on some mono hardware, but it is also based on the assumption that each channel is connected to each output.

# waveform types

this chip supports 2 types of waveforms, needs to be paired to external 8 KB RAM to access these features:

one is a signed 8 bit mono waveform, operated like other wavetable based sound systems.
these are stored at the lower half of RAM at common case.

the other one ("Envelope") is a 4 bit stereo waveform, multiplied with the above and calculates final output, each nibble is used for each output channel.
these are stored at the upper half of RAM at common case.

both waveforms are 128 bytes (fixed size), freely allocated at each half of RAM except the channel register area: each half can store total 32/31 waveforms at once.
in Furnace, you can enable the envelope shape split mode. when it is set, its waveform will be split to the left and right halves for each output. each max size is 128 bytes, total 256 bytes.

# effects

- `10xx`: **change wave.**
- `11xx`: **change envelope shape.** also wavetable.
- `17xx`: **toggle PCM mode.**
- `20xx`: **set PCM frequency.** range is `1` to `FF`.
  - PCM frequency formula: `step * (clock / 8192)`.
  - range is 1.95KHz to 498KHz if the chip clock is 16MHz.
- `22xx`: **set envelope mode.**
  - bit 0 sets whether envelope will affect this channel.
  - bit 1 toggles the envelope one-shot mode. when it is set, channel is halted after envelope cycle is finished.
  - bit 2 toggles the envelope shape split mode. when it is set, envelope shape will be split to left half and right half.
  - bit 3/5 sets whether the right/left shape will mirror the original one.
  - bit 4/6 sets whether the right/left output will mirror the original one.
- `23xx`: **set envelope period.**
- `25xx`: **slide envelope period up.**
- `26xx`: **slide envelope period down.**
- `29xy`: **enable auto-envelope mode.**
  - in this mode the envelope period is set to the channel's notes, multiplied by a fraction.
  - `x` is the numerator.
  - `y` is the denominator.
  - if `x` or `y` are 0 this will disable auto-envelope mode.
