/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.cluster.service.MasterService;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;

public class ClusterManagerThrottlingMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(ClusterManagerThrottlingMetricsCollector.class)).samplingInterval;
    private static final Logger LOG = LogManager.getLogger(ClusterManagerThrottlingMetricsCollector.class);
    private static final int KEYS_PATH_LENGTH = 0;
    private static final String CLUSTER_MANAGER_THROTTLING_RETRY_LISTENER_PATH = "org.opensearch.action.support.master.MasterThrottlingRetryListener";
    private static final String THROTTLED_PENDING_TASK_COUNT_METHOD_NAME = "numberOfThrottledPendingTasks";
    private static final String RETRYING_TASK_COUNT_METHOD_NAME = "getRetryingTasksCount";
    private final StringBuilder value = new StringBuilder();
    private final PerformanceAnalyzerController controller;
    private final ConfigOverridesWrapper configOverridesWrapper;

    public ClusterManagerThrottlingMetricsCollector(PerformanceAnalyzerController controller, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, "ClusterManagerThrottlingMetricsCollector", (MeasurementSet)StatMetrics.CLUSTER_MANAGER_THROTTLING_COLLECTOR_EXECUTION_TIME, StatExceptionCode.CLUSTER_MANAGER_THROTTLING_COLLECTOR_ERROR);
        this.controller = controller;
        this.configOverridesWrapper = configOverridesWrapper;
    }

    public void collectMetrics(long startTime) {
        if (!this.controller.isCollectorEnabled(this.configOverridesWrapper, this.getCollectorName())) {
            return;
        }
        if (Objects.isNull(OpenSearchResources.INSTANCE.getClusterService()) || Objects.isNull(OpenSearchResources.INSTANCE.getClusterService().getMasterService())) {
            return;
        }
        if (!this.isClusterManagerThrottlingFeatureAvailable()) {
            LOG.debug("ClusterManager Throttling Feature is not available for this domain");
            ServiceMetrics.COMMONS_STAT_METRICS_AGGREGATOR.updateStat((MeasurementSet)StatMetrics.CLUSTER_MANAGER_THROTTLING_COLLECTOR_NOT_AVAILABLE, (Number)1);
            return;
        }
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        try {
            this.value.append(new ClusterManagerThrottlingMetrics(this.getRetryingPendingTaskCount(), this.getTotalClusterManagerThrottledTaskCount()).serialize());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((ClusterManagerThrottlingMetricsCollector)this).getCollectorName();
            supplierArray[1] = e::getMessage;
            LOG.debug("[ {} ] Exception raised while getting Cluster Manager throttling metrics: {} ", supplierArray);
            StatsCollector.instance().logException(StatExceptionCode.CLUSTER_MANAGER_THROTTLING_COLLECTOR_ERROR);
            return;
        }
        this.saveMetricValues(this.value.toString(), startTime, new String[0]);
    }

    private boolean isClusterManagerThrottlingFeatureAvailable() {
        try {
            Class.forName(CLUSTER_MANAGER_THROTTLING_RETRY_LISTENER_PATH);
            MasterService.class.getMethod(THROTTLED_PENDING_TASK_COUNT_METHOD_NAME, new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private long getTotalClusterManagerThrottledTaskCount() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = MasterService.class.getMethod(THROTTLED_PENDING_TASK_COUNT_METHOD_NAME, new Class[0]);
        return (Long)method.invoke((Object)OpenSearchResources.INSTANCE.getClusterService().getMasterService(), new Object[0]);
    }

    private long getRetryingPendingTaskCount() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = Class.forName(CLUSTER_MANAGER_THROTTLING_RETRY_LISTENER_PATH).getMethod(RETRYING_TASK_COUNT_METHOD_NAME, new Class[0]);
        return (Long)method.invoke(null, new Object[0]);
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"cluster_manager_throttling_metrics"});
    }

    public static class ClusterManagerThrottlingMetrics
    extends MetricStatus {
        private final long retryingTaskCount;
        private final long throttledPendingTasksCount;

        public ClusterManagerThrottlingMetrics(long retryingTaskCount, long throttledPendingTasksCount) {
            this.retryingTaskCount = retryingTaskCount;
            this.throttledPendingTasksCount = throttledPendingTasksCount;
        }

        @JsonProperty(value="Data_RetryingPendingTasksCount")
        public long getRetryingTaskCount() {
            return this.retryingTaskCount;
        }

        @JsonProperty(value="ClusterManager_ThrottledPendingTasksCount")
        public long getThrottledPendingTasksCount() {
            return this.throttledPendingTasksCount;
        }
    }
}

