from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.BRepBuilderAPI import *
from OCC.Core.gp import *
from OCC.Core.TopoDS import *
from OCC.Core.Message import *
from OCC.Core.BRepPrim import *
from OCC.Core.TopTools import *
from OCC.Core.BRepSweep import *
from OCC.Core.Geom import *


class BRepPrimAPI_MakeBox(BRepBuilderAPI_MakeShape):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, dx: float, dy: float, dz: float) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt, dx: float, dy: float, dz: float) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt, P2: gp_Pnt) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, dx: float, dy: float, dz: float) -> None: ...
    def BackFace(self) -> TopoDS_Face: ...
    def BottomFace(self) -> TopoDS_Face: ...
    def Build(self, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    def FrontFace(self) -> TopoDS_Face: ...
    @overload
    def Init(self, theDX: float, theDY: float, theDZ: float) -> None: ...
    @overload
    def Init(self, thePnt: gp_Pnt, theDX: float, theDY: float, theDZ: float) -> None: ...
    @overload
    def Init(self, thePnt1: gp_Pnt, thePnt2: gp_Pnt) -> None: ...
    @overload
    def Init(self, theAxes: gp_Ax2, theDX: float, theDY: float, theDZ: float) -> None: ...
    def LeftFace(self) -> TopoDS_Face: ...
    def RightFace(self) -> TopoDS_Face: ...
    def Shell(self) -> TopoDS_Shell: ...
    def Solid(self) -> TopoDS_Solid: ...
    def TopFace(self) -> TopoDS_Face: ...
    def Wedge(self) -> BRepPrim_Wedge: ...

class BRepPrimAPI_MakeHalfSpace(BRepBuilderAPI_MakeShape):
    @overload
    def __init__(self, Face: TopoDS_Face, RefPnt: gp_Pnt) -> None: ...
    @overload
    def __init__(self, Shell: TopoDS_Shell, RefPnt: gp_Pnt) -> None: ...
    def Solid(self) -> TopoDS_Solid: ...

class BRepPrimAPI_MakeOneAxis(BRepBuilderAPI_MakeShape):
    def Build(self, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    def Face(self) -> TopoDS_Face: ...
    def OneAxis(self) -> None: ...
    def Shell(self) -> TopoDS_Shell: ...
    def Solid(self) -> TopoDS_Solid: ...

class BRepPrimAPI_MakeSweep(BRepBuilderAPI_MakeShape):
    def FirstShape(self) -> TopoDS_Shape: ...
    def LastShape(self) -> TopoDS_Shape: ...

class BRepPrimAPI_MakeWedge(BRepBuilderAPI_MakeShape):
    @overload
    def __init__(self, dx: float, dy: float, dz: float, ltx: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, dx: float, dy: float, dz: float, ltx: float) -> None: ...
    @overload
    def __init__(self, dx: float, dy: float, dz: float, xmin: float, zmin: float, xmax: float, zmax: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, dx: float, dy: float, dz: float, xmin: float, zmin: float, xmax: float, zmax: float) -> None: ...
    def Build(self, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    def Shell(self) -> TopoDS_Shell: ...
    def Solid(self) -> TopoDS_Solid: ...
    def Wedge(self) -> BRepPrim_Wedge: ...

class BRepPrimAPI_MakeCone(BRepPrimAPI_MakeOneAxis):
    @overload
    def __init__(self, R1: float, R2: float, H: float) -> None: ...
    @overload
    def __init__(self, R1: float, R2: float, H: float, angle: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, R1: float, R2: float, H: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, R1: float, R2: float, H: float, angle: float) -> None: ...
    def Cone(self) -> BRepPrim_Cone: ...
    def OneAxis(self) -> None: ...

class BRepPrimAPI_MakeCylinder(BRepPrimAPI_MakeOneAxis):
    @overload
    def __init__(self, R: float, H: float) -> None: ...
    @overload
    def __init__(self, R: float, H: float, Angle: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, R: float, H: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, R: float, H: float, Angle: float) -> None: ...
    def Cylinder(self) -> BRepPrim_Cylinder: ...
    def OneAxis(self) -> None: ...

class BRepPrimAPI_MakePrism(BRepPrimAPI_MakeSweep):
    @overload
    def __init__(self, S: TopoDS_Shape, V: gp_Vec, Copy: Optional[bool] = False, Canonize: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape, D: gp_Dir, Inf: Optional[bool] = True, Copy: Optional[bool] = False, Canonize: Optional[bool] = True) -> None: ...
    def Build(self, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    @overload
    def FirstShape(self) -> TopoDS_Shape: ...
    @overload
    def FirstShape(self, theShape: TopoDS_Shape) -> TopoDS_Shape: ...
    def Generated(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def IsDeleted(self, S: TopoDS_Shape) -> bool: ...
    @overload
    def LastShape(self) -> TopoDS_Shape: ...
    @overload
    def LastShape(self, theShape: TopoDS_Shape) -> TopoDS_Shape: ...
    def Prism(self) -> BRepSweep_Prism: ...

class BRepPrimAPI_MakeRevol(BRepPrimAPI_MakeSweep):
    @overload
    def __init__(self, S: TopoDS_Shape, A: gp_Ax1, D: float, Copy: Optional[bool] = False) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape, A: gp_Ax1, Copy: Optional[bool] = False) -> None: ...
    def Build(self, theRange: Optional[Message_ProgressRange] = Message_ProgressRange()) -> None: ...
    def Degenerated(self) -> TopTools_ListOfShape: ...
    @overload
    def FirstShape(self) -> TopoDS_Shape: ...
    @overload
    def FirstShape(self, theShape: TopoDS_Shape) -> TopoDS_Shape: ...
    def Generated(self, S: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def HasDegenerated(self) -> bool: ...
    def IsDeleted(self, S: TopoDS_Shape) -> bool: ...
    @overload
    def LastShape(self) -> TopoDS_Shape: ...
    @overload
    def LastShape(self, theShape: TopoDS_Shape) -> TopoDS_Shape: ...
    def Revol(self) -> BRepSweep_Revol: ...

class BRepPrimAPI_MakeRevolution(BRepPrimAPI_MakeOneAxis):
    @overload
    def __init__(self, Meridian: Geom_Curve) -> None: ...
    @overload
    def __init__(self, Meridian: Geom_Curve, angle: float) -> None: ...
    @overload
    def __init__(self, Meridian: Geom_Curve, VMin: float, VMax: float) -> None: ...
    @overload
    def __init__(self, Meridian: Geom_Curve, VMin: float, VMax: float, angle: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, Meridian: Geom_Curve) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, Meridian: Geom_Curve, angle: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, Meridian: Geom_Curve, VMin: float, VMax: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, Meridian: Geom_Curve, VMin: float, VMax: float, angle: float) -> None: ...
    def OneAxis(self) -> None: ...
    def Revolution(self) -> BRepPrim_Revolution: ...

class BRepPrimAPI_MakeSphere(BRepPrimAPI_MakeOneAxis):
    @overload
    def __init__(self, R: float) -> None: ...
    @overload
    def __init__(self, R: float, angle: float) -> None: ...
    @overload
    def __init__(self, R: float, angle1: float, angle2: float) -> None: ...
    @overload
    def __init__(self, R: float, angle1: float, angle2: float, angle3: float) -> None: ...
    @overload
    def __init__(self, Center: gp_Pnt, R: float) -> None: ...
    @overload
    def __init__(self, Center: gp_Pnt, R: float, angle: float) -> None: ...
    @overload
    def __init__(self, Center: gp_Pnt, R: float, angle1: float, angle2: float) -> None: ...
    @overload
    def __init__(self, Center: gp_Pnt, R: float, angle1: float, angle2: float, angle3: float) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax2, R: float) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax2, R: float, angle: float) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax2, R: float, angle1: float, angle2: float) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax2, R: float, angle1: float, angle2: float, angle3: float) -> None: ...
    def OneAxis(self) -> None: ...
    def Sphere(self) -> BRepPrim_Sphere: ...

class BRepPrimAPI_MakeTorus(BRepPrimAPI_MakeOneAxis):
    @overload
    def __init__(self, R1: float, R2: float) -> None: ...
    @overload
    def __init__(self, R1: float, R2: float, angle: float) -> None: ...
    @overload
    def __init__(self, R1: float, R2: float, angle1: float, angle2: float) -> None: ...
    @overload
    def __init__(self, R1: float, R2: float, angle1: float, angle2: float, angle: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, R1: float, R2: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, R1: float, R2: float, angle: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, R1: float, R2: float, angle1: float, angle2: float) -> None: ...
    @overload
    def __init__(self, Axes: gp_Ax2, R1: float, R2: float, angle1: float, angle2: float, angle: float) -> None: ...
    def OneAxis(self) -> None: ...
    def Torus(self) -> BRepPrim_Torus: ...

# harray1 classes
# harray2 classes
# hsequence classes

