/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayReference
extends Reference {
    public Expression receiver;
    public Expression position;

    public ArrayReference(Expression expression, Expression expression2) {
        this.receiver = expression;
        this.position = expression2;
        this.sourceStart = expression.sourceStart;
    }

    @Override
    public FlowInfo analyseAssignment(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean bl) {
        flowContext.recordAbruptExit();
        if (assignment.expression == null) {
            return this.analyseCode(blockScope, flowContext, flowInfo);
        }
        flowInfo = assignment.expression.analyseCode(blockScope, flowContext, this.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits());
        if (blockScope.environment().usesNullTypeAnnotations()) {
            this.checkAgainstNullTypeAnnotation(blockScope, this.resolvedType, assignment.expression, flowContext, flowInfo);
        }
        return flowInfo;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.receiver.analyseCode(blockScope, flowContext, flowInfo);
        this.receiver.checkNPE(blockScope, flowContext, flowInfo, 1);
        flowInfo = this.position.analyseCode(blockScope, flowContext, flowInfo);
        this.position.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
        flowContext.recordAbruptExit();
        return flowInfo;
    }

    @Override
    public boolean checkNPE(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, int n) {
        if ((this.resolvedType.tagBits & 0x80000000000000L) != 0L) {
            blockScope.problemReporter().arrayReferencePotentialNullReference(this);
            return true;
        }
        return super.checkNPE(blockScope, flowContext, flowInfo, n);
    }

    @Override
    public void generateAssignment(BlockScope blockScope, CodeStream codeStream, Assignment assignment, boolean bl) {
        int n = codeStream.position;
        this.receiver.generateCode(blockScope, codeStream, true);
        if (this.receiver instanceof CastExpression && ((CastExpression)this.receiver).innermostCastedExpression().resolvedType == TypeBinding.NULL) {
            codeStream.checkcast(this.receiver.resolvedType);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
        this.position.generateCode(blockScope, codeStream, true);
        assignment.expression.generateCode(blockScope, codeStream, true);
        codeStream.arrayAtPut(this.resolvedType.id, bl);
        if (bl) {
            codeStream.generateImplicitConversion(assignment.implicitConversion);
        }
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        this.receiver.generateCode(blockScope, codeStream, true);
        if (this.receiver instanceof CastExpression && ((CastExpression)this.receiver).innermostCastedExpression().resolvedType == TypeBinding.NULL) {
            codeStream.checkcast(this.receiver.resolvedType);
        }
        this.position.generateCode(blockScope, codeStream, true);
        codeStream.arrayAt(this.resolvedType.id);
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            boolean bl2;
            boolean bl3 = bl2 = (this.implicitConversion & 0x400) != 0;
            if (bl2) {
                codeStream.generateImplicitConversion(this.implicitConversion);
            }
            switch (bl2 ? this.postConversionType((Scope)blockScope).id : this.resolvedType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public void generateCompoundAssignment(BlockScope blockScope, CodeStream codeStream, Expression expression, int n, int n2, boolean bl) {
        this.receiver.generateCode(blockScope, codeStream, true);
        if (this.receiver instanceof CastExpression && ((CastExpression)this.receiver).innermostCastedExpression().resolvedType == TypeBinding.NULL) {
            codeStream.checkcast(this.receiver.resolvedType);
        }
        this.position.generateCode(blockScope, codeStream, true);
        codeStream.dup2();
        codeStream.arrayAt(this.resolvedType.id);
        int n3 = (this.implicitConversion & 0xFF) >> 4;
        switch (n3) {
            case 0: 
            case 1: 
            case 11: {
                codeStream.generateStringConcatenationAppend(blockScope, null, expression);
                break;
            }
            default: {
                codeStream.generateImplicitConversion(this.implicitConversion);
                if (expression == IntLiteral.One) {
                    codeStream.generateConstant(expression.constant, this.implicitConversion);
                } else {
                    expression.generateCode(blockScope, codeStream, true);
                }
                codeStream.sendOperator(n, n3);
                codeStream.generateImplicitConversion(n2);
            }
        }
        codeStream.arrayAtPut(this.resolvedType.id, bl);
    }

    @Override
    public void generatePostIncrement(BlockScope blockScope, CodeStream codeStream, CompoundAssignment compoundAssignment, boolean bl) {
        this.receiver.generateCode(blockScope, codeStream, true);
        if (this.receiver instanceof CastExpression && ((CastExpression)this.receiver).innermostCastedExpression().resolvedType == TypeBinding.NULL) {
            codeStream.checkcast(this.receiver.resolvedType);
        }
        this.position.generateCode(blockScope, codeStream, true);
        codeStream.dup2();
        codeStream.arrayAt(this.resolvedType.id);
        if (bl) {
            switch (this.resolvedType.id) {
                case 7: 
                case 8: {
                    codeStream.dup2_x2();
                    break;
                }
                default: {
                    codeStream.dup_x2();
                }
            }
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.generateConstant(compoundAssignment.expression.constant, this.implicitConversion);
        codeStream.sendOperator(compoundAssignment.operator, this.implicitConversion & 0xF);
        codeStream.generateImplicitConversion(compoundAssignment.preAssignImplicitConversion);
        codeStream.arrayAtPut(this.resolvedType.id, false);
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        this.receiver.printExpression(0, stringBuffer).append('[');
        return this.position.printExpression(0, stringBuffer).append(']');
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding;
        TypeBinding typeBinding2;
        this.constant = Constant.NotAConstant;
        if (this.receiver instanceof CastExpression && ((CastExpression)this.receiver).innermostCastedExpression() instanceof NullLiteral) {
            this.receiver.bits |= 0x20;
        }
        if ((typeBinding2 = this.receiver.resolveType(blockScope)) != null) {
            this.receiver.computeConversion(blockScope, typeBinding2, typeBinding2);
            if (typeBinding2.isArrayType()) {
                typeBinding = ((ArrayBinding)typeBinding2).elementsType();
                this.resolvedType = (this.bits & 0x2000) == 0 ? typeBinding.capture(blockScope, this.sourceStart, this.sourceEnd) : typeBinding;
            } else {
                blockScope.problemReporter().referenceMustBeArrayTypeAt(typeBinding2, this);
            }
        }
        if ((typeBinding = this.position.resolveTypeExpecting(blockScope, TypeBinding.INT)) != null) {
            this.position.computeConversion(blockScope, TypeBinding.INT, typeBinding);
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.receiver.traverse(aSTVisitor, blockScope);
            this.position.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        if (this.resolvedType != null && (this.resolvedType.tagBits & 0x180000000000000L) == 0L && this.resolvedType.isFreeTypeVariable()) {
            return 48;
        }
        return super.nullStatus(flowInfo, flowContext);
    }
}

