/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public final class ArrayBinding
extends TypeBinding {
    public static final FieldBinding ArrayLength = new FieldBinding(TypeConstants.LENGTH, TypeBinding.INT, 17, null, Constant.NotAConstant);
    public TypeBinding leafComponentType;
    public int dimensions;
    LookupEnvironment environment;
    char[] constantPoolName;
    char[] genericTypeSignature;
    public long[] nullTagBitsPerDimension;
    private MethodBinding clone;

    public ArrayBinding(TypeBinding typeBinding, int n, LookupEnvironment lookupEnvironment) {
        this.tagBits |= 1L;
        this.leafComponentType = typeBinding;
        this.dimensions = n;
        this.environment = lookupEnvironment;
        if (typeBinding instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)typeBinding).addWrapper(this, lookupEnvironment);
        } else {
            this.tagBits |= typeBinding.tagBits & 0x2000000060000880L;
        }
        long l = typeBinding.tagBits & 0x180000000000000L;
        if (l != 0L) {
            this.nullTagBitsPerDimension = new long[this.dimensions + 1];
            this.nullTagBitsPerDimension[this.dimensions] = l;
            this.tagBits |= 0x100000L;
        }
    }

    @Override
    public TypeBinding closestMatch() {
        if (this.isValidBinding()) {
            return this;
        }
        TypeBinding typeBinding = this.leafComponentType.closestMatch();
        if (typeBinding == null) {
            return null;
        }
        return this.environment.createArrayType(this.leafComponentType.closestMatch(), this.dimensions);
    }

    @Override
    public List<TypeBinding> collectMissingTypes(List<TypeBinding> list) {
        if ((this.tagBits & 0x80L) != 0L) {
            list = this.leafComponentType.collectMissingTypes(list);
        }
        return list;
    }

    @Override
    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, InferenceContext inferenceContext, int n) {
        if ((this.tagBits & 0x20000000L) == 0L) {
            return;
        }
        if (typeBinding == TypeBinding.NULL || typeBinding.kind() == 65540) {
            return;
        }
        switch (typeBinding.kind()) {
            case 68: {
                int n2 = typeBinding.dimensions();
                if (n2 == this.dimensions) {
                    this.leafComponentType.collectSubstitutes(scope, typeBinding.leafComponentType(), inferenceContext, n);
                    break;
                }
                if (n2 <= this.dimensions) break;
                ArrayBinding arrayBinding = this.environment.createArrayType(typeBinding.leafComponentType(), n2 - this.dimensions);
                this.leafComponentType.collectSubstitutes(scope, arrayBinding, inferenceContext, n);
                break;
            }
        }
    }

    @Override
    public boolean mentionsAny(TypeBinding[] typeBindingArray, int n) {
        return this.leafComponentType.mentionsAny(typeBindingArray, n);
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> set) {
        this.leafComponentType.collectInferenceVariables(set);
    }

    @Override
    TypeBinding substituteInferenceVariable(InferenceVariable inferenceVariable, TypeBinding typeBinding) {
        TypeBinding typeBinding2 = this.leafComponentType.substituteInferenceVariable(inferenceVariable, typeBinding);
        if (TypeBinding.notEquals(typeBinding2, this.leafComponentType)) {
            return this.environment.createArrayType(typeBinding2, this.dimensions, this.typeAnnotations);
        }
        return this;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        char[] cArray = new char[this.dimensions];
        for (int i = this.dimensions - 1; i >= 0; --i) {
            cArray[i] = 91;
        }
        return CharOperation.concat(cArray, this.leafComponentType.computeUniqueKey(bl));
    }

    @Override
    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        char[] cArray = new char[this.dimensions];
        for (int i = this.dimensions - 1; i >= 0; --i) {
            cArray[i] = 91;
        }
        this.constantPoolName = CharOperation.concat(cArray, this.leafComponentType.signature());
        return this.constantPoolName;
    }

    @Override
    public String debugName() {
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuilder stringBuilder = new StringBuilder(this.dimensions * 2);
        int n = this.dimensions;
        while (--n >= 0) {
            stringBuilder.append("[]");
        }
        return this.leafComponentType.debugName() + stringBuilder.toString();
    }

    @Override
    public String annotatedDebugName() {
        StringBuilder stringBuilder = new StringBuilder(this.dimensions * 2);
        stringBuilder.append(this.leafComponentType.annotatedDebugName());
        stringBuilder.append(' ');
        AnnotationBinding[] annotationBindingArray = this.getTypeAnnotations();
        int n = -1;
        for (int i = 0; i < this.dimensions; ++i) {
            if (annotationBindingArray != null) {
                if (i != 0) {
                    stringBuilder.append(' ');
                }
                while (++n < annotationBindingArray.length && annotationBindingArray[n] != null) {
                    stringBuilder.append(annotationBindingArray[n]);
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    @Override
    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding elementsType() {
        int n;
        if (this.dimensions == 1) {
            return this.leafComponentType;
        }
        AnnotationBinding[] annotationBindingArray = this.getTypeAnnotations();
        AnnotationBinding[] annotationBindingArray2 = Binding.NO_ANNOTATIONS;
        int n2 = n = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        for (int i = 0; i < n; ++i) {
            if (annotationBindingArray[i] != null) continue;
            annotationBindingArray2 = new AnnotationBinding[n - i - 1];
            System.arraycopy(annotationBindingArray, i + 1, annotationBindingArray2, 0, n - i - 1);
            break;
        }
        return this.environment.createArrayType(this.leafComponentType, this.dimensions - 1, annotationBindingArray2);
    }

    @Override
    public TypeBinding erasure() {
        TypeBinding typeBinding = this.leafComponentType.erasure();
        if (TypeBinding.notEquals(this.leafComponentType, typeBinding)) {
            return this.environment.createArrayType(typeBinding, this.dimensions);
        }
        return this;
    }

    @Override
    public ArrayBinding upwardsProjection(Scope scope, TypeBinding[] typeBindingArray) {
        TypeBinding typeBinding = this.leafComponentType.upwardsProjection(scope, typeBindingArray);
        return scope.environment().createArrayType(typeBinding, this.dimensions, this.typeAnnotations);
    }

    @Override
    public ArrayBinding downwardsProjection(Scope scope, TypeBinding[] typeBindingArray) {
        TypeBinding typeBinding = this.leafComponentType.downwardsProjection(scope, typeBindingArray);
        return scope.environment().createArrayType(typeBinding, this.dimensions, this.typeAnnotations);
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    @Override
    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            char[] cArray = new char[this.dimensions];
            for (int i = this.dimensions - 1; i >= 0; --i) {
                cArray[i] = 91;
            }
            this.genericTypeSignature = CharOperation.concat(cArray, this.leafComponentType.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    @Override
    public PackageBinding getPackage() {
        return this.leafComponentType.getPackage();
    }

    public int hashCode() {
        return this.leafComponentType == null ? super.hashCode() : this.leafComponentType.hashCode();
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (ArrayBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                if (arrayBinding.leafComponentType.isBaseType()) {
                    return false;
                }
                if (this.dimensions == arrayBinding.dimensions) {
                    return this.leafComponentType.isCompatibleWith(arrayBinding.leafComponentType);
                }
                if (this.dimensions >= arrayBinding.dimensions) break;
                return false;
            }
            case 132: {
                return false;
            }
            case 516: 
            case 8196: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 32772: {
                for (ReferenceBinding referenceBinding : ((IntersectionTypeBinding18)typeBinding).intersectingTypes) {
                    if (this.isCompatibleWith(referenceBinding, scope)) continue;
                    return false;
                }
                return true;
            }
            case 4100: {
                if (typeBinding.isCapture()) {
                    CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                    TypeBinding typeBinding2 = captureBinding.lowerBound;
                    if (typeBinding2 != null) {
                        if (!typeBinding2.isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith(typeBinding2, scope);
                    }
                }
                return false;
            }
        }
        switch (typeBinding.leafComponentType().id) {
            case 1: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding typeBinding, boolean bl) {
        if (ArrayBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                if (arrayBinding.leafComponentType.isBaseType()) {
                    return false;
                }
                if (this.dimensions == arrayBinding.dimensions) {
                    return this.leafComponentType.isSubtypeOf(arrayBinding.leafComponentType, bl);
                }
                if (this.dimensions >= arrayBinding.dimensions) break;
                return false;
            }
            case 132: {
                return false;
            }
            case 32772: {
                for (ReferenceBinding referenceBinding : ((IntersectionTypeBinding18)typeBinding).intersectingTypes) {
                    if (this.isSubtypeOf(referenceBinding, bl)) continue;
                    return false;
                }
                return true;
            }
            case 4100: {
                if (!typeBinding.isCapture()) break;
                CaptureBinding captureBinding = (CaptureBinding)typeBinding;
                TypeBinding typeBinding2 = captureBinding.lowerBound;
                if (typeBinding2 == null) break;
                if (!typeBinding2.isArrayType()) {
                    return false;
                }
                return this.isSubtypeOf(typeBinding2, bl);
            }
        }
        switch (typeBinding.leafComponentType().id) {
            case 1: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isProperType(boolean bl) {
        return this.leafComponentType.isProperType(bl);
    }

    @Override
    public int kind() {
        return 68;
    }

    @Override
    public TypeBinding leafComponentType() {
        return this.leafComponentType;
    }

    @Override
    public char[] nullAnnotatedReadableName(CompilerOptions compilerOptions, boolean bl) {
        if (this.nullTagBitsPerDimension == null) {
            return bl ? this.shortReadableName() : this.readableName();
        }
        char[][] cArrayArray = new char[this.dimensions][];
        for (int i = 0; i < this.dimensions; ++i) {
            if ((this.nullTagBitsPerDimension[i] & 0x180000000000000L) != 0L) {
                char[][] cArray = (this.nullTagBitsPerDimension[i] & 0x100000000000000L) != 0L ? compilerOptions.nonNullAnnotationName : compilerOptions.nullableAnnotationName;
                char[] cArray2 = bl ? cArray[cArray.length - 1] : CharOperation.concatWith(cArray, '.');
                cArrayArray[i] = new char[cArray2.length + 3];
                cArrayArray[i][0] = 64;
                System.arraycopy(cArray2, 0, cArrayArray[i], 1, cArray2.length);
                cArrayArray[i][cArray2.length + 1] = 91;
                cArrayArray[i][cArray2.length + 2] = 93;
                continue;
            }
            cArrayArray[i] = new char[]{'[', ']'};
        }
        return CharOperation.concat(this.leafComponentType.nullAnnotatedReadableName(compilerOptions, bl), CharOperation.concatWith(cArrayArray, ' '), ' ');
    }

    @Override
    public int problemId() {
        return this.leafComponentType.problemId();
    }

    @Override
    public char[] qualifiedSourceName() {
        char[] cArray = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            cArray[i] = 93;
            cArray[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.qualifiedSourceName(), cArray);
    }

    @Override
    public char[] readableName() {
        char[] cArray = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            cArray[i] = 93;
            cArray[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.readableName(), cArray);
    }

    @Override
    public void setTypeAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
        this.tagBits |= 0x200000L;
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            return;
        }
        this.typeAnnotations = annotationBindingArray;
        if (bl) {
            long l = 0L;
            if (this.nullTagBitsPerDimension == null) {
                this.nullTagBitsPerDimension = new long[this.dimensions + 1];
            }
            int n = 0;
            for (AnnotationBinding annotationBinding : annotationBindingArray) {
                if (annotationBinding != null) {
                    if (annotationBinding.type.hasNullBit(64)) {
                        l |= 0x80000000000000L;
                        this.tagBits |= 0x100000L;
                        continue;
                    }
                    if (!annotationBinding.type.hasNullBit(32)) continue;
                    l |= 0x100000000000000L;
                    this.tagBits |= 0x100000L;
                    continue;
                }
                if (l != 0L) {
                    this.nullTagBitsPerDimension[n] = l;
                    l = 0L;
                }
                ++n;
            }
            this.tagBits |= this.nullTagBitsPerDimension[0];
        }
    }

    @Override
    public char[] shortReadableName() {
        char[] cArray = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            cArray[i] = 93;
            cArray[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.shortReadableName(), cArray);
    }

    @Override
    public char[] sourceName() {
        char[] cArray = new char[this.dimensions * 2];
        for (int i = this.dimensions * 2 - 1; i >= 0; i -= 2) {
            cArray[i] = 93;
            cArray[i - 1] = 91;
        }
        return CharOperation.concat(this.leafComponentType.sourceName(), cArray);
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
        if (this.leafComponentType == unresolvedReferenceBinding) {
            this.leafComponentType = lookupEnvironment.convertUnresolvedBinaryToRawType(referenceBinding);
            if (this.leafComponentType != referenceBinding) {
                this.id = lookupEnvironment.createArrayType((TypeBinding)this.leafComponentType, (int)this.dimensions, (AnnotationBinding[])this.typeAnnotations).id;
            }
            this.tagBits |= this.leafComponentType.tagBits & 0x2000000060000080L;
        }
    }

    public String toString() {
        return this.leafComponentType != null ? this.debugName() : "NULL TYPE ARRAY";
    }

    @Override
    public TypeBinding unannotated() {
        return this.hasTypeAnnotations() ? this.environment.getUnannotatedType(this) : this;
    }

    @Override
    public TypeBinding withoutToplevelNullAnnotation() {
        if (!this.hasNullTypeAnnotations()) {
            return this;
        }
        AnnotationBinding[] annotationBindingArray = this.environment.filterNullTypeAnnotations(this.typeAnnotations);
        return this.environment.createArrayType(this.leafComponentType, this.dimensions, annotationBindingArray);
    }

    @Override
    public TypeBinding uncapture(Scope scope) {
        if ((this.tagBits & 0x2000000000000000L) == 0L) {
            return this;
        }
        TypeBinding typeBinding = this.leafComponentType.uncapture(scope);
        return scope.environment().createArrayType(typeBinding, this.dimensions, this.typeAnnotations);
    }

    @Override
    public boolean acceptsNonNullDefault() {
        return true;
    }

    @Override
    public long updateTagBits() {
        if (this.leafComponentType != null) {
            this.tagBits |= this.leafComponentType.updateTagBits();
        }
        return super.updateTagBits();
    }

    public MethodBinding getCloneMethod(final MethodBinding methodBinding) {
        if (this.clone != null) {
            return this.clone;
        }
        MethodBinding methodBinding2 = new MethodBinding(){

            @Override
            public char[] signature(ClassFile classFile) {
                return methodBinding.signature();
            }
        };
        methodBinding2.modifiers = methodBinding.modifiers;
        methodBinding2.selector = methodBinding.selector;
        methodBinding2.declaringClass = methodBinding.declaringClass;
        methodBinding2.typeVariables = Binding.NO_TYPE_VARIABLES;
        methodBinding2.parameters = methodBinding.parameters;
        methodBinding2.thrownExceptions = Binding.NO_EXCEPTIONS;
        methodBinding2.tagBits = methodBinding.tagBits;
        TypeBinding typeBinding = methodBinding2.returnType = this.environment.globalOptions.sourceLevel >= 0x310000L ? this : methodBinding.returnType;
        if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            if (this.environment.usesNullTypeAnnotations()) {
                methodBinding2.returnType = this.environment.createAnnotatedType(methodBinding2.returnType, new AnnotationBinding[]{this.environment.getNonNullAnnotation()});
            } else {
                methodBinding2.tagBits |= 0x100000000000000L;
            }
        }
        if ((methodBinding2.returnType.tagBits & 0x80L) != 0L) {
            methodBinding2.tagBits |= 0x80L;
        }
        this.clone = methodBinding2;
        return this.clone;
    }

    public static boolean isArrayClone(TypeBinding typeBinding, MethodBinding methodBinding) {
        if (typeBinding instanceof ArrayBinding) {
            MethodBinding methodBinding2 = ((ArrayBinding)typeBinding).clone;
            return methodBinding2 != null && methodBinding == methodBinding2;
        }
        return false;
    }
}

