// Generated by gmmproc 2.76.0 -- DO NOT MODIFY!
#ifndef _GTKMM_ALERTDIALOG_H
#define _GTKMM_ALERTDIALOG_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2022 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>
#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>
#include <gtk/gtk.h>
#include <vector>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API AlertDialog_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
class Window;

/** A %Gtk::AlertDialog object collects the arguments that
 * are needed to present a message to the user.
 *
 * The message is shown with the choose() method. This API follows the GIO
 * async pattern, and the result can be obtained by calling choose_finish().
 *
 * If you don't need to wait for a button to be clicked, you can use show().
 *
 * @ingroup Dialogs
 * @newin{4,10}
 */

class GTKMM_API AlertDialog : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = AlertDialog;
  using CppClassType = AlertDialog_Class;
  using BaseObjectType = GtkAlertDialog;
  using BaseClassType = GtkAlertDialogClass;

  // noncopyable
  AlertDialog(const AlertDialog&) = delete;
  AlertDialog& operator=(const AlertDialog&) = delete;

private:  friend class AlertDialog_Class;
  static CppClassType alertdialog_class_;

protected:
  explicit AlertDialog(const Glib::ConstructParams& construct_params);
  explicit AlertDialog(GtkAlertDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  AlertDialog(AlertDialog&& src) noexcept;
  AlertDialog& operator=(AlertDialog&& src) noexcept;

  ~AlertDialog() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkAlertDialog*       gobj()       { return reinterpret_cast<GtkAlertDialog*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkAlertDialog* gobj() const { return reinterpret_cast<GtkAlertDialog*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkAlertDialog* gobj_copy();

private:

     
protected:
  AlertDialog();

  /** Creates a new %Gtk::AlertDialog with the given message.
   * @param message The message.
   */
    explicit AlertDialog(const Glib::ustring& message);


public:
  
  static Glib::RefPtr<AlertDialog> create();


  /** Creates a new %Gtk::AlertDialog with the given message.
   * @param message The message.
   */
  
  static Glib::RefPtr<AlertDialog> create(const Glib::ustring& message);


  /** Returns whether the alert blocks interaction
   * with the parent window while it is presented.
   * 
   * @newin{4,10}
   * 
   * @return <tt>true</tt> if the alert is modal.
   */
  bool get_modal() const;
  
  /** Sets whether the alert blocks interaction
   * with the parent window while it is presented.
   * 
   * @newin{4,10}
   * 
   * @param modal The new value.
   */
  void set_modal(bool modal =  true);
  
  /** Returns the message that will be shown in the alert.
   * 
   * @newin{4,10}
   * 
   * @return The message.
   */
  Glib::ustring get_message() const;
  
  /** Sets the message that will be shown in the alert.
   * 
   * @newin{4,10}
   * 
   * @param message The new message.
   */
  void set_message(const Glib::ustring& message);
  
  /** Returns the detail text that will be shown in the alert.
   * 
   * @newin{4,10}
   * 
   * @return The detail text.
   */
  Glib::ustring get_detail() const;
  
  /** Sets the detail text that will be shown in the alert.
   * 
   * @newin{4,10}
   * 
   * @param detail The new detail text.
   */
  void set_detail(const Glib::ustring& detail);

 
  /** Returns the button labels for the alert.
   * 
   * @newin{4,10}
   * 
   * @return The button labels.
   */
  std::vector<Glib::ustring> get_buttons() const;
 

  /** Sets the button labels for the alert.
   * 
   * @newin{4,10}
   * 
   * @param labels The new button labels.
   */
  void set_buttons(const std::vector<Glib::ustring>& labels) const;

  
  /** Returns the index of the cancel button.
   * 
   * @newin{4,10}
   * 
   * @return The index of the cancel button, or -1.
   */
  int get_cancel_button() const;
  
  /** Sets the index of the cancel button.
   * 
   * See property_cancel_button() for
   * details of how this value is used.
   * 
   * @newin{4,10}
   * 
   * @param button The new cancel button.
   */
  void set_cancel_button(int button);
  
  /** Returns the index of the default button.
   * 
   * @newin{4,10}
   * 
   * @return The index of the default button, or -1.
   */
  int get_default_button() const;
  
  /** Sets the index of the default button.
   * 
   * See property_default_button() for
   * details of how this value is used.
   * 
   * @newin{4,10}
   * 
   * @param button The new default button.
   */
  void set_default_button(int button);

  
  /** This function shows the alert to the user.
   * 
   * The @a slot will be called when the alert is dismissed.
   * It should call choose_finish()
   * to obtain the result.
   * 
   * It is ok to pass <tt>nullptr</tt> for the callback if the alert
   * does not have more than one button. A simpler API for
   * this case is show().
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void choose(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A choose() convenience overload.
  void choose(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;
  
  /** Finishes the choose() call
   * and returns the index of the button that was clicked.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The index of the button that was clicked, or -1 if
   * the dialog was cancelled and property_cancel_button()
   * is not set.
   * 
   * @throws Gtk::DialogError
   */
  int choose_finish(const Glib::RefPtr<Gio::AsyncResult>& result) const;

  
  /** Show the alert to the user.
   * 
   * This function is a simple version of choose()
   * intended for dialogs with a single button.
   * If you want to cancel the dialog or if the alert has more than one button,
   * you should use that function instead and provide it with a Cancellable or
   * callback respectively.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   */
  void show(Window& parent);

  /// A show() convenience overload.
  void show();

  /** Whether the alert is modal.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_modal() ;

/** Whether the alert is modal.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_modal() const;

  /** The message for the alert.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_message() ;

/** The message for the alert.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_message() const;

  /** The detail text for the alert.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_detail() ;

/** The detail text for the alert.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_detail() const;

  /** Labels for buttons to show in the alert.
   * 
   * The labels should be translated and may contain
   * a _ to indicate the mnemonic character.
   * 
   * If this property is not set, then a 'Close' button is
   * automatically created.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< std::vector<Glib::ustring> > property_buttons() ;

/** Labels for buttons to show in the alert.
   * 
   * The labels should be translated and may contain
   * a _ to indicate the mnemonic character.
   * 
   * If this property is not set, then a 'Close' button is
   * automatically created.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::vector<Glib::ustring> > property_buttons() const;

  /** This property determines what happens when the Escape key is
   * pressed while the alert is shown.
   * 
   * If this property holds the index of a button in property_buttons(),
   * then pressing Escape is treated as if that button was pressed. If it is -1
   * or not a valid index for the `buttons` array, then an error is returned.
   * 
   * If `buttons` is <tt>nullptr</tt>, then the automatically created 'Close' button
   * is treated as both cancel and default button, so 0 is returned.
   * 
   * @newin{4,10}
   *
   * Default value: -1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_cancel_button() ;

/** This property determines what happens when the Escape key is
   * pressed while the alert is shown.
   * 
   * If this property holds the index of a button in property_buttons(),
   * then pressing Escape is treated as if that button was pressed. If it is -1
   * or not a valid index for the `buttons` array, then an error is returned.
   * 
   * If `buttons` is <tt>nullptr</tt>, then the automatically created 'Close' button
   * is treated as both cancel and default button, so 0 is returned.
   * 
   * @newin{4,10}
   *
   * Default value: -1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_cancel_button() const;

  /** This property determines what happens when the Return key is
   * pressed while the alert is shown.
   * 
   * If this property holds the index of a button in property_buttons(),
   * then pressing Return is treated as if that button was pressed. If it is -1
   * or not a valid index for the `buttons` array, then nothing happens.
   * 
   * If `buttons` is <tt>nullptr</tt>, then the automatically created 'Close' button
   * is treated as both cancel and default button, so 0 is returned.
   * 
   * @newin{4,10}
   *
   * Default value: -1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_default_button() ;

/** This property determines what happens when the Return key is
   * pressed while the alert is shown.
   * 
   * If this property holds the index of a button in property_buttons(),
   * then pressing Return is treated as if that button was pressed. If it is -1
   * or not a valid index for the `buttons` array, then nothing happens.
   * 
   * If `buttons` is <tt>nullptr</tt>, then the automatically created 'Close' button
   * is treated as both cancel and default button, so 0 is returned.
   * 
   * @newin{4,10}
   *
   * Default value: -1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_default_button() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::AlertDialog
   */
  GTKMM_API
  Glib::RefPtr<Gtk::AlertDialog> wrap(GtkAlertDialog* object, bool take_copy = false);
}


#endif /* _GTKMM_ALERTDIALOG_H */

