/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import org.openscience.jmol.app.janocchio.Nmr;

public class NmrResourceHandler {
    private static NmrResourceHandler instance;
    private ResourceBundle stringsResourceBundle;

    private NmrResourceHandler() {
        String language = "en";
        String country = "";
        String localeString = System.getProperty("user.language");
        if (localeString != null) {
            StringTokenizer st = new StringTokenizer(localeString, "_");
            if (st.hasMoreTokens()) {
                language = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                country = st.nextToken();
            }
        }
        this.stringsResourceBundle = ResourceBundle.getBundle(Nmr.path + "Properties.Nmr", new Locale(language, country));
    }

    public static NmrResourceHandler getInstance() {
        return instance == null ? (instance = new NmrResourceHandler()) : instance;
    }

    private synchronized ImageIcon getIcon(String key) {
        String resourceName = null;
        try {
            resourceName = this.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (resourceName != null) {
            String imageName = Nmr.path.replace('.', '/') + "images/" + resourceName;
            URL imageUrl = Nmr.class.getClassLoader().getResource(imageName);
            if (imageUrl != null) {
                return new ImageIcon(imageUrl);
            }
        }
        return null;
    }

    public static String getStringX(String key) {
        return NmrResourceHandler.getInstance().getString(key);
    }

    public static ImageIcon getIconX(String key) {
        return NmrResourceHandler.getInstance().getIcon(key);
    }

    private synchronized String getString(String key) {
        String result = null;
        try {
            result = this.stringsResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result == null ? key : result;
    }
}

