/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "maliit-glib/maliitserver.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface com.meego.inputmethod.uiserver1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MaliitServer
 * @title: MaliitServer
 * @short_description: Generated C code for the com.meego.inputmethod.uiserver1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-com-meego-inputmethod-uiserver1.top_of_page">com.meego.inputmethod.uiserver1</link> D-Bus interface in C.
 */

/* ---- Introspection data for com.meego.inputmethod.uiserver1 ---- */

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_activate_context =
{
  {
    -1,
    (gchar *) "activateContext",
    NULL,
    NULL,
    NULL
  },
  "handle-activate-context",
  FALSE
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_show_input_method =
{
  {
    -1,
    (gchar *) "showInputMethod",
    NULL,
    NULL,
    NULL
  },
  "handle-show-input-method",
  FALSE
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_hide_input_method =
{
  {
    -1,
    (gchar *) "hideInputMethod",
    NULL,
    NULL,
    NULL
  },
  "handle-hide-input-method",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_posX =
{
  {
    -1,
    (gchar *) "posX",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_posY =
{
  {
    -1,
    (gchar *) "posY",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_preeditRectX =
{
  {
    -1,
    (gchar *) "preeditRectX",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_preeditRectY =
{
  {
    -1,
    (gchar *) "preeditRectY",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_preeditRectWidth =
{
  {
    -1,
    (gchar *) "preeditRectWidth",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_preeditRectHeight =
{
  {
    -1,
    (gchar *) "preeditRectHeight",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_posX.parent_struct,
  &_maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_posY.parent_struct,
  &_maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_preeditRectX.parent_struct,
  &_maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_preeditRectY.parent_struct,
  &_maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_preeditRectWidth.parent_struct,
  &_maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_preeditRectHeight.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_mouse_clicked_on_preedit =
{
  {
    -1,
    (gchar *) "mouseClickedOnPreedit",
    (GDBusArgInfo **) &_maliit_server_method_info_mouse_clicked_on_preedit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-mouse-clicked-on-preedit",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_set_preedit_IN_ARG_text =
{
  {
    -1,
    (gchar *) "text",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_set_preedit_IN_ARG_cursorPos =
{
  {
    -1,
    (gchar *) "cursorPos",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_set_preedit_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_set_preedit_IN_ARG_text.parent_struct,
  &_maliit_server_method_info_set_preedit_IN_ARG_cursorPos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_set_preedit =
{
  {
    -1,
    (gchar *) "setPreedit",
    (GDBusArgInfo **) &_maliit_server_method_info_set_preedit_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-preedit",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_update_widget_information_IN_ARG_stateInformation =
{
  {
    -1,
    (gchar *) "stateInformation",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_update_widget_information_IN_ARG_focusChanged =
{
  {
    -1,
    (gchar *) "focusChanged",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_update_widget_information_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_update_widget_information_IN_ARG_stateInformation.parent_struct,
  &_maliit_server_method_info_update_widget_information_IN_ARG_focusChanged.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _maliit_server_method_update_widget_information_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In0",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _maliit_server_method_update_widget_information_annotation_info_pointers[] =
{
  &_maliit_server_method_update_widget_information_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_update_widget_information =
{
  {
    -1,
    (gchar *) "updateWidgetInformation",
    (GDBusArgInfo **) &_maliit_server_method_info_update_widget_information_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_maliit_server_method_update_widget_information_annotation_info_pointers
  },
  "handle-update-widget-information",
  FALSE
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_reset =
{
  {
    -1,
    (gchar *) "reset",
    NULL,
    NULL,
    NULL
  },
  "handle-reset",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_app_orientation_about_to_change_IN_ARG_angle =
{
  {
    -1,
    (gchar *) "angle",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_app_orientation_about_to_change_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_app_orientation_about_to_change_IN_ARG_angle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_app_orientation_about_to_change =
{
  {
    -1,
    (gchar *) "appOrientationAboutToChange",
    (GDBusArgInfo **) &_maliit_server_method_info_app_orientation_about_to_change_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-app-orientation-about-to-change",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_app_orientation_changed_IN_ARG_angle =
{
  {
    -1,
    (gchar *) "angle",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_app_orientation_changed_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_app_orientation_changed_IN_ARG_angle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_app_orientation_changed =
{
  {
    -1,
    (gchar *) "appOrientationChanged",
    (GDBusArgInfo **) &_maliit_server_method_info_app_orientation_changed_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-app-orientation-changed",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_set_copy_paste_state_IN_ARG_copyAvailable =
{
  {
    -1,
    (gchar *) "copyAvailable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_set_copy_paste_state_IN_ARG_pasteAvailable =
{
  {
    -1,
    (gchar *) "pasteAvailable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_set_copy_paste_state_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_set_copy_paste_state_IN_ARG_copyAvailable.parent_struct,
  &_maliit_server_method_info_set_copy_paste_state_IN_ARG_pasteAvailable.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_set_copy_paste_state =
{
  {
    -1,
    (gchar *) "setCopyPasteState",
    (GDBusArgInfo **) &_maliit_server_method_info_set_copy_paste_state_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-copy-paste-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_process_key_event_IN_ARG_keyType =
{
  {
    -1,
    (gchar *) "keyType",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_process_key_event_IN_ARG_keyCode =
{
  {
    -1,
    (gchar *) "keyCode",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_process_key_event_IN_ARG_modifiers =
{
  {
    -1,
    (gchar *) "modifiers",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_process_key_event_IN_ARG_text =
{
  {
    -1,
    (gchar *) "text",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_process_key_event_IN_ARG_autoRepeat =
{
  {
    -1,
    (gchar *) "autoRepeat",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_process_key_event_IN_ARG_count =
{
  {
    -1,
    (gchar *) "count",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_process_key_event_IN_ARG_nativeScanCode =
{
  {
    -1,
    (gchar *) "nativeScanCode",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_process_key_event_IN_ARG_nativeModifiers =
{
  {
    -1,
    (gchar *) "nativeModifiers",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_process_key_event_IN_ARG_time =
{
  {
    -1,
    (gchar *) "time",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_process_key_event_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_process_key_event_IN_ARG_keyType.parent_struct,
  &_maliit_server_method_info_process_key_event_IN_ARG_keyCode.parent_struct,
  &_maliit_server_method_info_process_key_event_IN_ARG_modifiers.parent_struct,
  &_maliit_server_method_info_process_key_event_IN_ARG_text.parent_struct,
  &_maliit_server_method_info_process_key_event_IN_ARG_autoRepeat.parent_struct,
  &_maliit_server_method_info_process_key_event_IN_ARG_count.parent_struct,
  &_maliit_server_method_info_process_key_event_IN_ARG_nativeScanCode.parent_struct,
  &_maliit_server_method_info_process_key_event_IN_ARG_nativeModifiers.parent_struct,
  &_maliit_server_method_info_process_key_event_IN_ARG_time.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_process_key_event =
{
  {
    -1,
    (gchar *) "processKeyEvent",
    (GDBusArgInfo **) &_maliit_server_method_info_process_key_event_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-process-key-event",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_register_attribute_extension_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_register_attribute_extension_IN_ARG_fileName =
{
  {
    -1,
    (gchar *) "fileName",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_register_attribute_extension_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_register_attribute_extension_IN_ARG_id.parent_struct,
  &_maliit_server_method_info_register_attribute_extension_IN_ARG_fileName.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_register_attribute_extension =
{
  {
    -1,
    (gchar *) "registerAttributeExtension",
    (GDBusArgInfo **) &_maliit_server_method_info_register_attribute_extension_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-register-attribute-extension",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_unregister_attribute_extension_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_unregister_attribute_extension_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_unregister_attribute_extension_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_unregister_attribute_extension =
{
  {
    -1,
    (gchar *) "unregisterAttributeExtension",
    (GDBusArgInfo **) &_maliit_server_method_info_unregister_attribute_extension_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unregister-attribute-extension",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_set_extended_attribute_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_set_extended_attribute_IN_ARG_target =
{
  {
    -1,
    (gchar *) "target",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_set_extended_attribute_IN_ARG_targetItem =
{
  {
    -1,
    (gchar *) "targetItem",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_set_extended_attribute_IN_ARG_attribute =
{
  {
    -1,
    (gchar *) "attribute",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_set_extended_attribute_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_set_extended_attribute_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_set_extended_attribute_IN_ARG_id.parent_struct,
  &_maliit_server_method_info_set_extended_attribute_IN_ARG_target.parent_struct,
  &_maliit_server_method_info_set_extended_attribute_IN_ARG_targetItem.parent_struct,
  &_maliit_server_method_info_set_extended_attribute_IN_ARG_attribute.parent_struct,
  &_maliit_server_method_info_set_extended_attribute_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_set_extended_attribute =
{
  {
    -1,
    (gchar *) "setExtendedAttribute",
    (GDBusArgInfo **) &_maliit_server_method_info_set_extended_attribute_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-extended-attribute",
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_method_info_load_plugin_settings_IN_ARG_descriptionLanguage =
{
  {
    -1,
    (gchar *) "descriptionLanguage",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_method_info_load_plugin_settings_IN_ARG_pointers[] =
{
  &_maliit_server_method_info_load_plugin_settings_IN_ARG_descriptionLanguage.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _maliit_server_method_info_load_plugin_settings =
{
  {
    -1,
    (gchar *) "loadPluginSettings",
    (GDBusArgInfo **) &_maliit_server_method_info_load_plugin_settings_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-load-plugin-settings",
  FALSE
};

static const GDBusMethodInfo * const _maliit_server_method_info_pointers[] =
{
  &_maliit_server_method_info_activate_context.parent_struct,
  &_maliit_server_method_info_show_input_method.parent_struct,
  &_maliit_server_method_info_hide_input_method.parent_struct,
  &_maliit_server_method_info_mouse_clicked_on_preedit.parent_struct,
  &_maliit_server_method_info_set_preedit.parent_struct,
  &_maliit_server_method_info_update_widget_information.parent_struct,
  &_maliit_server_method_info_reset.parent_struct,
  &_maliit_server_method_info_app_orientation_about_to_change.parent_struct,
  &_maliit_server_method_info_app_orientation_changed.parent_struct,
  &_maliit_server_method_info_set_copy_paste_state.parent_struct,
  &_maliit_server_method_info_process_key_event.parent_struct,
  &_maliit_server_method_info_register_attribute_extension.parent_struct,
  &_maliit_server_method_info_unregister_attribute_extension.parent_struct,
  &_maliit_server_method_info_set_extended_attribute.parent_struct,
  &_maliit_server_method_info_load_plugin_settings.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _maliit_server_signal_info_invoke_action_ARG_action =
{
  {
    -1,
    (gchar *) "action",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _maliit_server_signal_info_invoke_action_ARG_sequence =
{
  {
    -1,
    (gchar *) "sequence",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _maliit_server_signal_info_invoke_action_ARG_pointers[] =
{
  &_maliit_server_signal_info_invoke_action_ARG_action.parent_struct,
  &_maliit_server_signal_info_invoke_action_ARG_sequence.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _maliit_server_signal_info_invoke_action =
{
  {
    -1,
    (gchar *) "invokeAction",
    (GDBusArgInfo **) &_maliit_server_signal_info_invoke_action_ARG_pointers,
    NULL
  },
  "invoke-action"
};

static const GDBusSignalInfo * const _maliit_server_signal_info_pointers[] =
{
  &_maliit_server_signal_info_invoke_action.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _maliit_server_interface_info =
{
  {
    -1,
    (gchar *) "com.meego.inputmethod.uiserver1",
    (GDBusMethodInfo **) &_maliit_server_method_info_pointers,
    (GDBusSignalInfo **) &_maliit_server_signal_info_pointers,
    NULL,
    NULL
  },
  "server",
};


/**
 * maliit_server_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-com-meego-inputmethod-uiserver1.top_of_page">com.meego.inputmethod.uiserver1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
maliit_server_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_maliit_server_interface_info.parent_struct;
}

/**
 * maliit_server_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MaliitServer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
maliit_server_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * MaliitServer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-com-meego-inputmethod-uiserver1.top_of_page">com.meego.inputmethod.uiserver1</link>.
 */

/**
 * MaliitServerIface:
 * @parent_iface: The parent interface.
 * @handle_activate_context: Handler for the #MaliitServer::handle-activate-context signal.
 * @handle_app_orientation_about_to_change: Handler for the #MaliitServer::handle-app-orientation-about-to-change signal.
 * @handle_app_orientation_changed: Handler for the #MaliitServer::handle-app-orientation-changed signal.
 * @handle_hide_input_method: Handler for the #MaliitServer::handle-hide-input-method signal.
 * @handle_load_plugin_settings: Handler for the #MaliitServer::handle-load-plugin-settings signal.
 * @handle_mouse_clicked_on_preedit: Handler for the #MaliitServer::handle-mouse-clicked-on-preedit signal.
 * @handle_process_key_event: Handler for the #MaliitServer::handle-process-key-event signal.
 * @handle_register_attribute_extension: Handler for the #MaliitServer::handle-register-attribute-extension signal.
 * @handle_reset: Handler for the #MaliitServer::handle-reset signal.
 * @handle_set_copy_paste_state: Handler for the #MaliitServer::handle-set-copy-paste-state signal.
 * @handle_set_extended_attribute: Handler for the #MaliitServer::handle-set-extended-attribute signal.
 * @handle_set_preedit: Handler for the #MaliitServer::handle-set-preedit signal.
 * @handle_show_input_method: Handler for the #MaliitServer::handle-show-input-method signal.
 * @handle_unregister_attribute_extension: Handler for the #MaliitServer::handle-unregister-attribute-extension signal.
 * @handle_update_widget_information: Handler for the #MaliitServer::handle-update-widget-information signal.
 * @invoke_action: Handler for the #MaliitServer::invoke-action signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-com-meego-inputmethod-uiserver1.top_of_page">com.meego.inputmethod.uiserver1</link>.
 */

typedef MaliitServerIface MaliitServerInterface;
G_DEFINE_INTERFACE (MaliitServer, maliit_server, G_TYPE_OBJECT)

static void
maliit_server_default_init (MaliitServerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MaliitServer::handle-activate-context:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.activateContext">activateContext()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_activate_context() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-activate-context",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_activate_context),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MaliitServer::handle-show-input-method:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.showInputMethod">showInputMethod()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_show_input_method() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-input-method",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_show_input_method),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MaliitServer::handle-hide-input-method:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.hideInputMethod">hideInputMethod()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_hide_input_method() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hide-input-method",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_hide_input_method),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MaliitServer::handle-mouse-clicked-on-preedit:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_posX: Argument passed by remote caller.
   * @arg_posY: Argument passed by remote caller.
   * @arg_preeditRectX: Argument passed by remote caller.
   * @arg_preeditRectY: Argument passed by remote caller.
   * @arg_preeditRectWidth: Argument passed by remote caller.
   * @arg_preeditRectHeight: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.mouseClickedOnPreedit">mouseClickedOnPreedit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_mouse_clicked_on_preedit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-mouse-clicked-on-preedit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_mouse_clicked_on_preedit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);

  /**
   * MaliitServer::handle-set-preedit:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_text: Argument passed by remote caller.
   * @arg_cursorPos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setPreedit">setPreedit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_set_preedit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-preedit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_set_preedit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_INT);

  /**
   * MaliitServer::handle-update-widget-information:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_stateInformation: Argument passed by remote caller.
   * @arg_focusChanged: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.updateWidgetInformation">updateWidgetInformation()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_update_widget_information() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update-widget-information",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_update_widget_information),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_BOOLEAN);

  /**
   * MaliitServer::handle-reset:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.reset">reset()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_reset() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reset",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_reset),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MaliitServer::handle-app-orientation-about-to-change:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_angle: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.appOrientationAboutToChange">appOrientationAboutToChange()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_app_orientation_about_to_change() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-app-orientation-about-to-change",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_app_orientation_about_to_change),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * MaliitServer::handle-app-orientation-changed:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_angle: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.appOrientationChanged">appOrientationChanged()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_app_orientation_changed() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-app-orientation-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_app_orientation_changed),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * MaliitServer::handle-set-copy-paste-state:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_copyAvailable: Argument passed by remote caller.
   * @arg_pasteAvailable: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setCopyPasteState">setCopyPasteState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_set_copy_paste_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-copy-paste-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_set_copy_paste_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * MaliitServer::handle-process-key-event:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_keyType: Argument passed by remote caller.
   * @arg_keyCode: Argument passed by remote caller.
   * @arg_modifiers: Argument passed by remote caller.
   * @arg_text: Argument passed by remote caller.
   * @arg_autoRepeat: Argument passed by remote caller.
   * @arg_count: Argument passed by remote caller.
   * @arg_nativeScanCode: Argument passed by remote caller.
   * @arg_nativeModifiers: Argument passed by remote caller.
   * @arg_time: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.processKeyEvent">processKeyEvent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_process_key_event() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-process-key-event",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_process_key_event),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    10,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * MaliitServer::handle-register-attribute-extension:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_fileName: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.registerAttributeExtension">registerAttributeExtension()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_register_attribute_extension() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-attribute-extension",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_register_attribute_extension),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_STRING);

  /**
   * MaliitServer::handle-unregister-attribute-extension:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.unregisterAttributeExtension">unregisterAttributeExtension()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_unregister_attribute_extension() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-attribute-extension",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_unregister_attribute_extension),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * MaliitServer::handle-set-extended-attribute:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_target: Argument passed by remote caller.
   * @arg_targetItem: Argument passed by remote caller.
   * @arg_attribute: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setExtendedAttribute">setExtendedAttribute()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_set_extended_attribute() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-extended-attribute",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_set_extended_attribute),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * MaliitServer::handle-load-plugin-settings:
   * @object: A #MaliitServer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_descriptionLanguage: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.loadPluginSettings">loadPluginSettings()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call maliit_server_complete_load_plugin_settings() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-load-plugin-settings",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, handle_load_plugin_settings),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * MaliitServer::invoke-action:
   * @object: A #MaliitServer.
   * @arg_action: Argument.
   * @arg_sequence: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-com-meego-inputmethod-uiserver1.invokeAction">"invokeAction"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("invoke-action",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MaliitServerIface, invoke_action),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_STRING);

}

/**
 * maliit_server_emit_invoke_action:
 * @object: A #MaliitServer.
 * @arg_action: Argument to pass with the signal.
 * @arg_sequence: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-com-meego-inputmethod-uiserver1.invokeAction">"invokeAction"</link> D-Bus signal.
 */
void
maliit_server_emit_invoke_action (
    MaliitServer *object,
    const gchar *arg_action,
    const gchar *arg_sequence)
{
  g_signal_emit_by_name (object, "invoke-action", arg_action, arg_sequence);
}

/**
 * maliit_server_call_activate_context:
 * @proxy: A #MaliitServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.activateContext">activateContext()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_activate_context_finish() to get the result of the operation.
 *
 * See maliit_server_call_activate_context_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_activate_context (
    MaliitServer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "activateContext",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_activate_context_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_activate_context().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_activate_context().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_activate_context_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_activate_context_sync:
 * @proxy: A #MaliitServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.activateContext">activateContext()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_activate_context() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_activate_context_sync (
    MaliitServer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "activateContext",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_show_input_method:
 * @proxy: A #MaliitServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.showInputMethod">showInputMethod()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_show_input_method_finish() to get the result of the operation.
 *
 * See maliit_server_call_show_input_method_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_show_input_method (
    MaliitServer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "showInputMethod",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_show_input_method_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_show_input_method().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_show_input_method().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_show_input_method_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_show_input_method_sync:
 * @proxy: A #MaliitServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.showInputMethod">showInputMethod()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_show_input_method() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_show_input_method_sync (
    MaliitServer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "showInputMethod",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_hide_input_method:
 * @proxy: A #MaliitServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.hideInputMethod">hideInputMethod()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_hide_input_method_finish() to get the result of the operation.
 *
 * See maliit_server_call_hide_input_method_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_hide_input_method (
    MaliitServer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "hideInputMethod",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_hide_input_method_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_hide_input_method().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_hide_input_method().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_hide_input_method_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_hide_input_method_sync:
 * @proxy: A #MaliitServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.hideInputMethod">hideInputMethod()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_hide_input_method() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_hide_input_method_sync (
    MaliitServer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "hideInputMethod",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_mouse_clicked_on_preedit:
 * @proxy: A #MaliitServerProxy.
 * @arg_posX: Argument to pass with the method invocation.
 * @arg_posY: Argument to pass with the method invocation.
 * @arg_preeditRectX: Argument to pass with the method invocation.
 * @arg_preeditRectY: Argument to pass with the method invocation.
 * @arg_preeditRectWidth: Argument to pass with the method invocation.
 * @arg_preeditRectHeight: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.mouseClickedOnPreedit">mouseClickedOnPreedit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_mouse_clicked_on_preedit_finish() to get the result of the operation.
 *
 * See maliit_server_call_mouse_clicked_on_preedit_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_mouse_clicked_on_preedit (
    MaliitServer *proxy,
    gint arg_posX,
    gint arg_posY,
    gint arg_preeditRectX,
    gint arg_preeditRectY,
    gint arg_preeditRectWidth,
    gint arg_preeditRectHeight,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "mouseClickedOnPreedit",
    g_variant_new ("(iiiiii)",
                   arg_posX,
                   arg_posY,
                   arg_preeditRectX,
                   arg_preeditRectY,
                   arg_preeditRectWidth,
                   arg_preeditRectHeight),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_mouse_clicked_on_preedit_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_mouse_clicked_on_preedit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_mouse_clicked_on_preedit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_mouse_clicked_on_preedit_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_mouse_clicked_on_preedit_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_posX: Argument to pass with the method invocation.
 * @arg_posY: Argument to pass with the method invocation.
 * @arg_preeditRectX: Argument to pass with the method invocation.
 * @arg_preeditRectY: Argument to pass with the method invocation.
 * @arg_preeditRectWidth: Argument to pass with the method invocation.
 * @arg_preeditRectHeight: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.mouseClickedOnPreedit">mouseClickedOnPreedit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_mouse_clicked_on_preedit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_mouse_clicked_on_preedit_sync (
    MaliitServer *proxy,
    gint arg_posX,
    gint arg_posY,
    gint arg_preeditRectX,
    gint arg_preeditRectY,
    gint arg_preeditRectWidth,
    gint arg_preeditRectHeight,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "mouseClickedOnPreedit",
    g_variant_new ("(iiiiii)",
                   arg_posX,
                   arg_posY,
                   arg_preeditRectX,
                   arg_preeditRectY,
                   arg_preeditRectWidth,
                   arg_preeditRectHeight),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_set_preedit:
 * @proxy: A #MaliitServerProxy.
 * @arg_text: Argument to pass with the method invocation.
 * @arg_cursorPos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setPreedit">setPreedit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_set_preedit_finish() to get the result of the operation.
 *
 * See maliit_server_call_set_preedit_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_set_preedit (
    MaliitServer *proxy,
    const gchar *arg_text,
    gint arg_cursorPos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "setPreedit",
    g_variant_new ("(si)",
                   arg_text,
                   arg_cursorPos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_set_preedit_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_set_preedit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_set_preedit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_set_preedit_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_set_preedit_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_text: Argument to pass with the method invocation.
 * @arg_cursorPos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setPreedit">setPreedit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_set_preedit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_set_preedit_sync (
    MaliitServer *proxy,
    const gchar *arg_text,
    gint arg_cursorPos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "setPreedit",
    g_variant_new ("(si)",
                   arg_text,
                   arg_cursorPos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_update_widget_information:
 * @proxy: A #MaliitServerProxy.
 * @arg_stateInformation: Argument to pass with the method invocation.
 * @arg_focusChanged: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.updateWidgetInformation">updateWidgetInformation()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_update_widget_information_finish() to get the result of the operation.
 *
 * See maliit_server_call_update_widget_information_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_update_widget_information (
    MaliitServer *proxy,
    GVariant *arg_stateInformation,
    gboolean arg_focusChanged,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "updateWidgetInformation",
    g_variant_new ("(@a{sv}b)",
                   arg_stateInformation,
                   arg_focusChanged),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_update_widget_information_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_update_widget_information().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_update_widget_information().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_update_widget_information_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_update_widget_information_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_stateInformation: Argument to pass with the method invocation.
 * @arg_focusChanged: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.updateWidgetInformation">updateWidgetInformation()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_update_widget_information() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_update_widget_information_sync (
    MaliitServer *proxy,
    GVariant *arg_stateInformation,
    gboolean arg_focusChanged,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "updateWidgetInformation",
    g_variant_new ("(@a{sv}b)",
                   arg_stateInformation,
                   arg_focusChanged),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_reset:
 * @proxy: A #MaliitServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.reset">reset()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_reset_finish() to get the result of the operation.
 *
 * See maliit_server_call_reset_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_reset (
    MaliitServer *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "reset",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_reset_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_reset().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_reset().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_reset_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_reset_sync:
 * @proxy: A #MaliitServerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.reset">reset()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_reset() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_reset_sync (
    MaliitServer *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "reset",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_app_orientation_about_to_change:
 * @proxy: A #MaliitServerProxy.
 * @arg_angle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.appOrientationAboutToChange">appOrientationAboutToChange()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_app_orientation_about_to_change_finish() to get the result of the operation.
 *
 * See maliit_server_call_app_orientation_about_to_change_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_app_orientation_about_to_change (
    MaliitServer *proxy,
    gint arg_angle,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "appOrientationAboutToChange",
    g_variant_new ("(i)",
                   arg_angle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_app_orientation_about_to_change_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_app_orientation_about_to_change().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_app_orientation_about_to_change().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_app_orientation_about_to_change_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_app_orientation_about_to_change_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_angle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.appOrientationAboutToChange">appOrientationAboutToChange()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_app_orientation_about_to_change() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_app_orientation_about_to_change_sync (
    MaliitServer *proxy,
    gint arg_angle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "appOrientationAboutToChange",
    g_variant_new ("(i)",
                   arg_angle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_app_orientation_changed:
 * @proxy: A #MaliitServerProxy.
 * @arg_angle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.appOrientationChanged">appOrientationChanged()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_app_orientation_changed_finish() to get the result of the operation.
 *
 * See maliit_server_call_app_orientation_changed_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_app_orientation_changed (
    MaliitServer *proxy,
    gint arg_angle,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "appOrientationChanged",
    g_variant_new ("(i)",
                   arg_angle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_app_orientation_changed_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_app_orientation_changed().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_app_orientation_changed().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_app_orientation_changed_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_app_orientation_changed_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_angle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.appOrientationChanged">appOrientationChanged()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_app_orientation_changed() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_app_orientation_changed_sync (
    MaliitServer *proxy,
    gint arg_angle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "appOrientationChanged",
    g_variant_new ("(i)",
                   arg_angle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_set_copy_paste_state:
 * @proxy: A #MaliitServerProxy.
 * @arg_copyAvailable: Argument to pass with the method invocation.
 * @arg_pasteAvailable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setCopyPasteState">setCopyPasteState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_set_copy_paste_state_finish() to get the result of the operation.
 *
 * See maliit_server_call_set_copy_paste_state_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_set_copy_paste_state (
    MaliitServer *proxy,
    gboolean arg_copyAvailable,
    gboolean arg_pasteAvailable,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "setCopyPasteState",
    g_variant_new ("(bb)",
                   arg_copyAvailable,
                   arg_pasteAvailable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_set_copy_paste_state_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_set_copy_paste_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_set_copy_paste_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_set_copy_paste_state_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_set_copy_paste_state_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_copyAvailable: Argument to pass with the method invocation.
 * @arg_pasteAvailable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setCopyPasteState">setCopyPasteState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_set_copy_paste_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_set_copy_paste_state_sync (
    MaliitServer *proxy,
    gboolean arg_copyAvailable,
    gboolean arg_pasteAvailable,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "setCopyPasteState",
    g_variant_new ("(bb)",
                   arg_copyAvailable,
                   arg_pasteAvailable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_process_key_event:
 * @proxy: A #MaliitServerProxy.
 * @arg_keyType: Argument to pass with the method invocation.
 * @arg_keyCode: Argument to pass with the method invocation.
 * @arg_modifiers: Argument to pass with the method invocation.
 * @arg_text: Argument to pass with the method invocation.
 * @arg_autoRepeat: Argument to pass with the method invocation.
 * @arg_count: Argument to pass with the method invocation.
 * @arg_nativeScanCode: Argument to pass with the method invocation.
 * @arg_nativeModifiers: Argument to pass with the method invocation.
 * @arg_time: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.processKeyEvent">processKeyEvent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_process_key_event_finish() to get the result of the operation.
 *
 * See maliit_server_call_process_key_event_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_process_key_event (
    MaliitServer *proxy,
    gint arg_keyType,
    gint arg_keyCode,
    gint arg_modifiers,
    const gchar *arg_text,
    gboolean arg_autoRepeat,
    gint arg_count,
    guint arg_nativeScanCode,
    guint arg_nativeModifiers,
    guint arg_time,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "processKeyEvent",
    g_variant_new ("(iiisbiuuu)",
                   arg_keyType,
                   arg_keyCode,
                   arg_modifiers,
                   arg_text,
                   arg_autoRepeat,
                   arg_count,
                   arg_nativeScanCode,
                   arg_nativeModifiers,
                   arg_time),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_process_key_event_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_process_key_event().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_process_key_event().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_process_key_event_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_process_key_event_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_keyType: Argument to pass with the method invocation.
 * @arg_keyCode: Argument to pass with the method invocation.
 * @arg_modifiers: Argument to pass with the method invocation.
 * @arg_text: Argument to pass with the method invocation.
 * @arg_autoRepeat: Argument to pass with the method invocation.
 * @arg_count: Argument to pass with the method invocation.
 * @arg_nativeScanCode: Argument to pass with the method invocation.
 * @arg_nativeModifiers: Argument to pass with the method invocation.
 * @arg_time: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.processKeyEvent">processKeyEvent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_process_key_event() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_process_key_event_sync (
    MaliitServer *proxy,
    gint arg_keyType,
    gint arg_keyCode,
    gint arg_modifiers,
    const gchar *arg_text,
    gboolean arg_autoRepeat,
    gint arg_count,
    guint arg_nativeScanCode,
    guint arg_nativeModifiers,
    guint arg_time,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "processKeyEvent",
    g_variant_new ("(iiisbiuuu)",
                   arg_keyType,
                   arg_keyCode,
                   arg_modifiers,
                   arg_text,
                   arg_autoRepeat,
                   arg_count,
                   arg_nativeScanCode,
                   arg_nativeModifiers,
                   arg_time),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_register_attribute_extension:
 * @proxy: A #MaliitServerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_fileName: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.registerAttributeExtension">registerAttributeExtension()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_register_attribute_extension_finish() to get the result of the operation.
 *
 * See maliit_server_call_register_attribute_extension_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_register_attribute_extension (
    MaliitServer *proxy,
    gint arg_id,
    const gchar *arg_fileName,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "registerAttributeExtension",
    g_variant_new ("(is)",
                   arg_id,
                   arg_fileName),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_register_attribute_extension_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_register_attribute_extension().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_register_attribute_extension().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_register_attribute_extension_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_register_attribute_extension_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_fileName: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.registerAttributeExtension">registerAttributeExtension()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_register_attribute_extension() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_register_attribute_extension_sync (
    MaliitServer *proxy,
    gint arg_id,
    const gchar *arg_fileName,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "registerAttributeExtension",
    g_variant_new ("(is)",
                   arg_id,
                   arg_fileName),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_unregister_attribute_extension:
 * @proxy: A #MaliitServerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.unregisterAttributeExtension">unregisterAttributeExtension()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_unregister_attribute_extension_finish() to get the result of the operation.
 *
 * See maliit_server_call_unregister_attribute_extension_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_unregister_attribute_extension (
    MaliitServer *proxy,
    gint arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "unregisterAttributeExtension",
    g_variant_new ("(i)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_unregister_attribute_extension_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_unregister_attribute_extension().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_unregister_attribute_extension().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_unregister_attribute_extension_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_unregister_attribute_extension_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.unregisterAttributeExtension">unregisterAttributeExtension()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_unregister_attribute_extension() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_unregister_attribute_extension_sync (
    MaliitServer *proxy,
    gint arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "unregisterAttributeExtension",
    g_variant_new ("(i)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_set_extended_attribute:
 * @proxy: A #MaliitServerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_targetItem: Argument to pass with the method invocation.
 * @arg_attribute: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setExtendedAttribute">setExtendedAttribute()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_set_extended_attribute_finish() to get the result of the operation.
 *
 * See maliit_server_call_set_extended_attribute_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_set_extended_attribute (
    MaliitServer *proxy,
    gint arg_id,
    const gchar *arg_target,
    const gchar *arg_targetItem,
    const gchar *arg_attribute,
    GVariant *arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "setExtendedAttribute",
    g_variant_new ("(isss@v)",
                   arg_id,
                   arg_target,
                   arg_targetItem,
                   arg_attribute,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_set_extended_attribute_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_set_extended_attribute().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_set_extended_attribute().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_set_extended_attribute_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_set_extended_attribute_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_targetItem: Argument to pass with the method invocation.
 * @arg_attribute: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setExtendedAttribute">setExtendedAttribute()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_set_extended_attribute() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_set_extended_attribute_sync (
    MaliitServer *proxy,
    gint arg_id,
    const gchar *arg_target,
    const gchar *arg_targetItem,
    const gchar *arg_attribute,
    GVariant *arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "setExtendedAttribute",
    g_variant_new ("(isss@v)",
                   arg_id,
                   arg_target,
                   arg_targetItem,
                   arg_attribute,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_load_plugin_settings:
 * @proxy: A #MaliitServerProxy.
 * @arg_descriptionLanguage: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.loadPluginSettings">loadPluginSettings()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_call_load_plugin_settings_finish() to get the result of the operation.
 *
 * See maliit_server_call_load_plugin_settings_sync() for the synchronous, blocking version of this method.
 */
void
maliit_server_call_load_plugin_settings (
    MaliitServer *proxy,
    const gchar *arg_descriptionLanguage,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "loadPluginSettings",
    g_variant_new ("(s)",
                   arg_descriptionLanguage),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * maliit_server_call_load_plugin_settings_finish:
 * @proxy: A #MaliitServerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_call_load_plugin_settings().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with maliit_server_call_load_plugin_settings().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_load_plugin_settings_finish (
    MaliitServer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_call_load_plugin_settings_sync:
 * @proxy: A #MaliitServerProxy.
 * @arg_descriptionLanguage: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.loadPluginSettings">loadPluginSettings()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See maliit_server_call_load_plugin_settings() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
maliit_server_call_load_plugin_settings_sync (
    MaliitServer *proxy,
    const gchar *arg_descriptionLanguage,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "loadPluginSettings",
    g_variant_new ("(s)",
                   arg_descriptionLanguage),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * maliit_server_complete_activate_context:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.activateContext">activateContext()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_activate_context (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_show_input_method:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.showInputMethod">showInputMethod()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_show_input_method (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_hide_input_method:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.hideInputMethod">hideInputMethod()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_hide_input_method (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_mouse_clicked_on_preedit:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.mouseClickedOnPreedit">mouseClickedOnPreedit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_mouse_clicked_on_preedit (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_set_preedit:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setPreedit">setPreedit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_set_preedit (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_update_widget_information:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.updateWidgetInformation">updateWidgetInformation()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_update_widget_information (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_reset:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.reset">reset()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_reset (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_app_orientation_about_to_change:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.appOrientationAboutToChange">appOrientationAboutToChange()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_app_orientation_about_to_change (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_app_orientation_changed:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.appOrientationChanged">appOrientationChanged()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_app_orientation_changed (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_set_copy_paste_state:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setCopyPasteState">setCopyPasteState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_set_copy_paste_state (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_process_key_event:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.processKeyEvent">processKeyEvent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_process_key_event (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_register_attribute_extension:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.registerAttributeExtension">registerAttributeExtension()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_register_attribute_extension (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_unregister_attribute_extension:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.unregisterAttributeExtension">unregisterAttributeExtension()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_unregister_attribute_extension (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_set_extended_attribute:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.setExtendedAttribute">setExtendedAttribute()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_set_extended_attribute (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * maliit_server_complete_load_plugin_settings:
 * @object: A #MaliitServer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-meego-inputmethod-uiserver1.loadPluginSettings">loadPluginSettings()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
maliit_server_complete_load_plugin_settings (
    MaliitServer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MaliitServerProxy:
 *
 * The #MaliitServerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MaliitServerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MaliitServerProxy.
 */

struct _MaliitServerProxyPrivate
{
  GData *qdata;
};

static void maliit_server_proxy_iface_init (MaliitServerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MaliitServerProxy, maliit_server_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MaliitServerProxy)
                         G_IMPLEMENT_INTERFACE (MALIIT_TYPE_SERVER, maliit_server_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MaliitServerProxy, maliit_server_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MALIIT_TYPE_SERVER, maliit_server_proxy_iface_init))

#endif
static void
maliit_server_proxy_finalize (GObject *object)
{
  MaliitServerProxy *proxy = MALIIT_SERVER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (maliit_server_proxy_parent_class)->finalize (object);
}

static void
maliit_server_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
maliit_server_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
maliit_server_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_maliit_server_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MALIIT_TYPE_SERVER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MALIIT_TYPE_SERVER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
maliit_server_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MaliitServerProxy *proxy = MALIIT_SERVER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_maliit_server_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_maliit_server_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
maliit_server_proxy_init (MaliitServerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = maliit_server_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MALIIT_TYPE_SERVER_PROXY, MaliitServerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), maliit_server_interface_info ());
}

static void
maliit_server_proxy_class_init (MaliitServerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = maliit_server_proxy_finalize;
  gobject_class->get_property = maliit_server_proxy_get_property;
  gobject_class->set_property = maliit_server_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = maliit_server_proxy_g_signal;
  proxy_class->g_properties_changed = maliit_server_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MaliitServerProxyPrivate));
#endif
}

static void
maliit_server_proxy_iface_init (MaliitServerIface *iface G_GNUC_UNUSED)
{
}

/**
 * maliit_server_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-meego-inputmethod-uiserver1.top_of_page">com.meego.inputmethod.uiserver1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_proxy_new_finish() to get the result of the operation.
 *
 * See maliit_server_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
maliit_server_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MALIIT_TYPE_SERVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.meego.inputmethod.uiserver1", NULL);
}

/**
 * maliit_server_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with maliit_server_proxy_new().
 *
 * Returns: (transfer full) (type MaliitServerProxy): The constructed proxy object or %NULL if @error is set.
 */
MaliitServer *
maliit_server_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MALIIT_SERVER (ret);
  else
    return NULL;
}

/**
 * maliit_server_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-meego-inputmethod-uiserver1.top_of_page">com.meego.inputmethod.uiserver1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See maliit_server_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MaliitServerProxy): The constructed proxy object or %NULL if @error is set.
 */
MaliitServer *
maliit_server_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MALIIT_TYPE_SERVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.meego.inputmethod.uiserver1", NULL);
  if (ret != NULL)
    return MALIIT_SERVER (ret);
  else
    return NULL;
}


/**
 * maliit_server_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like maliit_server_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call maliit_server_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See maliit_server_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
maliit_server_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MALIIT_TYPE_SERVER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.meego.inputmethod.uiserver1", NULL);
}

/**
 * maliit_server_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to maliit_server_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with maliit_server_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MaliitServerProxy): The constructed proxy object or %NULL if @error is set.
 */
MaliitServer *
maliit_server_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MALIIT_SERVER (ret);
  else
    return NULL;
}

/**
 * maliit_server_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like maliit_server_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See maliit_server_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MaliitServerProxy): The constructed proxy object or %NULL if @error is set.
 */
MaliitServer *
maliit_server_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MALIIT_TYPE_SERVER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.meego.inputmethod.uiserver1", NULL);
  if (ret != NULL)
    return MALIIT_SERVER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MaliitServerSkeleton:
 *
 * The #MaliitServerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MaliitServerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MaliitServerSkeleton.
 */

struct _MaliitServerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_maliit_server_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MaliitServerSkeleton *skeleton = MALIIT_SERVER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MALIIT_TYPE_SERVER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MALIIT_TYPE_SERVER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_maliit_server_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MaliitServerSkeleton *skeleton = MALIIT_SERVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_maliit_server_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_maliit_server_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MaliitServerSkeleton *skeleton = MALIIT_SERVER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_maliit_server_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _maliit_server_skeleton_vtable =
{
  _maliit_server_skeleton_handle_method_call,
  _maliit_server_skeleton_handle_get_property,
  _maliit_server_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
maliit_server_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return maliit_server_interface_info ();
}

static GDBusInterfaceVTable *
maliit_server_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_maliit_server_skeleton_vtable;
}

static GVariant *
maliit_server_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MaliitServerSkeleton *skeleton = MALIIT_SERVER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_maliit_server_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _maliit_server_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _maliit_server_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _maliit_server_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.meego.inputmethod.uiserver1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
maliit_server_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_maliit_server_on_signal_invoke_action (
    MaliitServer *object,
    const gchar *arg_action,
    const gchar *arg_sequence)
{
  MaliitServerSkeleton *skeleton = MALIIT_SERVER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_action,
                   arg_sequence));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.meego.inputmethod.uiserver1", "invokeAction",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void maliit_server_skeleton_iface_init (MaliitServerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MaliitServerSkeleton, maliit_server_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MaliitServerSkeleton)
                         G_IMPLEMENT_INTERFACE (MALIIT_TYPE_SERVER, maliit_server_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MaliitServerSkeleton, maliit_server_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MALIIT_TYPE_SERVER, maliit_server_skeleton_iface_init))

#endif
static void
maliit_server_skeleton_finalize (GObject *object)
{
  MaliitServerSkeleton *skeleton = MALIIT_SERVER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (maliit_server_skeleton_parent_class)->finalize (object);
}

static void
maliit_server_skeleton_init (MaliitServerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = maliit_server_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MALIIT_TYPE_SERVER_SKELETON, MaliitServerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
maliit_server_skeleton_class_init (MaliitServerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = maliit_server_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = maliit_server_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = maliit_server_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = maliit_server_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = maliit_server_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MaliitServerSkeletonPrivate));
#endif
}

static void
maliit_server_skeleton_iface_init (MaliitServerIface *iface)
{
  iface->invoke_action = _maliit_server_on_signal_invoke_action;
}

/**
 * maliit_server_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-com-meego-inputmethod-uiserver1.top_of_page">com.meego.inputmethod.uiserver1</link>.
 *
 * Returns: (transfer full) (type MaliitServerSkeleton): The skeleton object.
 */
MaliitServer *
maliit_server_skeleton_new (void)
{
  return MALIIT_SERVER (g_object_new (MALIIT_TYPE_SERVER_SKELETON, NULL));
}

