<?php
// These modules are only registered when $wgEnableJavaScriptTest is true
use MediaWiki\ResourceLoader\FilePath;

return [

	'sinonjs' => [
		'scripts' => [
			'tests/qunit/data/sinonjs-local.js',
			'resources/lib/sinonjs/sinon.js',
		],
		'targets' => [ 'desktop', 'mobile' ],
	],

	'mediawiki.qunit-testrunner' => [
		'scripts' => [
			'tests/qunit/data/testrunner.js',
		],
		'dependencies' => [
			'mediawiki.page.ready',
			'sinonjs',
		],
		'targets' => [ 'desktop', 'mobile' ],
	],

	'mediawiki.language.testdata' => [
		'localBasePath' => "{$GLOBALS['IP']}/resources/src/mediawiki.language/languages",
		'remoteBasePath' => "{$GLOBALS['wgResourceBasePath']}/resources/src/mediawiki.language/languages",
		'packageFiles' => [
			new FilePath( 'mediawiki.jqueryMsg.testdata.js', __DIR__ . '/data' ),
			new FilePath( 'mediawiki.jqueryMsg.data.json', __DIR__ . '/data' ),
			'bs.js',
			'dsb.js',
			'fi.js',
			'ga.js',
			'hsb.js',
			'hu.js',
			'hy.js',
			'la.js',
			'os.js',
			'sl.js',
		]
	],

	'test.MediaWiki' => [
		'scripts' => [
			'tests/qunit/resources/startup/startup.test.js',
			'tests/qunit/resources/startup/mediawiki.test.js',
			'tests/qunit/resources/startup/mw.Map.test.js',
			'tests/qunit/resources/startup/mw.loader.test.js',
			'tests/qunit/resources/startup/mw.requestIdleCallback.test.js',
			'tests/qunit/resources/startup/jscompat.test.js',
			'tests/qunit/resources/jquery.color.test.js',
			'tests/qunit/resources/jquery.colorUtil.test.js',
			'tests/qunit/resources/jquery.highlightText.test.js',
			'tests/qunit/resources/jquery.lengthLimit.test.js',
			'tests/qunit/resources/jquery.makeCollapsible.test.js',
			'tests/qunit/resources/jquery.tablesorter.test.js',
			'tests/qunit/resources/jquery.textSelection.test.js',
			'tests/qunit/resources/mediawiki.base/errorLogger.test.js',
			'tests/qunit/resources/mediawiki.base/mediawiki.base.test.js',
			'tests/qunit/resources/mediawiki.base/html.test.js',
			'tests/qunit/resources/mediawiki.base/track.test.js',
			'tests/qunit/resources/mediawiki.jqueryMsg.test.js',
			'tests/qunit/resources/mediawiki.messagePoster/factory.test.js',
			'tests/qunit/resources/mediawiki.String/byteLength.test.js',
			'tests/qunit/resources/mediawiki.String/charAt.test.js',
			'tests/qunit/resources/mediawiki.String/lcFirst.test.js',
			'tests/qunit/resources/mediawiki.String/ucFirst.test.js',
			'tests/qunit/resources/mediawiki.String/trimByteLength.test.js',
			'tests/qunit/resources/mediawiki.storage.test.js',
			'tests/qunit/resources/mediawiki.template.test.js',
			'tests/qunit/resources/mediawiki.template.mustache.test.js',
			'tests/qunit/resources/mediawiki.inspect.test.js',
			'tests/qunit/resources/mediawiki.router.test.js',
			'tests/qunit/resources/mediawiki.Title.test.js',
			'tests/qunit/resources/mediawiki.toc.test.js',
			'tests/qunit/resources/mediawiki.Uri.test.js',
			'tests/qunit/resources/mediawiki.user.test.js',
			'tests/qunit/resources/mediawiki.util/util.test.js',
			'tests/qunit/resources/mediawiki.util/accessKeyLabel.test.js',
			'tests/qunit/resources/mediawiki.api/mediawiki.api.test.js',
			'tests/qunit/resources/mediawiki.api/mediawiki.api.category.test.js',
			'tests/qunit/resources/mediawiki.api/mediawiki.api.edit.test.js',
			'tests/qunit/resources/mediawiki.api/mediawiki.api.messages.test.js',
			'tests/qunit/resources/mediawiki.api/mediawiki.api.options.test.js',
			'tests/qunit/resources/mediawiki.api/mediawiki.api.parse.test.js',
			'tests/qunit/resources/mediawiki.api/mediawiki.api.upload.test.js',
			'tests/qunit/resources/mediawiki.api/mediawiki.api.watch.test.js',
			'tests/qunit/resources/mediawiki.api/mediawiki.rest.test.js',
			'tests/qunit/resources/mediawiki.ForeignApi/mediawiki.ForeignApi.test.js',
			'tests/qunit/resources/mediawiki.ForeignApi/mediawiki.ForeignRest.test.js',
			'tests/qunit/resources/mediawiki.rcfilters/dm.FiltersViewModel.test.js',
			'tests/qunit/resources/mediawiki.rcfilters/dm.FilterItem.test.js',
			'tests/qunit/resources/mediawiki.rcfilters/dm.SavedQueryItemModel.test.js',
			'tests/qunit/resources/mediawiki.rcfilters/dm.SavedQueriesModel.test.js',
			'tests/qunit/resources/mediawiki.rcfilters/UriProcessor.test.js',
			'tests/qunit/resources/mediawiki.widgets/MediaSearch/mediawiki.widgets.APIResultsQueue.test.js',
			'tests/qunit/resources/mediawiki.widgets/Table/mediawiki.widgets.TableWidget.test.js',
			'tests/qunit/resources/mediawiki.language.test.js',
			'tests/qunit/resources/mediawiki.cldr.test.js',
			'tests/qunit/resources/mediawiki.cookie.test.js',
			'tests/qunit/resources/mediawiki.deflate.test.js',
			'tests/qunit/resources/mediawiki.experiments.test.js',
			'tests/qunit/resources/mediawiki.visibleTimeout.test.js',
		],
		'dependencies' => [
			'jquery.color',
			'jquery.highlightText',
			'jquery.lengthLimit',
			'jquery.makeCollapsible',
			'jquery.tablesorter',
			'jquery.textSelection',
			'mediawiki.api',
			'mediawiki.ForeignApi.core',
			'mediawiki.jqueryMsg',
			'mediawiki.messagePoster',
			'mediawiki.String',
			'mediawiki.storage',
			'mediawiki.Title',
			'mediawiki.toc',
			'mediawiki.Uri',
			'mediawiki.user',
			'mediawiki.template.mustache',
			'mediawiki.template',
			'mediawiki.util',
			'mediawiki.rcfilters.filters.ui',
			'mediawiki.language',
			'mediawiki.language.testdata',
			'mediawiki.cldr',
			'mediawiki.cookie',
			'mediawiki.deflate',
			'mediawiki.experiments',
			'mediawiki.inspect',
			'mediawiki.router',
			'mediawiki.visibleTimeout',
			'mediawiki.widgets.MediaSearch',
			'mediawiki.widgets.Table',
			'mediawiki.qunit-testrunner',
		],
	]
];
