/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableLengthValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableLengthListValue
extends AnimatableValue {
    protected short[] lengthTypes;
    protected float[] lengthValues;
    protected short percentageInterpretation;

    protected AnimatableLengthListValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableLengthListValue(AnimationTarget animationTarget, short[] sArray, float[] fArray, short s) {
        super(animationTarget);
        this.lengthTypes = sArray;
        this.lengthValues = fArray;
        this.percentageInterpretation = s;
    }

    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f, AnimatableValue animatableValue3, int n) {
        AnimatableLengthListValue animatableLengthListValue;
        float[] fArray;
        short[] sArray;
        boolean bl;
        AnimatableLengthListValue animatableLengthListValue2 = (AnimatableLengthListValue)animatableValue2;
        AnimatableLengthListValue animatableLengthListValue3 = (AnimatableLengthListValue)animatableValue3;
        boolean bl2 = animatableValue2 != null;
        boolean bl3 = animatableValue3 != null;
        boolean bl4 = bl = !(bl2 && animatableLengthListValue2.lengthTypes.length != this.lengthTypes.length || bl3 && animatableLengthListValue3.lengthTypes.length != this.lengthTypes.length);
        if (!bl && bl2 && (double)f >= 0.5) {
            sArray = animatableLengthListValue2.lengthTypes;
            fArray = animatableLengthListValue2.lengthValues;
        } else {
            sArray = this.lengthTypes;
            fArray = this.lengthValues;
        }
        int n2 = sArray.length;
        if (animatableValue == null) {
            animatableLengthListValue = new AnimatableLengthListValue(this.target);
            animatableLengthListValue.lengthTypes = new short[n2];
            animatableLengthListValue.lengthValues = new float[n2];
        } else {
            animatableLengthListValue = (AnimatableLengthListValue)animatableValue;
            if (animatableLengthListValue.lengthTypes == null || animatableLengthListValue.lengthTypes.length != n2) {
                animatableLengthListValue.lengthTypes = new short[n2];
                animatableLengthListValue.lengthValues = new float[n2];
            }
        }
        animatableLengthListValue.hasChanged = this.percentageInterpretation != animatableLengthListValue.percentageInterpretation;
        animatableLengthListValue.percentageInterpretation = this.percentageInterpretation;
        for (int i = 0; i < n2; ++i) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            short s = sArray[i];
            float f4 = fArray[i];
            if (bl) {
                if (bl2 && !AnimatableLengthValue.compatibleTypes(s, this.percentageInterpretation, animatableLengthListValue2.lengthTypes[i], animatableLengthListValue2.percentageInterpretation) || bl3 && !AnimatableLengthValue.compatibleTypes(s, this.percentageInterpretation, animatableLengthListValue3.lengthTypes[i], animatableLengthListValue3.percentageInterpretation)) {
                    f4 = this.target.svgToUserSpace(f4, s, this.percentageInterpretation);
                    s = 1;
                    if (bl2) {
                        f2 = animatableValue2.target.svgToUserSpace(animatableLengthListValue2.lengthValues[i], animatableLengthListValue2.lengthTypes[i], animatableLengthListValue2.percentageInterpretation);
                    }
                    if (bl3) {
                        f3 = animatableValue3.target.svgToUserSpace(animatableLengthListValue3.lengthValues[i], animatableLengthListValue3.lengthTypes[i], animatableLengthListValue3.percentageInterpretation);
                    }
                } else {
                    if (bl2) {
                        f2 = animatableLengthListValue2.lengthValues[i];
                    }
                    if (bl3) {
                        f3 = animatableLengthListValue3.lengthValues[i];
                    }
                }
                f4 += f * (f2 - f4) + (float)n * f3;
            }
            if (!animatableLengthListValue.hasChanged) {
                animatableLengthListValue.hasChanged = s != animatableLengthListValue.lengthTypes[i] || f4 != animatableLengthListValue.lengthValues[i];
            }
            animatableLengthListValue.lengthTypes[i] = s;
            animatableLengthListValue.lengthValues[i] = f4;
        }
        return animatableLengthListValue;
    }

    public short[] getLengthTypes() {
        return this.lengthTypes;
    }

    public float[] getLengthValues() {
        return this.lengthValues;
    }

    public boolean canPace() {
        return false;
    }

    public float distanceTo(AnimatableValue animatableValue) {
        return 0.0f;
    }

    public AnimatableValue getZeroValue() {
        float[] fArray = new float[this.lengthValues.length];
        return new AnimatableLengthListValue(this.target, this.lengthTypes, fArray, this.percentageInterpretation);
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lengthValues.length > 0) {
            stringBuffer.append(AnimatableLengthListValue.formatNumber(this.lengthValues[0]));
            stringBuffer.append(AnimatableLengthValue.UNITS[this.lengthTypes[0] - 1]);
        }
        for (int i = 1; i < this.lengthValues.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(AnimatableLengthListValue.formatNumber(this.lengthValues[i]));
            stringBuffer.append(AnimatableLengthValue.UNITS[this.lengthTypes[i] - 1]);
        }
        return stringBuffer.toString();
    }
}

