# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
math module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_math.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _math
else:
    import _math

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _math.delete_SwigPyIterator

    def value(self):
        return _math.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _math.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _math.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _math.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _math.SwigPyIterator_equal(self, x)

    def copy(self):
        return _math.SwigPyIterator_copy(self)

    def next(self):
        return _math.SwigPyIterator_next(self)

    def __next__(self):
        return _math.SwigPyIterator___next__(self)

    def previous(self):
        return _math.SwigPyIterator_previous(self)

    def advance(self, n):
        return _math.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _math.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _math.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _math.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _math.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _math.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _math.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _math:
_math.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _math.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.gp

from enum import IntEnum
from OCC.Core.Exception import *

math_OK = _math.math_OK
math_TooManyIterations = _math.math_TooManyIterations
math_FunctionError = _math.math_FunctionError
math_DirectionSearchError = _math.math_DirectionSearchError
math_NotBracketed = _math.math_NotBracketed


class math_Status(IntEnum):
	math_OK = 0
	math_TooManyIterations = 1
	math_FunctionError = 2
	math_DirectionSearchError = 3
	math_NotBracketed = 4
math_OK = math_Status.math_OK
math_TooManyIterations = math_Status.math_TooManyIterations
math_FunctionError = math_Status.math_FunctionError
math_DirectionSearchError = math_Status.math_DirectionSearchError
math_NotBracketed = math_Status.math_NotBracketed

class math_Array1OfValueAndWeight(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _math.math_Array1OfValueAndWeight_begin(self)

    def end(self):
        return _math.math_Array1OfValueAndWeight_end(self)

    def cbegin(self):
        return _math.math_Array1OfValueAndWeight_cbegin(self)

    def cend(self):
        return _math.math_Array1OfValueAndWeight_cend(self)

    def __init__(self, *args):
        _math.math_Array1OfValueAndWeight_swiginit(self, _math.new_math_Array1OfValueAndWeight(*args))

    def Init(self, theValue):
        return _math.math_Array1OfValueAndWeight_Init(self, theValue)

    def Size(self):
        return _math.math_Array1OfValueAndWeight_Size(self)

    def Length(self):
        return _math.math_Array1OfValueAndWeight_Length(self)

    def IsEmpty(self):
        return _math.math_Array1OfValueAndWeight_IsEmpty(self)

    def Lower(self):
        return _math.math_Array1OfValueAndWeight_Lower(self)

    def Upper(self):
        return _math.math_Array1OfValueAndWeight_Upper(self)

    def IsDeletable(self):
        return _math.math_Array1OfValueAndWeight_IsDeletable(self)

    def IsAllocated(self):
        return _math.math_Array1OfValueAndWeight_IsAllocated(self)

    def Assign(self, theOther):
        return _math.math_Array1OfValueAndWeight_Assign(self, theOther)

    def Move(self, theOther):
        return _math.math_Array1OfValueAndWeight_Move(self, theOther)

    def Set(self, *args):
        return _math.math_Array1OfValueAndWeight_Set(self, *args)

    def First(self):
        return _math.math_Array1OfValueAndWeight_First(self)

    def ChangeFirst(self):
        return _math.math_Array1OfValueAndWeight_ChangeFirst(self)

    def Last(self):
        return _math.math_Array1OfValueAndWeight_Last(self)

    def ChangeLast(self):
        return _math.math_Array1OfValueAndWeight_ChangeLast(self)

    def Value(self, theIndex):
        return _math.math_Array1OfValueAndWeight_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _math.math_Array1OfValueAndWeight_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _math.math_Array1OfValueAndWeight___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _math.math_Array1OfValueAndWeight_SetValue(self, theIndex, theItem)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _math.math_Array1OfValueAndWeight_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _math.delete_math_Array1OfValueAndWeight

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register math_Array1OfValueAndWeight in _math:
_math.math_Array1OfValueAndWeight_swigregister(math_Array1OfValueAndWeight)
class math(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def GaussPoints(*args):
        r"""
        No available documentation.

        Parameters
        ----------
        Index: int
        Points: math_Vector

        Returns
        -------
        None

        """
        return _math.math_GaussPoints(*args)

    @staticmethod
    def GaussPointsMax(*args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _math.math_GaussPointsMax(*args)

    @staticmethod
    def GaussWeights(*args):
        r"""
        No available documentation.

        Parameters
        ----------
        Index: int
        Weights: math_Vector

        Returns
        -------
        None

        """
        return _math.math_GaussWeights(*args)

    @staticmethod
    def KronrodPointsAndWeights(*args):
        r"""
        Returns a vector of kronrod points and a vector of their weights for gauss-kronrod computation method. index should be odd and greater then or equal to 3, as the number of kronrod points is equal to 2*n + 1, where n is a number of gauss points. points and weights should have the size equal to index. each even element of points represents a gauss point value of n-th gauss quadrature. the values from index equal to 3 to 123 are stored in a table (see the file math_kronrod.cxx). if index is greater, then points and weights will be computed. returns standard_true if index is odd, it is equal to the size of points and weights and the computation of points and weights is performed successfully. otherwise this method returns standard_false.

        Parameters
        ----------
        Index: int
        Points: math_Vector
        Weights: math_Vector

        Returns
        -------
        bool

        """
        return _math.math_KronrodPointsAndWeights(*args)

    @staticmethod
    def KronrodPointsMax(*args):
        r"""
        Returns the maximal number of points for that the values are stored in the table. if the number is greater then kronrodpointsmax, the points will be computed.

        Returns
        -------
        int

        """
        return _math.math_KronrodPointsMax(*args)

    @staticmethod
    def OrderedGaussPointsAndWeights(*args):
        r"""
        Returns a vector of gauss points and a vector of their weights. the difference with the method gausspoints is the following: - the points are returned in increasing order. - if index is greater then gausspointsmax, the points are computed. returns standard_true if index is positive, points' and weights' length is equal to index, points and weights are successfully computed.

        Parameters
        ----------
        Index: int
        Points: math_Vector
        Weights: math_Vector

        Returns
        -------
        bool

        """
        return _math.math_OrderedGaussPointsAndWeights(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _math.math_swiginit(self, _math.new_math())
    __swig_destroy__ = _math.delete_math

# Register math in _math:
_math.math_swigregister(math)
class math_BFGS(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initializes the computation of the minimum of a function with nbvariables. tolerance, zeps and nbiterations are described in the method perform. warning: a call to the perform method must be made after this initialization to effectively compute the minimum of the function f.

        Parameters
        ----------
        NbVariables: int
        Tolerance: float,optional
        	default value is 1.0e-8
        NbIterations: int,optional
        	default value is 200
        ZEPS: float,optional
        	default value is 1.0e-12

        Returns
        -------
        None

        """
        _math.math_BFGS_swiginit(self, _math.new_math_BFGS(*args))

    def DumpToString(self):
        r"""DumpToString(math_BFGS self) -> std::string"""
        return _math.math_BFGS_DumpToString(self)

    def Gradient(self, *args):
        r"""
        Returns the gradient vector at the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        math_Vector
        Returns the value of the gradient vector at the minimum in grad. exception notdone is raised if the minimum was not found. exception dimensionerror is raised if the range of grad is not equal to the range of the startingpoint.

        Parameters
        ----------
        Grad: math_Vector

        Returns
        -------
        None

        """
        return _math.math_BFGS_Gradient(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_BFGS_IsDone(self, *args)

    def IsSolutionReached(self, *args):
        r"""
        This method is called at the end of each iteration to check if the solution is found. it can be redefined in a sub-class to implement a specific test to stop the iterations.

        Parameters
        ----------
        F: math_MultipleVarFunctionWithGradient

        Returns
        -------
        bool

        """
        return _math.math_BFGS_IsSolutionReached(self, *args)

    def Location(self, *args):
        r"""
        Returns the location vector of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        math_Vector
        Outputs the location vector of the minimum in loc. exception notdone is raised if the minimum was not found. exception dimensionerror is raised if the range of loc is not equal to the range of the startingpoint.

        Parameters
        ----------
        Loc: math_Vector

        Returns
        -------
        None

        """
        return _math.math_BFGS_Location(self, *args)

    def Minimum(self, *args):
        r"""
        Returns the value of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_BFGS_Minimum(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done in the calculation of the minimum. the exception notdone is raised if the minimum was not found.

        Returns
        -------
        int

        """
        return _math.math_BFGS_NbIterations(self, *args)

    def Perform(self, *args):
        r"""
        Given the starting point startingpoint, minimization is done on the function f. the solution f = fi is found when : 2.0 * abs(fi - fi-1) <= tolerance * (abs(fi) + abs(fi-1) + zeps). tolerance, zeps and maximum number of iterations are given in the constructor.

        Parameters
        ----------
        F: math_MultipleVarFunctionWithGradient
        StartingPoint: math_Vector

        Returns
        -------
        None

        """
        return _math.math_BFGS_Perform(self, *args)

    def SetBoundary(self, *args):
        r"""
        Set boundaries for conditional optimization. the expected indices range of vectors is [1, nbvariables].

        Parameters
        ----------
        theLeftBorder: math_Vector
        theRightBorder: math_Vector

        Returns
        -------
        None

        """
        return _math.math_BFGS_SetBoundary(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_BFGS

# Register math_BFGS in _math:
_math.math_BFGS_swigregister(math_BFGS)
class math_BissecNewton(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor. @param thextolerance - algorithm tolerance.

        Parameters
        ----------
        theXTolerance: float

        Returns
        -------
        None

        """
        _math.math_BissecNewton_swiginit(self, _math.new_math_BissecNewton(*args))

    def Derivative(self, *args):
        r"""
        Returns the value of the derivative at the root. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_BissecNewton_Derivative(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_BissecNewton self) -> std::string"""
        return _math.math_BissecNewton_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Tests is the root has been successfully found.

        Returns
        -------
        bool

        """
        return _math.math_BissecNewton_IsDone(self, *args)

    def IsSolutionReached(self, *args):
        r"""
        This method is called at the end of each iteration to check if the solution has been found. it can be redefined in a sub-class to implement a specific test to stop the iterations.

        Parameters
        ----------
        theFunction: math_FunctionWithDerivative

        Returns
        -------
        bool

        """
        return _math.math_BissecNewton_IsSolutionReached(self, *args)

    def Perform(self, *args):
        r"""
        A combination of newton-raphson and bissection methods is done to find the root of the function f between the bounds bound1 and bound2 on the function f. the tolerance required on the root is given by tolx. the solution is found when: abs(xi - xi-1) <= tolx and f(xi) * f(xi-1) <= 0 the maximum number of iterations allowed is given by nbiterations.

        Parameters
        ----------
        F: math_FunctionWithDerivative
        Bound1: float
        Bound2: float
        NbIterations: int,optional
        	default value is 100

        Returns
        -------
        None

        """
        return _math.math_BissecNewton_Perform(self, *args)

    def Root(self, *args):
        r"""
        Returns the value of the root. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_BissecNewton_Root(self, *args)

    def Value(self, *args):
        r"""
        Returns the value of the function at the root. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_BissecNewton_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_BissecNewton

# Register math_BissecNewton in _math:
_math.math_BissecNewton_swigregister(math_BissecNewton)
class math_BracketMinimum(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor preparing a and b parameters only. it does not perform the job.

        Parameters
        ----------
        A: float
        B: float

        Returns
        -------
        None
        Given two initial values this class computes a bracketing triplet of abscissae ax, bx, cx (such that bx is between ax and cx, f(bx) is less than both f(bx) and f(cx)) the brent minimization is done on the function f.

        Parameters
        ----------
        F: math_Function
        A: float
        B: float

        Returns
        -------
        None
        Given two initial values this class computes a bracketing triplet of abscissae ax, bx, cx (such that bx is between ax and cx, f(bx) is less than both f(bx) and f(cx)) the brent minimization is done on the function f. this constructor has to be used if f(a) is known.

        Parameters
        ----------
        F: math_Function
        A: float
        B: float
        FA: float

        Returns
        -------
        None
        Given two initial values this class computes a bracketing triplet of abscissae ax, bx, cx (such that bx is between ax and cx, f(bx) is less than both f(bx) and f(cx)) the brent minimization is done on the function f. this constructor has to be used if f(a) and f(b) are known.

        Parameters
        ----------
        F: math_Function
        A: float
        B: float
        FA: float
        FB: float

        Returns
        -------
        None

        """
        _math.math_BracketMinimum_swiginit(self, _math.new_math_BracketMinimum(*args))

    def DumpToString(self):
        r"""DumpToString(math_BracketMinimum self) -> std::string"""
        return _math.math_BracketMinimum_DumpToString(self)

    def FunctionValues(self, *args):
        r"""
        Returns the bracketed triplet function values. exceptions stdfail_notdone if the algorithm fails (and isdone returns false).

        Parameters
        ----------

        Returns
        -------
        FA: float
        FB: float
        FC: float

        """
        return _math.math_BracketMinimum_FunctionValues(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_BracketMinimum_IsDone(self, *args)

    def Perform(self, *args):
        r"""
        The method performing the job. it is called automatically by constructors with the function.

        Parameters
        ----------
        F: math_Function

        Returns
        -------
        None

        """
        return _math.math_BracketMinimum_Perform(self, *args)

    def SetFA(self, *args):
        r"""
        Set function value at a.

        Parameters
        ----------
        theValue: float

        Returns
        -------
        None

        """
        return _math.math_BracketMinimum_SetFA(self, *args)

    def SetFB(self, *args):
        r"""
        Set function value at b.

        Parameters
        ----------
        theValue: float

        Returns
        -------
        None

        """
        return _math.math_BracketMinimum_SetFB(self, *args)

    def SetLimits(self, *args):
        r"""
        Set limits of the parameter. by default no limits are applied to the parameter change. if no minimum is found in limits then isdone() will return false. the user is in charge of providing a and b to be in limits.

        Parameters
        ----------
        theLeft: float
        theRight: float

        Returns
        -------
        None

        """
        return _math.math_BracketMinimum_SetLimits(self, *args)

    def Values(self, *args):
        r"""
        Returns the bracketed triplet of abscissae. exceptions stdfail_notdone if the algorithm fails (and isdone returns false).

        Parameters
        ----------

        Returns
        -------
        A: float
        B: float
        C: float

        """
        return _math.math_BracketMinimum_Values(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_BracketMinimum

# Register math_BracketMinimum in _math:
_math.math_BracketMinimum_swigregister(math_BracketMinimum)
class math_BracketedRoot(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The brent method is used to find the root of the function f between the bounds bound1 and bound2 on the function f. if f(bound1)*f(bound2) >0 the brent method fails. the tolerance required for the root is given by tolerance. the solution is found when : abs(xi - xi-1) <= tolerance; the maximum number of iterations allowed is given by nbiterations.

        Parameters
        ----------
        F: math_Function
        Bound1: float
        Bound2: float
        Tolerance: float
        NbIterations: int,optional
        	default value is 100
        ZEPS: float,optional
        	default value is 1.0e-12

        Returns
        -------
        None

        """
        _math.math_BracketedRoot_swiginit(self, _math.new_math_BracketedRoot(*args))

    def DumpToString(self):
        r"""DumpToString(math_BracketedRoot self) -> std::string"""
        return _math.math_BracketedRoot_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_BracketedRoot_IsDone(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done during the computation of the root. exception notdone is raised if the minimum was not found.

        Returns
        -------
        int

        """
        return _math.math_BracketedRoot_NbIterations(self, *args)

    def Root(self, *args):
        r"""
        Returns the value of the root. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_BracketedRoot_Root(self, *args)

    def Value(self, *args):
        r"""
        Returns the value of the function at the root. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_BracketedRoot_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_BracketedRoot

# Register math_BracketedRoot in _math:
_math.math_BracketedRoot_swigregister(math_BracketedRoot)
class math_BrentMinimum(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        This constructor should be used in a sub-class to initialize correctly all the fields of this class.

        Parameters
        ----------
        TolX: float
        NbIterations: int,optional
        	default value is 100
        ZEPS: float,optional
        	default value is 1.0e-12

        Returns
        -------
        None
        This constructor should be used in a sub-class to initialize correctly all the fields of this class. it has to be used if f(bx) is known.

        Parameters
        ----------
        TolX: float
        Fbx: float
        NbIterations: int,optional
        	default value is 100
        ZEPS: float,optional
        	default value is 1.0e-12

        Returns
        -------
        None

        """
        _math.math_BrentMinimum_swiginit(self, _math.new_math_BrentMinimum(*args))

    def DumpToString(self):
        r"""DumpToString(math_BrentMinimum self) -> std::string"""
        return _math.math_BrentMinimum_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_BrentMinimum_IsDone(self, *args)

    def IsSolutionReached(self, *args):
        r"""
        This method is called at the end of each iteration to check if the solution is found. it can be redefined in a sub-class to implement a specific test to stop the iterations.

        Parameters
        ----------
        theFunction: math_Function

        Returns
        -------
        bool

        """
        return _math.math_BrentMinimum_IsSolutionReached(self, *args)

    def Location(self, *args):
        r"""
        Returns the location value of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_BrentMinimum_Location(self, *args)

    def Minimum(self, *args):
        r"""
        Returns the value of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_BrentMinimum_Minimum(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done during the computation of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        int

        """
        return _math.math_BrentMinimum_NbIterations(self, *args)

    def Perform(self, *args):
        r"""
        Brent minimization is performed on function f from a given bracketing triplet of abscissas ax, bx, cx (such that bx is between ax and cx, f(bx) is less than both f(bx) and f(cx)) the solution is found when: abs(xi - xi-1) <= tolx * abs(xi) + zeps;.

        Parameters
        ----------
        F: math_Function
        Ax: float
        Bx: float
        Cx: float

        Returns
        -------
        None

        """
        return _math.math_BrentMinimum_Perform(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_BrentMinimum

# Register math_BrentMinimum in _math:
_math.math_BrentMinimum_swigregister(math_BrentMinimum)
class math_BullardGenerator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Creates new xorshift 64-bit rng.

        Parameters
        ----------
        theSeed: unsigned int,optional
        	default value is 1

        Returns
        -------
        None

        """
        _math.math_BullardGenerator_swiginit(self, _math.new_math_BullardGenerator(*args))

    def NextInt(self, *args):
        r"""
        Generates new 64-bit integer value.

        Returns
        -------
        unsigned int

        """
        return _math.math_BullardGenerator_NextInt(self, *args)

    def NextReal(self, *args):
        r"""
        Generates new floating-point value.

        Returns
        -------
        float

        """
        return _math.math_BullardGenerator_NextReal(self, *args)

    def SetSeed(self, *args):
        r"""
        Setup new seed / reset defaults.

        Parameters
        ----------
        theSeed: unsigned int,optional
        	default value is 1

        Returns
        -------
        None

        """
        return _math.math_BullardGenerator_SetSeed(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_BullardGenerator

# Register math_BullardGenerator in _math:
_math.math_BullardGenerator_swigregister(math_BullardGenerator)
class math_ComputeGaussPointsAndWeights(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Number: int

        Returns
        -------
        None

        """
        _math.math_ComputeGaussPointsAndWeights_swiginit(self, _math.new_math_ComputeGaussPointsAndWeights(*args))

    def IsDone(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _math.math_ComputeGaussPointsAndWeights_IsDone(self, *args)

    def Points(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        math_Vector

        """
        return _math.math_ComputeGaussPointsAndWeights_Points(self, *args)

    def Weights(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        math_Vector

        """
        return _math.math_ComputeGaussPointsAndWeights_Weights(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_ComputeGaussPointsAndWeights

# Register math_ComputeGaussPointsAndWeights in _math:
_math.math_ComputeGaussPointsAndWeights_swigregister(math_ComputeGaussPointsAndWeights)
class math_ComputeKronrodPointsAndWeights(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Number: int

        Returns
        -------
        None

        """
        _math.math_ComputeKronrodPointsAndWeights_swiginit(self, _math.new_math_ComputeKronrodPointsAndWeights(*args))

    def IsDone(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _math.math_ComputeKronrodPointsAndWeights_IsDone(self, *args)

    def Points(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        math_Vector

        """
        return _math.math_ComputeKronrodPointsAndWeights_Points(self, *args)

    def Weights(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        math_Vector

        """
        return _math.math_ComputeKronrodPointsAndWeights_Weights(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_ComputeKronrodPointsAndWeights

# Register math_ComputeKronrodPointsAndWeights in _math:
_math.math_ComputeKronrodPointsAndWeights_swigregister(math_ComputeKronrodPointsAndWeights)
class math_Crout(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Given an input matrix a, this algorithm inverts a by the crout algorithm. the user can give only the inferior triangle for the implementation. a can be decomposed like this: a = l * d * t(l) where l is triangular inferior and d is diagonal. if one element of a is less than minpivot, a is considered as singular. exception notsquare is raised if a is not a square matrix.

        Parameters
        ----------
        A: math_Matrix
        MinPivot: float,optional
        	default value is 1.0e-20

        Returns
        -------
        None

        """
        _math.math_Crout_swiginit(self, _math.new_math_Crout(*args))

    def Determinant(self, *args):
        r"""
        Returns the value of the determinant of the previously lu decomposed matrix a. zero is returned if the matrix a is considered as singular. exceptions stdfail_notdone if the algorithm fails (and isdone returns false).

        Returns
        -------
        float

        """
        return _math.math_Crout_Determinant(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_Crout self) -> std::string"""
        return _math.math_Crout_DumpToString(self)

    def Inverse(self, *args):
        r"""
        Returns the inverse matrix of a. only the inferior triangle is returned. exception notdone is raised if notdone.

        Returns
        -------
        math_Matrix

        """
        return _math.math_Crout_Inverse(self, *args)

    def Invert(self, *args):
        r"""
        Returns in inv the inverse matrix of a. only the inferior triangle is returned. exception notdone is raised if notdone.

        Parameters
        ----------
        Inv: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_Crout_Invert(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if all has been correctly done.

        Returns
        -------
        bool

        """
        return _math.math_Crout_IsDone(self, *args)

    def Solve(self, *args):
        r"""
        Given an input vector <b>, this routine returns the solution of the set of linear equations a . x = b. exception notdone is raised if the decomposition was not done successfully. exception dimensionerror is raised if the range of b is not equal to the rowrange of a.

        Parameters
        ----------
        B: math_Vector
        X: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Crout_Solve(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_Crout

# Register math_Crout in _math:
_math.math_Crout_swigregister(math_Crout)
class math_DirectPolynomialRoots(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Computes all the real roots of the polynomial ax4 + bx3 + cx2 + dx + e using a direct method.

        Parameters
        ----------
        A: float
        B: float
        C: float
        D: float
        E: float

        Returns
        -------
        None
        Computes all the real roots of the polynomial ax3 + bx2 + cx + d using a direct method.

        Parameters
        ----------
        A: float
        B: float
        C: float
        D: float

        Returns
        -------
        None
        Computes all the real roots of the polynomial ax2 + bx + c using a direct method.

        Parameters
        ----------
        A: float
        B: float
        C: float

        Returns
        -------
        None
        Computes the real root of the polynomial ax + b.

        Parameters
        ----------
        A: float
        B: float

        Returns
        -------
        None

        """
        _math.math_DirectPolynomialRoots_swiginit(self, _math.new_math_DirectPolynomialRoots(*args))

    def DumpToString(self):
        r"""DumpToString(math_DirectPolynomialRoots self) -> std::string"""
        return _math.math_DirectPolynomialRoots_DumpToString(self)

    def InfiniteRoots(self, *args):
        r"""
        Returns true if there is an infinity of roots, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_DirectPolynomialRoots_InfiniteRoots(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_DirectPolynomialRoots_IsDone(self, *args)

    def NbSolutions(self, *args):
        r"""
        Returns the number of solutions. an exception is raised if there are an infinity of roots.

        Returns
        -------
        int

        """
        return _math.math_DirectPolynomialRoots_NbSolutions(self, *args)

    def Value(self, *args):
        r"""
        Returns the value of the nieme root. an exception is raised if there are an infinity of roots. exception rangeerror is raised if nieme is < 1 or nieme > nbsolutions.

        Parameters
        ----------
        Nieme: int

        Returns
        -------
        float

        """
        return _math.math_DirectPolynomialRoots_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_DirectPolynomialRoots

# Register math_DirectPolynomialRoots in _math:
_math.math_DirectPolynomialRoots_swigregister(math_DirectPolynomialRoots)
class math_DoubleTab(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        LowerRow: int
        UpperRow: int
        LowerCol: int
        UpperCol: int

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Tab: Standard_Address
        LowerRow: int
        UpperRow: int
        LowerCol: int
        UpperCol: int

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Other: math_DoubleTab

        Returns
        -------
        None

        """
        _math.math_DoubleTab_swiginit(self, _math.new_math_DoubleTab(*args))

    def Copy(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Other: math_DoubleTab

        Returns
        -------
        None

        """
        return _math.math_DoubleTab_Copy(self, *args)

    def Free(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        return _math.math_DoubleTab_Free(self, *args)

    def Init(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        InitValue: float

        Returns
        -------
        None

        """
        return _math.math_DoubleTab_Init(self, *args)

    def SetLowerCol(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        LowerCol: int

        Returns
        -------
        None

        """
        return _math.math_DoubleTab_SetLowerCol(self, *args)

    def SetLowerRow(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        LowerRow: int

        Returns
        -------
        None

        """
        return _math.math_DoubleTab_SetLowerRow(self, *args)

    def GetValue(self, RowIndex, ColIndex):
        r"""GetValue(math_DoubleTab self, Standard_Integer const RowIndex, Standard_Integer const ColIndex) -> Standard_Real"""
        return _math.math_DoubleTab_GetValue(self, RowIndex, ColIndex)

    def SetValue(self, RowIndex, ColIndex, value):
        r"""SetValue(math_DoubleTab self, Standard_Integer const RowIndex, Standard_Integer const ColIndex, Standard_Real value)"""
        return _math.math_DoubleTab_SetValue(self, RowIndex, ColIndex, value)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_DoubleTab

# Register math_DoubleTab in _math:
_math.math_DoubleTab_swigregister(math_DoubleTab)
class math_EigenValuesSearcher(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Diagonal: TColStd_Array1OfReal
        Subdiagonal: TColStd_Array1OfReal

        Returns
        -------
        None

        """
        _math.math_EigenValuesSearcher_swiginit(self, _math.new_math_EigenValuesSearcher(*args))

    def Dimension(self, *args):
        r"""
        Returns the dimension of matrix.

        Returns
        -------
        int

        """
        return _math.math_EigenValuesSearcher_Dimension(self, *args)

    def EigenValue(self, *args):
        r"""
        Returns the index_th eigen value of matrix index must be in [1, dimension()].

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _math.math_EigenValuesSearcher_EigenValue(self, *args)

    def EigenVector(self, *args):
        r"""
        Returns the index_th eigen vector of matrix index must be in [1, dimension()].

        Parameters
        ----------
        Index: int

        Returns
        -------
        math_Vector

        """
        return _math.math_EigenValuesSearcher_EigenVector(self, *args)

    def IsDone(self, *args):
        r"""
        Returns standard_true if computation is performed successfully.

        Returns
        -------
        bool

        """
        return _math.math_EigenValuesSearcher_IsDone(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_EigenValuesSearcher

# Register math_EigenValuesSearcher in _math:
_math.math_EigenValuesSearcher_swigregister(math_EigenValuesSearcher)
class math_FRPR(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initializes the computation of the minimum of f. warning: constructor does not perform computations.

        Parameters
        ----------
        theFunction: math_MultipleVarFunctionWithGradient
        theTolerance: float
        theNbIterations: int,optional
        	default value is 200
        theZEPS: float,optional
        	default value is 1.0e-12

        Returns
        -------
        None

        """
        _math.math_FRPR_swiginit(self, _math.new_math_FRPR(*args))

    def DumpToString(self):
        r"""DumpToString(math_FRPR self) -> std::string"""
        return _math.math_FRPR_DumpToString(self)

    def Gradient(self, *args):
        r"""
        Returns the gradient vector at the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        math_Vector
        Outputs the gradient vector at the minimum in grad. exception notdone is raised if the minimum was not found. exception dimensionerror is raised if the range of grad is not equal to the range of the startingpoint.

        Parameters
        ----------
        Grad: math_Vector

        Returns
        -------
        None

        """
        return _math.math_FRPR_Gradient(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_FRPR_IsDone(self, *args)

    def IsSolutionReached(self, *args):
        r"""
        The solution f = fi is found when: 2.0 * abs(fi - fi-1) <= tolerance * (abs(fi) + abs(fi-1)) + zeps. the maximum number of iterations allowed is given by nbiterations.

        Parameters
        ----------
        theFunction: math_MultipleVarFunctionWithGradient

        Returns
        -------
        bool

        """
        return _math.math_FRPR_IsSolutionReached(self, *args)

    def Location(self, *args):
        r"""
        Returns the location vector of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        math_Vector
        Outputs the location vector of the minimum in loc. exception notdone is raised if the minimum was not found. exception dimensionerror is raised if the range of loc is not equal to the range of the startingpoint.

        Parameters
        ----------
        Loc: math_Vector

        Returns
        -------
        None

        """
        return _math.math_FRPR_Location(self, *args)

    def Minimum(self, *args):
        r"""
        Returns the value of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_FRPR_Minimum(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done during the computation of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        int

        """
        return _math.math_FRPR_NbIterations(self, *args)

    def Perform(self, *args):
        r"""
        The solution f = fi is found when 2.0 * abs(fi - fi-1) <= tolerance * (abs(fi) + abs(fi-1) + zeps).

        Parameters
        ----------
        theFunction: math_MultipleVarFunctionWithGradient
        theStartingPoint: math_Vector

        Returns
        -------
        None

        """
        return _math.math_FRPR_Perform(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_FRPR

# Register math_FRPR in _math:
_math.math_FRPR_swigregister(math_FRPR)
class math_Function(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetStateNumber(self, *args):
        r"""
        Returns the state of the function corresponding to the latest call of any methods associated with the function. this function is called by each of the algorithms described later which defined the function integer algorithm::statenumber(). the algorithm has the responsibility to call this function when it has found a solution (i.e. a root or a minimum) and has to maintain the association between the solution found and this statenumber. byu default, this method returns 0 (which means for the algorithm: no state has been saved). it is the responsibility of the programmer to decide if he needs to save the current state of the function and to return an integer that allows retrieval of the state.

        Returns
        -------
        int

        """
        return _math.math_Function_GetStateNumber(self, *args)

    def Value(self, *args):
        r"""
        Computes the value of the function <f> for a given value of variable <x>. returns true if the computation was done successfully, false otherwise.

        Parameters
        ----------
        X: float

        Returns
        -------
        F: float

        """
        return _math.math_Function_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_Function

# Register math_Function in _math:
_math.math_Function_swigregister(math_Function)
class math_FunctionAllRoots(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The algorithm uses the sample to find intervals on which the function is null. an interval is found if, for at least two consecutive points of the sample, ui and ui+1, we get |f(ui)|<=epsnul and |f(ui+1)|<=epsnul. the real bounds of an interval are computed with the functionroots. algorithm. between two intervals, the roots of the function f are calculated using the functionroots algorithm.

        Parameters
        ----------
        F: math_FunctionWithDerivative
        S: math_FunctionSample
        EpsX: float
        EpsF: float
        EpsNul: float

        Returns
        -------
        None

        """
        _math.math_FunctionAllRoots_swiginit(self, _math.new_math_FunctionAllRoots(*args))

    def DumpToString(self):
        r"""DumpToString(math_FunctionAllRoots self) -> std::string"""
        return _math.math_FunctionAllRoots_DumpToString(self)

    def GetInterval(self, *args):
        r"""
        Returns the interval of parameter of range index. an exception is raised if isdone returns false; an exception is raised if index<=0 or index >nbintervals.

        Parameters
        ----------
        Index: int

        Returns
        -------
        A: float
        B: float

        """
        return _math.math_FunctionAllRoots_GetInterval(self, *args)

    def GetIntervalState(self, *args):
        r"""
        Returns the state number associated to the interval index. an exception is raised if isdone returns false; an exception is raised if index<=0 or index >nbintervals.

        Parameters
        ----------
        Index: int

        Returns
        -------
        IFirst: int
        ILast: int

        """
        return _math.math_FunctionAllRoots_GetIntervalState(self, *args)

    def GetPoint(self, *args):
        r"""
        Returns the parameter of the point of range index. an exception is raised if isdone returns false; an exception is raised if index<=0 or index >nbpoints.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _math.math_FunctionAllRoots_GetPoint(self, *args)

    def GetPointState(self, *args):
        r"""
        Returns the state number associated to the point index. an exception is raised if isdone returns false; an exception is raised if index<=0 or index >nbintervals.

        Parameters
        ----------
        Index: int

        Returns
        -------
        int

        """
        return _math.math_FunctionAllRoots_GetPointState(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computation has been done successfully.

        Returns
        -------
        bool

        """
        return _math.math_FunctionAllRoots_IsDone(self, *args)

    def NbIntervals(self, *args):
        r"""
        Returns the number of intervals on which the function is null. an exception is raised if isdone returns false.

        Returns
        -------
        int

        """
        return _math.math_FunctionAllRoots_NbIntervals(self, *args)

    def NbPoints(self, *args):
        r"""
        Returns the number of points where the function is null. an exception is raised if isdone returns false.

        Returns
        -------
        int

        """
        return _math.math_FunctionAllRoots_NbPoints(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_FunctionAllRoots

# Register math_FunctionAllRoots in _math:
_math.math_FunctionAllRoots_swigregister(math_FunctionAllRoots)
class math_FunctionRoot(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The newton-raphson method is done to find the root of the function f from the initial guess guess.the tolerance required on the root is given by tolerance. iterations are stopped if the expected solution does not stay in the range a..b. the solution is found when abs(xi - xi-1) <= tolerance; the maximum number of iterations allowed is given by nbiterations.

        Parameters
        ----------
        F: math_FunctionWithDerivative
        Guess: float
        Tolerance: float
        NbIterations: int,optional
        	default value is 100

        Returns
        -------
        None
        The newton-raphson method is done to find the root of the function f from the initial guess guess. the tolerance required on the root is given by tolerance. iterations are stopped if the expected solution does not stay in the range a..b the solution is found when abs(xi - xi-1) <= tolerance; the maximum number of iterations allowed is given by nbiterations.

        Parameters
        ----------
        F: math_FunctionWithDerivative
        Guess: float
        Tolerance: float
        A: float
        B: float
        NbIterations: int,optional
        	default value is 100

        Returns
        -------
        None

        """
        _math.math_FunctionRoot_swiginit(self, _math.new_math_FunctionRoot(*args))

    def Derivative(self, *args):
        r"""
        Returns the value of the derivative at the root. exception notdone is raised if the root was not found.

        Returns
        -------
        float

        """
        return _math.math_FunctionRoot_Derivative(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_FunctionRoot self) -> std::string"""
        return _math.math_FunctionRoot_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_FunctionRoot_IsDone(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done on the computation of the root. exception notdone is raised if the root was not found.

        Returns
        -------
        int

        """
        return _math.math_FunctionRoot_NbIterations(self, *args)

    def Root(self, *args):
        r"""
        Returns the value of the root. exception notdone is raised if the root was not found.

        Returns
        -------
        float

        """
        return _math.math_FunctionRoot_Root(self, *args)

    def Value(self, *args):
        r"""
        Returns the value of the function at the root. exception notdone is raised if the root was not found.

        Returns
        -------
        float

        """
        return _math.math_FunctionRoot_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_FunctionRoot

# Register math_FunctionRoot in _math:
_math.math_FunctionRoot_swigregister(math_FunctionRoot)
class math_FunctionRoots(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Calculates all the real roots of a function f-k within the range a..b. without conditions on a and b a solution x is found when abs(xi - xi-1) <= epsx and abs(f(xi)-k) <= epsf. the function is considered as null between a and b if abs(f-k) <= epsnull within this range.

        Parameters
        ----------
        F: math_FunctionWithDerivative
        A: float
        B: float
        NbSample: int
        EpsX: float,optional
        	default value is 0.0
        EpsF: float,optional
        	default value is 0.0
        EpsNull: float,optional
        	default value is 0.0
        K: float,optional
        	default value is 0.0

        Returns
        -------
        None

        """
        _math.math_FunctionRoots_swiginit(self, _math.new_math_FunctionRoots(*args))

    def DumpToString(self):
        r"""DumpToString(math_FunctionRoots self) -> std::string"""
        return _math.math_FunctionRoots_DumpToString(self)

    def IsAllNull(self, *args):
        r"""
        Returns true if the function is considered as null between a and b. exceptions stdfail_notdone if the algorithm fails (and isdone returns false).

        Returns
        -------
        bool

        """
        return _math.math_FunctionRoots_IsAllNull(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_FunctionRoots_IsDone(self, *args)

    def NbSolutions(self, *args):
        r"""
        Returns the number of solutions found. exceptions stdfail_notdone if the algorithm fails (and isdone returns false).

        Returns
        -------
        int

        """
        return _math.math_FunctionRoots_NbSolutions(self, *args)

    def StateNumber(self, *args):
        r"""
        Returns the statenumber of the nieme root. exception rangeerror is raised if nieme is < 1 or nieme > nbsolutions.

        Parameters
        ----------
        Nieme: int

        Returns
        -------
        int

        """
        return _math.math_FunctionRoots_StateNumber(self, *args)

    def Value(self, *args):
        r"""
        Returns the nth value of the root of function f. exceptions stdfail_notdone if the algorithm fails (and isdone returns false).

        Parameters
        ----------
        Nieme: int

        Returns
        -------
        float

        """
        return _math.math_FunctionRoots_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_FunctionRoots

# Register math_FunctionRoots in _math:
_math.math_FunctionRoots_swigregister(math_FunctionRoots)
class math_FunctionSample(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        A: float
        B: float
        N: int

        Returns
        -------
        None

        """
        _math.math_FunctionSample_swiginit(self, _math.new_math_FunctionSample(*args))

    def Bounds(self, *args):
        r"""
        Returns the bounds of parameters.

        Parameters
        ----------

        Returns
        -------
        A: float
        B: float

        """
        return _math.math_FunctionSample_Bounds(self, *args)

    def GetParameter(self, *args):
        r"""
        Returns the value of parameter of the point of range index : a + ((index-1)/(nbpoints-1))*b. an exception is raised if index<=0 or index>nbpoints.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _math.math_FunctionSample_GetParameter(self, *args)

    def NbPoints(self, *args):
        r"""
        Returns the number of sample points.

        Returns
        -------
        int

        """
        return _math.math_FunctionSample_NbPoints(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_FunctionSample

# Register math_FunctionSample in _math:
_math.math_FunctionSample_swigregister(math_FunctionSample)
class math_FunctionSet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetStateNumber(self, *args):
        r"""
        Returns the state of the function corresponding to the latestcall of any methods associated with the function. this function is called by each of the algorithms described later which define the function integer algorithm::statenumber(). the algorithm has the responsibility to call this function when it has found a solution (i.e. a root or a minimum) and has to maintain the association between the solution found and this statenumber. byu default, this method returns 0 (which means for the algorithm: no state has been saved). it is the responsibility of the programmer to decide if he needs to save the current state of the function and to return an integer that allows retrieval of the state.

        Returns
        -------
        int

        """
        return _math.math_FunctionSet_GetStateNumber(self, *args)

    def NbEquations(self, *args):
        r"""
        Returns the number of equations of the function.

        Returns
        -------
        int

        """
        return _math.math_FunctionSet_NbEquations(self, *args)

    def NbVariables(self, *args):
        r"""
        Returns the number of variables of the function.

        Returns
        -------
        int

        """
        return _math.math_FunctionSet_NbVariables(self, *args)

    def Value(self, *args):
        r"""
        Computes the values <f> of the functions for the variable <x>. returns true if the computation was done successfully, false otherwise.

        Parameters
        ----------
        X: math_Vector
        F: math_Vector

        Returns
        -------
        bool

        """
        return _math.math_FunctionSet_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_FunctionSet

# Register math_FunctionSet in _math:
_math.math_FunctionSet_swigregister(math_FunctionSet)
class math_FunctionSetRoot(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Is used in a sub-class to initialize correctly all the fields of this class. the range (1, f.nbvariables()) must be especially respected for all vectors and matrix declarations.

        Parameters
        ----------
        F: math_FunctionSetWithDerivatives
        Tolerance: math_Vector
        NbIterations: int,optional
        	default value is 100

        Returns
        -------
        None
        Is used in a sub-class to initialize correctly all the fields of this class. the range (1, f.nbvariables()) must be especially respected for all vectors and matrix declarations. the method settolerance must be called after this constructor.

        Parameters
        ----------
        F: math_FunctionSetWithDerivatives
        NbIterations: int,optional
        	default value is 100

        Returns
        -------
        None

        """
        _math.math_FunctionSetRoot_swiginit(self, _math.new_math_FunctionSetRoot(*args))

    def Derivative(self, *args):
        r"""
        Returns the matrix value of the derivative at the root. exception notdone is raised if the root was not found.

        Returns
        -------
        math_Matrix
        Outputs the matrix value of the derivative at the root in der. exception notdone is raised if the root was not found. exception dimensionerror is raised if the column range of <der> is not equal to the range of the startingpoint.

        Parameters
        ----------
        Der: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_FunctionSetRoot_Derivative(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_FunctionSetRoot self) -> std::string"""
        return _math.math_FunctionSetRoot_DumpToString(self)

    def FunctionSetErrors(self, *args):
        r"""
        Returns the vector value of the error done on the functions at the root. exception notdone is raised if the root was not found.

        Returns
        -------
        math_Vector
        Outputs the vector value of the error done on the functions at the root in err. exception notdone is raised if the root was not found. exception dimensionerror is raised if the range of err is not equal to the range of the startingpoint.

        Parameters
        ----------
        Err: math_Vector

        Returns
        -------
        None

        """
        return _math.math_FunctionSetRoot_FunctionSetErrors(self, *args)

    def IsDivergent(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _math.math_FunctionSetRoot_IsDivergent(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_FunctionSetRoot_IsDone(self, *args)

    def IsSolutionReached(self, *args):
        r"""
        This routine is called at the end of each iteration to check if the solution was found. it can be redefined in a sub-class to implement a specific test to stop the iterations. in this case, the solution is found when: abs(xi - xi-1) <= tolerance for all unknowns.

        Parameters
        ----------
        F: math_FunctionSetWithDerivatives

        Returns
        -------
        bool

        """
        return _math.math_FunctionSetRoot_IsSolutionReached(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done during the computation of the root. exception notdone is raised if the root was not found.

        Returns
        -------
        int

        """
        return _math.math_FunctionSetRoot_NbIterations(self, *args)

    def Perform(self, *args):
        r"""
        Improves the root of function from the initial guess point. the infinum and supremum may be given to constrain the solution. in this case, the solution is found when: abs(xi - xi-1)(j) <= tolerance(j) for all unknowns.

        Parameters
        ----------
        theFunction: math_FunctionSetWithDerivatives
        theStartingPoint: math_Vector
        theStopOnDivergent: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        Improves the root of function from the initial guess point. the infinum and supremum may be given to constrain the solution. in this case, the solution is found when: abs(xi - xi-1) <= tolerance for all unknowns.

        Parameters
        ----------
        theFunction: math_FunctionSetWithDerivatives
        theStartingPoint: math_Vector
        theInfBound: math_Vector
        theSupBound: math_Vector
        theStopOnDivergent: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _math.math_FunctionSetRoot_Perform(self, *args)

    def Root(self, *args):
        r"""
        Returns the value of the root of function f. exception notdone is raised if the root was not found.

        Returns
        -------
        math_Vector
        Outputs the root vector in root. exception notdone is raised if the root was not found. exception dimensionerror is raised if the range of root is not equal to the range of the startingpoint.

        Parameters
        ----------
        Root: math_Vector

        Returns
        -------
        None

        """
        return _math.math_FunctionSetRoot_Root(self, *args)

    def SetTolerance(self, *args):
        r"""
        Initializes the tolerance values.

        Parameters
        ----------
        Tolerance: math_Vector

        Returns
        -------
        None

        """
        return _math.math_FunctionSetRoot_SetTolerance(self, *args)

    def StateNumber(self, *args):
        r"""
        Returns the statenumber (as returned by f.getstatenumber()) associated to the root found.

        Returns
        -------
        int

        """
        return _math.math_FunctionSetRoot_StateNumber(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_FunctionSetRoot

# Register math_FunctionSetRoot in _math:
_math.math_FunctionSetRoot_swigregister(math_FunctionSetRoot)
class math_Gauss(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Given an input n x n matrix a this constructor performs its lu decomposition with partial pivoting (interchange of rows). this lu decomposition is stored internally and may be used to do subsequent calculation. if the largest pivot found is less than minpivot the matrix a is considered as singular. exception notsquare is raised if a is not a square matrix.

        Parameters
        ----------
        A: math_Matrix
        MinPivot: float,optional
        	default value is 1.0e-20
        theProgress: Message_ProgressRange,optional
        	default value is Message_ProgressRange()

        Returns
        -------
        None

        """
        _math.math_Gauss_swiginit(self, _math.new_math_Gauss(*args))

    def Determinant(self, *args):
        r"""
        This routine returns the value of the determinant of the previously lu decomposed matrix a. exception notdone may be raised if the decomposition of a was not done successfully, zero is returned if the matrix a was considered as singular.

        Returns
        -------
        float

        """
        return _math.math_Gauss_Determinant(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_Gauss self) -> std::string"""
        return _math.math_Gauss_DumpToString(self)

    def Invert(self, *args):
        r"""
        This routine outputs inv the inverse of the previously lu decomposed matrix a. exception dimensionerror is raised if the ranges of b are not equal to the ranges of a.

        Parameters
        ----------
        Inv: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_Gauss_Invert(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_Gauss_IsDone(self, *args)

    def Solve(self, *args):
        r"""
        Given the input vector b this routine returns the solution x of the set of linear equations a . x = b. exception notdone is raised if the decomposition of a was not done successfully. exception dimensionerror is raised if the range of b is not equal to the number of rows of a.

        Parameters
        ----------
        B: math_Vector
        X: math_Vector

        Returns
        -------
        None
        Given the input vector b this routine solves the set of linear equations a . x = b. b is replaced by the vector solution x. exception notdone is raised if the decomposition of a was not done successfully. exception dimensionerror is raised if the range of b is not equal to the number of rows of a.

        Parameters
        ----------
        B: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Gauss_Solve(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_Gauss

# Register math_Gauss in _math:
_math.math_Gauss_swigregister(math_Gauss)
class math_GaussLeastSquare(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Given an input n x m matrix a with n >= m this constructor performs the lu decomposition with partial pivoting (interchange of rows) of the matrix aa = a.transposed() * a; this lu decomposition is stored internally and may be used to do subsequent calculation. if the largest pivot found is less than minpivot the matrix <a> is considered as singular.

        Parameters
        ----------
        A: math_Matrix
        MinPivot: float,optional
        	default value is 1.0e-20

        Returns
        -------
        None

        """
        _math.math_GaussLeastSquare_swiginit(self, _math.new_math_GaussLeastSquare(*args))

    def DumpToString(self):
        r"""DumpToString(math_GaussLeastSquare self) -> std::string"""
        return _math.math_GaussLeastSquare_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.e.

        Returns
        -------
        bool

        """
        return _math.math_GaussLeastSquare_IsDone(self, *args)

    def Solve(self, *args):
        r"""
        Given the input vector <b> this routine solves the set of linear equations a . x = b. exception notdone is raised if the decomposition of a was not done successfully. exception dimensionerror is raised if the range of b inv is not equal to the rowrange of a. exception dimensionerror is raised if the range of x inv is not equal to the colrange of a.

        Parameters
        ----------
        B: math_Vector
        X: math_Vector

        Returns
        -------
        None

        """
        return _math.math_GaussLeastSquare_Solve(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_GaussLeastSquare

# Register math_GaussLeastSquare in _math:
_math.math_GaussLeastSquare_swigregister(math_GaussLeastSquare)
class math_GaussMultipleIntegration(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The gauss-legendre integration with order = points of integration for each unknown, is done on the function f between the bounds lower and upper.

        Parameters
        ----------
        F: math_MultipleVarFunction
        Lower: math_Vector
        Upper: math_Vector
        Order: math_IntegerVector

        Returns
        -------
        None

        """
        _math.math_GaussMultipleIntegration_swiginit(self, _math.new_math_GaussMultipleIntegration(*args))

    def DumpToString(self):
        r"""DumpToString(math_GaussMultipleIntegration self) -> std::string"""
        return _math.math_GaussMultipleIntegration_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if all has been correctly done.

        Returns
        -------
        bool

        """
        return _math.math_GaussMultipleIntegration_IsDone(self, *args)

    def Value(self, *args):
        r"""
        Returns the value of the integral.

        Returns
        -------
        float

        """
        return _math.math_GaussMultipleIntegration_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_GaussMultipleIntegration

# Register math_GaussMultipleIntegration in _math:
_math.math_GaussMultipleIntegration_swigregister(math_GaussMultipleIntegration)
class math_GaussSetIntegration(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The gauss-legendre integration with order = points of integration for each unknown, is done on the function f between the bounds lower and upper.

        Parameters
        ----------
        F: math_FunctionSet
        Lower: math_Vector
        Upper: math_Vector
        Order: math_IntegerVector

        Returns
        -------
        None

        """
        _math.math_GaussSetIntegration_swiginit(self, _math.new_math_GaussSetIntegration(*args))

    def DumpToString(self):
        r"""DumpToString(math_GaussSetIntegration self) -> std::string"""
        return _math.math_GaussSetIntegration_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if all has been correctly done.

        Returns
        -------
        bool

        """
        return _math.math_GaussSetIntegration_IsDone(self, *args)

    def Value(self, *args):
        r"""
        Returns the value of the integral.

        Returns
        -------
        math_Vector

        """
        return _math.math_GaussSetIntegration_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_GaussSetIntegration

# Register math_GaussSetIntegration in _math:
_math.math_GaussSetIntegration_swigregister(math_GaussSetIntegration)
class math_GaussSingleIntegration(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        The gauss-legendre integration with n = order points of integration, is done on the function f between the bounds lower and upper.

        Parameters
        ----------
        F: math_Function
        Lower: float
        Upper: float
        Order: int

        Returns
        -------
        None
        The gauss-legendre integration with n = order points of integration and given tolerance = tol is done on the function f between the bounds lower and upper.

        Parameters
        ----------
        F: math_Function
        Lower: float
        Upper: float
        Order: int
        Tol: float

        Returns
        -------
        None

        """
        _math.math_GaussSingleIntegration_swiginit(self, _math.new_math_GaussSingleIntegration(*args))

    def DumpToString(self):
        r"""DumpToString(math_GaussSingleIntegration self) -> std::string"""
        return _math.math_GaussSingleIntegration_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if all has been correctly done.

        Returns
        -------
        bool

        """
        return _math.math_GaussSingleIntegration_IsDone(self, *args)

    def Value(self, *args):
        r"""
        Returns the value of the integral.

        Returns
        -------
        float

        """
        return _math.math_GaussSingleIntegration_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_GaussSingleIntegration

# Register math_GaussSingleIntegration in _math:
_math.math_GaussSingleIntegration_swigregister(math_GaussSingleIntegration)
class math_GlobOptMin(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor. perform method is not called from it. @param thefunc - objective functional. @param thelowerborder - lower corner of the search box. @param theupperborder - upper corner of the search box. @param thec - lipschitz constant. @param thediscretizationtol - parameter space discretization tolerance. @param thesametol - functional value space indifference tolerance.

        Parameters
        ----------
        theFunc: math_MultipleVarFunction *
        theLowerBorder: math_Vector
        theUpperBorder: math_Vector
        theC: float,optional
        	default value is 9
        theDiscretizationTol: float,optional
        	default value is 1.0e-2
        theSameTol: float,optional
        	default value is 1.0e-7

        Returns
        -------
        None

        """
        _math.math_GlobOptMin_swiginit(self, _math.new_math_GlobOptMin(*args))

    def GetContinuity(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _math.math_GlobOptMin_GetContinuity(self, *args)

    def GetF(self, *args):
        r"""
        Get best functional value.

        Returns
        -------
        float

        """
        return _math.math_GlobOptMin_GetF(self, *args)

    def GetFunctionalMinimalValue(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _math.math_GlobOptMin_GetFunctionalMinimalValue(self, *args)

    def GetLipConstState(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _math.math_GlobOptMin_GetLipConstState(self, *args)

    def GetTol(self, *args):
        r"""
        Method to get tolerances. @param thediscretizationtol - parameter space discretization tolerance. @param thesametol - functional value space indifference tolerance.

        Parameters
        ----------

        Returns
        -------
        theDiscretizationTol: float
        theSameTol: float

        """
        return _math.math_GlobOptMin_GetTol(self, *args)

    def NbExtrema(self, *args):
        r"""
        Return count of global extremas.

        Returns
        -------
        int

        """
        return _math.math_GlobOptMin_NbExtrema(self, *args)

    def Perform(self, *args):
        r"""
        @param isfindsinglesolution - defines whether to find single solution or all solutions.

        Parameters
        ----------
        isFindSingleSolution: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _math.math_GlobOptMin_Perform(self, *args)

    def Points(self, *args):
        r"""
        Return solution theindex, 1 <= theindex <= nbextrema.

        Parameters
        ----------
        theIndex: int
        theSol: math_Vector

        Returns
        -------
        None

        """
        return _math.math_GlobOptMin_Points(self, *args)

    def SetContinuity(self, *args):
        r"""
        Set / get continuity of local borders splits (0 ~ c0, 1 ~ c1, 2 ~ c2).

        Parameters
        ----------
        theCont: int

        Returns
        -------
        None

        """
        return _math.math_GlobOptMin_SetContinuity(self, *args)

    def SetFunctionalMinimalValue(self, *args):
        r"""
        Set / get functional minimal value.

        Parameters
        ----------
        theMinimalValue: float

        Returns
        -------
        None

        """
        return _math.math_GlobOptMin_SetFunctionalMinimalValue(self, *args)

    def SetGlobalParams(self, *args):
        r"""
        @param thefunc - objective functional. @param thelowerborder - lower corner of the search box. @param theupperborder - upper corner of the search box. @param thec - lipschitz constant. @param thediscretizationtol - parameter space discretization tolerance. @param thesametol - functional value space indifference tolerance.

        Parameters
        ----------
        theFunc: math_MultipleVarFunction *
        theLowerBorder: math_Vector
        theUpperBorder: math_Vector
        theC: float,optional
        	default value is 9
        theDiscretizationTol: float,optional
        	default value is 1.0e-2
        theSameTol: float,optional
        	default value is 1.0e-7

        Returns
        -------
        None

        """
        return _math.math_GlobOptMin_SetGlobalParams(self, *args)

    def SetLipConstState(self, *args):
        r"""
        Set / get lipchitz constant modification state. true means that the constant is locked and unlocked otherwise.

        Parameters
        ----------
        theFlag: bool

        Returns
        -------
        None

        """
        return _math.math_GlobOptMin_SetLipConstState(self, *args)

    def SetLocalParams(self, *args):
        r"""
        Method to reduce bounding box. perform will use this box. @param thelocala - lower corner of the local box. @param thelocalb - upper corner of the local box.

        Parameters
        ----------
        theLocalA: math_Vector
        theLocalB: math_Vector

        Returns
        -------
        None

        """
        return _math.math_GlobOptMin_SetLocalParams(self, *args)

    def SetTol(self, *args):
        r"""
        Method to set tolerances. @param thediscretizationtol - parameter space discretization tolerance. @param thesametol - functional value space indifference tolerance.

        Parameters
        ----------
        theDiscretizationTol: float
        theSameTol: float

        Returns
        -------
        None

        """
        return _math.math_GlobOptMin_SetTol(self, *args)

    def isDone(self, *args):
        r"""
        Return computation state of the algorithm.

        Returns
        -------
        bool

        """
        return _math.math_GlobOptMin_isDone(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_GlobOptMin

# Register math_GlobOptMin in _math:
_math.math_GlobOptMin_swigregister(math_GlobOptMin)
class math_Householder(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Given an input matrix a with n>= m, given an input matrix b this constructor performs the least square resolution of the set of linear equations a.x = b for each column of b. if a column norm is less than eps, the resolution can't be done. exception dimensionerror is raised if the row number of b is different from the a row number.

        Parameters
        ----------
        A: math_Matrix
        B: math_Matrix
        EPS: float,optional
        	default value is 1.0e-20

        Returns
        -------
        None
        Given an input matrix a with n>= m, given an input matrix b this constructor performs the least square resolution of the set of linear equations a.x = b for each column of b. if a column norm is less than eps, the resolution can't be done. exception dimensionerror is raised if the row number of b is different from the a row number.

        Parameters
        ----------
        A: math_Matrix
        B: math_Matrix
        lowerArow: int
        upperArow: int
        lowerAcol: int
        upperAcol: int
        EPS: float,optional
        	default value is 1.0e-20

        Returns
        -------
        None
        Given an input matrix a with n>= m, given an input vector b this constructor performs the least square resolution of the set of linear equations a.x = b. if a column norm is less than eps, the resolution can't be done. exception dimensionerror is raised if the length of b is different from the a row number.

        Parameters
        ----------
        A: math_Matrix
        B: math_Vector
        EPS: float,optional
        	default value is 1.0e-20

        Returns
        -------
        None

        """
        _math.math_Householder_swiginit(self, _math.new_math_Householder(*args))

    def AllValues(self, *args):
        r"""
        Returns the matrix sol of all the solutions of the system a.x = b. exception notdone is raised is the resolution has not be done.

        Returns
        -------
        math_Matrix

        """
        return _math.math_Householder_AllValues(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_Householder self) -> std::string"""
        return _math.math_Householder_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_Householder_IsDone(self, *args)

    def Value(self, *args):
        r"""
        Given the integer index, this routine returns the corresponding least square solution sol. exception notdone is raised if the resolution has not be done. exception outofrange is raised if index <=0 or index is more than the number of columns of b.

        Parameters
        ----------
        sol: math_Vector
        Index: int,optional
        	default value is 1

        Returns
        -------
        None

        """
        return _math.math_Householder_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_Householder

# Register math_Householder in _math:
_math.math_Householder_swigregister(math_Householder)
class math_IntegerVector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs an integervector in the range [lower..upper].

        Parameters
        ----------
        theFirst: int
        theLast: int

        Returns
        -------
        None
        Constructs an integervector in the range [lower..upper] with all the elements set to theinitialvalue.

        Parameters
        ----------
        theFirst: int
        theLast: int
        theInitialValue: int

        Returns
        -------
        None
        Constructs an integervector in the range [lower..upper] which share the 'c array' thetab.

        Parameters
        ----------
        theTab: int *
        theFirst: int
        theLast: int

        Returns
        -------
        None
        Constructs a copy for initialization. an exception is raised if the lengths of the integervectors are different.

        Parameters
        ----------
        theOther: math_IntegerVector

        Returns
        -------
        None

        """
        _math.math_IntegerVector_swiginit(self, _math.new_math_IntegerVector(*args))

    def Add(self, *args):
        r"""
        Adds the integervector 'theright' to an integervector. an exception is raised if the integervectors have not the same length. an exception is raised if the lengths are not equal.

        Parameters
        ----------
        theRight: math_IntegerVector

        Returns
        -------
        None
        Sets an integervector to the sum of the integervector 'theleft' and the integervector 'theright'. an exception is raised if the lengths are different.

        Parameters
        ----------
        theLeft: math_IntegerVector
        theRight: math_IntegerVector

        Returns
        -------
        None

        """
        return _math.math_IntegerVector_Add(self, *args)

    def Added(self, *args):
        r"""
        Adds the integervector 'theright' to an integervector. an exception is raised if the integervectors have not the same length. an exception is raised if the lengths are not equal.

        Parameters
        ----------
        theRight: math_IntegerVector

        Returns
        -------
        math_IntegerVector

        """
        return _math.math_IntegerVector_Added(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_IntegerVector self) -> std::string"""
        return _math.math_IntegerVector_DumpToString(self)

    def Init(self, *args):
        r"""
        Initialize an integervector with all the elements set to theinitialvalue.

        Parameters
        ----------
        theInitialValue: int

        Returns
        -------
        None

        """
        return _math.math_IntegerVector_Init(self, *args)

    def Initialized(self, *args):
        r"""
        Initialises an integervector by copying 'theother'. an exception is raised if the lengths are different.

        Parameters
        ----------
        theOther: math_IntegerVector

        Returns
        -------
        math_IntegerVector

        """
        return _math.math_IntegerVector_Initialized(self, *args)

    def Inverse(self, *args):
        r"""
        Returns the inverse integervector of an integervector.

        Returns
        -------
        math_IntegerVector

        """
        return _math.math_IntegerVector_Inverse(self, *args)

    def Invert(self, *args):
        r"""
        Inverses an integervector.

        Returns
        -------
        None

        """
        return _math.math_IntegerVector_Invert(self, *args)

    def Length(self, *args):
        r"""
        Returns the length of an integervector.

        Returns
        -------
        int

        """
        return _math.math_IntegerVector_Length(self, *args)

    def Lower(self, *args):
        r"""
        Returns the value of the lower index of an integervector.

        Returns
        -------
        int

        """
        return _math.math_IntegerVector_Lower(self, *args)

    def Max(self, *args):
        r"""
        Returns the value of the index of the maximum element of an integervector.

        Returns
        -------
        int

        """
        return _math.math_IntegerVector_Max(self, *args)

    def Min(self, *args):
        r"""
        Returns the value of the index of the minimum element of an integervector.

        Returns
        -------
        int

        """
        return _math.math_IntegerVector_Min(self, *args)

    def Multiplied(self, *args):
        r"""
        Returns the product of an integervector by an integer value.

        Parameters
        ----------
        theRight: int

        Returns
        -------
        math_IntegerVector
        Returns the inner product of 2 integervectors. an exception is raised if the lengths are not equal.

        Parameters
        ----------
        theRight: math_IntegerVector

        Returns
        -------
        int

        """
        return _math.math_IntegerVector_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""
        Returns the product of an integervector by an integer value.

        Parameters
        ----------
        theRight: int

        Returns
        -------
        None
        Returns the multiplication of an integer by an integervector.

        Parameters
        ----------
        theLeft: int
        theRight: math_IntegerVector

        Returns
        -------
        None

        """
        return _math.math_IntegerVector_Multiply(self, *args)

    def Norm(self, *args):
        r"""
        Returns the value of the norm of an integervector.

        Returns
        -------
        float

        """
        return _math.math_IntegerVector_Norm(self, *args)

    def Norm2(self, *args):
        r"""
        Returns the value of the square of the norm of an integervector.

        Returns
        -------
        float

        """
        return _math.math_IntegerVector_Norm2(self, *args)

    def Opposite(self, *args):
        r"""
        Returns the opposite of an integervector.

        Returns
        -------
        math_IntegerVector

        """
        return _math.math_IntegerVector_Opposite(self, *args)

    def Set(self, *args):
        r"""
        Sets an integervector from 'thei1' to 'thei2' to the integervector 'thev'; an exception is raised if 'thei1' is less than 'lowerindex' or 'thei2' is greater than 'upperindex' or 'thei1' is greater than 'thei2'. an exception is raised if 'thei2-thei1+1' is different from the length of 'thev'.

        Parameters
        ----------
        theI1: int
        theI2: int
        theV: math_IntegerVector

        Returns
        -------
        None

        """
        return _math.math_IntegerVector_Set(self, *args)

    def Slice(self, *args):
        r"""
        Slices the values of the integervector between 'thei1' and 'thei2': example: [2, 1, 2, 3, 4, 5] becomes [2, 4, 3, 2, 1, 5] between 2 and 5. an exception is raised if 'thei1' is less than 'lowerindex' or 'thei2' is greater than 'upperindex'.

        Parameters
        ----------
        theI1: int
        theI2: int

        Returns
        -------
        math_IntegerVector

        """
        return _math.math_IntegerVector_Slice(self, *args)

    def Subtract(self, *args):
        r"""
        Sets an integervector to the substraction of 'theright' from 'theleft'. an exception is raised if the integervectors have not the same length.

        Parameters
        ----------
        theLeft: math_IntegerVector
        theRight: math_IntegerVector

        Returns
        -------
        None
        Returns the subtraction of 'theright' from 'me'. an exception is raised if the integervectors have not the same length.

        Parameters
        ----------
        theRight: math_IntegerVector

        Returns
        -------
        None

        """
        return _math.math_IntegerVector_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""
        Returns the subtraction of 'theright' from 'me'. an exception is raised if the integervectors have not the same length.

        Parameters
        ----------
        theRight: math_IntegerVector

        Returns
        -------
        math_IntegerVector

        """
        return _math.math_IntegerVector_Subtracted(self, *args)

    def TMultiplied(self, *args):
        r"""
        Returns the product of a vector and a real value.

        Parameters
        ----------
        theRight: int

        Returns
        -------
        math_IntegerVector

        """
        return _math.math_IntegerVector_TMultiplied(self, *args)

    def Upper(self, *args):
        r"""
        Returns the value of the upper index of an integervector.

        Returns
        -------
        int

        """
        return _math.math_IntegerVector_Upper(self, *args)

    def Value(self, *args):
        r"""
        Accesses the value of index thenum of an integervector.

        Parameters
        ----------
        theNum: int

        Returns
        -------
        int

        """
        return _math.math_IntegerVector_Value(self, *args)

    def GetValue(self, theNum):
        r"""GetValue(math_IntegerVector self, Standard_Integer const theNum) -> Standard_Integer"""
        return _math.math_IntegerVector_GetValue(self, theNum)

    def SetValue(self, theNum, value):
        r"""SetValue(math_IntegerVector self, Standard_Integer const theNum, Standard_Integer value)"""
        return _math.math_IntegerVector_SetValue(self, theNum, value)

    def __mul__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        theRight: int

        Returns
        -------
        math_IntegerVector
        No available documentation.

        Parameters
        ----------
        theRight: math_IntegerVector

        Returns
        -------
        int

        """
        return _math.math_IntegerVector___mul__(self, *args)

    def __imul_wrapper__(self, other):
        r"""__imul_wrapper__(math_IntegerVector self, Standard_Integer const other)"""
        return _math.math_IntegerVector___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        theRight: math_IntegerVector

        Returns
        -------
        math_IntegerVector

        """
        return _math.math_IntegerVector___add__(self, *args)

    def __iadd_wrapper__(self, other):
        r"""__iadd_wrapper__(math_IntegerVector self, math_IntegerVector other)"""
        return _math.math_IntegerVector___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __neg__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        math_IntegerVector

        """
        return _math.math_IntegerVector___neg__(self, *args)

    def __sub__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        theRight: math_IntegerVector

        Returns
        -------
        math_IntegerVector

        """
        return _math.math_IntegerVector___sub__(self, *args)

    def __isub_wrapper__(self, other):
        r"""__isub_wrapper__(math_IntegerVector self, math_IntegerVector other)"""
        return _math.math_IntegerVector___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_IntegerVector

# Register math_IntegerVector in _math:
_math.math_IntegerVector_swigregister(math_IntegerVector)
class math_Jacobi(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Given a real n x n matrix a, this constructor computes all its eigenvalues and eigenvectors using the jacobi method. the exception notsquare is raised if the matrix is not square. no verification that the matrix a is really symmetric is done.

        Parameters
        ----------
        A: math_Matrix

        Returns
        -------
        None

        """
        _math.math_Jacobi_swiginit(self, _math.new_math_Jacobi(*args))

    def DumpToString(self):
        r"""DumpToString(math_Jacobi self) -> std::string"""
        return _math.math_Jacobi_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_Jacobi_IsDone(self, *args)

    def Value(self, *args):
        r"""
        Returns the eigenvalue number num. eigenvalues are in the range (1..n). exception notdone is raised if calculation is not done successfully.

        Parameters
        ----------
        Num: int

        Returns
        -------
        float

        """
        return _math.math_Jacobi_Value(self, *args)

    def Values(self, *args):
        r"""
        Returns the eigenvalues vector. exception notdone is raised if calculation is not done successfully.

        Returns
        -------
        math_Vector

        """
        return _math.math_Jacobi_Values(self, *args)

    def Vector(self, *args):
        r"""
        Returns the eigenvector v of number num. eigenvectors are in the range (1..n). exception notdone is raised if calculation is not done successfully.

        Parameters
        ----------
        Num: int
        V: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Jacobi_Vector(self, *args)

    def Vectors(self, *args):
        r"""
        Returns the eigenvectors matrix. exception notdone is raised if calculation is not done successfully.

        Returns
        -------
        math_Matrix

        """
        return _math.math_Jacobi_Vectors(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_Jacobi

# Register math_Jacobi in _math:
_math.math_Jacobi_swigregister(math_Jacobi)
class math_KronrodSingleIntegration(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        An empty constructor.

        Returns
        -------
        None
        Constructor. takes the function, the lower and upper bound values, the initial number of kronrod points.

        Parameters
        ----------
        theFunction: math_Function
        theLower: float
        theUpper: float
        theNbPnts: int

        Returns
        -------
        None
        Constructor. takes the function, the lower and upper bound values, the initial number of kronrod points, the tolerance value and the maximal number of iterations as parameters.

        Parameters
        ----------
        theFunction: math_Function
        theLower: float
        theUpper: float
        theNbPnts: int
        theTolerance: float
        theMaxNbIter: int

        Returns
        -------
        None

        """
        _math.math_KronrodSingleIntegration_swiginit(self, _math.new_math_KronrodSingleIntegration(*args))

    def AbsolutError(self, *args):
        r"""
        Returns the value of the relative error reached.

        Returns
        -------
        float

        """
        return _math.math_KronrodSingleIntegration_AbsolutError(self, *args)

    def ErrorReached(self, *args):
        r"""
        Returns the value of the relative error reached.

        Returns
        -------
        float

        """
        return _math.math_KronrodSingleIntegration_ErrorReached(self, *args)

    @staticmethod
    def GKRule(*args):
        r"""
        No available documentation.

        Parameters
        ----------
        theFunction: math_Function
        theLower: float
        theUpper: float
        theGaussP: math_Vector
        theGaussW: math_Vector
        theKronrodP: math_Vector
        theKronrodW: math_Vector

        Returns
        -------
        theValue: float
        theError: float

        """
        return _math.math_KronrodSingleIntegration_GKRule(*args)

    def IsDone(self, *args):
        r"""
        Returns standard_true if computation is performed successfully.

        Returns
        -------
        bool

        """
        return _math.math_KronrodSingleIntegration_IsDone(self, *args)

    def NbIterReached(self, *args):
        r"""
        Returns the number of iterations that were made to compute result.

        Returns
        -------
        int

        """
        return _math.math_KronrodSingleIntegration_NbIterReached(self, *args)

    def OrderReached(self, *args):
        r"""
        Returns the number of kronrod points for which the result is computed.

        Returns
        -------
        int

        """
        return _math.math_KronrodSingleIntegration_OrderReached(self, *args)

    def Perform(self, *args):
        r"""
        Computation of the integral. takes the function, the lower and upper bound values, the initial number of kronrod points, the relative tolerance value and the maximal number of iterations as parameters. thenbpnts should be odd and greater then or equal to 3.

        Parameters
        ----------
        theFunction: math_Function
        theLower: float
        theUpper: float
        theNbPnts: int

        Returns
        -------
        None
        Computation of the integral. takes the function, the lower and upper bound values, the initial number of kronrod points, the relative tolerance value and the maximal number of iterations as parameters. thenbpnts should be odd and greater then or equal to 3. note that thetolerance is relative, i.e. the criterion of solution reaching is: abs(kronrod - gauss)/abs(kronrod) < thetolerance. thetolerance should be positive.

        Parameters
        ----------
        theFunction: math_Function
        theLower: float
        theUpper: float
        theNbPnts: int
        theTolerance: float
        theMaxNbIter: int

        Returns
        -------
        None

        """
        return _math.math_KronrodSingleIntegration_Perform(self, *args)

    def Value(self, *args):
        r"""
        Returns the value of the integral.

        Returns
        -------
        float

        """
        return _math.math_KronrodSingleIntegration_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_KronrodSingleIntegration

# Register math_KronrodSingleIntegration in _math:
_math.math_KronrodSingleIntegration_swigregister(math_KronrodSingleIntegration)
class math_Matrix(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a non-initialized matrix of range [lowerrow..upperrow, lowercol..uppercol] for the constructed matrix: - lowerrow and upperrow are the indexes of the lower and upper bounds of a row, and - lowercol and uppercol are the indexes of the lower and upper bounds of a column.

        Parameters
        ----------
        LowerRow: int
        UpperRow: int
        LowerCol: int
        UpperCol: int

        Returns
        -------
        None
        Constructs a non-initialized matrix of range [lowerrow..upperrow, lowercol..uppercol] whose values are all initialized with the value initialvalue.

        Parameters
        ----------
        LowerRow: int
        UpperRow: int
        LowerCol: int
        UpperCol: int
        InitialValue: float

        Returns
        -------
        None
        Constructs a matrix of range [lowerrow..upperrow, lowercol..uppercol] sharing data with a 'c array' pointed by tab.

        Parameters
        ----------
        Tab: Standard_Address
        LowerRow: int
        UpperRow: int
        LowerCol: int
        UpperCol: int

        Returns
        -------
        None
        Constructs a matrix for copy in initialization. an exception is raised if the matrixes have not the same dimensions.

        Parameters
        ----------
        Other: math_Matrix

        Returns
        -------
        None

        """
        _math.math_Matrix_swiginit(self, _math.new_math_Matrix(*args))

    def Add(self, *args):
        r"""
        Adds the matrix <right> to a matrix. an exception is raised if the dimensions are different. warning in order to save time when copying matrices, it is preferable to use operator += or the function add whenever possible.

        Parameters
        ----------
        Right: math_Matrix

        Returns
        -------
        None
        Sets a matrix to the addition of <left> and <right>. an exception is raised if the dimensions are different.

        Parameters
        ----------
        Left: math_Matrix
        Right: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_Matrix_Add(self, *args)

    def Added(self, *args):
        r"""
        Adds the matrix <right> to a matrix. an exception is raised if the dimensions are different.

        Parameters
        ----------
        Right: math_Matrix

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix_Added(self, *args)

    def Col(self, *args):
        r"""
        Returns the column of index <col> of a matrix.

        Parameters
        ----------
        Col: int

        Returns
        -------
        math_Vector

        """
        return _math.math_Matrix_Col(self, *args)

    def ColNumber(self, *args):
        r"""
        Returns the number of rows of this matrix. note that for a matrix a you always have the following relations: - a.rownumber() = a.upperrow() - a.lowerrow() + 1 - a.colnumber() = a.uppercol() - a.lowercol() + 1 - the length of a row of a is equal to the number of columns of a, - the length of a column of a is equal to the number of rows of a.returns the row range of a matrix.

        Returns
        -------
        int

        """
        return _math.math_Matrix_ColNumber(self, *args)

    def Determinant(self, *args):
        r"""
        Computes the determinant of a matrix. an exception is raised if the matrix is not a square matrix.

        Returns
        -------
        float

        """
        return _math.math_Matrix_Determinant(self, *args)

    def Divide(self, *args):
        r"""
        Divides all the elements of a matrix by the value <right>. an exception is raised if <right> = 0.

        Parameters
        ----------
        Right: float

        Returns
        -------
        None

        """
        return _math.math_Matrix_Divide(self, *args)

    def Divided(self, *args):
        r"""
        Divides all the elements of a matrix by the value <right>. an exception is raised if <right> = 0.

        Parameters
        ----------
        Right: float

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix_Divided(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_Matrix self) -> std::string"""
        return _math.math_Matrix_DumpToString(self)

    def Init(self, *args):
        r"""
        Initialize all the elements of a matrix to initialvalue.

        Parameters
        ----------
        InitialValue: float

        Returns
        -------
        None

        """
        return _math.math_Matrix_Init(self, *args)

    def Initialized(self, *args):
        r"""
        Matrixes are copied through assignment. an exception is raised if the dimensions are different.

        Parameters
        ----------
        Other: math_Matrix

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix_Initialized(self, *args)

    def Inverse(self, *args):
        r"""
        Returns the inverse of a matrix. exception notsquare is raised if the matrix is not square. exception singularmatrix is raised if the matrix is singular.

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix_Inverse(self, *args)

    def Invert(self, *args):
        r"""
        Inverts a matrix using gauss algorithm. exception notsquare is raised if the matrix is not square. exception singularmatrix is raised if the matrix is singular.

        Returns
        -------
        None

        """
        return _math.math_Matrix_Invert(self, *args)

    def LowerCol(self, *args):
        r"""
        Returns the value of the lower index of the column range of a matrix.

        Returns
        -------
        int

        """
        return _math.math_Matrix_LowerCol(self, *args)

    def LowerRow(self, *args):
        r"""
        Returns the value of the lower index of the row range of a matrix.

        Returns
        -------
        int

        """
        return _math.math_Matrix_LowerRow(self, *args)

    def Multiplied(self, *args):
        r"""
        Multiplies all the elements of a matrix by the value <right>.

        Parameters
        ----------
        Right: float

        Returns
        -------
        math_Matrix
        Returns the product of 2 matrices. an exception is raised if the dimensions are different.

        Parameters
        ----------
        Right: math_Matrix

        Returns
        -------
        math_Matrix
        Returns the product of a matrix by a vector. an exception is raised if the dimensions are different.

        Parameters
        ----------
        Right: math_Vector

        Returns
        -------
        math_Vector

        """
        return _math.math_Matrix_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""
        Sets this matrix to the product of the matrix left, and the matrix right. example math_matrix a (1, 3, 1, 3); math_matrix b (1, 3, 1, 3); // a = ... , b = ... math_matrix c (1, 3, 1, 3); c.multiply(a, b); exceptions standard_dimensionerror if matrices are of incompatible dimensions, i.e. if: - the number of columns of matrix left, or the number of rows of matrix tleft is not equal to the number of rows of matrix right, or - the number of rows of matrix left, or the number of columns of matrix tleft is not equal to the number of rows of this matrix, or - the number of columns of matrix right is not equal to the number of columns of this matrix.

        Parameters
        ----------
        Right: float

        Returns
        -------
        None
        Computes a matrix as the product of 2 vectors. an exception is raised if the dimensions are different. <self> = <left> * <right>.

        Parameters
        ----------
        Left: math_Vector
        Right: math_Vector

        Returns
        -------
        None
        Computes a matrix as the product of 2 matrixes. an exception is raised if the dimensions are different.

        Parameters
        ----------
        Left: math_Matrix
        Right: math_Matrix

        Returns
        -------
        None
        Returns the product of 2 matrices. an exception is raised if the dimensions are different.

        Parameters
        ----------
        Right: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_Matrix_Multiply(self, *args)

    def Opposite(self, *args):
        r"""
        Returns the opposite of a matrix. an exception is raised if the dimensions are different.

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix_Opposite(self, *args)

    def Row(self, *args):
        r"""
        Returns the row of index row of a matrix.

        Parameters
        ----------
        Row: int

        Returns
        -------
        math_Vector

        """
        return _math.math_Matrix_Row(self, *args)

    def RowNumber(self, *args):
        r"""
        Returns the number of rows of this matrix. note that for a matrix a you always have the following relations: - a.rownumber() = a.upperrow() - a.lowerrow() + 1 - a.colnumber() = a.uppercol() - a.lowercol() + 1 - the length of a row of a is equal to the number of columns of a, - the length of a column of a is equal to the number of rows of a.returns the row range of a matrix.

        Returns
        -------
        int

        """
        return _math.math_Matrix_RowNumber(self, *args)

    def Set(self, *args):
        r"""
        Sets the values of this matrix, - from index i1 to index i2 on the row dimension, and - from index j1 to index j2 on the column dimension, to those of matrix m. exceptions standard_dimensionerror if: - i1 is less than the index of the lower row bound of this matrix, or - i2 is greater than the index of the upper row bound of this matrix, or - j1 is less than the index of the lower column bound of this matrix, or - j2 is greater than the index of the upper column bound of this matrix, or - i2 - i1 + 1 is not equal to the number of rows of matrix m, or - j2 - j1 + 1 is not equal to the number of columns of matrix m.

        Parameters
        ----------
        I1: int
        I2: int
        J1: int
        J2: int
        M: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_Matrix_Set(self, *args)

    def SetCol(self, *args):
        r"""
        Sets the column of index col of a matrix to the vector <v>. an exception is raised if the dimensions are different. an exception is raises if <col> is inferior to the lower column of the matrix or <col> is superior to the upper column.

        Parameters
        ----------
        Col: int
        V: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Matrix_SetCol(self, *args)

    def SetDiag(self, *args):
        r"""
        Sets the diagonal of a matrix to the value <value>. an exception is raised if the matrix is not square.

        Parameters
        ----------
        Value: float

        Returns
        -------
        None

        """
        return _math.math_Matrix_SetDiag(self, *args)

    def SetRow(self, *args):
        r"""
        Sets the row of index row of a matrix to the vector <v>. an exception is raised if the dimensions are different. an exception is raises if <row> is inferior to the lower row of the matrix or <row> is superior to the upper row.

        Parameters
        ----------
        Row: int
        V: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Matrix_SetRow(self, *args)

    def Subtract(self, *args):
        r"""
        Subtracts the matrix <right> from <self>. an exception is raised if the dimensions are different. warning in order to avoid time-consuming copying of matrices, it is preferable to use operator -= or the function subtract whenever possible.

        Parameters
        ----------
        Right: math_Matrix

        Returns
        -------
        None
        Sets a matrix to the subtraction of the matrix <right> from the matrix <left>. an exception is raised if the dimensions are different.

        Parameters
        ----------
        Left: math_Matrix
        Right: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_Matrix_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""
        Returns the result of the subtraction of <right> from <self>. an exception is raised if the dimensions are different.

        Parameters
        ----------
        Right: math_Matrix

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix_Subtracted(self, *args)

    def SwapCol(self, *args):
        r"""
        Swaps the columns of index <col1> and <col2>. an exception is raised if <col1> or <col2> is out of range.

        Parameters
        ----------
        Col1: int
        Col2: int

        Returns
        -------
        None

        """
        return _math.math_Matrix_SwapCol(self, *args)

    def SwapRow(self, *args):
        r"""
        Swaps the rows of index row1 and row2. an exception is raised if <row1> or <row2> is out of range.

        Parameters
        ----------
        Row1: int
        Row2: int

        Returns
        -------
        None

        """
        return _math.math_Matrix_SwapRow(self, *args)

    def TMultiplied(self, *args):
        r"""
        Sets this matrix to the product of the transposed matrix tleft, and the matrix right. example math_matrix a (1, 3, 1, 3); math_matrix b (1, 3, 1, 3); // a = ... , b = ... math_matrix c (1, 3, 1, 3); c.multiply(a, b); exceptions standard_dimensionerror if matrices are of incompatible dimensions, i.e. if: - the number of columns of matrix left, or the number of rows of matrix tleft is not equal to the number of rows of matrix right, or - the number of rows of matrix left, or the number of columns of matrix tleft is not equal to the number of rows of this matrix, or - the number of columns of matrix right is not equal to the number of columns of this matrix.

        Parameters
        ----------
        Right: float

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix_TMultiplied(self, *args)

    def TMultiply(self, *args):
        r"""
        Returns the product of the transpose of a matrix with the matrix <right>. an exception is raised if the dimensions are different.

        Parameters
        ----------
        Right: math_Matrix

        Returns
        -------
        math_Matrix
        Computes a matrix to the product of the transpose of the matrix <tleft> with the matrix <right>. an exception is raised if the dimensions are different.

        Parameters
        ----------
        TLeft: math_Matrix
        Right: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_Matrix_TMultiply(self, *args)

    def Transpose(self, *args):
        r"""
        Transposes a given matrix. an exception is raised if the matrix is not a square matrix.

        Returns
        -------
        None

        """
        return _math.math_Matrix_Transpose(self, *args)

    def Transposed(self, *args):
        r"""
        Teturns the transposed of a matrix. an exception is raised if the matrix is not a square matrix.

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix_Transposed(self, *args)

    def UpperCol(self, *args):
        r"""
        Returns the value of the upper index of the column range of a matrix.

        Returns
        -------
        int

        """
        return _math.math_Matrix_UpperCol(self, *args)

    def UpperRow(self, *args):
        r"""
        Returns the upper index of the row range of a matrix.

        Returns
        -------
        int

        """
        return _math.math_Matrix_UpperRow(self, *args)

    def GetValue(self, Row, Col):
        r"""GetValue(math_Matrix self, Standard_Integer const Row, Standard_Integer const Col) -> Standard_Real"""
        return _math.math_Matrix_GetValue(self, Row, Col)

    def SetValue(self, Row, Col, value):
        r"""SetValue(math_Matrix self, Standard_Integer const Row, Standard_Integer const Col, Standard_Real value)"""
        return _math.math_Matrix_SetValue(self, Row, Col, value)

    def __mul__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Right: float

        Returns
        -------
        math_Matrix
        No available documentation.

        Parameters
        ----------
        Right: math_Matrix

        Returns
        -------
        math_Matrix
        No available documentation.

        Parameters
        ----------
        Right: math_Vector

        Returns
        -------
        math_Vector

        """
        return _math.math_Matrix___mul__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __imul_wrapper__(self, *args):
        r"""
        __imul_wrapper__(math_Matrix self, Standard_Real const other)
        __imul_wrapper__(math_Matrix self, math_Matrix other)
        """
        return _math.math_Matrix___imul_wrapper__(self, *args)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Right: math_Matrix

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix___add__(self, *args)

    def __iadd_wrapper__(self, other):
        r"""__iadd_wrapper__(math_Matrix self, math_Matrix other)"""
        return _math.math_Matrix___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __sub__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        Right: math_Matrix

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix___sub__(self, *args)

    def __neg__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        math_Matrix

        """
        return _math.math_Matrix___neg__(self, *args)

    def __isub_wrapper__(self, other):
        r"""__isub_wrapper__(math_Matrix self, math_Matrix other)"""
        return _math.math_Matrix___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _math.math_Matrix___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other):
        r"""__itruediv_wrapper__(math_Matrix self, Standard_Real const other)"""
        return _math.math_Matrix___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_Matrix

# Register math_Matrix in _math:
_math.math_Matrix_swigregister(math_Matrix)
class math_MultipleVarFunction(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetStateNumber(self, *args):
        r"""
        Return the state of the function corresponding to the latestt call of any methods associated to the function. this function is called by each of the algorithms described later which define the function integer algorithm::statenumber(). the algorithm has the responsibility to call this function when it has found a solution (i.e. a root or a minimum) and has to maintain the association between the solution found and this statenumber. byu default, this method returns 0 (which means for the algorithm: no state has been saved). it is the responsibility of the programmer to decide if he needs to save the current state of the function and to return an integer that allows retrieval of the state.

        Returns
        -------
        int

        """
        return _math.math_MultipleVarFunction_GetStateNumber(self, *args)

    def NbVariables(self, *args):
        r"""
        Returns the number of variables of the function.

        Returns
        -------
        int

        """
        return _math.math_MultipleVarFunction_NbVariables(self, *args)

    def Value(self, *args):
        r"""
        Computes the values of the functions <f> for the variable <x>. returns true if the computation was done successfully, otherwise false.

        Parameters
        ----------
        X: math_Vector

        Returns
        -------
        F: float

        """
        return _math.math_MultipleVarFunction_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_MultipleVarFunction

# Register math_MultipleVarFunction in _math:
_math.math_MultipleVarFunction_swigregister(math_MultipleVarFunction)
class math_NewtonFunctionRoot(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The newton method is done to find the root of the function f from the initial guess guess. the tolerance required on the root is given by tolerance. the solution is found when : abs(xi - xi-1) <= epsx and abs(f(xi))<= epsf the maximum number of iterations allowed is given by nbiterations.

        Parameters
        ----------
        F: math_FunctionWithDerivative
        Guess: float
        EpsX: float
        EpsF: float
        NbIterations: int,optional
        	default value is 100

        Returns
        -------
        None
        The newton method is done to find the root of the function f from the initial guess guess. the solution must be inside the interval [a, b]. the tolerance required on the root is given by tolerance. the solution is found when : abs(xi - xi-1) <= epsx and abs(f(xi))<= epsf the maximum number of iterations allowed is given by nbiterations.

        Parameters
        ----------
        F: math_FunctionWithDerivative
        Guess: float
        EpsX: float
        EpsF: float
        A: float
        B: float
        NbIterations: int,optional
        	default value is 100

        Returns
        -------
        None
        Is used in a sub-class to initialize correctly all the fields of this class.

        Parameters
        ----------
        A: float
        B: float
        EpsX: float
        EpsF: float
        NbIterations: int,optional
        	default value is 100

        Returns
        -------
        None

        """
        _math.math_NewtonFunctionRoot_swiginit(self, _math.new_math_NewtonFunctionRoot(*args))

    def Derivative(self, *args):
        r"""
        Returns the value of the derivative at the root. exception notdone is raised if the root was not found.

        Returns
        -------
        float

        """
        return _math.math_NewtonFunctionRoot_Derivative(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_NewtonFunctionRoot self) -> std::string"""
        return _math.math_NewtonFunctionRoot_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_NewtonFunctionRoot_IsDone(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done on the computation of the root. exception notdone is raised if the root was not found.

        Returns
        -------
        int

        """
        return _math.math_NewtonFunctionRoot_NbIterations(self, *args)

    def Perform(self, *args):
        r"""
        Is used internally by the constructors.

        Parameters
        ----------
        F: math_FunctionWithDerivative
        Guess: float

        Returns
        -------
        None

        """
        return _math.math_NewtonFunctionRoot_Perform(self, *args)

    def Root(self, *args):
        r"""
        Returns the value of the root of function <f>. exception notdone is raised if the root was not found.

        Returns
        -------
        float

        """
        return _math.math_NewtonFunctionRoot_Root(self, *args)

    def Value(self, *args):
        r"""
        Returns the value of the function at the root. exception notdone is raised if the root was not found.

        Returns
        -------
        float

        """
        return _math.math_NewtonFunctionRoot_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_NewtonFunctionRoot

# Register math_NewtonFunctionRoot in _math:
_math.math_NewtonFunctionRoot_swigregister(math_NewtonFunctionRoot)
class math_NewtonFunctionSetRoot(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Initialize correctly all the fields of this class. the range (1, f.nbvariables()) must be especially respected for all vectors and matrix declarations.

        Parameters
        ----------
        theFunction: math_FunctionSetWithDerivatives
        theXTolerance: math_Vector
        theFTolerance: float
        tehNbIterations: int,optional
        	default value is 100

        Returns
        -------
        None
        This constructor should be used in a sub-class to initialize correctly all the fields of this class. the range (1, f.nbvariables()) must be especially respected for all vectors and matrix declarations. the method settolerance must be called before performing the algorithm.

        Parameters
        ----------
        theFunction: math_FunctionSetWithDerivatives
        theFTolerance: float
        theNbIterations: int,optional
        	default value is 100

        Returns
        -------
        None

        """
        _math.math_NewtonFunctionSetRoot_swiginit(self, _math.new_math_NewtonFunctionSetRoot(*args))

    def Derivative(self, *args):
        r"""
        Returns the matrix value of the derivative at the root. exception notdone is raised if the root was not found.

        Returns
        -------
        math_Matrix
        Outputs the matrix value of the derivative at the root in der. exception notdone is raised if the root was not found. exception dimensionerror is raised if the range of der is not equal to the range of the startingpoint.

        Parameters
        ----------
        Der: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_NewtonFunctionSetRoot_Derivative(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_NewtonFunctionSetRoot self) -> std::string"""
        return _math.math_NewtonFunctionSetRoot_DumpToString(self)

    def FunctionSetErrors(self, *args):
        r"""
        Returns the vector value of the error done on the functions at the root. exception notdone is raised if the root was not found.

        Returns
        -------
        math_Vector
        Outputs the vector value of the error done on the functions at the root in err. exception notdone is raised if the root was not found. exception dimensionerror is raised if the range of err is not equal to the range of the startingpoint.

        Parameters
        ----------
        Err: math_Vector

        Returns
        -------
        None

        """
        return _math.math_NewtonFunctionSetRoot_FunctionSetErrors(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_NewtonFunctionSetRoot_IsDone(self, *args)

    def IsSolutionReached(self, *args):
        r"""
        This method is called at the end of each iteration to check if the solution is found. vectors deltax, fvalues and jacobian matrix are consistent with the possible solution vector sol and can be inspected to decide whether the solution is reached or not.

        Parameters
        ----------
        F: math_FunctionSetWithDerivatives

        Returns
        -------
        bool

        """
        return _math.math_NewtonFunctionSetRoot_IsSolutionReached(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done during the computation of the root. exception notdone is raised if the root was not found.

        Returns
        -------
        int

        """
        return _math.math_NewtonFunctionSetRoot_NbIterations(self, *args)

    def Perform(self, *args):
        r"""
        The newton method is done to improve the root of the function from the initial guess point. the solution is found when: abs(xj - xj-1)(i) <= xtol(i) and abs(fi) <= ftol for all i;.

        Parameters
        ----------
        theFunction: math_FunctionSetWithDerivatives
        theStartingPoint: math_Vector

        Returns
        -------
        None
        The newton method is done to improve the root of the function from the initial guess point. bounds may be given, to constrain the solution. the solution is found when: abs(xj - xj-1)(i) <= xtol(i) and abs(fi) <= ftol for all i;.

        Parameters
        ----------
        theFunction: math_FunctionSetWithDerivatives
        theStartingPoint: math_Vector
        theInfBound: math_Vector
        theSupBound: math_Vector

        Returns
        -------
        None

        """
        return _math.math_NewtonFunctionSetRoot_Perform(self, *args)

    def Root(self, *args):
        r"""
        Returns the value of the root of function f. exceptions stdfail_notdone if the algorithm fails (and isdone returns false).

        Returns
        -------
        math_Vector
        Outputs the root vector in root. exception notdone is raised if the root was not found. exception dimensionerror is raised if the range of root is not equal to the range of the startingpoint.

        Parameters
        ----------
        Root: math_Vector

        Returns
        -------
        None

        """
        return _math.math_NewtonFunctionSetRoot_Root(self, *args)

    def SetTolerance(self, *args):
        r"""
        Initializes the tolerance values for the unknowns.

        Parameters
        ----------
        XTol: math_Vector

        Returns
        -------
        None

        """
        return _math.math_NewtonFunctionSetRoot_SetTolerance(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def StateNumber(self):
    	pass

    __swig_destroy__ = _math.delete_math_NewtonFunctionSetRoot

# Register math_NewtonFunctionSetRoot in _math:
_math.math_NewtonFunctionSetRoot_swigregister(math_NewtonFunctionSetRoot)
class math_NewtonMinimum(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        The tolerance required on the solution is given by tolerance. iteration are stopped if (!withsingularity) and h(f(xi)) is not definite positive (if the smaller eigenvalue of h < convexity) or isconverged() returns true for 2 successives iterations. warning: this constructor does not perform computation.

        Parameters
        ----------
        theFunction: math_MultipleVarFunctionWithHessian
        theTolerance: float,optional
        	default value is Precision::Confusion()
        theNbIterations: int,optional
        	default value is 40
        theConvexity: float,optional
        	default value is 1.0e-6
        theWithSingularity: bool,optional
        	default value is Standard_True

        Returns
        -------
        None

        """
        _math.math_NewtonMinimum_swiginit(self, _math.new_math_NewtonMinimum(*args))

    def DumpToString(self):
        r"""DumpToString(math_NewtonMinimum self) -> std::string"""
        return _math.math_NewtonMinimum_DumpToString(self)

    def GetStatus(self, *args):
        r"""
        Returns the status of computation. the exception notdone is raised if an error has occurred.

        Returns
        -------
        math_Status

        """
        return _math.math_NewtonMinimum_GetStatus(self, *args)

    def Gradient(self, *args):
        r"""
        Returns the gradient vector at the minimum. exception notdone is raised if an error has occurred. the minimum was not found.

        Returns
        -------
        math_Vector
        Outputs the gradient vector at the minimum in grad. exception notdone is raised if the minimum was not found. exception dimensionerror is raised if the range of grad is not equal to the range of the startingpoint.

        Parameters
        ----------
        Grad: math_Vector

        Returns
        -------
        None

        """
        return _math.math_NewtonMinimum_Gradient(self, *args)

    def IsConverged(self, *args):
        r"""
        This method is called at the end of each iteration to check the convergence: || xi+1 - xi || < tolerance or || f(xi+1) - f(xi)|| < tolerance * || f(xi) || it can be redefined in a sub-class to implement a specific test.

        Returns
        -------
        bool

        """
        return _math.math_NewtonMinimum_IsConverged(self, *args)

    def IsDone(self, *args):
        r"""
        Tests if an error has occurred.

        Returns
        -------
        bool

        """
        return _math.math_NewtonMinimum_IsDone(self, *args)

    def Location(self, *args):
        r"""
        Returns the location vector of the minimum. exception notdone is raised if an error has occurred.

        Returns
        -------
        math_Vector
        Outputs the location vector of the minimum in loc. exception notdone is raised if an error has occurred. exception dimensionerror is raised if the range of loc is not equal to the range of the startingpoint.

        Parameters
        ----------
        Loc: math_Vector

        Returns
        -------
        None

        """
        return _math.math_NewtonMinimum_Location(self, *args)

    def Minimum(self, *args):
        r"""
        Returns the value of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_NewtonMinimum_Minimum(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done in the calculation of the minimum. the exception notdone is raised if an error has occurred.

        Returns
        -------
        int

        """
        return _math.math_NewtonMinimum_NbIterations(self, *args)

    def Perform(self, *args):
        r"""
        Search the solution.

        Parameters
        ----------
        theFunction: math_MultipleVarFunctionWithHessian
        theStartingPoint: math_Vector

        Returns
        -------
        None

        """
        return _math.math_NewtonMinimum_Perform(self, *args)

    def SetBoundary(self, *args):
        r"""
        Set boundaries.

        Parameters
        ----------
        theLeftBorder: math_Vector
        theRightBorder: math_Vector

        Returns
        -------
        None

        """
        return _math.math_NewtonMinimum_SetBoundary(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def IsConvex(self):
    	pass

    __swig_destroy__ = _math.delete_math_NewtonMinimum

# Register math_NewtonMinimum in _math:
_math.math_NewtonMinimum_swigregister(math_NewtonMinimum)
class math_PSO(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        /** * constructor. * * @param thefunc defines the objective function. it should exist during all lifetime of class instance. * @param thelowborder defines lower border of search space. * @param theuppborder defines upper border of search space. * @param thesteps defines steps of regular grid, used for particle generation. this parameter used to define stop condition (terminalvelocity). * @param thenbparticles defines number of particles. * @param thenbiter defines maximum number of iterations. */.

        Parameters
        ----------
        theFunc: math_MultipleVarFunction *
        theLowBorder: math_Vector
        theUppBorder: math_Vector
        theSteps: math_Vector
        theNbParticles: int,optional
        	default value is 32
        theNbIter: int,optional
        	default value is 100

        Returns
        -------
        None

        """
        _math.math_PSO_swiginit(self, _math.new_math_PSO(*args))

    def Perform(self, *args):
        r"""
        Perform computations, particles array is constructed inside of this function.

        Parameters
        ----------
        theSteps: math_Vector
        theOutPnt: math_Vector
        theNbIter: int,optional
        	default value is 100

        Returns
        -------
        theValue: float
        Perform computations with given particles array.

        Parameters
        ----------
        theParticles: math_PSOParticlesPool
        theNbParticles: int
        theOutPnt: math_Vector
        theNbIter: int,optional
        	default value is 100

        Returns
        -------
        theValue: float

        """
        return _math.math_PSO_Perform(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_PSO

# Register math_PSO in _math:
_math.math_PSO_swigregister(math_PSO)
class math_PSOParticlesPool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        theParticlesCount: int
        theDimensionCount: int

        Returns
        -------
        None

        """
        _math.math_PSOParticlesPool_swiginit(self, _math.new_math_PSOParticlesPool(*args))

    def GetBestParticle(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        PSO_Particle *

        """
        return _math.math_PSOParticlesPool_GetBestParticle(self, *args)

    def GetParticle(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        theIdx: int

        Returns
        -------
        PSO_Particle *

        """
        return _math.math_PSOParticlesPool_GetParticle(self, *args)

    def GetWorstParticle(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        PSO_Particle *

        """
        return _math.math_PSOParticlesPool_GetWorstParticle(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_PSOParticlesPool

# Register math_PSOParticlesPool in _math:
_math.math_PSOParticlesPool_swigregister(math_PSOParticlesPool)
class math_Powell(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor. initialize new entity.

        Parameters
        ----------
        theFunction: math_MultipleVarFunction
        theTolerance: float
        theNbIterations: int,optional
        	default value is 200
        theZEPS: float,optional
        	default value is 1.0e-12

        Returns
        -------
        None

        """
        _math.math_Powell_swiginit(self, _math.new_math_Powell(*args))

    def DumpToString(self):
        r"""DumpToString(math_Powell self) -> std::string"""
        return _math.math_Powell_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_Powell_IsDone(self, *args)

    def IsSolutionReached(self, *args):
        r"""
        Solution f = fi is found when: 2.0 * abs(fi - fi-1) <= tolerance * (abs(fi) + abs(fi-1)) + zeps. the maximum number of iterations allowed is given by nbiterations.

        Parameters
        ----------
        theFunction: math_MultipleVarFunction

        Returns
        -------
        bool

        """
        return _math.math_Powell_IsSolutionReached(self, *args)

    def Location(self, *args):
        r"""
        Returns the location vector of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        math_Vector
        Outputs the location vector of the minimum in loc. exception notdone is raised if the minimum was not found. exception dimensionerror is raised if the range of loc is not equal to the range of the startingpoint.

        Parameters
        ----------
        Loc: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Powell_Location(self, *args)

    def Minimum(self, *args):
        r"""
        Returns the value of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        float

        """
        return _math.math_Powell_Minimum(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done during the computation of the minimum. exception notdone is raised if the minimum was not found.

        Returns
        -------
        int

        """
        return _math.math_Powell_NbIterations(self, *args)

    def Perform(self, *args):
        r"""
        Computes powell minimization on the function f given thestartingpoint, and an initial matrix thestartingdirection whose columns contain the initial set of directions. the solution f = fi is found when: 2.0 * abs(fi - fi-1) =< tolerance * (abs(fi) + abs(fi-1) + zeps).

        Parameters
        ----------
        theFunction: math_MultipleVarFunction
        theStartingPoint: math_Vector
        theStartingDirections: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_Powell_Perform(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_Powell

# Register math_Powell in _math:
_math.math_Powell_swigregister(math_Powell)
class math_SVD(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Given as input an n x m matrix a with n < m, n = m or n > m this constructor performs the singular value decomposition.

        Parameters
        ----------
        A: math_Matrix

        Returns
        -------
        None

        """
        _math.math_SVD_swiginit(self, _math.new_math_SVD(*args))

    def DumpToString(self):
        r"""DumpToString(math_SVD self) -> std::string"""
        return _math.math_SVD_DumpToString(self)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_SVD_IsDone(self, *args)

    def PseudoInverse(self, *args):
        r"""
        Computes the inverse inv of matrix a such as a * inverse = identity. exceptions stdfail_notdone if the algorithm fails (and isdone returns false). standard_dimensionerror if the ranges of inv are compatible with the ranges of a.

        Parameters
        ----------
        Inv: math_Matrix
        Eps: float,optional
        	default value is 1.0e-6

        Returns
        -------
        None

        """
        return _math.math_SVD_PseudoInverse(self, *args)

    def Solve(self, *args):
        r"""
        Given the input vector b this routine solves the set of linear equations a . x = b. exception notdone is raised if the decomposition of a was not done successfully. exception dimensionerror is raised if the range of b is not equal to the rowrange of a. exception dimensionerror is raised if the range of x is not equal to the colrange of a.

        Parameters
        ----------
        B: math_Vector
        X: math_Vector
        Eps: float,optional
        	default value is 1.0e-6

        Returns
        -------
        None

        """
        return _math.math_SVD_Solve(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_SVD

# Register math_SVD in _math:
_math.math_SVD_swigregister(math_SVD)
class math_TrigonometricFunctionRoots(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Given coefficients a, b, c, d , e, this constructor performs the resolution of the equation above. the solutions must be contained in [infbound, supbound]. infbound and supbound can be set by default to 0 and 2*pi.

        Parameters
        ----------
        A: float
        B: float
        C: float
        D: float
        E: float
        InfBound: float
        SupBound: float

        Returns
        -------
        None
        Given the two coefficients d and e, it performs the resolution of d*sin(x) + e = 0. the solutions must be contained in [infbound, supbound]. infbound and supbound can be set by default to 0 and 2*pi.

        Parameters
        ----------
        D: float
        E: float
        InfBound: float
        SupBound: float

        Returns
        -------
        None
        Given the three coefficients c, d and e, it performs the resolution of c*cos(x) + d*sin(x) + e = 0. the solutions must be contained in [infbound, supbound]. infbound and supbound can be set by default to 0 and 2*pi.

        Parameters
        ----------
        C: float
        D: float
        E: float
        InfBound: float
        SupBound: float

        Returns
        -------
        None

        """
        _math.math_TrigonometricFunctionRoots_swiginit(self, _math.new_math_TrigonometricFunctionRoots(*args))

    def DumpToString(self):
        r"""DumpToString(math_TrigonometricFunctionRoots self) -> std::string"""
        return _math.math_TrigonometricFunctionRoots_DumpToString(self)

    def InfiniteRoots(self, *args):
        r"""
        Returns true if there is an infinity of roots, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_TrigonometricFunctionRoots_InfiniteRoots(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_TrigonometricFunctionRoots_IsDone(self, *args)

    def NbSolutions(self, *args):
        r"""
        Returns the number of solutions found. an exception is raised if notdone. an exception is raised if there is an infinity of solutions.

        Returns
        -------
        int

        """
        return _math.math_TrigonometricFunctionRoots_NbSolutions(self, *args)

    def Value(self, *args):
        r"""
        Returns the solution of range index. an exception is raised if notdone. an exception is raised if index>nbsolutions. an exception is raised if there is an infinity of solutions.

        Parameters
        ----------
        Index: int

        Returns
        -------
        float

        """
        return _math.math_TrigonometricFunctionRoots_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_TrigonometricFunctionRoots

# Register math_TrigonometricFunctionRoots in _math:
_math.math_TrigonometricFunctionRoots_swigregister(math_TrigonometricFunctionRoots)
class math_Uzawa(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Given an input matrix cont, two input vectors secont and startingpoint, it solves cont*x = secont (only = equations) with a minimization of norme(x-x0). the maximum iterations number allowed is fixed to nbiterations. the tolerance epslic is fixed for the dual variable convergence. the tolerance epslix is used for the convergence of x. exception constructionerror is raised if the line number of cont is different from the length of secont.

        Parameters
        ----------
        Cont: math_Matrix
        Secont: math_Vector
        StartingPoint: math_Vector
        EpsLix: float,optional
        	default value is 1.0e-06
        EpsLic: float,optional
        	default value is 1.0e-06
        NbIterations: int,optional
        	default value is 500

        Returns
        -------
        None
        Given an input matrix cont, two input vectors secont and startingpoint, it solves cont*x = secont (the nce first equations are equal equations and the nci last equations are inequalities <) with a minimization of norme(x-x0). the maximum iterations number allowed is fixed to nbiterations. the tolerance epslic is fixed for the dual variable convergence. the tolerance epslix is used for the convergence of x. there are no conditions on nce and nci. exception constructionerror is raised if the line number of cont is different from the length of secont and from nce + nci.

        Parameters
        ----------
        Cont: math_Matrix
        Secont: math_Vector
        StartingPoint: math_Vector
        Nci: int
        Nce: int
        EpsLix: float,optional
        	default value is 1.0e-06
        EpsLic: float,optional
        	default value is 1.0e-06
        NbIterations: int,optional
        	default value is 500

        Returns
        -------
        None

        """
        _math.math_Uzawa_swiginit(self, _math.new_math_Uzawa(*args))

    def Duale(self, *args):
        r"""
        Returns the duale variables v of the systeme.

        Parameters
        ----------
        V: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Uzawa_Duale(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_Uzawa self) -> std::string"""
        return _math.math_Uzawa_DumpToString(self)

    def Error(self, *args):
        r"""
        Returns the difference between x solution and the startingpoint. an exception is raised if notdone.

        Returns
        -------
        math_Vector

        """
        return _math.math_Uzawa_Error(self, *args)

    def InitialError(self, *args):
        r"""
        Returns the initial error cont*startingpoint-secont. an exception is raised if notdone.

        Returns
        -------
        math_Vector

        """
        return _math.math_Uzawa_InitialError(self, *args)

    def InverseCont(self, *args):
        r"""
        Returns the inverse matrix of (c * transposed(c)). this result is needed for the computation of the gradient when approximating a curve.

        Returns
        -------
        math_Matrix

        """
        return _math.math_Uzawa_InverseCont(self, *args)

    def IsDone(self, *args):
        r"""
        Returns true if the computations are successful, otherwise returns false.

        Returns
        -------
        bool

        """
        return _math.math_Uzawa_IsDone(self, *args)

    def NbIterations(self, *args):
        r"""
        Returns the number of iterations really done. an exception is raised if notdone.

        Returns
        -------
        int

        """
        return _math.math_Uzawa_NbIterations(self, *args)

    def Value(self, *args):
        r"""
        Returns the vector solution of the system above. an exception is raised if notdone.

        Returns
        -------
        math_Vector

        """
        return _math.math_Uzawa_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_Uzawa

# Register math_Uzawa in _math:
_math.math_Uzawa_swigregister(math_Uzawa)
class math_ValueAndWeight(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        theValue: float
        theWeight: float

        Returns
        -------
        None

        """
        _math.math_ValueAndWeight_swiginit(self, _math.new_math_ValueAndWeight(*args))

    def Value(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _math.math_ValueAndWeight_Value(self, *args)

    def Weight(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        float

        """
        return _math.math_ValueAndWeight_Weight(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_ValueAndWeight

# Register math_ValueAndWeight in _math:
_math.math_ValueAndWeight_swigregister(math_ValueAndWeight)
class math_Vector(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructs a non-initialized vector in the range [thelower..theupper] 'thelower' and 'theupper' are the indexes of the lower and upper bounds of the constructed vector.

        Parameters
        ----------
        theLower: int
        theUpper: int

        Returns
        -------
        None
        Constructs a vector in the range [thelower..theupper] whose values are all initialized with the value 'theinitialvalue'.

        Parameters
        ----------
        theLower: int
        theUpper: int
        theInitialValue: float

        Returns
        -------
        None
        Constructs a vector in the range [thelower..theupper] with the 'c array' thetab.

        Parameters
        ----------
        theTab: float *
        theLower: int
        theUpper: int

        Returns
        -------
        None
        Constructor for converting gp_xy to math_vector.

        Parameters
        ----------
        Other: gp_XY

        Returns
        -------
        None
        Constructor for converting gp_xyz to math_vector.

        Parameters
        ----------
        Other: gp_XYZ

        Returns
        -------
        None
        Constructs a copy for initialization. an exception is raised if the lengths of the vectors are different.

        Parameters
        ----------
        theOther: math_Vector

        Returns
        -------
        None

        """
        _math.math_Vector_swiginit(self, _math.new_math_Vector(*args))

    def Add(self, *args):
        r"""
        Adds the vector 'theright' to a vector. an exception is raised if the vectors have not the same length. warning in order to avoid time-consuming copying of vectors, it is preferable to use operator += or the function add whenever possible.

        Parameters
        ----------
        theRight: math_Vector

        Returns
        -------
        None
        Sets a vector to the sum of the vector 'theleft' and the vector 'theright'. an exception is raised if the lengths are different.

        Parameters
        ----------
        theLeft: math_Vector
        theRight: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Vector_Add(self, *args)

    def Added(self, *args):
        r"""
        Adds the vector theright to a vector. an exception is raised if the vectors have not the same length. an exception is raised if the lengths are not equal.

        Parameters
        ----------
        theRight: math_Vector

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector_Added(self, *args)

    def Divide(self, *args):
        r"""
        Divides a vector by the value 'theright'. an exception is raised if 'theright' = 0.

        Parameters
        ----------
        theRight: float

        Returns
        -------
        None

        """
        return _math.math_Vector_Divide(self, *args)

    def Divided(self, *args):
        r"""
        Divides a vector by the value 'theright'. an exception is raised if 'theright' = 0.

        Parameters
        ----------
        theRight: float

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector_Divided(self, *args)

    def DumpToString(self):
        r"""DumpToString(math_Vector self) -> std::string"""
        return _math.math_Vector_DumpToString(self)

    def Init(self, *args):
        r"""
        Initialize all the elements of a vector with 'theinitialvalue'.

        Parameters
        ----------
        theInitialValue: float

        Returns
        -------
        None

        """
        return _math.math_Vector_Init(self, *args)

    def Initialized(self, *args):
        r"""
        Initialises a vector by copying 'theother'. an exception is raised if the lengths are different.

        Parameters
        ----------
        theOther: math_Vector

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector_Initialized(self, *args)

    def Inverse(self, *args):
        r"""
        Inverts this vector and creates a new vector.

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector_Inverse(self, *args)

    def Invert(self, *args):
        r"""
        Inverts this vector and assigns the result to this vector.

        Returns
        -------
        None

        """
        return _math.math_Vector_Invert(self, *args)

    def Length(self, *args):
        r"""
        Returns the length of a vector.

        Returns
        -------
        int

        """
        return _math.math_Vector_Length(self, *args)

    def Lower(self, *args):
        r"""
        Returns the value of the thelower index of a vector.

        Returns
        -------
        int

        """
        return _math.math_Vector_Lower(self, *args)

    def Max(self, *args):
        r"""
        Returns the value of the 'index' of the maximum element of a vector.

        Returns
        -------
        int

        """
        return _math.math_Vector_Max(self, *args)

    def Min(self, *args):
        r"""
        Returns the value of the 'index' of the minimum element of a vector.

        Returns
        -------
        int

        """
        return _math.math_Vector_Min(self, *args)

    def Multiplied(self, *args):
        r"""
        Returns the product of a vector and a real value.

        Parameters
        ----------
        theRight: float

        Returns
        -------
        math_Vector
        Returns the inner product of 2 vectors. an exception is raised if the lengths are not equal.

        Parameters
        ----------
        theRight: math_Vector

        Returns
        -------
        float
        Returns the product of a vector by a matrix.

        Parameters
        ----------
        theRight: math_Matrix

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector_Multiplied(self, *args)

    def Multiply(self, *args):
        r"""
        Returns the product of a vector and a real value.

        Parameters
        ----------
        theRight: float

        Returns
        -------
        None
        Sets a vector to the product of the vector 'theleft' with the matrix 'theright'.

        Parameters
        ----------
        theLeft: math_Vector
        theRight: math_Matrix

        Returns
        -------
        None
        //!sets a vector to the product of the matrix 'theleft' with the vector 'theright'.

        Parameters
        ----------
        theLeft: math_Matrix
        theRight: math_Vector

        Returns
        -------
        None
        Returns the multiplication of a real by a vector. 'me' = 'theleft' * 'theright'.

        Parameters
        ----------
        theLeft: float
        theRight: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Vector_Multiply(self, *args)

    def Norm(self, *args):
        r"""
        Returns the value or the square of the norm of this vector.

        Returns
        -------
        float

        """
        return _math.math_Vector_Norm(self, *args)

    def Norm2(self, *args):
        r"""
        Returns the value of the square of the norm of a vector.

        Returns
        -------
        float

        """
        return _math.math_Vector_Norm2(self, *args)

    def Normalize(self, *args):
        r"""
        Normalizes this vector (the norm of the result is equal to 1.0) and assigns the result to this vector exceptions standard_nullvalue if this vector is null (i.e. if its norm is less than or equal to standard_real::realepsilon().

        Returns
        -------
        None

        """
        return _math.math_Vector_Normalize(self, *args)

    def Normalized(self, *args):
        r"""
        Normalizes this vector (the norm of the result is equal to 1.0) and creates a new vector exceptions standard_nullvalue if this vector is null (i.e. if its norm is less than or equal to standard_real::realepsilon().

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector_Normalized(self, *args)

    def Opposite(self, *args):
        r"""
        Returns the opposite of a vector.

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector_Opposite(self, *args)

    def Set(self, *args):
        r"""
        Sets a vector from 'thei1' to 'thei2' to the vector 'thev'; an exception is raised if 'thei1' is less than 'lowerindex' or 'thei2' is greater than 'upperindex' or 'thei1' is greater than 'thei2'. an exception is raised if 'thei2-thei1+1' is different from the 'length' of 'thev'.

        Parameters
        ----------
        theI1: int
        theI2: int
        theV: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Vector_Set(self, *args)

    def Slice(self, *args):
        r"""
        //!creates a new vector by inverting the values of this vector between indexes 'thei1' and 'thei2'. if the values of this vector were (1., 2., 3., 4.,5., 6.), by slicing it between indexes 2 and 5 the values of the resulting vector are (1., 5., 4., 3., 2., 6.).

        Parameters
        ----------
        theI1: int
        theI2: int

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector_Slice(self, *args)

    def Subtract(self, *args):
        r"""
        Sets a vector to the subtraction of the vector theright from the vector theleft. an exception is raised if the vectors have not the same length. warning in order to avoid time-consuming copying of vectors, it is preferable to use operator -= or the function subtract whenever possible.

        Parameters
        ----------
        theLeft: math_Vector
        theRight: math_Vector

        Returns
        -------
        None
        Returns the subtraction of 'theright' from 'me'. an exception is raised if the vectors have not the same length.

        Parameters
        ----------
        theRight: math_Vector

        Returns
        -------
        None

        """
        return _math.math_Vector_Subtract(self, *args)

    def Subtracted(self, *args):
        r"""
        Returns the subtraction of 'theright' from 'me'. an exception is raised if the vectors have not the same length.

        Parameters
        ----------
        theRight: math_Vector

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector_Subtracted(self, *args)

    def TMultiplied(self, *args):
        r"""
        Returns the product of a vector and a real value.

        Parameters
        ----------
        theRight: float

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector_TMultiplied(self, *args)

    def TMultiply(self, *args):
        r"""
        Sets a vector to the product of the transpose of the matrix 'thetleft' by the vector 'theright'.

        Parameters
        ----------
        theTLeft: math_Matrix
        theRight: math_Vector

        Returns
        -------
        None
        Sets a vector to the product of the vector 'theleft' by the transpose of the matrix 'thetright'.

        Parameters
        ----------
        theLeft: math_Vector
        theTRight: math_Matrix

        Returns
        -------
        None

        """
        return _math.math_Vector_TMultiply(self, *args)

    def Upper(self, *args):
        r"""
        Returns the value of the theupper index of a vector.

        Returns
        -------
        int

        """
        return _math.math_Vector_Upper(self, *args)

    def Value(self, *args):
        r"""
        Accesses the value of index 'thenum' of a vector.

        Parameters
        ----------
        theNum: int

        Returns
        -------
        float

        """
        return _math.math_Vector_Value(self, *args)

    def GetValue(self, theNum):
        r"""GetValue(math_Vector self, Standard_Integer const theNum) -> Standard_Real"""
        return _math.math_Vector_GetValue(self, theNum)

    def SetValue(self, theNum, value):
        r"""SetValue(math_Vector self, Standard_Integer const theNum, Standard_Real value)"""
        return _math.math_Vector_SetValue(self, theNum, value)

    def __mul__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        theRight: float

        Returns
        -------
        math_Vector
        No available documentation.

        Parameters
        ----------
        theRight: math_Vector

        Returns
        -------
        float
        No available documentation.

        Parameters
        ----------
        theRight: math_Matrix

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector___mul__(self, *args)

    def __imul_wrapper__(self, other):
        r"""__imul_wrapper__(math_Vector self, Standard_Real const other)"""
        return _math.math_Vector___imul_wrapper__(self, other)

    def __imul__(self, right):
        self.__imul_wrapper__(right)
        return self


    def __add__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        theRight: math_Vector

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector___add__(self, *args)

    def __iadd_wrapper__(self, other):
        r"""__iadd_wrapper__(math_Vector self, math_Vector other)"""
        return _math.math_Vector___iadd_wrapper__(self, other)

    def __iadd__(self, right):
        self.__iadd_wrapper__(right)
        return self


    def __neg__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector___neg__(self, *args)

    def __sub__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        theRight: math_Vector

        Returns
        -------
        math_Vector

        """
        return _math.math_Vector___sub__(self, *args)

    def __isub_wrapper__(self, other):
        r"""__isub_wrapper__(math_Vector self, math_Vector other)"""
        return _math.math_Vector___isub_wrapper__(self, other)

    def __isub__(self, right):
        self.__isub_wrapper__(right)
        return self


    def __truediv__(self, *args):
        return _math.math_Vector___truediv__(self, *args)
    __div__ = __truediv__



    def __itruediv_wrapper__(self, other):
        r"""__itruediv_wrapper__(math_Vector self, Standard_Real const other)"""
        return _math.math_Vector___itruediv_wrapper__(self, other)

    def __itruediv__(self, right):
        self.__itruediv_wrapper__(right)
        return self


    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_Vector

# Register math_Vector in _math:
_math.math_Vector_swigregister(math_Vector)
class math_FunctionSetWithDerivatives(math_FunctionSet):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Derivatives(self, *args):
        r"""
        Returns the values <d> of the derivatives for the variable <x>. returns true if the computation was done successfully, false otherwise.

        Parameters
        ----------
        X: math_Vector
        D: math_Matrix

        Returns
        -------
        bool

        """
        return _math.math_FunctionSetWithDerivatives_Derivatives(self, *args)

    def Values(self, *args):
        r"""
        Returns the values <f> of the functions and the derivatives <d> for the variable <x>. returns true if the computation was done successfully, false otherwise.

        Parameters
        ----------
        X: math_Vector
        F: math_Vector
        D: math_Matrix

        Returns
        -------
        bool

        """
        return _math.math_FunctionSetWithDerivatives_Values(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_FunctionSetWithDerivatives

# Register math_FunctionSetWithDerivatives in _math:
_math.math_FunctionSetWithDerivatives_swigregister(math_FunctionSetWithDerivatives)
class math_FunctionWithDerivative(math_Function):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Derivative(self, *args):
        r"""
        Computes the derivative <d> of the function for the variable <x>. returns true if the calculation were successfully done, false otherwise.

        Parameters
        ----------
        X: float

        Returns
        -------
        D: float

        """
        return _math.math_FunctionWithDerivative_Derivative(self, *args)

    def Values(self, *args):
        r"""
        Computes the value <f> and the derivative <d> of the function for the variable <x>. returns true if the calculation were successfully done, false otherwise.

        Parameters
        ----------
        X: float

        Returns
        -------
        F: float
        D: float

        """
        return _math.math_FunctionWithDerivative_Values(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_FunctionWithDerivative

# Register math_FunctionWithDerivative in _math:
_math.math_FunctionWithDerivative_swigregister(math_FunctionWithDerivative)
class math_MultipleVarFunctionWithGradient(math_MultipleVarFunction):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Gradient(self, *args):
        r"""
        Computes the gradient <g> of the functions for the variable <x>. returns true if the computation was done successfully, false otherwise.

        Parameters
        ----------
        X: math_Vector
        G: math_Vector

        Returns
        -------
        bool

        """
        return _math.math_MultipleVarFunctionWithGradient_Gradient(self, *args)

    def Values(self, *args):
        r"""
        Computes the value <f> and the gradient <g> of the functions for the variable <x>. returns true if the computation was done successfully, false otherwise.

        Parameters
        ----------
        X: math_Vector
        G: math_Vector

        Returns
        -------
        F: float

        """
        return _math.math_MultipleVarFunctionWithGradient_Values(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_MultipleVarFunctionWithGradient

# Register math_MultipleVarFunctionWithGradient in _math:
_math.math_MultipleVarFunctionWithGradient_swigregister(math_MultipleVarFunctionWithGradient)
class math_MultipleVarFunctionWithHessian(math_MultipleVarFunctionWithGradient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Values(self, *args):
        r"""
        Computes the value <f> and the gradient <g> of the functions for the variable <x>. returns true if the computation was done successfully, false otherwise.

        Parameters
        ----------
        X: math_Vector
        G: math_Vector

        Returns
        -------
        F: float
        Computes the value <f>, the gradient <g> and the hessian <h> of the functions for the variable <x>. returns true if the computation was done successfully, false otherwise.

        Parameters
        ----------
        X: math_Vector
        G: math_Vector
        H: math_Matrix

        Returns
        -------
        F: float

        """
        return _math.math_MultipleVarFunctionWithHessian_Values(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_MultipleVarFunctionWithHessian

# Register math_MultipleVarFunctionWithHessian in _math:
_math.math_MultipleVarFunctionWithHessian_swigregister(math_MultipleVarFunctionWithHessian)
class math_TrigonometricEquationFunction(math_FunctionWithDerivative):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Parameters
        ----------
        A: float
        B: float
        C: float
        D: float
        E: float

        Returns
        -------
        None

        """
        _math.math_TrigonometricEquationFunction_swiginit(self, _math.new_math_TrigonometricEquationFunction(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _math.delete_math_TrigonometricEquationFunction

# Register math_TrigonometricEquationFunction in _math:
_math.math_TrigonometricEquationFunction_swigregister(math_TrigonometricEquationFunction)



